(function($){
    const dfMenu = {
        body: $('body'),
        settingsModal: $('.df-menu-item-settings'),
        settingsModalWrap: $('.df-settings-container'),
        iconModal: $('.df-icon-select-wrap'),
        modalTitle: $('.modal-title'),
        init: function() {
            this.getDashboardSettings();
            this.addEditButton();
            this.openSettingsModal();
            this.addSettingsButton();
        },
        addEditButton: function() {
            $('#menu-to-edit > .menu-item').each(function(index, value){
                var item = $(this).find('.menu-item-bar .menu-item-checkbox');
                var title = $(this).find('.menu-item-title')[0].innerHTML;
                var isSubmenu = $(this).hasClass('menu-item-depth-0') ? '0' : '1';
                var menuTitle = $('#nav-menu-header #menu-name').val();
                var depthClass = $(this).attr("class").split(" ").filter(function(class_name){
                    return class_name.indexOf('item-depth') !== -1;
                });
                $(this).find('.menu-item-bar .item-title')
                .append(`<button data-submenu="${isSubmenu}" 
                data-depth="${depthClass}"
                data-menu-item-id="${item[0].dataset.menuItemId}" 
                data-menu-title="${menuTitle}"
                class="df-menu-edit" data-menu-item-title="${title}">Edit Menu</button>`);
            })
        },
        openSettingsModal: function() {
            dfMenu.body.on('click', '.df-menu-edit', function(ev){
                ev.preventDefault();
                $('#df-menu-dashboard').toggleClass('show');
                $('body').css('overflow', 'hidden');
            });
        },
        addSettingsButton: function() {
            $('#nav-menu-header .major-publishing-actions').append(`<div class="df-settings-btn-wrap">
            <button class="df-switch">
            <span class="slider"></span>
            </button> Enable/Disable DiviFlash menu settings.
            <span class="df-menu-db-info">
            <span class="df-menu-db-info-icon">p</span>
            <span class="df-menu-db-info-box">If you don't see the "Edit Menu" after enable,
            Please save the menu.</span></span></div>`);
            
            $('.df-switch').on('click', function(ev){
                ev.preventDefault();
                $(this).toggleClass('active');
            })
        },
        getDashboardSettings: function() {
            var menuId = $('#menu').val();

            window.wp.apiFetch({
                path: '/df-menu-settings/v2/df-am-option-edit',
                method: 'POST',
                data: {
                    id: menuId                
                }
            }).then((res) => {
                // console.log(res);
                $('.df-switch')[0].dataset.enable = res === 'on' ? 'on' : 'off';
                if(res == 'on') {
                    $('.df-switch').addClass('active');
                    $('.df-menu-edit').css('display', 'block');
                } else { $('.df-menu-edit').css('display', 'none'); }
            });

            $('body').on('click', '.df-switch', function(ev) {
                var $this = $(this);
                var _opt = ev.currentTarget.dataset.enable ? ev.currentTarget.dataset.enable : 'off';
                $this.css('pointer-events', 'none');
                if(_opt == 'on') {
                    $this.removeClass('active');
                    $('.df-menu-edit').css('display', 'none');
                } else { 
                    $this.addClass('active');
                    $('.df-menu-edit').css('display', 'block'); 
                }

                dfMenu.setDashboardSetting(menuId, _opt);
            })
        },
        setDashboardSetting: function (menuId, _opt) {
            window.wp.apiFetch({
                path: '/df-menu-settings/v2/df-am-option-edit-set',
                method: 'POST',
                data: {
                    id: menuId,
                    _opt: _opt            
                }
            }).then((res) => {
                // console.log(res);
                $('.df-switch')[0].dataset.enable = res === 'on' ? 'on' : 'off';
                $('.df-switch').css('pointer-events', 'all');
            });
        }
        
    }
    dfMenu.init();

})( jQuery );