<?php

trait Df_Acf_Data_Process {

    /**
     * Store all the custom post type
     * in array
     */
    public $df_acf_cpt_list = array(
        'select'    => 'Select post type'
    );
    /**
     * Store the dashboard extension value
     * this will depend on dashboard settings
     * 
     */
    public $acf_extension;
    /**
     * Store all acf fields for each cpt
     * 
     */
    public $df_acf_fields = array();

    /**
     * Initialize the acf support for
     * dynamic modules
     *  
     */
    public function df_acf_init($post_include = false) {
        $this->acf_extension = get_option('df_general_acf_field_support') === '1' ? 'on' : 'off';
        if( $this->acf_extension != 'on' ) return;
        if( !class_exists('ACF') ) return;
        if(!$post_include){
            $this->df_acf_cpt_list = array_merge(
                $this->df_acf_cpt_list, 
                df_get_registered_post_type_options(false, false)
            );
        }else{
            $this->df_acf_cpt_list = array_merge(
                $this->df_acf_cpt_list, 
                df_get_registered_post_type_options(false, false , true)
            );  
        }
      

        //$this->df_acf_cpt_list = array('post');
        $this->df_get_all_acf_fields();
    }

    /**
     * Get all fields for post types
     * 
     * @param String | $post_type
     */
    public function df_get_all_acf_fields() {
        $fields_storage = Df_Acf_Fields::getInstance();

        foreach($fields_storage->acf_fields_storage as $post_type=>$options) {
            $this->df_acf_fields[$post_type] = $this->add_settings_with_acf_fields($post_type,$options);
        }
    }

    /**
     * Acf Fields settings for module
     * 
     * @param String $post_type
     * @param Array $options
     * @return Array
     */
    public function add_settings_with_acf_fields($post_type, $options){
        $options = array_merge(array('df_select_option' => ' '), $options);

        $df_acf_settings = array(
            'label'             => esc_html__('Select Acf Field', 'divi_flash'),
            'type'              => 'select',
            'options'           => $options,
            'default'           => 'select_option',
            'tab_slug'          => 'general',
            'toggle_slug'       => 'settings',
            'show_if'           => array(
                'post_type_for_acf'  => $post_type,
                'type'               => 'acf_fields'
            )
        );
        
        return $df_acf_settings;
    }

}