<?php
/**
 * ImageGallery: Return Options for Gallery
 *
 * @return $options
 */
function df_ig_options($iamges, $object) {
	$options = array(
		'show_caption' => $object['show_caption'],
		'show_description' => $object['show_description'],
		'image_size' => $object['image_size'],
		'filter_nav' => $object['filter_nav'],
		'layout_mode' => $object['layout_mode'],
		'load_more' => $object['load_more'],
		'init_count' => $object['init_count'],
		'image_count' => $object['image_count'],
		'use_lightbox' => isset($object['use_lightbox']) ? $object['use_lightbox'] : 'off',
		'use_lightbox_content' => isset($object['use_lightbox_content']) ? $object['use_lightbox_content'] : 'off',
		'use_lightbox_download' => isset($object['use_lightbox_download']) ? $object['use_lightbox_download'] : 'off',
		'caption_tag' => $object['caption_tag'],
		'description_tag' => $object['description_tag'],
		'image_scale' => $object['image_scale'],
		'content_position' => $object['content_position'],
		'content_reveal_caption' => $object['content_reveal_caption'],
		'content_reveal_description' => $object['content_reveal_description'],
		'border_anim' => $object['border_anim'],
		'border_anm_style' => $object['border_anm_style'],
		'always_show_title' => $object['always_show_title'],
		'always_show_description' => $object['always_show_description'],
		'use_url' =>isset($object['use_url']) ? $object['use_url'] : 'off',
		'url_target' => isset($object['url_target']) ? $object['url_target'] : 'same_window',
		'overlay' => $object['overlay'],
	);
	return array_merge($iamges, $options);
}

/**
 * ImageGallery: Request from Gallery VB
 *
 * @return response | JSON
 */
add_action('wp_ajax_df_image_gallery', 'df_image_gallery');
function df_image_gallery() {
	// create the display gallery code
	$data = json_decode(file_get_contents('php://input'), true);
	if (! wp_verify_nonce( $data['et_admin_load_nonce'], 'et_admin_load_nonce' )) {
		wp_die();
	}

	$_objects = json_decode($data['images']);
	$images_array = [];
	foreach($_objects as $_object) {
		$title = isset($_object->gallery_title) && $_object->gallery_title !== '' ?
			$_object->gallery_title : '';
		$category = isset($_object->gallery_title) && $_object->gallery_title !== '' ?
			strtolower(preg_replace('/[^A-Za-z0-9-]/', "-", $_object->gallery_title)) : '';
		$ids = array();
		if(property_exists($_object, 'gallery_ids')){ // version 1.1.5 change from array_key_exists('gallery_ids', $_object)
			$ids = explode( ',', $_object->gallery_ids);
		}
		foreach($ids as $id) {
			$images_array[$id][] = $category;
		}
	}

	/**
	 * image order
	 */
	if($data['use_image_order'] == 'on') {
		if($data['image_order'] == '' || $data['image_order'] == 'random') {
			$images_array = df_shuffle_assoc($images_array);
		} else if($data['image_order'] == 'asc') {
			ksort($images_array);
		} else if($data['image_order'] == 'desc') {
			krsort($images_array);
		}
	}

	$options = df_ig_options(
		array('images_array' => $images_array),
		$data
	);

	$gallery = df_ig_render_images( $options );

	wp_send_json_success($gallery);
}

function df_display_galler_load_actions( $actions ) {
	$actions[] = 'df_image_gallery';

	return $actions;
}
add_filter( 'et_builder_load_actions', 'df_display_galler_load_actions' );

/**
 * ImageGallery: Load More image with Fetch
 *
 * @return json response
 */
add_action('wp_ajax_df_image_gallery_fetch', 'df_image_gallery_more_image');
add_action('wp_ajax_nopriv_df_image_gallery_fetch', 'df_image_gallery_more_image');
function df_image_gallery_more_image() {

	if (isset($_POST['et_frontend_nonce']) && !wp_verify_nonce( sanitize_text_field($_POST['et_frontend_nonce']), 'et_frontend_nonce' )) {
		wp_die();
	}

	$settings = isset($_POST["options"]) ? json_decode(stripslashes(sanitize_text_field($_POST["options"])), true) : '';
	$data = isset($_POST['images']) ? sanitize_text_field($_POST['images']) : '';
	$page = isset($_POST['page']) ? sanitize_text_field($_POST['page']) : '';
	$image_count = isset($_POST['image_count']) ? sanitize_text_field($_POST['image_count']) : '';
	$loaded = isset($_POST['loaded']) ? sanitize_text_field($_POST['loaded']) : '';
	$images_array = explode(',', $data);
	$images_array = array_unique($images_array);
	$images_array = array_slice($images_array, $loaded, $image_count);

	$options = df_ig_options(
		array('images_array' => $images_array),
		$settings
	);
	$images = df_ig_render_images( $options, true );

	wp_send_json_success($images);
}

add_action('wp_ajax_df_image_gallery_category_data_fetch', 'df_image_gallery_category_data_fetch');
add_action('wp_ajax_nopriv_df_image_gallery_category_data_fetch', 'df_image_gallery_category_data_fetch');
function df_image_gallery_category_data_fetch() {
	if (isset($_POST['et_frontend_nonce']) && !wp_verify_nonce( sanitize_text_field($_POST['et_frontend_nonce']), 'et_frontend_nonce' )) {
		wp_die();
	}

	$tax_ids = isset($_POST['tax_ids']) ? sanitize_text_field($_POST['tax_ids']) : '';
	$tax_array = explode(',', $tax_ids);
	$tax_array = array_unique($tax_array);
	$images = "";
	$request_data = [];
	$titles = [];
	foreach ($tax_array as $tax_id) {
		$tax_id = str_replace(['+', '-'], '', filter_var($tax_id, FILTER_SANITIZE_NUMBER_INT));
		$args = array(
			'post_type'      => 'attachment',
			'post_status'    => 'inherit',
			'tax_query'      => array(
				array(
					'taxonomy' => DiviFlash_Media_Category::TAXONOMY,
					'field'    => 'term_id',
					'terms'    => $tax_id,
				),
			),
		);
		$media_items = get_posts($args);
		if ($media_items) {
			$gallery_title = get_term($tax_id, DiviFlash_Media_Category::TAXONOMY)->name;
			$titles[strtolower(str_replace(' ', '-', $gallery_title))] = $gallery_title;
			$gallery_ids = "";
			foreach ($media_items as $media_item) {
				$gallery_ids = $gallery_ids.$media_item->ID.",";
				$images = $images.$media_item->ID.",";
			}
		}
		$gallery_title = isset($gallery_title) ? $gallery_title: "";
		$gallery_ids = isset($gallery_ids) ? $gallery_ids : "";
		$request_data[] = [ "gallery_title" => $gallery_title, "gallery_ids" => rtrim($gallery_ids, ',') ];
	}
	wp_send_json_success(["images" => $images, "request_data" => $request_data, "titles" => $titles]);
}

/**
 * ImageGallery: Image markup for gallery
 *
 * @param $options array
 * @param $load_more_type boolean, whether it is load more request or not
 * @return $images | HTML Markup
 */
function df_ig_render_images( $options=[], $load_more_type = false ) {

	$default = array(
		'images_array' => [],
		'show_caption' => 'off',
		'show_description' => 'off',
		'image_size' => 'medium',
		'filter_nav' => 'off',
		'load_more' => 'off',
		'init_count' => 6,
		'image_count' => 3,
		'use_lightbox' => 'off',
		'use_lightbox_content' => 'off',
		'caption_tag' => '',
		'description_tag' => '',
		'image_scale' => '',
		'content_position' => '',
		'content_reveal_caption' => '',
		'content_reveal_description' => '',
		'border_anim' => 'off',
		'border_anm_style' => '',
		'always_show_title' => '',
		'always_show_description' => '',
		'use_url' => 'off',
		'url_target' => 'same_window',
		'overlay' => ''
	);

	$default_image = 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTA4MCIgaGVpZ2h0PSI1NDAiIHZpZXdCb3g9IjAgMCAxMDgwIDU0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KICAgIDxnIGZpbGw9Im5vbmUiIGZpbGwtcnVsZT0iZXZlbm9kZCI+CiAgICAgICAgPHBhdGggZmlsbD0iI0VCRUJFQiIgZD0iTTAgMGgxMDgwdjU0MEgweiIvPgogICAgICAgIDxwYXRoIGQ9Ik00NDUuNjQ5IDU0MGgtOTguOTk1TDE0NC42NDkgMzM3Ljk5NSAwIDQ4Mi42NDR2LTk4Ljk5NWwxMTYuMzY1LTExNi4zNjVjMTUuNjItMTUuNjIgNDAuOTQ3LTE1LjYyIDU2LjU2OCAwTDQ0NS42NSA1NDB6IiBmaWxsLW9wYWNpdHk9Ii4xIiBmaWxsPSIjMDAwIiBmaWxsLXJ1bGU9Im5vbnplcm8iLz4KICAgICAgICA8Y2lyY2xlIGZpbGwtb3BhY2l0eT0iLjA1IiBmaWxsPSIjMDAwIiBjeD0iMzMxIiBjeT0iMTQ4IiByPSI3MCIvPgogICAgICAgIDxwYXRoIGQ9Ik0xMDgwIDM3OXYxMTMuMTM3TDcyOC4xNjIgMTQwLjMgMzI4LjQ2MiA1NDBIMjE1LjMyNEw2OTkuODc4IDU1LjQ0NmMxNS42Mi0xNS42MiA0MC45NDgtMTUuNjIgNTYuNTY4IDBMMTA4MCAzNzl6IiBmaWxsLW9wYWNpdHk9Ii4yIiBmaWxsPSIjMDAwIiBmaWxsLXJ1bGU9Im5vbnplcm8iLz4KICAgIDwvZz4KPC9zdmc+Cg==';

	$options = wp_parse_args($options, $default);
	extract($options); // phpcs:ignore WordPress.PHP.DontExtract
	$images = '';
	$classes = '';
	$_i = 0;

	if ( $load_more_type === true ) {
		$images_array = array_flip($images_array);
	}

	$always_title = $always_show_title === 'on' ?
		'always-show-title c4-fade-up' : $content_reveal_caption;
	$always_description = $always_show_description === 'on' ?
		'always-show-description c4-fade-up' : $content_reveal_description;

	$border_anim_class = $border_anim === 'on' ? $border_anm_style : '';

	foreach( $images_array as $id => $value ) {
		if ($load_more === 'on' && $filter_nav !== 'on') {
			if ($_i >= $init_count && $load_more_type === false) {
				break;
			}
		}
		$_i++;
		$media = wp_get_attachment_image_src($id, $image_size);
		$media_lightbox = wp_get_attachment_image_src($id, 'original');
		$lightbox_image_url = $media_lightbox != '' && !is_bool($media_lightbox) ? $media_lightbox[0] : $default_image;

		$content_box = '';

		$details = $id !== '' ? get_post($id) : "";
		$caption = '';
		$description = '';
		if(('on' == $use_lightbox_content || 'on' == $show_caption) && $details){
			$caption = $details->post_excerpt !== ''?
				sprintf('<div class="%3$s %4$s"><%2$s class="df_ig_caption">%1$s</%2$s></div>',
					wp_kses_post($details->post_excerpt, 'divi_flash'),
					esc_attr($caption_tag),
					esc_attr($always_title),
					esc_attr($show_caption !='on' ? 'df-hide-title' : '')
				) : '';
		}
		if(('on' == $use_lightbox_content || 'on' == $show_description) && $details) {
			$description = $details->post_content !== ''?
				sprintf('<div class="%3$s %4$s"><%2$s class="df_ig_description">%1$s</%2$s></div>',
					wp_kses_post($details->post_content, 'divi_flash'),
					esc_attr($description_tag),
					esc_attr($always_description),
					esc_attr($show_description !='on' ? 'df-hide-description' : '')
				) : '';
		}

		$content_box = sprintf('%1$s%2$s', $caption, $description);

		$data_lightbox_html = $use_lightbox_content === 'on' && $content_box !== '' ?
			'data-sub-html=".df_ig_content"' : '';

		if ( $load_more_type === false ) {
			$classes = implode(" ", $value);
		}

		$custom_url = $use_url === 'on' ?
			sprintf('data-url="%1$s"', esc_attr(get_post_meta( $id, 'df_ig_url', true )))
			: '';

		$empty_class = $content_box === '' ? ' empty_content' : '';

		if(empty($media[0])) continue;
		$image_url = !empty($media[0]) ? $media[0] : $default_image;

		// Lightbox Caption : https://sachinchoolur.github.io/lightgallery.js/demos/captions.html
		$image = sprintf('<div class="df_ig_image grid-item %3$s" data-src="%8$s" %4$s>
                <div class="item-content %5$s" %10$s>
                    <figure class="%7$s c4-izmir %9$s">
                        %13$s
                        <img class="ig-image" src="%1$s" alt="%12$s" class=""/>
                        <figcaption class="df_ig_content %6$s %11$s">
                            %2$s
                        </figcaption>
                    </figure>
                </div>
            </div>',
			esc_attr($image_url),
			$content_box,
			esc_attr($classes),
			$data_lightbox_html,
			esc_attr($image_scale),
			esc_attr($content_position),
			esc_attr($border_anim_class),
			esc_attr($lightbox_image_url),
			esc_attr(' has_overlay'),
			$custom_url,
			esc_attr($empty_class),
			esc_attr(get_post_meta($id , '_wp_attachment_image_alt', true)),
			$overlay === 'on' ? '<span class="df-overlay"></span>' : ''
		// esc_attr($media[1]), // width
		// esc_attr($media[2]) // height
		);
		$images .= $image;
	}
	return $images;
}
/**
 * Suffle an associative array in random order
 *
 */
function df_shuffle_assoc($my_array) {
	$keys = array_keys($my_array);

	shuffle($keys);

	foreach($keys as $key) {
		$new[$key] = $my_array[$key];
	}

	$my_array = $new;

	return $my_array;
}