<?php
/*
Plugin Name: Divi BodyCommerce
Plugin URL: https://diviengine.com/product/divi-bodycommerce/
Description: Divi BodyCommerce is a dynamic toolkit for people that use Divi and WooCommerce together. It empowers you to build beautiful e-commerce websites that look unique and custom built
Version: 8.1.7.3
WC tested up to: 7.3.0
Author: Divi Engine
Author URI: https://diviengine.com
License:     GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: divi-bodyshop-woocommerce
Domain Path: /languages
@author      diviengine.com
@copyright   2019 diviengine.com

I pray that you bless the people who interact and who own this website - I pray the blessing to be one that goes beyond worldly treasures but understanding the deep love you have for them.

John 14:6
I am the way, and the truth, and the life. No one comes to the Father except through me.
*/


if (! defined('ABSPATH')) exit;

define('DE_DB_WOO_VERSION', '8.1.7.3');

define('DE_DB_AUTHOR', 'Divi Engine');
define('DE_DB_WOO_PATH',   plugin_dir_path(__FILE__));
define('DE_DB_WOO_URL',    plugins_url('', __FILE__));
define('DE_DB_WOO_PRODUCT_ID', 'WP-DE-DB-WOO');
define('DE_DB_WOO_INSTANCE', str_replace(array ("https://" , "http://"), "", home_url()));
define('DE_DB_PRODUCT_URL', 'https://diviengine.com/product/divi-bodycommerce/');
define('DE_DB_WOO_APP_API_URL', 'https://diviengine.com/index.php');
define('DE_DB_URL', 'https://www.diviengine.com');
define('DE_DB_WOO_NAME',plugin_basename( __FILE__ ));
define('DE_DB_P', 'd_e');

include_once('titan-framework/titan-framework-embedder.php');

require_once dirname( __FILE__ ) .'/functions.php';
require_once dirname( __FILE__ ) .'/lib/features/other-woo-options.php';
require_once dirname( __FILE__ ) .'/lib/features/sharing-icons.php';
require_once dirname( __FILE__ ) .'/lib/features/checkout-fields.php';
require_once dirname( __FILE__ ) .'/lib/features/custom-tabs.php';
require_once dirname( __FILE__ ) .'/lib/features/custom-css-js.php';


if (get_bodycommerce_option('enable_cart_custom_icon') !== "1" && get_bodycommerce_option('enable_minicart') !== "1") {
} else {
    require_once dirname( __FILE__ ) .'/lib/features/cart-minicart/minicart-settings.php';
    require_once dirname( __FILE__ ) .'/lib/features/cart-minicart/custom-cart-css.php';
    require_once dirname( __FILE__ ) .'/lib/features/cart-minicart/popup-minicart.php';
    require_once dirname( __FILE__ ) .'/lib/features/cart-minicart/cart.php';
    require_once dirname( __FILE__ ) .'/lib/features/cart-minicart/minicart-slide.php';
    require_once dirname( __FILE__ ) .'/lib/features/cart-minicart/minicart-default.php';
    require_once dirname( __FILE__ ) .'/lib/features/cart-minicart/minicart.php';
    require_once dirname( __FILE__ ) .'/lib/features/cart-minicart/build.php';
}

if (get_bodycommerce_option('wishlist_enable') == "1" || get_bodycommerce_option('compare_enable') == "1") {
    // require_once dirname( __FILE__ ) .'/lib/features/wishlist/build.php';
    add_action('wp_footer', 'footer_bc_js_wishlist');
}
require_once dirname( __FILE__ ) .'/lib/features/checkout-funnel/checkout-order-bump.php';
require_once dirname( __FILE__ ) .'/lib/features/ajax-add-to-cart.php';


require_once dirname( __FILE__ ) .'/includes/ajaxcalls/stockstatus_ajax.php';
require_once dirname( __FILE__ ) .'/includes/ajaxcalls/wishlist.php';
// require_once dirname( __FILE__ ) .'/includes/ajaxcalls/cookie.php';
require_once dirname( __FILE__ ) .'/includes/ajaxcalls/ajax_minicart.php';



require_once dirname( __FILE__ ) .'/lib/custom-post.php';

include(DE_DB_WOO_PATH . '/includes/classes/class-wvs-term-meta.php');

include(DE_DB_WOO_PATH . '/includes/admin-notices.php');

include(DE_DB_WOO_PATH . '/includes/classes/class.wooslt.php');
include(DE_DB_WOO_PATH . '/includes/classes/class.licence.php');
include(DE_DB_WOO_PATH . '/includes/classes/class.options.php');
include(DE_DB_WOO_PATH . '/includes/classes/class.updater.php');


include(DE_DB_WOO_PATH . '/includes/classes/init.class.php');
include(DE_DB_WOO_PATH . '/includes/shortcodes/shortcodes.php');
include(DE_DB_WOO_PATH . '/includes/shortcodes/builder-shortcodes.php');


/**
 * Check if WooCommerce is installed.
 *
 * @see    Woocommerce_Bc_Missing_Wc_notice
 * @return void
 */
function Woocommerce_Bc_Missing_Wc_notice() {
    echo '<div class="error"><p><strong>' . sprintf(esc_html__('Divi BodyCommerce requires WooCommerce to be installed and active. You can download %s here.', 'divi-bodyshop-woocommerce'), '<a href="https://woocommerce.com/" target="_blank">WooCommerce</a>') . '</strong></p></div>';
}


/**
 * Display WooCommerce Missing Notice.
 *
 * @see    function Woocommerce_Gateway_Bc_Checkwoo_init
 * @return void
 */
function Woocommerce_Gateway_Bc_Checkwoo_init() {
    if (! class_exists('WooCommerce')) {
        add_action('admin_notices', 'Woocommerce_Bc_Missing_Wc_notice');
        return;
    }
}
add_action('plugins_loaded', 'Woocommerce_Gateway_Bc_Checkwoo_init');

if ( !function_exists('bodycommerce_load_actions_ajax')) {
    function bodycommerce_load_actions_ajax( $actions ) {
        $actions[] = 'divi_filter_ajax_handler';
        $actions[] = 'divi_filter_get_post_modal_ajax_handler';
        $actions[] = 'divi_filter_get_count_ajax_handler';
        $actions[] = 'divi_filter_get_sub_category_handler';
        $actions[] = 'divi_filter_loadmore_ajax_handler';
        $actions[] = 'divi_bodycommerce_get_cart_count_ajax_handler';
        $actions[] = 'divi_bodycommerce_get_stock_staus_ajax_handler';
        $actions[] = 'divi_bodycommerce_wishlist_ajax_handler';


        return $actions;
    }

    add_filter( 'et_builder_load_actions', 'bodycommerce_load_actions_ajax' );  
    add_filter( 'wcml_multi_currency_ajax_actions', 'bodycommerce_load_actions_ajax', 10, 1 );
}

/**
 * Adds Divi Builder to the Order Bump.
 *
 * @see    function Divi_Bodycommerce_Builder_Post_types
 * @return void
 */
function Divi_Bodycommerce_Builder_Post_types( $post_types ) {
    $post_types[] = 'bc_orderbump';

    return $post_types;
}
add_filter('et_builder_third_party_post_types', 'Divi_Bodycommerce_Builder_Post_types');

/**
 * Flushed permalinks on activation.
 *
 * @see    function Bodycommerce_Activate_hook
 * @return void
 */
function Bodycommerce_Activate_Deactivate_hook() {
    add_action( 'shutdown', 'BodyCommerce_Flush_Rewrite_Rules' );
}
register_activation_hook( __FILE__, 'Bodycommerce_Activate_Deactivate_hook' );
register_deactivation_hook( __FILE__, 'Bodycommerce_Activate_Deactivate_hook' );

function BodyCommerce_Flush_Rewrite_Rules() {
    update_option( 'rewrite_rules', '' );
}




if ( get_bodycommerce_option('settings_remove_french_translation') != '' ) {
    if (get_bodycommerce_option('settings_remove_french_translation') == "1") {} 
    else {
        function bodycommerce_load_languages() {
            load_plugin_textdomain( 'divi-bodyshop-woocommerce', false, basename( dirname( __FILE__ ) ) . '/languages' );
            load_plugin_textdomain( 'titan-framework', false, basename( dirname( __FILE__ ) ) . '/titan-framework/languages' );
        }
        add_action( 'plugins_loaded', 'bodycommerce_load_languages' );
    }
} else {
    function bodycommerce_load_languages() {
        load_plugin_textdomain( 'divi-bodyshop-woocommerce', false, basename( dirname( __FILE__ ) ) . '/languages' );
        load_plugin_textdomain( 'titan-framework', false, basename( dirname( __FILE__ ) ) . '/titan-framework/languages' );
    }
    add_action( 'plugins_loaded', 'bodycommerce_load_languages' );
}

function dbc_get_theme_details(){
    $theme = wp_get_theme(get_template());
    if( !defined( 'DIVIENGINE_BC_THEME_NAME' ) ){
        define( 'DIVIENGINE_BC_THEME_NAME', strtolower($theme->Name) );
    }
}
dbc_get_theme_details();





$check_enable_variation_swatches = get_bodycommerce_option('enable_variation_swatches');

if ($check_enable_variation_swatches != "0" && $check_enable_variation_swatches != "") {
    require_once dirname( __FILE__ ) .'/lib/features/variation-swatches.php';
}


$enable_custom_pagination_check = get_bodycommerce_option('enable_custom_pagination');

if ($enable_custom_pagination_check == "1") {
    require_once dirname( __FILE__ ) .'/lib/features/pagination.php';
}

$check_settings_disable_checkout_head_css = get_bodycommerce_option('settings_disable_checkout_head_css');

if ($check_settings_disable_checkout_head_css == "0" || $check_settings_disable_checkout_head_css == "") {
    require_once dirname( __FILE__ ) .'/lib/features/checkout.php';
}


// initialise Divi Modules
if ( !function_exists( 'de_bc_initialise_ext' ) ) {
    function de_bc_initialise_ext()
    {
        require_once plugin_dir_path( __FILE__ ) . 'includes/DEBodyCommerce.php';
    }
    add_action( 'divi_extensions_init', 'de_bc_initialise_ext' );
}



////////////////////////////////////////////////




////////////////////////////////////////////////

// CHECKOUT



remove_action('woocommerce_before_checkout_form','woocommerce_checkout_login_form',10);
remove_action('woocommerce_before_checkout_form','woocommerce_checkout_coupon_form',10);

remove_action('woocommerce_checkout_order_review','woocommerce_order_review',10);
remove_action('woocommerce_checkout_order_review','woocommerce_checkout_payment',20);

add_action('bodycommerce_before_checkout_login_form','woocommerce_checkout_login_form',10);
add_action('bodycommerce_before_checkout_coupon_form','woocommerce_checkout_coupon_form',10);

add_action( 'bodycommerce_checkout_order_review', 'woocommerce_order_review', 10 );
add_action( 'bodycommerce_checkout_order_payment', 'woocommerce_checkout_payment', 20 );


function bodycommerce_multi_step_checkout_script() {
    if ( ! is_admin() ) {
        echo '<script type="text/javascript">
            var bc_count_ajax_called = false;
          </script>';
    }
}

add_action('wp_head','bodycommerce_multi_step_checkout_script');



function bodycomerce_enqueue_styles_frontend() {

    $settings_disable_gallery_js_file = get_bodycommerce_option('settings_disable_gallery_js_file');

    if ( $settings_disable_gallery_js_file != "1"){ 
  
        if ( function_exists( 'is_woocommerce' ) ) {
          if ( is_single() ) {
              wp_enqueue_style( 'bc-venobox', DE_DB_WOO_URL . '/css/venobox.css' , array(), DE_DB_WOO_VERSION, 'all' );
          }
        }
    }

    $is_visual_builder = isset( $_GET['et_fb'] );

    if ($is_visual_builder) {
    wp_enqueue_script( 'bc-temp-builder-bundle', DE_DB_WOO_URL . '/js/builder-bundle.min.js' , array(), DE_DB_WOO_VERSION, 'all' );
    }

    
    wp_enqueue_style( 'bc-style-old', DE_DB_WOO_URL . '/css/style.min.css' , array(), DE_DB_WOO_VERSION, 'all' );

}
add_action( 'wp_enqueue_scripts', 'bodycomerce_enqueue_styles_frontend', 999999999 );

//////////////////////////////////////////////






add_filter( 'woocommerce_locate_template', 'bodycommerce_woo_templates', 1, 3 );
function bodycommerce_woo_templates( $template, $template_name, $template_path ) {
  if ( $template_path != 'woocommerce-shipment-tracking/' && $template_path == 'woocommerce/' ) {

    global $woocommerce;
    
    $my_acount_page_nav_layout = get_bodycommerce_option( 'my_acount_page_nav_layout' );

    if ($template_name == 'myaccount/my-account.php' && $my_acount_page_nav_layout == '') {

    } else {

        $_template = $template;
    
        if ( ! $template_path )
        $template_path = $woocommerce->template_url;
    
        $plugin_path  = untrailingslashit( plugin_dir_path( __FILE__ ) )  . '/includes/templates/woocommerce/';
        // Look within passed path within the theme - this is priority
        $check_template = locate_template(
            array(
                $template_path . $template_name,
                $template_name
                )
            );
        
        if( ! $check_template && file_exists( $plugin_path . $template_name ) )
        $template_new = $plugin_path . $template_name;
        
    }
    
    if ( !isset($template_new) ) {
        $template = $template;
    } else {
        $template = $template_new;
    }
    
    return $template;

  }
  return $template;
}



$settings_disable_general_head_css = get_bodycommerce_option('settings_disable_general_head_css');

if ( $settings_disable_general_head_css == "" || $settings_disable_general_head_css == "0") {
    require_once dirname( __FILE__ ) .'/lib/global-head-css.php';
    function bodyshop_woo_display_css() {

        $get_my_acount_fullwidth = get_bodycommerce_option('my_acount_fullwidth');
        $product_page_fullwidth = get_bodycommerce_option('product_page_fullwidth');
        $cart_page_fullwidth = get_bodycommerce_option('cart_page_fullwidth');
        $cart_page_remove_title = get_bodycommerce_option('cart_page_remove_title');


        $my_acount_page_nav_layout = get_bodycommerce_option( 'my_acount_page_nav_layout' );
        $get_my_acount_remove_headings = get_bodycommerce_option('my_acount_remove_headings');
        $get_my_acount_layout = get_bodycommerce_option('my_acount_layout');
        $get_my_acount_fullwidth_end_padding = get_bodycommerce_option('my_acount_fullwidth_end_padding');
        $get_my_acount_layout_width = get_bodycommerce_option('my_acount_layout_width', 40);
        $get_my_acount_layout_width_other = 100 - $get_my_acount_layout_width;

        $get_other_endpoint_width = $get_my_acount_layout_width_other - 20;
        $get_other_endpoint_width_margin_right = 10;


        $my_acount_left_right_same_height = get_bodycommerce_option('my_acount_left_right_same_height');

        $get_my_acount_other_endpoints_fullwidth = get_bodycommerce_option('my_acount_other_endpoints_fullwidth');
        $get_my_acount_other_endpoints_padding = get_bodycommerce_option('my_acount_other_endpoints_padding');

        $get_my_acount_remove_notices = get_bodycommerce_option('my_acount_remove_notices');
        $get_checkout_page_remove_title = get_bodycommerce_option('checkout_page_remove_title');
        $get_checkout_page_fullwidth = get_bodycommerce_option('checkout_page_fullwidth');


        if ($get_checkout_page_remove_title == "1") {
            echo "<style>.woocommerce-checkout .entry-title {display:none !important;}</style>";
        }

        if ($get_checkout_page_fullwidth == "1" ) {
            echo "<style>.woocommerce-checkout #main-content .container {width:100%; max-width:100%;}.woocommerce-checkout #main-content #left-area {width:100% !important;padding-right: 0 !important;}.woocommerce-checkout #sidebar, .woocommerce-cart #main-content .container::before, .woocommerce-cart .main_title {display:none;}
            .woocommerce-checkout #main-content .container {padding-top: 0px !important;}</style>";
        }

        if ($get_my_acount_other_endpoints_fullwidth != "1") {
            $get_my_acount_other_endpoints_fullwidth_display = "";
            $get_my_acount_other_endpoints_fullwidth_display_left = "";
        } else {
            $get_my_acount_other_endpoints_fullwidth_display = '.woocommerce-account.logged-in .entry-content .woocommerce .clearfix ~ h1, .woocommerce-account.logged-in .entry-content .woocommerce .clearfix ~ h2, .woocommerce-account.logged-in .entry-content .woocommerce .clearfix ~ h3, .woocommerce-account.logged-in .entry-content .woocommerce .clearfix ~ div:not(.et_pb_section) {    position: relative;width: 80%;max-width: 1080px;    margin: 0 auto;}';
            $get_my_acount_other_endpoints_fullwidth_display_left = '.woocommerce-account.logged-in .entry-content .woocommerce .clearfix ~ h1, .woocommerce-account.logged-in .entry-content .woocommerce .clearfix ~ h2, .woocommerce-account.logged-in .entry-content .woocommerce .clearfix ~ h3, .woocommerce-account.logged-in .entry-content .woocommerce .clearfix ~ div:not(.et_pb_section), .woocommerce-account.logged-in .entry-content .woocommerce > * {    position: relative;width: '.$get_other_endpoint_width.'%;max-width: 1080px;    margin: 0 auto; margin-right: '.$get_other_endpoint_width_margin_right.'%;}';
        }

        if ($get_my_acount_other_endpoints_padding == "") {
            $get_my_acount_other_endpoints_padding_display = "";
        } else {
            $get_my_acount_other_endpoints_padding_display = '  .woocommerce-account.logged-in .entry-content .woocommerce .clearfix + h1, .woocommerce-account.logged-in .entry-content .woocommerce .clearfix + h2, .woocommerce-account.logged-in .entry-content .woocommerce .clearfix + h3 {padding: '.$get_my_acount_other_endpoints_padding.'px 0;}';
        }

        if ($my_acount_left_right_same_height == "1") {
            $my_acount_left_right_same_height_dis = "
                .bc-account-content-container {display: flex;}
                .bc-account-content-container .bc-account-content .et_pb_section, .bc-account-content-container .bc-account-content .et_pb_row, .bc-account-content-container .bc-account-content .et_pb_column {height: 100%;};
            ";
        } else {
            $my_acount_left_right_same_height_dis = "";
        }

        $css_woo_bodyshop_class = "fullwidth";

        
        $css_woo_bodyshop = '';

        if ($get_my_acount_layout == "1" && $my_acount_page_nav_layout !== ''){

            $css_woo_bodyshop .=  sprintf('<style id="bodyshop-%s"> ', $css_woo_bodyshop_class);
            $css_woo_bodyshop .= '

                .bc-account-content-container .bc-account-nav {
                    width: '.$get_my_acount_layout_width.'%; float: left;
                }

                .bc-account-content-container .bc-account-content {
                    width: '.$get_my_acount_layout_width_other.'%;float: right;
                }

                .woocommerce-account .woocommerce-MyAccount-content {
                    width: 100% !important;
                }

                @media only screen and (max-width: 980px) {
                    .bc-account-content-container .bc-account-nav, .bc-account-content-container .bc-account-content {width: 100%;}
                    .bc-account-content-container {
                        display: block !important;
                    }
                }
                '.$my_acount_left_right_same_height_dis.'
                '.$get_my_acount_other_endpoints_fullwidth_display_left.'
                '.$get_my_acount_other_endpoints_padding_display.'
            ';
            $css_woo_bodyshop .= '</style>';
            //minify it
            $css_woo_bodyshop_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_woo_bodyshop );
            echo $css_woo_bodyshop_min; // phpcs:ignore
        } else if ($my_acount_page_nav_layout == '') {
            
        } else {
            $css_woo_bodyshop .=  sprintf('<style id="bodyshop-%s"> ', $css_woo_bodyshop_class);
            $css_woo_bodyshop .= '
                .woocommerce-account .woocommerce-MyAccount-content {
                    width: 100% !important;
                    float: none !important;
                }
                '.$get_my_acount_other_endpoints_fullwidth_display.'
                '.$get_my_acount_other_endpoints_padding_display.'
            ';
            $css_woo_bodyshop .= '</style>';
            //minify it
            $css_woo_bodyshop_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_woo_bodyshop );
            echo $css_woo_bodyshop_min; // phpcs:ignore
        }

        if ($get_my_acount_fullwidth == "1") {
            $css_woo_bodyshop_class = "woo-full";
            $css_woo_bodyshop .=  sprintf('<style id="bodyshop-%s"> ', $css_woo_bodyshop_class);
            $css_woo_bodyshop .= '
            .woocommerce-account #main-content .container { padding-top: 0 !important }
                .woocommerce-account #main-content .container {width:100%; max-width:100%;}
                .woocommerce-account #left-area {padding-right:0 !important;width:100% !important;}
                .woocommerce-account #sidebar, .et_right_sidebar #main-content .container:before {display:none !important;}
                .woocommerce-account #main-content .et_pb_section.et_pb_section_0 > .et_pb_row {
                    width: 100%;
                    max-width: 100%;
                    padding: 0;
                }
                .woocommerce-account .et_pb_section.et_pb_section_0 {
                    padding: 0;
                }
            ';
            $css_woo_bodyshop .= '</style>';
            //minify it
            $css_woo_bodyshop_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_woo_bodyshop );
            echo $css_woo_bodyshop_min; // phpcs:ignore
        } else { }

        if ($product_page_fullwidth == "1"){
            $css_woo_bodyshop_class = "woo-full-product";
            $css_woo_bodyshop .=  sprintf('<style id="bodyshop-%s"> ', $css_woo_bodyshop_class);
            $css_woo_bodyshop .= '
                .single-product #main-content .container {width:100%; max-width:100%;}
                .single-product #main-content #left-area {width:100% !important;padding-right: 0 !important;}
            ';
            $css_woo_bodyshop .= '</style>';
            //minify it
            $css_woo_bodyshop_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_woo_bodyshop );
            echo $css_woo_bodyshop_min; // phpcs:ignore
        }

        if ($cart_page_fullwidth == "1"){

            $css_woo_bodyshop_class = "woo-full-woocommerce-cart";
            $css_woo_bodyshop .=  sprintf('<style id="bodyshop-%s"> ', $css_woo_bodyshop_class);
            $css_woo_bodyshop .= '
                .woocommerce-cart #main-content .container {width:100%; max-width:100%;}
                .woocommerce-cart #main-content #left-area {width:100% !important;padding-right: 0 !important;}
                .woocommerce-cart #sidebar, .woocommerce-cart #main-content .container::before, .woocommerce-cart .main_title {display:none;}
                .woocommerce-cart #main-content .container {padding-top: 0px !important;}
            ';
            $css_woo_bodyshop .= '</style>';
            //minify it
            $css_woo_bodyshop_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_woo_bodyshop );
            echo $css_woo_bodyshop_min; // phpcs:ignore
        }

        if ($cart_page_remove_title == "1") {
            $css_woo_bodyshop_class = "bodycommerce-cart-title";
            $css_woo_bodyshop .=  sprintf('<style id="bodyshop-%s"> ', $css_woo_bodyshop_class);
            $css_woo_bodyshop .= '
                .woocommerce-cart .main_title {display:none;}
            ';
            $css_woo_bodyshop .= '</style>';
            //minify it
            $css_woo_bodyshop_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_woo_bodyshop );
            echo $css_woo_bodyshop_min; // phpcs:ignore
        }


        if ($get_my_acount_remove_headings == "1"){
            $css_woo_bodyshop_class = "woo-heading";
            $css_woo_bodyshop .=  sprintf('<style id="bodyshop-%s"> ', $css_woo_bodyshop_class);
            $css_woo_bodyshop .= '
                .woocommerce-account .entry-title.main_title {display:none;}
            ';
            $css_woo_bodyshop .= '</style>';
            //minify it
            $css_woo_bodyshop_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_woo_bodyshop );
            echo $css_woo_bodyshop_min; // phpcs:ignore
        }

        $css_woo_bodyshop .= '<style id="bodycommerce">';
        $css_woo_bodyshop .= '

            .et_pb_db_shop_cat_loop .et_pb_row_bodycommerce {clear: both;}

            .stock::first-letter, .out-of-stock::first-letter {
                text-transform: capitalize;
            }

            .woocommerce-form .et_pb_contact p .woocommerce-form__label-for-checkbox input[type="checkbox"] {
                -webkit-appearance: checkbox !important;
            }

            #main-content .container {padding-top: 0px;}
            .woocommerce-customer-details, .woocommerce-order-downloads, .woocommerce-account.logged-in .entry-content .woocommerce .col.s12, .woocommerce-account.logged-in .entry-content .woocommerce .woocommerce-order-details, .woocommerce-account.logged-in .entry-content .woocommerce > p {padding: '.$get_my_acount_fullwidth_end_padding.'px;}
            .et_pb_db_shop_loop_list .et_pb_row, .et_pb_db_shop_loop_grid .et_pb_row_bodycommerce, .et_pb_db_shop_loop_grid .et_pb_row_bodycommerce .et_pb_row {
                width: 100%;
                max-width: inherit;
                padding-left: 0;
                padding-right: 0;
            }
            .et_pb_gutters3 .et_pb_column_4_4 .et_pb_blog_grid.et_pb_db_shop_loop_grid .column.size-1of3, .et_pb_gutters3.et_pb_row .et_pb_column_4_4 .et_pb_blog_grid.et_pb_db_shop_loop_grid .column.size-1of3 {
                width: auto !important;
                margin-right: auto;
            }

            .et_pb_dc_product_column .et_pb_row {
                padding: 0;
            }


            .et_pb_db_shop_loop_list .et_pb_section, .et_pb_db_shop_loop_grid .et_pb_section {
                padding: 0;
            }


            .archive.woocommerce .quantity, .woocommerce .et_pb_shop .quantity {float:left;}
            .archive.woocommerce .add_to_cart_button, .woocommerce .et_pb_shop .add_to_cart_button {margin-top:0;}

            .woocommerce .cart-collaterals.cart-collaterals-bc .cart_totals, .woocommerce-page .cart-collaterals.cart-collaterals-bc .cart_totals {width: 100%;}

            .et_pb_db_cart_products.image_size_small .cart .product-thumbnail img {
                width: 60px;
            }

            .et_pb_db_cart_products.image_size_medium .cart .product-thumbnail img {
                width: 150px;
            }

            .et_pb_db_cart_products.image_size_large .cart .product-thumbnail img {
                width: 300px;
            }

            .et_pb_module.no-borders table,
            .et_pb_module.no-borders table td,
            .et_pb_module.no-borders table th,
            .et_pb_module.no-borders .cart-collaterals .cart_totals table th,
            .et_pb_module.no-borders .cart-collaterals .cart_totals table td,
            .woocommerce .et_pb_module.no-borders table.shop_table tbody th,
            .woocommerce .et_pb_module.no-borders table.shop_table tfoot td,
            .woocommerce .et_pb_module.no-borders table.shop_table tfoot th,
            .woocommerce .et_pb_module.no-borders .woocommerce-customer-details address,
            .woocommerce .et_pb_module.no-borders .cart-subtotal td {
                border: none !important;
            }

            .et_pb_module.no-title .woocommerce-column__title {
                display: none;
            }

            .woocommerce-form .et_pb_contact p input[type="checkbox"] {display: inline-block;margin-right: 10px;}

            /*
            .et_pb_db_navigation {
                display: flex;
            }
            */

            .img_pos_top a {
                display: flex;
                flex-direction: column;
            }

            .img_pos_bottom a {
                display: flex;
                flex-direction: column-reverse;
            }


            .et_pb_db_navigation.et_pb_text_align_left {
                display: flex;
                justify-content: flex-start;
                width: 100%;
            }

            .et_pb_db_navigation.et_pb_text_align_center {
                display: flex;
                justify-content: center;
                width: 100%;
            }

            .et_pb_db_navigation.et_pb_text_align_right {
                display: flex;
                justify-content: flex-end;
                width: 100%;
            }

            .db_pro_prev_product {
                margin: 0 2% 0 0;
                max-width: 48%;
                float: left;
            }

            .db_pro_next_product {
                margin: 0 0 0 2%;
                max-width: 48%;
                float: left;
            }
            .et_pb_text_align_edge_to_edge{
                overflow: hidden
            }
            .et_pb_text_align_edge_to_edge .db_pro_prev_product {float:left;}
            .et_pb_text_align_edge_to_edge .db_pro_next_product {float: right;}

            .et_pb_gutters3 .et_pb_column_2_3 .et_pb_dc_product_column.et_pb_column_1_3, .et_pb_gutters3 .et_pb_column_2_3 .et_pb_db_cat_column.et_pb_column_1_3 {
                width: 30%;
                margin-right: 5%;
            }

            .et_pb_row.et_pb_row_bodycommerce .et_pb_dc_product_column.et_pb_column_1_4 {margin: 0 3.8% 2.992em 0;width: 21.05%;}
            .et_pb_row.et_pb_row_bodycommerce .et_pb_dc_product_column.et_pb_column_1_3 {margin-right: 3%;width: 31.333%;}

            .woocommerce #respond input#submit.loading::after, .woocommerce a.button.loading::after, .woocommerce button.button.loading::after, .woocommerce input.button.loading::after {
                top: 10px;
                right: 2px;
            }

            @media only screen and (max-width: 980px) {
                .woocommerce-account.logged-in .entry-content .woocommerce .et_pb_section:nth-child(1),   .woocommerce-account.logged-in .entry-content .woocommerce .clearfix ~ h3, .woocommerce-account.logged-in .entry-content .woocommerce .clearfix ~ h1,.woocommerce-account.logged-in .entry-content .woocommerce .clearfix ~ h2, .woocommerce-account.logged-in .entry-content .woocommerce .clearfix ~ div, .woocommerce-account.logged-in .entry-content .woocommerce .et_pb_section, .woocommerce-account.logged-in .entry-content .woocommerce .col.s12, .woocommerce-account.logged-in .entry-content .woocommerce .woocommerce-order-details, .woocommerce-account.logged-in .entry-content .woocommerce > p {
                    width: 100%;
                    margin: 0;
                }
            }
        ';
        $css_woo_bodyshop .= '</style>';
        //minify it
        $css_woo_bodyshop_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_woo_bodyshop );
        echo $css_woo_bodyshop_min; // phpcs:ignore
        echo '<style>.et_pb_db_shop_thumbnail a, .et_pb_db_shop_thumbnail img.secondary-image {padding: inherit;}.secondary-image {position: absolute;top: 0; left: 0;opacity: 0 !important;    -webkit-transition: opacity .5s ease;-o-transition: opacity .5s ease;transition: opacity .5s ease;}.secondary-image + img{-webkit-transition: opacity .5s ease;-o-transition: opacity .5s ease;transition: opacity .5s ease;}.et_pb_db_shop_thumbnail:hover .secondary-image + img {opacity:1;}.et_pb_db_shop_thumbnail:hover .secondary-image {opacity:1 !important;}</style>';
    }
    add_action('wp_head', 'bodyshop_woo_display_css');
}

function internet_explorer_jquery() {
?>
<script>
jQuery(document).ready(function(i) {
    const c = window.navigator.userAgent;

    function t(c) {
        i(".bc_product_grid").each(function(t, o) {
            var n, s, d, r = i(this).find("li.product"),
                e = (n = i(this), s = c, d = void 0, i(n.attr("class").split(" ")).each(function() {
                    this.indexOf(s) > -1 && (d = this)
                }), d).replace(c, ""),
                u = 1,
                h = 1;
            i(r).each(function(i, c) {
                u++
            });
            var l = Math.ceil(u / e),
                a = l * e;
            i(r).each(function(c, t) {
                var o = (h - 1) % e + 1,
                    n = Math.ceil(h * l / a);
                i(this).closest(".bc_product_grid").find("li.product:nth-child(" + h + ")").css(
                    "-ms-grid-row", "" + n), i(this).closest(".bc_product_grid").find(
                    "li.product:nth-child(" + h + ")").css("-ms-grid-column", "" + o), h++
            })
        })
    }
    /MSIE|Trident/.test(c) && i(window).on("resize", function() {
        i(window).width() >= 981 ? (col_size = "bc_product_", t(col_size)) : (col_size = "bc_pro_mob_",
            t(col_size))
    })
});
</script>
<?php
}
add_action('wp_head', 'internet_explorer_jquery');

function internet_explorer_css() {
?>

<style>
.bc_product_1 {
    display: -ms-grid;
    -ms-grid-columns: 1fr
}

.bc_product_2 {
    display: -ms-grid;
    -ms-grid-columns: 1fr 1fr
}

.bc_product_3 {
    display: -ms-grid;
    -ms-grid-columns: 1fr 1fr 1fr
}

.bc_product_4 {
    display: -ms-grid;
    -ms-grid-columns: 1fr 1fr 1fr 1fr
}

.bc_product_5 {
    display: -ms-grid;
    -ms-grid-columns: 1fr 1fr 1fr 1fr 1fr
}

.bc_product_6 {
    display: -ms-grid;
    -ms-grid-columns: 1fr 1fr 1fr 1fr 1fr 1fr
}

@media(max-width:980px) {
    body .bc_pro_mob_1 {
        display: -ms-grid;
        -ms-grid-columns: 1fr
    }

    body .bc_pro_mob_2 {
        display: -ms-grid;
        -ms-grid-columns: 1fr 1fr
    }
}

@media screen and (-ms-high-contrast:active),
(-ms-high-contrast:none) {

    .woocommerce #main-content .et_pb_gutters4 .et_pb_db_shop_loop ul.bc_product_grid li.product,
    ul.bc_product_grid li.product>* {
        margin-left: 8% !important;
        margin-right: 8% !important
    }

    .woocommerce.et_pb_gutters3 #main-content .et_pb_db_shop_loop ul.bc_product_grid li.product,
    ul.bc_product_grid li.product>* {
        margin-left: 5.5% !important;
        margin-right: 5.5% !important
    }

    .woocommerce #main-content .et_pb_gutters2 .et_pb_db_shop_loop ul.bc_product_grid li.product,
    ul.bc_product_grid li.product>* {
        margin-left: 3% !important;
        margin-right: 3% !important
    }

    .woocommerce #main-content .et_pb_gutters1 .et_pb_db_shop_loop ul.bc_product_grid li.product,
    ul.bc_product_grid li.product>* {
        margin-left: 0 !important;
        margin-right: 0 !important
    }
}
</style>

<?php
}
add_action('wp_head', 'internet_explorer_css');

$get_divi_engine_css = get_option('divi-engine-css', null);
if ($get_divi_engine_css == "" || $get_divi_engine_css == "bodyshop-woo-added" ) {
    update_option('divi-engine-css', 'bodyshop-woo-added');

    add_action( 'admin_enqueue_scripts', 'load_divi_engine_style_woo' , 20);
    function load_divi_engine_style_woo() {
        $cssfile = plugins_url( 'css/divi-engine.css', __FILE__ );
        // $cssfile_font = 'https://fonts.googleapis.com/css?family=Roboto';

        wp_enqueue_style( 'divi_engine_admin_css', $cssfile , false, DE_DB_WOO_VERSION );
        // wp_enqueue_style( 'divi_engine_admin_css_roboto', $cssfile_font , false, DE_DB_WOO_VERSION );
    }

}

add_action( 'admin_enqueue_scripts', 'load_divi_bodyshop_woo_js' , 20);
function load_divi_bodyshop_woo_js($hook_suffix) {
    $jsfile = plugins_url( 'js/admin.min.js', __FILE__ );
    $importjsfile = plugins_url( 'js/import_export.js', __FILE__ );
    wp_enqueue_script( 'divi-bodycommerce-admin-script', $jsfile, array( 'jquery' ), DE_DB_WOO_VERSION );
    wp_enqueue_script( 'divi-bodycommerce-admin-import-export', $importjsfile, array( 'jquery' ), DE_DB_WOO_VERSION );
}

/// admin script for product pages
add_action( 'admin_enqueue_scripts', 'load_divi_bodycommerce_product_js' , 11);
function load_divi_bodycommerce_product_js($hook_suffix) {
    if ( 'product' === get_post_type() ) {
        $jsfile = plugins_url( 'js/product-admin.js', __FILE__ );
        wp_enqueue_script( 'divi-bodycommerce-product-admin-script', $jsfile, array( 'jquery' ), DE_DB_WOO_VERSION );
    }
}


add_action( 'admin_enqueue_scripts', 'load_style_woo' , 20);
function load_style_woo() {
    $cssfile = plugins_url( 'css/divi-bodycommerce.min.css', __FILE__ );
    wp_enqueue_style( 'divi_bodyshop_woo_admin_css', $cssfile , false, DE_DB_WOO_VERSION );
}

if(!function_exists('de_db_woo_uninstall_hook')) {
    function de_db_woo_uninstall_hook()
    {
        $remove_options = get_bodycommerce_option('settings_delete_from_database');
        if ($remove_options == '1') {
            delete_option('divi-engine-menu');
            delete_option('divi-engine-css');
            delete_option('divi-bodyshop-woo_options');
        }
    }

    register_uninstall_hook(__FILE__, 'de_db_woo_uninstall_hook');
}

// product category for module

if ( ! function_exists( 'et_builder_include_categories_option_product' ) ) :
function et_builder_include_categories_option_product( $args = array() ) {

    $terms = get_terms( 'product_cat', $args );
    $defaults = apply_filters( 'et_builder_include_categories_defaults', array (
        'use_terms' => true,
        'term_name' => 'product_cat',
    ) );

    $args = wp_parse_args( $args, $defaults );
    $term_args = apply_filters( 'et_builder_include_categories_option_product_args', array( 'hide_empty' => false, ) );
    $output = "\t" . "<% var et_pb_include_categories_temp = typeof et_pb_include_categories !== 'undefined' ? et_pb_include_categories.split( ',' ) : []; %>" . "\n";

    if ( $args['use_terms'] ) {
        $cats_array = get_terms( $args['term_name'], $term_args );
    } else {
        $cats_array = get_categories( apply_filters( 'et_builder_get_categories_args', 'hide_empty=0' ) );
    }

    if ( empty( $cats_array ) ) {
        $output = '<p>' . esc_html__( "You currently don't have any products assigned to a category.", 'et_builder' ) . '</p>';
    }

    foreach ( $terms as $term ) {

        $contains = sprintf(
            '<%%= _.contains( et_pb_include_categories_temp, "%1$s" ) ? checked="checked" : "" %%>',
            esc_html( $term->name )
        );

        $output .= sprintf(
            '%4$s<label><input type="checkbox" name="et_pb_include_categories" value="%1$s"%3$s> %2$s</label><br/>',
            esc_attr( $term->term_id ),
            esc_html( $term->name ),
            $contains,
            "\n\t\t\t\t\t"
        );
    }

    $output = '<div id="et_pb_include_categories">' . $output . '</div>';

    return apply_filters( 'et_builder_include_categories_option_product_html', $output );
}
endif;


/////------------------------------------------------------------------------
add_filter( 'template_include', 'bodycommerce_include_woo_templates_include', 99 );

function bodycommerce_include_woo_templates_include( $template ) { 

    if ( class_exists('WooCommerce')) {
 
        $base_template = basename($template);


        if ($base_template == 'single-product.php') {
            $product_layout = bodycommerce_single_layout();

                            if ($product_layout) {
                                $template = dirname(__FILE__) . '/includes/templates/master-template.php';
                            }


        } else if (is_search() || $base_template == 'archive-product.php' || $base_template == 'taxonomy-product_cat.php' || $base_template == 'taxonomy-product_tag.php' || $base_template == 'taxonomy-product-cat.php' || $base_template == 'taxonomy-product-tag.php' || $base_template == 'taxonomy-product-attribute.php' ) {
 
            $product_layout = bodycommerce_archive_layout();
            if ($product_layout) {
                $template = dirname(__FILE__) . '/includes/templates/master-template.php';
            }
        } else if ( is_wc_endpoint_url( 'order-received' ) ) {

            $product_layout = bodycommerce_thankyou_layout();
            if ($product_layout) {
                $template = dirname(__FILE__) . '/includes/templates/master-template.php';
            }
        } else if ( is_cart() && is_checkout() && 0 == WC()->cart->get_cart_contents_count() && ! is_wc_endpoint_url( 'order-pay' ) && ! is_wc_endpoint_url( 'order-received' ) ) {

            $product_layout = bodycommerce_blank_cart_layout();
            if ($product_layout) {
                $template = dirname(__FILE__) . '/includes/templates/master-template.php';
            }
        } 
    }
    return $template;
}

function bodycommerce_single_layout() {
    $start_time = microtime(true);
    global $wpdb, $post, $product;

    $post_id = 0;

    if (class_exists('woocommerce') && get_post_type() == "product") {
        global $woocommerce;
        if (is_a($product, 'WC_Product')) {
            $post_id = $product->get_id();
        }
    } else {
        $post_id = get_the_ID();
    }

    $get_product_page_enable_multiple_templates = get_bodycommerce_option('product_page_enable_multiple_templates');

    $product_template_override = get_post_meta( $post_id, 'divi-bodyshop-woo_product_template_override', true );

    $product_layout = get_bodycommerce_option('product_page_template');

    if ($product_template_override != "") {
        $display_layout = $product_template_override;
    } else {
        $primaryCategory = get_post_meta( $post_id, 'divi-bodyshop-woo_product_template_override_primary', true );
        $defaultCategory = !empty($primaryCategory)?$primaryCategory: "";
        if( $defaultCategory != "" ){
            $defaultCategory_term = get_term_by( 'id', $defaultCategory, 'product_cat' );
            if ($defaultCategory_term != "") {
                $defaultCategory_term_name = $defaultCategory_term->name;
                $defaultCategory_term_slug = $defaultCategory_term->slug;
                $check_defaultCategory_template = get_bodycommerce_option('custom_product_'.$defaultCategory_term_slug);
            } else {
                $defaultCategory_term_name = "";
            }
        } else {
            $defaultCategory_term_name = "";
        }

        if ( $defaultCategory_term_name != '' ) {
            $display_layout = $check_defaultCategory_template;
        } else {
            if ( is_product() && $get_product_page_enable_multiple_templates == "1" ) {

                $terms = get_the_terms( $post_id, 'product_cat' );
                // get last cat
                if (is_array($terms)) {
                    $last_cat_child = array_slice($terms, -1, 1, true);
                    $last_cat_child = array_values($last_cat_child);
                    $term_child_slug_first = $last_cat_child["0"];
                }
                else {
                    $term_child_slug_first = "";
                }

                $term_child_slug = get_term($term_child_slug_first);

                if (isset($term_child_slug->slug)) {

                    $child_slug = $term_child_slug->slug;
                    $check_product_page_category_child = get_bodycommerce_option('custom_product_'.$child_slug );
                    
                    if ($check_product_page_category_child != "") {
                        $display_layout = $check_product_page_category_child;
                    }else {
                        $product_parent_categories_all_hierachy = get_ancestors( $term_child_slug->term_id, 'product_cat' );
                        $last_parent_cat = array_slice($product_parent_categories_all_hierachy, -1, 1, true);
                        if (empty($last_parent_cat)) {
                            $display_layout = $product_layout;
                        }else {
                            if (!isset($last_parent_cat[0])) {
                                $display_layout = $product_layout;
                            } else {
                                if( $term = get_term_by( 'id', $last_parent_cat[0], 'product_cat' ) ){
                                    $term_parent_slug = $term->slug;
                                    $check_product_page_category_parent = get_bodycommerce_option( 'custom_product_'.$term_parent_slug.'' );
                                    
                                    if ($check_product_page_category_parent != "") {
                                        $display_layout = $check_product_page_category_parent;
                                    } else {
                                        $display_layout = $product_layout;
                                    }
                                }
                            }
                        }    
                    }
                } else {
                    $display_layout = $product_layout;
                }
            }else {
                $display_layout = $product_layout;
            }
        }
    }

    $settings_disable_schema = get_bodycommerce_option('settings_disable_schema');
    // product schema data
    if( class_exists( 'WC_Structured_Data' ) && $settings_disable_schema !== "1" ){
        $wc_str_data = new WC_Structured_Data();
        $wc_str_data->generate_product_data();
    }

    return $display_layout;
}

function bodycommerce_archive_layout() {

 
    global $post, $product, $wp_query;

    $get_category_page_enable_multiple_templates = get_bodycommerce_option('category_page_enable_multiple_templates');

    $archive_page_shop_template = get_bodycommerce_option('archive_page_shop_template');

    $archive_page_category_template = get_bodycommerce_option('archive_page_category_template');

    $tag_template = get_bodycommerce_option('tag_template');
    $attr_template = get_bodycommerce_option( 'attr_template' );
    $tag_page_enable_multiple_templates = get_bodycommerce_option( 'tag_page_enable_multiple_templates' );

    $search_page_template = get_bodycommerce_option('search_page_template');

    if (is_search()) {
        $display_layout = $search_page_template;
    } else if (is_shop()) {
        if (is_search()) {
            $display_layout = $search_page_template;
        } else {
            $display_layout = $archive_page_shop_template;
        }
    } else {

        if ( is_tax( 'product_cat' ) ) {

            $queried_object = get_queried_object();
            
            $cat_slug = 'custom_category_'.$queried_object->slug.'';
            $check_category_page_category = get_bodycommerce_option( $cat_slug );

            if ($archive_page_category_template != "" && $get_category_page_enable_multiple_templates != 1) {
                $display_layout = $archive_page_category_template;
            } else if ($check_category_page_category == "" && $get_category_page_enable_multiple_templates == 1) {
                $display_layout = $archive_page_category_template;
            } else  {
                $display_layout = $check_category_page_category;
            }
        } else if ( is_tax( 'product_tag' ) ) {

            $queried_object = get_queried_object();

            $tag_slug = 'custom_tag_'.$queried_object->slug.'';

            $check_tag_category_id = get_bodycommerce_option( $tag_slug );

            if ($tag_template != "" && $tag_page_enable_multiple_templates != 1) {
                $display_layout = $tag_template;
            } else if ($check_tag_category_id == "" && $tag_page_enable_multiple_templates == 1) {
                $display_layout = $tag_template;
            } else if ($tag_template == "" && $tag_page_enable_multiple_templates == 0) {
                $display_layout = $archive_page_category_template;
            } else  {
                $display_layout = $check_tag_category_id;
            }
        } else if ( is_tax() && function_exists( 'taxonomy_is_product_attribute') ) {
            $display_layout = $attr_template;
        } else {
            $display_layout = $archive_page_category_template;
        }
    }

    return $display_layout;
}

function bodycommerce_thankyou_layout() {
  
    global $wp;

    $thankyou_page_template = get_bodycommerce_option('thankyou_page_template');

    $display_layout = $thankyou_page_template;

    // if display_layout is empty, return false
    if ( empty( $display_layout ) ) {
        return false;
    }

    $order_id  = absint( $wp->query_vars['order-received'] );

    $order = wc_get_order($order_id);

    if ( $order->has_status( 'failed' ) ) {
        return false;
        }

    // check if order cust id = current user id
    $order_key = $_GET['key'];

    if ( !$order || !hash_equals($order->get_order_key(), $order_key ) ){
        return false;
    }

    $user_id = $order->get_user_id();
    $current_user_id = get_current_user_id();
    if ($current_user_id !== $user_id) {
        return false;
    }

    return $display_layout;
}

function bodycommerce_blank_cart_layout() {

    $get_cart_empty_page_template = get_bodycommerce_option('cart_empty_page_template');

    $display_layout = $get_cart_empty_page_template;

    return $display_layout;
}


function bodycommerce_include_woo_templates() {

    get_header('shop');
    global $post;

    $post_id = 0;

    if (class_exists('woocommerce') && get_post_type() == "product") {
        global $product, $woocommerce;
        if (is_a($product, 'WC_Product')) {
            $post_id = $product->get_id();
        }
    } else {
        $post_id = get_the_ID();
    }

    if (is_single()) {
        $product_layout = bodycommerce_single_layout();
        $entry_summary = '<div class="product ' . ( get_post_type() == 'product' ? 'post-' . $post_id : '' ) . '">
                  <div class="entry-summary">';
    } else if (is_archive() || is_search()) {
        $product_layout = bodycommerce_archive_layout();
        $entry_summary = '<div class="archive-bc-page">
                  <div class="entry-summary">';
    } else if (is_wc_endpoint_url( 'order-received' )) {
        $product_layout = bodycommerce_thankyou_layout();
        $entry_summary = '<div class="thankyou-bc-page">
                  <div class="entry-summary">';
    } else if ( is_cart() && is_checkout() && 0 == WC()->cart->get_cart_contents_count() && ! is_wc_endpoint_url( 'order-pay' ) && ! is_wc_endpoint_url( 'order-received' ) ) {
        $product_layout = bodycommerce_blank_cart_layout();
        $entry_summary = '<div class="cart-checkout-bc-page">
                      <div class="entry-summary">';
    }


 
    if ($product_layout) {

        global $shortcode_tags, $post;
        
        if (is_search()) {
            $section = apply_filters('the_content', get_post_field('post_content', $product_layout));
        } else {
            $section = do_shortcode('[et_pb_section global_module="' . $product_layout . '"][/et_pb_section]');
        }

        $layout_display = $section;

    }


    $theme = wp_get_theme();
    $parent = $theme->parent();

    if ($parent == "") {
        $theme_name = $theme;
    } else {
        $theme_name = $parent;
    }

    $layout_display_dis = '<div id="main-content" class="bodycommerce_main_content">';
    $layout_display_dis .= '<div id="et-boc" class="et-boc">';
    $layout_display_dis .= '<div class="et-l et-l--body">';
    $layout_display_dis .= $entry_summary;

    if ( stristr( $layout_display, 'woocommerce-message' ) === false ) {
        wc_print_notices();
    }

    $layout_display_dis .= $layout_display;
    $layout_display_dis .= '</div></div></div></div></div>';

    echo apply_filters( 'bodycommerce_include_woo_templates', $layout_display_dis ); // phpcs:ignore
      // do_action( 'woocommerce_after_shop_loop' );
    get_footer('shop');
}

function db_woo_remove_reviews($tabs)
{
    unset($tabs['reviews']);
    return $tabs;
}

////--------------------------------------------------------------------------

///---------------------------------------------------

add_action( 'init', function() {
    ps_register_shortcode_ajax( 'ajax_filter_get_posts', 'ajax_filter_get_posts' );
} );

function ps_register_shortcode_ajax( $callable, $action ) {

    if ( empty( $_POST['action'] ) || $_POST['action'] != $action )
        return;
    call_user_func( $callable );
}

add_action( 'bodycommerce_checkoutbilling', 'bodycommerce_checkoutbilling' );
function bodycommerce_checkoutbilling() {
    global $woocommerce;
    do_action( 'woocommerce_checkout_before_customer_details' );
    do_action( 'woocommerce_checkout_billing' );
}


add_action( 'bodycommerce_checkoutshipping', 'bodycommerce_checkoutshipping' );
function bodycommerce_checkoutshipping() {
    do_action( 'woocommerce_before_checkout_shipping_form' );
    do_action( 'woocommerce_checkout_shipping' );
    do_action( 'woocommerce_checkout_after_customer_details' );
}


add_action( 'bodycommerce_checkoutorder', 'bodycommerce_checkoutorder' );
function bodycommerce_checkoutorder() {
    do_action( 'woocommerce_checkout_before_order_review' );
    
    // $check_other_settings_step_order_title = get_bodycommerce_option('other_settings_step_order_title', "Your order");
?>

<h3 id="order_review_heading"><?php _e( 'Your order', 'woocommerce' ); ?></h3>
<div class="coupan_form">
    <?php do_action( 'bodycommerce_checkout_order_review' ); ?>
</div>
<!--input type="checkbox" name="payment_method" value="" data-order_button_text="" style="display: none;" /-->

<?php
}

// GET ACCENT COLOR
if ( ! function_exists( 'et_builder_accent_color_bodycommerce' ) ) :
function et_builder_accent_color_bodycommerce( $default_color = '#7EBEC5' ) {
    $accent_color = ! et_is_builder_plugin_active() ? et_get_option( 'accent_color', $default_color ) : $default_color;

    return apply_filters( 'et_builder_accent_color_bodycommerce', $accent_color );
}
endif;

/**
* @snippet       Add woocommerce class to the body
* @snippet       Add product type class to the body for ajax mini cart
*/
function bodycommerce_add_woocommerce_class( $classes ) {
    $settings_remove_woo_class = get_bodycommerce_option('settings_remove_woo_class');
    if (is_array($settings_remove_woo_class)) {
        $settings_remove_woo_class_arr = explode(",",$settings_remove_woo_class);

        if ( !is_page( $settings_remove_woo_class_arr ) ) {
            $classes[] = 'woocommerce';
        }
    } else {
        $classes[] = 'woocommerce';
    }

    
    if ( is_singular( 'product' ) ) {
        global $post, $woocommerce;
        $product = wc_get_product( $post->ID );
        if ( $product ) {
        $classes[] = 'product-type-' . $product->get_type();
        }
    }

    return $classes;
}
add_filter( 'body_class','bodycommerce_add_woocommerce_class', 9999999);


/***** Custom register validation ******/
function bodycommerce_register_validate_extra_fields( $username, $email, $validation_errors ) {

      if ( isset( $_POST['billing_first_name'] ) && empty( $_POST['billing_first_name'] ) ) {
              $validation_errors->add( 'billing_first_name_error', __( '<strong>Error</strong>: First name is required!', 'woocommerce' ) );
       }
       if ( isset( $_POST['billing_last_name'] ) && empty( $_POST['billing_last_name'] ) ) {
              $validation_errors->add( 'billing_last_name_error', __( '<strong>Error</strong>: Last name is required!', 'woocommerce' ) );
       }
         return $validation_errors;
}

add_action( 'woocommerce_register_post', 'bodycommerce_register_validate_extra_fields', 10, 3 );

/***** ADD CUSTOM REGISTER TO DATABASE ****/

function bodycommerce_register_save_extra_fields($customer_id) {
    //First name field
    if (isset($_POST['billing_first_name'])) {
        update_user_meta($customer_id, 'first_name', sanitize_text_field($_POST['billing_first_name']));
        update_user_meta($customer_id, 'billing_first_name', sanitize_text_field($_POST['billing_first_name']));
    }
    //Last name field
    if (isset($_POST['billing_last_name'])) {
        update_user_meta($customer_id, 'last_name', sanitize_text_field($_POST['billing_last_name']));
        update_user_meta($customer_id, 'billing_last_name', sanitize_text_field($_POST['billing_last_name']));
    }
    //Phone field
    if (isset($_POST['billing_phone'])) {
        update_user_meta($customer_id, 'billing_phone', sanitize_text_field($_POST['billing_phone']));
    }
}

add_action('woocommerce_created_customer', 'bodycommerce_register_save_extra_fields');


/* REMOVE PAYMENT BELOW ON RIGHT CHECKOUT */
if ( get_bodycommerce_option('checkout_page_style') != '') {
    if (get_bodycommerce_option('checkout_page_style') == "payment-right") {
        add_action( 'after_setup_theme', 'remove_payment_action_riught_chgeckout', 0 );
        function remove_payment_action_riught_chgeckout() {
           remove_action( 'woocommerce_checkout_order_review', 'woocommerce_checkout_payment', 20 );
           add_action( 'woocommerce_checkout_after_order_review', 'woocommerce_checkout_payment', 20 );
        }
    }
}


// add_action ('', 'bodycommerce_before_right_checkout');

// function wc_billing_field_strings( $translated_text, $text, $domain ) {
//
//  $mydata = get_option( 'divi-bodyshop-woo_options' );
//  $mydata = unserialize($mydata);
//
//  if (!isset($mydata['other_settings_step_billing_title'])) {
//      $check_other_settings_step_billing_title = "Billing details";
//          }   else {
//      $check_other_settings_step_billing_title = $mydata['other_settings_step_billing_title'];
//              }
//
//
//      if (!isset($mydata['other_settings_step_different_address_title'])) {
//      $check_other_settings_step_different_address_title = "Deliver to a different address?";
//   } else {
//      $check_other_settings_step_different_address_title = $mydata['other_settings_step_different_address_title'];
//   }
//
//
// if (!isset($mydata['other_settings_step_order_title'])) {
// $check_other_settings_step_order_title = "Your order";
// }
// else {
//  $check_other_settings_step_order_title = $mydata['other_settings_step_order_title'];
// }
//
//     switch ( $translated_text ) {
//
//          case 'Billing details' :
//             $translated_text = __( $check_other_settings_step_billing_title, 'woocommerce' );
//             break;
//
//            case 'Deliver to a different address?' :
//              $translated_text = __( $check_other_settings_step_different_address_title, 'woocommerce' );
//              break;
//
//            case 'Your order' :
//              $translated_text = __( $check_other_settings_step_order_title, 'woocommerce' );
//              break;
//     }
//     return $translated_text;
// }
// add_filter( 'gettext', 'wc_billing_field_strings', 20, 3 );


// ADD SKU TO SEARCH
if ( !function_exists( 'bodycommerce_product_search_join' ) ) {
    function bodycommerce_product_search_join( $join, $query ) {
        
        global $price_filter_var;
        global $wpdb;

        if ( isset($price_filter_var['is_filter']) && $price_filter_var['is_filter'] ) {
            $join  .= " LEFT JOIN {$wpdb->wc_product_meta_lookup} wc_product_meta_lookup ON $wpdb->posts.ID = wc_product_meta_lookup.product_id ";    
        }

        if ( ! $query->is_main_query() || is_admin() || ! is_search() || ! is_woocommerce() ) {
            return $join;
        }

        $join .= " LEFT JOIN {$wpdb->postmeta} iconic_post_meta ON {$wpdb->posts}.ID = iconic_post_meta.post_id ";
        return $join;
    }
    add_filter( 'posts_join', 'bodycommerce_product_search_join', 10, 2 );
}

if ( !function_exists( 'bodycommerce_product_search_where' ) ) {

    function bodycommerce_product_search_where( $where, $query ) {

        global $price_filter_var;
        global $wpdb;

        if ( isset($price_filter_var['is_filter']) && $price_filter_var['is_filter']) {
            $enable_price_variation_partial = get_bodycommerce_option('enable_price_variation_partial');

            if ( $enable_price_variation_partial == "1" ) {
                $where .= $wpdb->prepare(
                    ' AND NOT (%f>wc_product_meta_lookup.max_price OR %f<wc_product_meta_lookup.min_price ) ',
                    $price_filter_var['min_price'],
                    $price_filter_var['max_price']
                );
            } else {
                $where .= $wpdb->prepare(
                    ' AND NOT (%f>wc_product_meta_lookup.min_price OR %f<wc_product_meta_lookup.max_price ) ',
                    $price_filter_var['min_price'],
                    $price_filter_var['max_price']
                );
            }
        }

        if ( ! $query->is_main_query() || is_admin() || ! is_search() || ! is_woocommerce() ) {
            return $where;
        }
        
        $where = preg_replace(
            "/\(\s*{$wpdb->posts}.post_title\s+LIKE\s*(\'[^\']+\')\s*\)/",
            "({$wpdb->posts}.post_title LIKE $1) OR (iconic_post_meta.meta_key = '_sku' AND iconic_post_meta.meta_value LIKE $1)", $where );

        return $where;
    }
    add_filter( 'posts_where', 'bodycommerce_product_search_where', 10, 2 );
}



function my_woocommerce_widget_shopping_cart_button_view_cart() {

    $minicart_place_basket_with_continue = get_bodycommerce_option('minicart_place_basket_with_continue');

    $mini_cart_view_btn_text_get = get_bodycommerce_option('mini_cart_view_btn_text');

    do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'View Basket Button Text Mini Cart', $mini_cart_view_btn_text_get );
    $mini_cart_view_btn_text = apply_filters( 'wpml_translate_single_string', $mini_cart_view_btn_text_get, 'divi-bodyshop-woocommerce', 'View Basket Button Text Mini Cart' );

    if ($minicart_place_basket_with_continue == "1") {
        $atc_pupup_continue_shopping_btn_text_get= get_bodycommerce_option('atc_pupup_continue_shopping_btn_text');
        
        do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Continue Shopping Button Text for Pop Up', $atc_pupup_continue_shopping_btn_text_get );
        $atc_pupup_continue_shopping_btn_text = apply_filters( 'wpml_translate_single_string', $atc_pupup_continue_shopping_btn_text_get, 'divi-bodyshop-woocommerce', 'Continue Shopping Button Text for Pop Up' );
        
        $atc_pupup_continue_shopping_btn_url_get= get_bodycommerce_option('atc_pupup_continue_shopping_btn_url');
        
        do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Continue Shopping Button URL for Pop Up', $atc_pupup_continue_shopping_btn_url_get );
        $atc_pupup_continue_shopping_btn_url = apply_filters( 'wpml_translate_single_string', $atc_pupup_continue_shopping_btn_url_get, 'divi-bodyshop-woocommerce', 'Continue Shopping Button URL for Pop Up' );
        
        if ($atc_pupup_continue_shopping_btn_url == "#" || $atc_pupup_continue_shopping_btn_url == "") {
            $preventdefault_css = "preventdefault";
        } else {
            $preventdefault_css = "";
        }
?>
<a onclick="location.href='<?php _e($atc_pupup_continue_shopping_btn_url,'divi_bodycommerce'); ?>'"
    data-url="<?php _e($atc_pupup_continue_shopping_btn_url,'divi_bodycommerce'); ?>"
    class="cart-link-span et_pb_button button continueshoppingminicart preventdefault"><?php _e($atc_pupup_continue_shopping_btn_text,'divi_bodycommerce'); ?></a>
<script>
jQuery(document).ready(function($) {
    $(document).on('click', '.continueshoppingminicart', function(e) {
        e.preventDefault();
        $("#bodycommerce_added_to_cart_popup").removeClass("active");
        $(".bodycommerce-minicart").removeClass('active-always');
        $(".bodycommerce-minicart").removeClass('active');
        $("body").removeClass('minicart-active');
        $("body").removeClass('slidein-minicart-active');
        $(".CartClick").removeClass('active-always');
        $(".CartClick").fadeOut();
    });
});
</script>
<?php
    } else {
        echo '<a href="' . esc_url( wc_get_cart_url() ) . '" class="et_pb_button button wc-forward">' . esc_html__( $mini_cart_view_btn_text, 'woocommerce' ) . '</a>';
    }
}


function my_woocommerce_widget_shopping_cart_proceed_to_checkout() {

    $mini_cart_checkout_btn_text_get = get_bodycommerce_option('mini_cart_checkout_btn_text');

    do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Checkout Button Text Mini Cart', $mini_cart_checkout_btn_text_get );
    $mini_cart_checkout_btn_text = apply_filters( 'wpml_translate_single_string', $mini_cart_checkout_btn_text_get, 'divi-bodyshop-woocommerce', 'Checkout Button Text Mini Cart' );

    echo '<a href="' . esc_url( wc_get_checkout_url() ) . '" class="et_pb_button button checkout wc-forward">' . esc_html__( $mini_cart_checkout_btn_text, 'woocommerce' ) . '</a>';
}
add_action( 'bodycommerce_minicart_button_text', 'my_woocommerce_widget_shopping_cart_button_view_cart', 10 );
add_action( 'bodycommerce_minicart_button_text', 'my_woocommerce_widget_shopping_cart_proceed_to_checkout', 20 );

    // get post id for vb
function bodycommerce_post_id_vb(){

    if( isset( $_REQUEST['et_post_id'] ) ){
        $post_id = absint( $_REQUEST['et_post_id'] );
    }elseif( isset( $_REQUEST['current_page']['id'] ) ){
        $post_id = absint( $_REQUEST['current_page']['id'] );
    }else{
        $post_id = false;
    }
    return $post_id;
}



// fix dynamic html not rendering on the site when using shop manager role
function bodycommerce_manager_cap() {
    $role = get_role( 'shop_manager' );
    if( '' != $role ) {
      $role->add_cap( 'unfiltered_html' );
    }
}
add_action( 'admin_init', 'bodycommerce_manager_cap');



if (get_bodycommerce_option('enable_cart_custom_icon') == "1" || get_bodycommerce_option('enable_minicart') == "1") {
    add_filter( 'et_pb_menu_module_cart_output', 'my_fancy_filter_function', 9999999 );
}

function my_fancy_filter_function( ) {
    if ( ! class_exists( 'woocommerce' ) || ! WC()->cart ) {
        return '';
    }
    $output = '<div class="bc_menu_cart">';
    $output .= do_shortcode( '[bodycommerce_cart_icon]' );
    $output .= '</div>';

    return $output;
}

// Limit Excerpt Length by number of Words
function bc_shorten_excerpt( $limit, $ending, $ending_url ) {
    $excerpt_content = strip_tags( get_the_excerpt() );
    $excerpt = explode(' ', $excerpt_content, $limit);
    $excerpt = explode(' ', $excerpt_content, $limit);
    
    if (count($excerpt)>=$limit) {
        array_pop($excerpt); 
        if ($ending_url == '') {
            $excerpt = implode(" ",$excerpt). ' ' .$ending;
        } else {
            $excerpt = implode(" ",$excerpt). ' <a href="'.$ending_url.'">'.$ending.'</a>';
        }
    } else {
        $excerpt = implode(" ",$excerpt);
    }
    $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
    
    return $excerpt;
}
// Limit Excerpt Length by number of Words
function bc_shorten_long_desc( $limit, $ending, $ending_url, $link_expand, $expand_or_link ) {
    ob_start();
    $excerpt = explode(' ', get_the_content(), $limit);

    if (count($excerpt)>=$limit) {     
        $removed = array_pop($excerpt);
        if ($link_expand == 'no') {
            $excerpt = implode(" ",$excerpt). ' ' .$ending;
            $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
            echo $excerpt;
        } else {
            if ($expand_or_link == "link") {
                $excerpt = implode(" ",$excerpt). ' <a href="'.$ending_url.'">'.$ending.'</a>';
                $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
                echo $excerpt;
            } else {
                $excerpt = implode(" ",$excerpt). ' <a class="expand-readmore" href="#">'.$ending.'</a>';
                $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
                echo $excerpt;
?>
<span class="read-more-removed">
    <?php echo $removed; ?>
</span>
<?php 
            }
        }
    } else {
        $excerpt = implode(" ",$excerpt);
        $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
        echo $excerpt;
    }
    
    return ob_get_clean();
}



// function divi_child_theme_setup() {
//     if ( ! class_exists('ET_Builder_Module') ) {
//         return;
//     }
//
//     if(is_admin()) {
//       return;
//     }
//
//     $post_id = get_the_id();
//     echo $post_id;
//
//     // if ( et_builder_bfb_enabled() || et_core_is_fb_enabled() || !et_pb_is_pagebuilder_used( $post_id ) ) {
//     //   return;
//     // }
//     $content = get_the_content( false, false, $post_id );
//     // Find all registered tag names in $content.
//     // preg_match_all( '@\[et_pb_db_([^<>&/\[\]\x00-\x20=]++)@', $content, $matches );
//     preg_match_all( '@\[([^<>&/\[\]\x00-\x20=]++)@', $content, $matches );
//     // Only need unique tag names
//     $unique_matches = array_unique( $matches[1] );
//     echo '<pre>' . print_r( $unique_matches, true ) . '</pre>';
//
//     remove_shortcode( 'et_pb_db_images' );
//
// }
//
// add_action( 'wp', 'divi_child_theme_setup', 9999 );


// global $DE_DB_WOO;
// $DE_DB_WOO = new DE_DB_WOO()

if ( !function_exists('Divi_filter_remove_get_params')) {
    add_filter( 'query_vars', 'Divi_filter_remove_get_params', 10, 1 );

    function Divi_filter_remove_get_params( $query ){
        global $divi_filter_removed_param;
        $divi_filter_removed_param = array();
        $is_search_page = false;
        if ( !empty( $_GET['filter' ] ) && $_GET['filter' ] == 'true'){
            $is_geolocation_enabled = false;
            if ( class_exists('WC_Admin_Settings') ) {
                $geolocation_setting = WC_Admin_Settings::get_option( 'woocommerce_default_customer_address', '' );

                if ( $geolocation_setting == 'geolocation_ajax') {
                    $is_geolocation_enabled = true;
                }
            }
            if ( isset( $_GET['is_search'] ) && $_GET['is_search'] == 'true' ) {
               $is_search_page = true;
            }
            foreach ($_GET as $key => $param) {
                if ( $key != 'filter'){
                    if ( ( $is_search_page == false || ( $is_search_page == true && $key != 's' ) ) && !( $is_geolocation_enabled == true && $key == 'v' ) ){
                        $divi_filter_removed_param[$key] = $param;
                        unset($_GET[$key]);
                    }
                }
            }

            $divi_filter_removed_param['filter'] = 'true';
            unset( $_GET['filter'] );
        }
        return $query;
    } 
}

if ( !function_exists('divi_bodycommerce_dynamic_css_assets_atf')) {
    /**
     * Force load module styles above the fold.
     *
     * @return array
     */
    function divi_bodycommerce_dynamic_css_assets_atf( $atf_modules ) {
        array_push( $atf_modules, 'et_pb_blog' );
        return $atf_modules;
    }
    add_filter( 'et_dynamic_assets_modules_atf', 'divi_bodycommerce_dynamic_css_assets_atf', 20 );
  }
  
  
  if ( !function_exists('divi_bodycommerce_dynamic_css_assets')) {
    /**
     * Force load module styles.
     *
     * @return array
     */
    function divi_bodycommerce_dynamic_css_assets( $modules ) {
      array_push( $modules, 'et_pb_blog' );
        return $modules;
    }
    add_filter( 'et_required_module_assets', 'divi_bodycommerce_dynamic_css_assets', 99 );
  }

/**
 * Find matching product variation
 *
 * @param $product_id
 * @param $attributes
 * @return int
 */
function find_matching_product_variation_id($product_id, $attributes)
{
    return (new \WC_Product_Data_Store_CPT())->find_matching_product_variation(
        new \WC_Product($product_id),
        $attributes
    );
}

/**
 * Clear BodyCommerce layout cache.
 *
 * @param integer $post_id Current post ID.
 * @param WP_Post $post    Current post object.
 * @param boolean $update  Current post update status.
 */
function smpl_clear_bodycommerce_layout( $post_id, $post, $update ) {
    // Bail early if current action is not update.
    if ( ! $update ) {
        return;
    }

    // Bail early if current post type is not layout.
    if ( 'et_pb_layout' !== $post->post_type ) {
        return;
    }
    
    // CHECKING START HERE
    // Collect all template: single product, shop, category, etc.
    // For example:
    //     'product'  => 12
    //     'shop'     => 5
    //     'category' => 5
    $layouts_list = array(
        'product_page_template'  => (int) get_bodycommerce_option( 'product_page_template' ),
        'archive_page_shop_template'     => (int) get_bodycommerce_option( 'archive_page_shop_template' ),
        'archive_page_category_template' => (int) get_bodycommerce_option( 'archive_page_category_template' ),
        'search_page_template'   => (int) get_bodycommerce_option( 'search_page_template' ),
        'thankyou_page_template' => (int) get_bodycommerce_option( 'thankyou_page_template' ),
        'login_page_template' => (int) get_bodycommerce_option( 'login_page_template' ),
        'login_page_lost_password' => (int) get_bodycommerce_option( 'login_page_lost_password' ),
        'login_password_reset_confirmation' => (int) get_bodycommerce_option( 'login_password_reset_confirmation' ),
        'login_page_password_reset' => (int) get_bodycommerce_option( 'login_page_password_reset' ),
        'cart_page_template' => (int) get_bodycommerce_option( 'cart_page_template' ),
        'cart_empty_page_template' => (int) get_bodycommerce_option( 'cart_empty_page_template' ),
        'checkout_custom_layout' => (int) get_bodycommerce_option( 'checkout_custom_layout' ),
        'checkout_above_inject' => (int) get_bodycommerce_option( 'checkout_above_inject' ),
        'checkout_below_inject' => (int) get_bodycommerce_option( 'checkout_below_inject' ),
        'archive_page_shop_template' => (int) get_bodycommerce_option( 'archive_page_shop_template' ),
        'archive_page_category_template' => (int) get_bodycommerce_option( 'archive_page_category_template' ),
        'tag_template' => (int) get_bodycommerce_option( 'tag_template' ),
        'attr_template' => (int) get_bodycommerce_option( 'attr_template' ),
        'my_acount_page_layout_before' => (int) get_bodycommerce_option( 'my_acount_page_layout_before' ),
        'my_acount_page_nav_layout' => (int) get_bodycommerce_option( 'my_acount_page_nav_layout' ),
        'my_acount_page_dash_layout' => (int) get_bodycommerce_option( 'my_acount_page_dash_layout' ),
        'my_acount_page_orders_layout' => (int) get_bodycommerce_option( 'my_acount_page_orders_layout' ),
        'my_account_orders_view_order' => (int) get_bodycommerce_option( 'my_account_orders_view_order' ),
        'my_acount_page_edit_account_layout' => (int) get_bodycommerce_option( 'my_acount_page_edit_account_layout' ),
        'my_acount_page_my_addresses_layout' => (int) get_bodycommerce_option( 'my_acount_page_my_addresses_layout' ),
        'my_acount_page_my_payment_details_layout' => (int) get_bodycommerce_option( 'my_acount_page_my_payment_details_layout' ),
        'my_acount_page_downloads_layout' => (int) get_bodycommerce_option( 'my_acount_page_downloads_layout' ),
        'my_acount_page_layout_after' => (int) get_bodycommerce_option( 'my_acount_page_layout_after' ),
        'order_bump_template' => (int) get_bodycommerce_option( 'order_bump_template' ),
    );

    // Flip them so the template ID will be the key, and the template name will be the value.
    // For example:
    //     5  => 'shop' // Shop and Category has the same template ID, but it's fine. We just need the number.
    //     12 => 'product'
    $layouts_list = array_flip( $layouts_list );

    // Bail early if current post is not used as templates.
    if ( ! isset( $layouts_list[ $post_id ] ) ) {
        return;
    }

    ET_Core_PageResource::remove_static_resources( 'all', 'all' );
}
add_action( 'save_post', 'smpl_clear_bodycommerce_layout', 10, 3 );

if(!function_exists('de_db_woo_plugin_action_links')){
    function de_db_woo_plugin_action_links( $links ) {
        $action_links = array(
            'settings' => '<a href="' . admin_url( 'admin.php?page=divi-bodyshop-woo-settings&tab=settings' ) . '" aria-label="' . esc_attr__( 'View Bodycommerce settings', 'divi-bodyshop-woocommerce' ) . '">' . esc_html__( 'Settings', 'divi-bodyshop-woocommerce' ) . '</a>',
        );

        return array_merge( $action_links, $links );
    }
    add_filter( 'plugin_action_links_' . DE_DB_WOO_NAME, 'de_db_woo_plugin_action_links' );
}

if ( !function_exists( 'de_get_option_value' ) ) {
    function de_get_option_value( $plugin_name, $option_name ) {
        global $deGlobalOptions;

        if ( !isset( $deGlobalOptions[ $plugin_name ] ) ) {
            $deGlobalOptions[ $plugin_name ] = maybe_unserialize( get_option( $plugin_name . '_options' ) );
        }

        return isset( $deGlobalOptions[ $plugin_name ][ $option_name ] )?$deGlobalOptions[ $plugin_name ][ $option_name ]:'';
    }
}


add_action( "in_plugin_update_message-".DE_DB_WOO_NAME, 'de_db_woo_update_message', 10, 2 );
if ( !function_exists( 'de_db_woo_update_message' ) ){

    function de_db_woo_update_message( $data, $response ) {
        if( !empty( $data['upgrade_notice'] ) ) {
            printf(
                '<div class="update-message">%s</div>',
                wpautop( $data['upgrade_notice'] )
            );
        }
    }

}

/**
 * This function runs when WordPress completes its upgrade process
 * It iterates through each plugin updated to see if ours is included
 * @param $upgrader_object Array
 * @param $options Array
 */
function wp_debc_upgrade_completed( $upgrader_object, $options ) {
    // The path to our plugin's main file
    $our_plugin = plugin_basename( __FILE__ );
    // If an update has taken place and the updated type is plugins and the plugins element exists
    if( $options['action'] == 'update' && $options['type'] == 'plugin' && isset( $options['plugins'] ) ) {
     // Iterate through the plugins being updated and check if ours is there
     foreach( $options['plugins'] as $plugin ) {
      if( $plugin == $our_plugin ) {
       // Set a transient to record that our plugin has just been updated
       set_transient( 'wp_debc_updated', 1 );
      }
     }
    }
   }
   add_action( 'upgrader_process_complete', 'wp_debc_upgrade_completed', 10, 2 );

/**
 * Show a notice to anyone who has just updated this plugin
 * This notice shouldn't display to anyone who has just installed the plugin for the first time
 */
function wp_debc_display_update_notice() {
    // Check the transient to see if we've just updated the plugin
    if( get_transient( 'wp_debc_updated' ) ) {
        ?>
        <div class="notice notice-success">
        <h3>Thanks for updating Divi BodyCommerce</h3>
       <p>We have had a few changes to our default settings. The two main ones are the account page navigation position and the default for the product loop to be a grid.</p>   
       <p>Please check the changelog here: <a href="<?php echo admin_url( 'admin.php?page=divi-bodyshop-woo-settings&tab=changelog' ) ?>">View Bodycommerce Changelog</a></p>
   </div>
       <?php 
        delete_transient( 'wp_debc_updated' );
    }
   }
   add_action( 'admin_notices', 'wp_debc_display_update_notice' );
   

    function footer_bc_js_wishlist() {
       ?>
       <script>
       var logged_in = <?php echo get_current_user_id() ?>;
   
       jQuery(document).ready(function($) {
   
           
           //Get Cookie Information
           var compare_cookie_arr = [];
           if (Cookies.get('db_compare_list')) {
               compare_cookie_arr = Cookies.get('db_compare_list');
               compare_cookie_arr = $.parseJSON(compare_cookie_arr);
               $.each(compare_cookie_arr, function(index, value) {
                   $('a[data-post_id="'+value+'"][data-wishlist_compare*="compare"]').addClass('in_wishlist');
               });
           }
   
           if (logged_in != 0) {
               
                if ( ( typeof compare_cookie_arr !== 'undefined' ) && compare_cookie_arr.length > 0 ) {
                    jQuery.ajax({           //Cookie information to Database(compare)
                       url: '<?php echo admin_url( 'admin-ajax.php' );?>',
                       data: {
                           action: 'bc_cookie_to_compare',
                           compare_cookie_arr: compare_cookie_arr,
       
                       },
                       type: 'POST',
                       // success: function() {
                       //     // location.reload();
                       // }
                   });
                }
           }
   
           // console.log('compare_cookie_arr====',compare_cookie_arr);
   
           $(document).on("click", ".add_wishlist", function(e) {
               e.preventDefault();
               e.stopPropagation();
               
               var _this = $(this),
                   adding_text = _this.attr('data-adding_text'),
                   success_text = _this.attr('data-success_text'),
                   removed_adding_text = _this.attr('data-removed_adding_text'),
                   removed_success_text = _this.attr('data-removed_success_text'),
                   button_text = _this.attr('data-button_text'),
                   added_button_text = _this.attr('data-added_button_text'),
                   wishlist_compare = $(this).attr('data-wishlist_compare'),
                   post_id = $(this).attr('data-post_id'),
                   timer_delay = $(this).attr('data-timer_delay'),
                   use_popup = $(this).attr('data-use_popup'),
                   loggedin = $(this).attr('data-loggedin');
                   account_url = $(this).attr('data-account_url');
                   // console.log(post_id);
                                   
               if ($(this).hasClass('in_wishlist')) {
                   var add_remove = 'remove';
               } else {
                   var add_remove = 'add';
               }
   
               $('.wishlist_notice').remove();
   
               // if using pop up = show notice of adding
               if (use_popup == 'on') {
                   if (add_remove == 'remove') {
                       $('#page-container').append(
                           '<div class="wishlist_notice"><div class="wishlist_inner"><p>' +
                           removed_adding_text + '</p></div></div>');
                       var success_text = removed_success_text;
                   } else {
                       $('#page-container').append(
                           '<div class="wishlist_notice"><div class="wishlist_inner"><p>' +
                           adding_text + '</p></div></div>');
                       var success_text = success_text;
                   }
                   $('.wishlist_notice').hide();
                   $('.wishlist_notice').fadeIn('slow');
               }
               
               if (loggedin == "no" && wishlist_compare == 'wishlist') {
                   window.location.href = account_url;
               } else {
   
                   var selected_ids = [];
                   
                   jQuery.ajax({
                       url: '<?php echo admin_url( 'admin-ajax.php' );?>',
                       data: {
                           action: 'bc_add_to_wishlist',
                           post_id: post_id,
                           wishlist_compare: wishlist_compare,
                           add_remove: add_remove,
                           success_text: success_text,
                       },
                       type: 'POST',
                       beforeSend: function(xhr) {
                           _this.addClass('adding_list');
                       },
                       success: function(data) {
   
                            _this.removeClass('adding_list');

                            if ( use_popup == 'on' ) {
                                if ( (typeof data.notice != 'undefined') && data.notice != '' )  {
                                    $('.wishlist_notice .wishlist_inner p').html( data.notice );
                                    setTimeout( function() {
                                        $('.wishlist_notice').fadeOut('slow');
                                    }, timer_delay);
                                } else {
                                    $('.wishlist_notice').remove();
                                }
                            }

                            if ( _this.hasClass( 'et_pb_button' ) ) {
                                if ( add_remove == 'remove' ) {
                                    _this.html( button_text );
                                } else {
                                    _this.html( added_button_text );
                                }
                            }
                            
                            // IF logged in
                            // if (data.logged_in == "yes") {
                            _this.toggleClass('in_wishlist');

                            //Set Cookie
                            $('a[class*="in_wishlist"][data-wishlist_compare="compare"]').each(function() {
                               selected_ids.push($(this).attr('data-post_id'));
                            });
                            selected_ids = JSON.stringify(selected_ids);
                            Cookies.set('db_compare_list', selected_ids, { path: '/' });
                       }
                   });
               }
           });
       });
       </script>
       <?php
    }

    if ( !function_exists('de_custom_wpkses_post_tags')) {
        function de_custom_wpkses_post_tags( $tags, $context ) {
        
            $allowed_atts = array(
                'align'      => true,
                'class'      => true,
                'type'       => true,
                'id'         => true,
                'dir'        => true,
                'lang'       => true,
                'style'      => true,
                'xml:lang'   => true,
                'src'        => true,
                'alt'        => true,
                'href'       => true,
                'rel'        => true,
                'rev'        => true,
                'target'     => true,
                'novalidate' => true,
                'type'       => true,
                'value'      => true,
                'name'       => true,
                'tabindex'   => true,
                'action'     => true,
                'method'     => true,
                'for'        => true,
                'width'      => true,
                'height'     => true,
                'data'       => true,
                'data-*'     => true,
                'title'      => true,
                'for'        => true,
                'selected'  => true,
                'name'      => true,
                'value'     => true,
                'placeholder' => true,
                'aria-label'  => true,
                'size'        => true,
                'min'        => true,
                'max'        => true,
                'inputmode'  => true,
                'autocomplete' => true
            );
        
            if ( 'post' === $context ) {
                $tags['form']     = $allowed_atts;
                $tags['label']    = $allowed_atts;
                $tags['select']   = $allowed_atts;
                $tags['option']   = $allowed_atts;
                $tags['input']    = $allowed_atts;
                $tags['textarea'] = $allowed_atts;
                $tags['iframe']   = $allowed_atts;
                $tags['script']   = $allowed_atts;
                $tags['style']    = $allowed_atts;
                $tags['strong']   = $allowed_atts;
                $tags['small']    = $allowed_atts;
                $tags['table']    = $allowed_atts;
                $tags['span']     = $allowed_atts;
                $tags['abbr']     = $allowed_atts;
                $tags['code']     = $allowed_atts;
                $tags['pre']      = $allowed_atts;
                $tags['div']      = $allowed_atts;
                $tags['img']      = $allowed_atts;
                $tags['h1']       = $allowed_atts;
                $tags['h2']       = $allowed_atts;
                $tags['h3']       = $allowed_atts;
                $tags['h4']       = $allowed_atts;
                $tags['h5']       = $allowed_atts;
                $tags['h6']       = $allowed_atts;
                $tags['ol']       = $allowed_atts;
                $tags['ul']       = $allowed_atts;
                $tags['li']       = $allowed_atts;
                $tags['em']       = $allowed_atts;
                $tags['hr']       = $allowed_atts;
                $tags['br']       = $allowed_atts;
                $tags['tr']       = $allowed_atts;
                $tags['td']       = $allowed_atts;
                $tags['p']        = $allowed_atts;
                $tags['a']        = $allowed_atts;
                $tags['b']        = $allowed_atts;
                $tags['i']        = $allowed_atts;
        
                $svg_args = array(
                    'svg'   => array(
                        'class'           => true,
                        'aria-hidden'     => true,
                        'aria-labelledby' => true,
                        'role'            => true,
                        'xmlns'           => true,
                        'width'           => true,
                        'height'          => true,
                        'viewbox'         => true, // <= Must be lower case!
                        'style'           => true
                    ),
                    'g'     => array( 
                        'fill'            => true,
                        'style'           => true
                    ),
                    'title' => array( 
                        'title'           => true,
                        'style'           => true
                    ),
                    'path'  => array( 
                        'd'               => true, 
                        'fill'            => true,
                        'style'           => true
                    ),
                    'circle' => array(
                        'cx'              => true,
                        'cy'              => true,
                        'r'               => true,
                        'fill'            => true,
                        'style'           => true
                    ),
                    'rect' => array(
                        'x'               => true,
                        'y'               => true,
                        'width'           => true,
                        'height'          => true,
                        'fill'            => true,
                        'style'           => true
                    ),
                    'polygon' => array(
                        'points'          => true,
                        'fill'            => true,
                        'style'           => true
                    ),
                    'polyline' => array(
                        'points'          => true,
                        'fill'            => true,
                        'style'           => true
                    ),
                    'line' => array(
                        'x1'              => true,
                        'y1'              => true,
                        'x2'              => true,
                        'y2'              => true,
                        'fill'            => true,
                        'style'           => true
                    ),
                    'ellipse' => array(
                        'cx'              => true,
                        'cy'              => true,
                        'rx'              => true,
                        'ry'              => true,
                        'fill'            => true,
                        'style'           => true
                    )
                );
        
                $tags = array_merge( $tags, $svg_args );
        
                $audio_args = array(
                    'audio' => array(
                        'autoplay'        => true,
                        'controls'        => true,
                        'loop'            => true,
                        'muted'           => true,
                        'preload'         => true,
                        'src'             => true,
                        'style'           => true
                    ),
                    'source' => array(
                        'src'             => true,
                        'type'            => true,
                        'style'           => true
                    )
                );
        
                $tags = array_merge( $tags, $audio_args );
        
        
            }
        
            return $tags;
        
        }
        
        add_filter( 'wp_kses_allowed_html', 'de_custom_wpkses_post_tags', 10, 2 );
        }

    // Declare compatibility with WooCommerce HPOS
    add_action( 'before_woocommerce_init', function() {
        if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
        }
    } );