<?php 
if (! defined('ABSPATH')) exit;

function bodycommerce_quickstart_notice() {
	
	global $current_user;
	
	$user_id = $current_user->ID;
	
	if (!get_user_meta($user_id, 'bodycommerce_quickstart_notice_ignore') && current_user_can( 'manage_options' )) {
		
		echo '<div class="updated notice"><p><h1>'. __('Welcome to Divi BodyCommerce!', 'divi-bodyshop-woocommerce') . '</h1>' . __('Have you seen our ', 'divi-bodyshop-woocommerce') . '<a href="https://help.diviengine.com/article/176-quickstart-guide" target="_blank"><strong>' . __('Quick Start Guide?', 'divi-bodyshop-woocommerce') . '</strong></a>' . __(' Please take a read to better understand how to use our plugin.', 'divi-bodyshop-woocommerce') . '<br> <h3>' . __('The important things to remember are:', 'divi-bodyshop-woocommerce') . ' </h3><ol>' . '<li>' . __('Do not use the Divi Builder on the WooCommerce Pages, only in the Divi Library and Theme Builder.', 'divi-bodyshop-woocommerce') . '</li>' .'<li>' . __('Disabling static css file generation. Divi > Theme Options > Builder > Advance (this can cause issues) - if using a caching plugin, it will do the same job.', 'divi-bodyshop-woocommerce') . '</li>' .'<li>' . __('Understand the custom loop layout - this is a game changer', 'divi-bodyshop-woocommerce') . '</li>' .'<li>' . __('When using our modules, only use them on the templates where they are designed for', 'divi-bodyshop-woocommerce') . '</li>' .'</ol> <br><h4>' . __('Have Fun!', 'divi-bodyshop-woocommerce') . '</h4><br> <a href="?bodycommerce-ignore-notice">Dismiss</a></p></div>';
		
	}
	
}
add_action('admin_notices', 'bodycommerce_quickstart_notice');
	
function bodycommerce_quickstart_notice_ignore() {
	
	global $current_user;
	
	$user_id = $current_user->ID;
	
	if (isset($_GET['bodycommerce-ignore-notice'])) {
		
		add_user_meta($user_id, 'bodycommerce_quickstart_notice_ignore', 'true', true);
		
	}
	
}
add_action('admin_init', 'bodycommerce_quickstart_notice_ignore');