<?php 

$enable_ajax_stock = get_bodycommerce_option( 'enable_ajax_stock', "0" );

if ($enable_ajax_stock == "1") {

function divi_bodycommerce_get_stock_staus_ajax_handler(){

  $change_to_variation_stock = esc_html( $_POST['change_selected_var'] );
  $instock_text = esc_html( $_POST['instock'] );
  $outstock_text = esc_html( $_POST['outofstock'] );
  $backorder_text = esc_html( $_POST['backorder'] );
  $left_in_text = esc_html( $_POST['left_in_text'] );
  $only_text = esc_html( $_POST['only_text'] );
  if ($only_text == "") {
    $only_text = "Only";
  }
  $hide_stock_text = esc_html( $_POST['hide_stock_text'] );
  $hide_backorder_text = esc_html( $_POST['hide_backorder_text'] );
  $hide_remaining_text = esc_html( $_POST['hide_remaining_text'] );
  $hide_number_text = esc_html( $_POST['hide_number_text'] );
  
  $product_id = esc_attr( $_POST['product_id'] );

  global $woocommerce;

  $product = wc_get_product( $product_id );
  

  if( $change_to_variation_stock == 'on' && $product->is_type( 'variable' ) ){
?>
    <div class='bodycommerce-changes-variation-stock'></div>
    <input type="hidden" id="change_stock_instock" name="change_stock_instock" value="<?php echo esc_html($instock_text) ?>">
    <input type="hidden" id="change_stock_outofstock" name="change_stock_outofstock" value="<?php echo $outstock_text ?>">
    <input type="hidden" id="change_stock_backorder" name="change_stock_backorder" value="<?php echo $backorder_text ?>">
<?php
  }

  $stock_amount = $product->get_stock_quantity();

  if ($hide_number_text == "on") {
    $getamount = "";
  } else {
  $getamount = wc_format_stock_quantity_for_display( $stock_amount, $product );
}

if ( $stock_amount <= get_option( 'woocommerce_notify_low_stock_amount' ) ) {

  if ( $getamount <= '0' && $getamount != "" && $hide_stock_text == "on" ) {
          $this->add_classname('remove-stock');
  }

}

       switch ( get_option( 'woocommerce_stock_format' ) ) {
         case 'low_amount':
           if ( $stock_amount <= get_option( 'woocommerce_notify_low_stock_amount' ) ) {
             /* translators: %s: stock amount */
             $display = sprintf( __( '<div class="stock">%s '.$instock_text.'</div>', 'woocommerce' ), $getamount );
           }
           break;
         case '':
           /* translators: %s: stock amount */
           $display = sprintf( __( '<div class="stock">%s '.$instock_text.'</div>', 'woocommerce' ), $getamount );
           break;
       }

       if ( $product->backorders_allowed() && $product->backorders_require_notification() && $hide_backorder_text != "on" ) {
         $display .= '<div class="backorders"> ' . __( $backorder_text , 'woocommerce' ) . '</div>';
       }

       if ( $product->is_in_stock() ) {
       $stock_status = $product->get_availability();
        if ( strpos( $stock_status['class'], 'available-on-backorder') !== false ) {
           $display = sprintf( __( '<div class="stock available-on-backorder">'.$backorder_text.'</div>', 'woocommerce' ) );
         } else {
         $display = sprintf( __( '<div class="stock">'.$instock_text.'</div>', 'woocommerce' ) );
       }
       }
       else {
         $display = sprintf( __( '<div class="out-of-stock">'.$outstock_text.'</div>', 'woocommerce' ) );
       }

       echo $display;

       if ( $product->get_stock_quantity() && $hide_remaining_text != "on" ) { // if manage stock is enabled
     if ( number_format($product->get_stock_quantity(),0,'','') < 3 ) { // if stock is low
     echo '<div class="remaining">' . __( $only_text , 'divi-bodycommerce' ) . ' ' . $getamount . ' ' . $left_in_text . __( "!" , 'divi-bodycommerce' ) . '</div>';
     } else {
     echo '<div class="remaining">' . $getamount . ' ' . $left_in_text . '</div>';
         }
       }

  exit;
}

add_action("wp_ajax_get_bc_stock_status", "divi_bodycommerce_get_stock_staus_ajax_handler");
add_action("wp_ajax_nopriv_get_bc_stock_status", "divi_bodycommerce_get_stock_staus_ajax_handler");

function ajax_stock_status_js() {
  ?>
  <script>
        jQuery(document).ready(function(){
          if( jQuery('.stock_status_cont').length ){
          jQuery('.stock_status_cont').addClass("loading_stock");
          jQuery.ajax({
              url: '<?php echo admin_url( 'admin-ajax.php' );?>',
              data: {
                  action: 'get_bc_stock_status',
                  product_id: jQuery('.stock_status_cont').attr('data-product_id'),
                  change_selected_var: jQuery('.stock_status_cont').attr('data-change_selected_var'),
                  instock: jQuery('.stock_status_cont').attr('data-instock'),
                  outofstock: jQuery('.stock_status_cont').attr('data-outofstock'),
                  backorder: jQuery('.stock_status_cont').attr('data-backorder'),
                  only_text: jQuery('.stock_status_cont').attr('data-only_text'),
                  left_in_text: jQuery('.stock_status_cont').attr('data-left_in_text'),
                  hide_stock_text: jQuery('.stock_status_cont').attr('data-hide_stock_text'),
                  hide_backorder_text: jQuery('.stock_status_cont').attr('data-hide_backorder_text'),
                  hide_remaining_text: jQuery('.stock_status_cont').attr('data-hide_remaining_text'),
                  hide_number_text: jQuery('.stock_status_cont').attr('data-hide_number_text'),
                  },
                  type: 'POST',
                  success: function( data ) {
                      jQuery('.stock_status_cont').html( data );
                      jQuery('.stock_status_cont').removeClass("loading_stock");
                  }
          });
        }
        });
    </script>
  <?php
}

add_action('wp_footer', 'ajax_stock_status_js');

}