<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class db_attribute_module extends ET_Builder_Module {

    public $vb_support = 'on';

    public $folder_name;
    public $text_shadow;
    public $margin_padding;
    public $_additional_fields_options;
    

    protected $module_credits = array(
        'module_uri' => DE_DB_PRODUCT_URL,
        'author'     => DE_DB_AUTHOR,
        'author_uri' => DE_DB_URL,
    );

    function init() {
        $this->name       = esc_html__( 'PL Attributes - Product Page / Loop Layout', 'divi-bodyshop-woocommerce' );
        $this->slug = 'et_pb_db_attribute';
        $this->folder_name = 'divi_bodycommerce';

        $this->settings_modal_toggles = array(
            'general' => array(
                'toggles' => array(
                   'main_settings' => esc_html__( 'Module Options', 'divi-bodyshop-woocommerce' ),
                ),
            ),
            'advanced' => array(
                'toggles' => array(
                   'text' => esc_html__( 'Text', 'divi-bodyshop-woocommerce' ),
                ),
            ),
        );


        $this->main_css_element = '%%order_class%%';

        $this->advanced_fields = array(
            'fonts' => array(
                'headings' => array(
                    'label' => esc_html__('Title', 'divi-bodyshop-woocommerce'),
                    'css' => array(
                        'main' => "{$this->main_css_element} h3",
                    ),
                    'font_size' => array('default' => '30px'),
                    'line_height' => array('default' => '1.5em'),
                ),
                'attr_text'   => array(
                    'label'    => esc_html__( 'Attribute Text', 'divi-bodyshop-woocommerce' ),
                    'css'      => array(
                        'main' => "{$this->main_css_element} .term-item",
                    ),
                    'font_size' => array(
                        'default' => '14px',
                    ),
                    'line_height' => array(
                        'default' => '1.5em',
                    ),
                ),
                'attr_prefix'   => array(
                    'label'    => esc_html__( 'Attribute Prefix', 'divi-bodyshop-woocommerce' ),
                    'css'      => array(
                        'main' => "{$this->main_css_element} .db_attribute_term_list .term-prefix",
                    ),
                    'font_size' => array(
                        'default' => '14px',
                    ),
                    'line_height' => array(
                        'default' => '1.5em',
                    ),
                ),
                'attr_suffix'   => array(
                    'label'    => esc_html__( 'Attribute Suffix', 'divi-bodyshop-woocommerce' ),
                    'css'      => array(
                        'main' => "{$this->main_css_element} .db_attribute_term_list .term-suffix",
                    ),
                    'font_size' => array(
                        'default' => '14px',
                    ),
                    'line_height' => array(
                        'default' => '1.5em',
                    ),
                ),
                'attr_whole'   => array(
                    'label'    => esc_html__( 'Whole Attribute', 'divi-bodyshop-woocommerce' ),
                    'css'      => array(
                        'main' => "{$this->main_css_element} .et_pb_module_inner",
                    ),
                    'font_size' => array(
                        'default' => '14px',
                    ),
                    'line_height' => array(
                        'default' => '1.5em',
                    ),
                ),
            ),
            'background' => array(
                'settings' => array(
                    'color' => 'alpha',
                ),
            ),
            'border' => array(),
            'custom_margin_padding' => array(
                'css' => array(
                    'important' => 'all',
                ),
            ),
        );

        $this->help_videos = array(
            array(
                'id'   => esc_html__( 'n2karNiwJ3A', 'divi-bodyshop-woocommerce' ), // YouTube video ID
                'name' => esc_html__( 'BodyCommcerce Product Page Template Guide', 'divi-bodyshop-woocommerce' ),
            ),
        );
    }

    function get_fields() {

        $attr = array();
        $attr['none'] = 'No Attribute';
        
        if ($taxonomies = get_taxonomies(false, 'objects')) {
            foreach ($taxonomies as $taxonomy) {
                if (substr($taxonomy->name, 0, 3) == 'pa_') {
                    $attr[$taxonomy->name] = $taxonomy->label;
                }
            }
        }


        $fields = array(
            'title' => array(
                'label' => __('Title', 'divi-bodyshop-woocommerce'),
                'type' => 'text',
                'option_category' => 'layout',
                'toggle_slug' => 'main_settings',
                'description' => __('If you want to include a title then use this setting and a heading will be added above the list of attributes', 'divi-bodyshop-woocommerce'),
            ),
            'prefix' => array(
                'label' => __('Prefix', 'divi-bodyshop-woocommerce'),
                'type' => 'text',
                'option_category' => 'layout',
                'toggle_slug' => 'main_settings',
                'description' => __('Text to be added immediately before the list of attributes. Can be used for lead in text or a slightly more subtle title.', 'divi-bodyshop-woocommerce'),
            ),
            'suffix' => array(
                'label' => __('Suffix', 'divi-bodyshop-woocommerce'),
                'type' => 'text',
                'option_category' => 'layout',
                'toggle_slug' => 'main_settings',
                'description' => __('Text to be added immediately after the list of attributes.', 'divi-bodyshop-woocommerce'),
            ),
            'attribute' => array(
                'label' => esc_html__('Attribute', 'divi-bodyshop-woocommerce'),
                'type' => 'select',
                'computed_affects' => array(
                    '__getattribute',
                ),
                'options' => $attr,
                'option_category' => 'layout',
                'toggle_slug' => 'main_settings',
                'default'     => 'none',
                'description' => 'Which attribute should be shown? This will display a list of attributes if the product has them. If not the module will be hidden'
            ),
            'separator' => array(
                'label' => esc_html__('Separator', 'divi-bodyshop-woocommerce'),
                'type' => 'text',
                'computed_affects' => array(
                    '__getattribute',
                ),
                'option_category' => 'layout',
                'toggle_slug' => 'main_settings',
                'description' => 'When there is more than one term to display what should separate them. Eg | or ,',
            ),
            'instock_only' => array(
                'toggle_slug' => 'main_settings',
                'label'             => esc_html__( 'Show In Stock attributes only', 'divi-bodyshop-woocommerce' ),
                'type'              => 'yes_no_button',
                'default'           => 'off',
                'options'           => array(
                    'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
                    'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
                ),
                'description'        => esc_html__( 'If you want to display in stock attributes only, enable this', 'divi-bodyshop-woocommerce' ),
            ),
            'link_attr' => array(
                'toggle_slug' => 'main_settings',
                'label'             => esc_html__( 'Link to attribute archive page', 'divi-bodyshop-woocommerce' ),
                'type'              => 'yes_no_button',
                'default'           => 'off',
                'options'           => array(
                    'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
                    'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
                ),
                'affects'           => array(
                    'link_variation'
                ),
                'description'        => esc_html__( 'If you want to link the attribute to the archive page, enable this', 'divi-bodyshop-woocommerce' ),
            ),
            'link_variation' => array(
                'toggle_slug' => 'main_settings',
                'label'             => esc_html__( 'Link to product variation page', 'divi-bodyshop-woocommerce' ),
                'type'              => 'yes_no_button',
                'default'           => 'off',
                'options'           => array(
                    'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
                    'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
                ),
                'depends_show_if'   => 'off',
                'description'        => esc_html__( 'If you want to link the product variation page, enable this', 'divi-bodyshop-woocommerce' ),
            ),
            'show_on_hover' => array(
                'toggle_slug' => 'main_settings',
                'label'             => esc_html__( 'Show on Hover only', 'divi-bodyshop-woocommerce' ),
                'type'              => 'yes_no_button',
                'default'           => 'off',
                'options'           => array(
                    'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
                    'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
                ),
                'description'        => esc_html__( 'If you want to show this module when hover on product, enable this', 'divi-bodyshop-woocommerce' ),
            ),
            'show_swatch' => array(
                'toggle_slug' => 'main_settings',
                'label'             => esc_html__( 'Show Image/Color Swatch', 'divi-bodyshop-woocommerce' ),
                'type'              => 'yes_no_button',
                'default'           => 'off',
                'options'           => array(
                    'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
                    'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
                ),
                'description'        => esc_html__( 'If you want to show the image or color of the attribute, enable this', 'divi-bodyshop-woocommerce' ),
            ),
            'color_or_image' => array(
                'toggle_slug' => 'main_settings',
                'label'             => esc_html__( 'Choose the swatch type', 'divi-bodyshop-woocommerce' ),
                'type'              => 'select',
                'default'           => 'image',
                'options'           => array(
                    'image' => esc_html__( 'Image', 'divi-bodyshop-woocommerce' ),
                    'color'  => esc_html__( 'Color', 'divi-bodyshop-woocommerce' ),
                ),
                'description'        => esc_html__( 'Choose the swatch type so we know what data to get', 'divi-bodyshop-woocommerce' ),
                'show_if' => [
                    'show_swatch' => [ 'on' ],
                ],
            ),
            'swatch_height' => array(
                'label'             => esc_html__( 'Swatch Height', 'divi-filter' ),
                'type'              => 'range',
                'option_category' => 'configuration',
                'toggle_slug'     => 'main_settings',
                'default'   => '50px',
                'show_if' => array(
                    'filter_limit' => 'on'
                ),
                'description'       => esc_html__( 'Change the height of the swatch.', 'divi-filter' ),
                'show_if' => [
                    'show_swatch' => [ 'on' ],
                ],
            ),
            'swatch_width' => array(
                'label'             => esc_html__( 'Swatch Width', 'divi-filter' ),
                'type'              => 'range',
                'option_category' => 'configuration',
                'toggle_slug'     => 'main_settings',
                'default'   => '50px',
                'show_if' => array(
                    'filter_limit' => 'on'
                ),
                'description'       => esc_html__( 'Change the width of the swatch.', 'divi-filter' ),
                'show_if' => [
                    'show_swatch' => [ 'on' ],
                ],
            ),
            'swatch_radius' => array(
                'label'             => esc_html__( 'Swatch Border Radius', 'divi-filter' ),
                'type'              => 'range',
                'option_category' => 'configuration',
                'toggle_slug'     => 'main_settings',
                'default'   => '0',
                'show_if' => array(
                    'filter_limit' => 'on'
                ),
                'description'       => esc_html__( 'Change the border radius.', 'divi-filter' ),
                'show_if' => [
                    'show_swatch' => [ 'on' ],
                ],
            ),
            'swatch_postition' => array(
                'toggle_slug' => 'main_settings',
                'label'             => esc_html__( 'Swatch Position', 'divi-bodyshop-woocommerce' ),
                'type'              => 'select',
                'default'           => 'above',
                'options'           => array(
                    'above' => esc_html__( 'Above Name', 'divi-bodyshop-woocommerce' ),
                    'below'  => esc_html__( 'Below Name', 'divi-bodyshop-woocommerce' ),
                    'none'  => esc_html__( 'Remove Name', 'divi-bodyshop-woocommerce' ),
                ),
                'description'        => esc_html__( 'Choose where you want the swatch to appear or remove the name and just have the swatch', 'divi-bodyshop-woocommerce' ),
                'show_if' => [
                    'show_swatch' => [ 'on' ],
                ],
            ),
            '__getattribute' => array(
                'type' => 'computed',
                'computed_callback' => array( 'db_attribute_module', 'get_attribute' ),
                'computed_depends_on' => array(
                    'attribute'
                ),
            ),
        );

        return $fields;
    }


    public static function get_attribute ( $args = array(), $conditional_tags = array(), $current_page = array() ){
        if (!is_admin()) {
            return;
        }
        
        ob_start();
        // if $args['separator'] is undefined, set $separator to nothing
        $separator = isset($args['separator']) ? $separator : '';

        if ($taxonomies = get_taxonomies(false, 'objects')) {
            $first_att = true;
            foreach ($taxonomies as $taxonomy) {
                if ( $first_att )  {
                    if (substr($taxonomy->name, 0, 3) == 'pa_') {
                        $first_attribute = $taxonomy->name;
                        $first_att = false;
                    }
                } else {
                    $first_attribute = "";
                }
            }
        }

        $attribute = $first_attribute;

        $args = array(
            'post_type' => 'product',
            'post_status' => 'publish',
            'posts_per_page' => '3',
            'orderby' => 'ID',
            'order' => 'ASC',
        );

        $loop = new WP_Query( $args );

        $first = true;
        
        while ( $loop->have_posts() ) : $loop->the_post();

            if ( $first )  {
    
                //*---------------------------------------------------------------------------------------------------*//
                $product_terms = wp_get_object_terms(get_the_ID(), $attribute);
                $term_array = array();

                if (!empty($product_terms)) {
                    if (!is_wp_error($product_terms)) {
                        foreach ($product_terms as $term) {
                            $term_array[] = '<span class="term-item">' . $term->name . '</span>';
                        }
                    }
                } else {
                    if ($attr2 = get_post_meta(get_the_ID(), '_product_attributes', true)) {
                        $no_pa = substr($attribute, 3);
                        if (isset($attr2[$no_pa]['value'])) {
                            if ($attr3 = $attr2[$no_pa]['value']) {
                                $term_array[] = '<span class="term-item">' . $attr3 . '</span>';
                            }
                        }
                    }
                }

                //////////////////////////////////////////////////////
                $content = "";

                if (count($term_array) > 0) {

                    $content .= '<span class="db_attribute_term_list">';

                    $content .= implode($separator, $term_array);
                    $content .= '</span>';

                    return $content;
                }

                //*---------------------------------------------------------------------------------------------------*//

                $first = false;
            } else {
            }
    
        endwhile; wp_reset_query(); // Remember to reset


        $data = ob_get_clean();

        return $data;
    }


                
    function render( $attrs, $content, $render_slug ) {
        if ( is_admin() && ( ! defined( 'DOING_AJAX' ) || ! DOING_AJAX ) ) {
            return;
        }

        $title = $this->props['title'];
        $prefix = $this->props['prefix'];
        $suffix = $this->props['suffix'];
        $attribute = $this->props['attribute'];
        $separator = $this->props['separator'];
        $link_attr = $this->props['link_attr'];
        $instock_only = $this->props['instock_only'];
        $link_variation = $this->props['link_variation'];
        $show_on_hover = $this->props['show_on_hover'];

        $show_swatch = $this->props['show_swatch'];
        $color_or_image = $this->props['color_or_image'];
        
        $swatch_height = $this->props['swatch_height'];
        $swatch_width = $this->props['swatch_width'];
        $swatch_postition = $this->props['swatch_postition'];
        $swatch_radius = $this->props['swatch_radius'];
        
        // Module classnames
        $this->add_classname(
            array(
                'clearfix',
                $this->get_text_orientation_classname(),
            )
        );
                    
        if ( $swatch_postition == "none" ) {
            ET_Builder_Element::set_style( $render_slug, array(
                'selector'    => '%%order_class%% .attribute_name',
                'declaration' => "display:none;"
            ) );
        } else if ( $swatch_postition == "below" ) {
            ET_Builder_Element::set_style( $render_slug, array(
                'selector'    => '%%order_class%% .attribute_cont',
                'declaration' => "flex-direction: column-reverse;"
            ) );
        } else {
            ET_Builder_Element::set_style( $render_slug, array(
                'selector'    => '%%order_class%% .attribute_cont',
                'declaration' => "flex-direction: column;"
            ) );
        }


        //////////////////////////////////////////////////////////////////////


        ob_start();

        global $product;
        if (isset($product)) {

            if ( is_a( $product, 'WC_Product_Variation') ) {
                $term_name = $product->get_attribute( $attribute );
                if ( !is_array( $term_name ) && $term_name != '' ) {
                    $product_terms[] = get_term_by('name', $term_name, $attribute); //array( $product_terms );
                } else {
                    $product_terms = array();
                }
            } else {
                $product_id = $product->get_id();
                $product_terms = wp_get_object_terms($product_id, $attribute);    
            }
        }else{
            $product_terms=get_terms( $attribute);
        }


        $term_array = array();
        $attrs_array = []; // Initializing

        if ( $show_on_hover == 'on' ) {
            $this->add_classname('show_onhover');
        }

        $added_terms = array();

        if ( $instock_only == 'on' ) {
            if ( $product->is_type('variable') ) {
                $product_terms = array();
                // Loop through available variation Ids for the variable product
                foreach( $product->get_children() as $child_id ) {
                    $variation = wc_get_product( $child_id ); // Get the WC_Product_Variation object

                    if( $variation->is_purchasable() && $variation->is_in_stock() ) {
                        $term_name = $variation->get_attribute( $attribute );

                        if ( !in_array( $term_name, $added_terms ) ) {
                            $product_terms[] = get_term_by('name', $term_name, $attribute);
                            $added_terms[] = $term_name;
                        }
                    }
                }
            }     
        }

        if (!empty($product_terms)) {
            if (!is_wp_error($product_terms)) {
                foreach ($product_terms as $term) {
                    if ($show_swatch == "on" && $color_or_image == "image") {
                        $image_url = get_term_meta( $term->term_id, 'product_attribute_image', TRUE );
                        $swatch = '<span class="attribute_swatch_image"><img src=" ' . $image_url . '" style="height: ' . $swatch_height . '; width: '. $swatch_width . ';border-radius:'.$swatch_radius.';"></span>';
                    } else if ($show_swatch == "on" && $color_or_image == "color") {
                        $color = get_term_meta( $term->term_id, 'product_attribute_color', TRUE );
                        $swatch = '<span class="attribute_swatch_color" style="background-color: ' . $color . ';height: ' . $swatch_height . '; width: '. $swatch_width . ';border-radius:'.$swatch_radius.';"></span>';
                    } else {
                        $swatch = "";
                    }

                    $archive_link = get_term_link( $term->slug, $attribute );
                    if($link_attr == "on") {
                        $term_array[] = '<span class="term-item"><a class="attribute_cont" href="' . $archive_link. '"> ' .  $swatch . ' <span class="attribute_name">' . $term->name . '</span></a></span>';
                    } else {
                        if ( $link_variation == 'on' ) {
                            $the_link = '';
                            if ( $product->is_type('variable') ) {
                                // Loop through available variation Ids for the variable product
                                foreach( $product->get_children() as $child_id ) {
                                    $variation = wc_get_product( $child_id ); // Get the WC_Product_Variation object

                                    if( $variation->is_purchasable() && $variation->is_in_stock() ) {
                                        $term_name = $variation->get_attribute( $attribute );
                                        if ( $term_name == $term->name ) {
                                            $the_link = get_permalink( $child_id );
                                            break;
                                        }
                                    }
                                }
                            }
                            if ( $the_link != '' ) {
                                $term_array[] = '<span class="term-item"><a class="attribute_cont" href="' . $the_link. '"> ' .  $swatch . ' <span class="attribute_name">' . $term->name . '</span></a></span>';
                            } else {
                                $term_array[] = '<span class="term-item"><span class="attribute_cont"> ' .  $swatch . ' <span class="attribute_name">' . $term->name . '</span></span></span>';
                            }
                        } else {
                            $term_array[] = '<span class="term-item"><span class="attribute_cont"> ' .  $swatch . ' <span class="attribute_name">' . $term->name . '</span></span></span>';    
                        }
                        
                    }
                }
            }
        } else {
            if ($attr2 = get_post_meta(get_the_ID(), '_product_attributes', true)) {
                $no_pa = substr($attribute, 3);

                if (isset($attr2[$no_pa]['value'])) {
                    if ($attr3 = $attr2[$no_pa]['value']) {
                        $term_array[] = '<span class="term-item">' . $attr3 . '</span>';
                    }
                }
            } else {

                if ( is_page() ) {

                    $all_attributes = get_terms( $attribute, array(
                        'hide_empty' => false,
                    ) );

                    foreach ($all_attributes as $attr) {

                        if ($show_swatch == "on" && $color_or_image == "image") {
                            $image_url = get_term_meta( $attr->term_id, 'product_attribute_image', TRUE );
                            $swatch = '<span class="attribute_swatch_image"><img src=" ' . $image_url . '" style="height: ' . $swatch_height . '; width: '. $swatch_width . ';border-radius:'.$swatch_radius.';"></span>';
                        } else if ($show_swatch == "on" && $color_or_image == "color") {
                            $color = get_term_meta( $attr->term_id, 'product_attribute_color', TRUE );
                            $swatch = '<span class="attribute_swatch_color" style="background-color: ' . $color . ';height: ' . $swatch_height . '; width: '. $swatch_width . ';border-radius:'.$swatch_radius.';"></span>';
                        } else {
                            $swatch = "";
                        }

                        $archive_link = get_term_link( $attr->slug, $attribute );
                        if($link_attr == "on") {
                            $term_array[] = '<span class="term-item"><a class="attribute_cont" href="' . $archive_link. '"> ' .  $swatch . ' <span class="attribute_name">' . $attr->name . '</span></a></span>';
                        } else {
                            $term_array[] = '<span class="term-item"><span class="attribute_cont"> ' .  $swatch . ' <span class="attribute_name">' . $attr->name . '</span></span></span>';
                        }
                    }
                }
            }
        }

        //////////////////////////////////////////////////////

        if (count($term_array) > 0) {
            if ($title) {
                $content .= '<h3>' . $title . '</h3>';
            }

            $content .= '<span class="db_attribute_term_list">';

            if ($prefix) {
                $content .= '<span class="term-prefix">' . $prefix . '</span> ';
            }

            $content .= implode($separator, $term_array);

            if ($suffix) {
                $content .= '<span class="term-suffix">' . $suffix . '</span> ';
            }

            $content .= '</span>';
        } else {
            $this->add_classname('empty');
        }


        echo $content;

        $data = ob_get_clean();
        //////////////////////////////////////////////////////////////////////
        return $data;

    }
}

new db_attribute_module;

?>
