<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class db_shop_cat_loop_code extends ET_Builder_Module {
  public $vb_support = 'on';

  public $folder_name;
  public $fields_defaults;
  public $text_shadow;
  public $margin_padding;
  public $_additional_fields_options;

  protected $module_credits = array(
    'module_uri' => DE_DB_PRODUCT_URL,
    'author'     => DE_DB_AUTHOR,
    'author_uri' => DE_DB_URL,
  );

  function init() {
    $this->name       = esc_html__( 'ARP Category Loop - Archive Pages', 'divi-bodyshop-woocommerce' );
    $this->slug = 'et_pb_db_shop_cat_loop';
    $this->folder_name = 'divi_bodycommerce';

    $this->fields_defaults = array(
      'loop_layout'         => array( 'on' ),
      'fullwidth'         => array( 'on' ),
      'columns'         => array( '3' ),
      'show_pagination'   => array( 'on' ),
      'cat_order'   => array( '1' ),
      'hide_empty'   => array( 'on' ),
      'column_style'   => array( 'text-ontop' ),
    );

    $this->settings_modal_toggles = array(
      'general' => array(
        'toggles' => array(
          'main_content' => esc_html__( 'Module Options', 'divi-bodyshop-woocommerce' ),
        ),
      ),
      'advanced' => array(
        'toggles' => array(
          'overlay' => esc_html__( 'Overlay', 'divi-bodyshop-woocommerce' ),
          'image'   => esc_html__( 'Image', 'divi-bodyshop-woocommerce' ),
        ),
      ),
    );

    $this->main_css_element = '%%order_class%%';
    $this->advanced_fields = array(
      'fonts' => array(
        'text'   => array(
          'label'    => esc_html__( 'Title', 'divi-bodyshop-woocommerce' ),
          'css'      => array(
            'main' => "{$this->main_css_element} .cat_title, .woocommerce {$this->main_css_element} ul.products li.product .cat_title, .woocommerce-page ul.products li.product .cat_title, .woocommerce-page.et-db #et-boc .et-l {$this->main_css_element} ul.products li.product .cat_title", 'important' => 'all',
          ),
          'font_size' => array('default' => '14px'),
          'line_height'    => array('default' => '1.5em'),
        ),
        'active_title'   => array(
          'label'    => esc_html__( 'Active Title', 'divi-bodyshop-woocommerce' ),
          'css'      => array(
            'main' => "{$this->main_css_element} .active-category .cat_title, .woocommerce {$this->main_css_element} ul.products li.product.active-category .cat_title, .woocommerce-page ul.products li.product.active-category .cat_title, .woocommerce-page.et-db #et-boc .et-l {$this->main_css_element} ul.products li.product.active-category .cat_title", 'important' => 'all',
          ),
          'font_size' => array('default' => '14px'),
          'line_height'    => array('default' => '1.5em'),
        ),
        'description'   => array(
          'label'    => esc_html__( 'Description', 'divi-bodyshop-woocommerce' ),
          'css'      => array(
            'main' => "{$this->main_css_element} .cat_desc",
            'important' => 'all',
          ),
          'font_size' => array('default' => '14px'),
          'line_height'    => array('default' => '1.5em'),
        ),
      ),
      'background' => array(
        'settings' => array(
          'color' => 'alpha',
        ),
      ),
			'box_shadow'     => array(
        'default' => array(
            'label' => esc_html__( 'All Box Shadow', 'divi-bodyshop-woocommerce' ),
            'css' => array(
                'main' => "%%order_class%%",
                'important' => 'plugin_only',
            ),
        ),
        'category_cards' => array(
            'label' => esc_html__( 'Individual Categories Box Shadow', 'divi-bodyshop-woocommerce' ),
            'css' => array(
                'main' => "%%order_class%% .et_pb_db_cat_column",
                'important' => 'plugin_only',
            ),
        ),
			),
			'borders'        => array(
				'default' => array(
					'css'          => array(
						'main'      => array(
							'border_radii'  => sprintf( '%1$s', $this->main_css_element ),
							'border_styles' => sprintf( '%1$s', $this->main_css_element ),
						),
						'important' => 'plugin_only',
					),
					'label_prefix' => esc_html__( 'All', 'et_builder' ),
				),
				'cards' => array(
					'css'          => array(
						'main'      => array(
							'border_radii'  => sprintf( '%1$s .et_pb_db_cat_column', $this->main_css_element ),
							'border_styles' => sprintf( '%1$s .et_pb_db_cat_column', $this->main_css_element ),
						),
						'important' => 'plugin_only',
					),
					'label_prefix' => esc_html__( 'Individual Categories', 'et_builder' ),
				),
			),
      'custom_margin_padding' => array(
        'css' => array(
          'important' => 'all',
        ),
      ),
    );

    $this->help_videos = array(
      array(
        'id'   => esc_html__( 'n2karNiwJ3A', 'divi-bodyshop-woocommerce' ), // YouTube video ID
        'name' => esc_html__( 'BodyCommcerce Product Page Template Guide', 'divi-bodyshop-woocommerce' ),
      ),
    );
  }


  function get_fields() {
    
    $looplayout_options = DEBC_INIT::get_divi_layouts();

    $fields = array(
      'layout_style' => array(
        'toggle_slug'       => 'main_content',
        'label'             => esc_html__( 'Layout Style', 'divi-machine' ),
        'type'              => 'select',
        'options'           => array(
        'default'  => esc_html__( 'Default', 'divi-machine' ),
        'loop' => esc_html__( 'Loop Layout', 'divi-machine' ),
        ),
        'option_category'   => 'layout',
        'default'           => 'default',
        'description'       => esc_html__( 'Default will show the title, description and image for you. If you want to use a loop layout = choose this', 'divi-machine' ),
        'computed_affects' => array(
          '__getcategoryarchive',
        ),
      ),
      'loop_layout' => array(
        'label'             => esc_html__('Loop Layout', 'divi-machine'),
        'type'              => 'select',
        'option_category'   => 'layout',
        'toggle_slug'       => 'main_content',
        'default'           => 'none',
        'show_if'   => array('layout_style' => 'loop'),
        'options'           => $looplayout_options,
        'description'        => esc_html__('Choose the layout you have made for each category.', 'divi-machine'),
      ),
      'fullwidth' => array(
        'label'             => esc_html__( 'Layout', 'divi-bodyshop-woocommerce' ),
        'type'              => 'select',
        'computed_affects' => array(
          '__getcategoryarchive',
        ),
        'option_category'   => 'layout',
        'options'           => array(
          'list'  => esc_html__( 'List', 'divi-bodyshop-woocommerce' ),
          'off' => esc_html__( 'Grid', 'divi-bodyshop-woocommerce' ),
        ),
        'affects'=>array(
          'columns',
          'columns_tablet',
          'columns_mobile',
          'column_style',
          'hover_icon',
          'zoom_icon_color',
          'hover_overlay_color',
        ),
        'default'           => 'list',
        'description'        => esc_html__( 'Choose if you want it displayed as a list or a grid layout', 'divi-bodyshop-woocommerce' ),
        'toggle_slug'       => 'main_content',
      ),
      'show_all_cat' => array(
        'label'             => esc_html__( 'Show all categories', 'divi-bodyshop-woocommerce' ),
        'type'              => 'yes_no_button',
        'option_category'   => 'layout',
        'options'           => array(
          'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
          'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
        ),
        'description' => esc_html__( 'If on a category page, it will show the categories in that particular category. If you want to show ALL of them, enable this.', 'divi-bodyshop-woocommerce' ),
        'toggle_slug'       => 'main_content',
      ),
      'include_cats' => array(
        'toggle_slug'       => 'main_content',
        'label'           => esc_html__( 'Include Categories (ID)(comma-seperated)', 'divi-bodyshop-woocommerce' ),
        'type'            => 'text',
        'description'     => esc_html__( 'If you want to include some categories, add the IDs here. (comma-seperated)', 'divi-bodyshop-woocommerce' ),
      ),
      'exclude_cats' => array(
        'toggle_slug'       => 'main_content',
        'label'           => esc_html__( 'Exclude Categories (ID)(comma-seperated)', 'divi-bodyshop-woocommerce' ),
        'type'            => 'text',
        'description'     => esc_html__( 'If you want to exclude some categories, add the IDs here. (comma-seperated)', 'divi-bodyshop-woocommerce' ),
      ),
      'hide_empty' => array(
        'label'             => esc_html__( 'Hide Empty Categories?', 'divi-bodyshop-woocommerce' ),
        'type'              => 'yes_no_button',
        'option_category'   => 'layout',
        'options'           => array(
          'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
          'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
        ),
        'description' => esc_html__( 'If you want to hide empty categories, enable this.', 'divi-bodyshop-woocommerce' ),
        'toggle_slug'       => 'main_content',
      ),

      'is_loop_layout' => array(
        'label'             => esc_html__( 'Is in loop layout?', 'divi-bodyshop-woocommerce' ),
        'type'              => 'yes_no_button',
        'option_category'   => 'layout',
        'options'           => array(
          'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
          'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
        ),
        'description' => esc_html__( 'If you want to only show the categories that are assigned to this post and using it inside a custom loop layout, enable this.', 'divi-machine' ),
        'toggle_slug'       => 'main_content',
      ),


      'show_count' => array(
        'label'             => esc_html__( 'Show Product Count?', 'divi-bodyshop-woocommerce' ),
        'type'              => 'yes_no_button',
        'option_category'   => 'layout',
        'options'           => array(
          'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
          'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
        ),
        'default'           => 'off',
        'description' => esc_html__( 'Enable this if you want to show the product count in brackets next to the title.', 'divi-bodyshop-woocommerce' ),
        'toggle_slug'       => 'main_content',
      ),
      'hide_images' => array(
        'label'             => esc_html__( 'Hide Category Images', 'divi-bodyshop-woocommerce' ),
        'type'              => 'yes_no_button',
        'option_category'   => 'layout',
        'options'           => array(
          'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
          'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
        ),
        'description' => esc_html__( 'If you want to hide the category images, enable this.', 'divi-bodyshop-woocommerce' ),
        'toggle_slug'       => 'main_content',
      ),
      'back_to_shop' => array(
        'label'             => esc_html__( 'Back to Shop Link', 'divi-bodyshop-woocommerce' ),
        'type'              => 'yes_no_button',
        'option_category'   => 'layout',
        'options'           => array(
          'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
          'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
        ),
        'affects'=>array(
          'back_to_shop_text',
          'back_to_shop_image',
          'back_to_shop_position'
        ),
        'description' => esc_html__( 'If you want a button that will take them back to the shop, or to the main page where all the categories are, enable this.', 'divi-bodyshop-woocommerce' ),
        'toggle_slug'       => 'main_content',
      ),
      'back_to_shop_text' => array(
        'option_category'   => 'layout',
        'label'             => esc_html__( 'Back to shop text', 'divi-bodyshop-woocommerce' ),
        'type'              => 'text',
        'depends_show_if'   => 'on',
        'toggle_slug'       => 'main_content',
        'default'           => 'All',
        'description'       => esc_html__( 'Choose what you want the text to say', 'divi-bodyshop-woocommerce' ),
      ),
      'back_to_shop_image' => array(
        'label'              => esc_html__( 'Back to shop Image', 'et_builder' ),
        'type'               => 'upload',
        'option_category'   => 'layout',
        'toggle_slug'       => 'main_content',
        'depends_show_if'   => 'on',
        'upload_button_text' => esc_attr__( 'Upload an image', 'et_builder' ),
        'choose_text'        => esc_attr__( 'Choose an Image', 'et_builder' ),
        'update_text'        => esc_attr__( 'Set As Image', 'et_builder' ),
        'affects'            => array(
          'alt',
        ),
        'description'        => esc_html__( 'Upload the image for the back to shop category item, if you do not set it, we wont show the image', 'et_builder' ),
      ),
      'back_to_shop_position' => array(
        'label'             => esc_html__( 'Back to shop position', 'divi-bodyshop-woocommerce' ),
        'type'              => 'select',
        'option_category'   => 'layout',
        'toggle_slug'       => 'main_content',
        'options'           => array(
          'start'  => esc_html__( 'Start of category list', 'divi-bodyshop-woocommerce' ),
          'end' => esc_html__( 'End of category list', 'divi-bodyshop-woocommerce' ),
        ),
        'default'           => 'start',
        'depends_show_if' => 'on',
        'description'        => esc_html__( 'Choose where you want the link to appear on the category list', 'divi-bodyshop-woocommerce' ),
      ),
      'column_style' => array(
        'label'             => esc_html__( 'Column Style', 'divi-bodyshop-woocommerce' ),
        'type'              => 'select',
        'computed_affects' => array(
          '__getcategoryarchive',
        ),
        'option_category'   => 'layout',
        'options'           => array(
          'text-ontop'  => esc_html__( 'Title Above Image', 'divi-bodyshop-woocommerce' ),
          'text-appeartop'  => esc_html__( 'Title On Top Image', 'divi-bodyshop-woocommerce' ),
          'text-below' => esc_html__( 'Title Below Image', 'divi-bodyshop-woocommerce' ),
        ),
        'affects'            => array(
          'tile_hover_not',
        ),
        'depends_show_if' => 'off',
        'description'        => esc_html__( 'Choose the style of the grid layout', 'divi-bodyshop-woocommerce' ),
        'toggle_slug'       => 'main_content',
      ),
      'tile_hover_not' => array(
        'label'             => esc_html__( 'Show Title on Hover?', 'divi-bodyshop-woocommerce' ),
        'type'              => 'yes_no_button',
        'option_category'   => 'layout',
        'options'           => array(
          'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
          'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
        ),
        'default'           => 'on',
        'depends_show_if' => 'text-appeartop',
        'description' => esc_html__( 'If you want to hide empty categories, enable this.', 'divi-bodyshop-woocommerce' ),
        'toggle_slug'       => 'main_content',
      ),
      'columns' => array(
        'label'             => esc_html__( 'Grid Columns', 'divi-bodyshop-woocommerce' ),
        'type'              => 'select',
        'computed_affects' => array(
          '__getcategoryarchive',
        ),
        'option_category'   => 'layout',
        'options'           => array(
          1  => esc_html__( 'One', 'divi-bodyshop-woocommerce' ),
          2  => esc_html__( 'Two', 'divi-bodyshop-woocommerce' ),
          3 => esc_html__( 'Three', 'divi-bodyshop-woocommerce' ),
          4 => esc_html__( 'Four', 'divi-bodyshop-woocommerce' ),
          5 => esc_html__( 'Five', 'divi-bodyshop-woocommerce' ),
          6 => esc_html__( 'Six', 'divi-bodyshop-woocommerce' ),
        ),
        'depends_show_if' => 'off',
        'description'        => esc_html__( 'How many columns do you want to see', 'divi-bodyshop-woocommerce' ),
        'toggle_slug'       => 'main_content',
      ),
      'columns_tablet' => array(
        'label'             => esc_html__( 'Tablet Grid Columns', 'divi-bodyshop-woocommerce' ),
        'type'              => 'select',
        'option_category'   => 'layout',
        'toggle_slug'       => 'main_content',
        'default'   => '2',
        'options'           => array(
          1  => esc_html__( 'One', 'divi-bodyshop-woocommerce' ),
          2  => esc_html__( 'Two', 'divi-bodyshop-woocommerce' ),
          3 => esc_html__( 'Three', 'divi-bodyshop-woocommerce' ),
          4 => esc_html__( 'Four', 'divi-bodyshop-woocommerce' ),
        ),
        'depends_show_if' => 'off',
        'description'        => esc_html__( 'How many columns do you want to see on tablet', 'divi-bodyshop-woocommerce' ),
      ),
      'columns_mobile' => array(
        'label'             => esc_html__( 'Mobile Grid Columns', 'divi-bodyshop-woocommerce' ),
        'type'              => 'select',
        'option_category'   => 'layout',
        'toggle_slug'       => 'main_content',
        'default'   => '1',
        'options'           => array(
          1  => esc_html__( 'One', 'divi-bodyshop-woocommerce' ),
          2  => esc_html__( 'Two', 'divi-bodyshop-woocommerce' ),
        ),
        'depends_show_if' => 'off',
        'description'        => esc_html__( 'How many columns do you want to see on mobile', 'divi-bodyshop-woocommerce' ),
      ),
      'text_orientation' => array(
        'label'             => esc_html__( 'Text Orientation', 'divi-bodyshop-woocommerce' ),
        'type'              => 'select',
        'option_category'   => 'layout',
        'options'           => et_builder_get_text_orientation_options(),
        'description'       => esc_html__( 'This controls the how your text is aligned within the module.', 'divi-bodyshop-woocommerce' ),
        'toggle_slug'       => 'main_content',
      ),
      'hide_description' => array(
        'label'             => esc_html__( 'Hide Descriptions', 'divi-bodyshop-woocommerce' ),
        'type'              => 'yes_no_button',
        'options'           => array(
          "off"  => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
          "on" => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
        ),
        'description'        => esc_html__( 'If you want to only show the title and image and hide the descriptions, check this.', 'divi-bodyshop-woocommerce' ),
        'toggle_slug'       => 'main_content',
      ),
      'hide_title' => array(
      'label'             => esc_html__( 'Hide Titles', 'divi-machine' ),
      'type'              => 'yes_no_button',
      'options'           => array(
      "off"  => esc_html__( 'No', 'divi-machine' ),
      "on" => esc_html__( 'Yes', 'divi-machine' ),
      ),
      'default'     => 'off',
      'description'        => esc_html__( 'If you want to only show the image and hide the titles, check this.', 'divi-bodyshop-woocommerce' ),
      'toggle_slug'       => 'main_content',
      ),
      'title_tag'      => array(
          'label'       => __('Title HTML Tag', 'et_builder'),
          'type'        => 'select',
          'options'     => array(
              "h1" => "h1",
              "h2" => "h2",
              "h3" => "h3",
              "h4" => "h4",
              "h5" => "h5",
              "h6" => "h6",
              "p"  => "p",
          ),
          'default'     => 'h3',
          'computed_affects' => array(
            '__getcategoryarchive',
          ),
          'show_if' => array('hide_title' => 'off'),
          'toggle_slug'       => 'main_content',
          'description' => __('Set the title tag. For example you may want it to be h2 or h4.', 'et_builder'),
      ),
      'cat_order' => array(
        'label'             => esc_html__( 'Category Orderby', 'divi-bodyshop-woocommerce' ),
        'type'              => 'select',
        'computed_affects' => array(
          '__getcategoryarchive',
        ),
        'options'           => array(
          "1"  => esc_html__( 'Name', 'divi-bodyshop-woocommerce' ),
          "2" => esc_html__( 'Category Order', 'divi-bodyshop-woocommerce' ),
        ),
        'description'        => esc_html__( 'Select how you want the categories ordered.', 'divi-bodyshop-woocommerce' ),
        'toggle_slug'       => 'main_content',
      ),
      'zoom_icon_color' => array(
        'label'             => esc_html__( 'Zoom Icon Color', 'divi-bodyshop-woocommerce' ),
        'type'              => 'color-alpha',
        'custom_color'      => true,
        'depends_show_if'   => 'off',
        'tab_slug'          => 'advanced',
        'toggle_slug'       => 'overlay',
      ),
      'hover_overlay_color' => array(
        'label'             => esc_html__( 'Hover Overlay Color', 'divi-bodyshop-woocommerce' ),
        'type'              => 'color-alpha',
        'custom_color'      => true,
        'depends_show_if'   => 'off',
        'tab_slug'          => 'advanced',
        'toggle_slug'       => 'overlay',
      ),
      'hover_icon' => array(
        'label'               => esc_html__( 'Hover Icon Picker', 'divi-bodyshop-woocommerce' ),
        'type'                => 'text',
        'option_category'     => 'configuration',
        'class'               => array( 'et-pb-font-icon' ),
        'renderer'            => 'select_icon',
        'renderer_with_field' => true,
        'depends_show_if'     => 'off',
        'tab_slug'          => 'advanced',
        'toggle_slug'       => 'overlay',
      ),
      '__getcategoryarchive' => array(
        'type' => 'computed',
        'computed_callback' => array( 'db_shop_cat_loop_code', 'get_cat_archive' ),
        'computed_depends_on' => array(
          'fullwidth',
          'column_style',
          'columns',
          'cat_order'
        ),
      ),
      'category_padding'          => array(
        'label'           => esc_html__( 'Individual Categories Padding', 'divi-bodyshop-woocommerce' ),
        'type'           => 'custom_padding',
        'description'     => esc_html__( 'Set padding for each individual category', 'divi-bodyshop-woocommerce' ),
        'default_unit' => 'px',
        'validate_unit' => true,
        'tab_slug'        => 'advanced',
        'toggle_slug'     => 'margin_padding',
        'mobile_options'  => true,
      ),
      'category_margin'          => array(
        'label'           => esc_html__( 'Individual Categories Margin', 'divi-bodyshop-woocommerce' ),
        'type'           => 'custom_margin',
        'description'     => esc_html__( 'Set margin for each individual category', 'divi-bodyshop-woocommerce' ),
        'default_unit' => 'px',
        'validate_unit' => true,
        'tab_slug'        => 'advanced',
        'toggle_slug'     => 'margin_padding',
        'mobile_options'  => true,
    ),
    );
    return $fields;
  }


  public static function get_cat_archive ( $args = array(), $conditional_tags = array(), $current_page = array() ){
    


    ob_start();

    $column_style           = $args['column_style'];
    $title_tag           = $args['title_tag'] ?: 'h3';
    
    $fullwidth           = $args['fullwidth'];
    $cols                   = $args['columns'];
    $columns_tablet         = isset($args['columns_tablet'])?$args['columns_tablet']:1;
    $columns_mobile         = isset($args['columns_mobile'])?$args['columns_mobile']:1;
    $cat_order              = $args['cat_order'];
    $taxonomy     = 'product_cat';
    $orderby      = 'title';
    $show_count   = (isset($args['columns']) && $args['columns'] == 'on')?1:0;      // 1 for yes, 0 for no
    $pad_counts   = 0;      // 1 for yes, 0 for no
    $hierarchical = 1;      // 1 for yes, 0 for no
    $title        = '';
    $empty        = 0;

    if ($cat_order == 1) { // NAME
      $get_categories_args = array(
        'taxonomy'     => $taxonomy,
        'orderby'      => $orderby,
        'show_count'   => $show_count,
        'pad_counts'   => $pad_counts,
        'hierarchical' => $hierarchical,
        'title_li'     => $title,
        'hide_empty'   => 1
      );
    } else if ($cat_order == 2) { // CAT ORDER
      $get_categories_args = array(
        'show_count'   => $show_count,
        'pad_counts'   => $pad_counts,
        'hierarchical' => $hierarchical,
        'title_li'     => $title,
        'hide_empty'   => 1,
        'taxonomy' => $taxonomy,
        'menu_order' => 'asc',
      );
    } else {
      $get_categories_args = array(
        'taxonomy'     => $taxonomy,
        'orderby'      => $orderby,
        'show_count'   => $show_count,
        'pad_counts'   => $pad_counts,
        'hierarchical' => $hierarchical,
        'title_li'     => $title,
        'hide_empty'   => 1
      );
    }

    $all_categories = get_categories( $get_categories_args );

    if ( $all_categories != "0" ) {
      $shortcodes = '';
      $i = 0;
      $category_class ='';
      if ($fullwidth == 'off') {
          $category_class = "grid-loop col-desk-$cols col-tab-$columns_tablet col-mob-$columns_mobile";
      }
      echo '<div class="et_pb_db_shop_loop '.$category_class.'">';//grid
      if ($fullwidth == 'off') { //grid
        echo '<ul class="et_pb_row_bodycommerce products bc_product_grid bc_product_' . $cols . ' bc_pro_tab_'. $columns_tablet .' bc_pro_mob_'. $columns_mobile .'">';
      }
      else if ($fullwidth  == 'list') {
        echo '<ul class="et_pb_row_bodycommerce products">';
      }

      foreach ($all_categories as $cat) {
        if($cat->category_parent == 0) {
          if ($fullwidth == 'off') { //grid
            echo '<li class="category-name_'. $cat->slug .' et_pb_db_cat_column product bc_product">';
          } else if ($fullwidth != 'off') {
            $category_id = $cat->term_id;
            echo '<a href="'. get_term_link($cat->slug, 'product_cat') .'">';
            $thumbnail_id = get_term_meta( $cat->term_id, 'thumbnail_id', true );
            $image = wp_get_attachment_url( $thumbnail_id );

            if ( !$image ) {
            $image = wc_placeholder_img_src();
            }
            if ( $image ) {
              ?>
              <span class="et_portfolio_image">
              <img src="<?php echo $image; ?>" alt="<?php echo $cat->name; ?>" />
              </span>
              <?php
            }
              echo '<'.$title_tag.' class="cat_title" style="padding-top:20px;">'. $cat->name .' <span class="catcount">('. $cat->count .')</span></'.$title_tag.'></a>';
              echo '<div class="cat_desc"><p>' . $cat->description . '</p></div>';
          } else {

          }

          if ($column_style == "text-ontop" && $fullwidth == 'off' ){
            $category_id = $cat->term_id;
            echo '<a href="'. get_term_link($cat->slug, 'product_cat') .'"><'.$title_tag.' class="cat_title">'. $cat->name .' <span class="catcount">('. $cat->count .')</span></'.$title_tag.'>';
            $thumbnail_id = get_term_meta( $cat->term_id, 'thumbnail_id', true );
            $image = wp_get_attachment_url( $thumbnail_id );

            if ( !$image ) {
            $image = wc_placeholder_img_src();
            }
            if ( $image ) {?>
              <span class="et_portfolio_image">
              <img src="<?php echo $image; ?>" alt="<?php echo $cat->name; ?>" />
              </span>
              <?php
            }
            echo '</a>';
            echo '<div class="cat_desc"><p>' . $cat->description . '</p></div>';
          } else if ($column_style == "text-below" && $fullwidth == 'off') {
            $category_id = $cat->term_id;
            echo '<a href="'. get_term_link($cat->slug, 'product_cat') .'">';
            $thumbnail_id = get_term_meta( $cat->term_id, 'thumbnail_id', true );
            $image = wp_get_attachment_url( $thumbnail_id );

            if ( !$image ) {
            $image = wc_placeholder_img_src();
            }
            if ( $image ) { ?>
              <span class="et_portfolio_image">
              <img src="<?php echo $image; ?>" alt="<?php echo $cat->name; ?>" />
              </span>
              <?php
            }

            echo '<'.$title_tag.' class="cat_title">'. $cat->name .' <span class="catcount">('. $cat->count .')</span></'.$title_tag.'></a>';
            echo '<div class="cat_desc"><p>' . $cat->description . '</p></div>';
          } else {

          }

          echo '</li>';
        }
      }
      echo '</ul>';
      echo '</div>';

      wp_reset_query();
    } else {
      if ( et_is_builder_plugin_active() ) {
        include( ET_BUILDER_PLUGIN_DIR . 'includes/no-results.php' );
      } else {
        get_template_part( 'includes/no-results', 'index' );
      }
    }

    $data = ob_get_clean();

    return $data;
  }


    function render( $attrs, $content, $render_slug ) {
    if ( is_admin() && ( ! defined( 'DOING_AJAX' ) || ! DOING_AJAX ) ) {
      return;
    }

    $background_layout = '';
    $cols                   = $this->props['columns'];
    $columns_tablet           = $this->props['columns_tablet'];
    $columns_mobile          = $this->props['columns_mobile'];
    $column_style           = $this->props['column_style'];
    $text_orientation       = $this->props['text_orientation'];
    $hide_description       = $this->props['hide_description'];
    $cat_order              = $this->props['cat_order'];
    $fullwidth           =  $this->props['fullwidth'];
    $zoom_icon_color     = $this->props['zoom_icon_color'];
    $hover_overlay_color = $this->props['hover_overlay_color'];
    $hover_icon          = $this->props['hover_icon'];
    $category_padding    = $this->props['category_padding'];
    $category_padding_tablet    = $this->props['category_padding_tablet'];
    $category_padding_phone    = $this->props['category_padding_phone'];
    $category_margin     = $this->props['category_margin'];
    $category_margin_tablet     = $this->props['category_margin_tablet'];
    $category_margin_phone     = $this->props['category_margin_phone'];
    $show_all_cat          = $this->props['show_all_cat'];
    $back_to_shop          = $this->props['back_to_shop'];
    $back_to_shop_text          = $this->props['back_to_shop_text'];
    $back_to_shop_image          = $this->props['back_to_shop_image'];
    $back_to_shop_position          = $this->props['back_to_shop_position'];
    $hide_empty          = $this->props['hide_empty'];
    $tile_hover_not          = $this->props['tile_hover_not'];
    $show_count          = $this->props['show_count'];
    $hide_images          = $this->props['hide_images'];
    $hide_title          = $this->props['hide_title'];
    $is_loop_layout          = $this->props['is_loop_layout'];

    $title_tag          = $this->props['title_tag'];

    $layout_style         = $this->props['layout_style'];
    $loop_layout         = $this->props['loop_layout'];

    if ($fullwidth == 'on' || $fullwidth == '') {
      $fullwidth = 'list';
    }
        
    // Module classnames
    $this->add_classname(
        array(
            'clearfix',
            $this->get_text_orientation_classname(),
        )
    );
    
    $include_cats          = $this->props['include_cats'];
    $exclude_cats          = $this->props['exclude_cats'];


    if ( $hide_images == 'on' ) {
      $this->add_classname('hide_images');
    }
    if ( $tile_hover_not == 'off' ) {
      $this->add_classname('show-title-always');
    }
    if ( $show_count == 'on' ) {
      $this->add_classname('show-catcount');
    }

    $back_shop = "";
    if ($fullwidth == 'off') { // grid
      if ($back_to_shop == "on") {
        $shop_page_url = wc_get_page_permalink( 'shop' );
        if ($back_to_shop_image != "") {
          $back_image = '<span class="et_portfolio_image"><img src="'.$back_to_shop_image.'" alt="'.$back_to_shop_text.'" /><span class="et_overlay"></span></span>';
        } else {
          $back_image = "";
        }
        $back_shop = '<li class="et_pb_db_cat_column product bc_product"><a href="'.$shop_page_url.'"><'.$title_tag.' class="cat_title">'.$back_to_shop_text.'</'.$title_tag.'>'.$back_image.'</a></li>';
      }
    } else {
      if ($back_to_shop == "on") {
        if ($back_to_shop_image != "") {
          $back_image = '<span class="et_portfolio_image"><img src="'.$back_to_shop_image.'" alt="'.$back_to_shop_text.'" /><span class="et_overlay"></span></span>';
        } else {
          $back_image = "";
        }
        $shop_page_url = wc_get_page_permalink( 'shop' );
        $back_shop = '<a href="'.$shop_page_url.'"><'.$title_tag.' style="padding-top:20px;" class="cat_title">'.$back_to_shop_text.'</'.$title_tag.'>'.$back_image.'</a>';
      }
    }


    ob_start();

    global $paged, $wp_query, $de_categoryloop_term;

    $container_is_closed = false;
    $overlay = "";
    if ( '' !== $zoom_icon_color ) {
      ET_Builder_Element::set_style( $render_slug, array(
        'selector'    => '%%order_class%% .et_overlay:before',
        'declaration' => sprintf(
          'color: %1$s !important;',
          esc_html( $zoom_icon_color )
        ),
      ) );
    }

    if ( '' !== $hover_overlay_color ) {
      ET_Builder_Element::set_style( $render_slug, array(
        'selector'    => '%%order_class%% .et_overlay',
        'declaration' => sprintf(
          'background-color: %1$s;
          border-color: %1$s;',
          esc_html( $hover_overlay_color )
        ),
      ) );
    }
    $category_selector = "#main-content %%order_class%% ul.bc_product_grid  li.et_pb_db_cat_column.product";
    if( $fullwidth == 'list' ){
        $category_selector ="%%order_class%% .et_pb_db_cat_column.product .et_portfolio_image";
    }
    if ('' !== $category_padding && '|||' !== $category_padding) {
        ET_Builder_Element::set_style($render_slug, array(
            'selector'    => $category_selector,
            'declaration' => sprintf(
                'padding-top: %1$s; padding-right: %2$s; padding-bottom: %3$s; padding-left: %4$s;',
                esc_attr(et_pb_get_spacing($category_padding, 'top', '0px')),
                esc_attr(et_pb_get_spacing($category_padding, 'right', '0px')),
                esc_attr(et_pb_get_spacing($category_padding, 'bottom', '0px')),
                esc_attr(et_pb_get_spacing($category_padding, 'left', '0px'))
            ),
        ));
    }
    if ('' !== $category_padding_tablet && '|||' !== $category_padding_tablet) {
        ET_Builder_Element::set_style($render_slug, array(
            'selector'    => $category_selector,
            'declaration' => sprintf(
                'padding-top: %1$s; padding-right: %2$s; padding-bottom: %3$s; padding-left: %4$s;',
                esc_attr(et_pb_get_spacing($category_padding_tablet, 'top', '0px')),
                esc_attr(et_pb_get_spacing($category_padding_tablet, 'right', '0px')),
                esc_attr(et_pb_get_spacing($category_padding_tablet, 'bottom', '0px')),
                esc_attr(et_pb_get_spacing($category_padding_tablet, 'left', '0px'))
            ),
            'media_query' => ET_Builder_Element::get_media_query('max_width_980')
        ));
    }
    if ('' !== $category_padding_phone && '|||' !== $category_padding_phone) {
        ET_Builder_Element::set_style($render_slug, array(
            'selector'    => $category_selector,
            'declaration' => sprintf(
                'padding-top: %1$s; padding-right: %2$s; padding-bottom: %3$s; padding-left: %4$s;',
                esc_attr(et_pb_get_spacing($category_padding_phone, 'top', '0px')),
                esc_attr(et_pb_get_spacing($category_padding_phone, 'right', '0px')),
                esc_attr(et_pb_get_spacing($category_padding_phone, 'bottom', '0px')),
                esc_attr(et_pb_get_spacing($category_padding_phone, 'left', '0px'))
            ),
            'media_query' => ET_Builder_Element::get_media_query('max_width_767')
        ));
    }

    if ('' !== $category_margin && '|||' !== $category_margin) {
        ET_Builder_Element::set_style($render_slug, array(
            'selector'    => $category_selector,
            'declaration' => sprintf(
                'margin-top: %1$s; margin-right: %2$s; margin-bottom: %3$s; margin-left: %4$s;',
                esc_attr(et_pb_get_spacing($category_margin, 'top', '0px')),
                esc_attr(et_pb_get_spacing($category_margin, 'right', '0px')),
                esc_attr(et_pb_get_spacing($category_margin, 'bottom', '0px')),
                esc_attr(et_pb_get_spacing($category_margin, 'left', '0px'))
            ),
        ));
    }
    if ('' !== $category_margin_tablet && '|||' !== $category_margin_tablet) {
        ET_Builder_Element::set_style($render_slug, array(
            'selector'    => $category_selector,
            'declaration' => sprintf(
                'margin-top: %1$s; margin-right: %2$s; margin-bottom: %3$s; margin-left: %4$s;',
                esc_attr(et_pb_get_spacing($category_margin_tablet, 'top', '0px')),
                esc_attr(et_pb_get_spacing($category_margin_tablet, 'right', '0px')),
                esc_attr(et_pb_get_spacing($category_margin_tablet, 'bottom', '0px')),
                esc_attr(et_pb_get_spacing($category_margin_tablet, 'left', '0px'))
            ),
            'media_query' => ET_Builder_Element::get_media_query('max_width_980')
        ));
    }
    if ('' !== $category_margin_phone && '|||' !== $category_margin_phone) {
        ET_Builder_Element::set_style($render_slug, array(
            'selector'    => $category_selector,
            'declaration' => sprintf(
                'margin-top: %1$s; margin-right: %2$s; margin-bottom: %3$s; margin-left: %4$s;',
                esc_attr(et_pb_get_spacing($category_margin_phone, 'top', '0px')),
                esc_attr(et_pb_get_spacing($category_margin_phone, 'right', '0px')),
                esc_attr(et_pb_get_spacing($category_margin_phone, 'bottom', '0px')),
                esc_attr(et_pb_get_spacing($category_margin_phone, 'left', '0px'))
            ),
            'media_query' => ET_Builder_Element::get_media_query('max_width_767')
        ));
    }

    if ( 'on' !== $fullwidth ) {

      $data_icon = '' !== $hover_icon ? sprintf( ' data-icon="%1$s"', esc_attr( et_pb_process_font_icon( $hover_icon ) ) ) : '';
      $overlay = sprintf( '<span class="et_overlay%1$s"%2$s></span>',
      ( '' !== $hover_icon ? ' et_pb_inline_icon' : '' ),
      $data_icon
    );
    }
    if ( is_rtl() && 'left' === $text_orientation ) {
      $text_orientation = 'right';
    }
    if ($fullwidth == 'list') {
      echo '<style>.et_shop_image {display:inline-block;}</style>';
    } else {
    }

    if ( is_shop() || is_product_category() || $show_all_cat == "on" ) {
      if ($hide_empty == "off") {
        $hide_empty = 0;
      } else {
        $hide_empty = 1;
      }

      $taxonomy     = 'product_cat';
      $orderby      = 'name';
      $pad_counts   = 0;      // 1 for yes, 0 for no
      $hierarchical = 1;      // 1 for yes, 0 for no
      $title        = '';
      $empty        = 0;

      if ($cat_order == 1) { // NAME
        $args = array(
          'taxonomy'     => $taxonomy,
          'orderby'      => $orderby,
          'show_count'   => 1,
          'pad_counts'   => $pad_counts,
          'hierarchical' => $hierarchical,
          'title_li'     => $title,
          'hide_empty'   => $hide_empty
        );
      } else if ($cat_order == 2) { // CAT ORDER
        $args = array(
          'show_count'   => 1,
          'pad_counts'   => $pad_counts,
          'hierarchical' => $hierarchical,
          'title_li'     => $title,
          'hide_empty'   => $hide_empty,
          'taxonomy' => $taxonomy,
          'menu_order' => 'asc',
        );
      } else {
        $args = array(
          'taxonomy'     => $taxonomy,
          'orderby'      => $orderby,
          'show_count'   => 1,
          'pad_counts'   => $pad_counts,
          'hierarchical' => $hierarchical,
          'title_li'     => $title,
          'hide_empty'   => $hide_empty
        );
      }


    
      // exclude_cats
      if ($exclude_cats != "") {
          $exclude_cats = explode(',', $exclude_cats);
        } else {
          $exclude_cats = array();
        }
      
      if ( !is_array($exclude_cats) && $exclude_cats != "" ) {
        $exclude_cats = array($exclude_cats);
      }

      if ($show_all_cat == "on") {

        // include_cats
        if ($include_cats != "") {

          $include_cats = explode(',', $include_cats);

          if ( !is_array($include_cats) && $include_cats != "" ) {
            $include_cats = array($include_cats);
          }
          
          $args['include'] = $include_cats;

        } 
        
        $args['exclude'] = $exclude_cats;

        $all_categories = get_terms( 'product_cat', $args );
      } else {
        global $post;

        $cateID = "0";
        $cate = get_queried_object();

        if (isset($cate->term_id)) {
         $cateID = $cate->term_id;
        }

        
      
        if ($cat_order != 2) { // NAME
          $get_terms_array['orderby'] = 'name';
        }

        $get_terms_array['hide_empty'] = $hide_empty;
        $get_terms_array['order'] = 'ASC';
        $get_terms_array['exclude'] = $exclude_cats;
        
        // include_cats
        if ($include_cats != "") {

          $include_cats = explode(',', $include_cats);

          if ( !is_array($include_cats) && $include_cats != "" ) {
            $include_cats = array($include_cats);
          }
          
          $get_terms_array['include'] = $include_cats;



        } 
        
        
        

        if (is_single() || $is_loop_layout == "on") {

          $get_terms_array['parent'] = '0';
          $all_categories = get_the_terms( get_the_ID(), 'product_cat', $get_terms_array );

        } else {

          /*
          Include Categories - We only include when its NOT "all".
          We then get all the child category IDs from the parent
          Then we merge into an include so we add the Child Category IDs + Include IDs
          */

          if ($include_cats != "") {

            $get_terms_array_temp = array();
            $get_terms_array = array_merge($get_terms_array, $get_terms_array_temp);
            $get_terms_array_temp['parent'] = $cateID;
            $temp_get_categories = get_terms('product_cat',$get_terms_array_temp);

            foreach ($temp_get_categories as $cat) {
              array_push($get_terms_array['include'], $cat->term_id);
            }

          } else {
            $get_terms_array['parent'] = $cateID;
          }
       
          
          $all_categories = get_terms(
           'product_cat',
           $get_terms_array
          );

        }

      }


      if ( $all_categories != "0" ) {
          $shortcodes = '';
          $i = 0;
          $category_class ='';
          
          if ($fullwidth == 'off') {
              $category_class = "grid-loop col-desk-$cols col-tab-$columns_tablet col-mob-$columns_mobile";
          }
          echo '<div class="et_pb_db_shop_loop '.$category_class.'">';

          if ($layout_style == 'loop') {

            if ($fullwidth == 'off') { //grid
              echo '<div class="et_pb_row_bodycommerce products bc_product_grid bc_product_' . $cols . ' bc_pro_tab_'. $columns_tablet .' bc_pro_mob_'. $columns_mobile .'">';
            } else if ($fullwidth  == 'list') {
              echo '<div class="et_pb_row_bodycommerce products">';
            }

            foreach ($all_categories as $cat) {

              $de_categoryloop_term = $cat;
              $css_classes = "";
              if (is_product_category( $cat->name )) {
                $css_classes .= "active-category";
              }
  
              if ($cat->count == "0") {
                $css_classes .= " no-count";
              } else {
                $css_classes .= "";
              }

              echo '<div class="et_pb_db_cat_column product '. esc_attr($css_classes) .'">';
              echo do_shortcode(get_post_field('post_content', $loop_layout));
              echo '</div>';

            }
        
            $de_categoryloop_term = null;

          } else {
            if ($fullwidth == 'off') { //grid
              echo '<ul class="et_pb_row_bodycommerce products bc_product_grid bc_product_' . $cols . ' bc_pro_tab_'. $columns_tablet .' bc_pro_mob_'. $columns_mobile .'">';
            } else if ($fullwidth  == 'list') {
              echo '<ul class="et_pb_row_bodycommerce products">';
            }
            if ($back_to_shop_position == "start") {
              echo $back_shop;
            }

            foreach ($all_categories as $cat) {
            
              $css_classes = "";
              if (is_product_category( $cat->name )) {
                $css_classes .= "active-category";
              }
  
              if ($cat->count == "0") {
                $css_classes .= " no-count";
              } else {
                $css_classes .= "";
              }
              if( is_array($exclude_cats) && in_array( $cat->term_id ,$exclude_cats ) ) {
  
              } else {
                
                if ($show_count == "on") {
                  $cat_name = '' . $cat->name . ' <span class="catcount">(' . $cat->count . ')</span>';
                } else {
                  $cat_name = $cat->name;
                }
                
                if($cat->category_parent == 0) {
              
                  if ($fullwidth == 'off') { //grid
                    echo '<li class="category-name_'. $cat->slug .' et_pb_db_cat_column product '.$css_classes.'">';
                  } else if ($fullwidth != 'off') {
                    echo '<li class="category-name_'. $cat->slug .' '.$css_classes.'">';
                    $category_id = $cat->term_id;
                    echo '<a class="et_pb_db_cat_column product" href="'. get_term_link($cat->slug, 'product_cat') .'">';
                    $thumbnail_id = get_term_meta( $cat->term_id, 'thumbnail_id', true );
                    $image = wp_get_attachment_url( $thumbnail_id );
                    
                    if ( !$image ) {
                      $image = wc_placeholder_img_src();
                    }
                    if ( $image && $hide_images !== 'on' ) { ?>
                      <span class="et_portfolio_image">
                      <img src="<?php echo $image; ?>" alt="<?php echo $cat->name; ?>" />
                      <?php echo $overlay; ?>
                      </span>
                      <?php
                    }
  
  
                    if ($hide_title == 'on') {
                    } else {
                      echo '<'.$title_tag.' style="padding-top:20px;" class="cat_title">'. $cat_name .'</'.$title_tag.'>';
                    }
  
                    echo '</a>';
  
                    if ($hide_description == 'on') {
                    } else {
                      echo "<p>";
                      echo '<div class="cat_desc"><p>' . $cat->description . '</p></div>';
                      echo "</p>";
                    }
                }
  
                if ($column_style == "text-ontop" && $fullwidth == 'off' ){
                  $category_id = $cat->term_id;
                  echo '<a href="'. get_term_link($cat->slug, 'product_cat') .'">';
  
  
                  if ($hide_title == 'on') {
                  } else {
                  echo '<'.$title_tag.' class="cat_title">'. $cat_name .'</'.$title_tag.'>';
                  }
  
                  $thumbnail_id = get_term_meta( $cat->term_id, 'thumbnail_id', true );
                  $image = wp_get_attachment_url( $thumbnail_id );
  
                  if ( !$image ) {
                  $image = wc_placeholder_img_src();
                  }
  
                  if ( $image && $hide_images !== 'on' ) { ?>
                    <span class="et_portfolio_image">
                    <img src="<?php echo $image; ?>" alt="<?php echo $cat->name; ?>" />
                    <?php echo $overlay; ?>
                    </span>
                    <?php
                  }
                  echo '</a>';
                  if ($hide_description == 'on') {
                  } else {
                    echo '<div class="cat_desc"><p>' . $cat->description . '</p></div>';
                  }
                } else if ($column_style == "text-below" && $fullwidth == 'off') {
                  $category_id = $cat->term_id;
                  echo '<a href="'. get_term_link($cat->slug, 'product_cat') .'">';
                  $thumbnail_id = get_term_meta( $cat->term_id, 'thumbnail_id', true );
                  $image = wp_get_attachment_url( $thumbnail_id );
  
                  if ( !$image ) {
                  $image = wc_placeholder_img_src();
                  }
                  if ( $image && $hide_images !== 'on' ) {
                    ?>
                    <span class="et_portfolio_image">
                    <img src="<?php echo $image; ?>" alt="<?php echo $cat->name; ?>" />
                    <?php echo $overlay; ?>
                    </span>
                    <?php
                  }
  
  
                  if ($hide_title == 'on') {
                  } else {
                    echo '<'.$title_tag.' class="cat_title">'. $cat_name .'</'.$title_tag.'>';
                  }
  
                  echo '</a>';
  
                  if ($hide_description == 'on') {
                  } else {
                    echo '<div class="cat_desc"><p>' . $cat->description . '</p></div>';
                  }
                } else if ($column_style == "text-appeartop" && $fullwidth == 'off') {
                  $category_id = $cat->term_id;
                  echo '<a href="'. get_term_link($cat->slug, 'product_cat') .'">';
                  ?><div class="appeartop_text_cont"><?php
                  $thumbnail_id = get_term_meta( $cat->term_id, 'thumbnail_id', true );
                  $image = wp_get_attachment_url( $thumbnail_id );
  
                  if ( !$image ) {
                  $image = wc_placeholder_img_src();
                  }
                  if ( $image && $hide_images !== 'on' ) {
                    ?>
                    <span class="et_portfolio_image">
                    <img src="<?php echo $image; ?>" alt="<?php echo $cat->name; ?>" />
                    <?php echo $overlay; ?>
                    <span class="appeartop_text">
                    <?php
                    if ($hide_title == 'on') {
                    } else {
                      echo '<'.$title_tag.' class="cat_title">'. $cat_name .'</'.$title_tag.'>';
                    }
  
                    if ($hide_description == 'on') {
                    } else {
                      echo  $cat->description;
                    }
                    ?>
                    </span>
                    </span>
                    <?php
                  } else {
  
                    if ($hide_title == 'on') {
                    } else {
                    echo '<'.$title_tag.' class="cat_title">'. $cat_name .'</'.$title_tag.'>';
                    }
  
                    if ($hide_description == 'on') {
                    } else {
                      echo  $cat->description;
                    }
                  }
                  ?>
                  </div>
                  </a>
                  <?php
                } else {
                }
  
                  echo '</li>';
              }
            }
            }

          }

          if ($layout_style == 'loop') {
            if ($back_to_shop_position == "end") {
              echo $back_shop;
            }
            echo '</div>';
          } else {
            if ($back_to_shop_position == "end") {
              echo $back_shop;
            }
            echo '</ul>';
          }
          
          echo '</div>';

          if (is_single() || $is_loop_layout == "on") {

          } else {
              wp_reset_query();
            }
        } else {

        }



      }

      $data = ob_get_clean();

      return $data;
  }
}
new db_shop_cat_loop_code;

?>
