<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class db_shop_comparetable_code extends ET_Builder_Module {

    // Variables and functions should be started at 1 tab position.
    // Because class definition line has ended with '{'
    // So, put 1 tab after every block start '{'
    public $vb_support = 'on';
    
    public $folder_name;
    public $fields_defaults;
    public $text_shadow;
    public $margin_padding;
    public $_additional_fields_options;
    public $child_item_text;
    public $options;

    // Array variables should have 1 tab
    // Just like '{', all lines should have 1 tab after '('
    protected $module_credits = array(
        'module_uri' => DE_DB_PRODUCT_URL,
        'author'     => DE_DB_AUTHOR,
        'author_uri' => DE_DB_URL,
    );

    function init() {
        $this->name            = esc_html__( 'G Compare Table - Global', 'divi-bodyshop-woocommerce' );
        $this->slug            = 'et_pb_db_shop_comparetable';
    	$this->vb_support      = 'on';
    	$this->child_slug      = 'et_pb_db_shop_comparetable_item';
        $this->child_item_text = esc_html__( 'Compare Table Field', 'divi-bodyshop-woocommerce' );
        $this->folder_name      = 'divi_bodycommerce';
        
        $this->settings_modal_toggles = array(
            'general' => array(
                'toggles' => array(
                    'main_content' => esc_html__( 'Main Options', 'divi-bodyshop-woocommerce' ),
                    'alignment' => esc_html__( 'Alignment', 'divi-bodyshop-woocommerce' ),
                    'elements' => esc_html__( 'Elements', 'divi-bodyshop-woocommerce' ),
					'table_row_options'        => esc_html__( 'Item Row Options', 'divi-bodyshop-woocommerce' ),
					'loop_options'        => esc_html__( 'Automatic Options', 'divi-bodyshop-woocommerce' ),
                    'guest_options'       => esc_html__( 'Guest Options', 'divi-bodyshop-woocommerce' ),
                    'no_results' => esc_html__( 'No Results', 'divi-bodyshop-woocommerce' ),
                ),
            ),
        );

        $this->main_css_element = '%%order_class%%';

		$this->advanced_fields = array(
			'borders'        => array(
				'default' => array(
					'css'          => array(
						'main'      => array(
							'border_radii'  => '%%order_class%% .table_row .td_row',
							'border_styles' => '%%order_class%% .table_row .td_row',
						),
						'important' => 'plugin_only',
					),
					'label_prefix' => esc_html__( 'Cell', 'et_builder' ),
				)
			),
			'fonts'          => array(
				'form_title' => array(
					'label'    => esc_html__( 'Product Title', 'divi-filter' ),
					'css'      => array(
							'main' => "%%order_class%% .compare_title",
							'important' => 'all',
					),
					'font_size' => array(
							'default' => '24px',
					),
					'line_height' => array(
							'default' => '1em',
					),
				),
                'label' => array(
					'label'    => esc_html__( 'Label', 'divi-filter' ),
					'css'      => array(
							'main' => "%%order_class%% .dbc_compare_label",
							'important' => 'plugin_only',
					),
					'font_size' => array(
							'default' => '18px',
					),
					'line_height' => array(
							'default' => '1em',
					),
				),
                'value' => array(
					'label'    => esc_html__( 'Value', 'divi-filter' ),
					'css'      => array(
							'main' => "%%order_class%% .td_row.dbc_compare_value",
							'important' => 'all',
					),
					'font_size' => array(
							'default' => '18px',
					),
					'line_height' => array(
							'default' => '1em',
					),
				)
			),
			'box_shadow'     => array(
				'default' => array(
					'css' => array(
						'main' => implode(
							', ',
							array(
								'%%order_class%%',
							)
						),
					),
				),
			),
			'button' => array(
                'button' => array(
                  'label' => esc_html__( 'Button', 'divi-bodyshop-woocommerce' ),
                  'css' => array(
                    'main' => "{$this->main_css_element} .button",
                    'important' => 'all',
                  ),
                  'box_shadow'  => array(
                    'css' => array(
                      'main' => "{$this->main_css_element} .button",
                          'important' => 'all',
                    ),
                  ),
                      'margin_padding' => array(
                          'css'           => array(
                              'main' => "{$this->main_css_element} .button",
                              'important' => 'all',
                          ),
                      ),
                  'use_alignment' => true,
                ),
			),
			'margin_padding' => array(
				'css' => array(
                    'main'=>'%%order_class%%',
                    'important' => 'all',
				),
				'label'          => esc_html__( 'Whole Form', 'et_builder' ),
			),
			'max_width'      => array(
				'css' => array(
					'module_alignment' => '%%order_class%%',
				),
			),
		);

        $this->options = DEBC_INIT::get_divi_layouts();

        $this->custom_css_fields = array();
        $this->help_videos = array();
    }

    function get_fields() {
        $options = $col_options = array();
        $sizes   = get_intermediate_image_sizes();

        foreach ($sizes as $size) {
            $options[$size] = $size;
        }

        $attr = array();
        $attr['none'] = 'No Attribute';
        
        if ($taxonomies = get_taxonomies(false, 'objects')) {
            foreach ($taxonomies as $taxonomy) {
                if (substr($taxonomy->name, 0, 3) == 'pa_') {
                    $attr[$taxonomy->name] = $taxonomy->label;
                }
            }
        }

        $fields = array(
            'display_type'             => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'Display Type', 'divi-bodyshop-woocommerce' ),
                'type'              => 'select',
                'options'           => array(
                    'manual'        => esc_html__( 'Customer Adds to table', 'divi-bodyshop-woocommerce' ),
                    'automatic'     => esc_html__( 'Automatic on product page', 'divi-bodyshop-woocommerce' ),
                ),
                'option_category'   => 'configuration',
                'default'           => 'manual',
                'description'       => esc_html__( 'Choose how you want the compare to work, automatic (on product page) or the customer adds it to the table manually.', 'divi-bodyshop-woocommerce' ),
            ),

            // automatic
            'related_content'             => array(
                'toggle_slug'       => 'loop_options',
                'label'             => esc_html__( 'Related Products based on', 'divi-bodyshop-woocommerce' ),
                'type'              => 'select',
                'options'           => array(
                    'categories' => sprintf( esc_html__( 'Categories', 'divi-bodyshop-woocommerce' ) ),
                    'tags' => esc_html__( 'Tags', 'divi-bodyshop-woocommerce' ),
                    'attribute' => esc_html__( 'Attribute', 'divi-bodyshop-woocommerce' ),
                ),
                'option_category'   => 'configuration',
                'default'           => 'categories',
                'description'       => esc_html__( 'Choose how you want the compare to work, automatic (on product page) or the customer adds it to the table manually.', 'divi-bodyshop-woocommerce' ),
                'show_if'          => array ('display_type' => 'automatic')
            ),
            'attribute' => array(
                'label' => esc_html__('Attribute', 'divi-bodyshop-woocommerce'),
                'type' => 'select',
                'options' => $attr,
                'toggle_slug'       => 'loop_options',
                'default'     => 'none',
                'description' => 'Choose the attribute that will determine what other products are shown.',
                'show_if'      => array('related_content' => 'attribute')
            ),
            'posts_number' => array(
              'toggle_slug'       => 'loop_options',
              'option_category'   => 'configuration',
              'label'             => esc_html__( 'Post Count (excluding current product)', 'divi-bodyshop-woocommerce' ),
              'type'              => 'text',
              'default'           => 3,
              'description'       => esc_html__( 'Choose how other products do you want to show.', 'divi-bodyshop-woocommerce' ),
              'show_if'          => array ('display_type' => 'automatic')
            ),
            //automatic end

            'post_type'             => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'Post Type', 'divi-bodyshop-woocommerce' ),
                'type'              => 'select',
                'options'           => et_get_registered_post_type_options( false, false ),
                'option_category'   => 'configuration',
                'default'           => 'product',
                'description'       => esc_html__( 'Choose the post type that you want to show on Compare Table', 'divi-bodyshop-woocommerce' ),
            ),
            'show_title'            => array(
                'toggle_slug'       => 'elements',
                'label'             => esc_html__( 'Show Title', 'divi-bodyshop-woocommerce' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'default'           => 'on',
                'options'           => array(
                    'on'            => et_builder_i18n( 'Yes' ),
                    'off'           => et_builder_i18n( 'No' ),
                ),
                'description'       => esc_html__( 'Enable this option to show title on header.', 'divi-bodyshop-woocommerce' ),
            ),
            'title_tag'      => array(
                'toggle_slug'       => 'elements',
                'label'       => __('Title HTML Tag', 'et_builder'),
                'type'        => 'select',
                'options'     => array(
                    "h1" => "h1",
                    "h2" => "h2",
                    "h3" => "h3",
                    "h4" => "h4",
                    "h5" => "h5",
                    "h6" => "h6",
                    "p"  => "p",
                ),
                'default'     => 'h3',
                'description' => __('Set the title tag. For example you may want it to be h3 or h4.', 'et_builder'),
                'show_if'          => array ('show_title' => 'on')
            ),
            'link_product'          => array(
                'toggle_slug'       => 'elements',
                'label'             => esc_html__( 'Link Product Title to Product Page?', 'divi-bodyshop-woocommerce' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'default'           => 'on',
                'options'           => array(
                    'on'            => et_builder_i18n( 'Yes' ),
                    'off'           => et_builder_i18n( 'No' ),
                ),
                'description'       => esc_html__( 'Enable this option to link title to product page.', 'divi-bodyshop-woocommerce' ),
                'show_if'          => array ('show_title' => 'on'),
                'affects'           => array(
                    'link_product_in_new_tab'
                ),
            ),
            'link_product_in_new_tab'          => array(
                'toggle_slug'       => 'elements',
                'label'             => esc_html__( 'Open Product in a New Tab?', 'divi-bodyshop-woocommerce' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'default'           => 'off',
                'options'           => array(
                    'on'            => et_builder_i18n( 'Yes' ),
                    'off'           => et_builder_i18n( 'No' ),
                ),
                'description'       => esc_html__( 'Enable this option to open product page in new tab.', 'divi-bodyshop-woocommerce' ),
                'depends_show_if'   => 'on',
            ),
            'show_thumbnail'        => array(
                'toggle_slug'       => 'elements',
                'label'             => esc_html__( 'Show Thumbnail', 'divi-bodyshop-woocommerce' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'default'           => 'off',
                'options'           => array(
                    'on'            => et_builder_i18n( 'Yes' ),
                    'off'           => et_builder_i18n( 'No' ),
                ),
                'description'       => esc_html__( 'Enable this option to show thumbnail on header.', 'divi-bodyshop-woocommerce' ),
            ),
            'thumb_image_size'         => array(
                'toggle_slug'       => 'elements',
                'option_category'   => 'configuration',
                'label'            => __('Thumbnail Image Size', 'et_builder'),
                'type'             => 'select',
                'options'          => $options,
                'default'          => 'woocommerce_thumbnail',
                'description'      => __('Pick a size for the thumbnail image from the list.', 'et_builder'),
                'show_if'          => array ('show_thumbnail' => 'on')
            ),
            
            'show_atc'        => array(
                'toggle_slug'       => 'elements',
                'label'             => esc_html__( 'Show Add to Cart', 'divi-bodyshop-woocommerce' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'default'           => 'off',
                'options'           => array(
                    'on'            => et_builder_i18n( 'Yes' ),
                    'off'           => et_builder_i18n( 'No' ),
                ),
                'description'       => esc_html__( 'Enable this option to show the add to cart button at the end.', 'divi-bodyshop-woocommerce' ),
            ),

			'button_alignment' => array(
				'label'            => esc_html__( 'Button Alignment', 'et_builder' ),
				'type'             => 'text_align',
				'option_category'  => 'configuration',
				'options'          => et_builder_get_text_orientation_options( array( 'justified' ) ),
				'tab_slug'         => 'advanced',
				'toggle_slug'      => 'alignment',
				'description'      => esc_html__( 'Here you can define the alignment of Button', 'et_builder' ),
			),

            //Padding
			'table_item_padding' => array(
                'label'          => esc_html__('Table Item Padding', 'divi-bodyshop-woocommerce' ),
                'description'    => 'Set the padding for the table item.',
                'type'           => 'custom_padding',
				'tab_slug'         => 'advanced',
				'toggle_slug'     => 'margin_padding',
                'mobile_options' => true,
            ),

            // BG COLOR
			'row_bg' 	=> array(
				'default'           => "#ffffff",
				'label'             => esc_html__('Row Background Color', 'divi-bodyshop-woocommerce'),
				'type'              => 'color-alpha',
				'description'       => esc_html__('Change the background color of the row.', 'divi-bodyshop-woocommerce'),
				'tab_slug'         => 'advanced',
				'toggle_slug'		=> 'table_row_options',		
			),
			'row_bg_alternative' 	=> array(
				'default'           => "#efefef",
				'label'             => esc_html__('Alternative Row Background Color', 'divi-bodyshop-woocommerce'),
				'type'              => 'color-alpha',
				'description'       => esc_html__('Change the background color of the row.', 'divi-bodyshop-woocommerce'),
				'tab_slug'         => 'advanced',
				'toggle_slug'		=> 'table_row_options',		
			),

            // Guest Options

            'guest_display_type'      => array(
                'toggle_slug'       => 'guest_options',
                'label'       => __('Guest Display Type', 'divi-bodyshop-woocommerce'),
                'type'        => 'select',
                'options'     => array(
                    'text' => esc_html__('Text', 'divi-bodyshop-woocommerce'),
                    'layout' => esc_html__('Library Layout', 'divi-bodyshop-woocommerce')
                ),
                'default'     => 'text',
                'show_if'       => array( 'display_type' => 'manual' ),
                'description' => __('If there are no products in the compare table, choose what gets displayed.', 'divi-bodyshop-woocommerce')
            ),
            'guest_display_text' => array(
                'toggle_slug'       => 'guest_options',
                'option_category'   => 'configuration',
                'label'             => esc_html__( 'Message for Guest', 'divi-bodyshop-woocommerce' ),
                'type'              => 'text',
                'default'           => esc_html__('Please login to see the compare table.', 'divi-bodyshop-woocommerce'),
                'description'       => esc_html__( 'Specify the text that appears when user is not logged in.', 'divi-bodyshop-woocommerce' ),
                'show_if'          => array ('guest_display_type' => 'text')
            ),
            'guest_display_layout' => array(
                'toggle_slug' => 'guest_options',
                'label' => esc_html__('Layout for Guest', 'divi-bodyshop-woocommerce'),
                'type' => 'select',
                'option_category' => 'configuration',
                'default' => 'none',
                'options' => $this->options,
                'description' => esc_html__('Choose the layout to show when user is not logged in.', 'divi-bodyshop-woocommerce'),
                'show_if'          => array ('guest_display_type' => 'layout')
            ),

            // No Results
            
            'no_results_type'      => array(
                'toggle_slug'       => 'no_results',
                'label'       => __('No Products Display Type', 'et_builder'),
                'type'        => 'select',
                'options'     => array(
                    'text' => esc_html__('Text', 'divi-bodyshop-woocommerce'),
                    'layout' => esc_html__('Library Layout', 'divi-bodyshop-woocommerce')
                ),
                'default'     => 'text',
                'description' => __('If there are no products in the compare table, choose what gets displayed.', 'et_builder')
            ),
            'no_results_text' => array(
                'toggle_slug'       => 'no_results',
                'option_category'   => 'configuration',
                'label'             => esc_html__( 'No Products Text', 'divi-bodyshop-woocommerce' ),
                'type'              => 'text',
                'default'           => esc_html__('No products to compare.', 'divi-bodyshop-woocommerce'),
                'description'       => esc_html__( 'Specify the text that appears when there are no products in the compare table.', 'divi-bodyshop-woocommerce' ),
                'show_if'          => array ('no_results_type' => 'text')
              ),
              'loop_layout' => array(
                  'toggle_slug' => 'no_results',
                  'label' => esc_html__('Library Layout', 'divi-bodyshop-woocommerce'),
                  'type' => 'select',
                  'option_category' => 'configuration',
                  'default' => 'none',
                  'options' => $this->options,
                  'description' => esc_html__('Choose the layout to show for the no results.', 'divi-bodyshop-woocommerce'),
                  'show_if'          => array ('no_results_type' => 'layout')
                ),

                'column_alignment'             => array(
                    'toggle_slug'       => 'main_content',
                    'label'             => esc_html__( 'Alignment of items in column', 'divi-bodyshop-woocommerce' ),
                    'type'              => 'select',
                    'options'           => array(
                        'left'        => esc_html__( 'Left', 'divi-bodyshop-woocommerce' ),
                        'center'     => esc_html__( 'Center', 'divi-bodyshop-woocommerce' ),
                        'right'     => esc_html__( 'Right', 'divi-bodyshop-woocommerce' ),
                    ),
                    'option_category'   => 'configuration',
                    'default'           => 'left',
                    'description'       => esc_html__( 'Choose how you want all the items in the column to be aligned.', 'divi-bodyshop-woocommerce' ),
                ),
                'hide_row_if_all_empty' => array(
                    'toggle_slug'       => 'main_content',
                    'label'             => esc_html__( 'Hide row if all are empty?', 'divi-bodyshop-woocommerce' ),
                    'type'              => 'yes_no_button',
                    'default'           => 'off',
                    'options'           => array(
                        'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
                        'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
                    ),
                    'option_category'   => 'configuration',
                    'description'        => esc_html__( 'If all the products in the compare table are empty, choose to hide the whole row or not.', 'divi-bodyshop-woocommerce' ),
                ),

            
        );

        return $fields;
    }

    public function get_compare_items_content() {
        return $this->content;
    }

    public function get_button_alignment() {
        $text_orientation = isset( $this->props['button_alignment'] ) ? $this->props['button_alignment'] : '';
        return et_pb_get_alignment( $text_orientation );
    }

    function render($attrs, $content, $render_slug){

        if ( is_admin() && ( ! defined( 'DOING_AJAX' ) || ! DOING_AJAX ) ) {
            return;
        }


        ET_Builder_Element::set_style($render_slug, array(
            'selector'    => '%%order_class%% .tr_row',
            'declaration' => sprintf(
                'display: table-row;'
            ),
        ));

        ET_Builder_Element::set_style($render_slug, array(
            'selector'    => '%%order_class%% .td_row',
            'declaration' => 'display: table-cell;border-style:solid;border-width:0px;vertical-align:top;'
        ));

        ET_Builder_Element::set_style($render_slug, array(
            'selector'    => '%%order_class%% .et_pb_db_shop_comparetable_item, .woocommerce-account .bc-account-content-container %%order_class%% .et_pb_db_shop_comparetable_item.et_pb_module.clearfix',
            'declaration' => sprintf(
                'display: table-row-group !important;'
            ),
        ));

        ET_Builder_Element::set_style($render_slug, array(
            'selector'    => '%%order_class%% .et_pb_db_shop_comparetable_item .et_pb_module_inner',
            'declaration' => sprintf(
                'display: table-row;'
            ),
        ));

        $post_type = $this->props['post_type'];
        $user_id = get_current_user_id();

        $display_type = $this->props['display_type'];
        $related_content = $this->props['related_content'];
        $posts_number = $this->props['posts_number'];
        $attribute = $this->props['attribute'];

        $show_title = $this->props['show_title'];
        $title_tag = $this->props['title_tag'];
        $link_product = $this->props['link_product'];
        $link_product_in_new_tab = $this->props['link_product_in_new_tab'];
        
        $show_thumbnail = $this->props['show_thumbnail'];
        $thumb_image_size = $this->props['thumb_image_size'];

        $show_atc = $this->props['show_atc'];

        $hide_row_if_all_empty = $this->props['hide_row_if_all_empty'];
        
        if ($hide_row_if_all_empty == 'on') {
            $this->add_classname( 'hide_empty_row' );
        }
        
		$module_alignment 		= $this->props['module_alignment'];
		$this->add_classname( 'align-module_' . $module_alignment );

        
		$row_bg 		= $this->props['row_bg'];
		$row_bg_alternative 		= $this->props['row_bg_alternative'];

		$no_results_type 		= $this->props['no_results_type'];
		$no_results_text 		= $this->props['no_results_text'];
		$loop_layout 		= $this->props['loop_layout'];

        //Guest Option
        $guest_display_type     = $this->props['guest_display_type'];
        $guest_display_text     = $this->props['guest_display_text'];
        $guest_display_layout   = $this->props['guest_display_layout'];

		$column_alignment 		= $this->props['column_alignment'] ?: 'left';
        

        $custom_button  			= $this->props['custom_button'];
        $custom_icon          		= $this->props['button_icon'];
        $button_use_icon  			= $this->props['button_use_icon'];
        $button_icon 				= $this->props['button_icon'];
        $button_icon_placement 		= $this->props['button_icon_placement'];
        
        // Module classnames
        $this->add_classname(
            array(
                'clearfix',
                $this->get_text_orientation_classname(),
            )
        );

        $button_alignment             = $this->get_button_alignment();

        $this->add_classname( 'et_pb_button_alignment_' . $button_alignment . '' );
        $this->add_classname( 'dbc_column_alignment_' . $column_alignment . '' );
        
        if ($button_alignment == 'left') {
            ET_Builder_Element::set_style( $render_slug, array(
                'selector' => '%%order_class%% .table_button_atc',
                'declaration' => "text-align: left;"
                )
            );
        }
        if ($button_alignment == 'right') {
            ET_Builder_Element::set_style( $render_slug, array(
                'selector' => '%%order_class%% .table_button_atc',
                'declaration' => "text-align: right;"
                )
            );
        }
        
        if( $custom_button == 'on' ){
            
            // button icon
            if( $button_icon !== '' ){
                $button_icon_arr = explode('||', $button_icon);

                  $button_icon_font_family = ( !empty( $button_icon_arr[1] ) && $button_icon_arr[1] == 'fa' )?'FontAwesome':'ETmodules';
                  $button_icon_font_weight = ( !empty( $button_icon_arr[2] ))?$button_icon_arr[2]:'400';

                  if ( class_exists( 'DEBC_INIT' ) ) {
                      $iconContent = DEBC_INIT::et_icon_css_content( esc_attr($button_icon) );
                  } else if (class_exists( 'DEDMACH_INIT' ) ) {
                      $iconContent = DEDMACH_INIT::et_icon_css_content( esc_attr($button_icon) );
                  } else {
                      $iconContent = DE_Filter::et_icon_css_content( esc_attr($button_icon) );
                  }

                $iconSelector = '';
                if( $button_icon_placement == 'right' ){
                    $iconSelector = '%%order_class%% .button:after';
                }elseif( $button_icon_placement == 'left' ){
                    $iconSelector = '%%order_class%% .button:before';
                }

                if( !empty( $iconContent ) && !empty( $iconSelector ) ){
                    ET_Builder_Element::set_style( $render_slug, array(
                        'selector' => $iconSelector,
                        'declaration' => "content: '{$iconContent}'!important;
                        font-family:{$button_icon_font_family}!important;
                        font-weight:{$button_icon_font_weight};
                        display: inline-block;
                        line-height: inherit;
                        font-size: inherit!important;
                        margin-left: .3em;
                        left: auto;
                        display: inline-block;
                        "
                        )
                    );
                }
            }
            
            // fix the button padding if has no icon
            if( $button_use_icon == 'off' ){
                ET_Builder_Element::set_style( $render_slug, array(
                    'selector' => 'body.woocommerce %%order_class%% .button',
                    'declaration' => "padding: 0.3em 1em!important"
                    )
                );
            }
            // button text
            if( !empty( $button_text_color ) ){
                ET_Builder_Element::set_style( $render_slug, array(
                    'selector'    => 'body #page-container %%order_class%% .button',
                    'declaration' => "color:". esc_attr( $button_text_color ) ."!important;",
                ) );
            }
            // button text hover
            if( !empty( $button_text_color__hover ) ){
                ET_Builder_Element::set_style( $render_slug, array(
                    'selector'    => 'body #page-container %%order_class%% .button:hover',
                    'declaration' => "color:". esc_attr( $button_text_color__hover ) ."!important;",
                ) );
            }
        }


        ET_Builder_Element::set_style($render_slug, array(
            'selector'    => '%%order_class%% .et_pb_db_shop_comparetable_item',
            'declaration' => sprintf(
                'background-color: '.$row_bg.' !important;'
            ),
        ));

        ET_Builder_Element::set_style($render_slug, array(
            'selector'    => '%%order_class%% .et_pb_db_shop_comparetable_item:nth-child(2n)',
            'declaration' => sprintf(
                'background-color: '.$row_bg_alternative.' !important;'
            ),
        ));

        

        // PADDING 
        
		
		$table_item_padding 						= $this->props['table_item_padding'];
        $table_item_padding_tablet				= $this->props['table_item_padding_tablet'];
        $table_item_padding_phone				= $this->props['table_item_padding_phone'];
        $table_item_padding_last_edited			= $this->props['table_item_padding' . '_last_edited'];
        $table_item_padding_responsive_active 	= et_pb_get_responsive_status($table_item_padding_last_edited);

        if ('' !== $table_item_padding && '|||' !== $table_item_padding) {
            ET_Builder_Element::set_style($render_slug, array(
                'selector'    => '%%order_class%% .table_row .td_row',
                'declaration' => sprintf(
                'padding-top: %1$s; padding-right: %2$s; padding-bottom: %3$s; padding-left: %4$s;',
                esc_attr(et_pb_get_spacing($table_item_padding, 'top', '0px')),
                esc_attr(et_pb_get_spacing($table_item_padding, 'right', '0px')),
                esc_attr(et_pb_get_spacing($table_item_padding, 'bottom', '0px')),
                esc_attr(et_pb_get_spacing($table_item_padding, 'left', '0px'))
                ),
            ));
        }
        if ('' !== $table_item_padding_tablet && '|||' !== $table_item_padding_tablet) {
            ET_Builder_Element::set_style($render_slug, array(
                'selector'    => '%%order_class%% .table_row .td_row',
                'declaration' => sprintf(
                'padding-top: %1$s; padding-right: %2$s; padding-bottom: %3$s; padding-left: %4$s;',
                esc_attr(et_pb_get_spacing($table_item_padding_tablet, 'top', '0px')),
                esc_attr(et_pb_get_spacing($table_item_padding_tablet, 'right', '0px')),
                esc_attr(et_pb_get_spacing($table_item_padding_tablet, 'bottom', '0px')),
                esc_attr(et_pb_get_spacing($table_item_padding_tablet, 'left', '0px'))
                ),
                'media_query' => ET_Builder_Element::get_media_query('max_width_980')
            ));
        }
        if ('' !== $table_item_padding_phone && '|||' !== $table_item_padding_phone) {
            ET_Builder_Element::set_style($render_slug, array(
                'selector'    => '%%order_class%% .table_row .td_row',
                'declaration' => sprintf(
                'padding-top: %1$s; padding-right: %2$s; padding-bottom: %3$s; padding-left: %4$s;',
                esc_attr(et_pb_get_spacing($table_item_padding_phone, 'top', '0px')),
                esc_attr(et_pb_get_spacing($table_item_padding_phone, 'right', '0px')),
                esc_attr(et_pb_get_spacing($table_item_padding_phone, 'bottom', '0px')),
                esc_attr(et_pb_get_spacing($table_item_padding_phone, 'left', '0px'))
                ),
                'media_query' => ET_Builder_Element::get_media_query('max_width_767')
            ));
        }

        $compare_product_ids = array();
        global $post, $woocommerce;
        global $product;
        
        $no_posts = '';
        
        if ($display_type == 'manual') {

            if ( $user_id != 0 ) {
                $get_compare_settings = get_user_meta( $user_id, 'bc_wishlist_compare_compare', true );
                if ( !empty( $get_compare_settings['product'] ) ) {
                    $compare_product_ids = $get_compare_settings['product'];
                }
            }
            
            $compare_arg = array(
                'post_type'     => $post_type,
                'post_status'   => 'publish',
                'post__in'      => $compare_product_ids
            );

            if (!$compare_product_ids) {
                $no_posts = 'yes';
            }

        } else {

            $tax_array[] = "";

            if ($related_content == 'categories') {

                $taxonomy = 'product_cat';
                $field = 'id';

                $cats = wp_get_post_terms( $post->ID, $taxonomy );
                foreach ( $cats as $cat ) {
                    $tax_array[] = $cat->term_id;
                }

            } else if ($related_content == 'tags') {

                $taxonomy = 'product_tag';
                $field = 'id';

                $cats = wp_get_post_terms( $post->ID, $taxonomy );
                foreach ( $cats as $cat ) {
                    $tax_array[] = $cat->term_id;
                }

            } else {

                $taxonomy = $attribute;
                $field = 'slug';

                
                $product_id = $product->get_id();
                $product_terms = wp_get_object_terms($product_id, $attribute);
                foreach ( $product_terms as $product_term ) {
                    $tax_array[] = $product_term->slug;
                }
                
            }

            
            
            $compare_arg = array(
                'post_type'         => $post_type,
                'post_status'       => 'publish',
                'posts_per_page'    => (int) $posts_number,
                'post__not_in'      => array($post->ID),
                'tax_query'         => array(
                    'relation'      => 'AND',
                    array(
                        'taxonomy'  => 'product_visibility',
                        'field'     => 'name',
                        'terms'     => 'exclude-from-catalog',
                        'operator'  => 'NOT IN',
                    ),
                    array(
                        'taxonomy'  => $taxonomy,
                        'field'     => $field,
                        'terms'     => $tax_array,
                        'operator'  => 'IN'
                        )
                )
            );

            if (!is_single()) {
                $no_posts = 'yes';
            }

        }

        $compare_query = new WP_Query($compare_arg);

        $all_items_content = $this->get_compare_items_content();
        ob_start();

        if ( $display_type == 'manual' && $user_id == 0 ) {
            if ( $guest_display_type == 'text' ) {
                echo esc_html__( $guest_display_text );
            } else {
                $guest_layout_content = get_post_field( 'post_content', $guest_display_layout );
                echo apply_filters( 'the_content', wp_kses_post( $guest_layout_content ) );
            }

            $data = ob_get_clean();
            return $data;
        }

        if ($no_posts !== 'yes') {
            if ( $compare_query->have_posts() ) {
            
            ?>
            <div class="table_row hidethis">
                <div class="tr_row table_header">
                    <div class="td_row"></div>
            <?php if ( $display_type == 'automatic' ) { ?>
                    <div class="td_row">
                        <?php 
                        if ( $show_thumbnail == 'on' ) { ?>
                            <div class="compare_thumbnail">
                                <?php 
                                echo get_the_post_thumbnail(get_the_id(), $thumb_image_size, array(
                                    'class' => 'featured-image'
                                ));
                                ?>
                            </div>
                        <?php } ?>
                        
                        <?php 
                        if ( $show_title == 'on' ) { ?>
                            <?php 
                            if ( $link_product == 'on' ) { ?>
                                <a href="<?php echo the_permalink();?>" target="<?php echo ($link_product_in_new_tab == 'on')?"_blank":"";?>">
                            <?php } ?>
                            
                            <<?php echo esc_attr($title_tag);?> class="compare_title">
                                <?php the_title(); ?>
                            </<?php echo esc_attr($title_tag);?>>
                            
                            <?php if ( $link_product == 'on' ) { ?>
                                </a>
                            <?php } ?>
                        <?php }?>
                    </div>
            <?php } ?>
                    <?php
                    while ( $compare_query->have_posts() ) {
                        $compare_query->the_post();
                        ?>
                        <div class="td_row">
                            <?php 
                            if ( $show_thumbnail == 'on' ) { ?>
                                <div class="compare_thumbnail">
                                    <?php 
                                    echo get_the_post_thumbnail(get_the_id(), $thumb_image_size, array(
                                        'class' => 'featured-image'
                                    ));
                                    ?>
                                </div>
                            <?php } ?>
                            
                            <?php 
                            if ( $show_title == 'on' ) { ?>
                                <?php 
                                if ( $link_product == 'on' ) { ?>
                                    <a href="<?php echo the_permalink();?>" target="<?php echo ($link_product_in_new_tab == 'on')?"_blank":"";?>">
                                <?php } ?>
                                
                                <<?php echo esc_attr($title_tag);?> class="compare_title">
                                    <?php the_title(); ?>
                                </<?php echo esc_attr($title_tag);?>>
                                
                                <?php if ( $link_product == 'on' ) { ?>
                                    </a>
                                <?php } ?>
                            <?php }?>
                        </div>
                    <?php
                    }
                    ?>
                </div>

                <?php echo $all_items_content; ?>

                <?php if ($show_atc == 'on') { ?>
                <div class="tr_row table_footer">
                    <div class="td_row"></div>
                <?php if ( $display_type == 'automatic' ) { ?>
                    <div class="td_row table_button_atc">
                        <?php 
                        $current_product_args = array(
                            'quantity'   => 1,
                            'class'      => implode(
                                ' ',
                                array_filter(
                                    array(
                                        'button',
                                        'product_type_' . $product->get_type(),
                                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                                        $product->supports( 'ajax_add_to_cart' ) && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
                                    )
                                )
                            ),
                            'attributes' => array(
                                'data-product_id'  => $product->get_id(),
                                'data-product_sku' => $product->get_sku(),
                                'aria-label'       => $product->add_to_cart_description(),
                                'rel'              => 'nofollow',
                            ),
                        );

                        woocommerce_template_loop_add_to_cart( $current_product_args );
                        ?>
                    </div>
            <?php } ?>
                    <?php
                    while ( $compare_query->have_posts() ) {
                        $compare_query->the_post();
                        ?>
                        <div class="td_row table_button_atc">
                            <?php 
                            woocommerce_template_loop_add_to_cart(); 
                            ?>
                        </div>
                        <?php 
                    }
                    ?>
                </div>
                <?php } ?>

            </div>
            <?php
            } else{
                if ($no_results_type == 'text') {
                    echo esc_html__($no_results_text);
                } else {
                    $loop_layout_content = get_post_field('post_content', $loop_layout);
                    echo apply_filters('the_content', wp_kses_post($loop_layout_content));
                }
            }

        } else {
            if ($no_results_type == 'text') {
                echo esc_html__($no_results_text);
            } else {
                $loop_layout_content = get_post_field('post_content', $loop_layout);
                echo apply_filters('the_content', wp_kses_post($loop_layout_content));
            }
        }

        $data = ob_get_clean();
        //////////////////////////////////////////////////////////////////////
        return $data;
    }
}

new db_shop_comparetable_code;

    ?>
