<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class db_shop_comparetable_item_code extends ET_Builder_Module {

    public $vb_support = 'on';

    public $folder_name;
    public $fields_defaults;
    public $text_shadow;
    public $margin_padding;
    public $advanced_setting_title_text;
    public $settings_text;
    public $_additional_fields_options;

    protected $module_credits = array(
        'module_uri' => DE_DB_PRODUCT_URL,
        'author'     => DE_DB_AUTHOR,
        'author_uri' => DE_DB_URL,
    );

    function init() {
        $this->name       = esc_html__( 'CompareTable Item', 'divi-bodyshop-woocommerce' );
        $this->slug = 'et_pb_db_shop_comparetable_item';
        $this->vb_support      = 'on';
        $this->type                        = 'child';
        $this->child_title_var             = 'title';
        $this->advanced_setting_title_text = esc_html__( 'New CompareTable Item', 'divi-bodyshop-woocommerce' );
        $this->settings_text               = esc_html__( 'CompareTable Item Settings', 'divi-bodyshop-woocommerce' );
        $this->folder_name = 'divi_bodycommerce';


        $this->fields_defaults = array(
        // 'loop_layout'         => array( 'on' ),
        );

        $this->settings_modal_toggles = array(
            'general' => array(
                'toggles' => array(
                    'main_content' => esc_html__( 'Main Options', 'divi-bodyshop-woocommerce' ),
                    'ratings' => esc_html__( 'Ratings', 'divi-bodyshop-woocommerce' ),
					'value_icons'		=> array(
						'title' => esc_html__( 'Icons', 'divi-form-builder'),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'empty_icon'     => array(
								'name' => esc_html__( 'Empty Icon', 'divi-form-builder')
							),
							'not_empty_icon'     => array(
								'name' => esc_html__( 'Not Empty Icon', 'divi-form-builder')
							)
						)
					),
                ),
            ),
        );


        $this->main_css_element = '%%order_class%%';


        $this->advanced_fields = array(
            'fonts' => array(
                'label_text' => array(
                    'label'    => esc_html__( 'Label', 'divi-bodyshop-woocommerce' ),
                    'css'      => array(
                            'main' => "%%order_class%% .dbc_compare_label",
                        'important' => 'plugin_only',
                    ),
                    'font_size' => array(
                        'default' => '14px',
                    ),
                    'line_height' => array(
                        'default' => '1em',
                    ),
                ),
                'value_text' => array(
                    'label'    => esc_html__( 'Value', 'divi-bodyshop-woocommerce' ),
                    'css'      => array(
                            'main' => "%%order_class%% .dbc_compare_value, %%order_class%% .dbc_compare_value a",
                        'important' => 'plugin_only',
                    ),
                    'font_size' => array(
                        'default' => '14px',
                    ),
                    'line_height' => array(
                        'default' => '1em',
                    ),
                ),
            ),
            'background' => array(
                'settings' => array(
                    'color' => 'alpha',
                ),
            ),
            'button' => array(
            ),
        );


        $this->custom_css_fields = array(
        );


        $this->help_videos = array(
        );
    }

    function get_fields() {
        $et_accent_color = et_builder_accent_color();

        ///////////////////////////////
        $acf_fields = array();
        $productattr = array();

        $comparetable_item_type['title'] = esc_html__('Title', 'divi-bodyshop-woocommerce');
        $comparetable_item_type['description'] = esc_html__('Description', 'divi-bodyshop-woocommerce');
        
        
        if ( class_exists('WooCommerce') ){
            $comparetable_item_type['attribute'] = esc_html__('Attribute', 'divi-bodyshop-woocommerce');
            $attribute_taxonomies = wc_get_attribute_taxonomies();
            $productattr['none'] = 'Please select an Product Attribute';
            if ( $attribute_taxonomies ) {
                foreach ( $attribute_taxonomies as $tax ) {
                    $productattr[esc_attr( wc_attribute_taxonomy_name( $tax->attribute_name ) )] = esc_html( $tax->attribute_label );
                }
            }

            $comparetable_item_type['price'] = esc_html__('Price', 'divi-bodyshop-woocommerce');
            $comparetable_item_type['rating'] = esc_html__('Rating', 'divi-bodyshop-woocommerce');
            $comparetable_item_type['stock'] = esc_html__('Stock Status', 'divi-bodyshop-woocommerce');
            $comparetable_item_type['sku'] = esc_html__('SKU', 'divi-bodyshop-woocommerce');
        }

        // if ( function_exists('acf_get_field_groups') ) {
        //     $acf_fields = DEBC_INIT::get_acf_fields();
        //     $comparetable_item_type['acf'] = esc_html__('Advanced Custom Field(ACF Plugin)', 'divi-bodyshop-woocommerce');
        // }
        
        $comparetable_item_type['meta'] = esc_html__('Custom Meta Field', 'divi-bodyshop-woocommerce');
        $comparetable_item_type['category'] = esc_html__('Category', 'divi-bodyshop-woocommerce');
        $comparetable_item_type['tag'] = esc_html__('Tag', 'divi-bodyshop-woocommerce');
        $comparetable_item_type['taxonomy'] = esc_html__('Custom Taxonomy', 'divi-bodyshop-woocommerce');

        /*if (class_exists('DMACHACC_DiviMachineAccount')) {
            $dmach_acc_types_saved = de_get_option_value('divi-bodyshop-woocommerce', 'dmach_acc_types_saved'); //$titan->getOption( 'dmach_acc_types_saved' );
            $dmach_acc_types_saved_array = explode(',', $dmach_acc_types_saved);

            foreach ($dmach_acc_types_saved_array as $field) {
                $post_display_type_fields[$field] = esc_html__($field, 'divi-bodyshop-woocommerce');
            }
        }*/

        //////////////////////////////

		$et_accent_color = et_builder_accent_color();

        $fields = array(
            'title' => array(
                'label'           => esc_html__( 'CompareTable Item Name', 'divi-bodyshop-woocommerce' ),
                'type'            => 'text',
                'description'     => esc_html__( 'Define Compare Table Field name to show on Compare Table.', 'divi-bodyshop-woocommerce' ),
                'toggle_slug'     => 'main_content',
                'dynamic_content' => 'text',
                'option_category' => 'configuration',
            ),
            'item_type' => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'What do you want to add to compare table?', 'divi-bodyshop-woocommerce' ),
                'type'              => 'select',
                'options'           => $comparetable_item_type,
                'default'           => 'title',
                'affects'         => array(
                    'show_excerpt',
                    'acf_name',
                    'attribute_name',
                    'taxonomy_name',
                    'custom_meta_name',
                ),
                'option_category'   => 'configuration',
                'description'       => esc_html__( 'Choose which field you want to add to the compare table.', 'divi-bodyshop-woocommerce' ),
            ),
            'show_excerpt'  => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'Show Excerpt', 'divi-bodyshop-woocommerce' ),
                'type'              => 'yes_no_button',
                'option_category'   => 'configuration',
                'default'           => 'off',
                'options'           => array(
                    'on'            => et_builder_i18n( 'Yes' ),
                    'off'           => et_builder_i18n( 'No' ),
                ),
                'depends_show_if'   => 'description',
                'description'       => esc_html__( 'Enable this option to show excerpt instead of full content.', 'divi-form-builder' ),
            ),
            'acf_name' => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'ACF Name', 'divi-bodyshop-woocommerce' ),
                'type'              => 'select',
                'options'           => $acf_fields,
                'default'           => 'none',
                'depends_show_if'   => 'acf',
                'option_category'   => 'configuration',
                'description'       => esc_html__( 'Add the name of the ACF you want to display here', 'divi-bodyshop-woocommerce' ),
            ),
            'attribute_name' => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'Attribute Name', 'divi-bodyshop-woocommerce' ),
                'type'              => 'select',
                'default'           => 'none',
                'options'           => $productattr,
                'depends_show_if'   => 'attribute',
                'option_category'   => 'configuration',
                'description'       => esc_html__( 'Add the name of the ACF you want to display here', 'divi-bodyshop-woocommerce' ),
            ),
            'taxonomy_name' => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'Custom Taxonomy Name', 'divi-bodyshop-woocommerce' ),
                'type'              => 'select',
                'default'           => '',
                'depends_show_if'   => 'taxonomy',
                'options'           => get_taxonomies( array( '_builtin' => FALSE ) ),
                'option_category'   => 'configuration',
                'description'       => esc_html__( 'Add the name of the ACF you want to display here', 'divi-bodyshop-woocommerce' ),
            ),
            'custom_meta_name' => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'Custom Meta Field Name', 'divi-bodyshop-woocommerce' ),
                'type'              => 'text',
                'default'           => '',
                'depends_show_if'   => 'meta',
                'option_category'   => 'configuration',
                'description'       => esc_html__( 'Add the name of the ACF you want to display here', 'divi-bodyshop-woocommerce' ),
            ),

            
            'not_empty_display'             => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'Not Empty Display', 'divi-bodyshop-woocommerce' ),
                'type'              => 'select',
                'options'           => array(
                    'value'        => esc_html__( 'Value', 'divi-bodyshop-woocommerce' ),
                    'icon'     => esc_html__( 'Icon', 'divi-bodyshop-woocommerce' ),
                ),
                'option_category'   => 'configuration',
                'default'           => 'value',
                'description'       => esc_html__( 'Choose what you want to display when there is a value for example it has the attribute.', 'divi-bodyshop-woocommerce' ),
                'show_if_not'       => array('item_type' => 'title', 'description', 'price', 'rating', 'category', 'tag', 'taxonomy', 'sku')
            ),
			'not_empty_icon'				=> array(
                'toggle_slug'       => 'main_content',
				'label'             => esc_html__( 'Not Empty Icon', 'divi-form-builder' ),
				'type'              => 'select_icon',
                'option_category'   => 'configuration',
				'class'             => array( 'et-pb-font-icon' ),
				'description'       => esc_html__( 'Choose the icon that shows if there is a value returned', 'divi-form-builder' ),
				'show_if' 			=> array('not_empty_display' => 'icon'),
				'default'			=> 'N||divi||400',
                'show_if_not'       => array('item_type' => 'title', 'description', 'price', 'rating', 'category', 'tag', 'taxonomy', 'sku')
			),            
            'empty_display'             => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'Empty Display', 'divi-bodyshop-woocommerce' ),
                'type'              => 'select',
                'options'           => array(
                    'blank'        => esc_html__( 'Blank', 'divi-bodyshop-woocommerce' ),
                    'custom_text'        => esc_html__( 'Custom Text', 'divi-bodyshop-woocommerce' ),
                    'icon'     => esc_html__( 'Icon', 'divi-bodyshop-woocommerce' ),
                ),
                'option_category'   => 'configuration',
                'default'           => 'blank',
                'description'       => esc_html__( 'Choose what you want to display when there is NOT a value for example it has NO attribute.', 'divi-bodyshop-woocommerce' ),
                'show_if_not'       => array('item_type' => 'title', 'description', 'price', 'rating', 'category', 'tag', 'taxonomy', 'sku')
            ),
            'empty_text' => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'Empty Custom Text', 'divi-bodyshop-woocommerce' ),
                'type'              => 'text',
                'default'           => '',
                'depends_show_if'   => 'meta',
                'option_category'   => 'configuration',
                'description'       => esc_html__( 'Add the text that shows if there is no value', 'divi-bodyshop-woocommerce' ),
				'show_if' 			=> array('empty_display' => 'custom_text'),
            ),
			'empty_icon'				=> array(
                'toggle_slug'       => 'main_content',
				'label'             => esc_html__( 'Empty Icon', 'divi-form-builder' ),
				'type'              => 'select_icon',
                'option_category'   => 'configuration',
				'class'             => array( 'et-pb-font-icon' ),
				'description'       => esc_html__( 'Choose the icon that shows if there is a value returned', 'divi-form-builder' ),
				'show_if' 			=> array('empty_display' => 'icon'),
				'default'			=> 'N||divi||400',
			),

            
            'ratings_primary_color' => array(
				'label'               => esc_html__( 'Ratings Primary Color', 'divi-form-builder' ),
				'type'              => 'color-alpha',
				'description'       => esc_html__( 'Choose the primary color for the ratings.', 'divi-form-builder' ),
				'depends_show_if' 	=> 'on',
				'default'         => $et_accent_color,
				'toggle_slug'     	=> 'ratings',
				'tab_slug'     	 	=> 'advanced',
                'show_if'           => array('item_type' => 'rating')
			),
            'ratings_secondary_color' => array(
				'label'               => esc_html__( 'Ratings Primary Color', 'divi-form-builder' ),
				'type'              => 'color-alpha',
				'description'       => esc_html__( 'Choose the primary color for the ratings.', 'divi-form-builder' ),
				'depends_show_if' 	=> 'on',
				'default'         => '#cccccc',
				'toggle_slug'     	=> 'ratings',
				'tab_slug'     	 	=> 'advanced',
                'show_if'           => array('item_type' => 'rating')
			),

            
			'empty_icon_color' => array(
				'label'               => esc_html__( 'Empty Icon Color', 'divi-form-builder' ),
				'type'              => 'color-alpha',
				'description'       => esc_html__( 'Here you can define a custom color for your empty icon.', 'divi-form-builder' ),
				'default'         => '#000000',
				'toggle_slug'     	=> 'value_icons',
                'sub_toggle'		=> 'empty_icon',
				'tab_slug'     	 	=> 'advanced',
			),
			'empty_icon_size' => array(
				'label'               => esc_html__( 'Empty Icon Font Size', 'divi-form-builder' ),
				'type'            => 'range',
				'default'         => '18px',
				'default_unit'    => 'px',
				'default_on_front'=> '',
				'range_settings' => array(
					'min'  => '1',
					'max'  => '120',
					'step' => '1',
				),
				'depends_show_if' 	=> 'on',
				'toggle_slug'     	=> 'value_icons',
                'sub_toggle'		=> 'empty_icon',
				'tab_slug'     	 	=> 'advanced',
			),
            'not_empty_icon_color' => array(
				'label'               => esc_html__( 'Not Empty Icon Color', 'divi-form-builder' ),
				'type'              => 'color-alpha',
				'description'       => esc_html__( 'Here you can define a custom color for your NOT empty icon.', 'divi-form-builder' ),
				'depends_show_if' 	=> 'on',
				'default'         => '#000000',
				'toggle_slug'     	=> 'value_icons',
                'sub_toggle'		=> 'not_empty_icon',
				'tab_slug'     	 	=> 'advanced',
			),
			'not_empty_icon_size' => array(
				'label'               => esc_html__( 'Not Empty Icon Font Size', 'divi-form-builder' ),
				'type'            => 'range',
				'default'         => '18px',
				'default_unit'    => 'px',
				'default_on_front'=> '',
				'range_settings' => array(
					'min'  => '1',
					'max'  => '120',
					'step' => '1',
				),
				'depends_show_if' 	=> 'on',
				'toggle_slug'     	=> 'value_icons',
                'sub_toggle'		=> 'not_empty_icon',
				'tab_slug'     	 	=> 'advanced',
			),
        );
        return $fields;
    }



    function render($attrs, $content, $render_slug){

        if ( is_admin() && ( ! defined( 'DOING_AJAX' ) || ! DOING_AJAX ) ) {
            return;
        }

        $title                  = $this->props['title'];
        $item_type              = $this->props['item_type'];
        $acf_name               = $this->props['acf_name'];
        $attribute_name         = $this->props['attribute_name'];
        $taxonomy_name          = $this->props['taxonomy_name'];
        $custom_meta_name       = $this->props['custom_meta_name'];
        $show_excerpt           = $this->props['show_excerpt'];


        $not_empty_display           = $this->props['not_empty_display'];
        $not_empty_icon           = $this->props['not_empty_icon'];
        $empty_display           = $this->props['empty_display'];
        $empty_text           = $this->props['empty_text'];
        $empty_icon           = $this->props['empty_icon'];
        $empty_icon_color           = $this->props['empty_icon_color'];
        $empty_icon_size           = $this->props['empty_icon_size'] ?: '18px';

        $ratings_primary_color           = $this->props['ratings_primary_color'];
        $ratings_secondary_color           = $this->props['ratings_secondary_color'];
        
        // Module classnames
        $this->add_classname(
            array(
                'clearfix',
                $this->get_text_orientation_classname(),
            )
        );
        
        if ($item_type == 'rating') {

            ET_Builder_Element::set_style($render_slug, array(
				'selector'    => '%%order_class%% .star-rating span::before',
				'declaration' => sprintf('color:%1s;',$ratings_primary_color),
            ));

            ET_Builder_Element::set_style($render_slug, array(
				'selector'    => '.woocommerce %%order_class%% .star-rating:before',
				'declaration' => sprintf('color:%1s;',$ratings_secondary_color),
            ));

        }

        if ($empty_display == 'icon') {

            $empty_icon_arr = explode('||', $empty_icon);

            $empty_icon_font_family = ( !empty( $empty_icon_arr[1] ) && $empty_icon_arr[1] == 'fa' )?'FontAwesome':'ETmodules';
            $empty_icon_font_weight = ( !empty( $empty_icon_arr[2] ))?$empty_icon_arr[2]:'400';

            $iconContent = DEBC_INIT::et_icon_css_content( esc_attr($empty_icon) );
            

            ET_Builder_Element::set_style($render_slug, array(
				'selector'    => '%%order_class%% .dbc_compare_icon.empty-value::after',
				'declaration' => sprintf(
					'
                    display: inline-block;
					position: absolute;
					left: 0px;
					top: 0px;
					content:"%1s";
					font-size:%2s;
					color:%3s;
					font-family:%4$s!important;
					font-weight:%5$s;
					',$iconContent,
					$empty_icon_size,
					$empty_icon_color,
					$empty_icon_font_family,
					$empty_icon_font_weight
				),
			));

            ET_Builder_Element::set_style($render_slug, array(
				'selector'    => '.dbc_compare_icon',
				'declaration' => sprintf('position: relative;'),
            ));
        }
        
        if ($not_empty_display == 'icon') {

            $not_empty_icon_arr = explode('||', $not_empty_icon);

            $not_empty_icon_font_family = ( !empty( $not_empty_icon_arr[1] ) && $not_empty_icon_arr[1] == 'fa' )?'FontAwesome':'ETmodules';
            $not_empty_icon_font_weight = ( !empty( $not_empty_icon_arr[2] ))?$not_empty_icon_arr[2]:'400';

            $not_empty_iconContent = DEBC_INIT::et_icon_css_content( esc_attr($not_empty_icon) );
            

            ET_Builder_Element::set_style($render_slug, array(
				'selector'    => '%%order_class%% .dbc_compare_icon.not-empty-value::after',
				'declaration' => sprintf(
					'
                    display: inline-block;
					position: absolute;
					left: 0px;
					top: 0px;
					content:"%1s";
					font-size:%2s;
					color:%3s;
					font-family:%4$s!important;
					font-weight:%5$s;
					',$not_empty_iconContent,
					$not_empty_icon_size,
					$not_empty_icon_color,
					$not_empty_icon_font_family,
					$not_empty_icon_font_weight
				),
			));

            ET_Builder_Element::set_style($render_slug, array(
				'selector'    => '.dbc_compare_icon',
				'declaration' => sprintf('position: relative;'),
            ));

            

        }

        $parent_module = self::get_parent_modules('page')['et_pb_db_shop_comparetable'];

        $post_type = $parent_module->props['post_type'];
        $display_type = $parent_module->props['display_type'];
        $related_content = $parent_module->props['related_content'];
        $posts_number = $parent_module->props['posts_number'];

        global $post, $product, $woocommerce;

        //////////////////////////////////////////////////////////////////////

        $user_id = get_current_user_id();
        
        $compare_product_ids = array();
        if ($display_type == 'manual') {

            if ( $user_id != 0 ) {
                $get_compare_settings = get_user_meta( $user_id, 'bc_wishlist_compare_compare', true );
                if ( !empty( $get_compare_settings['product'] ) ) {
                    $compare_product_ids = $get_compare_settings['product'];
                }
            }
            
            $compare_arg = array(
                'post_type'     => $post_type,
                'post_status'   => 'publish',
                'post__in'      => $compare_product_ids
            );

            if (!$compare_product_ids) {
                $no_posts = 'yes';
            }

        } else {

            $tax_array[] = "";

            if ($related_content == 'categories') {

                $taxonomy = 'product_cat';
                $field = 'id';

                $cats = wp_get_post_terms( $post->ID, $taxonomy );
                foreach ( $cats as $cat ) {
                    $tax_array[] = $cat->term_id;
                }

            } else if ($related_content == 'tags') {

                $taxonomy = 'product_tag';
                $field = 'id';

                $cats = wp_get_post_terms( $post->ID, $taxonomy );
                foreach ( $cats as $cat ) {
                    $tax_array[] = $cat->term_id;
                }

            } else {

                $taxonomy = $attribute;
                $field = 'slug';

                
                $product_id = $product->get_id();
                $product_terms = wp_get_object_terms($product_id, $attribute);
                foreach ( $product_terms as $product_term ) {
                    $tax_array[] = $product_term->slug;
                }
                
            }

            
            
            $compare_arg = array(
                'post_type'         => $post_type,
                'post_status'       => 'publish',
                'posts_per_page'    => (int) $posts_number,
                'post__not_in'      => array($post->ID),
                'tax_query'         => array(
                    'relation'      => 'AND',
                    array(
                        'taxonomy'  => 'product_visibility',
                        'field'     => 'name',
                        'terms'     => 'exclude-from-catalog',
                        'operator'  => 'NOT IN',
                    ),
                    array(
                        'taxonomy'  => $taxonomy,
                        'field'     => $field,
                        'terms'     => $tax_array,
                        'operator'  => 'IN'
                        )
                )
            );

            if (!is_single()) {
                $no_posts = 'yes';
            }

        }

        if ( $no_posts == 'yes' ) {
            return '';
        }

        $compare_query = new WP_Query($compare_arg);
        ob_start();
        ?>
        <div class="td_row dbc_compare_label"> <?php echo esc_html( ucfirst($title) ) ?> </div>
<?php   
        if ( $display_type == 'automatic' ) {
            $post_id = get_the_ID();
            if ( $post_type == 'product' && class_exists('WooCommerce') ) {
                $product = wc_get_product( $post_id );
            }
            if ( $item_type == 'title' ) {
                ?>
                <div class="td_row dbc_compare_value"><?php the_title();?></div>
                <?php
            } else if ( $item_type == 'description' ){
                ?>
                <div class="td_row dbc_compare_value">
                <?php 
                if ( $show_excerpt == 'on' ) {
                    the_excerpt();
                } else {
                    the_content();
                }
                ?>
                </div>
                <?php                    
            } else if ( $item_type == 'price' ) {

                $price = $product->get_price_html();

                if ($price == '') {
                    $this->add_classname( 'empty_compare_item' );
                } else {
                    $this->add_classname( 'compare_item_not_empty' );
                }
                ?>
                <div class="td_row dbc_compare_value"><?php echo wp_kses_post($price); ?></div>
                <?php                    
            } else if ( $item_type == 'rating' ) {
                $rating  = $product->get_average_rating();
                $count   = $product->get_rating_count();

                if ($rating == '') {
                    $this->add_classname( 'empty_compare_item' );
                } else {
                    $this->add_classname( 'compare_item_not_empty' );
                }

                ?>
                <div class="td_row dbc_compare_value"><?php echo wc_get_rating_html( $rating, $count );?></div>
                <?php                    
            } else if ( $item_type == 'meta' ) {
                $meta_value = '';
                
                if ( $custom_meta_name != '' ) {
                    $meta_value = get_post_meta( $post_id, $custom_meta_name, true );
                    if ($meta_value == '') {
                        $this->add_classname( 'empty_compare_item' );
                        if ($empty_display == 'icon') {
                            $meta_value = '<span class="dbc_compare_icon empty-value"></span>';
                        } else if ($empty_display == 'custom_text') {
                            $meta_value = $empty_text;
                        } else {
                            $meta_value = '';
                        }
                    } else {
                        $this->add_classname( 'compare_item_not_empty' );
                        if ($not_empty_display == 'icon') {
                            $meta_value = '<span class="dbc_compare_icon not-empty-value"></span>';
                        } else {
                            $meta_value = $meta_value;
                        }
                    }
                }

                ?>
                <div class="td_row dbc_compare_value"><?php echo $meta_value;?></div>
                <?php                    

            } else if ( $item_type == 'category' ) {
                $cat_tax = 'category';
                if ( $post_type == 'product' && class_exists('WooCommerce') ) {
                    $cat_tax = 'product_cat';
                } else if ( $post_type != 'post' ) {
                    $cat_tax = $post_type . '_category';
                }

                $category_terms = wp_get_object_terms( $post_id,  $cat_tax );
                $terms = array();
                foreach( $category_terms as $term ) {
                    $terms[] = '<a href="' . esc_url( get_term_link( $term->slug, $cat_tax ) ) . '">' . esc_html( $term->name ) . '</a>';
                }
                if (!$terms) {
                    $this->add_classname( 'empty_compare_item' );
                } else {
                    $this->add_classname( 'compare_item_not_empty' );
                }
                ?>
                <div class="td_row dbc_compare_value"><?php echo implode(', ', $terms );?></div>
                <?php                    
            } else if ( $item_type == 'tag' ) {
                $tag_tax = $post_type . '_tag';
                
                $tag_terms = wp_get_object_terms( $post->ID,  $tag_tax );
                $terms = array();
                foreach( $tag_terms as $term ) {
                    $terms[] = '<a href="' . esc_url( get_term_link( $term->slug, $cat_tax ) ) . '">' . esc_html( $term->name ) . '</a>';
                }
                if (!$terms) {
                    $this->add_classname( 'empty_compare_item' );
                } else {
                    $this->add_classname( 'compare_item_not_empty' );
                }
                ?>
                <div class="td_row dbc_compare_value"><?php echo implode(', ', $terms );?></div>
                <?php                    
            } else if ( $item_type == 'taxonomy' ) {
                $tax_terms = wp_get_object_terms( $post->ID,  $taxonomy_name );
                $terms = array();
                foreach( $tax_terms as $term ) {
                    $terms[] = '<a href="' . esc_url( get_term_link( $term->slug, $taxonomy_name ) ) . '">' . esc_html( $term->name ) . '</a>';
                }
                if (!$terms) {
                    $this->add_classname( 'empty_compare_item' );
                } else {
                    $this->add_classname( 'compare_item_not_empty' );
                }
                ?>
                <div class="td_row dbc_compare_value"><?php echo implode(', ', $terms );?></div>
                <?php                    
            } else if ( $item_type == 'stock' ) {
                $stock = wc_get_stock_html( $product );

                if (!$product->is_in_stock()) {
                    $this->add_classname( 'empty_compare_item' );
                    if ($empty_display == 'icon') {
                        $stock = '<span class="dbc_compare_icon empty-value"></span>';
                    } else if ($empty_display == 'custom_text') {
                        $stock = $empty_text;
                    } else {
                        $stock = '';
                    }
                } else {
                    $this->add_classname( 'compare_item_not_empty' );
                    if ($not_empty_display == 'icon') {
                        $stock = '<span class="dbc_compare_icon not-empty-value"></span>';
                    } else {
                        $stock = $stock;
                    }
                }

                ?>
                <div class="td_row dbc_compare_value"><?php echo wp_kses_post($stock);?></div>
                <?php                    

            } else if ( $item_type == 'sku' ) {

                $sku = $product->get_sku();

                if ($sku == '') {
                    $this->add_classname( 'empty_compare_item' );
                } else {
                    $this->add_classname( 'compare_item_not_empty' );
                }
                ?>

                <div class="td_row dbc_compare_value"><?php echo esc_html($sku); ?></div>
                <?php                    
            } else if ( $item_type == 'attribute' ) {

                $attributes = $product->get_attribute( $attribute_name );

                if ($attributes == '') {
                    $this->add_classname( 'empty_compare_item' );
                    if ($empty_display == 'icon') {
                        $attributes = '<span class="dbc_compare_icon empty-value"></span>';
                    } else if ($empty_display == 'custom_text') {
                        $attributes = $empty_text;
                    } else {
                        $attributes = '';
                    }
                } else {
                    $this->add_classname( 'compare_item_not_empty' );
                    if ($not_empty_display == 'icon') {
                        $attributes = '<span class="dbc_compare_icon not-empty-value"></span>';
                    } else {
                        $attributes = $attributes;
                    }
                }
                ?>
                <div class="td_row dbc_compare_value">
                    <?php
                        echo wp_kses_post($attributes);
                    ?>
                </div>
                <?php

            }
        }

        if ( $compare_query->have_posts() ) {
            while ( $compare_query->have_posts() ) {
                $compare_query->the_post();
                $post_id = get_the_ID();
                if ( $post_type == 'product' && class_exists('WooCommerce') ) {
                    $product = wc_get_product( $post_id );
                }
                if ( $item_type == 'title' ) {
                    ?>
                    <div class="td_row dbc_compare_value"><?php the_title();?></div>
                    <?php
                } else if ( $item_type == 'description' ){
                    ?>
                    <div class="td_row dbc_compare_value">
                    <?php 
                    if ( $show_excerpt == 'on' ) {
                        the_excerpt();
                    } else {
                        the_content();
                    }
                    ?>
                    </div>
                    <?php                    
                } else if ( $item_type == 'price' ) {

                    $price = $product->get_price_html();

                    if ($price == '') {
                        $this->add_classname( 'empty_compare_item' );
                    } else {
                        $this->add_classname( 'compare_item_not_empty' );
                    }
                    ?>
                    <div class="td_row dbc_compare_value"><?php echo wp_kses_post($price); ?></div>
                    <?php                    
                } else if ( $item_type == 'rating' ) {
                    $rating  = $product->get_average_rating();
                    $count   = $product->get_rating_count();

                    if ($rating == '') {
                        $this->add_classname( 'empty_compare_item' );
                    } else {
                        $this->add_classname( 'compare_item_not_empty' );
                    }

                    ?>
                    <div class="td_row dbc_compare_value"><?php echo wc_get_rating_html( $rating, $count );?></div>
                    <?php                    
                } else if ( $item_type == 'meta' ) {
                    $meta_value = '';
                    
                    if ( $custom_meta_name != '' ) {
                        $meta_value = get_post_meta( $post_id, $custom_meta_name, true );
                        if ($meta_value == '') {
                            $this->add_classname( 'empty_compare_item' );
                            if ($empty_display == 'icon') {
                                $meta_value = '<span class="dbc_compare_icon empty-value"></span>';
                            } else if ($empty_display == 'custom_text') {
                                $meta_value = $empty_text;
                            } else {
                                $meta_value = '';
                            }
                        } else {
                            $this->add_classname( 'compare_item_not_empty' );
                            if ($not_empty_display == 'icon') {
                                $meta_value = '<span class="dbc_compare_icon not-empty-value"></span>';
                            } else {
                                $meta_value = $meta_value;
                            }
                        }
                    }

                    ?>
                    <div class="td_row dbc_compare_value"><?php echo $meta_value;?></div>
                    <?php                    

                } else if ( $item_type == 'category' ) {
                    $cat_tax = 'category';
                    if ( $post_type == 'product' && class_exists('WooCommerce') ) {
                        $cat_tax = 'product_cat';
                    } else if ( $post_type != 'post' ) {
                        $cat_tax = $post_type . '_category';
                    }

                    $category_terms = wp_get_object_terms( $post_id,  $cat_tax );
                    $terms = array();
                    foreach( $category_terms as $term ) {
                        $terms[] = '<a href="' . esc_url( get_term_link( $term->slug, $cat_tax ) ) . '">' . esc_html( $term->name ) . '</a>';
                    }
                    if (!$terms) {
                        $this->add_classname( 'empty_compare_item' );
                    } else {
                        $this->add_classname( 'compare_item_not_empty' );
                    }
                    ?>
                    <div class="td_row dbc_compare_value"><?php echo implode(', ', $terms );?></div>
                    <?php                    
                } else if ( $item_type == 'tag' ) {
                    $tag_tax = $post_type . '_tag';
                    
                    $tag_terms = wp_get_object_terms( $post->ID,  $tag_tax );
                    $terms = array();
                    foreach( $tag_terms as $term ) {
                        $terms[] = '<a href="' . esc_url( get_term_link( $term->slug, $cat_tax ) ) . '">' . esc_html( $term->name ) . '</a>';
                    }
                    if (!$terms) {
                        $this->add_classname( 'empty_compare_item' );
                    } else {
                        $this->add_classname( 'compare_item_not_empty' );
                    }
                    ?>
                    <div class="td_row dbc_compare_value"><?php echo implode(', ', $terms );?></div>
                    <?php                    
                } else if ( $item_type == 'taxonomy' ) {
                    $tax_terms = wp_get_object_terms( $post->ID,  $taxonomy_name );
                    $terms = array();
                    foreach( $tax_terms as $term ) {
                        $terms[] = '<a href="' . esc_url( get_term_link( $term->slug, $taxonomy_name ) ) . '">' . esc_html( $term->name ) . '</a>';
                    }
                    if (!$terms) {
                        $this->add_classname( 'empty_compare_item' );
                    } else {
                        $this->add_classname( 'compare_item_not_empty' );
                    }
                    ?>
                    <div class="td_row dbc_compare_value"><?php echo implode(', ', $terms );?></div>
                    <?php                    
                } else if ( $item_type == 'stock' ) {
                    $stock = wc_get_stock_html( $product );

                    if (!$product->is_in_stock()) {
                        $this->add_classname( 'empty_compare_item' );
                        if ($empty_display == 'icon') {
                            $stock = '<span class="dbc_compare_icon empty-value"></span>';
                        } else if ($empty_display == 'custom_text') {
                            $stock = $empty_text;
                        } else {
                            $stock = '';
                        }
                    } else {
                        $this->add_classname( 'compare_item_not_empty' );
                        if ($not_empty_display == 'icon') {
                            $stock = '<span class="dbc_compare_icon not-empty-value"></span>';
                        } else {
                            $stock = $stock;
                        }
                    }

                    ?>
                    <div class="td_row dbc_compare_value"><?php echo wp_kses_post($stock);?></div>
                    <?php                    

                } else if ( $item_type == 'sku' ) {

                    $sku = $product->get_sku();

                    if ($sku == '') {
                        $this->add_classname( 'empty_compare_item' );
                    } else {
                        $this->add_classname( 'compare_item_not_empty' );
                    }
                    ?>

                    <div class="td_row dbc_compare_value"><?php echo esc_html($sku); ?></div>
                    <?php                    
                } else if ( $item_type == 'attribute' ) {

                    $attributes = $product->get_attribute( $attribute_name );

                    if ($attributes == '') {
                        $this->add_classname( 'empty_compare_item' );
                        if ($empty_display == 'icon') {
                            $attributes = '<span class="dbc_compare_icon empty-value"></span>';
                        } else if ($empty_display == 'custom_text') {
                            $attributes = $empty_text;
                        } else {
                            $attributes = '';
                        }
                    } else {
                        $this->add_classname( 'compare_item_not_empty' );
                        if ($not_empty_display == 'icon') {
                            $attributes = '<span class="dbc_compare_icon not-empty-value"></span>';
                        } else {
                            $attributes = $attributes;
                        }
                    }
                    ?>
                    <div class="td_row dbc_compare_value">
                        <?php
                            echo wp_kses_post($attributes);
                        ?>
                    </div>
                    <?php

                }
            }
        }
       
        $data = ob_get_clean();

        //////////////////////////////////////////////////////////////////////

        return $data;
    }
}

new db_shop_comparetable_item_code;

?>
