<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class db_shop_orderby_item_code extends ET_Builder_Module {

    public $vb_support = 'on';
	public $slug       = 'et_pb_db_shop_orderby_item';

    public $folder_name;
    public $fields_defaults;
    public $text_shadow;
    public $margin_padding;
    public $_additional_fields_options;
    public $advanced_setting_title_text;
    public $settings_text;

    protected $module_credits = array(
        'module_uri' => DE_DB_PRODUCT_URL,
        'author'     => DE_DB_AUTHOR,
        'author_uri' => DE_DB_URL,
    );

    function init() {
        $this->name       = esc_html__( 'Orderby Item', 'divi-bodyshop-woocommerce' );
        $this->type                        = 'child';
        $this->child_title_var             = 'title';
        $this->advanced_setting_title_text = esc_html__( 'New Orderby Item', 'divi-bodyshop-woocommerce' );
        $this->settings_text               = esc_html__( 'Orderby Item Settings', 'divi-bodyshop-woocommerce' );
        $this->folder_name = 'divi_bodycommerce';

        $this->settings_modal_toggles = array(
            'general' => array(
                'toggles' => array(
                    'main_content' => esc_html__( 'Main Options', 'divi-bodyshop-woocommerce' ),
                    'layout' => esc_html__( 'Layout Options', 'divi-bodyshop-woocommerce' ),
                    'text_filter' => esc_html__( 'Text Filter Options', 'divi-bodyshop-woocommerce' ),
                    'select_filter' => esc_html__( 'Select Filter Options', 'divi-bodyshop-woocommerce' ),
                    'radio_filter' => esc_html__( 'Checkbox / radio Filter Options', 'divi-bodyshop-woocommerce' ),
                    'range_filter' => esc_html__( 'Number Range Filter Options', 'divi-bodyshop-woocommerce' ),
                    'filter_style' => esc_html__( 'Filter Style', 'divi-bodyshop-woocommerce' ),
                ),
            ),
            'advanced' => array(
                'toggles' => array(
                    'text' => esc_html__( 'Text', 'divi-bodyshop-woocommerce' ),
                ),
            ),
        );


        $this->main_css_element = '%%order_class%%';


        $this->advanced_fields = array(
            'fonts' => array(
            ),
            'background' => array(
                'settings' => array(
                    'color' => 'alpha',
                ),
            ),
            'button' => array(
            ),
            'box_shadow' => array(
                'default' => array(),
                'product' => array(
                    'label' => esc_html__( 'Default Layout - Box Shadow', 'divi-bodyshop-woocommerce' ),
                    'css' => array(
                        'main' => "%%order_class%% .products .product",
                    ),
                    'option_category' => 'layout',
                    'tab_slug'        => 'advanced',
                    'toggle_slug'     => 'product',
                ),
            ),
        );


        $this->custom_css_fields = array(
        );


        $this->help_videos = array(
        );
    }

    function get_fields() {
        $et_accent_color = et_builder_accent_color();

        ///////////////////////////////

        $acf_fields = DEBC_INIT::get_acf_fields();


        $filter_post_type_fields = array();

        $post_display_type_fields['menu_order'] = esc_html__('Default Sorting(Menu Order)', 'divi-bodyshop-woocommerce');
        $post_display_type_fields['relevance'] = esc_html__('Relevance', 'divi-bodyshop-woocommerce');
        $post_display_type_fields['popularity'] = esc_html__('Popularity', 'divi-bodyshop-woocommerce');
        $post_display_type_fields['rating'] = esc_html__('Rating', 'divi-bodyshop-woocommerce');
        $post_display_type_fields['price'] = esc_html__('Price', 'divi-bodyshop-woocommerce');
        $post_display_type_fields['acf'] = esc_html__('Advanced Custom Field (ACF Plugin)', 'divi-bodyshop-woocommerce');
        $post_display_type_fields['date'] = esc_html__('Date', 'divi-bodyshop-woocommerce');
        $post_display_type_fields['custom'] = esc_html__('Custom Meta Field', 'divi-bodyshop-woocommerce');

        /*if (class_exists('DMACHACC_DiviMachineAccount')) {
            $dmach_acc_types_saved = de_get_option_value('divi-bodyshop-woocommerce', 'dmach_acc_types_saved'); //$titan->getOption( 'dmach_acc_types_saved' );
            $dmach_acc_types_saved_array = explode(',', $dmach_acc_types_saved);

            foreach ($dmach_acc_types_saved_array as $field) {
                $post_display_type_fields[$field] = esc_html__($field, 'divi-bodyshop-woocommerce');
            }
        }*/

        //////////////////////////////


        $fields = array(
            'title' => array(
                'label'           => esc_html__( 'OrderBy Name', 'divi-bodyshop-woocommerce' ),
                'type'            => 'text',
                'description'     => esc_html__( 'Change the name for the OrderBy Title what you will see on orderby dropdown.', 'divi-bodyshop-woocommerce' ),
                'toggle_slug'     => 'main_content',
                'dynamic_content' => 'text',
                'option_category' => 'configuration',
            ),
            'filter_post_type' => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'What do you want to add to the orderby select option?', 'divi-bodyshop-woocommerce' ),
                'type'              => 'select',
                'options'           => $post_display_type_fields,
                'default'           => 'relevance',
                'affects'         => array(
                    'acf_name',
                    'meta_name',
                ),
                'option_category'   => 'configuration',
                'description'       => esc_html__( 'Choose what you want added to the orderby select dropdown', 'divi-bodyshop-woocommerce' ),
            ),
            'acf_name' => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'ACF Name', 'divi-bodyshop-woocommerce' ),
                'type'              => 'select',
                'options'           => $acf_fields,
                'default'           => 'none',
                'depends_show_if'   => 'acf',
                'option_category'   => 'configuration',
                'description'       => esc_html__( 'Add the name of the ACF you want to display here', 'divi-bodyshop-woocommerce' ),
            ),
            'meta_name' => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'Custom Meta Field Name', 'divi-bodyshop-woocommerce' ),
                'type'              => 'text',
                'default'           => '',
                'depends_show_if'   => 'custom',
                'option_category'   => 'configuration',
                'description'       => esc_html__( 'Add the name of the Custom Meta Field you want', 'divi-bodyshop-woocommerce' ),
            ),
            'asc_desc' => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'Ascending or Descending?', 'divi-bodyshop-woocommerce' ),
                'type'              => 'select',
                'options'           => array(
                    'ASC'           => 'Ascending',
                    'DESC'          => 'Descending',
                ),
                'default'           => 'ASC',
                'option_category'   => 'configuration',
                'description'       => esc_html__( 'Choose if you want the orderby to be ascending or descending', 'divi-bodyshop-woocommerce' ),
                'show_if'     => array(
                    'filter_post_type' => array( 'acf', 'date', 'price', 'custom' )
                ),
            ),
            'order_type' => array(
                'toggle_slug'       => 'main_content',
                'label'             => esc_html__( 'Is Numeric?', 'divi-bodyshop-woocommerce' ),
                'type'              => 'yes_no_button',
                'options'           => array(
                    'off'             => 'No',
                    'on'              => 'Yes',
                ),
                'default'           => 'off',
                'option_category'   => 'configuration',
                'description'       => esc_html__( 'Enable this option if order value are numeric.', 'divi-bodyshop-woocommerce' ),
            ),
        );

        return $fields;
    }



    function render($attrs, $content, $render_slug){

        if (is_admin()) {
            return;
        }

        $filter_post_type       = $this->props['filter_post_type'];
        $acf_name               = $this->props['acf_name'];
        $meta_name              = $this->props['meta_name'];
        $asc_desc               = $this->props['asc_desc'];
        $title                  = $this->props['title'];
        $order_type             = $this->props['order_type'];
        
		// Module classnames
		$this->add_classname(
			array(
				'clearfix',
				$this->get_text_orientation_classname(),
			)
		);


        //////////////////////////////////////////////////////////////////////

        ob_start();

        if ($filter_post_type == "acf"){
            $acf_get = get_field_object($acf_name);
            $option_value = $acf_get['name'];
            if ( isset( $acf_get['parent'] ) && $acf_get['parent'] != 0 ) {
                $parent_obj = get_post( $acf_get['parent'] );
                $parent_acf_obj = get_field_object( $parent_obj->post_name );
                if ( $parent_acf_obj['type'] == 'group' ) {
                    $option_value = $parent_acf_obj['name'] . '_' . $acf_get['name'];
                }
            }

            if ( in_array( $acf_get['type'], array( 'range', 'number' )) || $order_type == 'on' ) {
                $data_order_type = 'number';
            } else {
                $data_order_type = $acf_get['type'];
            }
?>
        <option value="<?php echo $option_value; ?>" data-ascdec="<?php echo $asc_desc; ?>" data-order-type="<?php echo $data_order_type;?>"><?php echo esc_html( $title ); ?></option>
<?php
        } else if ($filter_post_type == "date"){
?>
        <option value="date" data-ascdec="<?php echo $asc_desc; ?>" data-order-type="num"><?php echo esc_html( $title ); ?></option>
<?php
        } else if ( in_array( $filter_post_type, array("relevance", "menu_order", "popularity", "rating", "price", "price-desc") ) ){
?>
        <option value="<?php echo $filter_post_type;?>" data-ascdec="<?php echo $asc_desc; ?>" data-order-type=""><?php echo esc_html( $title ); ?></option>
<?php
        } else if ( $filter_post_type == 'custom' ) {
            if ( $order_type == 'on' ) {
                $data_order_type = 'number';
            } else {
                $data_order_type = '';
            }
?>
        <option value="<?php echo $meta_name;?>" data-ascdec="<?php echo $asc_desc; ?>" data-order-type="<?php echo $data_order_type;?>"><?php echo esc_html( $title ); ?></option>
<?php
        } else {
?>
        <option value="post__in" data-ascdec="<?php echo $filter_post_type; ?>" data-order-type=""><?php echo esc_html( $title ); ?></option>
<?php
        }
        
        $data = ob_get_clean();

        //////////////////////////////////////////////////////////////////////

        return $data;
    }
}

new db_shop_orderby_item_code;

?>
