<?php

class db_product_WishlistIcon extends ET_Builder_Module {

	public $slug       = 'et_db_wishlist_compare';
	public $vb_support = 'on';

  public $folder_name;
  public $fields_defaults;
  public $text_shadow;
  public $margin_padding;
  public $_additional_fields_options;
  public $child_item_text;

	protected $module_credits = array(
		'module_uri' => '',
		'author'     => '',
		'author_uri' => '',
	);

	public function init() {
		$this->name = esc_html__( 'PL Wishlist/Compare - Product Page / Loop Layout', 'divi-bodyshop-woocommerce' );
    $this->folder_name = 'divi_bodycommerce';
    
    $this->settings_modal_toggles = array(
      'general' => array(
        'toggles' => array(
          'main_content'        => esc_html__('Main Settings', 'divi-bodyshop-woocommerce'),
          'image'        => esc_html__('Icon', 'divi-bodyshop-woocommerce'),
          'add_icon'        => esc_html__('Add Icon', 'divi-bodyshop-woocommerce'),
          'in_list_icon'        => esc_html__('In list Icon', 'divi-bodyshop-woocommerce'),
          'remove_state_icon'        => esc_html__('Adding Icon', 'divi-bodyshop-woocommerce'),
        ),
      ),
      'advanced' => array(
        'toggles' => array(
          'text' => esc_html__('Text', 'divi-bodyshop-woocommerce'),
        ),
      ),
    );

    $this->main_css_element = '%%order_class%%';

    $this->advanced_fields = array(
      'borders'        => array(
        'default' => array(
          'css'          => array(
            'main'      => array(
              'border_radii'  => '%%order_class%%',
              'border_styles' => '%%order_class%%',
            ),
            'important' => 'plugin_only',
          ),
          'label_prefix' => esc_html__( 'Wishlist Icon', 'et_builder' ),
        )
      ),
      'box_shadow' => array(
        'default' => array(),
        'filter_items' => array(
            'label' => esc_html__( 'Wishlist Icon', 'divi-bodyshop-woocommerce' ),
            'css' => array(
                'main' => '%%order_class%%',
            ),
        ),
      ),
      'button' => array(
        'button' => array(
          'label' => esc_html__( 'Button', 'divi-bodyshop-woocommerce' ),
          'css' => array(
            'main' => "%%order_class%% .et_pb_button",
            'important' => 'all',
          ),
          'box_shadow'  => array(
            'css' => array(
              'main' => "%%order_class%% .et_pb_button",
                  'important' => 'all',
            ),
          ),
          'margin_padding' => array(
              'css'           => array(
                  'main' => "%%order_class%% .et_pb_button",
                  'important' => '',
              ),
          ),
					'use_icon'       => false,
          'use_alignment' => false,
        ),
      ),
      'margin_padding' => array(
        'default' => array(
          'css' => array(
            'main'=>'%%order_class%%',
            'important' => 'all',
          ),
          'label_prefix'          => esc_html__( 'Wishlist Icon', 'et_builder' ),
        ),
      ),
    );

	}

  

	public function get_fields() {

    $et_accent_color = et_builder_accent_color();

    $type_options = array();

    if ( get_bodycommerce_option('wishlist_enable') == "1" ) {
        $type_options['wishlist'] = esc_html__('Wishlist', 'divi-bodyshop-woocommerce');
    }

    if ( get_bodycommerce_option('compare_enable') == "1" ) {
        $type_options['compare'] = esc_html__('Compare', 'divi-bodyshop-woocommerce');
    }

		return array(

			'wishlist_compare' => array(
				'label'           => esc_html__( 'Choose the type', 'divi-bodyshop-woocommerce' ),
				'type'            => 'select',
        'options'          => $type_options,
				'description'     => esc_html__( 'Choose what you want this icon to be for, wishlist or compare.', 'divi-bodyshop-woocommerce' ),
				'toggle_slug'     => 'main_content',
        'default'         => 'wishlist',
			),

      'make_button'  => array(
       'label'            => esc_html__( 'Make the module as a button?', 'divi-bodyshop-woocommerce' ),
       'description'      => esc_html__( 'Enable this if you want to make a button that they click to add to wishlist or compare.', 'divi-bodyshop-woocommerce' ),
       'type'             => 'yes_no_button',
       'options'          => array(
         'off' => esc_html__('No', 'divi-bodyshop-woocommerce'),
         'on'  => esc_html__('Yes', 'divi-bodyshop-woocommerce'),
       ),
       'default'            => 'off',
       'toggle_slug'         => 'main_content',
      ),

      'button_text' => array(
        'label'           => esc_html__( 'Button text', 'divi-bodyshop-woocommerce' ),
        'type'            => 'text',
        'default'         =>  esc_html__( '', 'divi-bodyshop-woocommerce' ),
        'description'     => esc_html__( 'Specify the button text.', 'divi-bodyshop-woocommerce' ),
        'toggle_slug'     => 'main_content',
        'show_if'         => array('make_button' => 'on'),
      ),

      'added_button_text' => array(
        'label'           => esc_html__( 'Added Button text', 'divi-bodyshop-woocommerce' ),
        'type'            => 'text',
        'default'         =>  esc_html__( '', 'divi-bodyshop-woocommerce' ),
        'description'     => esc_html__( 'Specify the button text for when added.', 'divi-bodyshop-woocommerce' ),
        'toggle_slug'     => 'main_content',
        'show_if'         => array('make_button' => 'on'),
      ),

      'right_offset'      => array(
        'label'           => esc_html__( 'Icon position from right', 'divi-form-builder' ),
        'description'     => esc_html__( 'Set the offset(px) of the icon from right.', 'divi-form-builder' ),
        'type'            => 'range',
        'default'         => '0px',
        'default_unit'    => 'px',
        'allowed_units'    => array( '%', 'em', 'rem', 'px' ),
        'range_settings'  => array(
          'min'  => '0',
          'max'  => '200',
          'step' => '1',
        ),
        'toggle_slug'     => 'main_content',
        'show_if'         => array('make_button' => 'on'),
      ),

      'extra_positioning'  => array(
       'label'            => esc_html__( 'Extra Icon Positioning?', 'divi-bodyshop-woocommerce' ),
       'description'      => esc_html__( 'Choose extra positioning you may want like making the icon in the middle vertical and horizontal or inline.', 'divi-bodyshop-woocommerce' ),
       'type'             => 'select',
       'options'          => array(
         'none' => esc_html__('None', 'divi-bodyshop-woocommerce'),
         'inline'  => esc_html__('Inline (float left)', 'divi-bodyshop-woocommerce'),
         'center_both'  => esc_html__('Center Vertically and Horizontally', 'divi-bodyshop-woocommerce'),
       ),
       'default'            => 'none',
       'toggle_slug'         => 'main_content',
     ),

      'use_popup'  => array(
       'label'            => esc_html__( 'Use popup notification?', 'divi-bodyshop-woocommerce' ),
       'description'      => esc_html__( 'If you want a pop up notification telling the user that it is adding to the list and removing - enable this.', 'divi-bodyshop-woocommerce' ),
       'type'             => 'yes_no_button',
       'options'          => array(
         'off' => esc_html__('No', 'divi-bodyshop-woocommerce'),
         'on'  => esc_html__('Yes', 'divi-bodyshop-woocommerce'),
       ),
       'default'            => 'off',
       'toggle_slug'         => 'main_content',
     ),

			'adding_text' => array(
				'label'           => esc_html__( 'Adding to list text', 'divi-bodyshop-woocommerce' ),
				'type'            => 'text',
				'default'         =>  esc_html__( 'Adding to your list', 'divi-bodyshop-woocommerce' ),
				'description'     => esc_html__( 'Specify the text that should be shown when adding the post to the chosen list.', 'divi-bodyshop-woocommerce' ),
				'toggle_slug'     => 'main_content',
        'show_if'         => array('use_popup' => 'on'),
			),

			'success_text' => array(
				'label'           => esc_html__( 'Added Success message text', 'divi-bodyshop-woocommerce' ),
				'type'            => 'text',
				'default'         =>  esc_html__( 'Added to your list', 'divi-bodyshop-woocommerce' ),
				'description'     => esc_html__( 'Specify the text that should be shown when it has been successfully added to the list.', 'divi-bodyshop-woocommerce' ),
				'toggle_slug'     => 'main_content',
        'show_if'         => array('use_popup' => 'on'),
      ),
      
			'success_delay'                 => array(
				'label'           => esc_html__( 'Delay after successful add/remove', 'divi-form-builder' ),
				'description'     => esc_html__( 'Set the delay (ms) you want after successfully adding or removing to the list', 'divi-form-builder' ),
				'type'            => 'range',
				'default'         => '1500',
				'unitless'        => true,
				'range_settings'  => array(
					'min'  => '0',
					'max'  => '10000',
					'step' => '1',
				),
				'toggle_slug'     => 'main_content',
        'show_if'         => array('use_popup' => 'on'),
			),

			'removed_adding_text' => array(
				'label'           => esc_html__( 'Removing from list text', 'divi-bodyshop-woocommerce' ),
				'type'            => 'text',
				'default'         =>  esc_html__( 'Removing from your list', 'divi-bodyshop-woocommerce' ),
				'description'     => esc_html__( 'Specify the text that should be shown when adding the post to the chosen list.', 'divi-bodyshop-woocommerce' ),
				'toggle_slug'     => 'main_content',
        'show_if'         => array('use_popup' => 'on'),
			),

			'removed_success_text' => array(
				'label'           => esc_html__( 'Removed Success message text', 'divi-bodyshop-woocommerce' ),
				'type'            => 'text',
				'default'         =>  esc_html__( 'Removed from your list', 'divi-bodyshop-woocommerce' ),
				'description'     => esc_html__( 'Specify the text that should be shown when it has been successfully added to the list.', 'divi-bodyshop-woocommerce' ),
				'toggle_slug'     => 'main_content',
        'show_if'         => array('use_popup' => 'on'),
			),

      // 'icon_size'      => array(
      //   'label'            => esc_html__( 'Icon Size', 'divi-bodyshop-woocommerce' ),
      //   'description'      => esc_html__( 'Set the size of the icon.', 'divi-bodyshop-woocommerce' ),
      //   'type'             => 'range',
      //   'toggle_slug'      => 'main_content',
      //   'default'          => '20px',
      //   'default_unit'     => 'px',
      //   'default_on_front' => '',
      //   'allowed_units'    => array( '%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw' ),
      //   'range_settings'   => array(
      //     'min'  => '1',
      //     'max'  => '500',
      //     'step' => '1',
      //   ),
      // ),

      'font_icon' => array(
        'label'               => esc_html__('Add Icon', 'divi-bodyshop-woocommerce'),
        'type'                => 'select_icon',
        'option_category'     => 'basic_option',
        'toggle_slug'         => 'add_icon',
        'default'             => '%%141%%',
        'class'               => array('et-pb-font-icon'),
        'description'         => esc_html__('Choose an icon to display to add to the list.', 'divi-bodyshop-woocommerce'),
        'hover'               => 'tabs',
      ),
      'icon_color' => array(
        'default'           => $et_accent_color,
        'label'             => esc_html__('Add Icon Color', 'divi-bodyshop-woocommerce'),
        'type'              => 'color-alpha',
        'description'       => esc_html__('Here you can define a custom color for your icon.', 'divi-bodyshop-woocommerce'),
        'option_category'     => 'basic_option',
        'toggle_slug'         => 'add_icon',
        'hover'             => 'tabs',
      ),
       'use_icon_font_size'  => array(
        'label'            => esc_html__( 'Use Add Icon Font Size', 'divi-bodyshop-woocommerce' ),
        'description'      => esc_html__( 'If you would like to control the size of the icon, you must first enable this option.', 'divi-bodyshop-woocommerce' ),
        'type'             => 'yes_no_button',
        'option_category'  => 'font_option',
        'options'          => array(
          'off' => esc_html__('No', 'divi-bodyshop-woocommerce'),
          'on'  => esc_html__('Yes', 'divi-bodyshop-woocommerce'),
        ),
        'affects'          => array(
          'icon_font_size',
        ),
        'option_category'     => 'basic_option',
        'toggle_slug'         => 'add_icon',
        'default_on_front' => 'off',
      ),
      'icon_font_size'      => array(
        'label'            => esc_html__( 'Add Icon Font Size', 'divi-bodyshop-woocommerce' ),
        'description'      => esc_html__( 'Control the size of the icon by increasing or decreasing the font size.', 'divi-bodyshop-woocommerce' ),
        'type'             => 'range',
        'option_category'     => 'basic_option',
        'toggle_slug'         => 'add_icon',
        'default'          => '16px',
        'default_unit'     => 'px',
        'default_on_front' => '',
        'allowed_units'    => array( '%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw' ),
        'range_settings'   => array(
          'min'  => '1',
          'max'  => '500',
          'step' => '1',
        ),
        'depends_show_if'  => 'on',
        'responsive'       => true,
        'hover'            => 'tabs',
      ),

      'inlist_font_icon' => array(
        'label'               => esc_html__('In List Icon', 'divi-bodyshop-woocommerce'),
        'type'                => 'select_icon',
        'option_category'     => 'basic_option',
        'toggle_slug'         => 'in_list_icon',
        'default'             => '%%257%%',
        'class'               => array('et-pb-font-icon'),
        'description'         => esc_html__('Choose an icon to display with your ACF item.', 'divi-bodyshop-woocommerce'),
        'hover'               => 'tabs',
      ),
      'inlist_icon_color' => array(
        'default'           => $et_accent_color,
        'label'             => esc_html__('In List Color', 'divi-bodyshop-woocommerce'),
        'type'              => 'color-alpha',
        'description'       => esc_html__('Here you can define a custom color for your icon.', 'divi-bodyshop-woocommerce'),
        'option_category'     => 'basic_option',
        'toggle_slug'         => 'in_list_icon',
        'hover'             => 'tabs',
      ),
       'inlist_use_icon_font_size'  => array(
        'label'            => esc_html__( 'Use In List Font Size', 'divi-bodyshop-woocommerce' ),
        'description'      => esc_html__( 'If you would like to control the size of the icon, you must first enable this option.', 'divi-bodyshop-woocommerce' ),
        'type'             => 'yes_no_button',
        'option_category'  => 'font_option',
        'options'          => array(
          'off' => esc_html__('No', 'divi-bodyshop-woocommerce'),
          'on'  => esc_html__('Yes', 'divi-bodyshop-woocommerce'),
        ),
        'affects'          => array(
          'inlist_icon_font_size',
        ),
        'option_category'     => 'basic_option',
        'toggle_slug'         => 'in_list_icon',
        'default_on_front' => 'off',
      ),
      'inlist_icon_font_size'      => array(
        'label'            => esc_html__( 'In List Font Size', 'divi-bodyshop-woocommerce' ),
        'description'      => esc_html__( 'Control the size of the icon by increasing or decreasing the font size.', 'divi-bodyshop-woocommerce' ),
        'type'             => 'range',
        'option_category'     => 'basic_option',
        'toggle_slug'         => 'in_list_icon',
        'default'          => '16px',
        'default_unit'     => 'px',
        'default_on_front' => '',
        'allowed_units'    => array( '%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw' ),
        'range_settings'   => array(
          'min'  => '1',
          'max'  => '500',
          'step' => '1',
        ),
        'depends_show_if'  => 'on',
        'responsive'       => true,
        'hover'            => 'tabs',
      ),
      
      // 'remove_state_font_icon' => array(
      //   'label'               => esc_html__('Remove Icon', 'divi-bodyshop-woocommerce'),
      //   'type'                => 'select_icon',
      //   'option_category'     => 'basic_option',
      //   'toggle_slug'         => 'remove_state_icon',
      //   'default'             => '%%81%%',
      //   'class'               => array('et-pb-font-icon'),
      //   'description'         => esc_html__('Choose an icon to display to remove from the list.', 'divi-bodyshop-woocommerce'),
      //   'hover'               => 'tabs',
      //   'show_if'         => array('saved_dislike_type' => 'saved'),
      // ),
      // 'remove_state_icon_color' => array(
      //   'default'           => $et_accent_color,
      //   'label'             => esc_html__('Remove Color', 'divi-bodyshop-woocommerce'),
      //   'type'              => 'color-alpha',
      //   'description'       => esc_html__('Here you can define a custom color for your icon.', 'divi-bodyshop-woocommerce'),
      //   'option_category'     => 'basic_option',
      //   'toggle_slug'         => 'remove_state_icon',
      //   'hover'             => 'tabs',
      //   'show_if'         => array('saved_dislike_type' => 'saved'),
      // ),
      //  'remove_state_use_icon_font_size'  => array(
      //   'label'            => esc_html__( 'Use Remove Font Size', 'divi-bodyshop-woocommerce' ),
      //   'description'      => esc_html__( 'If you would like to control the size of the icon, you must first enable this option.', 'divi-bodyshop-woocommerce' ),
      //   'type'             => 'yes_no_button',
      //   'option_category'  => 'font_option',
      //   'options'          => array(
      //     'off' => esc_html__('No', 'divi-bodyshop-woocommerce'),
      //     'on'  => esc_html__('Yes', 'divi-bodyshop-woocommerce'),
      //   ),
      //   'affects'          => array(
      //     'icon_font_size',
      //   ),
      //   'option_category'     => 'basic_option',
      //   'toggle_slug'         => 'remove_state_icon',
      //   'default_on_front' => 'off',
      //   'show_if'         => array('saved_dislike_type' => 'saved'),
      // ),
      // 'remove_state_icon_font_size'      => array(
      //   'label'            => esc_html__( 'In Remove Size', 'divi-bodyshop-woocommerce' ),
      //   'description'      => esc_html__( 'Control the size of the icon by increasing or decreasing the font size.', 'divi-bodyshop-woocommerce' ),
      //   'type'             => 'range',
      //   'option_category'     => 'basic_option',
      //   'toggle_slug'         => 'remove_state_icon',
      //   'default'          => '16px',
      //   'default_unit'     => 'px',
      //   'default_on_front' => '',
      //   'allowed_units'    => array( '%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw' ),
      //   'range_settings'   => array(
      //     'min'  => '1',
      //     'max'  => '500',
      //     'step' => '1',
      //   ),
      //   'depends_show_if'  => 'on',
      //   'responsive'       => true,
      //   'hover'            => 'tabs',
      //   'show_if'         => array('saved_dislike_type' => 'saved'),
      // ),

      ///

      'adding_state_font_icon' => array(
        'label'               => esc_html__('Adding Icon', 'divi-bodyshop-woocommerce'),
        'type'                => 'select_icon',
        'option_category'     => 'basic_option',
        'toggle_slug'         => 'remove_state_icon',
        'default'             => '%%138%%',
        'class'               => array('et-pb-font-icon'),
        'description'         => esc_html__('Choose an icon to appear while waiting for it to add to the list.', 'divi-bodyshop-woocommerce'),
        'hover'               => 'tabs',
      ),
      'adding_state_icon_color' => array(
        'default'           => $et_accent_color,
        'label'             => esc_html__('Adding Icon Color', 'divi-bodyshop-woocommerce'),
        'type'              => 'color-alpha',
        'description'       => esc_html__('Here you can define a custom color for your icon.', 'divi-bodyshop-woocommerce'),
        'option_category'     => 'basic_option',
        'toggle_slug'         => 'remove_state_icon',
        'hover'             => 'tabs',
      ),
       'adding_state_use_icon_font_size'  => array(
        'label'            => esc_html__( 'Use Adding icon Font Size', 'divi-bodyshop-woocommerce' ),
        'description'      => esc_html__( 'If you would like to control the size of the icon, you must first enable this option.', 'divi-bodyshop-woocommerce' ),
        'type'             => 'yes_no_button',
        'option_category'  => 'font_option',
        'options'          => array(
          'off' => esc_html__('No', 'divi-bodyshop-woocommerce'),
          'on'  => esc_html__('Yes', 'divi-bodyshop-woocommerce'),
        ),
        'affects'          => array(
          'adding_state_icon_font_size',
        ),
        'option_category'     => 'basic_option',
        'toggle_slug'         => 'remove_state_icon',
        'default_on_front' => 'off',
      ),
      'adding_state_icon_font_size'      => array(
        'label'            => esc_html__( 'Adding Icon Size', 'divi-bodyshop-woocommerce' ),
        'description'      => esc_html__( 'Control the size of the icon by increasing or decreasing the font size.', 'divi-bodyshop-woocommerce' ),
        'type'             => 'range',
        'option_category'     => 'basic_option',
        'toggle_slug'         => 'remove_state_icon',
        'default'          => '16px',
        'default_unit'     => 'px',
        'default_on_front' => '',
        'allowed_units'    => array( '%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw' ),
        'range_settings'   => array(
          'min'  => '1',
          'max'  => '500',
          'step' => '1',
        ),
        'depends_show_if'  => 'on',
        'responsive'       => true,
        'hover'            => 'tabs',
      ),
      'adding_state_icon_rotate_speed'      => array(
        'label'            => esc_html__( 'Adding Icon Rotation Speed (ms)', 'divi-bodyshop-woocommerce' ),
        'description'      => esc_html__( 'Control the animation speed.', 'divi-bodyshop-woocommerce' ),
        'type'             => 'range',
        'option_category'     => 'basic_option',
        'toggle_slug'         => 'remove_state_icon',
        'default'          => '1000ms',
        'default_unit'     => 'ms',
        'default_on_front' => '',
        'allowed_units'    => array( 'ms' ),
        'range_settings'   => array(
          'min'  => '1',
          'max'  => '10000',
          'step' => '1',
        ),
        'depends_show_if'  => 'on',
        'responsive'       => true,
        'hover'            => 'tabs',
      ),
      
			'icon_alignment' => array(
				'label'            => esc_html__( 'Alignment', 'et_builder' ),
				'type'             => 'text_align',
				'option_category'  => 'configuration',
				'options'          => et_builder_get_text_orientation_options(),
				'tab_slug'         => 'advanced',
				'default'					 => 'left',
				'toggle_slug'      => 'alignment',
				'description'      => esc_html__( 'Here you can define the alignment of icon', 'et_builder' ),
			),

		);
	}

	public function render( $attrs, $content, $render_slug ) {
    
    if ( is_admin() && ( ! defined( 'DOING_AJAX' ) || ! DOING_AJAX ) ) {
      return;
    }

    $wishlist_compare                      = $this->props['wishlist_compare'];

    if ( get_bodycommerce_option('wishlist_enable') !== "1" && $wishlist_compare == 'wishlist' ) {
      return '';
    }

    if ( get_bodycommerce_option('compare_enable') !== "1" && $wishlist_compare == 'compare' ) {
      return '';
    }
    
    $adding_text                      = $this->props['adding_text'];
    $success_text                      = $this->props['success_text'];
    $removed_adding_text                      = $this->props['removed_adding_text'];
    $removed_success_text                      = $this->props['removed_success_text'];

    $make_button                  = $this->props['make_button'];
    $button_text                  = $this->props['button_text'];
    $added_button_text            = $this->props['added_button_text'];

    $right_offset                 = $this->props['right_offset'];
    
		$icon_alignment 		= $this->props['icon_alignment'];
		$this->add_classname( 'icon_align_' . $icon_alignment );

    $extra_positioning                    = $this->props['extra_positioning'];    

    $use_popup                      = $this->props['use_popup'];
    
    $font_icon                       = $this->props['font_icon'];
    $icon_color                      = $this->props['icon_color'];
    $icon_color_hover                = $this->get_hover_value('icon_color');
    $use_icon_font_size            = $this->props['use_icon_font_size'];
    $icon_font_size                = $this->props['icon_font_size'];

    $inlist_font_icon                       = $this->props['inlist_font_icon'];
    $inlist_icon_color                      = $this->props['inlist_icon_color'];
    $inlist_icon_color_hover                = $this->get_hover_value('inlist_icon_color');
    $inlist_use_icon_font_size            = $this->props['inlist_use_icon_font_size'];
    $inlist_icon_font_size                = $this->props['inlist_icon_font_size'];

    $adding_state_font_icon                       = $this->props['adding_state_font_icon'];
    $adding_state_icon_color                      = $this->props['adding_state_icon_color'];
    $adding_state_icon_color_hover                = $this->get_hover_value('adding_state_icon_color');
    $adding_state_use_icon_font_size            = $this->props['adding_state_use_icon_font_size'];
    $adding_state_icon_font_size                = $this->props['adding_state_icon_font_size'];
    $adding_state_icon_rotate_speed                = $this->props['adding_state_icon_rotate_speed'] ?: "1000ms";
        
		// Module classnames
		$this->add_classname(
			array(
				'clearfix',
				$this->get_text_orientation_classname(),
			)
		);
    
    $font_icon_rendered = DEBC_INIT::et_icon_css_content(esc_attr($font_icon));
    $inlist_font_icon_rendered = DEBC_INIT::et_icon_css_content(esc_attr($inlist_font_icon));
    $adding_state_font_icon_rendered = DEBC_INIT::et_icon_css_content(esc_attr($adding_state_font_icon));

    $font_icon_arr = explode('||', $font_icon);

    $font_icon_font_family = ( !empty( $font_icon_arr[1] ) && $font_icon_arr[1] == 'fa' )?'FontAwesome':'ETmodules';
    $font_icon_font_weight = ( !empty( $font_icon_arr[2] ))?$font_icon_arr[2]:'400';

    $inlist_icon_arr = explode('||', $inlist_font_icon);

    $inlist_icon_font_family = ( !empty( $inlist_icon_arr[1] ) && $inlist_icon_arr[1] == 'fa' )?'FontAwesome':'ETmodules';
    $inlist_icon_font_weight = ( !empty( $inlist_icon_arr[2] ))?$inlist_icon_arr[2]:'400';

    $adding_icon_arr = explode('||', $adding_state_font_icon);

    $adding_icon_font_family = ( !empty( $adding_icon_arr[1] ) && $adding_icon_arr[1] == 'fa' )?'FontAwesome':'ETmodules';
    $adding_icon_font_weight = ( !empty( $adding_icon_arr[2] ))?$adding_icon_arr[2]:'400';

    if ( $extra_positioning == 'none' ) {
      if ( $icon_alignment == 'center' ) {
        ET_Builder_Element::set_style($render_slug, array(
          'selector'    => '%%order_class%%',
          'declaration' => 'text-align:center;',
        ));  
      } else if ( $icon_alignment == 'right' ) {
        ET_Builder_Element::set_style($render_slug, array(
          'selector'    => '%%order_class%%',
          'declaration' => 'text-align:right;',
        ));
      } else {
        ET_Builder_Element::set_style($render_slug, array(
          'selector'    => '%%order_class%%',
          'declaration' => 'left:0;',
        ));
      }
    }
    
    if ( $extra_positioning == 'inline' ) {
      ET_Builder_Element::set_style($render_slug, array(
        'selector'    => '%%order_class%%',
        'declaration' => 'display:inline-block;float:left;',
      ));
    }
    
    if ( $extra_positioning == 'center_both' ) {
      ET_Builder_Element::set_style($render_slug, array(
        'selector'    => '%%order_class%%',
        'declaration' => 'display: flex;justify-content: center;align-items: center;',
      ));
    }
    
    

    // $remove_state_font_icon                       = $this->props['remove_state_font_icon'];
    // $remove_state_font_icon_rendered = DEBC_INIT::et_icon_css_content(esc_attr($remove_state_font_icon));
    // $remove_state_icon_color                      = $this->props['remove_state_icon_color'];
    // $remove_state_icon_color_hover                = $this->get_hover_value('remove_state_icon_color');
    // $remove_state_use_icon_font_size            = $this->props['remove_state_use_icon_font_size'];
    // $remove_state_icon_font_size                = $this->props['remove_state_icon_font_size'];

    // $icon_size                      = $this->props['icon_size'];

    $success_delay                      = $this->props['success_delay'];
    
      $this->add_classname('type_' . $wishlist_compare);

    // ET_Builder_Element::set_style($render_slug, array(
    //   'selector'    => '%%order_class%% .add_wishlist',
    //   'declaration' => sprintf(
    //     'width: %1$s;
    //     height: %1$s;',
    //     esc_html($icon_size)
    //   ),
    // ));
    
    // Normal State icon

    ET_Builder_Element::set_style($render_slug, array(
      'selector'    => '%%order_class%% .add_wishlist::after,body.et-db #page-container #et-boc .et-l .et_pb_section .et_db_wishlist_compare .et_pb_button.add_wishlist::after',
      'declaration' => sprintf(
        'display: inline-block !important;
        content: "%1$s";
        color: %2$s;
        font-family:"%3$s"!important;
        font-weight:%4$s;',
        esc_html($font_icon_rendered),
        $icon_color,
        $font_icon_font_family,
        $font_icon_font_weight
      ),
    ));

    if ($icon_color_hover !== '' || $icon_color_hover !== NULL) {
    ET_Builder_Element::set_style($render_slug, array(
      'selector'    => '%%order_class%% .add_wishlist:hover::after, ,body.et-db #page-container #et-boc .et-l .et_pb_section .et_db_wishlist_compare .et_pb_button.add_wishlist:hover::after',
      'declaration' => sprintf(
        'color: %1$s;',
        $icon_color_hover
      ),
    ));
  } 
      
    if ( 'off' !== $use_icon_font_size && $icon_font_size !== '') {
      
      ET_Builder_Element::set_style($render_slug, array(
        'selector'    => '%%order_class%% .add_wishlist::after, ,body.et-db #page-container #et-boc .et-l .et_pb_section .et_db_wishlist_compare .et_pb_button.add_wishlist::after',
        'declaration' => sprintf(
          'font-size: %1$s;',
          $icon_font_size
        ),
      ));

    }

    if ( 'on' == $make_button ) {
      ET_Builder_Element::set_style($render_slug, array(
        'selector'    => '%%order_class%% .add_wishlist.et_pb_button::after, ,body.et-db #page-container #et-boc .et-l .et_pb_section .et_db_wishlist_compare .et_pb_button.add_wishlist::after',
        'declaration' => sprintf(
          'right: %1$s;',
          $right_offset
        ),
      ));
    }


    //  Adding State icon

    ET_Builder_Element::set_style($render_slug, array(
      'selector'    => '%%order_class%% .adding_list.add_wishlist::after,body.et-db #page-container #et-boc .et-l .et_pb_section .et_db_wishlist_compare .et_pb_button.adding_list.add_wishlist::after',
      'declaration' => sprintf(
        'content: "%1$s" !important;
        color: %2$s !important;
        font-family:"%3$s"!important;
        font-weight:%4$s;',
        esc_html($adding_state_font_icon_rendered),
        $adding_state_icon_color,
        $adding_icon_font_family,
        $adding_icon_font_weight
      ),
    ));

    if ($adding_state_icon_color_hover !== '' || $adding_state_icon_color_hover !== NULL) {
    ET_Builder_Element::set_style($render_slug, array(
      'selector'    => '%%order_class%% .adding_list.add_wishlist:hover::after,body.et-db #page-container #et-boc .et-l .et_pb_section .et_db_wishlist_compare .et_pb_button.adding_list.add_wishlist:hover::after',
      'declaration' => sprintf(
        'color: %1$s !important',
        $adding_state_icon_color_hover
      ),
    ));
  }
      
    if ( 'off' !== $adding_state_use_icon_font_size && $adding_state_icon_font_size !== '') {
      
      ET_Builder_Element::set_style($render_slug, array(
        'selector'    => '%%order_class%% .adding_list.add_wishlist::after,body.et-db #page-container #et-boc .et-l .et_pb_section .et_db_wishlist_compare .et_pb_button.adding_list.add_wishlist::after',
        'declaration' => sprintf(
          'font-size: %1$s!important;',
          $adding_state_icon_font_size
        ),
      ));

    }

    ET_Builder_Element::set_style($render_slug, array(
      'selector'    => '%%order_class%% .adding_list.add_wishlist::after,body.et-db #page-container #et-boc .et-l .et_pb_section .et_db_wishlist_compare .et_pb_button.adding_list.add_wishlist::after',
      'declaration' => sprintf(
        '-webkit-animation:spin %1$s linear infinite;
        -moz-animation:spin %1$s linear infinite;
        animation:spin %1$s linear infinite;',
        $adding_state_icon_rotate_speed
      ),
    ));
    

    // Remove State icon

    // ET_Builder_Element::set_style($render_slug, array(
    //   'selector'    => '.remove_wishlist.'.$saved_type.' .saved_type_'.$saved_type.' .add_wishlist::after',
    //   'declaration' => sprintf(
    //     'content: "%1$s" !important;
    //     color: %2$s; !important',
    //     esc_html($remove_state_font_icon_rendered),
    //     $remove_state_icon_color
    //   ),
    // ));

    // ET_Builder_Element::set_style($render_slug, array(
    //   'selector'    => '.remove_wishlist.'.$saved_type.' .saved_type_'.$saved_type.' .add_wishlist::after',
    //   'declaration' => sprintf(
    //     'color: %1$s; !important',
    //     $remove_state_icon_color_hover
    //   ),
    // ));
      
    // if ( 'off' !== $remove_state_use_icon_font_size ) {
      
    //   ET_Builder_Element::set_style($render_slug, array(
    //     'selector'    => '.remove_wishlist.'.$saved_type.' .saved_type_'.$saved_type.' .add_wishlist::after',
    //     'declaration' => sprintf(
    //       'font-size: %1$s; !important',
    //       $remove_state_icon_font_size
    //     ),
    //   ));

    // }

       // In List State icon

       ET_Builder_Element::set_style($render_slug, array(
        'selector'    => '%%order_class%% .add_wishlist.in_wishlist::after,body.et-db #page-container #et-boc .et-l .et_pb_section .et_db_wishlist_compare .et_pb_button.in_wishlist.add_wishlist::after',
        'declaration' => sprintf(
          'content: "%1$s";
          color: %2$s;
          font-family:"%3$s"!important;
          font-weight:%4$s;',
          esc_html($inlist_font_icon_rendered),
          $inlist_icon_color,
          $inlist_icon_font_family,
          $inlist_icon_font_weight
        ),
      ));
  
      if ($inlist_icon_color_hover !== '' || $inlist_icon_color_hover !== NULL) {
      ET_Builder_Element::set_style($render_slug, array(
        'selector'    => '%%order_class%% .add_wishlist.in_wishlist:hover::after,body.et-db #page-container #et-boc .et-l .et_pb_section .et_db_wishlist_compare .et_pb_button.in_wishlist.add_wishlist:hover::after',
        'declaration' => sprintf(
          'color: %1$s;',
          $inlist_icon_color_hover
        ),
      ));
    }
        
      if ( 'off' !== $inlist_use_icon_font_size && $inlist_icon_font_size !== '') {
        
        ET_Builder_Element::set_style($render_slug, array(
          'selector'    => '%%order_class%% .add_wishlist.in_wishlist::after,body.et-db #page-container #et-boc .et-l .et_pb_section .et_db_wishlist_compare .et_pb_button.in_wishlist.add_wishlist::after',
          'declaration' => sprintf(
            'font-size: %1$s;',
            $inlist_icon_font_size
          ),
        ));
      }

		ob_start();

  $user_id = get_current_user_id();
  $post_id = get_the_ID();

  $logged_in = "yes";
  if ($user_id == "0") {
    $logged_in = "no";
  } 
  // var_dump($logged_in);
  //$titan = TitanFramework::getInstance( 'divi-bodyshop-woocommerce' );
  // $dmach_acc_slug = de_get_option_value( 'divi-bodyshop-woocommerce', 'dmach_acc_slug' ); //$titan->getOption( 'dmach_acc_slug' );
  $account_url = wc_get_page_permalink( 'myaccount' );
  // $dmach_acc_types_saved = de_get_option_value( 'divi-bodyshop-woocommerce', 'dmach_acc_types_saved' ); //$titan->getOption( 'dmach_acc_types_saved' );
  // $dmach_acc_types_saved_linked_affects = de_get_option_value( 'divi-bodyshop-woocommerce', 'dmach_acc_types_saved_linked_affects' ); //$titan->getOption( 'dmach_acc_types_saved_linked_affects' );
  $css_class = '';
  $is_added = false;
  // $active_type = '';
  // $new_saved_string = '';
  // var_dump($this->props['removed_success_text']);
  if ( !empty($wishlist_compare) ) {
    $get_wishlist_compare_settings = get_user_meta( $user_id, 'bc_wishlist_compare_' . $wishlist_compare , true );
    
    // var_dump($get_wishlist_compare_settings); exit;
    if (!empty($get_wishlist_compare_settings)) {
      foreach ($get_wishlist_compare_settings as $item) {
        if (in_array($post_id, $item)) {
          $css_class = "in_wishlist";
          $is_added = true;
        }
      }
    }
  } 

  if ( $make_button == 'on' ) {
    $css_class .= ' et_pb_button';

    if ( $button_text == '' && $added_button_text == '' ) {
      $css_class .= ' no_text';
    }
  }
  ?>
<a href="#" class="add_wishlist <?php echo esc_html($css_class) ?>"
    data-post_id="<?php echo esc_html($post_id); ?>" data-wishlist_compare="<?php echo esc_html($wishlist_compare); ?>"
    data-post_type="<?php echo esc_html(get_post_type())?>" data-adding_text="<?php echo esc_html($adding_text); ?>"
    data-button_text="<?php echo esc_html($button_text);?>"
    data-added_button_text="<?php echo esc_html($added_button_text);?>"
    data-success_text="<?php echo esc_html($success_text); ?>"
    data-removed_adding_text="<?php echo esc_html($removed_adding_text); ?>"
    data-removed_success_text="<?php echo esc_html($removed_success_text); ?>"
    data-account_url="<?php echo esc_html($account_url); ?>" data-timer_delay="<?php echo esc_html($success_delay); ?>"
    data-use_popup="<?php echo esc_html($use_popup); ?>"
    data-loggedin="<?php echo esc_html($logged_in); ?>">
  <?php
    if ( $make_button == 'on' ) {
      echo ( $is_added == false )?$button_text:$added_button_text;
    }
  ?>
</a>
<?php 
    
    $data = ob_get_clean();

    return $data;

	}
}

new db_product_WishlistIcon;