<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class db_account_nav_code extends ET_Builder_Module {

public $vb_support = 'on';

public $folder_name;
public $fields_defaults;
public $text_shadow;
public $margin_padding;
public $_additional_fields_options;

protected $module_credits = array(
  'module_uri' => DE_DB_PRODUCT_URL,
  'author'     => DE_DB_AUTHOR,
  'author_uri' => DE_DB_URL,
);

                function init() {
                    $this->name       = esc_html__( 'AP Navigation - Account Pages', 'divi-bodyshop-woocommerce' );
                    $this->slug = 'et_pb_db_account_nav';
                    $this->folder_name = 'divi_bodycommerce';

		$this->fields_defaults = array(
			'show_as_buttons'  		=> array( 'off' ),
			'display_inline'  		=> array( 'off' ),
		);

          $this->settings_modal_toggles = array(
      			'general' => array(
      				'toggles' => array(
      					'main_content' => esc_html__( 'Module Options', 'divi-bodyshop-woocommerce' ),
      				),
      			),
      			'advanced' => array(
      				'toggles' => array(
					           'alignment'  => esc_html__( 'Alignment', 'et_builder' ),
      					'text' => esc_html__( 'Text', 'divi-bodyshop-woocommerce' ),
      				),
      			),

      		);


                      $this->main_css_element = '%%order_class%%';
                      $this->advanced_fields = array(
        			'fonts' => array(
        				'meta'   => array(
        					'label'    => esc_html__( 'Nav Links', 'divi-bodyshop-woocommerce' ),
        					'css'      => array(
        						'main' => "{$this->main_css_element} .woocommerce-MyAccount-navigation a",
        					),
        					'font_size' => array(
        						'default' => '14px',
        					),
        					'line_height' => array(
        						'default' => '1.3em',
        					),
        				),
        				'active_link'   => array(
        					'label'    => esc_html__( 'Active Link', 'divi-bodyshop-woocommerce' ),
        					'css'      => array(
        						'main' => "{$this->main_css_element} .woocommerce-MyAccount-navigation .is-active a",
        					),
        					'font_size' => array(
        						'default' => '14px',
        					),
        					'line_height' => array(
        						'default' => '1.3em',
        					),
        				),
        			),
        			'background' => array(
        				'settings' => array(
        					'color' => 'alpha',
        				),
        			),
        			'border' => array(),
        			'custom_margin_padding' => array(
        				'css' => array(
        					'important' => 'all',
        				),
        			),

              'button' => array(
      'button' => array(
        'label' => esc_html__( 'Button', 'divi-bodyshop-woocommerce' ),
        'css' => array(
          'main' => "{$this->main_css_element} .et_pb_button",
          'important' => 'all',
        ),
        'box_shadow'  => array(
          'css' => array(
            'main' => "{$this->main_css_element} .et_pb_button",
                'important' => 'all',
          ),
        ),
        'margin_padding' => array(
        'css'           => array(
          'main' => "{$this->main_css_element} .et_pb_button",
          'important' => 'all',
        ),
        ),
      ),
      'active_button' => array(
      'label' => esc_html__( 'Active Button', 'divi-bodyshop-woocommerce' ),
      'css' => array(
        'main' => "{$this->main_css_element} .is-active .et_pb_button, {$this->main_css_element} .is-active.et_pb_button",
        'important' => 'all',
      ),
      'box_shadow'  => array(
        'css' => array(
          'main' => ".woocommerce {$this->main_css_element} .is-active .et_pb_button, {$this->main_css_element} .is-active.et_pb_button",
        ),
      ),
      ),

    ),

        		);

                  }

                  function get_fields() {
    		$fields = array(
            'title' => array(
                'label' => __('Title', 'et_builder'),
                'type' => 'text',
                'toggle_slug' => 'main_content',
                'description' => __('If you want a title for the navigation, add it here', 'et_builder'),
            ),
            'show_as_buttons' => array(
                'label' => esc_html__('Show as Buttons', 'et_builder'),
                'type' => 'yes_no_button',
                'toggle_slug' => 'main_content',
                'options' => array(
                    'off' => esc_html__('No', 'et_builder'),
                    'on' => esc_html__('Yes', 'et_builder'),
                ),
                'affects' => array(
                  'display_inline',
                  'fullwidth_button'
                ),
                'description' => 'By default the navigation will be shown as a list with bullet points. If you would like it to show as buttons, check this to "yes"',
            ),
            'display_inline' => array(
                'label' => esc_html__('Show Inline', 'et_builder'),
                'type' => 'yes_no_button',
                'toggle_slug' => 'main_content',
                'depends_show_if' => 'on',
                'options' => array(
                    'off' => esc_html__('No', 'et_builder'),
                    'on' => esc_html__('Yes', 'et_builder'),
                ),
                'description' => 'When showing buttons should they be shown one per line or adjacent to each other. Check this to "yes" to make the buttons sit side by side',
            ),
            'fullwidth_button' => array(
                'label' => esc_html__('Make buttons fullwidth?', 'et_builder'),
                'type' => 'yes_no_button',
                'toggle_slug' => 'main_content',
                'depends_show_if' => 'on',
                'options' => array(
                    'off' => esc_html__('No', 'et_builder'),
                    'on' => esc_html__('Yes', 'et_builder'),
                ),
                'description' => 'Enabling this will make the buttons fullwidth',
            ),
            'hide_dashboard' => array(
                'label' => esc_html__('Hide Dashboard Link/Button', 'et_builder'),
                'type' => 'yes_no_button',
                'toggle_slug' => 'main_content',
                'options' => array(
                    'off' => esc_html__('No', 'et_builder'),
                    'on' => esc_html__('Yes', 'et_builder'),
                ),
            ),
            'hide_orders' => array(
                'label' => esc_html__('Hide Orders Link/Button', 'et_builder'),
                'type' => 'yes_no_button',
                'toggle_slug' => 'main_content',
                'options' => array(
                    'off' => esc_html__('No', 'et_builder'),
                    'on' => esc_html__('Yes', 'et_builder'),
                ),
            ),
            'hide_downloads' => array(
                'label' => esc_html__('Hide Downloads Link/Button', 'et_builder'),
                'type' => 'yes_no_button',
                'toggle_slug' => 'main_content',
                'options' => array(
                    'off' => esc_html__('No', 'et_builder'),
                    'on' => esc_html__('Yes', 'et_builder'),
                ),
            ),
            'hide_addresses' => array(
                'label' => esc_html__('Hide Addresses Link/Button', 'et_builder'),
                'type' => 'yes_no_button',
                'toggle_slug' => 'main_content',
                'options' => array(
                    'off' => esc_html__('No', 'et_builder'),
                    'on' => esc_html__('Yes', 'et_builder'),
                ),
            ),
            'hide_account_details' => array(
                'label' => esc_html__('Hide Account Details Link/Button', 'et_builder'),
                'type' => 'yes_no_button',
                'toggle_slug' => 'main_content',
                'options' => array(
                    'off' => esc_html__('No', 'et_builder'),
                    'on' => esc_html__('Yes', 'et_builder'),
                ),
            ),
            'hide_payment' => array(
                'label' => esc_html__('Hide Payment Methods', 'et_builder'),
                'type' => 'yes_no_button',
                'toggle_slug' => 'main_content',
                'options' => array(
                    'off' => esc_html__('No', 'et_builder'),
                    'on' => esc_html__('Yes', 'et_builder'),
                ),
            ),
            'hide_logout' => array(
                'label' => esc_html__('Hide Logout Link/Button', 'et_builder'),
                'type' => 'yes_no_button',
                'toggle_slug' => 'main_content',
                'options' => array(
                    'off' => esc_html__('No', 'et_builder'),
                    'on' => esc_html__('Yes', 'et_builder'),
                ),
            ),
            // 'space_button' => array(
            //   'label'           => esc_html__( 'Space Between Buttons', 'et_builder' ),
            //   'type'            => 'range',
            //   'default'         => '10px',
            //   'default_unit'    => 'px',
            //   'default_on_front'=> '',
            //   'range_settings' => array(
            //     'min'  => '0',
            //     'max'  => '200',
            //     'step' => '1',
            //   ),
            //   'toggle_slug' => 'main_content',
            //   'depends_show_if' => 'on',
            // ),
			'button_alignment' => array(
				'label'            => esc_html__( 'Button Alignment', 'et_builder' ),
				'description'      => esc_html__( 'Align your button to the left, right or center of the module.', 'et_builder' ),
				'type'             => 'text_align',
				'option_category'  => 'configuration',
				'options'          => et_builder_get_text_orientation_options( array( 'justified' ) ),
				'tab_slug'         => 'advanced',
				'toggle_slug'      => 'alignment',
				'description'      => esc_html__( 'Here you can define the alignment of Button', 'et_builder' ),
			),
    		);

    		return $fields;
    	}


      public function get_button_alignment( $device = 'desktop' ) {
  $suffix           = 'desktop' !== $device ? "_{$device}" : '';
  $text_orientation = isset( $this->props["button_alignment{$suffix}"] ) ? $this->props["button_alignment{$suffix}"] : '';

  return et_pb_get_alignment( $text_orientation );
}

                    function render( $attrs, $content, $render_slug ) {

                    if ( is_admin() && ( ! defined( 'DOING_AJAX' ) || ! DOING_AJAX ) ) {
                        return;
                    }


                    $title = $this->props['title'];
                    $buttons = $this->props['show_as_buttons'];
                    $inline = $this->props['display_inline'];
                    $fullwidth_button = $this->props['fullwidth_button'];
                    // $space_button = $this->props['space_button'];
                    $button_use_icon          	= $this->props['button_use_icon'];
                    $custom_icon          		= $this->props['button_icon'];
                    $button_custom        		= $this->props['custom_button'];
		                $button_icon_placement 		= $this->props['button_icon_placement'];

                    $custom_active_button  			= $this->props['custom_active_button'];
                  $custom_icon_active_button         		= $this->props['active_button_icon'];
                  $button_bg_color_active_button       		= $this->props['active_button_bg_color'];
                  $button_use_icon_active_button  			= $this->props['active_button_use_icon'];
                  $button_icon_active_button 				= $this->props['active_button_icon'];
                  $button_icon_placement_active_button 		= $this->props['active_button_icon_placement'];


                    $hide_dashboard 		= $this->props['hide_dashboard'];
		                $hide_orders 		= $this->props['hide_orders'];
		                $hide_downloads 		= $this->props['hide_downloads'];
		                $hide_addresses 		= $this->props['hide_addresses'];
		                $hide_account_details 		= $this->props['hide_account_details'];
                    $hide_payment 		= $this->props['hide_payment'];
		                $hide_logout 		= $this->props['hide_logout'];
        
                    // Module classnames
                    $this->add_classname(
                        array(
                            'clearfix',
                            $this->get_text_orientation_classname(),
                        )
                    );


                    $button_alignment                = $this->get_button_alignment();
                          // Button Alignment.
                		$button_alignments = sprintf( 'et_pb_button_alignment_%1$s', esc_attr( $button_alignment ) );

                    if( $fullwidth_button !== 'et_pb_button_alignment_' ){
                      $this->add_classname( $button_alignments );
                    }

                    if( $custom_active_button == 'on' ){

                      // button icon
                      if( $button_icon_active_button !== '' ){
                        $button_icon_arr = explode('||', $button_icon_active_button);

                        $button_icon_font_family = ( !empty( $button_icon_arr[1] ) && $button_icon_arr[1] == 'fa' )?'FontAwesome':'ETmodules';
                        $button_icon_font_weight = ( !empty( $button_icon_arr[2] ))?$button_icon_arr[2]:'400';

                        if ( class_exists( 'DEBC_INIT' ) ) {
                            $addToCartIconContent = DEBC_INIT::et_icon_css_content( esc_attr($button_icon_active_button) );
                        } else if (class_exists( 'DEDMACH_INIT' ) ) {
                            $addToCartIconContent = DEDMACH_INIT::et_icon_css_content( esc_attr($button_icon_active_button) );
                        } else {
                            $addToCartIconContent = DE_Filter::et_icon_css_content( esc_attr($button_icon_active_button) );
                        }

                        $addToCartIconContent = DEBC_INIT::et_icon_css_content( esc_attr($button_icon_active_button) );
  
                        $addToCartIconSelector = '';
                        if( $button_icon_placement_active_button == 'right' ){
                          $addToCartIconSelector = '%%order_class%% .is-active .et_pb_button:after, %%order_class%% .is-active.et_pb_button:after';
                        }elseif( $button_icon_placement_active_button == 'left' ){
                          $addToCartIconSelector = '%%order_class%% .is-active .et_pb_button:before, %%order_class%% .is-active.et_pb_button:before';
                        }
  
                        if( !empty( $addToCartIconContent ) && !empty( $addToCartIconSelector ) ){
                          ET_Builder_Element::set_style( $render_slug, array(
                            'selector' => $addToCartIconSelector,
                            'declaration' => "
                            content: '{$addToCartIconContent}'!important;
                            font-family:{$button_icon_font_family}!important;
                            font-weight:{$button_icon_font_weight};
                            display: inline-block;
                            line-height: inherit;
                            font-size: inherit!important;
                            margin-left: .3em;
                            left: auto;
                            display: inline-block;
                            "
                            )
                          );
                        }
                      }
  
                      // button background
                      if( !empty( $button_bg_color_active_button ) ){
                        ET_Builder_Element::set_style( $render_slug, array(
                          'selector'    => 'body #page-container %%order_class%% .is-active .et_pb_button, %%order_class%% .is-active.et_pb_button',
                          'declaration' => "background-color:". esc_attr( $button_bg_color_active_button ) ."!important;",
                        ) );
                      }
                    }



                    $data = '';
                  //////////////////////////////////////////////////////////////////////

                    ob_start();

                    if ($title) {
                        echo '<h3 class="module_title">' . $title . '</h3>';
                    }

                    do_action('woocommerce_before_account_navigation');

                    if ($buttons == 'on') {

                        foreach (wc_get_account_menu_items() as $endpoint => $label) {
                            if ($inline != 'on') {
                                echo '<p class="bc-account-nav-buttons woocommerce-MyAccount-navigation-link--'.esc_html($endpoint).' ' . wc_get_account_menu_item_classes($endpoint) . '">';
                            }
                            echo '<a class="' . ($inline == 'on' ? 'inline-button  woocommerce-MyAccount-navigation-link--'.esc_html($endpoint).'' : '') . ' et_pb_button ' . wc_get_account_menu_item_classes($endpoint) . '" href="' . esc_url(wc_get_account_endpoint_url($endpoint)) . '" name="'.esc_html($label).'">' . esc_html($label) . '</a>';

                            if ($inline != 'on') {
                                echo '</p>';
                            }
                        }

                    } else {
                        echo '<nav class="woocommerce-MyAccount-navigation">
                            <ul>';

                        foreach (wc_get_account_menu_items() as $endpoint => $label) {
                            echo '<li class="' . wc_get_account_menu_item_classes($endpoint) . '">
                                        <a href="' . esc_url(wc_get_account_endpoint_url($endpoint)) . '">' . esc_html($label) . '</a>
                                    </li>';
                        }

                        echo '</ul>
                        </nav>';
                    }

                    do_action('woocommerce_after_account_navigation');



                if( $custom_icon != '' ){

                  $IconSelector = '';
                					if( $button_icon_placement == 'right' ){
                						$IconSelector = '%%order_class%% .et_pb_button:after';
                					}elseif( $button_icon_placement == 'left' ){
                						$IconSelector = '%%order_class%% .et_pb_button:before';
                					}

                          if( !empty( $IconContent ) && !empty( $IconSelector ) ){
          ET_Builder_Element::set_style( $render_slug, array(
            'selector' => $IconSelector,
            'declaration' => "content: '{$IconContent}'!important;font-family:ETmodules!important;"
            )
          );
        }

                }



                if( $fullwidth_button == 'on' ){
                  $this->add_classname( 'fullwidth_buttons' );
                  $this->add_classname( 'et_pb_button_module_wrapper' );
                  
                  ET_Builder_Element::set_style( $render_slug, array(
                    'selector' => ".fullwidth_buttons .bc-account-nav-buttons a",
                    'declaration' => "display: block !important"
                  )
                  );

                }
                if( $hide_dashboard == 'on' ){
                  $this->add_classname( 'hide_dashboard' );
                  
                  ET_Builder_Element::set_style( $render_slug, array(
                    'selector' => ".hide_dashboard .woocommerce-MyAccount-navigation-link--dashboard",
                    'declaration' => "display: none !important"
                  )
                  );

                }
                if( $hide_orders == 'on' ){
                  $this->add_classname( 'hide_orders' );
                  
                  ET_Builder_Element::set_style( $render_slug, array(
                    'selector' => ".hide_orders .woocommerce-MyAccount-navigation-link--orders",
                    'declaration' => "display: none !important"
                  )
                  );

                }
                if( $hide_downloads == 'on' ){
                  $this->add_classname( 'hide_downloads' );
                  
                  ET_Builder_Element::set_style( $render_slug, array(
                    'selector' => ".hide_downloads .woocommerce-MyAccount-navigation-link--downloads",
                    'declaration' => "display: none !important"
                  )
                  );

                }
                if( $hide_addresses == 'on' ){
                  $this->add_classname( 'hide_addresses' );
                  
                  ET_Builder_Element::set_style( $render_slug, array(
                    'selector' => ".hide_addresses .woocommerce-MyAccount-navigation-link--edit-address",
                    'declaration' => "display: none !important"
                  )
                  );

                }
                if( $hide_account_details == 'on' ){
                  $this->add_classname( 'hide_account_details' );
                  
                  ET_Builder_Element::set_style( $render_slug, array(
                    'selector' => ".hide_account_details .woocommerce-MyAccount-navigation-link--edit-account",
                    'declaration' => "display: none !important"
                  )
                  );

                }
                if( $hide_payment == 'on' ){
                  $this->add_classname( 'hide_payment_methods' );
                  
                  ET_Builder_Element::set_style( $render_slug, array(
                    'selector' => ".hide_payment_methods .woocommerce-MyAccount-navigation-link--payment-methods,.hide_payment_methods .woocommerce-MyAccount-navigation-link--paymentMethods",
                    'declaration' => "display: none !important"
                  )
                  );
                  
                }
                if( $hide_logout == 'on' ){
                  $this->add_classname( 'hide_logout' );
                  
                  ET_Builder_Element::set_style( $render_slug, array(
                    'selector' => ".hide_logout .woocommerce-MyAccount-navigation-link--customer-logout",
                    'declaration' => "display: none !important"
                  )
                  );

                }
                


                    $data = ob_get_clean();

                   //////////////////////////////////////////////////////////////////////

                  return $data;
                  }
              }

            new db_account_nav_code;

?>
