<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class db_notices_code extends ET_Builder_Module {

  public $vb_support = 'on';

  public $folder_name;
  public $button_css; 
  public $text_shadow;
  public $margin_padding;
  public $_additional_fields_options;

protected $module_credits = array(
  'module_uri' => DE_DB_PRODUCT_URL,
  'author'     => DE_DB_AUTHOR,
  'author_uri' => DE_DB_URL,
);

                function init() {
                    $this->name       = esc_html__( 'G Notices - Global', 'divi-bodyshop-woocommerce' );
                    $this->slug = 'et_pb_db_notices';
                    $this->folder_name = 'divi_bodycommerce';


                    $this->settings_modal_toggles = array(
                			'general' => array(
                				'toggles' => array(
                					'main_content' => esc_html__( 'Module Options', 'divi-bodyshop-woocommerce' ),
                				),
                			),
                			'advanced' => array(
                				'toggles' => array(
                					'text' => esc_html__( 'Text', 'divi-bodyshop-woocommerce' ),
                				),
                			),

                		);


                      $this->main_css_element = '%%order_class%% .woocommerce-error, %%order_class%% .woocommerce-info, %%order_class%% .woocommerce-message';
                      $this->button_css = "%%order_class%%";

                      $this->advanced_fields = array(
                        'fonts' => array(
                  				'notice_text'   => array(
                  					'label'    => esc_html__( 'Notice', 'divi-bodyshop-woocommerce' ),
                  					'css'      => array(
                              'main' => "{$this->main_css_element}, %%order_class%% .wc-block-components-notice-banner__content, %%order_class%% .wc-block-components-notice-banner>.wc-block-components-notice-banner__content .wc-forward",
                              'important' => 'all'
                  					),
                  					'font_size' => array(
                  						'default' => '18px',
                  					),
                  					'line_height' => array(
                  						'default' => '1.1em',
                  					),
                  				),
                  			),
                  			'box_shadow'            => array(
                  				'default' => array(
                  					'css' => array(
                              'main' => "{$this->main_css_element}, %%order_class%% .wc-block-components-notice-banner",
                              'important' => 'all'
                  					),
                  				),
                  			),
                  			'background' => array(
                  				'css' => array(
                            'main' => "{$this->main_css_element}, %%order_class%% .wc-block-components-notice-banner",
                            'important' => 'all'
                  				),
                  				'settings' => array(
                  					'color' => 'alpha',
                  				),
                  			),
                        'borders'        => array(
                          'default' => array(
                            'css'          => array(
                              'main'      => array(
                                'border_radii'  => "{$this->main_css_element}, %%order_class%% .wc-block-components-notice-banner",
                                'border_styles' => "{$this->main_css_element}, %%order_class%% .wc-block-components-notice-banner",
                              ),
                              'important' => 'plugin_only',
                            ),
                            'label_prefix' => esc_html__( 'Notice Box', 'et_builder' ),
                          ),
                        ),
                        'custom_margin_padding' => array(
                          'css' => array(
                            'important' => 'all',
                          ),
                        ),
                  			'button' => array(
                  				'button' => array(
                  					'label' => esc_html__( 'Notice Button', 'divi-bodyshop-woocommerce' ),
                  					'css' => array(
                  						'main' => "%%order_class%% .woocommerce-error .button, %%order_class%% .woocommerce-info .button, %%order_class%% .woocommerce-message .button, %%order_class%% .wc-block-components-notice-banner__content a.button.wc-forward",
                  						'important' => 'all',
                  					),
                  					'box_shadow'  => array(
                  						'css' => array(
                  							'main' => '%%order_class%% .woocommerce-error .button, %%order_class%% .woocommerce-info .button, %%order_class%% .woocommerce-message .button, %%order_class%% .wc-block-components-notice-banner__content a.button.wc-forward',
                  						),
                  					),
                  				),
                  			),
                  		);



                  }

                  function get_fields() {
                    $fields = array(

                      // hide icon on notice
                      'hide_icon' => array(
                        'label'             => esc_html__( 'Hide Icon', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'yes_no_button',
                        'option_category'   => 'configuration',
                        'options'           => array(
                          'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
                          'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
                        ),
                        'default' => 'off',
                        'description'       => esc_html__( 'Here you can choose whether to hide the icon on the notice banner.', 'divi-bodyshop-woocommerce' ),
                        'toggle_slug'       => 'main_content',
                      ),
                      'admin_label' => array(
                        'label'       => __( 'Admin Label', 'divi-bodyshop-woocommerce' ),
                        'type'        => 'text',
                        'toggle_slug'     => 'main_content',
                        'description' => __( 'This will change the label of the module in the builder for easy identification.', 'divi-bodyshop-woocommerce' ),
),
                        '__getnotices' => array(
                          'type' => 'computed',
                          'computed_callback' => array( 'db_notices_code', 'get_checkout_notices' ),
                          'computed_depends_on' => array(
                            'admin_label'
                          ),
                        ),
                    );

        return $fields;
      }


                  public static function get_checkout_notices ( $args = array(), $conditional_tags = array(), $current_page = array() ){
                    if (!is_admin()) {
                			return;
                		}

                            ob_start();

        ?>
        <div class="woocommerce">
        <div class="woocommerce-message" role="alert">
        		<a href="" tabindex="1" class="button wc-forward">View basket</a> This is a preview of the notice that appears.
        </div>
                </div>
        <?php

                    $data = ob_get_clean();

                  return $data;

                  }


                    function render( $attrs, $content, $render_slug ) {
                      
                      if ( is_admin() && ( ! defined( 'DOING_AJAX' ) || ! DOING_AJAX ) ) {
                        return;
                      }
        
                      // Module classnames
                      $this->add_classname(
                          array(
                              'clearfix',
                              $this->get_text_orientation_classname(),
                          )
                      );



                                      $custom_button  			= $this->props['custom_button'];
                                      $button_use_icon  			= $this->props['button_use_icon'];
                                      $button_icon 				= $this->props['button_icon'];
                                      $button_icon_placement 		= $this->props['button_icon_placement'];

                                      $hide_icon = $this->props['hide_icon'];

                                      // if hide_icon is on, hide the icon .wc-block-components-notice-banner svg
                                      if( $hide_icon == 'on' ){
                                        ET_Builder_Element::set_style( $render_slug, array(
                                          'selector'    => '%%order_class%% .wc-block-components-notice-banner svg',
                                          'declaration' => sprintf(
                                            'display: none !important;'
                                          ),
                                        ) );
                                      }
                                      

                                      if ( $custom_button == 'on' ) {
                                        // if button_custom_padding is empty, set default padding
                                        if ( '' === $this->props['button_custom_padding'] ) {
                                          $this->props['button_custom_padding'] = '10px|10px|10px|10px';
                                        }

                                        // remove | if exists and replace with space
                                        $this->props['button_custom_padding'] = str_replace( '|', ' ', $this->props['button_custom_padding'] );

                                        // set the button padding and margin
                                        ET_Builder_Element::set_style( $render_slug, array(
                                          'selector'    => '%%order_class%% .woocommerce-error .button, %%order_class%% .woocommerce-info .button, %%order_class%% .woocommerce-message .button, %%order_class%% .wc-block-components-notice-banner__content a.button.wc-forward',
                                          'declaration' => sprintf(
                                            'padding:%1$s !important;',
                                            $this->props['button_custom_padding']
                                          ),
                                        ) );

                                        // fix the button padding if has no icon
                                        if( $button_use_icon == 'off' ){
                                          ET_Builder_Element::set_style( $render_slug, array(
                                            'selector' => 'body.woocommerce %%order_class%% .woocommerce-error .button, body.woocommerce %%order_class%% .woocommerce-info .button, body.woocommerce %%order_class%% .woocommerce-message .button, body.woocommerce %%order_class%% .wc-block-components-notice-banner__content a',
                                            'declaration' => "padding: 0.3em 1em!important"
                                            )
                                          );
                                        }

                                        ET_Builder_Element::set_style( $render_slug, array(
                                          'selector'    => '%%order_class%% .wc-block-components-notice-banner__content a.button.wc-forward',
                                          'declaration' => sprintf(
                                            'text-decoration: none !important;opacity:1;'
                                          ),
                                        ) );
                                        

                                      }

                                      // if border_radii is empty, set default border_radii to be 0px
                                      if ( '' === $this->props['border_radii'] ) {
                                        ET_Builder_Element::set_style( $render_slug, array(
                                          'selector'    => '%%order_class%% .wc-block-components-notice-banner',
                                          'declaration' => sprintf(
                                            'border-radius: %1$s;',
                                            '0px'
                                          ),
                                        ) );
                                      }

                                      // if border_width_all, border_width_top, border_width_right, border_width_bottom, border_width_left is empty, set border to be 0px
                                      if ( '' === $this->props['border_width_all'] && '' === $this->props['border_width_top'] && '' === $this->props['border_width_right'] && '' === $this->props['border_width_bottom'] && '' === $this->props['border_width_left'] ) {
                                        ET_Builder_Element::set_style( $render_slug, array(
                                          'selector'    => '%%order_class%% .wc-block-components-notice-banner',
                                          'declaration' => sprintf(
                                            'border-width: %1$s;',
                                            '0px'
                                          ),
                                        ) );
                                      }

                                      // if either border_width_all, border_width_top, border_width_right, border_width_bottom, border_width_left are not empty, set border style to solid
                                      if ( '' !== $this->props['border_width_all'] || '' !== $this->props['border_width_top'] || '' !== $this->props['border_width_right'] || '' !== $this->props['border_width_bottom'] || '' !== $this->props['border_width_left'] ) {
                                        ET_Builder_Element::set_style( $render_slug, array(
                                          'selector'    => '%%order_class%% .wc-block-components-notice-banner',
                                          'declaration' => sprintf(
                                            'border-style: %1$s;',
                                            'solid'
                                          ),
                                        ) );
                                      }

                                      // set notice_text_font_size
                                      ET_Builder_Element::set_style( $render_slug, array(
                                        'selector'    => '%%order_class%% .wc-block-components-notice-banner__content',
                                        'declaration' => sprintf(
                                          'font-size: %1$s;',
                                          $this->props['notice_text_font_size']
                                        ),
                                      ) );



                                      ob_start();
                                      wc_print_notices();


                                      if ( is_page( 'cart' ) || is_cart() ) {
                                        do_action( 'woocommerce_before_cart' );
                                      }

                                      if ( is_page( 'checkout' ) || is_checkout() ) {
                                        
                                        ?>
                                        <div class="bc-checkout-notices"></div>
                                        <?php
                                        
                                      }




                  // button icon and background
                  if( $custom_button == 'on' ){

                      // button icon
                      if( $button_icon !== '' ){
                          $button_icon_arr = explode('||', $button_icon);

                          $button_icon_font_family = ( !empty( $button_icon_arr[1] ) && $button_icon_arr[1] == 'fa' )?'FontAwesome':'ETmodules';
                          $button_icon_font_weight = ( !empty( $button_icon_arr[2] ))?$button_icon_arr[2]:'400';

                          if ( class_exists( 'DEBC_INIT' ) ) {
                              $iconContent = DEBC_INIT::et_icon_css_content( esc_attr($button_icon) );
                          } else if (class_exists( 'DEDMACH_INIT' ) ) {
                              $iconContent = DEDMACH_INIT::et_icon_css_content( esc_attr($button_icon) );
                          } else {
                              $iconContent = DE_Filter::et_icon_css_content( esc_attr($button_icon) );
                          }

                          $iconSelector = '';
                          if( $button_icon_placement == 'right' ){
                              $iconSelector = '%%order_class%% .button:after';
                          }elseif( $button_icon_placement == 'left' ){
                              $iconSelector = '%%order_class%% .button:before';
                          }

                          if( !empty( $iconContent ) && !empty( $iconSelector ) ){
                              ET_Builder_Element::set_style( $render_slug, array(
                                  'selector' => $iconSelector,
                                  'declaration' => "content: '{$iconContent}'!important;
                                    font-family:{$button_icon_font_family}!important;
                                    font-weight:{$button_icon_font_weight};"
                                  )
                              );
                          }
              }

                  }

            	

                  $content = ob_get_clean();

                  //////////////////////////////////////////////////////////////////////



                  return $content;



              	}
              }

            new db_notices_code;

?>
