<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class db_related_products_code extends ET_Builder_Module {

public $vb_support = 'on';

  public $folder_name;
  public $fields_defaults;
  public $text_shadow;
  public $margin_padding;
  public $_additional_fields_options;

protected $module_credits = array(
  'module_uri' => DE_DB_PRODUCT_URL,
  'author'     => DE_DB_AUTHOR,
  'author_uri' => DE_DB_URL,
);

                function init() {
                    $this->name       = esc_html__( 'PP Related Products - Product Page', 'divi-bodyshop-woocommerce' );
                    $this->slug = 'et_pb_db_related_products';
                    $this->folder_name = 'divi_bodycommerce';

                    $this->fields_defaults = array(
                    'custom_loop'         => array( 'off' ),
                    'out_of_stock'         => array( 'on' ),
                    );

          $this->settings_modal_toggles = array(
      			'general' => array(
      				'toggles' => array(
      					'main_content'  => esc_html__( 'Module Options', 'divi-bodyshop-woocommerce' ),
                'grid_option'   => esc_html__( 'Grid Options', 'divi-bodyshop-woocommerce'),
                'loop_option' => array(
                  'title' => esc_html__( 'Loop Options', 'divi-bodyshop-woocommerce' ),
                  'tabbed_subtoggles' => true,
                  'sub_toggles' => array(
                    'general' => array(
                      'name' => 'General'
                    ),
                    'include_exclude' => array(
                      'name' => 'Include/Exclude'
                    ),
                    'sortby' => array(
                      'name' => 'Sortby'
                    ),
                  )
                ),
      				),
      			),
      			'advanced' => array(
      				'toggles' => array(
					      'overlay' => esc_html__( 'Overlay', 'et_builder' ),
      					'text' => esc_html__( 'Text', 'divi-bodyshop-woocommerce' ),
      				),
      			),

      		);


                      $this->main_css_element = '%%order_class%%';
                      $this->advanced_fields = array(
                  			'fonts' => array(
                  				'header' => array(
                  					'label'    => esc_html__( 'Header', 'et_builder' ),
                  					'css'      => array(
                  						'main' => "{$this->main_css_element} .related > h2,{$this->main_css_element} .et_pb_related_wrapper > h2",
                  						'important' => array( 'size', 'font-size', 'plugin_all' ),
                  					),
                  					'font_size' => array(
                  						'default' => '26px',
                  					),
                  					'line_height' => array(
                  						'default' => '1em',
                  					),
                  				),
                  				'product_title' => array(
                  					'label'    => esc_html__( 'Product Title', 'et_builder' ),
                  					'css'      => array(
                  						'main' => "body.woocommerce {$this->main_css_element} ul.products li.product h2.woocommerce-loop-product__title, {$this->main_css_element} ul.products li.product h2.woocommerce-loop-product__title",
                  						'important' => array( 'size', 'font-size' ),
                  					),
                  					'font_size' => array(
                  						'default' => '26px',
                  					),
                  					'line_height' => array(
                  						'default' => '1em',
                  					),
                  				),
                  				'product_price' => array(
                  					'label'    => esc_html__( 'Price', 'et_builder' ),
                  					'css'      => array(
                  						'main' => "body.woocommerce {$this->main_css_element} ul.products li.product .price, {$this->main_css_element} ul.products li.product .price",
                  					),
                  					'font_size' => array(
                  						'default' => '14px',
                  					),
                  					'line_height' => array(
                  						'default' => '1.7em',
                  					),
                  				),
                  			),
                  			'background' => array(
                  				'settings' => array(
                  					'color' => 'alpha',
                  				),
                  			),
                  			'border' => array(),
                  			'custom_margin_padding' => array(
                  				'css' => array(
                  					'important' => 'all',
                  				),
                  			),
                  			'button' => array(
                  				'add_to_cart_button' => array(
                  					'label' => esc_html__( 'Add To Cart Button', 'et_builder' ),
                  					'css' => array(
                  						'main' => "{$this->main_css_element} ul.products li.product .button",
                  						'important' => 'all',
                  					),
                  					'box_shadow' => array(
                  						'css' => array(
                  							'main' => "{$this->main_css_element} ul.products li.product .button",
                  						),
                  					),
                  				),
                  			),
                  		);


                      		$this->custom_css_fields = array(
                      			'overlay'   => array(
                      				'label'    => esc_html__( 'Overlay', 'et_builder' ),
                      				'selector' => '.et_overlay',
                      			),
                      		);

                  }



                  function get_fields() {

                    $options = DEBC_INIT::get_divi_layouts();

                    $productattr = array();

                    if ( class_exists('WooCommerce') ){
                        $attribute_taxonomies = wc_get_attribute_taxonomies();
                        $productattr['none'] = 'Please select an Product Attribute';
                        if ( $attribute_taxonomies ) {
                            foreach ( $attribute_taxonomies as $tax ) {
                                $productattr[esc_attr( wc_attribute_taxonomy_name( $tax->attribute_name ) )] = esc_html( $tax->attribute_label );
                            }
                        }
                    }

                    $fields = array(
                      'remove_heading' => array(
                        'label'             => esc_html__( 'Remove Heading', 'et_builder' ),
                        'type'              => 'yes_no_button',
                        'options'           => array(
                          'off' => esc_html__( 'No', 'et_builder' ),
                          'on'  => esc_html__( 'Yes', 'et_builder' ),
                        ),
                        'description'        => esc_html__( 'Enable this if you want to remove the Heading', 'et_builder' ),
                      ),
                      'custom_loop' => array(
                        'label'             => esc_html__( 'Custom Loop layout for the Products?', 'et_builder' ),
                        'type'              => 'yes_no_button',
                        'computed_affects' => array(
                          '__getprorelated',
                        ),
                        'options'           => array(
                          'off' => esc_html__( 'No', 'et_builder' ),
                          'on'  => esc_html__( 'Yes', 'et_builder' ),
                        ),
                        'affects'=>array(
                          'link_whole_gird',
                          'loop_layout',
                          'equal_height',
                          'align_last_bottom'
                        ),
                        'description'        => esc_html__( 'Enable this if you want to use a custom layout - otherwise leave it off to be the default layout', 'et_builder' ),
                      ),
                      'loop_layout' => array(
                        'label'             => esc_html__( 'Loop Layout', 'et_builder' ),
                        'type'              => 'select',
                        'option_category'   => 'layout',
                        'default'           => 'none',
                        'options'           => $options,
                        'description'        => esc_html__( 'Choose the layout you have made for each product in the loop.', 'et_builder' ),
                      ),
                      'link_whole_gird' => array(
                        'option_category'   => 'layout',
                        'label'             => esc_html__( 'Link each layout to product', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'yes_no_button',
                        'options'           => array(
                          'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
                          'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
                        ),
                        'description'        => esc_html__( 'Enable this if you want to link each loop layout to the product. For example if you want the whole "grid card" to link to the product page. NB: You need to have no other links on the loop layout so do not link the image or the title to the product page.', 'divi-bodyshop-woocommerce' ),
                      ),
                      'equal_height' => array(
                        'label'             => esc_html__( 'Equal Height Grid Cards', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'yes_no_button',
                        'option_category'   => 'layout',
                        'options'           => array(
                          'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
                          'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
                        ),
                        'description' => esc_html__( 'Enable this if you have the grid layout and want all your cards to be the same height.', 'divi-bodyshop-woocommerce' ),
                      ),
                      'align_last_bottom' => array(
                        'option_category'   => 'layout',
                        'label'             => esc_html__( 'Align last module at the bottom', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'yes_no_button',
                        'options'           => array(
                          'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
                          'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
                        ),
                        'description'        => esc_html__( 'Enable this to align the last module (probably the add to cart) at the bottom. Works well when using the equal height.', 'divi-bodyshop-woocommerce' ),
                      ),
                      'out_of_stock' => array(
                        'label'             => esc_html__( 'Show out of stock products?', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'yes_no_button',
                        'option_category'   => 'layout',
                        'options'           => array(
                          'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
                          'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
                        ),
                        'show_if' => array('custom_loop' => 'on'),
                        'description' => esc_html__( 'Enable this if you want to display out of stock images.', 'divi-bodyshop-woocommerce' ),
                      ),
                      'no_posts_layout' => array(
                        'label'             => esc_html__( 'No Posts Layout', 'et_builder' ),
                        'type'              => 'select',
                        'option_category'   => 'layout',
                        'default'           => 'none',
                        'options'           => $options,
                        'description'        => esc_html__( 'Choose the layout that will be shown if there are no posts in the selection.', 'et_builder' ),
                      ),
                      'macth_all_any_categories'  => array(
                        'label'             => esc_html__( 'Category Matching', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'select',
                        'option_category'   => 'configuration',
                        'options'           => array(
                          'all'  => esc_html__( 'All the categories', 'divi-bodyshop-woocommerce' ),
                          'any' => esc_html__( 'Any of the categories', 'divi-bodyshop-woocommerce' ),
                        ),
                        'default'           => 'any',
                        'description'        => esc_html__( 'This option allows users to select how related products are matched based on categories. You can show products that match ALL the same categories or march ANY of them.', 'divi-bodyshop-woocommerce' ),
                      ),
                      'columns' => array(
                        'label'             => esc_html__( 'Grid Columns', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'select',
                        'option_category'   => 'layout',
                        'default'   => '3',
                        'options'           => array(
                          2  => esc_html__( 'Two', 'divi-bodyshop-woocommerce' ),
                          3 => esc_html__( 'Three', 'divi-bodyshop-woocommerce' ),
                          4 => esc_html__( 'Four', 'divi-bodyshop-woocommerce' ),
                          5 => esc_html__( 'Five', 'divi-bodyshop-woocommerce' ),
                          6 => esc_html__( 'Six', 'divi-bodyshop-woocommerce' ),
                        ),
                        'toggle_slug'       => 'grid_option',
                        'description'        => esc_html__( 'How many columns do you want to see', 'divi-bodyshop-woocommerce' ),
                      ),
                      'columns_tablet' => array(
                        'label'             => esc_html__( 'Tablet Grid Columns', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'select',
                        'option_category'   => 'layout',
                        'default'   => '3',
                        'options'           => array(
                          1  => esc_html__( 'One', 'divi-bodyshop-woocommerce' ),
                          2  => esc_html__( 'Two', 'divi-bodyshop-woocommerce' ),
                          3 => esc_html__( 'Three', 'divi-bodyshop-woocommerce' ),
                          4 => esc_html__( 'Four', 'divi-bodyshop-woocommerce' ),
                        ),
                        'toggle_slug'       => 'grid_option',
                        'description'        => esc_html__( 'How many columns do you want to see on tablet', 'divi-bodyshop-woocommerce' ),
                      ),
                      'columns_mobile' => array(
                        'label'             => esc_html__( 'Mobile Grid Columns', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'select',
                        'option_category'   => 'layout',
                        'default'   => '1',
                        'options'           => array(
                          1  => esc_html__( 'One', 'divi-bodyshop-woocommerce' ),
                          2  => esc_html__( 'Two', 'divi-bodyshop-woocommerce' ),
                        ),
                        'toggle_slug'       => 'grid_option',
                        'description'        => esc_html__( 'How many columns do you want to see on mobile', 'divi-bodyshop-woocommerce' ),
                      ),
                      'to_show' => array(
                        'label'       => __( 'Items to show', 'et_builder' ),
                        'type'        => 'select',
                        'options'     => array(
                          '1'    => esc_html__( 'one', 'et_builder' ),
                          '2'  => esc_html__( 'Two', 'et_builder' ),
                          '3'  => esc_html__( 'Three', 'et_builder' ),
                          '4'    => esc_html__( 'Four', 'et_builder' ),
                          '5'    => esc_html__( 'Five', 'et_builder' ),
                          '6'    => esc_html__( 'Six', 'et_builder' ),
                          'custom'   => esc_html__( 'Custom', 'et_builder' ),
                        ),
                        'toggle_slug'       => 'loop_option',
                        'sub_toggle' => 'general',
                        'description' => __( 'the number of related items to show. Defaults to 3', 'et_builder' ),
                      ),
                      'related_by' => array(
                        'label'       => __( 'Display products related by', 'et_builder' ),
                        'type'        => 'select',
                        'options'     => array(
                          'both'    => esc_html__( 'Same categories or tags', 'et_builder' ),
                          'categories_only'  => esc_html__( 'Same categories only', 'et_builder' ),
                        ),
                        'toggle_slug'       => 'loop_option',
                        'sub_toggle' => 'general',
                        'default'           => 'both',
                        'show_if' => array('custom_loop' => 'on'),
                        'description' => __( 'Choose if you want to show products with the same categories only or like WooCommerce does to have both categories and tags', 'et_builder' ),
                      ),
                      'to_show_custom' => array(
                        'label'       => __( 'Items to show custom', 'et_builder' ),
                        'type'        => 'text',
                        'description' => __( 'If you want to define a custom number more than 6, write it here', 'et_builder' ),
                        'show_if' => array('to_show' => 'custom'),
                        'toggle_slug'       => 'loop_option',
                        'sub_toggle' => 'general',
                      ),
                      'include_subcat' => array(
                        'option_category'   => 'configuration',
                        'toggle_slug'       => 'loop_option',
                        'label'             => esc_html__( 'Include sub-categories', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'yes_no_button',
                        'options'           => array(
                          'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
                          'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
                        ),
                        'default'           => 'off',
                        'sub_toggle' => 'include_exclude',
                        'description'        => esc_html__( 'Enable this if you want to get products in sub-categories of the products too', 'divi-bodyshop-woocommerce' ),
                      ),
                      // Text Field for include attributes
                      'include_attributes' => array(
                        'label'             => esc_html__( 'Include Attributes', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'text',
                        'option_category'   => 'configuration',
                        'toggle_slug'       => 'loop_option',
                        'sub_toggle' => 'include_exclude',
                        'description'       => esc_html__( 'It will get related products that have same attribute value with current product, separated by a comma. For example: color,size,brand', 'divi-bodyshop-woocommerce' ),
                      ),
                      // Text Field for exclude attributes
                      'exclude_attributes' => array(
                        'label'             => esc_html__( 'Exclude Attributes', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'text',
                        'option_category'   => 'configuration',
                        'toggle_slug'       => 'loop_option',
                        'sub_toggle' => 'include_exclude',
                        'description'       => esc_html__( 'Enter the attributes you want to exclude, separated by a comma. For example: color,size,brand', 'divi-bodyshop-woocommerce' ),
                      ),
                      // Select field for Filter with Conditional Logic(All/Any)
                      'filter_condition' => array(
                        'label'             => esc_html__( 'Include/Exclude Attribute Matching', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'select',
                        'option_category'   => 'configuration',
                        'options'           => array(
                          'all' => esc_html__( 'All of the values', 'divi-bodyshop-woocommerce' ),
                          'any'  => esc_html__( 'Any of the values', 'divi-bodyshop-woocommerce' ),
                        ),
                        'default'           => 'all',
                        'toggle_slug'       => 'loop_option',
                        'sub_toggle' => 'include_exclude',
                        'description'       => esc_html__( 'Select how you want the inclusion or exclusion of attributes to function. In cases where multiple attributes are added as values above (comma-separated), you can choose whether you want the inclusion/exclusion to match all of the values or any of them.', 'divi-bodyshop-woocommerce' ),
                      ),
                      // Select Field for select ACF Field
                      'acf_field' => array(
                        'label'             => esc_html__( 'Include ACF Field', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'select',
                        'option_category'   => 'configuration',
                        'options'           => DEBC_INIT::get_acf_fields(),
                        'toggle_slug'       => 'loop_option',
                        'sub_toggle' => 'include_exclude',
                        'description'       => esc_html__( 'It will get related products that have same acf field value with current product.', 'divi-bodyshop-woocommerce' ),
                      ),
                      // Select field for select Attribute to include specific value
                      'attribute_to_include_specific_value' => array(
                        'label'             => esc_html__( 'Attribute to Include Specific Value', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'select',
                        'option_category'   => 'configuration',
                        'options'           => $productattr,
                        'toggle_slug'       => 'loop_option',
                        'sub_toggle' => 'include_exclude',
                        'description'       => esc_html__( 'Select the attribute to filter by specific attribute value from the result', 'divi-bodyshop-woocommerce' ),
                      ),
                      // Text field for specific attribute value
                      'include_specific_attribute_value' => array(
                        'label'             => esc_html__( 'Specific Attribute Value', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'text',
                        'option_category'   => 'configuration',
                        'toggle_slug'       => 'loop_option',
                        'sub_toggle' => 'include_exclude',
                        'description'       => esc_html__( 'Enter the specific attribute value to filter the result', 'divi-bodyshop-woocommerce' ),
                      ),
                      // Select field for select Attribute to exclude specific value
                      'attribute_to_exclude_specific_value' => array(
                        'label'             => esc_html__( 'Attribute to Exclude Specific Value', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'select',
                        'option_category'   => 'configuration',
                        'options'           => $productattr,
                        'toggle_slug'       => 'loop_option',
                        'sub_toggle' => 'include_exclude',
                        'description'       => esc_html__( 'Select the attribute to filter by specific attribute value from the result', 'divi-bodyshop-woocommerce' ),
                      ),
                      // Text field for specific attribute value
                      'exclude_specific_attribute_value' => array(
                        'label'             => esc_html__( 'Exclude Specific Attribute Value', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'text',
                        'option_category'   => 'configuration',
                        'toggle_slug'       => 'loop_option',
                        'sub_toggle' => 'include_exclude',
                        'description'       => esc_html__( 'Enter the specific attribute value to filter the result', 'divi-bodyshop-woocommerce' ),
                      ),
                      // Add Sortby option select
                      'sortby' => array(
                        'label'             => esc_html__( 'Sort By', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'select',
                        'option_category'   => 'configuration',
                        'options'           => array(
                          'date' => esc_html__( 'Date', 'divi-bodyshop-woocommerce' ),
                          'price'  => esc_html__( 'Price', 'divi-bodyshop-woocommerce' ),
                          'rand'  => esc_html__( 'Random', 'divi-bodyshop-woocommerce' ),
                          'sales'  => esc_html__( 'Sales', 'divi-bodyshop-woocommerce' ),
                          'title'  => esc_html__( 'Title', 'divi-bodyshop-woocommerce' ),
                        ),
                        'default'           => 'price',
                        'toggle_slug'       => 'loop_option',
                        'sub_toggle' => 'sortby',
                        'description'       => esc_html__( 'Select the condition to get related products by all/any attributes.', 'divi-bodyshop-woocommerce' ),
                      ),
                      // Select Field for Sort Order
                      'sort_order' => array(
                        'label'             => esc_html__( 'Sort Order', 'divi-bodyshop-woocommerce' ),
                        'type'              => 'select',
                        'option_category'   => 'configuration',
                        'options'           => array(
                          'asc' => esc_html__( 'Ascending', 'divi-bodyshop-woocommerce' ),
                          'desc'  => esc_html__( 'Descending', 'divi-bodyshop-woocommerce' ),
                        ),
                        'default'           => 'asc',
                        'toggle_slug'       => 'loop_option',
                        'sub_toggle' => 'sortby',
                        'description'       => esc_html__( 'Select the condition to get related products by all/any attributes.', 'divi-bodyshop-woocommerce' ),
                      ),
                      'icon_hover_color'    => array(
                        'label'          => esc_html__( 'Overlay Icon Color', 'et_builder' ),
                        'description'    => esc_html__( 'Pick a color to use for the icon that appears when hovering over a product.', 'et_builder' ),
                        'type'           => 'color-alpha',
                        'custom_color'   => true,
                        'tab_slug'       => 'advanced',
                        'toggle_slug'    => 'overlay',
                        'mobile_options' => true,
                      ),
                      'hover_overlay_color' => array(
                        'label'          => esc_html__( 'Overlay Background Color', 'et_builder' ),
                        'description'    => esc_html__( 'Here you can define a custom color for the overlay', 'et_builder' ),
                        'type'           => 'color-alpha',
                        'custom_color'   => true,
                        'tab_slug'       => 'advanced',
                        'toggle_slug'    => 'overlay',
                        'mobile_options' => true,
                      ),
                      'admin_label' => array(
                        'label'       => __( 'Admin Label', 'divi-bodyshop-woocommerce' ),
                        'type'        => 'text',
                        'toggle_slug'     => 'main_content',
                        'description' => __( 'This will change the label of the module in the builder for easy identification.', 'divi-bodyshop-woocommerce' ),
                      ),
                      '__getprorelated' => array(
                        'type' => 'computed',
                        'computed_callback' => array( 'db_related_products_code', 'get_pro_related' ),
                        'computed_depends_on' => array(
                          'admin_label',
                          'custom_loop'
                        ),
                      ),
                    );

                    return $fields;
                }


                public static function get_pro_related ( $args = array(), $conditional_tags = array(), $current_page = array() ){
                  if (!is_admin()) {
                    			return;
                    		}
                  ob_start();


                  $getrelated = array(
                    'post_type' => 'product',
                  'post_status' => 'publish',
                  'posts_per_page' => '3',
                  'orderby' => 'ID',
                  'order' => 'ASC',
                );

                  $loop = new WP_Query( $getrelated );

                  $first = true;
                  while ( $loop->have_posts() ) : $loop->the_post();

                    if ( $first )  {
    //*---------------------------------------------------------------------------------------------------*//

if( $args['custom_loop'] == 'off' ){

              $getproducts = array();
              $defaults = array(
              'posts_per_page' => (3 ? 3:3),
              'columns'        => 3,
              'orderby'        => 'rand'
              );

          $getproducts = wp_parse_args( $getproducts, $defaults );

          woocommerce_related_products( $getproducts );

        }
    else if( $args['custom_loop'] == 'on' ){

          $shop = "<div class='no-html-output'><p>We do not have compatibility for the custom layout yet, only for the default layout. We are working on this still. It will still work as expected on the front-end, you will just not get a live preview.</p></div>";

          return $shop;
        }

    //*---------------------------------------------------------------------------------------------------*//
                  $first = false;
              } else {

              }
            endwhile; wp_reset_query(); // Remember to reset

                  $data = ob_get_clean();

                return $data;

                }

                    function render( $attrs, $content, $render_slug ) {

                      global $wp_query, $product;
                      
                      if ( is_admin() && ( ! defined( 'DOING_AJAX' ) || ! DOING_AJAX ) ) {
                        return;
                      }


		$icon_hover_color_values   = et_pb_responsive_options()->get_property_values( $this->props, 'icon_hover_color' );
		$hover_overlay_color_value = et_pb_responsive_options()->get_property_values( $this->props, 'hover_overlay_color' );

		// Icon Hover Color.
		et_pb_responsive_options()->generate_responsive_css( $icon_hover_color_values, '%%order_class%% .et_overlay:before', 'color', $render_slug, ' !important;', 'color' );

		// Hover Overlay Color.
		et_pb_responsive_options()->generate_responsive_css(
			$hover_overlay_color_value,
			'%%order_class%% .et_overlay',
			array(
				'background-color',
				'border-color',
			),
			$render_slug,
			' !important;',
			'color'
		);

                    $loop_layout           = $this->props['loop_layout'];
                    $related_by           = $this->props['related_by'];
                    $no_posts_layout        = $this->props['no_posts_layout'];
                    $link_whole_gird           = $this->props['link_whole_gird'];
                    $to_show_dis       = $this->props['to_show'];
                    $to_show_custom       = $this->props['to_show_custom'];


                    $custom_loop        = $this->props['custom_loop'];
                		$remove_heading     			= $this->props['remove_heading'];
                    $cols           = $this->props['columns'];
                    $columns_tablet           = $this->props['columns_tablet'];
                    $columns_mobile          = $this->props['columns_mobile'];

                    $equal_height 		= $this->props['equal_height'];
                    $align_last_bottom 		= $this->props['align_last_bottom'];

                    $include_subcat       = $this->props['include_subcat'];
                    $include_attributes   = $this->props['include_attributes'];
                    $exclude_attributes   = $this->props['exclude_attributes'];
                    $acf_field            = isset($this->props['acf_field'])?$this->props['acf_field']:'none';

                    $filter_condition     = $this->props['filter_condition'];

                    $macth_all_any_categories = $this->props['macth_all_any_categories'];

                    $attribute_to_include_specific_value = $this->props['attribute_to_include_specific_value'];
                    $include_specific_attribute_value = $this->props['include_specific_attribute_value'];
                    $attribute_to_exclude_specific_value = $this->props['attribute_to_exclude_specific_value'];
                    $exclude_specific_attribute_value = $this->props['exclude_specific_attribute_value'];

                    // get Sortby and Sort Order options
                    $sortby = isset($this->props['sortby'])? $this->props['sortby'] : 'price';
                    $sort_order = isset($this->props['sort_order'])? $this->props['sort_order'] : 'asc';

                    $out_of_stock 		= $this->props['out_of_stock'];
        
                    // Module classnames
                    $this->add_classname(
                      array(
                        'clearfix',
                        $this->get_text_orientation_classname(),
                      )
                    );
                    
                    if ($to_show_custom != "") {
                      $to_show = $to_show_custom;
                    } else {
                      $to_show = $to_show_dis;
                    }

                    if ($to_show == '') {
                      $to_show = 3;
                    }


                  //////////////////////////////////////////////////////////////////////

                  if ( $equal_height == 'on' ) {
                    $this->add_classname('same-height-cards');
                  }
                  if ( $align_last_bottom == 'on' ) {
                    $this->add_classname('align-last-module');
                  }

                  if( $remove_heading == 'on' ){
                    $this->add_classname('no-title');
            			}

                  

                  if ($custom_loop == 'on') {
                    // woocommerce_upsell_display(($to_show ? $to_show:3));
                    $output = sprintf(
                      '<div class="et_pb_related_wrapper et_pb_db_shop_loop">'
                    );

                    global $post;

                    if (isset($post->ID)) {
                      $tax_array = array();
                      $cats = wp_get_post_terms( $post->ID, "product_cat" );
                      foreach ( $cats as $cat ) {
                        $tax_array[] = $cat->term_id;

                        if ( $include_subcat == 'on' ) {
                          // Get child categories of $cat
                          $terms = get_terms( array(
                              'taxonomy' => 'product_cat',
                              'parent' => $cat->term_id,
                              'hide_empty' => true,
                          ) );

                          foreach ( $terms as $term ) {
                            $tax_array[] = $term->term_id;
                          }
                        }
                      }
                      
                      $tags = wp_get_post_terms( $post->ID, "product_tag" );

                      $tag_array = array();
                      foreach ( $tags as $tag ) {
                        $tag_array[] = $tag->term_id;
                      }

                      $cat_array = array();

                      if ( !empty( $tax_array ) ) {
                        if ( $macth_all_any_categories == 'all' ) {
                          $cat_query = array(
                            'relation'  => 'AND'
                          );
                          foreach ( $tax_array as $tax ) {
                            $cat_query[] = array(
                              'taxonomy' => 'product_cat',
                              'field' => 'id',
                              'terms' => $tax
                            );
                          }
                        } else {
                          $cat_query = array(
                            'taxonomy' => 'product_cat',
                            'field' => 'id',
                            'terms' => $tax_array
                          );
                        }
                      }

                      if ( !empty( $tag_array ) && $related_by == 'both' ) {
                        $tag_query = array(
                          'taxonomy' => 'product_tag',
                          'field' => 'id',
                          'terms' => $tag_array
                        );

                        $cat_query = array(
                          'relation' => 'OR',
                          $cat_query,
                          $tag_query
                        );
                      }

                      $sub_tax_query = array(
                        'relation' => 'OR',
                      );
                      
                      $args = array(
                        'post_type'             => 'product',
                        'post_status'           => 'publish',
                        'posts_per_page'      => $to_show,
                        'orderby'        => 'rand',
                        'tax_query' => array(
                          'relation' => 'AND',
                          array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'name',
                            'terms'    => 'exclude-from-catalog',
                            'operator' => 'NOT IN',
                          ),
                          $cat_query
                        )
                      );

                      if ( $filter_condition == 'all' ) {
                        $sub_tax_query['relation'] = 'AND';
                      };

                      $attributes = $product->get_attributes();

                      if ( $include_attributes != '' ) {
                        // Split $include_attributes into an array
                        $include_attributes = explode( ',', $include_attributes );
                        $include_attributes = array_map( 'trim', $include_attributes );

                        // Get attribute values of current product
                        foreach ( $include_attributes as $attribute ) {
                          $attribute = 'pa_' . $attribute;
                          if ( isset( $attributes[$attribute] ) ) {
                            $product_attribute = $attributes[$attribute];
                            // Add attribute value to $args
                            if ( !empty( $product_attribute->get_options() ) ) {
                              $sub_tax_query[] = array(
                                'taxonomy'        => $attribute,
                                'field'           => 'term_id',
                                'terms'           =>  $product_attribute->get_options(),
                                'operator'        => 'IN',
                              );
                            }
                          }
                        }
                      } else if ( $exclude_attributes != '' ) {
                        $exclude_attributes = explode( ',', $exclude_attributes );
                        $exclude_attributes = array_map( 'trim', $exclude_attributes );

                        // Get attribute values of current product
                        foreach ( $attributes as $attribute ) {
                          if ( !in_array( $attribute->get_name(), $exclude_attributes ) ) {
                            $attribute = 'pa_' . $attribute->get_name();
                            $product_attribute = $attributes[$attribute];

                            // Add attribute value to $args
                            if ( !empty( $product_attribute->get_options() ) ) {
                              $sub_tax_query[] = array(
                                'taxonomy'        => $attribute,
                                'field'           => 'term_id',
                                'terms'           =>  $product_attribute->get_options(),
                                'operator'        => 'IN',
                              );
                            }
                          }
                        }
                      }

                      $args['tax_query'][] = $sub_tax_query;

                      if ( $acf_field != '' && $acf_field != 'none' && class_exists('ACF') ) {
                        $acf_object = get_field_object( $acf_field );
                        $acf_value = get_post_meta( $post->ID, $acf_object['name'], true );
                        if ( $acf_value ) {
                          if ( $filter_condition == 'all' ) {
                            $args['meta_query'] = array(
                              'relation' => 'AND',
                              array(
                                'key' => $acf_object['name'],
                                'value' => $acf_value,
                                'compare' => '=',
                              ),
                            );
                          } else {
                            $args['meta_query'] = array(
                              'relation' => 'OR',
                              array(
                                'key' => $acf_object['name'],
                                'value' => $acf_value,
                                'compare' => '=',
                              ),
                            );
                          }
                        }
                      }
                      
                      // if $attribute_to_include_specific_value and $include_specific_attribute_value is exists, add tax query
                      if ( $attribute_to_include_specific_value && $include_specific_attribute_value ) {
                        $args['tax_query'][] = array(
                          'taxonomy' => $attribute_to_include_specific_value,
                          'field' => 'slug',
                          'terms' => explode(',', $include_specific_attribute_value),
                          'operator' => 'IN',
                        );
                      }

                      // if $attribute_to_exclude_specific_value and $exclude_specific_attribute_value is exists, add tax query
                      if ( $attribute_to_exclude_specific_value && $exclude_specific_attribute_value ) {
                        $args['tax_query'][] = array(
                          'taxonomy' => $attribute_to_exclude_specific_value,
                          'field' => 'slug',
                          'terms' => explode(',', $exclude_specific_attribute_value),
                          'operator' => 'NOT IN',
                        );
                      }                     
                      
                      if ( is_single() && ! isset( $args['post__not_in'] ) ) {
                        $args['post__not_in'] = array( get_the_ID() );
                      }
                      
                      if ($out_of_stock == "off" || $out_of_stock == "") {
                        $args['meta_query'] = array (
                          array(
                            'key' => '_stock_status',
                            'value' => 'outofstock',
                            'compare' => '!=',
                          )
                        );
                      }

                    // Add sorting args to query
                    if ( $sortby == 'price' ) {
                      $args['meta_key'] = '_price';
                      $args['orderby']  = 'meta_value_num';
                    } else if ( $sortby == 'sales' ) {
                      $args['meta_key'] = 'total_sales';
                      $args['orderby']  = 'meta_value_num';
                    } else if ( $sortby == 'rating' ) {
                      $args['meta_key'] = '_wc_average_rating';
                      $args['orderby']  = 'meta_value_num';
                    } else if ( $sortby == 'date' ) {
                      $args['orderby']  = 'date ID';
                    } else if ( $sortby == 'rand' ) {
                      $args['orderby']  = 'rand';
                    } else if ( $sortby == 'title') {
                      $args['orderby']  = 'title';
                    }

                    // Add order args to query
                    if ( $sort_order == 'asc' ) {
                      $args['order'] = 'ASC';
                    } elseif ( $sort_order == 'desc' ) {
                      $args['order'] = 'DESC';
                    }

                    $args = apply_filters( 'bc_related_products_args', $args, $post->ID );

                    

                  	query_posts( $args );

                    
                    //$products = new WP_Query($args);

                    ob_start();

                    if ( have_posts() ) {
                      
                      ?>
                      <h2><?php esc_html_e( 'Related products', 'woocommerce' ); ?></h2>
                      <?php

                      $i = 0;

                    echo '<ul class="et_pb_row_bodycommerce products bc_product_grid bc_product_' . $cols . ' bc_pro_tab_'. $columns_tablet .' bc_pro_mob_'. $columns_mobile .'">';

                      while ( have_posts() ) {
                      the_post();
                      $post_link = get_permalink(get_the_ID());
                      echo '<li class="product bc_product ' . esc_attr( implode( " ", wc_get_product_class( '', get_the_ID() ) ) ) . '">';
                      
                      if ($link_whole_gird == "on") {
                        ?>
                        <div class="bc-link-whole-grid-card" data-link-url="<?php echo $post_link ?>">
                        <?php   
                      }

                      echo apply_filters('the_content', get_post_field('post_content', $loop_layout));

                      if ($link_whole_gird == "on") {
                        ?>
                        </div>  
                        <?php       
                        }

                      echo '</li>';
                      $i++;

                    }
                    echo '</ul>';
                    } else {
                      if ($no_posts_layout != "") {
                        echo apply_filters('the_content', get_post_field('post_content', $no_posts_layout));
                      } else {
                        echo '<p class="woocommerce-info">' . esc_html__( 'No products were found matching your selection.', 'woocommerce' ) . '</p>';
                      }
                    }
                    wp_reset_query();

                    $output .= ob_get_contents();
                    ob_end_clean();

                    $output .= sprintf(
                    '</div>'
                    );
                    }
                  } else {
                    ob_start();

                    $args = array();

                    $defaults = array(
                      'posts_per_page' => ($to_show ? $to_show:$to_show),
                      'columns'        => $to_show,
                      'orderby'        => 'rand'
                    );

                    // if ($out_of_stock == "off" || $out_of_stock == "") {
                    //     $defaults['meta_query'] = array (
                    //       array(
                    //         'key'     => '_stock_status',
                    //         'value'   => 'outofstock',
                    //         'compare' => 'NOT LIKE',
                    //       )
                    //     );
                    //   }

                      

                    // print_r($defaults);

                    $args = wp_parse_args( $args, $defaults );
                    
                    woocommerce_related_products( $args );

                    $output = ob_get_contents();
                    ob_end_clean();


                        $this->add_classname( 'bc_default_loop' );
                        $this->add_classname( 'bc_default_desk_' . $cols . '' );
                        $this->add_classname( 'bc_default_tab_'. $columns_tablet .'' );
                        $this->add_classname( 'bc_default_mob_'. $columns_mobile .'' );

                  }




                                    return $output;


                                   //////////////////////////////////////////////////////////////////////

                  }
              }

            new db_related_products_code;

?>
