<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class db_reviews_code extends ET_Builder_Module {

public $vb_support = 'on';

  public $folder_name;
  public $fields_defaults;
  public $text_shadow;
  public $margin_padding;
  public $_additional_fields_options;

protected $module_credits = array(
  'module_uri' => DE_DB_PRODUCT_URL,
  'author'     => DE_DB_AUTHOR,
  'author_uri' => DE_DB_URL,
);

                function init() {
                    $this->name       = esc_html__( 'PP Reviews - Product Page', 'divi-bodyshop-woocommerce' );
                    $this->slug = 'et_pb_db_reviews';
                    $this->folder_name = 'divi_bodycommerce';

		$this->fields_defaults = array(
			'show_heading' => array( 'on' ),
		);

          $this->settings_modal_toggles = array(
      			'general' => array(
      				'toggles' => array(
      					'main_content' => esc_html__( 'Module Options', 'divi-bodyshop-woocommerce' ),
      					'elements' => esc_html__( 'Elements', 'divi-bodyshop-woocommerce' ),
      				),
      			),
      			'advanced' => array(
      				'toggles' => array(

      					'text' => esc_html__( 'Text', 'divi-bodyshop-woocommerce' ),
                
                'star_design'		=> array(
                  'title' => esc_html__( 'Stars', 'divi-bodyshop-woocommerce'),
                  'tabbed_subtoggles' => true,
                  'sub_toggles'       => array(
                    'primary'     => array(
                      'name' => esc_html__( 'Primary', 'divi-bodyshop-woocommerce')
                    ),
                    'secondary'     => array(
                      'name' => esc_html__( 'Secondary', 'divi-bodyshop-woocommerce')
                    )
                  )
                ),
              
              ),

      			),

      		);


          $this->main_css_element = '%%order_class%%';
          $this->advanced_fields = array(
      			'fonts' => array(
      				'header' => array(
      					'label'    => esc_html__( 'Heading', 'divi-bodyshop-woocommerce' ),
      					'css'      => array(
      						'main' => "{$this->main_css_element} .woocommerce-Reviews-title",
      					),
      					'font_size' => array(
      						'default' => '26px',
      					),
      					'line_height' => array(
      						'default' => '1em',
      					),
      				),
      			),
      			'background' => array(
      				'settings' => array(
      					'color' => 'alpha',
      				),
      			),
      			'border' => array(),
      			'custom_margin_padding' => array(
      				'css' => array(
      					'important' => 'all',
      				),
      			),
      			'button' => array(
      				'button' => array(
      					'label' => esc_html__( 'Submit Button', 'divi-bodyshop-woocommerce' ),
      					'css' => array(
      						'main' => "%%order_class%% #review_form #respond .form-submit [name='submit']",
          					'important' => 'all',
      					),
      					'box_shadow'  => array(
      						'css' => array(
      							'main' => "%%order_class%% #review_form #respond .form-submit [name='submit']",
            					'important' => 'all',
      						),
      					),
                'margin_padding' => array(
                'css'           => array(
                  'main' => "{$this->main_css_element} #review_form #respond .form-submit [name='submit']",
                  'important' => 'all',
                ),
                ),
      				),
      			),
            'form_field'     => array(
              'form_field' => array(
                'label'          => esc_html__( 'Fields', 'et_builder' ),
                'css'            => array(
                  'main'                         => '%%order_class%% .star-rating, %%order_class%% .comment-form-rating p.stars a',
                  'background_color'             => '%%order_class%% #review_form #respond textarea',
                  'background_color_hover'       => '%%order_class%% #review_form #respond textarea:hover',
                  'focus_background_color'       => '%%order_class%% #review_form #respond textarea:focus',
                  'focus_background_color_hover' => '%%order_class%% #review_form #respond textarea:focus:hover',
                  'placeholder_focus'            => '%%order_class%% #review_form #respond textarea:focus::-webkit-input-placeholder, %%order_class%% #review_form #respond textarea:focus::-moz-placeholder, %%order_class%% #review_form #respond textarea:focus:-ms-input-placeholder',
                  'padding'                      => '%%order_class%% #review_form #respond textarea',
                  'margin'                       => '%%order_class%% #review_form #respond textarea',
                  'form_text_color'              => '%%order_class%% #review_form #respond textarea',
                  'form_text_color_hover'        => '%%order_class%% #review_form #respond textarea:hover',
                  'focus_text_color'             => '%%order_class%% #review_form #respond textarea:focus',
                  'focus_text_color_hover'       => '%%order_class%% #review_form #respond textarea:focus:hover',
                ),
                'box_shadow'     => false,
                'border_styles'  => false,
                'font_field'     => array(
                  'css' => array(
                    'main'  => implode(
                      ', ',
                      array(
                        "{$this->main_css_element} #review_form #respond textarea",
                        "{$this->main_css_element} #review_form #respond textarea::placeholder",
                        "{$this->main_css_element} #review_form #respond textarea::-webkit-input-placeholder",
                        "{$this->main_css_element} #review_form #respond textarea::-moz-placeholder",
                        "{$this->main_css_element} #review_form #respond textarea:-ms-input-placeholder",
                      )
                    ),
                    'hover' => array(
                        "{$this->main_css_element} #review_form #respond textarea:hover",
                        "{$this->main_css_element} #review_form #respond textarea:hover::placeholder",
                        "{$this->main_css_element} #review_form #respond textarea:hover::-webkit-input-placeholder",
                        "{$this->main_css_element} #review_form #respond textarea:hover::-moz-placeholder",
                        "{$this->main_css_element} #review_form #respond textarea:hover:-ms-input-placeholder",
                    ),
                  ),
                ),
              ),
            ),
      		);

		$this->custom_css_fields = array(
			'header' => array(
				'label' => esc_html__( 'Heading', 'divi-bodyshop-woocommerce' ),
				'selector' => "{$this->main_css_element} .woocommerce-Reviews-title",
			),
		);

    $this->help_videos = array(
      array(
        'id'   => esc_html__( 'n2karNiwJ3A', 'divi-bodyshop-woocommerce' ), // YouTube video ID
        'name' => esc_html__( 'BodyCommcerce Product Page Template Guide', 'divi-bodyshop-woocommerce' ),
      ),
    );
  }

                  function get_fields() {
                      $fields = array(
                        
                        'show_heading' => array(
                          'label' => esc_html__( 'Show Heading', 'divi-bodyshop-woocommerce' ),
                          'type' => 'yes_no_button',
                          'options_category' => 'configuration',
                          'options' => array(
                            'on'  => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
                            'off' => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
                          ),
                          'toggle_slug' => 'main_content'
                        ),
                        'star_primary' => array(
                          'label'             => esc_html__( 'Primary Star Color', 'divi-bodyshop-woocommerce' ),
                          'type'              => 'color-alpha',
                          'custom_color'      => true,
                  				'toggle_slug' => 'star_design',
                          'sub_toggle'		=> 'primary',
                          'description'       => esc_html__( 'This will chanege the color of the primary stars (the ones that indicate the number rating)', 'divi-bodyshop-woocommerce' ),
                        ),
                        'star_secondary' => array(
                          'label'             => esc_html__( 'Secondary Star Color', 'divi-bodyshop-woocommerce' ),
                          'type'              => 'color-alpha',
                          'custom_color'      => true,
                  				'toggle_slug' => 'star_design',
                          'sub_toggle'		=> 'secondary',
                          'description'       => esc_html__( 'This will chanege the color of the secondary stars (the ones that indicate the missing number rating)', 'divi-bodyshop-woocommerce' ),
                        ),

                        'show_author_avatar'  => array(
                          'label'             => esc_html__( 'Show Author Avatar', 'divi-machine'),
                          'type'              => 'yes_no_button',
                          'option_category'   => 'configuration',
                          'options'           => array(
                            'on'    => esc_html__( 'Yes', 'divi-machine' ),
                            'off'   => esc_html__( 'No', 'divi-machine' ),
                          ),
                          'description'       => esc_html__( 'Enable or Disable the profile picture.', 'divi-machine' ),
                          'default'           => 'on',
                          'toggle_slug'       => 'elements'
                        ),
                        'show_comment_count'  => array(
                          'label'             => esc_html__( 'Show Comment Count', 'divi-machine'),
                          'type'              => 'yes_no_button',
                          'option_category'   => 'configuration',
                          'options'           => array(
                            'on'    => esc_html__( 'Yes', 'divi-machine' ),
                            'off'   => esc_html__( 'No', 'divi-machine' ),
                          ),
                          'description'       => esc_html__( 'Enable or Disable the comment count.', 'divi-machine' ),
                          'default'           => 'on',
                          'toggle_slug'       => 'elements'
                        ),
                        'show_meta'  => array(
                          'label'             => esc_html__( 'Show Meta', 'divi-machine'),
                          'type'              => 'yes_no_button',
                          'option_category'   => 'configuration',
                          'options'           => array(
                            'on'    => esc_html__( 'Yes', 'divi-machine' ),
                            'off'   => esc_html__( 'No', 'divi-machine' ),
                          ),
                          'description'       => esc_html__( 'Turn on or off the meta.', 'divi-machine' ),
                          'default'           => 'on',
                          'toggle_slug'       => 'elements'
                        ),
                        'show_rating'  => array(
                          'label'             => esc_html__( 'Show Rating', 'divi-machine'),
                          'type'              => 'yes_no_button',
                          'option_category'   => 'configuration',
                          'options'           => array(
                            'on'    => esc_html__( 'Yes', 'divi-machine' ),
                            'off'   => esc_html__( 'No', 'divi-machine' ),
                          ),
                          'description'       => esc_html__( 'Turn on or off the rating.', 'divi-machine' ),
                          'default'           => 'on',
                          'toggle_slug'       => 'elements'
                        ),



                        'admin_label' => array(
                            'label'       => __( 'Admin Label', 'divi-bodyshop-woocommerce' ),
                            'type'        => 'text',
                            'toggle_slug'     => 'main_content',
                            'description' => __( 'This will change the label of the module in the builder for easy identification.', 'divi-bodyshop-woocommerce' ),
                        ),
                        '__getproreviews' => array(
                        'type' => 'computed',
                        'computed_callback' => array( 'db_reviews_code', 'get_pro_reviews' ),
                        'computed_depends_on' => array(
                        'admin_label'
                        ),
                        ),
                      );

                      return $fields;
                  }

                  public static function get_pro_reviews ( $args = array(), $conditional_tags = array(), $current_page = array() ){
                    if (!is_admin()) {
                      			return;
                      		}
                    ob_start();

                    $args = array(
                      'post_type' => 'product',
                    'post_status' => 'publish',
                    'posts_per_page' => '3',
                    'orderby' => 'ID',
                    'order' => 'ASC',
                  );

                    $loop = new WP_Query( $args );

                    $first = true;
                    while ( $loop->have_posts() ) : $loop->the_post();

                      if ( $first )  {
//*---------------------------------------------------------------------------------------------------*//
	                    comments_template();
//*---------------------------------------------------------------------------------------------------*//
                    $first = false;
                } else {

                }
              endwhile; wp_reset_query(); // Remember to reset

                    $data = ob_get_clean();

                  return $data;

                  }

                    function render( $attrs, $content, $render_slug ) {
                      
                      if ( is_admin() && ( ! defined( 'DOING_AJAX' ) || ! DOING_AJAX ) ) {
                        return;
                      }

                    $show_heading     				= $this->props['show_heading'];
                    $star_primary             = $this->props['star_primary'];
                    $star_secondary           = $this->props['star_secondary'];
                    $button_use_icon          	= $this->props['button_use_icon'];
                    $custom_icon          		= $this->props['button_icon'];
                    $button_custom        		= $this->props['custom_button'];

                    $show_author_avatar       		= $this->props['show_author_avatar'];
                    $show_comment_count       		= $this->props['show_comment_count'];
                    $show_meta       		= $this->props['show_meta'];
                    $show_rating       		= $this->props['show_rating'];
        
                    // Module classnames
                    $this->add_classname(
                      array(
                        'clearfix',
                        $this->get_text_orientation_classname(),
                      )
                    );

                    if( $show_author_avatar == 'off' ){
                      ET_Builder_Element::set_style( $render_slug, array(
                        'selector'    => '%%order_class%% #reviews #comments ol.commentlist li img.avatar',
                        'declaration' => "display: none !important;",
                      ) );
                      ET_Builder_Element::set_style( $render_slug, array(
                        'selector'    => '%%order_class%% #reviews #comments ol.commentlist li .comment-text, .woocommerce-page #reviews #comments ol.commentlist li .comment-text',
                        'declaration' => "margin-left: 0 !important;",
                      ) );
                    }
                    if( $show_comment_count == 'off' ){
                      ET_Builder_Element::set_style( $render_slug, array(
                        'selector'    => '%%order_class%% .woocommerce-Reviews-title',
                        'declaration' => "display: none !important;",
                      ) );
                    }
                    if( $show_meta == 'off' ){
                      ET_Builder_Element::set_style( $render_slug, array(
                        'selector'    => '%%order_class%% #reviews #comments ol.commentlist li .comment-text p.meta',
                        'declaration' => "display: none !important;",
                      ) );
                    }
                    if( $show_rating == 'off' ){
                      ET_Builder_Element::set_style( $render_slug, array(
                        'selector'    => '%%order_class%% #reviews .commentlist .star-rating',
                        'declaration' => "display: none !important;",
                      ) );
                    }
                    




                    $data = '';

                  //////////////////////////////////////////////////////////////////////

                                  ob_start();
                                  if( is_admin() ){
                                    return;
                                  }


                                  comments_template();



                                    if( !empty( $star_primary ) ){

                              				ET_Builder_Element::set_style( $render_slug, array(
                              					'selector'    => 'body.woocommerce %%order_class%% .comment-form .stars a , body.woocommerce %%order_class%% .star-rating span::before, body.woocommerce-page %%order_class%% .star-rating span::before, %%order_class%% #reviews .stars.selected a.active::before, %%order_class%% #reviews .stars:hover a::before, %%order_class%% #reviews .stars.selected a:not(.active)::before',
                              					'declaration' => "color: ". esc_attr( $star_primary ) ."!important;",
                              				) );
                              			}



                                    if( !empty( $star_secondary ) ){

                              				ET_Builder_Element::set_style( $render_slug, array(
                              					'selector'    => 'body.woocommerce %%order_class%% .star-rating:before, body.woocommerce-page %%order_class%% .star-rating:before, %%order_class%% #reviews .stars a, %%order_class%% #reviews .stars.selected a.active~a::before, %%order_class%% #reviews p.stars a:hover~a::before',
                              					'declaration' => "color: ". esc_attr( $star_secondary ) ."!important;",
                              				) );
                              			}

                                    if( $show_heading == 'off' ){

                            				ET_Builder_Element::set_style( $render_slug, array(
                            					'selector'    => '%%order_class%% .woocommerce-Reviews-title',
                            					'declaration' => "display: none !important;",
                            				) );
                            			}


                                if( $button_use_icon == 'on' && $custom_icon != '' && $button_custom == 'on' ){
                                    $custom_icon_arr = explode('||', $custom_icon);
                                    $custom_icon_font_family = ( !empty( $custom_icon_arr[1] ) && $custom_icon_arr[1] == 'fa' )?'FontAwesome':'ETmodules';
                                    $custom_icon_font_weight = ( !empty( $custom_icon_arr[2] ))?$custom_icon_arr[2]:'400';
                                    $custom_icon = 'data-icon="'. esc_attr( et_pb_process_font_icon( $custom_icon ) ) .'"';


                                    ET_Builder_Element::set_style( $render_slug, array(
                                      'selector'    => "%%order_class%% #review_form #respond .form-submit [name='submit']:after",
                                      'declaration' => "content: attr(data-icon);
                                        font-family:{$custom_icon_font_family}!important;
                                        font-weight:{$custom_icon_font_weight};",
                                    ) );
                                }else{
                                  ET_Builder_Element::set_style( $render_slug, array(
                                    'selector'    => "%%order_class%% #review_form #respond .form-submit [name='submit']:hover",
                                    'declaration' => "padding: .3em 1em;",
                                  ) );
                                }

          $data = ob_get_clean();


                                   //////////////////////////////////////////////////////////////////////

                                   $data = str_replace(
                                     'class="submit"',
                                     'class="submit"' . $custom_icon
                                     , $data
                                   );

                                return $data;
                  }
              }

            new db_reviews_code;

?>
