<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class db_shop_button_code extends ET_Builder_Module {

  public static $button_text, $p;
  public $folder_name;
  public $fields_defaults;
  public $text_shadow;
  public $margin_padding;
  public $_additional_fields_options;
  
	public static function change_button_text( $btn_text ){
		if( !empty( self::$button_text ) ){
			$btn_text = esc_html__( self::$button_text );
		}
		return $btn_text;
	}

public $vb_support = 'on';

protected $module_credits = array(
  'module_uri' => DE_DB_PRODUCT_URL,
  'author'     => DE_DB_AUTHOR,
  'author_uri' => DE_DB_URL,
);

                function init() {
                    $this->name       = esc_html__( 'LL View Product Btn - Loop Layout', 'divi-bodyshop-woocommerce' );
                    $this->slug = 'et_pb_db_shop_button';
                    $this->folder_name = 'divi_bodycommerce';

                    $this->settings_modal_toggles = array(

      			'general' => array(
              'toggles' => array(
					'hide_out_stock_button' => esc_html__( 'Add to Cart Button', 'divi-bodyshop-woocommerce' ),
					'quantity' => esc_html__( 'Quantity', 'divi-bodyshop-woocommerce' ),
					'variations' => esc_html__( 'Variations', 'divi-bodyshop-woocommerce' ),
				      ),
      			),

      		);


                      $this->main_css_element = '%%order_class%%';
                      $this->fields_defaults = array();



                      $this->advanced_fields = array(
                                      'button' => array(
                                        'button' => array(
                                          'label' => esc_html__( 'Button', 'et_builder' ),
                                          'css' => array(
                                            'main' => "{$this->main_css_element} .et_pb_button, {$this->main_css_element} .dbc_view_product",
                                            'plugin_main' => "{$this->main_css_element}.et_pb_module",
                                          ),
                                          'box_shadow'  => array(
                                            'css' => array(
                                              'main' => "{$this->main_css_element} .et_pb_button, {$this->main_css_element} .dbc_view_product",
                                                  'important' => 'all',
                                            ),
                                          ),
                                          'margin_padding' => array(
                                          'css'           => array(
                                            'main' => "{$this->main_css_element} .et_pb_button, {$this->main_css_element} .dbc_view_product",
                                            'important' => 'all',
                                          ),
                                          ),
                                        ),
                                      ),
                                          'background' => array(
                                                  'settings' => array(
                                                          'color' => 'alpha',
                                                  ),
                                          ),
                                          'border' => array(),
                                          'custom_margin_padding' => array(
                                                  'css' => array(
                                                          'important' => 'all',
                                                  ),
                                          ),
                                  );
                      $this->custom_css_fields = array();

            $this->help_videos = array(
              array(
                'id'   => esc_html__( 'n2karNiwJ3A', 'divi-bodyshop-woocommerce' ), // YouTube video ID
                'name' => esc_html__( 'BodyCommcerce Product Page Template Guide', 'divi-bodyshop-woocommerce' ),
              ),
            );
          }

                  function get_fields() {
                      $fields = array(
                        'title' => array(
                          'label'           => esc_html__( 'Button Text', 'divi-bodyshop-woocommerce' ),
                          'type'            => 'text',
                          'option_category' => 'basic_option',
                          'default'         => 'View Product',
                          'description'     => esc_html__( 'Input your desired button text.', 'divi-bodyshop-woocommerce' ),
                        ),
                        'custom_url' => array(
                          'label'       => __( 'Custom URL End', 'divi-bodyshop-woocommerce' ),
                          'type'        => 'text',
                          'description' => __( 'If you want to add an extension after the URL such as an anchor link - add it here. For example add #buynow to go to a section on the product page that has the ID "buynow".', 'et_builder' ),
                        ),
                        'fullwidth_button' => array(
                          'option_category' => 'basic_option',
                          'label'             => esc_html__( 'Make "Button Fullwidth" Style', 'divi-bodyshop-woocommerce' ),
                          'type'              => 'yes_no_button',
                          'options'   => array(
                              'on'    => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
                              'off'   => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
                          ),
                          'default'           => 'off',
                          'description'       => esc_html__( 'Enable if you want the button to be fullwidth. Text alignment will be inherited from module style settings. Defaults to left alignment.' ),
                      ),
                        'disable_button' => array(
                            'option_category' => 'basic_option',
                            'label'             => esc_html__( 'Disable "Button" Style', 'divi-bodyshop-woocommerce' ),
                            'type'              => 'yes_no_button',
                            'options'   => array(
                                'on'    => esc_html__( 'Yes', 'divi-bodyshop-woocommerce' ),
                                'off'   => esc_html__( 'No', 'divi-bodyshop-woocommerce' ),
                            ),
                            'default'           => 'off',
                            'description'       => esc_html__( 'If you want the button to be disabled so its just plain text, enable this.', 'divi-bodyshop-woocommerce' ),
                        ),
                      );

                      return $fields;
                  }

                    function render( $attrs, $content, $render_slug ) {
                      
                      if ( is_admin() && ( ! defined( 'DOING_AJAX' ) || ! DOING_AJAX ) ) {
                        return;
                      }
                      

                  self::$button_text      	= $this->props['title'];

                  $custom_url  = $this->props['custom_url'];
                  $title  = $this->props['title'];
                  $button_use_icon  			= $this->props['button_use_icon'];
                  $custom_button        		= $this->props['custom_button'];
                  $button_icon 				= $this->props['button_icon'];
                  $button_icon_placement 		= $this->props['button_icon_placement'];                  
                  $fullwidth_button 		= $this->props['fullwidth_button'];
                  $disable_button 		= $this->props['disable_button'];
                  

                  $data = '';
        
                  // Module classnames
                  $this->add_classname(
                    array(
                      'clearfix',
                      $this->get_text_orientation_classname(),
                    )
                  );

                  //////////////////////////////////////////////////////////////////////
            

                  global $product;

                  if ( !$product ){
                    return;
                  }

                  ob_start();

                  if ($disable_button == 'on') {
                    $button_class = '';
                  } else {
                    $button_class = 'et_pb_button';
                  }
                  
                  $product_id = $product->get_id();
                  $url = get_permalink( $product_id );
                  ?>
                <a class="dbc_view_product <?php echo esc_attr($button_class); ?>" href="<?php echo $url ?><?php echo $custom_url ?>"><?php echo $title; ?> </a>

                  <?php
                  // Make the button fullwidth
                  if( $fullwidth_button == 'on' ){
                    ET_Builder_Element::set_style( $render_slug, array(
                      'selector' => 'body #page-container %%order_class%% .dbc_view_product',
                      'declaration' => "display: block!important; width: 100%!important;"
                      )
                    );
                  }
                  // button icon and background
                  if( $custom_button == 'on' ){
                    if( $button_icon !== '' ){
                      $button_icon_arr = explode('||', $button_icon);

                      $button_icon_font_family = ( !empty( $button_icon_arr[1] ) && $button_icon_arr[1] == 'fa' )?'FontAwesome':'ETmodules';
                      $button_icon_font_weight = ( !empty( $button_icon_arr[2] ))?$button_icon_arr[2]:'400';

                      if ( class_exists( 'DEBC_INIT' ) ) {
                          $iconContent = DEBC_INIT::et_icon_css_content( esc_attr($button_icon) );
                      } else if (class_exists( 'DEDMACH_INIT' ) ) {
                          $iconContent = DEDMACH_INIT::et_icon_css_content( esc_attr($button_icon) );
                      } else {
                          $iconContent = DE_Filter::et_icon_css_content( esc_attr($button_icon) );
                      }

                      $iconSelector = '';
                      if( $button_icon_placement == 'right' ){
                        $iconSelector = 'body #page-container %%order_class%% .dbc_view_product:after';
                      } elseif ( $button_icon_placement == 'left' ){
                        $iconSelector = 'body #page-container %%order_class%% .dbc_view_product:before';
                      }
                      if( !empty( $iconContent ) && !empty( $iconSelector ) ){
                        ET_Builder_Element::set_style( $render_slug, array(
                          'selector' => $iconSelector,
                          'declaration' => "content: '{$iconContent}'!important;
                          font-family:{$button_icon_font_family}!important;
                          font-weight:{$button_icon_font_weight};
                          display: inline-block!important;
                          line-height: inherit;
                          font-size: inherit!important;
                          margin-left: .3em;
                          left: auto;
                          display: inline-block;
                          "
                          )
                        );
                      }
                    }
                    
                    if( $button_use_icon == 'on' && $button_icon != '' ){
                      $button_icon_arr = explode('||', $button_icon);
                      $button_icon_font_family = ( !empty( $button_icon_arr[1] ) && $button_icon_arr[1] == 'fa' )?'FontAwesome':'ETmodules';
                      $button_icon_font_weight = ( !empty( $button_icon_arr[2] ))?$button_icon_arr[2]:'400';
                      $button_icon = 'data-icon="'. esc_attr( et_pb_process_font_icon( $button_icon ) ) .'"';
                      ET_Builder_Element::set_style( $render_slug, array(
                        'selector'    => 'body #page-container %%order_class%% .dbc_view_product:after',
                        'declaration' => "content: attr(data-icon);
                          font-family:{$button_icon_font_family}!important;
                          font-weight:{$button_icon_font_weight};",
                        ) );
                    }else{
                      ET_Builder_Element::set_style( $render_slug, array(
                        'selector'    => 'body #page-container %%order_class%% .dbc_view_product:hover',
                        'declaration' => "padding: .3em 1em;",
                        ) );
                    }
                    
                    // fix the button padding if has no icon
                    if( $button_use_icon == 'off' ){
                      ET_Builder_Element::set_style( $render_slug, array(
                        'selector' => 'body.woocommerce %%order_class%% .button',
                        'declaration' => "padding: 0.3em 1em!important"
                        )
                      );
                    }

                  }

                  $data = ob_get_clean();
                  //////////////////////////////////////////////////////////////////////

                  // $data = str_replace(
              		// 	'class="dbc_view_product et_pb_button"',
              		// 	'class="dbc_view_product et_pb_button"' . $button_icon
              		// 	, $data
              		// );

                  return $data;

                  }
              }

            new db_shop_button_code;

?>
