<?php
if ( ! defined( 'ABSPATH' ) ) exit;

//////////////////////////////////////////
/////////////// AJAX CART ///////////////
//////////////////////////////////////////

$check_enable_ajax_cart = get_bodycommerce_option('other_settings_ajax_add_to_cart', "0");
//$check_minicart_hover_click = $mydata['minicart_hover_click'][0];

if ($check_enable_ajax_cart == "1") {

	function bodycommerce_ajax_add_to_cart_script() {
        if ( class_exists('WooCommerce')) {
            $check_ajax_atc_js_method_display = get_bodycommerce_option('ajax_atc_js_method_1', "1");

            $params = array(
                'ajax_url'                => WC()->ajax_url(),
                'wc_ajax_url'             => WC_AJAX::get_endpoint( '%%endpoint%%' ),
                'i18n_view_cart'          => esc_attr__( 'View cart', 'woocommerce' ),
                'cart_url'                => apply_filters( 'woocommerce_add_to_cart_redirect', wc_get_cart_url(), null ),
                'is_cart'                 => is_cart(),
                'cart_redirect_after_add' => get_option( 'woocommerce_cart_redirect_after_add' ),
                'ajax_error_text' => __( 'Please select', 'divi-bodyshop-woocommerce' ),
            );

            if ($check_ajax_atc_js_method_display == "1") {
                wp_enqueue_script( 'bodycommerce-add-to-cart-ajax', plugins_url() . '/divi-bodycommerce/js/add-to-cart-ajax.min.js', array('jquery'), DE_DB_WOO_VERSION, true );
                wp_localize_script( 'bodycommerce-add-to-cart-ajax', 'bc_add_to_cart_params', $params );
            }else {
                wp_enqueue_script( 'bodycommerce-add-to-cart-ajax-alternative', plugins_url() . '/divi-bodycommerce/js/add-to-cart-ajax-alter.min.js', array('jquery'), DE_DB_WOO_VERSION, true );
                wp_localize_script( 'bodycommerce-add-to-cart-ajax', 'bc_add_to_cart_params', $params );
            }
        }
    }
	add_action( 'wp_enqueue_scripts', 'bodycommerce_ajax_add_to_cart_script',99 );


    // BUNDLE CALLBACK
  	add_action( 'wp_ajax_bodycommerce_ajax_add_to_cart_woo_bundle', 'bodycommerce_ajax_add_to_cart_woo_bundle_callback' );
  	add_action( 'wp_ajax_nopriv_bodycommerce_ajax_add_to_cart_woo_bundle', 'bodycommerce_ajax_add_to_cart_woo_bundle_callback' );

  	function bodycommerce_ajax_add_to_cart_woo_bundle_callback() {

  		ob_start();

        $product_id = apply_filters( 'woocommerce_add_to_cart_product_id', absint( $_POST['product_id'] ) ); // phpcs:ignore
        $quantity = "0"; // phpcs:ignore
        $grouped_data = $_POST['grouped_data']; // phpcs:ignore
        $testarray = array();

        $add_to_cart_error = false;
        
        foreach ($grouped_data as $key => $value) {
            $product_id = str_replace("product-", '', $key) ;
            $quantity = $value;
            $passed_validation = apply_filters( 'woocommerce_add_to_cart_validation', true, $product_id, $quantity );
            if ( $passed_validation && WC()->cart->add_to_cart( $product_id, $quantity  ) ) {
                do_action( 'woocommerce_ajax_added_to_cart', $product_id );
            } else {
                $add_to_cart_error = true;
            }
        }

        if ( $add_to_cart_error != true ) {
            $ajax_show_woocommerce_notice = get_bodycommerce_option('other_settings_ajax_show_notice', "0");

            if ( $ajax_show_woocommerce_notice == "1" ) {
                if ( get_option( 'woocommerce_cart_redirect_after_add' ) != 'yes' ) {
                    wc_add_to_cart_message( array( $product_id => $quantity ), true );
                    add_filter('woocommerce_add_to_cart_fragments', function( $data ){
                        $data['div.woocommerce-notices-wrapper.main'] = '<div class="woocommerce-notices-wrapper">';
                        foreach ( wc_get_notices('success') as $notices ) {
                            $data['div.woocommerce-notices-wrapper.main'] .= '<p role="alert" class="woocommerce-message">' . $notices['notice'] . '</p>';
                        }
                        $data['div.woocommerce-notices-wrapper.main'] .= '</div>';
                        wc_clear_notices();
                        return $data;
                    }, 10, 1);
                }
            }
            WC_AJAX::get_refreshed_fragments();
        }  else  {
            // $this->json_headers(); // REMOVED AS WAS THROWING AN ERROR
            // If there was an error adding to the cart, redirect to the product page to show any errors
            ob_start();
            wc_print_notices();
            $error_message = ob_get_clean();

            $data = array(
                'error' => true,
                'error_message' => $error_message,
                'product_url' => apply_filters( 'woocommerce_cart_redirect_after_error', get_permalink( $product_id ), $product_id )
            );
            echo json_encode( $data );
        }

        $return = array(
            'product_id' => $testarray
        );

        ob_end_clean();
        die();
    }

    // VARIATION CALLBACK
	add_action( 'wp_ajax_bodycommerce_ajax_add_to_cart_woo', 'bodycommerce_ajax_add_to_cart_woo_callback' );
	add_action( 'wp_ajax_nopriv_bodycommerce_ajax_add_to_cart_woo', 'bodycommerce_ajax_add_to_cart_woo_callback' );

	function bodycommerce_ajax_add_to_cart_woo_callback() {

		ob_start();

		$product_id = apply_filters( 'woocommerce_add_to_cart_product_id', absint( $_POST['product_id'] ) ); // phpcs:ignore
        $quantity = empty( $_POST['quantity'] ) ? 1 : apply_filters( 'woocommerce_stock_amount', $_POST['quantity'] ); // phpcs:ignore
        // $product_quantity = $_POST['product_quantity'];
		$variation_id = $_POST['variation_id']; // phpcs:ignore
		$variation  = $_POST['variation']; // phpcs:ignore
        //$variation = wc_get_product_variation_attributes( $variation_id );

        error_log("Variation Product", 0);
        $passed_validation = apply_filters( 'woocommerce_add_to_cart_validation', true, $product_id, $quantity, $variation_id, $variation  );

        if ( $passed_validation && WC()->cart->add_to_cart( $product_id, $quantity, $variation_id, $variation  ) ) {
            do_action( 'woocommerce_ajax_added_to_cart', $product_id );

            $ajax_show_woocommerce_notice = get_bodycommerce_option('other_settings_ajax_show_notice', "0");

            if ( $ajax_show_woocommerce_notice == "1" ) {
                if ( get_option( 'woocommerce_cart_redirect_after_add' ) != 'yes' ) {
                    wc_add_to_cart_message( array( $product_id => $quantity ), true );
                    add_filter('woocommerce_add_to_cart_fragments', function( $data ){
                        $data['div.woocommerce-notices-wrapper.main'] = '<div class="woocommerce-notices-wrapper">';
                        foreach ( wc_get_notices('success') as $notices ) {
                            $data['div.woocommerce-notices-wrapper.main'] .= '<p role="alert" class="woocommerce-message">' . $notices['notice'] . '</p>';
                        }
                        $data['div.woocommerce-notices-wrapper.main'] .= '</div>';
                        wc_clear_notices();
                        return $data;
                    }, 10, 1);
                }
            }

            // Return fragments
            WC_AJAX::get_refreshed_fragments();
        }  else  {
            // $this->json_headers(); // REMOVED AS WAS THROWING AN ERROR

            // If there was an error adding to the cart, redirect to the product page to show any errors

            ob_start();
            wc_print_notices();
            $error_message = ob_get_clean();

            $data = array(
                'error' => true,
                'error_message' => $error_message,
                'product_url' => apply_filters( 'woocommerce_cart_redirect_after_error', get_permalink( $product_id ), $product_id  )
            );
            echo json_encode( $data );
        }
        die();
	}

    // SINGLE CALLBACK
    add_action( 'wp_ajax_bodycommerce_ajax_add_to_cart_woo_single', 'bodycommerce_ajax_add_to_cart_woo_single_callback' );
    add_action( 'wp_ajax_nopriv_bodycommerce_ajax_add_to_cart_woo_single', 'bodycommerce_ajax_add_to_cart_woo_single_callback' );
    
    function bodycommerce_ajax_add_to_cart_woo_single_callback() {
        ob_start();
        $product_id = apply_filters( 'woocommerce_add_to_cart_product_id', absint( $_POST['product_id'] ) ); // phpcs:ignore
        $quantity = empty( $_POST['quantity'] ) ? 1 : apply_filters( 'woocommerce_stock_amount', $_POST['quantity'] ); // phpcs:ignore
        $passed_validation = apply_filters( 'woocommerce_add_to_cart_validation', true, $product_id, $quantity );

        if ( $passed_validation && WC()->cart->add_to_cart( $product_id, $quantity  ) ) {
            do_action( 'woocommerce_ajax_added_to_cart', $product_id );

            $ajax_show_woocommerce_notice = get_bodycommerce_option('other_settings_ajax_show_notice', "0");

            if ( $ajax_show_woocommerce_notice == "1" ) {
                if ( get_option( 'woocommerce_cart_redirect_after_add' ) != 'yes' ) {
                    wc_add_to_cart_message( array( $product_id => $quantity ), true );
                    add_filter('woocommerce_add_to_cart_fragments', function( $data ){
                        $data['div.woocommerce-notices-wrapper.main'] = '<div class="woocommerce-notices-wrapper">';
                        foreach ( wc_get_notices('success') as $notices ) {
                            $data['div.woocommerce-notices-wrapper.main'] .= '<p role="alert" class="woocommerce-message">' . $notices['notice'] . '</p>';
                        }
                        $data['div.woocommerce-notices-wrapper.main'] .= '</div>';
                        wc_clear_notices();
                        return $data;
                    }, 10, 1);
                }
            }
            // Return fragments
            WC_AJAX::get_refreshed_fragments();
        }  else  {
            // $this->json_headers(); // REMOVED AS WAS THROWING AN ERROR

            // If there was an error adding to the cart, redirect to the product page to show any errors
            ob_start();
            wc_print_notices();
            $error_message = ob_get_clean();

            $data = array(
                'error' => true,
                'error_message' => $error_message,
                'product_url' => apply_filters( 'woocommerce_cart_redirect_after_error', get_permalink( $product_id ), $product_id )
            );
            echo json_encode( $data );
        }

    	die();
	}
}