<?php
if ( ! defined( 'ABSPATH' ) ) exit;

function divi_bodycommerce_cart() { 

        $enable_cart_custom_icon = get_bodycommerce_option( 'enable_cart_custom_icon', "0" );

        $atc_pupup_disable_mobile = get_bodycommerce_option( 'atc_pupup_disable_mobile' );
                
        if ($atc_pupup_disable_mobile == '1') {
            $atc_pupup_disable_mobile_name = 'cart-icon disable_minicart_mobile';
        } else {
            $atc_pupup_disable_mobile_name = 'enable_minicart_mobile';
        }

        if ($enable_cart_custom_icon == "1") {
          
          
                $args = array();
            
                $defaults = array(
                    'no_text' => false,
                );
                $args = wp_parse_args( $args, $defaults );
                if (is_object( WC()->cart ) ) {
                    $items_number = WC()->cart->get_cart_contents_count();
                } else {
                    $items_number = "";
                }
                 
                
                $check_enable_cart_custom_icon = get_bodycommerce_option( 'enable_cart_custom_icon');
                $check_cart_custom_icon_enable_numbers = get_bodycommerce_option( 'cart_custom_icon_enable_numbers' );
                $cart_custom_icon_disable_empty_number = get_bodycommerce_option( 'cart_custom_icon_disable_empty_number' );

                $check_cart_custom_icon_enable_text_after_get = get_bodycommerce_option( 'cart_custom_icon_enable_text_after' );
                $check_cart_custom_icon_enable_text_after_plural_get = get_bodycommerce_option( 'cart_custom_icon_enable_text_after_plural' );
                do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Cart Text After', $check_cart_custom_icon_enable_text_after_get );
                do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Cart Text After Plural', $check_cart_custom_icon_enable_text_after_plural_get );
                
                $check_BodyCommerce_cart_icon = get_bodycommerce_option( 'enable_cart_custom_icon_select' );

              
                
                $minicart_activate = get_bodycommerce_option( 'minicart_activate' );
                $custom_cart_icon_upload = get_bodycommerce_option( 'custom_cart_icon_upload' );
                
                if ($custom_cart_icon_upload == "") {
                    $path = '/lib/cart-icon-styles/'.$check_BodyCommerce_cart_icon.'.php';
                } else {
                    $path = '/lib/cart-icon-styles/users-custom-cart.php';
                }
        
                $cart_icon_shortcode_menu = get_bodycommerce_option( 'cart_icon_shortcode_menu' );
                
                if ($cart_icon_shortcode_menu == 1) {
                    $cart_tag = "span";
                    $cart_href_data = "data-url";
                } else {
                    $cart_tag = "a";
                    $cart_href_data = "href";
                }

                $getCartURL = function_exists( 'wc_get_cart_url' ) ? wc_get_cart_url() : $woocommerce->cart->get_cart_url();
                
                ?>
                <<?php echo esc_attr($cart_tag); ?> <?php echo esc_attr($cart_href_data); ?>="<?php echo $getCartURL ?>" class="cart-link-<?php echo esc_attr($cart_tag); ?> et-cart-info cart-link bc-first" data-url="<?php echo $getCartURL;?>">
                <div class="cart-icon <?php echo $atc_pupup_disable_mobile_name ?>"><?php include(DE_DB_WOO_PATH . $path); ?>
      
            <?php   if ($check_cart_custom_icon_enable_numbers == "1") { 
                        if ($cart_custom_icon_disable_empty_number == 1 && $items_number == "0") {
                            ?>
                            <div class="cart-count loaded hidethis"><p></p> </div>
                            <?php 
                        } else {
                    ?>
                    <div class="cart-count loaded"><p></p> </div>
                    <?php 
                        }
                    } ?>
                    
                </div>
                </<?php echo esc_attr($cart_tag); ?>>
                
                <?php
        
        } else {
            if ( ! class_exists( 'woocommerce' ) || ! WC()->cart ) {
                return;
            }

            
        $cart_custom_icon_enable_numbers = get_bodycommerce_option( 'cart_custom_icon_enable_numbers', "0" );

        if ($cart_custom_icon_enable_numbers == "1") {

            $defaults = array(
                'no_text' => false,
            );

        } else {

            $defaults = array(
                'no_text' => true,
            );

        }

            $args = array();
    
            $args = wp_parse_args( $args, $defaults );
    
            $items_number = WC()->cart->get_cart_contents_count();
    
            $url = function_exists( 'wc_get_cart_url' ) ? wc_get_cart_url() : WC()->cart->get_cart_url();
    
            printf(
                '<a href="%1$s" class="et-cart-info %3$s">
                    <span>%2$s</span>
                </a>',
                esc_url( $url ),
                ( ! $args['no_text']
                    ? esc_html( sprintf(
                        _nx( '%1$s Item', '%1$s Items', $items_number, 'WooCommerce items number', 'Divi' ),
                        number_format_i18n( $items_number )
                    ) )
                    : ''
                ),
                $atc_pupup_disable_mobile_name
            );
          
        }

}


function divi_bodycommerce_get_cart_count_ajax_handler(){
    $enable_cart_custom_icon = get_bodycommerce_option( 'enable_cart_custom_icon', "0" );
    $check_cart_custom_icon_enable_numbers = get_bodycommerce_option( 'cart_custom_icon_enable_numbers' );
    $cart_custom_icon_disable_empty_number = get_bodycommerce_option( 'cart_custom_icon_disable_empty_number' );
    if (is_object( WC()->cart ) ) {
        $items_number = WC()->cart->get_cart_contents_count();
    } else {
        $items_number = "";
    }
    if ($enable_cart_custom_icon == "1") {
        $check_cart_custom_icon_enable_text_after_get = get_bodycommerce_option( 'cart_custom_icon_enable_text_after' );
        $check_cart_custom_icon_enable_text_after_plural_get = get_bodycommerce_option( 'cart_custom_icon_enable_text_after_plural' );

        $check_cart_custom_icon_enable_text_after = apply_filters( 'wpml_translate_single_string', $check_cart_custom_icon_enable_text_after_get, 'divi-bodyshop-woocommerce', 'Cart Text After' );
        $check_cart_custom_icon_enable_text_after_plural = apply_filters( 'wpml_translate_single_string', $check_cart_custom_icon_enable_text_after_plural_get, 'divi-bodyshop-woocommerce', 'Cart Text After Plural' );

        $cartCount = esc_html( sprintf(
                    _nx( 
                        '%1$s '.$check_cart_custom_icon_enable_text_after.'', 
                        '%1$s '.$check_cart_custom_icon_enable_text_after_plural.'', 
                        $items_number, 'WooCommerce items number', 'divi-bodyshop-woocommerce' ),
                    number_format_i18n( $items_number )  
                ) );

                if ($cart_custom_icon_disable_empty_number == 1 && $items_number == "0") {
                } else {
                    echo $cartCount;
                }

    } else {

        $args = array();

        $defaults = array(
            'no_text' => true,
        );
    
        $args = wp_parse_args( $args, $defaults );

        if (! $args['no_text']) {    
            echo esc_html( sprintf(
             _nx( '%1$s Item', '%1$s Items', $items_number, 'WooCommerce items number', 'Divi' ),
             number_format_i18n( $items_number )
            ) );
        }
    }
    exit;
}

add_action("wp_ajax_get_bc_cart_count", "divi_bodycommerce_get_cart_count_ajax_handler");
add_action("wp_ajax_nopriv_get_bc_cart_count", "divi_bodycommerce_get_cart_count_ajax_handler");