<?php 

// if accessed directly, then exit
if (!defined('ABSPATH')) {
  exit;
}

// Ajax loaded mini cart
function dbc_minicart_ajax_loaded() {
    ?>
    <script>
        jQuery(document).ready(function($) {

            function update_minicart() {
            // ajax  call to get the cart contents and display the mini cart
                $.ajax({
                    url: '<?php echo esc_js( admin_url( 'admin-ajax.php' ) ); ?>',
                    type: 'POST',
                    data: {
                        action: 'dbc_get_mini_cart'
                    },
                    success: function(response) {
                        $('.bodycommerce-minicart').html(response);
                        $('.mini-cart-loading').hide();
                    },
                    error: function(error) {
                        console.log(error);
                    }
                });
            }

            function update_cart_count() {
                console.log('update cart count');
                jQuery.ajax({
                    url: '<?php echo admin_url( 'admin-ajax.php' );?>',
                    data: {
                        action: 'get_bc_cart_count',
                    },
                    type: 'POST',
                    success: function( data ) {
                      jQuery('.cart-count p').html( data );
                      jQuery('.cart-count').removeClass("hideanimation hidethis");

                    }
                });
            }

            update_minicart();

        // on remove product from mini cart
        $(document).on('removed_from_cart', function() {
            update_minicart();
        });

        // bodycommerce_atc_completed trigger
        $(document).on('bodycommerce_atc_completed', function() {
            update_minicart();
            update_cart_count();
        });

    });
    </script>
    <?php 
}

add_action('wp_footer', 'dbc_minicart_ajax_loaded');