<?php
if ( ! defined( 'ABSPATH' ) ) exit;

$atc_pupup_enable = get_bodycommerce_option('atc_pupup_enable');

if ($atc_pupup_enable == "1") {

add_filter('woocommerce_add_to_cart_fragments', 'db_woo_modal_pop_up_add_to_cart');

function db_woo_modal_pop_up_add_to_cart( $fragments, $args = array() ) {
    $atc_pupup_successfully_added_to_cart_get= get_bodycommerce_option( 'atc_pupup_successfully_added_to_cart' );
    $atc_pupup_continue_shopping_btn_text_get= get_bodycommerce_option( 'atc_pupup_continue_shopping_btn_text' );
    $atc_pupup_continue_shopping_btn_url_get= get_bodycommerce_option( 'atc_pupup_continue_shopping_btn_url' );

    do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Successfully added to cart Text for Pop Up', $atc_pupup_successfully_added_to_cart_get );
    do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Continue Shopping Button Text for Pop Up', $atc_pupup_continue_shopping_btn_text_get );
    do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Continue Shopping Button URL for Pop Up', $atc_pupup_continue_shopping_btn_url_get );

    $atc_pupup_successfully_added_to_cart = apply_filters( 'wpml_translate_single_string', $atc_pupup_successfully_added_to_cart_get, 'divi-bodyshop-woocommerce', 'Successfully added to cart Text for Pop Up' );
    $atc_pupup_continue_shopping_btn_text = apply_filters( 'wpml_translate_single_string', $atc_pupup_continue_shopping_btn_text_get, 'divi-bodyshop-woocommerce', 'Continue Shopping Button Text for Pop Up' );
    $atc_pupup_continue_shopping_btn_url = apply_filters( 'wpml_translate_single_string', $atc_pupup_continue_shopping_btn_url_get, 'divi-bodyshop-woocommerce', 'Continue Shopping Button URL for Pop Up' );

    if ($atc_pupup_continue_shopping_btn_url == "#" || $atc_pupup_continue_shopping_btn_url == "") {
        $preventdefault_css = "preventdefault";
        $continuejs = "return false;";
    } else {
        $preventdefault_css = "";
        $continuejs = "location.href='" . $atc_pupup_continue_shopping_btn_url . "'";
    }

    $check_minicart_remove_option= get_bodycommerce_option( 'minicart_remove_option' );
    $minicart_remove_option_text_get= get_bodycommerce_option( 'minicart_remove_option_text' );

    do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Mini Cart Remove Text', $minicart_remove_option_text_get );
    $minicart_remove_option_text = apply_filters( 'wpml_translate_single_string', $minicart_remove_option_text_get, 'divi-bodyshop-woocommerce', 'Mini Cart Remove Text' );
    $drop_down_mini_cart_total_subtotal = get_bodycommerce_option( 'drop_down_mini_cart_total_subtotal' );

    if ($check_minicart_remove_option == "1") {
        $check_minicart_remove_option_display = $minicart_remove_option_text;
    }
    else {
        $check_minicart_remove_option_display = "&times;";
    }

    ob_start();
    ?>
    <div class="bc-added-modal-container">
<div class="close-modal"></div>
<h4><?php echo esc_html__( $atc_pupup_successfully_added_to_cart, 'divi-bodyshop-woocommerce' ); ?></h4>
    <?php 
    if ($drop_down_mini_cart_total_subtotal == "sub-total") {
        ?>
    <p class="woocommerce-mini-cart__total total"><strong><?php _e( 'Subtotal', 'woocommerce' ); ?>:</strong> <?php echo WC()->cart->get_cart_subtotal(); ?></p>
    <?php 
    } else {
        ?>
    <p class="woocommerce-mini-cart__total total"><strong><?php _e( 'Total', 'woocommerce' ); ?>:</strong> <?php echo WC()->cart->get_total(); ?></p>
    <?php 
    }
    ?>
    <hr>
    <?php 
    do_action( 'woocommerce_before_mini_cart' );
    if ( ! WC()->cart->is_empty() ) : 
    ?>
<ul class="woocommerce-mini-cart cart_list product_list_widget">
    <?php
        do_action( 'woocommerce_before_mini_cart_contents' );
    foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
      $_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
      $product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

      if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
        $product_name      = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );
        $thumbnail         = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
        $product_price     = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
        $product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
                ?>
  <li class="woocommerce-mini-cart-item <?php echo esc_attr( apply_filters( 'woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key ) ); ?>">
        <?php
          echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
            '<a href="%s" class="remove-mini-cart remove remove_from_cart_button" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s">%s</a>',
            esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
            __( 'Remove this item', 'woocommerce' ),
            esc_attr( $product_id ),
            esc_attr( $cart_item_key ),
            esc_attr( $_product->get_sku() ),
                    $check_minicart_remove_option_display
                    ), $cart_item_key );

                if ( empty( $product_permalink ) ) : 
            echo $thumbnail . $product_name;
        else : 
                ?>
    <span onclick="location.href='<?php echo esc_url( $product_permalink ); ?>'" data-url="<?php echo esc_url( $product_permalink ); ?>" class="cart-link-span">
      <?php echo $thumbnail . $product_name; ?>
    </span>
            <?php 
                endif; 

                echo wc_get_formatted_cart_item_data( $cart_item );
        echo apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="quantity">' . sprintf( '%s &times; %s', $cart_item['quantity'], $product_price ) . '</span>', $cart_item, $cart_item_key ); 
                ?>
  </li>
        <?php
            }
        }
        do_action( 'woocommerce_mini_cart_contents' );
        ?>
</ul>
    <?php 
        do_action( 'woocommerce_widget_shopping_cart_before_buttons' ); 
        ?>
<hr>
<div class="bc-added-buttons">
        <div class="continueshopping <?php _e($preventdefault_css,'divi_bodycommerce'); ?> <?php _e($atc_pupup_continue_shopping_btn_text,'divi_bodycommerce'); ?>">
            <a onclick="<?php _e($continuejs,'divi_bodycommerce'); ?>" data-url="<?php _e($atc_pupup_continue_shopping_btn_url,'divi_bodycommerce'); ?>" class="cart-link-span et_pb_button button"><?php _e($atc_pupup_continue_shopping_btn_text,'divi_bodycommerce'); ?></a>
        </div>
        <div class="checkoutbuttons">
    <p class="bc-added-buttons_checkout buttons"><?php do_action( 'bodycommerce_minicart_button_text' ); ?></p>
        </div>
    </div>
    <?php 
    else : 
    ?>
<p class="woocommerce-mini-cart__empty-message"><?php _e( 'No products in the cart.', 'woocommerce' ); ?></p>
    <?php 
    endif; 
    do_action( 'woocommerce_after_mini_cart' ); 
    ?>
  </div>
    <?php
  $fragments['.bc-added-modal-container'] = ob_get_clean();
    return $fragments;
}


add_action('wp_footer', 'db_woo_modal_pop_up_add_to_cart_html');
function db_woo_modal_pop_up_add_to_cart_html(){
?>
<div id="bodycommerce_added_to_cart_popup">
<div class="bc-added-modal-container">
<div class="close-modal"></div>
</div>
</div>
<script>
jQuery(document).ready(function( $ ) {$(document).on('click', '.close-modal', function (e) {e.preventDefault();$("#bodycommerce_added_to_cart_popup").removeClass("active");});$(document).on('click', '.continueshopping.preventdefault .button', function (e) {e.preventDefault();$("#bodycommerce_added_to_cart_popup").removeClass("active");});});
</script>
<?php
}

add_action('wp_head', 'db_woo_modal_pop_up_add_to_cart_css');
function db_woo_modal_pop_up_add_to_cart_css(){

    $mini_cart_popup_close_size = get_bodycommerce_option( 'mini_cart_popup_close_size' );
    $mini_cart_popup_close_color = get_bodycommerce_option( 'mini_cart_popup_close_color' );
    $mini_cart_popup_overlay_color = get_bodycommerce_option( 'mini_cart_popup_overlay_color' );

        // Subtotal
        $check_mini_cart_subtotal_text_size = (int)get_bodycommerce_option( 'mini_cart_subtotal_text_size', 20 );
        $check_mini_cart_subtotal_text_colour = get_bodycommerce_option( 'mini_cart_subtotal_text_color');
        // Product
        $check_mini_cart_product_title_text_size = (int)get_bodycommerce_option( 'mini_cart_product_title_text_size', 14 );
        $check_mini_cart_product_title_text_colour = get_bodycommerce_option( 'mini_cart_product_title_text_color');
        $check_mini_cart_product_image_size = (int)get_bodycommerce_option( 'mini_cart_product_image_size',32 );
    
        // Quntity & Price
        $check_mini_cart_product_quantity_price_text_size = (int)get_bodycommerce_option( 'mini_cart_product_quantity_price_text_size',14 );
        $check_mini_cart_product_quantity_price_text_colour = get_bodycommerce_option( 'mini_cart_product_quantity_price_text_color');
        // Remove
        $check_mini_cart_remove_text_size = (int)get_bodycommerce_option( 'mini_cart_remove_text_size', 14); // text size
        $check_mini_cart_remove_text_colour = get_bodycommerce_option( 'mini_cart_remove_text_color'); // color
        $mini_cart_remove_icon_color = get_bodycommerce_option( 'mini_cart_remove_icon_color'); // background color
        $mini_cart_remove_icon_color_hover = get_bodycommerce_option( 'mini_cart_remove_icon_color_hover'); // color on hover
        $mini_cart_remove_icon_bg_color_hover = get_bodycommerce_option( 'mini_cart_remove_icon_bg_color_hover'); // bg on hover

  $css_ajax_pop_up_class = 'pop_up_atc';
  $css_ajax_pop_up =  sprintf('<style id="bodyshop-%s"> ', $css_ajax_pop_up_class);
  $css_ajax_pop_up .= '#bodycommerce_added_to_cart_popup {display: none;}
  .woocommerce ul.cart_list li, .woocommerce ul.product_list_widget li {
    position: relative;
}
#bodycommerce_added_to_cart_popup.active {
  display: block;
  position: fixed;
  z-index: 999999999999999999;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: '.$mini_cart_popup_overlay_color.';
  color: #fff;
  display: flex;
  justify-content: center;
  align-items: center;
}
.bc-added-modal-container {
  background-color: #fff;
    width: 80%;
    max-width: 800px;
    margin: auto;
    padding: 30px;
    color: #000;
    position: relative;
    overflow-y: auto;
    max-height: 80vh;
}
#bodycommerce_added_to_cart_popup .close-modal {
  position: absolute;
  right: 0;
  top: 0;
}
#bodycommerce_added_to_cart_popup .close-modal::after {
  font-family: "ETmodules" !important;
    font-weight: normal;
    font-style: normal;
    font-variant: normal;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    line-height: 1;
    text-transform: none;
    speak: none;
    font-size: '.$mini_cart_popup_close_size.'px;
    color: '.$mini_cart_popup_close_color.';
    z-index: 9999999;
    cursor: pointer;
    content: "\4d";
}
#bodycommerce_added_to_cart_popup .jde_hint {
  display: none;
}
.bc-added-buttons {display: flex;}
.bc-added-buttons > div {flex: 1;}
.bc-added-buttons_checkout {text-align: right;}

@media all and (max-width: 980px) {
  .bc-added-buttons {
      display: block;
  }
  .bc-added-buttons > div {
        text-align: center;
    }
    .bc-added-buttons_checkout {
        text-align: center;
    }
}

.woocommerce-mini-cart-item.mini_cart_item .remove-mini-cart, 
.bodycommerce-minicart .woocommerce-mini-cart.cart_list li .remove-mini-cart {
   position: absolute; 
   font-size:'.$check_mini_cart_remove_text_size.'px !important; 
   color:'.$check_mini_cart_remove_text_colour.' !important;
   background-color: '.$mini_cart_remove_icon_color.'!important;
   width: '.$check_mini_cart_remove_text_size.'px !important;
  }


  .woocommerce-mini-cart-item.mini_cart_item .remove-mini-cart:hover, 
.bodycommerce-minicart .woocommerce-mini-cart.cart_list li .remove-mini-cart:hover {
  color:'.$mini_cart_remove_icon_color_hover.' !important;
  background-color: '.$mini_cart_remove_icon_bg_color_hover.'!important;
}

@media all and (max-width: 450px) {
    .bc-added-buttons .et_pb_button, .bc-added-buttons .button {
      display: block !important;
    }
}

</style>';

    $css_ajax_pop_up .= '</style>';
    //minify it
    $css_ajax_pop_up_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_ajax_pop_up );
    echo $css_ajax_pop_up_min;
}

}