<?php
if ( ! defined( 'ABSPATH' ) ) exit;

function divi_bodycommerce_check_other_options() {

  
    if(class_exists('TitanFramework')){
    
        // Remove add to cart message
        $check_other_settings_remove_add_to_cart_message = get_bodycommerce_option( 'other_settings_remove_add_to_cart_message' );

        if ($check_other_settings_remove_add_to_cart_message == "1") {
            add_filter( 'wc_add_to_cart_message_html', '__return_null' );
        }
    
        // Change the add to cart notice text
        $check_other_settings_add_to_cart_message_text = get_bodycommerce_option( 'other_settings_add_to_cart_message_text' );
        $check_other_settings_add_to_cart_message_button_text = get_bodycommerce_option( 'other_settings_add_to_cart_message_button_text' );
    
        if ($check_other_settings_add_to_cart_message_text != ""){
            add_filter( 'wc_add_to_cart_message_html', 'divi_bodycommerce_change_add_to_cart_message_text' );
            function divi_bodycommerce_change_add_to_cart_message_text($products) {
                $check_other_settings_add_to_cart_message_text = get_bodycommerce_option( 'other_settings_add_to_cart_message_text' );
                $check_other_settings_add_to_cart_message_button_text = get_bodycommerce_option( 'other_settings_add_to_cart_message_button_text' );
                $check_other_settings_add_to_cart_message_text_display = $check_other_settings_add_to_cart_message_text;

                if ($check_other_settings_add_to_cart_message_button_text == "") {
                    $check_other_settings_add_to_cart_message_button_text_display = "View basket";
                } else {
                    $check_other_settings_add_to_cart_message_button_text_display = $check_other_settings_add_to_cart_message_button_text;
                }

                global $woocommerce;
                $return_to  = get_permalink(wc_get_page_id('cart'));
                $message    = sprintf('<a href="%s" class="button wc-forwards">%s</a> %s', $return_to, __($check_other_settings_add_to_cart_message_button_text_display, 'woocommerce'), __($check_other_settings_add_to_cart_message_text_display, 'woocommerce') );
                return $message;
            }
        }
    
        // PAGINCATION TOP
        $check_other_settings_pagination_top = get_bodycommerce_option( 'other_settings_pagination_top' );
        if ($check_other_settings_pagination_top == "1"){
            if ( function_exists( 'bodycommerce_pagination' ) ) {
                add_action( 'woocommerce_before_shop_loop', 'bodycommerce_pagination', 10 );
                remove_action( 'woocommerce_after_shop_loop', 'bodycommerce_pagination', 10 );  
            } else {
                add_action( 'woocommerce_before_shop_loop', 'woocommerce_pagination', 10 );
                remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 10 );  
            }
        }     
    // Password Strength
    $check_other_settings_user_password = get_bodycommerce_option( 'other_settings_user_password' );
    
    if ($check_other_settings_user_password == "1" ){
      function bodycommerce_user_remove_password_strength() {
        if ( wp_script_is( 'wc-password-strength-meter', 'enqueued' ) ) {
          wp_dequeue_script( 'wc-password-strength-meter' );
        }
      }
      add_action( 'wp_print_scripts', 'bodycommerce_user_remove_password_strength', 100 );
    }
    else {

    }
    
    // Short desc title
    $check_other_settings_short_desc_title = get_bodycommerce_option( 'other_settings_short_desc_title' );
    if ($check_other_settings_short_desc_title != "") {
      function bodycommerce_filter_short_description( $desc ){
        global $product;
        if ( is_product() ){
          $check_other_settings_short_desc_title = get_bodycommerce_option( 'other_settings_short_desc_title' );
          if ( is_single() ) {
            $new_desc = '<h3 class="bc-short-desc-title">'.$check_other_settings_short_desc_title.'</h3>';
            $new_desc .= $desc;
            return $new_desc;
          }
        }
      }
      add_filter( 'woocommerce_short_description', 'bodycommerce_filter_short_description' );
    }
    
    // Breadcrumb separator
    $check_other_settings_breadcrumb_separator = get_bodycommerce_option( 'other_settings_breadcrumb_separator' );
    
    if ($check_other_settings_breadcrumb_separator != "") {
      add_filter( 'woocommerce_breadcrumb_defaults', 'bodycommerce_woocommerce_breadcrumbs_separator' );
      function bodycommerce_woocommerce_breadcrumbs_separator() {
        $check_other_settings_breadcrumb_separator = get_bodycommerce_option( 'other_settings_breadcrumb_separator' );
        return array(
          'delimiter'   => ' '.$check_other_settings_breadcrumb_separator.' ',
          'wrap_before' => '<div class="bc-breadcrumb-wrap"><nav class="bc-woocommerce-breadcrumb" itemprop="breadcrumb">',
          'wrap_after'  => '</nav></div>',
          'before'      => '',
          'after'       => '',
          'home'        => _x( 'Home', 'breadcrumb', 'woocommerce' ),
        );
      }
    }
    
    // REMOVE SALES Badge
    $check_other_settings_remove_sale_badge = get_bodycommerce_option( 'other_settings_remove_sale_badge' );
    if ($check_other_settings_remove_sale_badge == "1") {
      remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
      remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
    }
    
    // SALES BADGE Percentage
    $check_other_settings_percentage_sales_enable = get_bodycommerce_option( 'other_settings_percentage_sales_enable' );
    if ($check_other_settings_percentage_sales_enable == "1") {
      // FIX FOR SITES ALREADY USING SALES BADGE - WILL FILTER OUT
      add_filter('woocommerce_sale_flash', 'bodycommerce_woocommerce_savings_on_sales_flash');
      function bodycommerce_woocommerce_savings_on_sales_flash() {
        $check_other_settings_percentage_sales_before_get = get_bodycommerce_option( 'other_settings_percentage_sales_before' );
        $check_other_settings_percentage_sales_after_get = get_bodycommerce_option( 'other_settings_percentage_sales_after' );
        do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Sale Percentage Before', $check_other_settings_percentage_sales_before_get );
        do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Sale Percentage After', $check_other_settings_percentage_sales_after_get );
        $check_other_settings_percentage_sales_before = apply_filters( 'wpml_translate_single_string', $check_other_settings_percentage_sales_before_get, 'divi-bodyshop-woocommerce', 'Sale Percentage Before' );
        $check_other_settings_percentage_sales_after = apply_filters( 'wpml_translate_single_string', $check_other_settings_percentage_sales_after_get, 'divi-bodyshop-woocommerce', 'Sale Percentage After' );
        $check_other_settings_sale_badge_percentage_sign = get_bodycommerce_option( 'other_settings_sale_badge_percentage_sign' );
        
        global $post, $product;
        if ( ! $product->is_in_stock() ) return;
        if( $product->is_type( 'grouped' ) ){
          return;
        }
        
        if ( '' === $product->get_price() || 0 == $product->get_price() ) {

        } else {
          
          $sale_price = get_post_meta( $product->get_id(), '_price', true);
          $regular_price = get_post_meta( $product->get_id(), '_regular_price', true);
          if (empty($regular_price) && $product->is_type( 'variable' ) ){ //then this is a variable product
            $available_variations = $product->get_available_variations();
            $variation_id=$available_variations[0]['variation_id'];
            if ($variation_id !== "") { 
              $variation= new WC_Product_Variation( $variation_id );
              $regular_price = $variation->get_regular_price();
              $sale_price = $variation->get_sale_price();
            }
          }
          
          if (is_numeric($regular_price) && is_numeric($sale_price)) {
            $difference = $regular_price - $sale_price;
            $division = $difference / $regular_price;
            $savings = round ($division * 100);
            if ($savings > "0") {
              if ($check_other_settings_sale_badge_percentage_sign == "1") {
                $sale_flash = '<span class="onsale">'.$check_other_settings_percentage_sales_before.' ' . $savings . '% '.$check_other_settings_percentage_sales_after.'</span>';
              } else {
                $sale_flash = '<span class="onsale">'.$check_other_settings_percentage_sales_before.''.$check_other_settings_percentage_sales_after.'</span>';
              }
              return $sale_flash;
            }
          }
        }
      }
      // FIX FOR SITES ALREADY USING SALES BADGE - WILL FILTER OUT
      
      // Sales badge css
      function bodycommerce_sale_badge_css()  {
        $check_BodyCommerce_sale_badge_design = get_bodycommerce_option( 'BodyCommerce_sale_badge_design' );
        $path = '/lib/sale-badge-styles/'.$check_BodyCommerce_sale_badge_design.'.css.php';
        include(DE_DB_WOO_PATH . $path);
        $css_button_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_button );
        echo $css_button_min;
      }
      add_action( 'wp_head', 'bodycommerce_sale_badge_css', 15 );
    
    }
    
    $check_other_settings_percentage_sales_enable_new = get_bodycommerce_option( 'other_settings_percentage_sales_enable_new' );
    $check_other_settings_percentage_sales_enable_free = get_bodycommerce_option( 'other_settings_percentage_sales_enable_free' );
    $other_settings_percentage_sales_enable_ofs = get_bodycommerce_option( 'other_settings_percentage_sales_enable_ofs' );
    
    if ($check_other_settings_percentage_sales_enable_new == "1") {
      function bodycommerce_new_badge_css()  {
        $check_BodyCommerce_sale_badge_design_new = get_bodycommerce_option( 'BodyCommerce_sale_badge_design_new' );
        $path_new = '/lib/new-badge-styles/'.$check_BodyCommerce_sale_badge_design_new.'.css.php';
        include(DE_DB_WOO_PATH . $path_new);
        $css_button_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_button );
        echo $css_button_min;
      }
      add_action( 'wp_head', 'bodycommerce_new_badge_css', 15 );
    }
    
    if ($check_other_settings_percentage_sales_enable_free == "1") {
      function bodycommerce_free_badge_css()  {
        $check_BodyCommerce_sale_badge_design_free = get_bodycommerce_option( 'BodyCommerce_sale_badge_design_free' );
        $path_free = '/lib/free-badge-styles/'.$check_BodyCommerce_sale_badge_design_free.'.css.php';
        include(DE_DB_WOO_PATH . $path_free);
        $css_button_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_button );
        echo $css_button_min;
      }
      add_action( 'wp_head', 'bodycommerce_free_badge_css', 15 );
    }
    
    if ($other_settings_percentage_sales_enable_ofs == "1") {
      function bodycommerce_ofs_badge_css()  {
        $BodyCommerce_sale_badge_design_ofs = get_bodycommerce_option( 'BodyCommerce_sale_badge_design_ofs' );
        $path_free = '/lib/ofs-badge-styles/'.$BodyCommerce_sale_badge_design_ofs.'.css.php';
        include(DE_DB_WOO_PATH . $path_free);
        $css_button_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_button );
        echo $css_button_min;
      }
      add_action( 'wp_head', 'bodycommerce_ofs_badge_css', 15 );
    }
    // SALES BADGE PERCENTAGE
    
    
    // Default Image placeholder
    $check_other_settings_default_product_image= get_bodycommerce_option( 'other_settings_default_product_image' );
    if ($check_other_settings_default_product_image != "") {
      $imageSrc = $check_other_settings_default_product_image; // For the default value
      if ( is_numeric( $check_other_settings_default_product_image ) ) {
        add_filter( 'woocommerce_placeholder_img_src', 'bodycommerce_custom_woocommerce_placeholder', 10 );
        function bodycommerce_custom_woocommerce_placeholder( $image_url ) {
          $check_other_settings_default_product_image= get_bodycommerce_option( 'other_settings_default_product_image' );
          $imageAttachment = wp_get_attachment_image_src( $check_other_settings_default_product_image , $size = 'full', $icon = false );
          if (is_array($imageAttachment)) {
            $imageSrc = $imageAttachment[0];
          } else {
            $imageSrc = $imageAttachment;
          }
          $image_url = $imageSrc;  // change this to the URL to your custom placeholder
          return $image_url;
        }
      }
    }
    
    
    // better display of variations
    $other_settings_better_variation= get_bodycommerce_option( 'other_settings_better_variation' );
    if ( "1" == $other_settings_better_variation) {
      add_filter( 'woocommerce_product_variation_title_include_attributes', '__return_false' );
      add_filter( 'woocommerce_is_attribute_in_product_name', '__return_false' );
      function better_variation_css() {

        $check_mini_cart_product_image_size = (int)get_bodycommerce_option( 'mini_cart_product_image_size',32 );
  
        $image_width_margin = $check_mini_cart_product_image_size + 10;
  
        if ($image_width_margin == '') {
          $image_width_margin = '42';
        }
  
        $styles = '
        .woocommerce ul.cart_list li dl, .woocommerce ul.product_list_widget li dl {
          padding-left: 0;
          border-left: none;
          padding-bottom: 10px;
          padding-top: 10px;
        }
        .woocommerce ul.cart_list li dl dd, .woocommerce ul.product_list_widget li dl dd {
          padding: 0;
          margin: 0;
        }
        .woocommerce-mini-cart-item .item-img, .woocommerce-mini-cart-item .item-contents {
          float: left;
        }
        body.woocommerce ul.cart_list li img, body.woocommerce ul.product_list_widget li img {
          float: left;
          margin-left: 0;
          margin-right: 10px;
          width: 32px!important
        }
        .woocommerce-mini-cart-item .item-upper {
          position: relative;
        }
        .woocommerce-mini-cart-item .item-contents {
          width: calc(100% - '.$image_width_margin.'px);
        }
        .woocommerce-mini-cart-item .item-name {
          text-align: left;
          display: block;
        }
        body .bodycommerce-minicart .woocommerce-mini-cart-item .cart-item-delete {
          top: 0 !important;
          position: absolute !important;
          right: 0;
        }
        .bodycommerce-minicart .woocommerce-mini-cart-item.mini_cart_item a.remove-mini-cart.remove {
          top: 0 !important;
        }
        .bodycommerce-minicart,.bodycommerce-minicart .woocommerce-mini-cart.cart_list li {
          text-align: left;
        }
        ';

        echo '<style>'.$styles.'</style>';


      }
      add_action( 'wp_head', 'better_variation_css', 15 );  

    }
    
    // only one purchase
    $check_other_settings_buy_one_item_only = get_bodycommerce_option( 'other_settings_buy_one_item_only' );
    if ($check_other_settings_buy_one_item_only == "1") {
      add_filter( 'woocommerce_add_cart_item_data', 'bodycommerce_allow_one_item_only' );
      function bodycommerce_allow_one_item_only( $cart_item_data ) {
        global $woocommerce;
        $woocommerce->cart->empty_cart();
        return $cart_item_data;
      }
    }
    
    
    // price for logged in users only
    $check_other_settings_price_logged_in = get_bodycommerce_option( 'other_settings_price_logged_in' );
    
    if ($check_other_settings_price_logged_in == "1") {
      add_filter('woocommerce_get_price_html','bodycommerce_members_only_price');
      function bodycommerce_members_only_price($price){
        $other_settings_price_logged_in_custom_message = get_bodycommerce_option( 'other_settings_price_logged_in_custom_message' );
        if(is_user_logged_in() ){
          return $price;
        } else {
          if ($other_settings_price_logged_in_custom_message == "") {
            return '<a href="' .get_permalink(wc_get_page_id('myaccount')). '">'.esc_html__( 'Login', 'divi-bodyshop-woocommerce' ).'</a> or <a href="'.site_url('/wp-login.php?action=register&redirect_to=' . get_permalink()).'">'.esc_html__( 'Register', 'divi-bodyshop-woocommerce' ).'</a> '.esc_html__( 'to view price!', 'divi-bodyshop-woocommerce' ).'';
          } else {
            // replace href=\" with href="
            $other_settings_price_logged_in_custom_message = str_replace('href=\"', 'href="', $other_settings_price_logged_in_custom_message);
            // replace /\ with /
            $other_settings_price_logged_in_custom_message = str_replace('/\"', '/"', $other_settings_price_logged_in_custom_message);
            
            return $other_settings_price_logged_in_custom_message;
          }
        }
      }
    } else {

    }
    
    // atc button for logged in users only
    $other_settings_atc_button_logged_in = get_bodycommerce_option( 'other_settings_atc_button_logged_in' );
    if ($other_settings_atc_button_logged_in == "1") {
      add_action( 'wp_head', 'bodycommerce_hide_add_cart_not_logged_in' );
      function bodycommerce_hide_add_cart_not_logged_in() {
        if ( ! is_user_logged_in() ) {
          ?>
          <style>.button.add_to_cart_button, .et_pb_db_atc .button, .et_pb_wc_add_to_cart .button, .single_add_to_cart_button  {display: none !important;}.logged-in .button.add_to_cart_button, .logged-in .et_pb_db_atc .button, .logged-in .et_pb_wc_add_to_cart .button, .logged-in .single_add_to_cart_button  {display: none !important;}</style>
          <?php
        }
      }
    } else {

    }


// archive sorting label text
function bodycommerce_sorting_label_text( $orderby ) {

$check_other_settings_sorting_label_default_get = get_bodycommerce_option( 'other_settings_sorting_label_default', __('Default sorting', 'woocommerce') );
$check_other_settings_sorting_label_popularity_get = get_bodycommerce_option( 'other_settings_sorting_label_popularity', __('Sort by popularity', 'woocommerce') );
$check_other_settings_sorting_label_ave_rating_get = get_bodycommerce_option( 'other_settings_sorting_label_ave_rating', __('Sort by average rating', 'woocommerce') );
$check_other_settings_sorting_label_newness_get = get_bodycommerce_option( 'other_settings_sorting_label_newness', __('Sort by most recent', 'woocommerce') );
$check_other_settings_sorting_label_low_high_get = get_bodycommerce_option( 'other_settings_sorting_label_low_high', __('Sort by price: low to high', 'woocommerce') );
$check_other_settings_sorting_label_high_low_get = get_bodycommerce_option( 'other_settings_sorting_label_high_low', __('Sort by price: high to low', 'woocommerce') );

do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Sorting - Default', $check_other_settings_sorting_label_default_get );
$check_other_settings_sorting_label_default = apply_filters( 'wpml_translate_single_string', $check_other_settings_sorting_label_default_get, 'divi-bodyshop-woocommerce', 'Sorting - Default' );
do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Sorting - Popularity', $check_other_settings_sorting_label_popularity_get );
$check_other_settings_sorting_label_popularity = apply_filters( 'wpml_translate_single_string', $check_other_settings_sorting_label_popularity_get, 'divi-bodyshop-woocommerce', 'Sorting - Popularity' );
do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Sorting - Rating', $check_other_settings_sorting_label_ave_rating_get );
$check_other_settings_sorting_label_ave_rating = apply_filters( 'wpml_translate_single_string', $check_other_settings_sorting_label_ave_rating_get, 'divi-bodyshop-woocommerce', 'Sorting - Rating' );
do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Sorting - Newness', $check_other_settings_sorting_label_newness_get );
$check_other_settings_sorting_label_newness = apply_filters( 'wpml_translate_single_string', $check_other_settings_sorting_label_newness_get, 'divi-bodyshop-woocommerce', 'Sorting - Newness' );
do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Sorting - Price Low High', $check_other_settings_sorting_label_low_high_get );
$check_other_settings_sorting_label_low_high = apply_filters( 'wpml_translate_single_string', $check_other_settings_sorting_label_low_high_get, 'divi-bodyshop-woocommerce', 'Sorting - Price Low High' );
do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Sorting - Price High Low', $check_other_settings_sorting_label_high_low_get );
$check_other_settings_sorting_label_high_low = apply_filters( 'wpml_translate_single_string', $check_other_settings_sorting_label_high_low_get, 'divi-bodyshop-woocommerce', 'Sorting - Price High Low' );

	$orderby["menu_order"] = __($check_other_settings_sorting_label_default, 'woocommerce');
  $orderby["popularity"] = __($check_other_settings_sorting_label_popularity, 'woocommerce');
  $orderby["rating"] = __($check_other_settings_sorting_label_ave_rating, 'woocommerce');
  $orderby["date"] = __($check_other_settings_sorting_label_newness, 'woocommerce');
  $orderby["price"] = __($check_other_settings_sorting_label_low_high, 'woocommerce');
  $orderby["price-desc"] = __($check_other_settings_sorting_label_high_low, 'woocommerce');
	return $orderby;
}
add_filter( "woocommerce_catalog_orderby", "bodycommerce_sorting_label_text", 20 );

/*function bodycommerce_results_count_text( ): array
{
    $result_count_single_text_get = get_bodycommerce_option( 'result_count_single_text', __( 'Showing the single result', 'woocommerce' ));
    $result_count_all_text_get = get_bodycommerce_option( 'result_count_all_text', __( 'Showing all %d result', 'woocommerce' ));
    $result_count_pagination_text_get = get_bodycommerce_option( 'result_count_pagination_text', __( 'Showing %1$d&ndash;%2$d of %3$d result', 'woocommerce' ));

    do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Results count - Single', $result_count_single_text_get );
    $check_other_settings_result_count['single_text'] = apply_filters( 'wpml_translate_single_string', $result_count_single_text_get, 'divi-bodyshop-woocommerce', 'Results count - Single' );
    do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Results count - All text', $result_count_all_text_get );
    $check_other_settings_result_count['all_text'] = apply_filters( 'wpml_translate_single_string', $result_count_all_text_get, 'divi-bodyshop-woocommerce', 'Results count - All text' );
    do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Results count - Pagination text', $result_count_pagination_text_get );
    $check_other_settings_result_count['pagination_text'] = apply_filters( 'wpml_translate_single_string', $result_count_pagination_text_get, 'divi-bodyshop-woocommerce', 'Results count - Pagination text' );
    return $check_other_settings_result_count;
}*/

/*
// product tabs order

add_filter( 'woocommerce_product_tabs', 'bodycommerce_remove_product_tabs', 98 );
function bodycommerce_remove_product_tabs( $tabs ) {
include(DE_DB_WOO_PATH . '/titan-framework/titan-framework-embedder.php');
$titan = TitanFramework::getInstance( 'divi-bodyshop-woo' );
$get_other_settings_tabs_order = get_bodycomMerce_option( 'other_settings_tabs_order' );


if (in_array("description", $get_other_settings_tabs_order)) {
}else {
unset( $tabs['description'] );
}

if (in_array("reviews", $get_other_settings_tabs_order)) {
}else {
unset( $tabs['reviews'] );
}

if (in_array("additional_information", $get_other_settings_tabs_order)) {
}else {
unset( $tabs['additional_information'] );
}



    return $tabs;

}

// product tabs order

add_filter( 'woocommerce_product_tabs', 'bodycommerce_reorder_product_tabs', 98 );
function bodycommerce_reorder_product_tabs( $tabs ) {


  include(DE_DB_WOO_PATH . '/titan-framework/titan-framework-embedder.php');
  $titan = TitanFramework::getInstance( 'divi-bodyshop-woo' );
  $get_other_settings_tabs_order = get_bodycommerce_option( 'other_settings_tabs_order' );

if (sizeof($get_other_settings_tabs_order) == 3) {
$tabs[$get_other_settings_tabs_order[0]]['priority'] = 5;
$tabs[$get_other_settings_tabs_order[1]]['priority'] = 10;
$tabs[$get_other_settings_tabs_order[2]]['priority'] = 15;
}

if (sizeof($get_other_settings_tabs_order) == 2) {
$tabs[$get_other_settings_tabs_order[0]]['priority'] = 5;
$tabs[$get_other_settings_tabs_order[1]]['priority'] = 10;
}

if (sizeof($get_other_settings_tabs_order) == 1) {
$tabs[$get_other_settings_tabs_order[0]]['priority'] = 5;
}

return $tabs;
}
*/
// product under image - archive

$get_other_settings_archive_desc_under_imager = get_bodycommerce_option( 'other_settings_archive_desc_under_image' );

if ($get_other_settings_archive_desc_under_imager == "1") {
add_action('woocommerce_after_shop_loop_item_title','woocommerce_template_single_excerpt', 5);
}


// Add custom checkbox to checkout page

// $get_other_settings_checkout_custom_check_enable = get_bodycommerce_option( 'other_settings_checkout_custom_check_enable' );

// if ($get_other_settings_checkout_custom_check_enable == "1"){



// add_action('woocommerce_after_order_notes', 'bodycommerce_checkout_field');
// function bodycommerce_checkout_field( $checkout ) {
//   $get_other_settings_checkout_custom_check_title = get_bodycommerce_option( 'other_settings_checkout_custom_check_title' );
//   $get_other_settings_checkout_custom_check_label = get_bodycommerce_option( 'other_settings_checkout_custom_check_label' );

//    echo '<div id="my-new-field"><h3>'.__($get_other_settings_checkout_custom_check_title).'</h3>';
//    woocommerce_form_field( 'bodycommerce_checkbox', array(
//        'type'          => 'checkbox',
//        'class'         => array('input-checkbox'),
//        'label'         => __($get_other_settings_checkout_custom_check_label),
//        'required'  => true,
//        ), $checkout->get_value( 'bodycommerce_checkbox' ));
//    echo '</div>';
// }



// add_action('woocommerce_checkout_process', 'bodycommerce_checkout_field_process');
// function bodycommerce_checkout_field_process() {
//   $get_other_settings_checkout_custom_check_error = get_bodycommerce_option( 'other_settings_checkout_custom_check_error' );
//    global $woocommerce;
//    if (!$_POST['bodycommerce_checkbox'])
//         $woocommerce->add_notice( __($get_other_settings_checkout_custom_check_error) );
// }
// add_action('woocommerce_checkout_update_order_meta', 'bodycommerce_checkout_field_update_order_meta');
// function bodycommerce_checkout_field_update_order_meta( $order_id ) {
//   $get_other_settings_checkout_custom_check_title = get_bodycommerce_option( 'other_settings_checkout_custom_check_title' );
//    if ($_POST['bodycommerce_checkbox']) update_post_meta( $order_id, $get_other_settings_checkout_custom_check_title, esc_attr($_POST['bodycommerce_checkbox']));
// }
// }


// Change default country selected at checkout
$get_other_settings_checkout_default_country = get_bodycommerce_option( 'other_settings_checkout_default_country' );
if ($get_other_settings_checkout_default_country == "" || $get_other_settings_checkout_default_country == "select") {

} else {
    add_filter( 'default_checkout_billing_country', 'bodycommerce_change_default_checkout_country' );
    function bodycommerce_change_default_checkout_country() {
      $get_other_settings_checkout_default_country = get_bodycommerce_option( 'other_settings_checkout_default_country' );
      return ''.$get_other_settings_checkout_default_country.''; // country code
    }
}

// remove breadcrumbs

$get_other_settings_breadcrumb_remove = get_bodycommerce_option( 'other_settings_breadcrumb_remove' );

if ($get_other_settings_breadcrumb_remove == "1" ){
  add_action( 'init', 'bodycommerce_remove_breadcrumbs' );
  function bodycommerce_remove_breadcrumbs() {
      remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
  }
}


// bypass logout "are you sure"
function bodycommerce_bypass_logout_confirmation() {
    global $wp;

    if ( isset( $wp->query_vars['customer-logout'] ) ) {
        wp_redirect( str_replace( '&amp;', '&', wp_logout_url( wc_get_page_permalink( 'myaccount' ) ) ) );
        exit;
    }
}

add_action( 'template_redirect', 'bodycommerce_bypass_logout_confirmation' );



if (!current_user_can('edit_posts')) {
	add_filter('show_admin_bar', '__return_false');
}


// archive product button
$get_other_settings_button_below_product = get_bodycommerce_option( 'other_settings_button_below_product' );

if ($get_other_settings_button_below_product == ""){}
  else {
     add_action( 'woocommerce_after_shop_loop_item', 'bodycommerce_view_product_button', 10);
    function bodycommerce_view_product_button() {
        $get_other_settings_button_below_product = get_bodycommerce_option( 'other_settings_button_below_product' );

    global $product;
    $link = $product->get_permalink();
    echo do_shortcode('<div class="cat-actions"><a href="'.$link.'" class="button addtocartbutton">'.$get_other_settings_button_below_product.'</a></div>');

    }
  }


$get_product_page_template = get_bodycommerce_option( 'product_page_template' );
if ($get_product_page_template != 0 && $get_product_page_template != "") {
  function divi_bodycommerce_sinlge_product_breadcrumb_remove()  {
  echo "<style id='bodycommerce-single-prodcut'>.woocommerce.single-product #left-area > .woocommerce-breadcrumb {display:none;}</style>";
  }
  add_action( 'wp_head', 'divi_bodycommerce_sinlge_product_breadcrumb_remove', 15 );
}


$product_free_price_name = get_bodycommerce_option( 'product_free_price_name' );
if ($product_free_price_name == "") {
}
else {
  add_filter('woocommerce_get_price_html', 'changeFreePriceNotice', 10, 2);
function changeFreePriceNotice($price, $product) {
$product_free_price_name_get = get_bodycommerce_option( 'product_free_price_name' );

do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Free Product Price Name', $product_free_price_name_get );
$product_free_price_name = apply_filters( 'wpml_translate_single_string', $product_free_price_name_get, 'divi-bodyshop-woocommerce', 'Free Product Price Name' );

		if ( $price == wc_price( 0.00 ) )
		return $product_free_price_name;
	else
		return $price;
}}

//////// Admin Change name and icon

add_action( 'admin_menu', 'rename_woocoomerce_admin_menu', 999 );
 function rename_woocoomerce_admin_menu()
 {

 $get_other_settings_admin_woo_name = get_bodycommerce_option( 'other_settings_admin_woo_name' );

if ($get_other_settings_admin_woo_name != ""){

		 global $menu;
		 // Pinpoint menu item
		 $woo = recursive_array_search_php( 'WooCommerce', $menu );
		 // Validate
		 if( !$woo )
				 return;
		 $menu[$woo][0] = $get_other_settings_admin_woo_name;
   }
   else {
     # code...
   }
 }
 function recursive_array_search_php( $needle, $haystack )
 {
		 foreach( $haystack as $key => $value )
		 {
				 $current_key = $key;
				 if(
						 $needle === $value
						 OR (
								 is_array( $value )
								 && recursive_array_search_php( $needle, $value ) !== false
						 )
				 )
				 {
						 return $current_key;
				 }
		 }
		 return false;

 }

 add_action( 'admin_head', 'replace_woocommerce_dashcons' );
function replace_woocommerce_dashcons() {

  $get_other_settings_admin_woo_icon = get_bodycommerce_option( 'other_settings_admin_woo_icon' );

if ($get_other_settings_admin_woo_icon != ""){
  $content =  sprintf('<style type="text/css">#adminmenu .toplevel_page_woocommerce div.wp-menu-image {background-image: none !important;}#adminmenu .toplevel_page_woocommerce div.wp-menu-image::before {content:"\%s" !important;font-family: dashicons !important;    font-size: 20px;}</style>',$get_other_settings_admin_woo_icon );

echo $content;
}
}

//////// Admin Change name and icon


      $get_other_settings_add_to_basket_quantity_archive = get_bodycommerce_option( 'other_settings_add_to_basket_quantity_archive' );
      if ($get_other_settings_add_to_basket_quantity_archive == "1") {
        function custom_woo_before_shop_link() {
          add_filter('woocommerce_loop_add_to_cart_link', 'custom_woo_loop_add_to_cart_link', 10, 2);
        }
        add_action('woocommerce_before_shop_loop', 'custom_woo_before_shop_link');
      
        function custom_woo_loop_add_to_cart_link($button, $product) {
          if ($product->get_type() == "simple") {
            if ($product->is_purchasable()) {
              ob_start();
              woocommerce_simple_add_to_cart();
              $button = ob_get_clean();
              $replacement = sprintf('data-product_id="%d" data-quantity="1" $1 add_to_cart_button product_type_simple ', $product->get_id());
              $button = preg_replace('/(class="single_add_to_cart_button)/', $replacement, $button);
            }
          }
          return $button;
        }

        // function custom_quantity_field_archive() {

        // $get_other_settings_add_to_basket_quantity_archive = get_bodycommerce_option( 'other_settings_add_to_basket_quantity_archive' );
        
        // if ($get_other_settings_add_to_basket_quantity_archive == "1") {
        //  $product = wc_get_product( get_the_ID() );
        //  if ( ! $product->is_sold_individually() && 'variable' != $product->get_type() && $product->is_purchasable() ) {
        //    woocommerce_quantity_input( array( 'min_value' => 1, 'max_value' => $product->backorders_allowed() ? '' : $product->get_stock_quantity() ) );
        //  }
        // }
        // else {
        //   # code...
        // }
        // }
        // add_action( 'woocommerce_after_shop_loop_item', 'custom_quantity_field_archive', 0, 9 );
      }





$get_other_settings_add_to_basket_archive = get_bodycommerce_option( 'other_settings_add_to_basket_archive' );

if ($get_other_settings_add_to_basket_archive == 1) {
add_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 1 );
}
else{
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 1 );

}


$get_notice_product_added_cart = get_bodycommerce_option( 'notice_product_added_cart' );
if ($get_notice_product_added_cart != "") {

add_filter('wc_add_to_cart_message_html', 'change_add_to_cart_notice', 10, 2);
function change_add_to_cart_notice($message,$products) {
  $get_notice_product_added_cart_get = get_bodycommerce_option( 'notice_product_added_cart' );
  $notice_product_added_cart_btn_get = get_bodycommerce_option( 'notice_product_added_cart_btn' );

  do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Product was successfully added to cart message', $get_notice_product_added_cart_get );
    do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Product was successfully added to cart message button', $notice_product_added_cart_btn_get );
  $get_notice_product_added_cart = apply_filters( 'wpml_translate_single_string', $get_notice_product_added_cart_get, 'divi-bodyshop-woocommerce', 'Product was successfully added to cart message' );
$notice_product_added_cart_btn = apply_filters( 'wpml_translate_single_string', $notice_product_added_cart_btn_get, 'divi-bodyshop-woocommerce', 'Product was successfully added to cart message button' );

  if($notice_product_added_cart_btn == "") {
    $notice_product_added_cart_btn_display = "View Basket";
  }
  else {
    $notice_product_added_cart_btn_display = $notice_product_added_cart_btn;
  }


global $woocommerce;
$return_to  = get_permalink(wc_get_page_id('cart'));
$message    = sprintf('<a href="%s" class="button wc-forward">%s</a> %s', $return_to, esc_html__($notice_product_added_cart_btn_display, 'woocommerce'), esc_html__($get_notice_product_added_cart, 'woocommerce') );
return $message;


}
}

// ajax add to cart notify text


$other_settings_ajax_add_to_cart_text_notify = get_bodycommerce_option( 'other_settings_ajax_add_to_cart_text_notify' );
if ($other_settings_ajax_add_to_cart_text_notify != "") {
  add_action('wp_footer', 'ajax_atc_notify_txt');
  function ajax_atc_notify_txt(){


      $other_settings_ajax_add_to_cart_text_notify_get = get_bodycommerce_option( 'other_settings_ajax_add_to_cart_text_notify' );
      do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Added to Cart Notify Text', $other_settings_ajax_add_to_cart_text_notify_get );
      $other_settings_ajax_add_to_cart_text_notify = apply_filters( 'wpml_translate_single_string', $other_settings_ajax_add_to_cart_text_notify_get, 'divi-bodyshop-woocommerce', 'Added to Cart Notify Text' );

      $other_settings_ajax_add_to_cart_text_notify_time = get_bodycommerce_option( 'other_settings_ajax_add_to_cart_text_notify_time' );
      $ajax_add_to_cart_text_notify_btn_bg_color = get_bodycommerce_option( 'ajax_add_to_cart_text_notify_btn_bg_color' );
      $ajax_add_to_cart_text_notify_btn_text_color = get_bodycommerce_option( 'ajax_add_to_cart_text_notify_btn_text_color' );


    ?>
<input class="db_atc_notify_txt" type="hidden" value="<?php echo esc_html__( $other_settings_ajax_add_to_cart_text_notify, 'divi-bodyshop-woocommerce' ); ?>">
<input class="db_atc_notify_txt_time" type="hidden" value="<?php echo esc_attr__( $other_settings_ajax_add_to_cart_text_notify_time, 'divi-bodyshop-woocommerce' ); ?>">
<input class="db_atc_notify_bg_color" type="hidden" value="<?php echo esc_attr__( $ajax_add_to_cart_text_notify_btn_bg_color, 'divi-bodyshop-woocommerce' ); ?>">
<input class="db_atc_notify_text_color" type="hidden" value="<?php echo esc_attr__( $ajax_add_to_cart_text_notify_btn_text_color, 'divi-bodyshop-woocommerce' ); ?>">
    <?php
  }
}

$other_settings_straight_to_checkout = get_bodycommerce_option( 'other_settings_straight_to_checkout' );
if ($other_settings_straight_to_checkout == "1") {
  add_filter('woocommerce_add_to_cart_redirect', 'bodycommerce_straight_checkout');
  function bodycommerce_straight_checkout() {
   global $woocommerce;
   $checkout_url = wc_get_checkout_url();
   return $checkout_url;
  }
}

$other_settings_disable_product_cart_link = get_bodycommerce_option( 'other_settings_disable_product_cart_link' );
if ($other_settings_disable_product_cart_link == "1") {
  add_filter('woocommerce_cart_item_permalink','__return_false');
}

if (get_bodycommerce_option( 'other_settings_admin_woo_products_name_plural' ) != "") {
  add_filter( 'woocommerce_register_post_type_product', 'custom_post_type_label_woo' );

  function custom_post_type_label_woo( $args ){

    $other_settings_admin_woo_products_name_plural = get_bodycommerce_option( 'other_settings_admin_woo_products_name_plural' );
    $other_settings_admin_woo_products_name_singular = get_bodycommerce_option( 'other_settings_admin_woo_products_name_singular' );


      $labels = array(
          'name'               => __( $other_settings_admin_woo_products_name_plural, 'divi-bodyshop-woocommerce' ),
          'singular_name'      => __( $other_settings_admin_woo_products_name_singular, 'divi-bodyshop-woocommerce' ),
          'menu_name'          => _x( $other_settings_admin_woo_products_name_plural, 'Admin menu name', 'divi-bodyshop-woocommerce' ),
          'add_new'            => __( 'Add '.$other_settings_admin_woo_products_name_singular.'', 'divi-bodyshop-woocommerce' ),
          'add_new_item'       => __( 'Add New '.$other_settings_admin_woo_products_name_singular.'', 'divi-bodyshop-woocommerce' ),
          'edit'               => __( 'Edit  '.$other_settings_admin_woo_products_name_singular.'', 'divi-bodyshop-woocommerce' ),
          'edit_item'          => __( 'Edit  '.$other_settings_admin_woo_products_name_singular.'', 'divi-bodyshop-woocommerce' ),
          'new_item'           => __( 'New  '.$other_settings_admin_woo_products_name_singular.'', 'divi-bodyshop-woocommerce' ),
          'view'               => __( 'View  '.$other_settings_admin_woo_products_name_singular.'', 'divi-bodyshop-woocommerce' ),
          'view_item'          => __( 'View  '.$other_settings_admin_woo_products_name_singular.'', 'divi-bodyshop-woocommerce' ),
          'search_items'       => __( 'Search '.$other_settings_admin_woo_products_name_plural.'', 'divi-bodyshop-woocommerce' ),
          'not_found'          => __( 'No  '.$other_settings_admin_woo_products_name_plural.' found', 'divi-bodyshop-woocommerce' ),
          'not_found_in_trash' => __( 'No '.$other_settings_admin_woo_products_name_plural.' found in trash', 'divi-bodyshop-woocommerce' ),
          'parent'             => __( 'Parent  '.$other_settings_admin_woo_products_name_singular.'', 'divi-bodyshop-woocommerce' )
      );

      $args['labels'] = $labels;
      return $args;
  }
}


// CUSTOM QUANTITY


$custom_quantity_field = get_bodycommerce_option( 'custom_quantity_field' );
if ($custom_quantity_field == "1") {
  add_action('wp_footer', 'custom_quantity_field_footer');
  add_action('wp_head', 'custom_quantity_field_head');

  function custom_quantity_field_footer(){
    ?>
<script> 
jQuery(document).ready(function ($) {

$(".cart .quantity").prepend('<button type="button" id="sub" class="sub"></button>');
$(".cart .quantity").append('<button type="button" id="add" class="add"></button>');

$(".shop_table .quantity").prepend('<button type="button" id="sub" class="sub"></button>');
$(".shop_table .quantity").append('<button type="button" id="add" class="add"></button>');


$(".quantity :input").bind('keyup mouseup', function () {

  var max = $(this).attr("max");
  if (max == "") {
    max = "9999999999";
  }
  var val = $(this).val();

  var max_num = parseInt(max);

  if (val >= max_num) {
    $(this).val(max_num);
  } else {

  }

});

$(document).on("click", '.add', function (event) {
  event.preventDefault();
  event.stopPropagation();
  var max = $(this).closest(".quantity").find("input").attr("max");
  if (max == "") {
    max = "9999999999";
  }
  var val = $(this).closest(".quantity").find("input").val();

  var max_num = parseInt(max);

  if (val >= max_num) {
    $(this).closest(".quantity").find("input").val(max_num);
  } else {
    var step = $(this).closest('.quantity').find('input').attr("step");
    if ( typeof step == 'undefined' ) {
      step = 1;
    } else {
      step = parseInt(step);
    }

    $(this).closest(".quantity").find("input").val(+$(this).closest(".quantity").find("input").val() + step);
    $(this).closest(".woocommerce-cart-form").find(".button").prop('disabled', false);
  }
});
$(document).on("click", '.sub', function (event) {
  event.preventDefault();
  event.stopPropagation();
  var min = $(this).closest(".quantity").find("input").attr("min");
  if (min == "") {
    min = "0";
  }
  var val = $(this).closest(".quantity").find("input").val();

  var min_num = parseInt(min);
  if (val <= min_num) {
    $(this).closest(".quantity").find("input").val(min_num);
  } else {
    var step = $(this).closest('.quantity').find('input').attr("step");
    if ( typeof step == 'undefined' ) {
      step = 1;
    }else {
      step = parseInt(step);
    }
    if ($(this).closest(".quantity").find(".qty").val() > 1) {
      if ($(this).closest(".quantity").find(".qty").val() > 1) $(this).closest(".quantity").find(".qty").val(+$(this).closest(".quantity").find(".qty").val() - step);
      $(this).closest(".woocommerce-cart-form").find(".button").prop('disabled', false);
    }
  }
});

// Add the quantity buttons with ajax
$(document).ajaxSuccess(function () {
  $(".quantity .sub").remove();
  $(".quantity .add").remove();
  $(".quantity").prepend('<button type="button" id="sub" class="sub"></button>');
  $(".quantity").append('<button type="button" id="add" class="add"></button>');
});

$(document.body).on('updated_cart_totals', function () {
  $(".shop_table .quantity").prepend('<button type="button" id="sub" class="sub"></button>');
  $(".shop_table .quantity").append('<button type="button" id="add" class="add"></button>');
});

});
</script>
    <?php
  }


  function custom_quantity_field_head(){

    $quantity_width = get_bodycommerce_option( 'quantity_width' ); // done
    $quantity_max_width = get_bodycommerce_option( 'quantity_max_width' ); // done
    $quantity_background_color = get_bodycommerce_option( 'quantity_background_color' ); // done
    $quantity_number_color = get_bodycommerce_option( 'quantity_number_color' ); // done
    $quantity_minus_icon = get_bodycommerce_option( 'quantity_minus_icon' ); // done
    $quantity_number_minus_color = get_bodycommerce_option( 'quantity_number_minus_color' ); // done
    $quantity_number_minus_size = get_bodycommerce_option( 'quantity_number_minus_size' ); // done
    $quantity_add_icon = get_bodycommerce_option( 'quantity_add_icon' ); // done
    $quantity_number_add_color = get_bodycommerce_option( 'quantity_number_add_color' ); // done
    $quantity_number_add_size = get_bodycommerce_option( 'quantity_number_add_size' ); // done
    $quantity_border_style = get_bodycommerce_option( 'quantity_border_style' );
    $quantity_border_size = get_bodycommerce_option( 'quantity_border_size' );
    $quantity_border_color = get_bodycommerce_option( 'quantity_border_color' );
    $quantity_border_radius = get_bodycommerce_option( 'quantity_border_radius' );
    $quantity_border_height = get_bodycommerce_option( 'quantity_border_height' );

    if ($quantity_border_height == "0") {
      $quantity_border_height_dis = "";
      $quantity_border_height_input_dis = "";
    }
    else {
      $quantity_border_height_dis = "height: " . $quantity_border_height . "px";
      $quantity_border_height_input_dis = "max-height: " . $quantity_border_height . "px !important;padding: 0;height: 100%;";
    }

    $render_minus_icon = sprintf('content: "\%s";', $quantity_minus_icon);
    $render_add_icon = sprintf('content: "\%s";', $quantity_add_icon);

 $css_woo_bodyshop =  '<style id="bodycommerce_custom_quantity_input">';

$css_woo_bodyshop .= '

.product form.cart .quantity:has(input[type=hidden]) {
  display: none;
}

.et_pb_wc_cart_products .product-quantity span {
  display: none;
  }

  .et-db #et-boc .et-l .et_pb_wc_add_to_cart .quantity input.qty, 
  .et_pb_wc_add_to_cart .quantity input.qty,
  .product form.cart .quantity input[type="number"].qty {
    width: 100% !important;
    max-width: 100% !important;
    '.$quantity_border_height_input_dis.';
}

.product form.cart .quantity, 
.shop_table .quantity, 
.archive.woocommerce li:not(.woocommerce-mini-cart-item) .quantity, 
body.woocommerce .cart .quantity {
  text-decoration: none;
  -webkit-appearance: none;
  -moz-appearance: textfield;
  outline: 0;
  -webkit-box-shadow: none;
  -moz-box-shadow: none;
  box-shadow: none;
  border-style: '. $quantity_border_style .';
  border-width: '. $quantity_border_size .'px;
  border-color: '. $quantity_border_color .';
  border-radius: '. $quantity_border_radius .'px !important;
  background-color: '. $quantity_background_color .';
  position: relative;
  min-width: '. $quantity_max_width .'px !important;
  width: '. $quantity_width .'px !important;
  '.$quantity_border_height_dis.';
  overflow: hidden;
margin: 0 20px 0 0!important;
}

.shop_table .quantity, body.woocommerce .cart  .quantity {
    display: inline-block;
}
.product form.cart .quantity input[type=number].qty, .shop_table .quantity input[type=number].qty, .archive.woocommerce .quantity input[type=number].qty, body.woocommerce .cart  .quantity input[type=number].qty {
    border: none !important;
    text-decoration: none!important;
    -webkit-appearance: none!important;
    -moz-appearance: textfield!important;
    appearance: none!important;
    outline: 0!important;
    -webkit-box-shadow: none!important;
    -moz-box-shadow: none!important;
    box-shadow: none!important;
    background-color: transparent!important;
    color: '. $quantity_number_color .' !important;
    width: 100%;
    text-align: center;
    -webkit-appearance: none !important;
    margin: 0;
}
.sub, .add{
    text-decoration: none;
    position: absolute;
    top: 0;
    bottom: 0;
    line-height: 46px;
    font-size: 25px;
    padding: 0 12px;
    background-color: transparent;
    border: none;
    cursor: pointer;
    min-width: 40px;
}
.sub {
	    left: 0;
}

.add {
      right: 0;
}

.sub::after, .add::after {
  position: absolute;
  font-family: "ETmodules";
  top: 50%;
  left: 50%;
  transform: translate(-50%,-50%);
}

.sub::after {
  '. $render_minus_icon .'
  color: '. $quantity_number_minus_color .';
  font-size: '. $quantity_number_minus_size .'px;
}

.add::after {
  '. $render_add_icon .'
  color: '. $quantity_number_add_color .';
  font-size: '. $quantity_number_add_size .'px;
}


form .quantity input[type=number]::-webkit-inner-spin-button,form .quantity input[type=number]::-webkit-outer-spin-button, body.woocommerce .cart  .quantity input[type=number]::-webkit-outer-spin-button {
  -webkit-appearance:none;margin:0
}

 body.woocommerce .cart  .quantity input[type=number]::-webkit-inner-spin-button, body.woocommerce .cart  .quantity input[type=number],form .quantity input[type=number],.shop_table .quantity input[type=number]::-webkit-inner-spin-button,.shop_table .quantity input[type=number]::-webkit-outer-spin-button{-webkit-appearance:none;margin:0}.shop_table .quantity input[type=number],
.product form.cart .quantity input[type="number"].qty, .shop_table .quantity input[type="number"].qty{
  -webkit-appearance: none !important;
    -webkit-appearance: textfield !important;
}


';
$css_woo_bodyshop .= '</style>';
//minify it
$css_woo_bodyshop_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_woo_bodyshop );
echo $css_woo_bodyshop_min;
  }


}


// CUSTOM SELECT FIELD

$custom_select_field = get_bodycommerce_option( 'custom_select_field' );
$custom_select_field_select2 = get_bodycommerce_option( 'custom_select_field_select2' );
if ($custom_select_field == "1") {
  add_action('wp_head', 'custom_select_field_head');
  add_action('wp_footer', 'custom_select_field_footer');
  if ($custom_select_field_select2 == "1") {
  add_action( 'wp_enqueue_scripts', 'disable_select2_dropdown', 100 );
  function disable_select2_dropdown() {
    if ( class_exists( 'woocommerce' ) ) {
      wp_dequeue_style( 'selectWoo' );
      wp_deregister_style( 'selectWoo' );

      wp_dequeue_script( 'selectWoo');
      wp_deregister_script('selectWoo');

}
  }
}



  function custom_select_field_footer(){
    ?>
<script>jQuery(document).ready(function(e){e(document).ajaxSuccess(function(){e(".woocommerce-page select").parent().addClass("custom-dropdown"),e(".woocommerce-page select.bodycommerce-variation-raw-select").parent().removeClass("custom-dropdown"),e(".woocommerce-page select#rating").parent().removeClass("custom-dropdown")}),e(".woocommerce-page select").parent().addClass("custom-dropdown"),e(".woocommerce-page select.bodycommerce-variation-raw-select").parent().removeClass("custom-dropdown"),e(".woocommerce-page select#rating").parent().removeClass("custom-dropdown")});</script>
    <?php
  }
  function custom_select_field_head(){

    $custom_select_background_color = get_bodycommerce_option( 'custom_select_background_color' );
    $custom_select_text_color = get_bodycommerce_option( 'custom_select_text_color' );
    $custom_select_font_size = get_bodycommerce_option( 'custom_select_font_size' );
    $custom_select_pad_top = get_bodycommerce_option( 'custom_select_pad_top' );
    $custom_select_pad_bottom = get_bodycommerce_option( 'custom_select_pad_bottom' );
    $custom_select_pad_right = get_bodycommerce_option( 'custom_select_pad_right' );
    $custom_select_pad_left = get_bodycommerce_option( 'custom_select_pad_left' );
    $custom_select_border_style = get_bodycommerce_option( 'custom_select_border_style' );
    $custom_select_border_size = get_bodycommerce_option( 'custom_select_border_size' );
    $custom_select_border_color = get_bodycommerce_option( 'custom_select_border_color' );
    $custom_select_border_radius = get_bodycommerce_option( 'custom_select_border_radius' );
    $custom_select_icon = get_bodycommerce_option( 'custom_select_icon' );
    $custom_select_color = get_bodycommerce_option( 'custom_select_color' );
    $custom_select_size = get_bodycommerce_option( 'custom_select_icon_size' );
    $custom_select_icon_background_color = get_bodycommerce_option( 'custom_select_icon_background_color' );
    $custom_select_dis_right = get_bodycommerce_option( 'custom_select_dis_right' );
    $custom_select_dis_top = get_bodycommerce_option( 'custom_select_dis_top' );
    $custom_select_icon_background_width = get_bodycommerce_option( 'custom_select_icon_background_width' );

    if ($custom_select_dis_top == "0") {
      $custom_select_dis_top_dis = "";
    } else {
      $custom_select_dis_top_dis ="top: ". $custom_select_dis_top ."px;";
    }

    $render_custom_select_icon = sprintf('content: "\%s";', $custom_select_icon);

 $css_woo_bodyshop =  '<style id="bodycommerce_custom_select_input">';
$css_woo_bodyshop .= '

.woocommerce .product form.cart .reset_variations {
position: absolute;
    bottom: -25px;
}

.variations select, .woocommerce .product form.cart .variations td select, 
.woocommerce form .form-row select, .woocommerce-page form .form-row select, 
.orderby, body.woocommerce div.product form.cart .variations td select,
.woocommerce #page-container .checkout-area form .form-row select {
  background-color: '.$custom_select_background_color.';
  color: '.$custom_select_text_color.' !important;
  font-size: '.$custom_select_font_size.'px;
  padding-top: '.$custom_select_pad_top.'px;
  padding-bottom: '.$custom_select_pad_bottom.'px;
  padding-right: '.$custom_select_pad_right.'px;
  padding-left: '.$custom_select_pad_left.'px;
  border: 0;
  margin: 0;
  text-indent: 0.01px;
  text-overflow: initial;
  -moz-appearance: none !important;
  -webkit-appearance: none !important;
  -moz-appearance: none !important;
  appearance: none;
  display: block;
  width: 100%;
  border-style: '. $custom_select_border_style .' !important;
  border-width: '. $custom_select_border_size .'px;
  border-color: '. $custom_select_border_color .';
  border-radius: '. $custom_select_border_radius .'px !important;
}

.custom-dropdown {
  position: relative;
  display: block;
  vertical-align: middle !important;
}



.woocommerce .product form.cart .variations td {
  padding: 0 !important;
}

.woocommerce .product form.cart .variations .custom-dropdown {
  margin-left: 20px;
}

.custom-dropdown select::-ms-expand {
    display: none;
}

.custom-dropdown::before,
.custom-dropdown::after {
  content: "";
  position: absolute;
  pointer-events: none;
}

td.custom-dropdown:after,
#page-container form.cart .variations td.value td.custom-dropdown:after {
  height: 1em;
      line-height: 1;
      right: '.$custom_select_dis_right.'px;
      top: 50%;
      transform: translateY(-50%);
      margin-top: -.5em;
      position: absolute;
      font-family: "ETmodules";
    '.$render_custom_select_icon.'
      font-size: '.$custom_select_size.'px;
      color: '.$custom_select_color.';
      z-index: 10;
      '.$custom_select_dis_top_dis.'
}



.custom-dropdown::before {
  width: '.$custom_select_icon_background_width.'px;
  right: 0;
  top: 0;
  bottom: 0;
  border-radius: 0 3px 3px 0;
  background-color: '.$custom_select_icon_background_color.';
  z-index: 4;
}

.custom-dropdown:after,
#page-container form.cart .variations td.value span.custom-dropdown:after {
  color: rgba(0,0,0,.6);
}

.custom-dropdown select[disabled] {
  color: rgba(0,0,0,.25);
} ';
$css_woo_bodyshop .= '</style>';
//minify it
$css_woo_bodyshop_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_woo_bodyshop );
echo $css_woo_bodyshop_min;
  }

}
else {
  // code...
}


// CUSTOM INPUT FIELD



$checkout_page_disable_none_required = get_bodycommerce_option( 'checkout_page_disable_none_required' );
if ($checkout_page_disable_none_required == "1") {
  
  add_action('wp_head', 'checkout_disable_none_required');
  function checkout_disable_none_required(){
    ?>
    <style>
    .woocommerce-checkout .et_pb_db_checkout_billing .form-row:not(.validate-required),
    .woocommerce-checkout .et_pb_db_checkout_shipping .form-row:not(.validate-required),
    .woocommerce-checkout .woocommerce-billing-fields .form-row:not(.validate-required),
    .woocommerce-checkout .woocommerce-shipping-fields .form-row:not(.validate-required) {display: none !important;}
    </style>
    <?php
  }

}

$custom_input_field_placeholder = get_bodycommerce_option( 'custom_input_field_placeholder' );
if ($custom_input_field_placeholder == "1") {
  add_action('wp_footer', 'custom_input_field_footer');
  function custom_input_field_footer(){  
    if ( function_exists( 'is_woocommerce' ) ) {
        if ( is_checkout() ) {
    ?>
<script>jQuery(document).ready(function($){$(".woocommerce-checkout input").each(function(){var placeholder = $(this).closest('.form-row').find('label').text();if (placeholder !== '') {$(this).attr("placeholder", placeholder);}})});</script>
<style>.woocommerce-checkout form .form-row label {display: none;}</style>
    <?php
        }
      }
  }
}

$custom_input_field = get_bodycommerce_option( 'custom_input_field' );
if ($custom_input_field == "1") {
  add_action('wp_head', 'custom_input_field_head');
  
  function custom_input_field_head(){

    $custom_input_background_color = get_bodycommerce_option( 'custom_input_background_color' );
    $custom_input_text_color = get_bodycommerce_option( 'custom_input_text_color' );
    $custom_input_placeholder_text_color = get_bodycommerce_option( 'custom_input_placeholder_text_color' );
    $custom_input_font_size = get_bodycommerce_option( 'custom_input_font_size' );
    $custom_input_pad_top = get_bodycommerce_option( 'custom_input_pad_top' );
    $custom_input_pad_bottom = get_bodycommerce_option( 'custom_input_pad_bottom' );
    $custom_input_pad_right = get_bodycommerce_option( 'custom_input_pad_right' );
    $custom_input_pad_left = get_bodycommerce_option( 'custom_input_pad_left' );
    $custom_input_border_style = get_bodycommerce_option( 'custom_input_border_style' );
    $custom_input_border_size = get_bodycommerce_option( 'custom_input_border_size' );
    $custom_input_border_color = get_bodycommerce_option( 'custom_input_border_color' );
    $custom_input_border_radius = get_bodycommerce_option( 'custom_input_border_radius' );
    $custom_input_error_border_color = get_bodycommerce_option( 'custom_input_error_border_color' );
    $custom_input_valid_border_color = get_bodycommerce_option( 'custom_input_valid_border_color' );



 $css_woo_bodyshop =  '<style id="bodycommerce_custom_input">';
$css_woo_bodyshop .= '


.woocommerce form .form-row input.input-text, .woocommerce form .form-row textarea {
  background-color: '.$custom_input_background_color.';
  color: '.$custom_input_text_color.' !important;
  font-size: '.$custom_input_font_size.'px;
  padding-top: '.$custom_input_pad_top.'px;
  padding-bottom: '.$custom_input_pad_bottom.'px;
  padding-right: '.$custom_input_pad_right.'px;
  padding-left: '.$custom_input_pad_left.'px;
  margin: 0;
  border-radius: 0 !important;
  text-indent: 0.01px;
  text-overflow: initial;
  -moz-appearance: none;
  -webkit-appearance: none;
  appearance: none;
  display: block;
  width: 100%;
  border-style: '. $custom_input_border_style .' !important;
  border-width: '. $custom_input_border_size .'px;
  border-color: '. $custom_input_border_color .';
  border-radius: '. $custom_input_border_radius .'px !important;
}

::-webkit-input-placeholder { /* Chrome/Opera/Safari */
color: '.$custom_input_placeholder_text_color.' !important;
}
/* CONTROLS PLACEHOLDER TEXT */
::-moz-placeholder { /* Firefox 19+ */
color: '.$custom_input_placeholder_text_color.' !important;
}
/* CONTROLS PLACEHOLDER TEXT */
:-ms-input-placeholder { /* IE 10+ */
color: '.$custom_input_placeholder_text_color.' !important;
}
/* CONTROLS PLACEHOLDER TEXT */
:-moz-placeholder { /* Firefox 18- */
color: '.$custom_input_placeholder_text_color.' !important;
}


.checkout-area form .form-row.woocommerce-validated input.input-text {
border-color: '. $custom_input_valid_border_color .';
}

.woocommerce form .form-row.woocommerce-invalid input.input-text {
border-color: '. $custom_input_error_border_color .';

}

';
$css_woo_bodyshop .= '</style>';
//minify it
$css_woo_bodyshop_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_woo_bodyshop );
echo $css_woo_bodyshop_min;
  }

}
else {
  // code...
}


$divi_search_products = get_bodycommerce_option( 'divi_search_products' );
if ($divi_search_products == "1") {

add_action('wp_footer', 'divi_search_products_header');
function divi_search_products_header(){
  ?>
<script>jQuery(document).ready(function(e){e(".et-search-form").append('<input type="hidden" name="post_type" value="product" />'),e(".et_pb_menu__search-form").each(function(p,t){e(".et_pb_menu__search-form").append('<input type="hidden" name="post_type" value="product" />')})});</script>
  <?php
}

}

// Active swatch name
$variation_swatch_label_text = get_bodycommerce_option( 'variation_swatch_label_text' );
if ($variation_swatch_label_text == "1") {

add_action('wp_footer', 'variation_active_name');
function variation_active_name(){
$variation_text_between_swatch_label_text = get_bodycommerce_option( 'variation_text_between_swatch_label_text' );
if ($variation_text_between_swatch_label_text == "") {
  $between = " ";
}
else {
  $between = ' '. $variation_text_between_swatch_label_text . ' ';
}

  ?>
<script>
jQuery(document).ready(function(t){jQuery(".variations tr").each(function(t,a){var e=jQuery(this).find(".active-variation").attr("data-bc-swatch-tooltip"),l=jQuery(this).find("ul").attr("data-attribute_name_title");void 0!==e&&jQuery(this).find("label").html("<span class='var_label_title'>"+l+"</span><?php echo $between ?><span class='var_label_value'>"+e+"</span>")}),t(".variable-item").click(function(){var a=t(this).closest(".variable-item").attr("data-bc-swatch-tooltip"),e=t(this).closest("ul").attr("data-attribute_name_title");void 0!==a&&t(this).closest("tr").find("label").html("<span class='var_label_title'>"+e+"</span><?php echo $between ?><span class='var_label_value'>"+a+"</span>")})});
</script>
  <?php
}
} 

// CHANGE THE LINK OF THE BREADCRUMBS HOME TO SHOP

$other_settings_breadcrumb_home_shop = get_bodycommerce_option( 'other_settings_breadcrumb_home_shop' );

if ($other_settings_breadcrumb_home_shop == "1") {

add_filter( 'woocommerce_breadcrumb_home_url', 'bodycommerce_breadcrumbs_home_shop' );
function bodycommerce_breadcrumbs_home_shop() {
$shop_page_url = get_permalink( wc_get_page_id( 'shop' ) );
return $shop_page_url;
}
}




$other_settings_breadcrumb_home_shop_text = get_bodycommerce_option( 'other_settings_breadcrumb_home_shop_text' );
if ($other_settings_breadcrumb_home_shop_text != "") {

add_filter( 'woocommerce_breadcrumb_defaults', 'bodycommmerce_change_breadcrumbs_home_text' );
function bodycommmerce_change_breadcrumbs_home_text( $defaults ) {
$other_settings_breadcrumb_home_shop_text_get = get_bodycommerce_option( 'other_settings_breadcrumb_home_shop_text' );
do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Change breadcrumbs home text', $other_settings_breadcrumb_home_shop_text_get );
$other_settings_breadcrumb_home_shop_text = apply_filters( 'wpml_translate_single_string', $other_settings_breadcrumb_home_shop_text_get, 'divi-bodyshop-woocommerce', 'Change breadcrumbs home text' );
    // Change the breadcrumb home text from 'Home' to 'Apartment'
	$defaults['home'] = $other_settings_breadcrumb_home_shop_text;
	return $defaults;
}

}





$other_settings_user_password_confirm = get_bodycommerce_option( 'other_settings_user_password_confirm' );
if ($other_settings_user_password_confirm == "1") {
  // ----- validate password match on the registration page
  function bodycommerce_registration_errors_validation($reg_errors, $sanitized_user_login, $user_email) {
    global $woocommerce;
    extract( $_POST );
    if ( strcmp( $password, $password2 ) !== 0 ) {
      return new WP_Error( 'registration-error', __( 'Passwords do not match.', 'woocommerce' ) );
    }
    return $reg_errors;
  }
  add_filter('woocommerce_registration_errors', 'bodycommerce_registration_errors_validation', 10,3);
  
  // ----- add a confirm password fields match on the registration page
  function bodycommerce_register_form_password_repeat() {
$other_settings_user_password_confirm_text_get = get_bodycommerce_option( 'other_settings_user_password_confirm_text' );
  do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Confrim Password Text', $other_settings_user_password_confirm_text_get );
  $other_settings_user_password_confirm_text = apply_filters( 'wpml_translate_single_string', $other_settings_user_password_confirm_text_get, 'divi-bodyshop-woocommerce', 'Confrim Password Text' );
  	?>
  	<p class="form-row form-row-wide">
  		<label for="reg_password2"><?php _e( $other_settings_user_password_confirm_text, 'divi-bodyshop-woocommerce' ); ?> <span class="required">*</span></label>
  		<input type="password" class="input-text" name="password2" id="reg_password2" value="<?php if ( ! empty( $_POST['password2'] ) ) echo esc_attr( $_POST['password2'] ); ?>" />
  	</p>
  	<?php
  }
  add_action( 'woocommerce_register_form', 'bodycommerce_register_form_password_repeat' );

  // ----- Validate confirm password field match to the checkout page
  function bodycommerce_woocommerce_confirm_password_validation( $posted ) {
      $checkout = WC()->checkout;
      if ( ! is_user_logged_in() && ( $checkout->must_create_account || ! empty( $posted['createaccount'] ) ) ) {
          if ( strcmp( $posted['account_password'], $posted['account_confirm_password'] ) !== 0 ) {
              wc_add_notice( __( 'Passwords do not match.', 'woocommerce' ), 'error' );
          }
      }
  }
  add_action( 'woocommerce_after_checkout_validation', 'bodycommerce_woocommerce_confirm_password_validation', 10, 2 );

  // ----- Add a confirm password field to the checkout page
  function bodycommerce_oocommerce_confirm_password_checkout( $checkout ) {
    if (!is_admin()) {
      if ( get_option( 'woocommerce_registration_generate_password' ) == 'no' ) {

        $other_settings_user_password_confirm_text_get = get_bodycommerce_option( 'other_settings_user_password_confirm_text' );
  do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'Confrim Password Text', $other_settings_user_password_confirm_text_get );
  $other_settings_user_password_confirm_text = apply_filters( 'wpml_translate_single_string', $other_settings_user_password_confirm_text_get, 'divi-bodyshop-woocommerce', 'Confrim Password Text' );

          $fields = $checkout->get_checkout_fields();

          $fields['account']['account_confirm_password'] = array(
              'type'              => 'password',
              'label'             => __( $other_settings_user_password_confirm_text, 'divi-bodyshop-woocommerce' ),
              'required'          => true,
              'placeholder'       => _x( $other_settings_user_password_confirm_text, 'placeholder', 'divi-bodyshop-woocommerce' )
          );

          $checkout->__set( 'checkout_fields', $fields );
      }
    }
  }
  add_action( 'woocommerce_checkout_init', 'bodycommerce_oocommerce_confirm_password_checkout', 10, 1 );

}




$my_account_menu_text_change_css = get_bodycommerce_option( 'my_account_menu_text_change_css' );
if ($my_account_menu_text_change_css == "") {

} else {

// Change My Account Name

add_action('wp_footer', 'bodycommerce_change_my_account_name');
function bodycommerce_change_my_account_name(){

$my_account_menu_text_change = get_bodycommerce_option( 'my_account_menu_text_change' );
$my_account_menu_text_change_css = get_bodycommerce_option( 'my_account_menu_text_change_css' );
$my_account_menu_text_change_get = get_bodycommerce_option( 'my_account_menu_text_change' );

  do_action( 'wpml_register_single_string', 'divi-bodyshop-woocommerce', 'My Account Menu Text Change', $my_account_menu_text_change_get );
  $my_account_menu_text_change = apply_filters( 'wpml_translate_single_string', $my_account_menu_text_change_get, 'divi-bodyshop-woocommerce', 'My Account Menu Text Change' );

  $my_account_menu_text_change_css = get_bodycommerce_option( 'my_account_menu_text_change_css' ); 
  $my_account_menu_text_username_or_text = get_bodycommerce_option( 'my_account_menu_text_username_or_text' ); 

  $user_info = get_userdata(get_current_user_id());
  $display_name = !empty($user_info->display_name)?$user_info->display_name:'';

   if ( is_user_logged_in() ) {
    if ($my_account_menu_text_username_or_text == "1") {
      ?>
      <script>jQuery(document).ready(function( $ ) {
        $(".<?php echo $my_account_menu_text_change_css ?> > a").html("<?php echo $display_name ?>");
        });
        </script>
        <?php
    }
  } else {
    if ($my_account_menu_text_change == "") {

    } else {
  ?>
<script>jQuery(document).ready(function( $ ) {$(".<?php echo $my_account_menu_text_change_css ?> > a").html("<?php echo $my_account_menu_text_change ?>");});</script>
  <?php
    }
}
}

}


// Overwrite German Market
$settings_german_market_overwrite = get_bodycommerce_option( 'settings_german_market_overwrite' );
if ($settings_german_market_overwrite == "1") {

add_filter( 'german_market_add_woocommerce_de_templates_force_original', function( $boolean, $template_name ) {
  if ( $template_name != 'checkout/terms.php' ) { return true; }
  return $boolean;
  }, 10, 2 );

}


$other_settings_custom_login_redirect = get_bodycommerce_option( 'other_settings_custom_login_redirect' );
if ($other_settings_custom_login_redirect != "") {

function custom_registration_redirect() {

  $other_settings_custom_login_redirect = get_bodycommerce_option( 'other_settings_custom_login_redirect' );

  if ($other_settings_custom_login_redirect == "/") {
    return home_url('/');
  } else {
    return home_url('/' . $other_settings_custom_login_redirect);
  }
}
add_action('woocommerce_registration_redirect', 'custom_registration_redirect', 2);

}




add_action('wp_footer', 'bodycommerce_same_height_cards');
function bodycommerce_same_height_cards(){
  ?>
<script>

function same_height() {
  var totalImg = jQuery('.same-height-cards .et_pb_row_bodycommerce img').length;
  var imageLoaded = 0;

  jQuery(document).on('load', '.same-height-cards .et_pb_row_bodycommerce img', function() {
    imageLoaded++;
    if ( imageLoaded == totalImg ) {
      jQuery('.same-height-cards .et_pb_row_bodycommerce').each(function(){
        var highestBox = 0;
        jQuery(this).find('li').css('height', 'auto');
        jQuery('> li', this).each(function(){
          if(jQuery(this).height() > highestBox) {
            highestBox = jQuery(this).height();
          }
        });
        var margin_bottom = jQuery(this).find(".et_pb_section").css("marginBottom");
        if (margin_bottom == "") {
          var new_height = highestBox - margin_bottom.slice(0,-2);
        } else {
          var new_height = highestBox;
        }
        jQuery('> li',this).height(new_height);
        jQuery('> li',this).css("margin-bottom", margin_bottom);
        jQuery('> li .et_pb_section',this).css("height", "100%");
      });
    }
  }).each(function() {
    if(this.complete) jQuery(this).load();
  });
}

jQuery(document).ready(function(e){

  // when the browser changes size
  jQuery(window).resize(function() {
    same_height();
  });
  
  // same_height();
  jQuery( document ).ajaxComplete(function( event, request, settings ) {
    setTimeout( function() {
      same_height();  
    }, 500);
  });
});

</script>
  <?php

}


// Put original Divi cart icon at end
// $settings_divi_cart_end_primary_menu = get_bodycommerce_option( 'settings_divi_cart_end_primary_menu' );
// if ($settings_divi_cart_end_primary_menu == 1) {
//
//   add_filter( 'wp_nav_menu_items', 'bodycommerce_add_cart_end_primary_menu', 10, 2 );
//   function bodycommerce_add_cart_end_primary_menu ( $items, $args ) {
//
//     include(DE_DB_WOO_PATH . '/titan-framework/titan-framework-embedder.php');
//     $titan = TitanFramework::getInstance( 'divi-bodyshop-woo' );
//     $settings_divi_cart_end_primary_menu_choose = get_bodycommerce_option( 'settings_divi_cart_end_primary_menu_choose' );
//
//
//     if( $args->theme_location == $settings_divi_cart_end_primary_menu_choose ) {
//           $items .= do_shortcode('[bodycommerce_cart_icon]');
//     }
//
// return $items;
//   }
//
// }



// Hide BC modules
$settings_hide_modules = get_bodycommerce_option( 'settings_hide_modules' );
if ($settings_hide_modules == "1") {

  add_action('admin_head', 'divi_engine_admin_css_hide_modules');

  function divi_engine_admin_css_hide_modules() {
    echo '<style>
  .et_db_stock_status,.et_fb_db_account_nav,.et_fb_db_action_shortcode,.et_fb_db_add_info,.et_fb_db_atc,.et_fb_db_attribute,.et_fb_db_breadcrumbs,.et_fb_db_cart_products,.et_fb_db_cart_total,.et_fb_db_checkout_after_cust_details,.et_fb_db_checkout_before_cust_details,.et_fb_db_checkout_before_order_review,.et_fb_db_checkout_billing,.et_fb_db_checkout_coupon,.et_fb_db_checkout_order_review,.et_fb_db_checkout_payment,.et_fb_db_checkout_shipping,.et_fb_db_content,.et_fb_db_crosssell,.et_fb_db_images,.et_fb_db_login_form,.et_fb_db_login_password_confirmation,.et_fb_db_login_password_lost,.et_fb_db_login_password_reset,.et_fb_db_meta,.et_fb_db_notices,.et_fb_db_price,.et_fb_db_pro_before,.et_fb_db_pro_navigation,.et_fb_db_product_carousel,.et_fb_db_product_slider,.et_fb_db_product_summary,.et_fb_db_product_title,.et_fb_db_products_search,.et_fb_db_rating,.et_fb_db_register_form,.et_fb_db_related_products,.et_fb_db_reviews,.et_fb_db_sharing,.et_fb_db_shop_after,.et_fb_db_shop_button,.et_fb_db_shop_cat_loop,.et_fb_db_shop_cat_title,.et_fb_db_shop_loop,.et_fb_db_shop_thumbnail,.et_fb_db_short_desc,.et_fb_db_single_image,.et_fb_db_tabs,.et_fb_db_thankyou_cust_details,.et_fb_db_thankyou_details,.et_fb_db_thankyou_overview,.et_fb_db_thankyou_payment_details,.et_fb_db_upsell,.et_fb_db_woo_add_payment_method,.et_fb_db_woo_addresses,.et_fb_db_woo_avatar,.et_fb_db_woo_downloads,.et_fb_db_woo_edit_account,.et_fb_db_woo_edit_addresses,.et_fb_db_woo_get_name,.et_fb_db_woo_orders,.et_fb_db_woo_payment_methods,.et_fb_db_woo_user_name,.et_fb_db_woo_view_order,.et_pb_db_account_nav,.et_pb_db_action_shortcode,.et_pb_db_add_info,.et_pb_db_atc,.et_pb_db_attribute,.et_pb_db_breadcrumbs,.et_pb_db_cart_products,.et_pb_db_cart_total,.et_pb_db_checkout_after_cust_details,.et_pb_db_checkout_before_cust_details,.et_pb_db_checkout_before_order_review,.et_pb_db_checkout_billing,.et_pb_db_checkout_coupon,.et_pb_db_checkout_order_review,.et_pb_db_checkout_payment,.et_pb_db_checkout_shipping,.et_pb_db_content,.et_pb_db_crosssell,.et_pb_db_images,.et_pb_db_login_form,.et_pb_db_login_password_confirmation,.et_pb_db_login_password_lost,.et_pb_db_login_password_reset,.et_pb_db_meta,.et_pb_db_notices,.et_pb_db_price,.et_pb_db_pro_before,.et_pb_db_pro_navigation,.et_pb_db_product_carousel,.et_pb_db_product_slider,.et_pb_db_product_summary,.et_pb_db_product_title,.et_pb_db_products_search,.et_pb_db_rating,.et_pb_db_register_form,.et_pb_db_related_products,.et_pb_db_reviews,.et_pb_db_sharing,.et_pb_db_shop_after,.et_pb_db_shop_button,.et_pb_db_shop_cat_loop,.et_pb_db_shop_cat_title,.et_pb_db_shop_loop,.et_pb_db_shop_thumbnail,.et_pb_db_short_desc,.et_pb_db_single_image,.et_pb_db_tabs,.et_pb_db_thankyou_cust_details,.et_pb_db_thankyou_details,.et_pb_db_thankyou_overview,.et_pb_db_thankyou_payment_details,.et_pb_db_upsell,.et_pb_db_woo_add_payment_method,.et_pb_db_woo_addresses,.et_pb_db_woo_avatar,.et_pb_db_woo_downloads,.et_pb_db_woo_edit_account,.et_pb_db_woo_edit_addresses,.et_pb_db_woo_get_name,.et_pb_db_woo_orders,.et_pb_db_woo_payment_methods,.et_pb_db_woo_user_name,.et_pb_db_woo_view_order{display:none!important}
  </style>';
  }

  add_action('wp_head', 'divi_engine_frontend_css_hide_modules');

  function divi_engine_frontend_css_hide_modules() {
    echo '<style>
.et_db_stock_status,.et_fb_db_account_nav,.et_fb_db_action_shortcode,.et_fb_db_add_info,.et_fb_db_atc,.et_fb_db_attribute,.et_fb_db_breadcrumbs,.et_fb_db_cart_products,.et_fb_db_cart_total,.et_fb_db_checkout_after_cust_details,.et_fb_db_checkout_before_cust_details,.et_fb_db_checkout_before_order_review,.et_fb_db_checkout_billing,.et_fb_db_checkout_coupon,.et_fb_db_checkout_order_review,.et_fb_db_checkout_payment,.et_fb_db_checkout_shipping,.et_fb_db_content,.et_fb_db_crosssell,.et_fb_db_images,.et_fb_db_login_form,.et_fb_db_login_password_confirmation,.et_fb_db_login_password_lost,.et_fb_db_login_password_reset,.et_fb_db_meta,.et_fb_db_notices,.et_fb_db_price,.et_fb_db_pro_before,.et_fb_db_pro_navigation,.et_fb_db_product_carousel,.et_fb_db_product_slider,.et_fb_db_product_summary,.et_fb_db_product_title,.et_fb_db_products_search,.et_fb_db_rating,.et_fb_db_register_form,.et_fb_db_related_products,.et_fb_db_reviews,.et_fb_db_sharing,.et_fb_db_shop_after,.et_fb_db_shop_button,.et_fb_db_shop_cat_loop,.et_fb_db_shop_cat_title,.et_fb_db_shop_loop,.et_fb_db_shop_thumbnail,.et_fb_db_short_desc,.et_fb_db_single_image,.et_fb_db_tabs,.et_fb_db_thankyou_cust_details,.et_fb_db_thankyou_details,.et_fb_db_thankyou_overview,.et_fb_db_thankyou_payment_details,.et_fb_db_upsell,.et_fb_db_woo_add_payment_method,.et_fb_db_woo_addresses,.et_fb_db_woo_avatar,.et_fb_db_woo_downloads,.et_fb_db_woo_edit_account,.et_fb_db_woo_edit_addresses,.et_fb_db_woo_get_name,.et_fb_db_woo_orders,.et_fb_db_woo_payment_methods,.et_fb_db_woo_user_name,.et_fb_db_woo_view_order{display:none!important}
  </style>';
  }

}

// CUSTOM CART ICON IN MENU
add_filter('wp_nav_menu_items', 'do_shortcode');


// Remove view basket link

$ajax_add_to_cart_remove_basket_link = get_bodycommerce_option( 'ajax_add_to_cart_remove_basket_link' );
if ($ajax_add_to_cart_remove_basket_link == "1") {
add_action('wp_head', 'ajax_remove_view_basket');
function ajax_remove_view_basket(){

$css_woo_bodyshop =  '<style id="bc_remove_ajax_view_basket">';
$css_woo_bodyshop .= '
a.added_to_cart {display:none !important}
';
$css_woo_bodyshop .= '</style>';
//minify it
$css_woo_bodyshop_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_woo_bodyshop );
echo $css_woo_bodyshop_min;
}
} else {
  // code...
}

// Remove loading animation on icon when using ajax add to cart

$ajax_add_to_cart_disable_spinning = get_bodycommerce_option( 'ajax_add_to_cart_disable_spinning' );
if ($ajax_add_to_cart_disable_spinning == "1") {
add_action('wp_head', 'ajax_disable_spinning');
function ajax_disable_spinning(){

$css_woo_bodyshop =  '<style id="bc_disable_spinning_ajax">';
$css_woo_bodyshop .= '
.add_to_cart_button::after, 
.single_add_to_cart_button::after, 
.et_pb_db_atc button::after {
-webkit-animation:none !important;
animation:none !important;
}
';
$css_woo_bodyshop .= '</style>';
//minify it
$css_woo_bodyshop_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_woo_bodyshop );
echo $css_woo_bodyshop_min;
}
} else {
  // code...
}


// Remove view basket link


add_action('wp_footer', 'other_settings_ajax_add_to_cart_disable_products');
function other_settings_ajax_add_to_cart_disable_products(){

  $other_settings_ajax_add_to_cart_disable_products = get_bodycommerce_option( 'other_settings_ajax_add_to_cart_disable_products' );

  $cart_page_empty_reload= get_bodycommerce_option( 'cart_page_empty_reload' );
  

  if ($other_settings_ajax_add_to_cart_disable_products == "") {
    ?>
    <script>
    jQuery(document).ready(function($){
  $(".single_add_to_cart_button").addClass("ajax_add_to_cart");
  $(".product-type-external .single_add_to_cart_button").removeClass("ajax_add_to_cart");
    });
    </script>
      <?php
  } else {
?>
<script>
jQuery(document).ready(function($){
  var ajax_disabled_products_class = '<?php echo $other_settings_ajax_add_to_cart_disable_products ?>';
  $(".single_add_to_cart_button").addClass("ajax_add_to_cart");
  $("." + ajax_disabled_products_class + " .single_add_to_cart_button").removeClass("ajax_add_to_cart");
  $(".product-type-external .single_add_to_cart_button").removeClass("ajax_add_to_cart");
});
</script>
  <?php
}


if ($cart_page_empty_reload == "1") {
  ?>
  <script>
    jQuery(document).ready(function(e){
      function o() {
    e(".woocommerce-cart .woocommerce-cart-form").length || (e("body").append('<div class="overlap-false" style="position:fixed;left:0;top:0;bottom:0;right:0;background-color:#fff;z-index:999999999999999999;"></div>'), location.reload())
  }
  if (jQuery(document.body).on("updated_wc_div", o), jQuery(document.body).on("updated_cart_totals", o));
    });
  </script>
<?php
}

}


$notice_change_shop_url = get_bodycommerce_option( 'notice_change_shop_url' );

if ($notice_change_shop_url !== "") {
  function bodycommerce_change_shop_url($notice_change_shop_url) {
    $notice_change_shop_url = get_bodycommerce_option( 'notice_change_shop_url' );
    $url = $notice_change_shop_url; // change this link to your need
    return esc_url( $url );
}
add_filter( 'woocommerce_return_to_shop_redirect', 'bodycommerce_change_shop_url' );
} 
}

$other_settings_cart_regular_discounted_price = get_bodycommerce_option( 'other_settings_cart_regular_discounted_price' );
if ($other_settings_cart_regular_discounted_price == "1") {
  add_filter( 'woocommerce_cart_item_price', 'divi_bodycommerce_cart_refular_sale_price', 30, 3 );
  
  function divi_bodycommerce_cart_refular_sale_price( $price, $values, $cart_item_key ) {
    $slashed_price = $values['data']->get_price_html();
    $is_on_sale = $values['data']->is_on_sale();
    if ( $is_on_sale ) {
      $price = $slashed_price;
    }
    return $price;
  }
}

// END
}
add_action( 'tf_create_options', 'divi_bodycommerce_check_other_options' );