<?php
if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! function_exists( 'woocommerce_pagination' ) ) {
// REMOVE PAGINATION
remove_action('woocommerce_pagination', 'woocommerce_pagination', 10);
function woocommerce_pagination() {
		bodycommerce_pagination();
	}
add_action( 'woocommerce_pagination', 'woocommerce_pagination', 10);

}

// CUSTOM PAGINATION
function bodycommerce_pagination() {

  if ( ! wc_get_loop_prop( 'is_paginated' ) || ! woocommerce_products_will_display() ) {
    return;
  }

  $pagination_style = get_bodycommerce_option( 'pagination_style');
  $pagination_nextprev_style = get_bodycommerce_option( 'pagination_nextprev_style');
  $pagination_prev_text = get_bodycommerce_option( 'pagination_prev_text');
  $pagination_next_text = get_bodycommerce_option( 'pagination_next_text');

  $total   = isset( $total ) ? $total : wc_get_loop_prop( 'total_pages' );
  if ( !empty($_GET['filter']) && $_GET['filter'] == 'true' && !empty($_GET['page']) ){
    $current = $_GET['page'];
  }

  if ( !empty($_GET['filter']) && $_GET['filter'] == 'true' && !empty($_GET['paged']) ){
    $current = $_GET['paged'];
  }

  $current = isset( $current ) ? $current : wc_get_loop_prop( 'current_page' );

  $base    = isset( $base ) ? $base : esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) );
  $format  = isset( $format ) ? $format : '';

  if ( $total <= 1 ) {
  	return;
  }

	if ( wc_get_loop_prop( 'is_shortcode' ) ) {
$format = '?product-page=%#%';
$base = esc_url_raw( add_query_arg( 'product-page', '%#%', false ) );
} else {
$format  = isset( $format ) ? $format : '';
$base    = isset( $base ) ? $base : esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) );
}

$extra_class = '';
  if ( defined('WOOF_PLUGIN_NAME') ) {
    $extra_class = 'woocommerce-pagination';
  }
  ?>
  <nav class="bodycommerce-pagination <?php echo $pagination_style . ' ' . $extra_class; ?> <?php echo $pagination_nextprev_style ?>">
  	<?php
echo paginate_links( apply_filters( 'woocommerce_pagination_args', array( // WPCS: XSS ok.
					'total'   => wc_get_loop_prop( 'total_pages' ),
					'current' => $current,
					'format'  => $format,
					'base'    => $base,
					'type'         => 'list',
					'end_size'     => 3,
					'mid_size'     => 3, // change how many between
					'prev_text'    => __($pagination_prev_text),
					'next_text'    => __($pagination_next_text),
				) ) );
				?>
  </nav>
  <?php
}


// CUSTOM PAGINATION CSS
add_action('wp_head','pagination_css');

function pagination_css() {

  $pagination_primary_color = get_bodycommerce_option( 'pagination_primary_color');
  $pagination_primary_color_hover = get_bodycommerce_option( 'pagination_primary_color_hover');
  $pagination_secondary_color = get_bodycommerce_option( 'pagination_secondary_color');
  $quantity_text_color = get_bodycommerce_option( 'quantity_text_color');
  $quantity_active_text_color = get_bodycommerce_option( 'quantity_active_text_color');
  $pagination_arrow_color = get_bodycommerce_option( 'pagination_arrow_color');
  $pagination_prev_icon = get_bodycommerce_option( 'pagination_prev_icon');
  $pagination_next_icon = get_bodycommerce_option( 'pagination_next_icon');

  $pagination_prev_icon_display = sprintf('content: "\%s";', $pagination_prev_icon);
  $pagination_next_icon_display = sprintf('content: "\%s";', $pagination_next_icon);

  $css_pagination =  sprintf('<style id="bodycommerce-custom-pagination">');

  $css_pagination .= '

  .bodycommerce-pagination {
  padding: 30px 0;
  text-align: center;
  }

  .bodycommerce-pagination ul {
  margin: 0!important;
  padding: 0!important;
  list-style-type: none;
  border:0!important;
  }

  .bodycommerce-pagination ul li{
        display: inline-block;
    border:0!important;
  }

  .bodycommerce-pagination li .page-numbers {
  display: inline-block!important;
  padding: 10px 18px;
  color: '.$quantity_text_color.' !important;
  -webkit-transition: all .4s;
  -moz-transition: all .4s;
  transition: all .4s;
  line-height:26px!important;
  }

  /* NEXT PREV */

  .bodycommerce-pagination.arrows .prev:before, .bodycommerce-pagination.arrows .next:before {
    text-shadow: 0 0;
    font-family: "ETmodules" !important;
    font-weight: normal;
    font-style: normal;
    font-variant: normal;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    line-height: 1;
    text-transform: none;
    speak: none;
    position: absolute;
    font-size: 17px;
    '.$pagination_prev_icon_display.'
    top: 50%;
    transform: translate(-50%, -50%);
    left: 50%;
    color: '.$pagination_arrow_color.'
  }


  .bodycommerce-pagination .next {
    float: none !important;
  }

  .bodycommerce-pagination.arrows .next:before {
    '.$pagination_next_icon_display.'
    }

  .bodycommerce-pagination.arrows .prev, .bodycommerce-pagination.arrows .next{
    font-size: 0;
      top: -6px;
      position: relative;
  }

  /* ONE */

  .bodycommerce-pagination.p1 a{
    width: 40px;
    height: 40px;
    line-height: 40px!important;
    padding: 0!important;
    text-align: center;
  }

  .bodycommerce-pagination.p1 li .page-numbers.current{
    background-color: '. $pagination_primary_color . ';
    border-radius: 100%;
    color: '.$quantity_active_text_color.'!important;
  width: 40px;
    height: 40px;
    line-height: 40px!important;
    padding: 0;
    text-align: center;
  }

    .bodycommerce-pagination.p1 li .page-numbers:hover{
      background-color: '. $pagination_primary_color_hover . ' !important;
      border-radius: 100%;
      color: '.$quantity_active_text_color.'!important;
    }


  /* TWO */

  .bodycommerce-pagination.p2 li .page-numbers.current{
    font-weight: bold;
    border-bottom: 3px solid '. $pagination_primary_color . ';
  }

  .bodycommerce-pagination.p2 li .page-numbers:hover{
    border-bottom: 3px solid '. $pagination_primary_color_hover . ' !important;
  }

  /* THREE */

  .bodycommerce-pagination.p3 li .page-numbers.current{
    background-color: '. $pagination_primary_color . ';
    color: '.$quantity_active_text_color.'!important;
  }

  .bodycommerce-pagination.p3 li .page-numbers:hover{
      background-color: '. $pagination_primary_color_hover . ';
      color: '.$quantity_active_text_color.'!important;
  }

  /* FOUR */

  .bodycommerce-pagination.p4 li{
    width: 40px;
    height: 40px;
    line-height: 40px;
    border-radius: 100%;
    padding: 0;
    text-align: center;
    position: relative;
    border: 3px solid '. $pagination_primary_color . ';
  }

  .bodycommerce-pagination.p4 li .page-numbers {
    font-size: 0;
  }

  .bodycommerce-pagination.p4 li:first-child, .bodycommerce-pagination.p4 li:last-child {
    display: none;
  }

.bodycommerce-pagination.p4 li .page-numbers:before{
  opacity: 0;
    content: "";
    width: 30px;
    height: 30px;
    border-radius: 100%;
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%,-50%);
    -webkit-transition: all .4s;
    -moz-transition: all .4s;
    transition: all .4s
}

  .bodycommerce-pagination.p4 li .page-numbers.current:before{
    opacity: 1;
    content: "";
    width: 30px;
    height: 30px;
    border-radius: 100%;
    background-color: '. $pagination_primary_color . '!important;
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%,-50%);
  }

  .bodycommerce-pagination.p4 li .page-numbers:hover::before{
    opacity: 1;
      background-color: '. $pagination_primary_color_hover . '!important;
  }

  /* FIVE */

  .bodycommerce-pagination.p5 li .page-numbers{
    width: 30px;
    height: 5px;
    padding: 0;
    margin: auto 5px;
    background-color: ' .$pagination_secondary_color. '!important;
  }

  .bodycommerce-pagination.p5 li .page-numbers.current{
    background-color: '. $pagination_primary_color . ';
    color: '.$quantity_active_text_color.'!important;
  }

    .bodycommerce-pagination.p5 li .page-numbers:hover {
      background-color: '. $pagination_primary_color_hover . ';
      color: '.$quantity_active_text_color.'!important;
    }

  .bodycommerce-pagination.p5 li .page-numbers {
    font-size: 0;
  }

  .bodycommerce-pagination.p5 li:first-child, .bodycommerce-pagination.p5 li:last-child {
    display: none;
  }

  /* SIX */

  .bodycommerce-pagination.p6 li .page-numbers{
    width: 30px;
    height: 30px;
    border-radius: 100%;
    padding: 0;
    margin: auto 5px;
    text-align: center;
    position: relative;
    background-color: ' .$pagination_secondary_color. ';
  }

  .bodycommerce-pagination.p6 li .page-numbers.current{
    background-color: '. $pagination_primary_color . ';
    color: '.$quantity_active_text_color.'!important;
  }

  .bodycommerce-pagination.p6 li .page-numbers:hover{
    background-color: '. $pagination_primary_color_hover . ' !important;
  }

  .bodycommerce-pagination.p6 li .page-numbers {
    font-size: 0;
  }

  .bodycommerce-pagination.p6 li:first-child, .bodycommerce-pagination.p6 li:last-child {
    display: none;
  }

  /* SEVEN */

  .bodycommerce-pagination.p7 li .page-numbers{
    border: 3px solid '. $pagination_primary_color . ';
    margin: auto 5px;
    color: '. $pagination_primary_color . '!important;
    font-weight: bold;
  }

  .bodycommerce-pagination.p7 li .page-numbers.current{
    background-color: '. $pagination_primary_color . ';
    color: '.$quantity_active_text_color.'!important;
  }

  .bodycommerce-pagination.p7 li .page-numbers:hover {
    background-color: '. $pagination_primary_color_hover . ';
    color: '.$quantity_active_text_color.'!important;
  }

  /* EIGHT */

  .bodycommerce-pagination.p8 a{
    padding: 10px 18px;
    text-align: center;
    margin: auto 5px;
  }

  .bodycommerce-pagination.p8 li .page-numbers {
  border-radius: 100%;
  }

  .bodycommerce-pagination.p8 li .page-numbers.current{
    border: 3px solid '. $pagination_primary_color . ';
    border-radius: 100%;
    color: '.$quantity_active_text_color.'!important;
  }

  .bodycommerce-pagination.p8 li .page-numbers:hover {
          border: 3px solid '. $pagination_primary_color_hover . ';
          color: '.$quantity_active_text_color.'!important;
      }

  /* NINE */

  .bodycommerce-pagination.p9 a{
    padding: 10px 18px;
    text-align: center;
    margin: auto 5px;
  }

  .bodycommerce-pagination.p9 li .page-numbers.current{
    border: 3px solid '. $pagination_primary_color . ';
    color: '.$quantity_active_text_color.'!important;
  }

  .bodycommerce-pagination.p9 li .page-numbers:hover {
          border: 3px solid '. $pagination_primary_color_hover . ';
          color: '.$quantity_active_text_color.'!important;
      }

  /* TEN */

  .bodycommerce-pagination.p10 li .page-numbers{
    background-color: '. $pagination_primary_color . ';
    margin: 5px;
    color: #fff !important;
    border: 3px solid '. $pagination_primary_color . ';
    position: relative;
  }

  .bodycommerce-pagination.p10 li:first-of-type .page-numbers.prev:before{
    content: "";
    position: absolute;
    left: -15.5px;
    border-top: 26px solid transparent;
    border-bottom: 26px solid transparent;
    border-right: 26px solid '. $pagination_primary_color . ';
    top: 50%;
  }

  .bodycommerce-pagination.p10 li:last-of-type .page-numbers.next:after{
    content: "";
    position: absolute;
    top: -3px;
    right: -29px;
    border-top: 26px solid transparent;
    border-bottom: 26px solid transparent;
    border-left: 26px solid '. $pagination_primary_color . ';
  }

  .bodycommerce-pagination.p10 li .page-numbers.current{
    font-weight: bold;
    background-color: transparent;
    color: inherit;
    color: '.$quantity_active_text_color.'!important;
  }



  .bodycommerce-pagination.p10 li .page-numbers:hover{
      font-weight: bold;
      background-color: transparent;
      color: inherit;
      color: '.$quantity_active_text_color.'!important;
        border-color: '. $pagination_primary_color_hover . ' !important;
  }

  .bodycommerce-pagination.p10.arrows .next:before {
    display: none;
  }

  .bodycommerce-pagination.p10.arrows .prev, .bodycommerce-pagination.p10.arrows .next {
    font-size: inherit !important;
    top: 0;
  }


  /* ELEVEN */

  .bodycommerce-pagination.p11 li:first-of-type .page-numbers, .bodycommerce-pagination.p11 li:last-of-type .page-numbers, .bodycommerce-pagination.p11 li .page-numbers.current{
    background-color: '. $pagination_primary_color . ';
      font-weight: bold;
  }

    .bodycommerce-pagination.p11 li .page-numbers.current{
  color: '.$quantity_active_text_color.'!important;
}


    .bodycommerce-pagination.p11 li .page-numbers:hover{
      background-color: '. $pagination_primary_color_hover . ';
      color: '.$quantity_active_text_color.'!important;
      font-weight: bold;
}
  ';

  $css_pagination .= '</style>';
  //minify it
  $css_pagination_min = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_pagination );
  echo $css_pagination_min;
}

// CUSTOM PAGINATION JS
add_action('wp_footer','pagination_js');

function pagination_js() {
  ?>
<script>jQuery(document).ready(function( $ ) {$(document).on("click", 'li .page-numbers', function() {$("li .page-numbers").removeClass("current");$(this).addClass("current");});});</script>
<?php
}
?>
