<?php
if ( ! defined( 'ABSPATH' ) ) exit;
/*
Plugin Name: Divi Mobile
Plugin URL: https://diviengine.com
Description: Take your mobile menu to the next level using Divi Mobile.
Version: 1.8.2
Author: Divi Engine
Author URI: https://diviengine.com
License:     GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
@author      diviengine.com
@copyright   2019 diviengine.com

DE_DMM_P: d_e | m_a

I pray that you bless the people who interact and who own this website - I pray the blessing to be one that goes beyond worldly treasures but understanding the deep love you have for them.

John 14:6
I am the way, and the truth, and the life. No one comes to the Father except through me.
*/


define('DE_DM_VERSION', '1.8.2');


define('DE_DM_PATH', plugin_dir_path(__FILE__));
define('DE_DM_URL', plugins_url('', __FILE__));
define('DE_DM_APP_API_URL', 'https://diviengine.com/index.php');
define('DE_DM_PRODUCT_ID', 'WP-DE-DM');
define('DE_DM_INSTANCE', str_replace(array ("https://" , "http://"), "", home_url()));
define('DE_M_P', 'd_e');

include(DE_DM_PATH . '/functions.php');
include(DE_DM_PATH . '/includes/menu-styles.php');

include(DE_DM_PATH . '/includes/classes/class.wooslt.php');
include(DE_DM_PATH . '/includes/classes/class.licence.php');
include(DE_DM_PATH . '/includes/classes/class.options.php');
include(DE_DM_PATH . '/includes/classes/class.updater.php');


function divi_mobile_enqueue_scripts() {
    wp_enqueue_style('divi-mobile-stop-stacking', plugins_url( '/css/divi-mobile-stop-stacking.min.css', __FILE__ ));
    wp_register_script( 'divi-mobile-vb-js', '', array("jquery"), '', true );
    wp_enqueue_script( 'divi-mobile-vb-js'  );
    wp_add_inline_script( 'divi-mobile-vb-js', 'jQuery(".divi-mobile-stop-stacking").closest(".et_pb_row").addClass("divi-mobile-stop-stacking-row");');
}
add_action( 'wp_enqueue_scripts', 'divi_mobile_enqueue_scripts' );

add_action( 'admin_enqueue_scripts', 'load_divi_mobile_js' , 11);
          function load_divi_mobile_js($hook_suffix) {
          $jsfile = plugins_url( 'js/dm-admin.js', __FILE__ );
          wp_enqueue_script( 'divi-mobile-admin-js', $jsfile, array( 'jquery' ), DE_DM_VERSION );
       }

add_action( 'admin_enqueue_scripts', 'load_divi_engine_style_divi_mobile' , 20);
function load_divi_engine_style_divi_mobile() {
$cssfile = plugins_url( 'css/divi-mobile-menu.css', __FILE__ );
$cssfile2 = plugins_url( 'css/divi-engine.css', __FILE__ );

 wp_enqueue_style( 'divi_engine_mobile_menu_style', $cssfile , false, DE_DM_VERSION );
 wp_enqueue_style( 'divi_engine_style', $cssfile2 , false, DE_DM_VERSION );
}

/*add_action( 'et_builder_ready', 'Divi_mobile_Stop_Stacking_Custom_Module');

function Divi_mobile_Stop_Stacking_Custom_Module(){
    if(class_exists("ET_Builder_Module")){
       include("includes/modules/divi-mobile-stop-stacking-module.php");
    }
}*/

function divimobile_initialize_extension() {
  require_once plugin_dir_path( __FILE__ ) . 'includes/DiviMobile.php';
}
add_action( 'divi_extensions_init', 'divimobile_initialize_extension' );

add_action('wp_footer', 'dm_stop_stacking_js');
function dm_stop_stacking_js(){
  ?>
  <script>
jQuery(function($){$(".divi-mobile-stop-stacking").each(function(){$(this).parents(".et_pb_row").addClass("divi-mobile-stop-stacking-row")})});
  </script>
  <?php
}


register_uninstall_hook( __FILE__, 'dm_uninstall_hook' );
register_deactivation_hook( __FILE__, 'dm_deactivation_hook' );

function dm_uninstall_hook() {
}

function dm_deactivation_hook() {
delete_option( 'divi-engine-menu' );
delete_option( 'divi-engine-css' );
  delete_option( 'divi-mobile-menu_options' );
}


function divi_mobile_tb_menu( $atts ){
  include(DE_DM_PATH . '/titan-framework/titan-framework-embedder.php');
  $titan = TitanFramework::getInstance( 'divi-mobile-menu' );
  $check_mobile_menu_layout = $titan->getOption( 'set_mobile_menu_layout' );
  $set_mobile_menu_second_menu = $titan->getOption( 'set_mobile_menu_second_menu' );
  $expand_shape_style = $titan->getOption( 'expand_shape_style' );
  $divi_mobile_header_style = $titan->getOption( 'divi_mobile_header_style' );
  ob_start();



 if ($divi_mobile_header_style == "1") { 
?><div class="dm_tb_shortcode"> <?php
if ($check_mobile_menu_layout == "off-canvas") {
  include_once(DE_DM_PATH . '/includes/inject/off-canvas/head.php');
} else if ($check_mobile_menu_layout == "expand-shape") {
  if ($expand_shape_style == "top-expand") {
    include_once(DE_DM_PATH . '/includes/inject/expand-shape/top-expand/head.php');
  }
  else if ($expand_shape_style == "circle-expand") {
    include_once(DE_DM_PATH . '/includes/inject/expand-shape/circle-expand/head.php');
  }
  else if ($expand_shape_style == "circle-stretch") {
    include_once(DE_DM_PATH . '/includes/inject/expand-shape/circle-stretch/head.php');
  }
} else if ($check_mobile_menu_layout == "bottom-nav") {
  include_once(DE_DM_PATH . '/includes/inject/bottom-nav/simple/head.php');
}

if ($set_mobile_menu_second_menu == "bottom-nav") {
  include_once(DE_DM_PATH . '/includes/inject/bottom-nav/simple/head.php');
}
?></div> <?php
} else {
  ?><div class="dm_tb_shortcode">
  Please make sure you are not using our custom header option and enabled theme builder setting. See here for more information: https://help.diviengine.com/article/155-using-divi-mobile-in-the-theme-builder
</div> <?php
}
return ob_get_clean();
}
add_shortcode( 'divi_mobile_tb_menu', 'divi_mobile_tb_menu' );

if ( !function_exists('divi_mobile_axtions_ajax')) {
  function divi_mobile_axtions_ajax( $actions ) {
      $actions[] = 'dm_inject_layout_submenu_handler';
      $actions[] = 'get_dm_inject_submenu_layouts';

      return $actions;
  }

  add_filter( 'et_builder_load_actions', 'divi_mobile_axtions_ajax' );
}

global $DE_DMOBILE;
$DE_DMOBILE = new DE_DMOBILE()
?>
