<?php
if ( ! defined( 'ABSPATH' ) ) exit;
  include('titan-framework/titan-framework-embedder.php');

function divi_mobile_menu_settings() {



  $titan = TitanFramework::getInstance( 'divi-mobile-menu' );


/////////////////////////////////////////
/////////////////////////////////////////
$get_divi_engine_menu = get_option('divi-engine-menu', null);
if ($get_divi_engine_menu == "" || $get_divi_engine_menu == "mobile-menu-added" ) {
  update_option('divi-engine-menu', 'mobile-menu-added');
  $titan = TitanFramework::getInstance( 'divi-mobile-menu' );
$icon = plugins_url( 'images/dash-icon.svg', __FILE__ );
$admin_panel2 = $titan->createAdminPanel( array( 'name' => 'Divi Engine', 'capability' => 'manage_options' , 'icon' => $icon . '' , 'id' => 'divi-engine',) );
$welcometab = $admin_panel2->createTab(array('name' => 'Welcome',));
        $welcometab->createOption(array(
            'name' => esc_html__( 'Welcome to Divi Engine'),
            'type' => 'heading',
        ));

        $welcometab->createOption(array(
            'type' => 'note',
            'desc' => '<iframe class="nitro_videos" width="560" height="315" src="https://www.youtube.com/embed/jKio-EA4I0k" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>'
        ));

        $welcometab->createOption(array(
            'name' => esc_html__( 'Support'),
            'type' => 'heading',
        ));
        $welcometab->createOption(array(
            'type' => 'note',
            'desc' => esc_html__( 'We know that when building a website things may not always go according to plan. If you experience issues when using Divi Nitro do not worry we are here to help. First take a look at our documentation ').'<a href="https://help.diviengine.com/ " target="_blank">'. esc_html__( 'here') .'</a>'. esc_html__( ' and if you cannot find a solution, please contact us ').' <a href="https://diviengine.com/support/" target="_blank">'. esc_html__( 'here').'</a>'. esc_html__( ' and we will help you resolve any issues.'),
        ));
        $welcometab->createOption(array(
            'name' => 'Feedback',
            'type' => 'heading',
        ));
        $welcometab->createOption(array(
            'type' => 'note',
            'desc' => esc_html__( 'We would love to hear from you, good or bad! We would really appreciate it if you could leave a review on our product page so that it helps others!')
        ));

        $welcometab->createOption(array(
            'name' => esc_html__( 'Do you have idea?'),
            'type' => 'heading',
        ));
        $welcometab->createOption(array(
            'type' => 'note',
            'desc' => esc_html__( 'If you have an idea for how to improve Divi Nitro, please dont hesitate to contact us ') .'<a href="https://diviengine.com/contact/" target="_blank">'. esc_html__( 'here') .'</a>'. esc_html__( ' as we really want to make Divi Nitro better for everyone!')
        ));
}
else {
  # code...
}
/////////////////////////////////////////
/////////////////////////////////////////



// $mobile_panel = $titan->createAdminPanel( array( 'name' => 'Divi Mobile', 'id' => 'divi-mobile', 'parent' => 'divi-engine', 'position' => '9',) );
//


$menu_style = $titan->createThemeCustomizerSection( array(
    'name' => 'General Settings',
    'panel' => 'Divi Mobile',
) );

$custom_header = $titan->createThemeCustomizerSection( array(
    'name' => 'Custom Header',
    'panel' => 'Divi Mobile',
) );

$burger_menu = $titan->createThemeCustomizerSection( array(
    'name' => 'Burger Menu',
    'panel' => 'Divi Mobile',
) );

$inject = $titan->createThemeCustomizerSection( array(
    'name' => 'Inject Layouts',
    'panel' => 'Divi Mobile',
) );

$menu_appearance = $titan->createThemeCustomizerSection( array(
    'name' => 'Menu Style',
    'panel' => 'Divi Mobile',
) );

$submenu = $titan->createThemeCustomizerSection( array(
    'name' => 'Sub-Menu Style',
    'panel' => 'Divi Mobile',
) );

$circle_stretch = $titan->createThemeCustomizerSection( array(
    'name' => 'Circle Stretch Down Style',
    'panel' => 'Divi Mobile',
) );

$bottom_nav = $titan->createThemeCustomizerSection( array(
    'name' => 'Bottom Navigation Style',
    'panel' => 'Divi Mobile',
) );

$fullscreenmenu = $titan->createThemeCustomizerSection( array(
    'name' => 'Fullscreen Menu Style',
    'panel' => 'Divi Mobile',
) );

$menu_style->createOption( array(
  'name' => ''.esc_html__( 'Premade Menu Styles', 'divi-mobile' ).'',
  'id' => 'divi_mobile_presets',
  'type' => 'select',
  'default' => "none",
  'options' => array(
  'none' => ''.esc_html__( 'None', 'divi-mobile' ).'',
  'reset' => ''.esc_html__( 'Reset to Defaults', 'divi-mobile' ).'',
  'style-1' => ''.esc_html__( 'Style 1', 'divi-mobile' ).'',
  'style-2' => ''.esc_html__( 'Style 2', 'divi-mobile' ).'',
  'style-3' => ''.esc_html__( 'Style 3', 'divi-mobile' ).'',
  'style-4' => ''.esc_html__( 'Style 4', 'divi-mobile' ).'',
  'style-5' => ''.esc_html__( 'Style 5', 'divi-mobile' ).'',
  'style-6' => ''.esc_html__( 'Style 6', 'divi-mobile' ).'',
  ),
  'desc' =>  ''.esc_html__( 'Select a premade menu style. To view the avaliable styles click', 'divi-mobile' ).' - <a href="https://diviengine.com/plugin-features/premade-menu-styles/" target="_blank"> '.esc_html__( ' HERE.', 'divi-mobile' ).'</a>',
  'livepreview' => '

  ',
  ) );

  // $menu_style->createOption( array(
  //   'name' => ''.esc_html__( 'Presets Code', 'divi-mobile' ).'',
  //   'id' => 'divi_mobile_presets_code',
  //   'type' => 'textarea',
  //   'default' => "none",
  //   'livepreview' => '',
  //   ) );

$menu_style->createOption( array(
'name' => ''.esc_html__( 'Preview Mode', 'divi-mobile' ).'',
'id' => 'divi_mobile_mobile_preview',
'type' => 'select',
'default' => "dm-mobile",
'options' => array(
'dm-desktop' => ''.esc_html__( 'Desktop', 'divi-mobile' ).'',
'dm-tablet' => ''.esc_html__( 'Tablet', 'divi-mobile' ).'',
'dm-mobile' => ''.esc_html__( 'Mobile', 'divi-mobile' ).'',
),
'desc' =>  ''.esc_html__( 'Change the preview mode.', 'divi-mobile' ).'',
) );


$nav_menus_options = array();

$nav_menus = wp_get_nav_menus( array( 'orderby' => 'name' ) );
  $nav_menus_options[ "primary-menu" ] = "Default";
foreach ( (array) $nav_menus as $_nav_menu ) {
  $nav_menus_options[ $_nav_menu->term_id ] = $_nav_menu->name;
}
$menu_style->createOption( array(
'name' => ''.esc_html__( 'Mobile Header Style', 'divi-mobile' ).'',
'id' => 'divi_mobile_header_style',
'type' => 'enable',
'default' => 'disabled',
'enabled' => ''.esc_html__( 'Divi Theme Builder', 'divi-mobile' ).'',
'disabled' => ''.esc_html__( 'Divi Mobile', 'divi-mobile' ).'',
'desc' =>  ''.esc_html__( 'You have two options for how you want to create your mobile header. Your choices are the Divi Theme Builder or Divi Mobile. Divi Mobile allows you to create your header using the default Divi header or with our custom header builder. If you want to use the Divi Theme Builder then you need to add our shortcode [divi_mobile_tb_menu] into the Theme Builder. In addition, make sure you disable the Divi Mobile custom header.', 'divi-mobile' ).'',
) );

$menu_style->createOption( array(
	'name' => ''.esc_html__( 'Mobile Header location', 'divi-mobile' ).'',
	'id' => 'divi_mobile_header_location',
	'type' => 'enable',
	'default' => 'disabled',
	'enabled' => ''.esc_html__( 'Divi - Before Main Content', 'divi-mobile' ).'',
	'disabled' => ''.esc_html__( 'WP Head', 'divi-mobile' ).'',
	'desc' =>  ''.esc_html__( 'The best place to put the menu is in "wp_head" but you can see some issues with styles with Divi Button or other modules with injected layouts. In this case we suggest "Divi - Before Main Content"', 'divi-mobile' ).'',
) );

$menu_style->createOption( array(
  'name' => ''.esc_html__( 'Remove Space', 'divi-mobile' ).'',
  'id' => 'divi_mobile_header_remove_space',
  'type' => 'enable',
  'default' => 'disabled',
  'enabled' => ''.esc_html__( 'YES', 'divi-mobile' ).'',
  'disabled' => ''.esc_html__( 'NO', 'divi-mobile' ).'',
  'desc' =>  ''.esc_html__( 'Enable this to remove the space that might appear at the top of the page when using the theme builder.', 'divi-mobile' ).'',
  ) );

$menu_style->createOption( array(
'name' => ''.esc_html__( "Select Primary Menu", 'divi_mobile_settings' ).'',
'id' => 'set_mobile_menu',
'type' => 'select',
'options' => $nav_menus_options,
'default' => 'primary-menu',
'desc' => ''.esc_html__( "If you change this setting you may need to publish and reload the page for the preview to work.", 'divi_mobile_settings' ).'',
) );

$menu_style->createOption( array(
'name' => ''.esc_html__( "Select Primary Menu Movement", 'divi_mobile_settings' ).'',
'id' => 'set_mobile_menu_layout',
'type' => 'select',
'options' => array(
'off-canvas' => ''.esc_html__( "Expand from outside screen", 'divi_mobile_settings' ).'',
'expand-shape' => ''.esc_html__( "Expand from shape", 'divi_mobile_settings' ).'',
'bottom-nav' => ''.esc_html__( "Bottom Navigation", 'divi_mobile_settings' ).'',
),
'default' => 'off-canvas',
'desc' => ''.esc_html__( "If you change this setting you may need to publish and reload the page for the preview to work.", 'divi_mobile_settings' ).'',
) );

$menu_style->createOption( array(
'name' => ''.esc_html__( "Expand from outside screen style", 'divi_mobile_settings' ).'',
'id' => 'off_canvas_style',
'type' => 'select',
'options' => array(
'side-slide' => ''.esc_html__( "Side Slide", 'divi_mobile_settings' ).'',
'top-side' => ''.esc_html__( "Top Side", 'divi_mobile_settings' ).'',
'elastic' => ''.esc_html__( "Elastic", 'divi_mobile_settings' ).'',
'full-screen' => ''.esc_html__( "FullScreen Slide Down", 'divi_mobile_settings' ).'',
'fullscreen-fade' => esc_html__( "FullScreen Fade", 'divi_mobile_settings' ),
'divi-engine' => ''.esc_html__( "Divi Engine Style", 'divi_mobile_settings' ).'',
),
'default' => 'side-slide',
) );

$menu_style->createOption( array(
'name' => ''.esc_html__( "Expand from shape style", 'divi_mobile_settings' ).'',
'id' => 'expand_shape_style',
'type' => 'select',
'options' => array(
// 'top-expand' => ''.esc_html__( "Square expand", 'divi_mobile_settings' ).'',
'circle-expand' => ''.esc_html__( "Circle expand", 'divi_mobile_settings' ).'',
'circle-stretch' => ''.esc_html__( "Circle stretch down", 'divi_mobile_settings' ).'',
),
'default' => 'circle-expand',
) );


$menu_style->createOption( array(
'name' => ''.esc_html__( "Bottom navigation menu style", 'divi_mobile_settings' ).'',
'id' => 'bottom_nav_style',
'type' => 'select',
'options' => array(
'simple' => ''.esc_html__( "Simple Icons", 'divi_mobile_settings' ).'',
),
'default' => 'simple',
) );

$menu_style->createOption( array(
'name' => ''.esc_html__( "Select Secondary Menu Style", 'divi_mobile_settings' ).'',
'id' => 'set_mobile_menu_second_menu',
'type' => 'select',
'options' => array(
'none' => ''.esc_html__( "None", 'divi_mobile_settings' ).'',
'bottom-nav' => ''.esc_html__( "Bottom Navigation", 'divi_mobile_settings' ).'',
),
'default' => 'none',
'desc' => ''.esc_html__( "If you have a second menu that you would like to show then select it here.", 'divi_mobile_settings' ).'',
) );

$menu_style->createOption( array(
'name' => ''.esc_html__( "Select Secondary Menu", 'divi_mobile_settings' ).'',
'id' => 'set_mobile_menu_second',
'type' => 'select',
'options' => $nav_menus_options,
'default' => 'primary-menu',
'desc' => ''.esc_html__( "If you change this setting you may need to publish and reload the page for the preview to work.", 'divi_mobile_settings' ).'',
) );


$menu_style->createOption( array(
'name' => ''.esc_html__( "Divi Mobile Break Point", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__breakpoint',
'type' => 'number',
'default' => '980',
'min' => '0',
'max' => '5000',
'step' => '1',
'unit' => 'px',
'desc' => ''.esc_html__( 'Choose the screen width for when you would like your mobile menu to appear. Increase the width to make your mobile menu appear on desktop.', 'divi-mobile' ).'',
) );

$menu_style->createOption( array(
'name' => ''.esc_html__( "Fixed or Not Fixed Menu", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_fixed_not',
'type' => 'select',
'options' => array(
'fixed' => ''.esc_html__( "Fixed", 'divi_mobile_settings' ).'',
'notfixed' => ''.esc_html__( "Not Fixed", 'divi_mobile_settings' ).'',
),
'default' => 'fixed',
) );

$menu_style->createOption( array(
  'name' => ''.esc_html__( 'Keep Divi Mobile header when theme builder has it disabled?', 'divi-mobile' ).'',
  'id' => 'divi_mobile_disable_theme_builder',
  'type' => 'enable',
  'default' => 'disabled',
  'enabled' => ''.esc_html__( 'YES', 'divi-mobile' ).'',
  'disabled' => ''.esc_html__( 'NO', 'divi-mobile' ).'',
  'desc' =>  ''.esc_html__( 'If you are using the theme builder to disable your header on specific pages or posts then click the NO button to hide your menu. Click YES to keep it visible.', 'divi-mobile' ).'',
  ) );

  $menu_style->createOption( array(
    'name' => ''.esc_html__( 'Enable Fixed Header CSS Class', 'divi-mobile' ).'',
    'id' => 'divi_mobile_fixed_header_css',
    'type' => 'enable',
    'default' => 'disabled',
    'enabled' => ''.esc_html__( 'YES', 'divi-mobile' ).'',
    'disabled' => ''.esc_html__( 'NO', 'divi-mobile' ).'',
    'desc' =>  ''.esc_html__( 'Enable this if you want us to add the class "dm-fixed-header" on scroll.', 'divi-mobile' ).'',
    ) );
    $menu_style->createOption( array(
      'name' => ''.esc_html__( "Fixed Header CSS Scroll Distance", 'divi_mobile_settings' ).'',
      'id' => 'divi_mobile_fixed_header_css_distace',
      'type' => 'number',
      'default' => '300',
      'min' => '0',
      'max' => '1500',
      'step' => '1',
      'unit' => '',
      'livepreview' => '',
      'desc' =>  ''.esc_html__( 'Set the distance in pixels you want the user to scroll before adding this fixed header CSS class', 'divi-mobile' ).'',
      ) );

// $menu_style->createOption( array(
// 'name' => ''.esc_html__( "Header Settings", 'divi_mobile_settings' ).'',
// 'type' => 'heading',
// ) );

$custom_header->createOption( array(
'name' => ''.esc_html__( 'Create a custom header', 'divi-mobile' ).'',
'id' => 'divi_mobile_custom_header',
'type' => 'enable',
'default' => 'disabled',
'enabled' => ''.esc_html__( 'YES', 'divi-mobile' ).'',
'disabled' => ''.esc_html__( 'NO', 'divi-mobile' ).'',
'desc' =>  ''.esc_html__( 'Disable the default Divi header and create your own.', 'divi-mobile' ).'',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Custom Header", 'divi_mobile_settings' ).'',
'type' => 'heading',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Custom Header Logo", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_logo',
'type' => 'upload',
'desc' =>  ''.esc_html__( 'Upload your logo here.', 'divi-mobile' ).'',
// 'livepreview' => '$("#dm-header").css("height", value + "px");',
) );

$custom_header->createOption( array(
  'name' => ''.esc_html__( "Logo Alt Text", 'divi_mobile_settings' ).'',
  'id' => 'divi_mobile_custom_header_logo_alt_text',
  'type' => 'text',
  'default' => '',
  ) );

  $custom_header->createOption( array(
    'name' => ''.esc_html__( "Logo Title Text", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_logo_title_text',
    'type' => 'text',
    'default' => '',
    ) );
$custom_header->createOption( array(
    'name' => ''.esc_html__( "Logo Title Color", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_logo_title_color',
    'type' => 'color',
    'default' => '#ffffff',
    'alpha'  => 'true',
    'livepreview' => '$("#dm-logo").css("color", value);',
) );

$custom_header->createOption( array(
    'name' => ''.esc_html__( "Logo Title Font Size", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_logo_title_font_size',
    'type' => 'number',
    'default' => '14',
    'min' => '1',
    'max' => '50',
    'step' => '1',
    'unit' => 'px',
    'livepreview' => '$("#dm-logo").css("font-size", value + "px");',
) );

$custom_header->createOption( array(
    'name' => ''.esc_html__( "Logo Title Font Style", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_logo_title_font_style',
    'type' => 'select',
    'options' => array(
        'inherit' => ''.esc_html__( "Inherit", 'divi_mobile_settings' ).'',
        'initial' => ''.esc_html__( "Initial", 'divi_mobile_settings' ).'',
        'italic' => ''.esc_html__( "Italic", 'divi_mobile_settings' ).'',
        'normal' => ''.esc_html__( "Normal", 'divi_mobile_settings' ).'',
        'oblique' => ''.esc_html__( "Oblique", 'divi_mobile_settings' ).'',
        'revert' => ''.esc_html__( "Revert", 'divi_mobile_settings' ).'',
        'revert-layer' => ''.esc_html__( "Revert layer", 'divi_mobile_settings' ).'',
        'unset' => ''.esc_html__( "Unset", 'divi_mobile_settings' ).'',
    ),
    'default' => 'inherit',
) );

$custom_header->createOption( array(
    'name' => ''.esc_html__( "Logo Title Font Weight", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_logo_title_font_weight',
    'type' => 'select',
    'options' => array(
        'bold' => ''.esc_html__( "Bold", 'divi_mobile_settings' ).'',
        'bolder' => ''.esc_html__( "Bolder", 'divi_mobile_settings' ).'',
        'inherit' => ''.esc_html__( "Inherit", 'divi_mobile_settings' ).'',
        'initial' => ''.esc_html__( "Initial", 'divi_mobile_settings' ).'',
        'lighter' => ''.esc_html__( "Lighter", 'divi_mobile_settings' ).'',
        'normal' => ''.esc_html__( "Normal", 'divi_mobile_settings' ).'',
        'revert' => ''.esc_html__( "Revert", 'divi_mobile_settings' ).'',
        'revert-layer' => ''.esc_html__( "Revert layer", 'divi_mobile_settings' ).'',
        'unset' => ''.esc_html__( "Unset", 'divi_mobile_settings' ).'',
    ),
    'default' => 'inherit',
) );

$custom_header->createOption( array(
    'name' => ''.esc_html__( "Logo Title Letter Spacing", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_logo_title_letter_spacing',
    'type' => 'number',
    'default' => '0',
    'min' => '0',
    'max' => '15',
    'step' => '1',
    'unit' => 'px',
    'livepreview' => '$("#dm-logo").css("letter-spacing", value + "px");',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Custom Header Logo on Scroll", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_logo_scroll',
'type' => 'upload',
'desc' =>  ''.esc_html__( 'Upload your logo on scroll here.', 'divi-mobile' ).'',
// 'livepreview' => '$("#dm-header").css("height", value + "px");',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Custom Header Height", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_height',
'type' => 'number',
'default' => '80',
'min' => '0',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '$("#dm-header").css("height", value + "px");',
) );

$custom_header->createOption( array(
  'name' => ''.esc_html__( "Logo Height", 'divi_mobile_settings' ).'',
  'id' => 'divi_mobile_custom_header_logo_height_fixed',
  'desc' =>  ''.esc_html__( 'If you want to have a fixed height, define it here. If it is 0, we will not add a fixed height and instead be determined by max-height.', 'divi-mobile' ).'',
  'type' => 'number',
  'default' => '0',
  'min' => '0',
  'max' => '1000',
  'step' => '1',
  'unit' => 'px',
  'livepreview' => 'if (value !== "0") {$("#dm-header #dm-logo, #dm-header .svg-logo").css("height", value + "px");}',
  ) );
  
  $custom_header->createOption( array(
  'name' => ''.esc_html__( "Logo Width", 'divi_mobile_settings' ).'',
  'id' => 'divi_mobile_custom_header_logo_width_fixed',
  'desc' =>  ''.esc_html__( 'If you want to have a fixed width, define it here. If it is 0, we will not add a fixed width and instead be determined by max-width.', 'divi-mobile' ).'',
  'type' => 'number',
  'default' => '0',
  'min' => '0',
  'max' => '1000',
  'step' => '1',
  'unit' => 'px',
  'livepreview' => 'if (value !== "0") {$("#dm-header #dm-logo, #dm-header .svg-logo").css("width", value + "px");}',
  ) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Logo Max Height", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_logo_height',
'type' => 'number',
'default' => '60',
'min' => '0',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '$("#dm-header #dm-logo, #dm-header .svg-logo").css("max-height", value + "px");',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Logo Max Width", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_logo_max_width',
'type' => 'number',
'default' => '1000',
'min' => '0',
'max' => '1000',
'step' => '1',
'unit' => 'px',
'livepreview' => '$("#dm-header #dm-logo, #dm-header .svg-logo").css("max-width", value + "px");',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Custom Header background Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_bg_color',
'type' => 'color',
'default' => '#ffffff',
'alpha'  => 'true',
'livepreview' => '$("#dm-header").css("background-color", value);',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Custom Header background Shadow Horizontal Length", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_header_shadow_horizontal',
'type' => 'number',
'default' => '0',
'min' => '-200',
'max' => '200',
'step' => '1',
'unit' => 'px',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Custom Header background Shadow Vertical Length", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_header_shadow_vetical',
'type' => 'number',
'default' => '6',
'min' => '-200',
'max' => '200',
'step' => '1',
'unit' => 'px',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Custom Header background Shadow Blur Radius", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_header_shadow_blur_radius',
'type' => 'number',
'default' => '30',
'min' => '0',
'max' => '300',
'step' => '1',
'unit' => 'px',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Custom Header background Shadow Spread Radius", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_header_shadow_spread_radius',
'type' => 'number',
'default' => '0',
'min' => '-200',
'max' => '200',
'step' => '1',
'unit' => 'px',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Custom Header background Shadow Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_header_shadow_colour',
'type' => 'color',
'default' => 'rgba(0,0,0,0)',
'alpha'  => 'true',
'maxlength' => 20,
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Custom Header Elements", 'divi_mobile_settings' ).'',
'type' => 'heading',
) );

$custom_header->createOption( array(
'desc' => '<h3 style="padding: 10px;font-size: 20px;text-transform: uppercase !important;background-color: #1d0d6f;color: #fff;">'.esc_html__( "Logo Settings", 'divi_mobile_settings' ).'</h3>',
'type' => 'note',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Logo Link", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_logo_link',
'type' => 'text',
'default' => '',
'desc' => 'Leave blank to have the website url or add a custom URL that you might want as the logo link.',
'livepreview' => 'console.log("changed url");',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Logo Postion", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_logo_position',
'type' => 'select',
'options' => array(
'left' => ''.esc_html__( "Left", 'divi_mobile_settings' ).'',
'none' => ''.esc_html__( "Center", 'divi_mobile_settings' ).'',
'right' => ''.esc_html__( "Right", 'divi_mobile_settings' ).'',
),
'default' => 'left',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Logo Position From Edge (does not affect center logo)", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_logo_position_edge',
'type' => 'number',
'default' => '0',
'min' => '0',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '
if ( $("body").hasClass("dm-ch-logo-pos-left") ) {
$(".dm-branding").css("left", value + "px");
  } else if ( $("body").hasClass("dm-ch-logo-pos-right") ) {
  $(".dm-branding").css("right", value + "px");
    }
    else {
    $(".dm-branding").css("left", value + "px");
      }
',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Logo Position From Top (does not affect center logo)", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_logo_position_top',
'type' => 'number',
'default' => '0',
'min' => '0',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".dm-branding").css("top", value + "px");',
) );

$custom_header->createOption( array(
'desc' => '<h3 style="padding: 10px;font-size: 20px;text-transform: uppercase !important;background-color: #1d0d6f;color: #fff;">'.esc_html__( "Cart Icon Settings", 'divi_mobile_settings' ).'</h3>',
'type' => 'note',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Cart Icon Postion", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_cart_icon_position',
'type' => 'select',
'options' => array(
'none' => ''.esc_html__( "No Cart Icon", 'divi_mobile_settings' ).'',
'left' => ''.esc_html__( "Left", 'divi_mobile_settings' ).'',
'right' => ''.esc_html__( "Right", 'divi_mobile_settings' ).'',
'inside-left' => ''.esc_html__( "Inside Menu Left", 'divi_mobile_settings' ).'',
'inside-right' => ''.esc_html__( "Inside Menu Right", 'divi_mobile_settings' ).'',
),
'default' => 'none',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Cart Icon Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_cart_icon_color',
'type' => 'color',
'default' => '#000',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>.dm-cart .et-cart-info span:before {color: " + value + ";}.cart-icon svg path {fill: " + value + ";}</style>");
',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Cart Icon Font Size", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_cart_icon_font_size',
'type' => 'number',
'default' => '18',
'min' => '0',
'max' => '60',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>.dm-cart .et-cart-info span:before {font-size: " + value + "px;}</style>");
',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Cart Icon Position From Edge", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_cart_icon_position_edge',
'type' => 'number',
'default' => '60',
'min' => '-500',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '
if ( $("body").hasClass("dm-ch-cart-icon-pos-left") || $("body").hasClass("dm-ch-cart-icon-pos-inside-left") ) {
$(".dm-cart").css("left", value + "px");
  } else if ( $("body").hasClass("dm-ch-cart-icon-pos-right") || $("body").hasClass("dm-ch-cart-icon-pos-inside-right") ) {
  $(".dm-cart").css("right", value + "px");
    }
    else {
    $(".dm-cart").css("left", value + "px");
      }
',
) );


$custom_header->createOption( array(
'name' => ''.esc_html__( "Cart Icon Position From Top", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_cart_icon_position_top',
'type' => 'number',
'default' => '20',
'min' => '-500',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".dm-cart").css("margin-top", value + "px");',
) );

$custom_header->createOption( array(
'desc' => '<h3 style="padding: 10px;font-size: 20px;text-transform: uppercase !important;background-color: #1d0d6f;color: #fff;">'.esc_html__( "Search Settings", 'divi_mobile_settings' ).'</h3>',
'type' => 'note',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Search Icon Postion", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_search_icon_position',
'type' => 'select',
'options' => array(
'none' => ''.esc_html__( "No Search Icon", 'divi_mobile_settings' ).'',
'left' => ''.esc_html__( "Left", 'divi_mobile_settings' ).'',
'right' => ''.esc_html__( "Right", 'divi_mobile_settings' ).'',
'inside-left' => ''.esc_html__( "Inside Menu Left", 'divi_mobile_settings' ).'',
'inside-right' => ''.esc_html__( "Inside Menu Right", 'divi_mobile_settings' ).'',
),
'default' => 'none',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Search Icon Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_search_icon_color',
'type' => 'color',
'default' => '#000',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>.dm-search #et_search_icon:before {color: " + value + ";}</style>");
',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Search Icon Font Size", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_search_icon_font_size',
'type' => 'number',
'default' => '18',
'min' => '0',
'max' => '60',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>.dm-search #et_search_icon:before {font-size: " + value + "px;}</style>");
',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Search Icon Position From Edge", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_search_icon_position_edge',
'type' => 'number',
'default' => '60',
'min' => '-500',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '
if ( $("body").hasClass("dm-ch-search-icon-pos-left") || $("body").hasClass("dm-ch-search-icon-pos-inside-left") ) {
$(".dm-search").css("left", value + "px");
  } else if ( $("body").hasClass("dm-ch-search-icon-pos-right") || $("body").hasClass("dm-ch-search-icon-pos-inside-right") ) {
  $(".dm-search").css("right", value + "px");
    }
    else {
    $(".dm-search").css("left", value + "px");
      }
',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Search Icon Position From Top", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_search_icon_position_top',
'type' => 'number',
'default' => '20',
'min' => '-500',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".dm-search").css("margin-top", value + "px");',
) );


$custom_header->createOption( array(
'name' => ''.esc_html__( "Search Text Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_search_text_color',
'type' => 'color',
'default' => '#000',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>.dm-search .et-search-form input, .dm-search .et-search-form input::-webkit-input-placeholder {color: " + value + ";}</style>");
',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Search Icon Text Size", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_search_text_font_size',
'type' => 'number',
'default' => '18',
'min' => '0',
'max' => '60',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>.dm-search .et-search-form input {font-size: " + value + "px;}</style>");
',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Search Icon Close Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_search_icon_close_color',
'type' => 'color',
'default' => '#000',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>.dm-search-icon-header .dm-search-box .close:before {color: " + value + ";}</style>");
',
) );

$custom_header->createOption( array(
'name' => ''.esc_html__( "Search Icon Close Size", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_custom_header_search_icon_close_font_size',
'type' => 'number',
'default' => '22',
'min' => '0',
'max' => '60',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>.dm-search-icon-header .dm-search-box .close:before {font-size: " + value + "px;}</style>");
',
) );

//////

$custom_header->createOption( array(
  'desc' => '<h3 style="padding: 10px;font-size: 20px;text-transform: uppercase !important;background-color: #1d0d6f;color: #fff;">'.esc_html__( "Account Icon Settings", 'divi_mobile_settings' ).'</h3>',
  'type' => 'note',
  ) );
  
  $custom_header->createOption( array(
  'name' => ''.esc_html__( "Account Icon Postion", 'divi_mobile_settings' ).'',
  'id' => 'divi_mobile_custom_header_account_icon_position',
  'type' => 'select',
  'options' => array(
  'none' => ''.esc_html__( "No Account Icon", 'divi_mobile_settings' ).'',
  'left' => ''.esc_html__( "Left", 'divi_mobile_settings' ).'',
  'right' => ''.esc_html__( "Right", 'divi_mobile_settings' ).'',
  ),
  'default' => 'none',
  ) );
  
  $custom_header->createOption( array(
  'name' => ''.esc_html__( "Account Icon Colour", 'divi_mobile_settings' ).'',
  'id' => 'divi_mobile_custom_header_account_icon_color',
  'type' => 'color',
  'default' => '#000',
  'alpha'  => 'true',
  'livepreview' => '
  $("head").append("<style>.dm-header-cont .dm-account span {color: " + value + " !important;}</style>");
  ',
  ) );
  
  $custom_header->createOption( array(
  'name' => ''.esc_html__( "Account Icon Font Size", 'divi_mobile_settings' ).'',
  'id' => 'divi_mobile_custom_header_account_icon_font_size',
  'type' => 'number',
  'default' => '28',
  'min' => '0',
  'max' => '60',
  'step' => '1',
  'unit' => 'px',
  'livepreview' => '
  $("head").append("<style>.dm-header-cont .dm-account span {font-size: " + value + "px !important;}</style>");
  ',
  ) );
  
  $custom_header->createOption( array(
  'name' => ''.esc_html__( "Account Icon Position From Edge", 'divi_mobile_settings' ).'',
  'id' => 'divi_mobile_custom_header_account_icon_position_edge',
  'type' => 'number',
  'default' => '120',
  'min' => '-500',
  'max' => '500',
  'step' => '1',
  'unit' => 'px',
  'livepreview' => '
  if ( $("body").hasClass("dm-ch-account-icon-pos-left") ) {
  $(".dm-account").css("left", value + "px");
    } else if ( $("body").hasClass("dm-ch-account-icon-pos-right") ) {
    $(".dm-account").css("right", value + "px");
      }
      else {
      $(".dm-account").css("left", value + "px");
        }
  ',
  ) );
  
  
  $custom_header->createOption( array(
  'name' => ''.esc_html__( "Account Icon Position From Top", 'divi_mobile_settings' ).'',
  'id' => 'divi_mobile_custom_header_account_icon_position_top',
  'type' => 'number',
  'default' => '25',
  'min' => '-500',
  'max' => '500',
  'step' => '1',
  'unit' => 'px',
  'livepreview' => '$(".dm-account").css("top", value + "px");',
  ) );


  $custom_header->createOption( array(
    'name' => ''.esc_html__( "Custom Header On Scroll", 'divi_mobile_settings' ).'',
    'type' => 'heading',
    ) );
    
    $custom_header->createOption( array(
    'name' => ''.esc_html__( 'Fixed menu on scroll?', 'divi-mobile' ).'',
    'id' => 'divi_mobile_custom_header_fixed',
    'type' => 'enable',
    'default' => true,
    'enabled' => ''.esc_html__( 'YES', 'divi-mobile' ).'',
    'disabled' => ''.esc_html__( 'NO', 'divi-mobile' ).'',
    'desc' =>  ''.esc_html__( 'Click YES if you want your custom menu to be stuck to the top of your browser.', 'divi-mobile' ).'',
    'livepreview' => '
    if (value == "1") {
    $("#dm-header, body .dm_menu_button").css("position", "fixed");
      } else {
      $("#dm-header, body .dm_menu_button").css("position", "absolute");
        }
    ',
    ) );
    
    $custom_header->createOption( array(
    'name' => ''.esc_html__( "Custom Header Height on Scroll", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_height_scroll',
    'type' => 'number',
    'default' => '60',
    'min' => '0',
    'max' => '500',
    'step' => '1',
    'unit' => 'px',
    'livepreview' => '
    $("head").append("<style>#dm-header.fixed-header {height: " + value + "px;}</style>");
    ',
    ) );
    
    $custom_header->createOption( array(
    'name' => ''.esc_html__( "Logo Max Height on Scroll", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_logo_height_scroll',
    'type' => 'number',
    'default' => '60',
    'min' => '0',
    'max' => '500',
    'step' => '1',
    'unit' => 'px',
    'livepreview' => '
    $("head").append("<style>#dm-header.fixed-header #dm-logo {max-height: " + value + "px !important;}</style>");
    ',
    ) );
    
    $custom_header->createOption( array(
    'name' => ''.esc_html__( "Burger Icon Position from Top on Scroll", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_hamburger_top_scroll',
    'type' => 'number',
    'default' => '0',
    'min' => '-100',
    'max' => '500',
    'step' => '1',
    'unit' => 'px',
    'livepreview' => '
    $("head").append("<style>.dm-fixed-header .hamburger {top: " + value + "px !important;}</style>");
    ',
    ) );
    
    $custom_header->createOption( array(
    'name' => ''.esc_html__( "Burger Icon Colour on scroll", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_burger_icon_color_scroll',
    'type' => 'color',
    'default' => 'rgba(0,0,0,0)',
    'alpha'  => 'true',
    'livepreview' => 'if (value !== "rgba(0,0,0,0)") {$("head").append("<style>.dm-fixed-header .hamburger.is-active .hamburger-inner,.dm-fixed-header .hamburger.is-active .hamburger-inner::before,.dm-fixed-header .hamburger.is-active .hamburger-inner::after {background-color: " + value + ";}.dm-fixed-header #nav-icon .dots{fill: " + value + ";}</style>");}',
    ) );
    
    $custom_header->createOption( array(
    'name' => ''.esc_html__( "Cart Icon Position from Top on Scroll", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_cart_top_scroll',
    'type' => 'number',
    'default' => '0',
    'min' => '-100',
    'max' => '500',
    'step' => '1',
    'unit' => 'px',
    'livepreview' => '
    $("head").append("<style>.dm-fixed-header .dm-cart {top: " + value + "px !important;}</style>");
    ',
    ) );
    
    $custom_header->createOption( array(
    'name' => ''.esc_html__( "Cart Icon Colour on scroll", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_cart_icon_color_scroll',
    'type' => 'color',
    'default' => 'rgba(0,0,0,0)',
    'alpha'  => 'true',
    'livepreview' => 'if (value !== "rgba(0,0,0,0)") {$("head").append("<style>.dm-fixed-header .dm-cart .et-cart-info span:before, .dm-fixed-header .cart-icon svg path{color: " + value + ";}.dm-fixed-header .cart-icon svg path {fill: " + value + ";}</style>");}',
    ) );
    
    $custom_header->createOption( array(
    'name' => ''.esc_html__( "Search Icon Position from Top on Scroll", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_search_top_scroll',
    'type' => 'number',
    'default' => '0',
    'min' => '-100',
    'max' => '500',
    'step' => '1',
    'unit' => 'px',
    'livepreview' => '
    $("head").append("<style>.dm-fixed-header .dm-search {top: " + value + "px !important;}</style>");
    ',
    ) );
    
    $custom_header->createOption( array(
    'name' => ''.esc_html__( "Search Icon Colour on scroll", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_search_icon_color_scroll',
    'type' => 'color',
    'default' => 'rgba(0,0,0,0)',
    'alpha'  => 'true',
    'livepreview' => 'if (value !== "rgba(0,0,0,0)") {$("head").append("<style>.dm-fixed-header .dm-fixed-header .dm-search:before{color: " + value + ";}</style>");}',
    ) );
    
    $custom_header->createOption( array(
    'name' => ''.esc_html__( "Account Icon Position from Top on Scroll", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_account_top_scroll',
    'type' => 'number',
    'default' => '25',
    'min' => '-100',
    'max' => '500',
    'step' => '1',
    'unit' => 'px',
    'livepreview' => '
    $("head").append("<style>.dm-fixed-header .dm-header-cont .dm-account {top: " + value + "px !important;}</style>");
    ',
    ) );
    
    $custom_header->createOption( array(
    'name' => ''.esc_html__( "Account Icon Colour on scroll", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_account_icon_color_scroll',
    'type' => 'color',
    'default' => 'rgba(0,0,0,0)',
    'alpha'  => 'true',
    'livepreview' => 'if (value !== "rgba(0,0,0,0)") {$("head").append("<style>.dm-fixed-header .dm-header-cont .dm-account span{color: " + value + " !important;}</style>");}',
    ) );
    
    $custom_header->createOption( array(
    'name' => ''.esc_html__( "Custom Header background Colour on scroll", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_custom_header_bg_color_scroll',
    'type' => 'color',
    'default' => '#ffffff',
    'alpha'  => 'true',
    'livepreview' => '
    $("head").append("<style>#dm-header.fixed-header {background-color: " + value + ";}</style>");
    ',
    ) );

//////


$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Style", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_style',
'type' => 'select',
'options' => array(
'three' => ''.esc_html__( "Three Lines", 'divi_mobile_settings' ).'',
'two' => ''.esc_html__( "Two Lines", 'divi_mobile_settings' ).'',
'three-dots' => ''.esc_html__( "Three Dots", 'divi_mobile_settings' ).'',
'custom-svg' => ''.esc_html__( "Custom SVG Code", 'divi_mobile_settings' ).'',
),
'default' => 'three',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Custom SVG Icon Code", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_custom_svg',
'type' => 'code',
'lang' => 'html',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Position on Screen", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__position',
'type' => 'select',
'options' => array(
'right' => ''.esc_html__( "Top Right", 'divi_mobile_settings' ).'',
'left' => ''.esc_html__( "Top Left", 'divi_mobile_settings' ).'',
),
'default' => 'right',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Three Lines Burger Menu Animation Style", 'divi_mobile_settings' ).'',
'id' => 'burger_menu',
'type' => 'select',
'options' => array(
'hamburger--slider' => ''.esc_html__( "Slider", 'divi_mobile_settings' ).'',
'hamburger--minus' => ''.esc_html__( "Minus", 'divi_mobile_settings' ).'',
'hamburger--squeeze' => ''.esc_html__( "Squeeze", 'divi_mobile_settings' ).'',
'hamburger--arrow' => ''.esc_html__( "Arrow", 'divi_mobile_settings' ).'',
'hamburger--arrowalt' => ''.esc_html__( "Arrow Alternative", 'divi_mobile_settings' ).'',
'hamburger--arrowturn' => ''.esc_html__( "Arrow Turn", 'divi_mobile_settings' ).'',
'hamburger--spin' => ''.esc_html__( "Spin", 'divi_mobile_settings' ).'',
'hamburger--elastic' => ''.esc_html__( "Elastic", 'divi_mobile_settings' ).'',
'hamburger--emphatic' => ''.esc_html__( "Emphatic", 'divi_mobile_settings' ).'',
'hamburger--collapse' => ''.esc_html__( "Callapse", 'divi_mobile_settings' ).'',
'hamburger--vortex' => ''.esc_html__( "Vortex", 'divi_mobile_settings' ).'',
'hamburger--stand' => ''.esc_html__( "Stand", 'divi_mobile_settings' ).'',
'hamburger--spring' => ''.esc_html__( "Spring", 'divi_mobile_settings' ).'',
'hamburger--3dx' => ''.esc_html__( "3DX", 'divi_mobile_settings' ).'',
'hamburger--3dy' => ''.esc_html__( "3DY", 'divi_mobile_settings' ).'',
'hamburger--3dxy' => ''.esc_html__( "3DXY", 'divi_mobile_settings' ).'',
'hamburger--boring' => ''.esc_html__( "Boring", 'divi_mobile_settings' ).'',
),
'default' => 'hamburger--spin',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Animation Style Direction", 'divi_mobile_settings' ).'',
'id' => 'burger_menu_style',
'type' => 'select',
'options' => array(
'normal' => ''.esc_html__( "Normal", 'divi_mobile_settings' ).'',
'reverse' => ''.esc_html__( "Reverse", 'divi_mobile_settings' ).'',
),
'default' => 'normal',
) );



$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu General", 'divi_mobile_settings' ).'',
'type' => 'heading',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Header Height If not using custom header", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_header_height',
'type' => 'number',
'default' => '80',
'min' => '0',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '$("#et-top-navigation").css("min-height", value + "px");',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Distance from Edge", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_distance_edge',
'type' => 'number',
'default' => '0',
'min' => '-500',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '
if ( $("body").hasClass("dm-bm-pos-left") ) {
$(".hamburger").css("left", value + "px");
  } else if ( $("body").hasClass("dm-bm-pos-right") ) {
  $(".hamburger").css("right", value + "px");
    }
    else {
    $(".hamburger").css("left", value + "px");
      }
',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Distance from Top", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_distance_top',
'type' => 'number',
'default' => '0',
'min' => '-500',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".hamburger").css("top", value + "px");',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Hover Opacity", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_opacity_hover',
'type' => 'number',
'default' => '0.6',
'min' => '0',
'max' => '1',
'step' => '0.1',
'livepreview' => '$(".dm_menu_button:hover").css("opacity", value);',
) );


$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Icon", 'divi_mobile_settings' ).'',
'type' => 'heading',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Closed Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_burger_colour_closed',
'type' => 'color',
'default' => '#fff',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>.hamburger-inner, .hamburger-inner::before, .hamburger-inner::after {background-color: " + value + ";}#nav-icon .dots{fill: " + value + ";}</style>");
',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Open Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_burger_colour_open',
'type' => 'color',
'default' => '#fff',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>.hamburger.is-active .hamburger-inner, .hamburger.is-active .hamburger-inner::before, .hamburger.is-active .hamburger-inner::after {background-color: " + value + ";}.show-menu #nav-icon .dots{fill: " + value + ";}</style>");
',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Icon Position from Left", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_postion',
'type' => 'number',
'default' => '16',
'min' => '-200',
'max' => '200',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".hamburger-box, #nav-icon").css("left", value + "px");',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Icon Position from Top", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_postion_top',
'type' => 'number',
'default' => '1',
'min' => '-200',
'max' => '200',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".hamburger-box, #nav-icon").css("top", value + "px");',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Line / dot Width", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_line_width',
'type' => 'number',
'default' => '27',
'min' => '0',
'max' => '50',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>.hamburger-inner, .hamburger-inner::before, .hamburger-inner::after, #nav-icon {width: " + value + "px;}</style>");
',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Line Height", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_line_height',
'type' => 'number',
'default' => '3',
'min' => '0',
'max' => '50',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>.hamburger-inner, .hamburger-inner::before, .hamburger-inner::after {height: " + value + "px;}</style>");
',) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Line Border Radius", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_line_border_radius',
'type' => 'number',
'default' => '4',
'min' => '0',
'max' => '20',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>.hamburger-inner, .hamburger-inner::before, .hamburger-inner::after {border-radius: " + value + "px;}</style>");
',) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Line Spacing", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_line_spacing',
'type' => 'number',
'default' => '8',
'min' => '0',
'max' => '50',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>.hamburger-inner::before {top: " + value + "px !important;}.hamburger-inner::after {bottom: " + value + "px !important;}</style>");
',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Text", 'divi_mobile_settings' ).'',
'type' => 'heading',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger menu text", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_text',
'type' => 'text',
'default' => '',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Text position from top", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_text_top',
'type' => 'number',
'default' => '20',
'min' => '-100',
'max' => '100',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".menu-text").css("top", value + "px");',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Text position from left", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_text_teft',
'type' => 'number',
'default' => '-25',
'min' => '-500',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".menu-text").css("left", value + "px");',
) );


$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Text font size", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_text_font_size',
'type' => 'number',
'default' => '14',
'min' => '1',
'max' => '60',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".menu-text, .menu-item").css("font-size", value + "px");',
) );



$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Text Font", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_text_font',
'type' => 'font',
'show_color' => false,
'show_font_size' => false,
'show_websafe_fonts' => true,
'fonts'=>dm_get_user_custom_fonts_from_divi_theme(),
'livepreview' => '$(".menu-text").css(value);',
'desc' => 'We do not have a live preview of the font styles. Save and reload to see it in action.'
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Text colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_text_color',
'type' => 'color',
'default' => '#1d0d6f',
'alpha'  => 'true',
'livepreview' => '$(".menu-text").css("color", value);',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Background", 'divi_mobile_settings' ).'',
'type' => 'heading',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Background Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_background_color',
'type' => 'color',
'default' => '#1d0d6f',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>.menu-wrap::before, .hamburger {background-color: " + value + ";}</style>");
',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Background Width", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_background_size_width',
'type' => 'number',
'default' => '60',
'min' => '0',
'max' => '150',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".hamburger").css("width", value + "px");',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Background Height", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_background_size_height',
'type' => 'number',
'default' => '60',
'min' => '0',
'max' => '150',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".hamburger").css("height", value + "px");',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Background Border Radius", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu__burger_menu_background_border_radius',
'type' => 'number',
'default' => '60',
'min' => '0',
'max' => '150',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".hamburger").css("border-radius", value + "px");',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Background Shadow", 'divi_mobile_settings' ).'',
'type' => 'heading',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Background Shadow Horizontal Length", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_background_box_shadow_horizontal',
'type' => 'number',
'default' => '0',
'min' => '-200',
'max' => '200',
'step' => '1',
'unit' => 'px',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Background Shadow Vertical Length", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_background_box_shadow_vetical',
'type' => 'number',
'default' => '6',
'min' => '-200',
'max' => '200',
'step' => '1',
'unit' => 'px',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Background Shadow Blur Radius", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_background_box_shadow_blur_radius',
'type' => 'number',
'default' => '30',
'min' => '0',
'max' => '300',
'step' => '1',
'unit' => 'px',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Background Shadow Spread Radius", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_background_box_shadow_spread_radius',
'type' => 'number',
'default' => '0',
'min' => '-200',
'max' => '200',
'step' => '1',
'unit' => 'px',
) );

$burger_menu->createOption( array(
'name' => ''.esc_html__( "Burger Menu Background Shadow Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_background_box_shadow_colour',
'type' => 'color',
'default' => 'rgba(0, 0, 0, 0.2)',
'alpha'  => 'true',
) );

$inject->createOption( array(
'name' => ''.esc_html__( 'Select layout to inject above the menu', 'divi-mobile' ).'',
'id' => 'inject_head',
'type' => 'select-posts',
'post_type' => 'et_pb_layout',
'desc' => ''.esc_html__( 'Leave blank or add a Divi library layout.', 'divi-mobile' ).'',
) );


$inject->createOption( array(
'name' => ''.esc_html__( 'Select layout to inject below the menu', 'divi-mobile' ).'',
'id' => 'inject_footer',
'type' => 'select-posts',
'post_type' => 'et_pb_layout',
'desc' => ''.esc_html__( 'Leave blank or add a Divi library layout.', 'divi-mobile' ).'',
) );


$inject->createOption( array(
'name' => ''.esc_html__( 'Select layout to inject above the mobile custom header', 'divi-mobile' ).'',
'id' => 'inject_above_header',
'type' => 'select-posts',
'post_type' => 'et_pb_layout',
'desc' => ''.esc_html__( 'Leave blank or add a Divi library layout.', 'divi-mobile' ).'',
) );

$inject->createOption( array(
  'name' => ''.esc_html__( 'Hide above injected layout on scroll?', 'divi-mobile' ).'',
  'id' => 'inject_above_header_scroll',
  'type' => 'enable',
  'default' => false,
  'enabled' => ''.esc_html__( 'YES', 'divi-mobile' ).'',
  'disabled' => ''.esc_html__( 'NO', 'divi-mobile' ).'',
  'desc' =>  ''.esc_html__( 'Click YES if you would like to hide your injected layout on scroll.', 'divi-mobile' ).'',
  'livepreview' => 'if (value == "1") {$(".dm-above-layout").addClass("hideonscroll");} else {$(".dm-above-layout").removeClass("hideonscroll");}',
  ) );


$inject->createOption( array(
'name' => ''.esc_html__( 'Select layout to inject below the mobile custom header', 'divi-mobile' ).'',
'id' => 'inject_below_header',
'type' => 'select-posts',
'post_type' => 'et_pb_layout',
'desc' => ''.esc_html__( 'Leave blank or add a Divi library layout.', 'divi-mobile' ).'',
) );


$submenu->createOption( array(
'name' => ''.esc_html__( "Sub-Menu Style", 'divi_mobile_settings' ).'',
'type' => 'heading',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Sub-menu Style", 'divi_mobile_settings' ).'',
'id' => 'sub_menu_style',
'type' => 'select',
'options' => array(
'collapse' => ''.esc_html__( "Collapse Nested", 'divi_mobile_settings' ).'',
'overlap-slide' => ''.esc_html__( "Overlap Slide In", 'divi_mobile_settings' ).'',
'side-by-side' => ''.esc_html__( "Side By Side", 'divi_mobile_settings' ).'',
),
'default' => 'collapse',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "If Collapse, open all by default?", 'divi-mobile' ).'',
'id' => 'collapse_open_default',
'type' => 'enable',
'default' => false,
'enabled' => ''.esc_html__( "YES", 'divi-mobile' ).'',
'disabled' => ''.esc_html__( "NO", 'divi-mobile' ).'',
'livepreview' => '',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Disable Parent Click Through", 'divi-mobile' ).'',
'id' => 'disable_parent_clickthrough',
'type' => 'enable',
'default' => true,
'enabled' => ''.esc_html__( "YES", 'divi-mobile' ).'',
'disabled' => ''.esc_html__( "NO", 'divi-mobile' ).'',
'livepreview' => '',
) );

$submenu->createOption( array(
  'name' => ''.esc_html__( "Inject Layouts into Sub-Menus?", 'divi-mobile' ).'',
  'id' => 'inject_layouts_submenu',
  'type' => 'enable',
  'default' => false,
  'enabled' => ''.esc_html__( "YES", 'divi-mobile' ).'',
  'disabled' => ''.esc_html__( "NO", 'divi-mobile' ).'',
  'livepreview' => '',
  ) );

  $submenu->createOption( array(
    'name' => ''.esc_html__( "Injected Layout Position", 'divi_mobile_settings' ).'',
    'id' => 'inject_layouts_submenu_position',
    'type' => 'select',
    'options' => array(
    'top' => ''.esc_html__( "On Top", 'divi_mobile_settings' ).'',
    'below' => ''.esc_html__( "Below", 'divi_mobile_settings' ).'',
    'remove' => ''.esc_html__( "Remove Sub-Menu", 'divi_mobile_settings' ).'',
    ),
    'default' => 'remove',
    ) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Sub-Menu Appearance", 'divi_mobile_settings' ).'',
'type' => 'heading',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Enable Border at Top", 'divi-mobile' ).'',
'id' => 'sub_menu_enable_border',
'type' => 'enable',
'default' => true,
'enabled' => ''.esc_html__( "YES", 'divi-mobile' ).'',
'disabled' => ''.esc_html__( "NO", 'divi-mobile' ).'',
'livepreview' => '
if (value == "1") {
} else {
  $(".nav li ul").css("border-top", "0px");
}
',
) );

$submenu->createOption( array(
  'name' => ''.esc_html__( "Disable Box Shadow", 'divi-mobile' ).'',
  'id' => 'sub_menu_disable_shadow',
  'type' => 'enable',
  'default' => false,
  'enabled' => ''.esc_html__( "YES", 'divi-mobile' ).'',
  'disabled' => ''.esc_html__( "NO", 'divi-mobile' ).'',
  'livepreview' => '
  if (value == "1") {
    $("#dm_nav .menu-wrap__inner ul.sub-menu").css("box-shadow", "none");
  }
  ',
  ) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Sub-Menu max-width (set the width of your sub-menu)", 'divi_mobile_settings' ).'',
'id' => 'set_mobile_sub_menu_side_max_width',
'type' => 'number',
'default' => '300',
'min' => '1',
'max' => '3000',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>.overlap-submenu #dm_nav .menu-wrap__inner .sub-menu {max-width: " + value + "px !important;}</style>");
',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Space at the top of the sub-menu", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_space_top',
'type' => 'number',
'default' => '0',
'min' => '0',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>#dm_nav .menu-wrap__inner .sub-menu {padding-top: " + value + "px !important;}</style>");
',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Sub-Menu Background Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_sub_menu_bg_color',
'type' => 'color',
'default' => 'rgba(0, 0, 0, 0.2)',
'alpha'  => 'true',
'livepreview' => '$(".nav li ul.sub-menu").css("background-color", value);',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Sub-Sub-Menu Background Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_sub_sub_menu_bg_color',
'type' => 'color',
'default' => 'rgba(0, 0, 0, 0)',
'alpha'  => 'true',
'livepreview' => '$(".nav li ul.sub-menu ul.sub-menu").css("background-color", value);',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Sub-Menu Text Font", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_text_font',
'type' => 'font',
'show_color' => false,
'show_font_size' => false,
'show_websafe_fonts' => true,
'fonts'=>dm_get_user_custom_fonts_from_divi_theme(),
'livepreview' => '$(".nav li ul.sub-menu a").css(value);',
'desc' => 'We do not have a live preview of the font styles. Save and reload to see it in action.'
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Sub-Menu Text Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_text_color',
'type' => 'color',
'default' => '#ffffff',
'alpha'  => 'true',
'livepreview' => '$(".nav li ul.sub-menu a").css("color", value);',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Sub-Menu Text Colour Hover", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_text_color_hover',
'type' => 'color',
'default' => '#efefef',
'alpha'  => 'true',
'livepreview' => '$(".nav li ul.sub-menu a:hover").css("color", value);',
) );

$submenu->createOption( array(
  'name' => ''.esc_html__( "Sub-Menu Active Menu Text Colour", 'divi_mobile_settings' ).'',
  'id' => 'divi_mobile_active_sub_menu_text_color',
  'type' => 'color',
  'default' => 'rgba(255,255,255,0)',
  'alpha'  => 'true',
  'livepreview' => '$(".nav li ul.sub-menu .current_page_item a").css("color", value);',
  ) );
  
  $submenu->createOption( array(
  'name' => ''.esc_html__( "Sub-Menu Active Menu Text Colour Hover", 'divi_mobile_settings' ).'',
  'id' => 'divi_mobile_active_sub_menu_text_color_hover',
  'type' => 'color',
  'default' => 'rgba(255,255,255,0)',
  'alpha'  => 'true',
  'livepreview' => '$(".nav li ul.sub-menu .current_page_item a:hover").css("color", value);',
  ) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Sub-Menu Text Font Size", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_text_font_size',
'type' => 'number',
'default' => '14',
'min' => '1',
'max' => '50',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".nav li ul.sub-menu a").css("font-size", value + "px");',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Sub-Menu Text Alignment", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_text_font_alignment',
'type' => 'select',
'options' => array(
'left' => ''.esc_html__( "Left", 'divi_mobile_settings' ).'',
'center' => ''.esc_html__( "Center", 'divi_mobile_settings' ).'',
'right' => ''.esc_html__( "Right", 'divi_mobile_settings' ).'',
),
'default' => 'left',
'livepreview' => '$("#dm-menu.nav li li").css("text-align", value);',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Sub-Menu Text padding top/bottom", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_text_padding',
'type' => 'number',
'default' => '14',
'min' => '1',
'max' => '50',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".nav li ul.sub-menu a").css("padding-top", value + "px");$(".nav li ul.sub-menu a").css("padding-bottom", value + "px");',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Open Sub-Menu Icon Appearance", 'divi_mobile_settings' ).'',
'type' => 'heading',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( 'Open Sub-Menu Icon', 'divi-mobile' ).'',
'id' => 'divi_mobile_sub_menu_icon',
'type' => 'text',
'default' => '24',
'desc' => ''.esc_html__( 'Enter in the code for the Divi icon of your choice which you will find', 'divi-mobile' ).' <a href="https://www.elegantthemes.com/blog/resources/elegant-icon-font" target="_blank">'.esc_html__( 'HERE.', 'divi-mobile' ).'</a> '.esc_html__( 'Copy the numbers and letters that appear after the "x". ', 'divi-mobile' ).esc_html__( 'For example for', 'divi-mobile' ).' "&amp;#x21;"'.esc_html__( 'copy and paste only the "21".', 'divi-mobile' ).'',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Open Sub-Menu Icon Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_icon_activate_color',
'type' => 'color',
'default' => '#ffffff',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>#dm_nav .menu-wrap__inner .menu-item-has-children > a:after {color: " + value + ";}</style>");
',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Open Sub-Menu Font Size", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_open_font_size',
'type' => 'number',
'default' => '16',
'min' => '1',
'max' => '100',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>#dm_nav .menu-wrap__inner .menu-item-has-children > a:after {font-size: " + value + "px !important;}</style>");
',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Open Icon Position", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_position',
'type' => 'select',
'options' => array(
'far-right' => ''.esc_html__( "Far right of menu", 'divi_mobile_settings' ).'',
'after-text' => ''.esc_html__( "After menu text", 'divi_mobile_settings' ).'',
),
'default' => 'far-right',
'livepreview' => '
if (value == "far-right") {
  $("#dm-menu a").css("display", "block");
}
else {
  $("#dm-menu a").css("display", "inline-block");
  }
',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Open Sub-Menu Icon Distance from Top", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_open_icon_top',
'type' => 'number',
'default' => '0',
'min' => '-50',
'max' => '50',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>#dm_nav .menu-wrap__inner .menu-item-has-children > a:after {top: " + value + "px;}</style>");
',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Open Sub-Menu Icon Distance from Right", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_open_icon_left',
'type' => 'number',
'default' => '0',
'min' => '-50',
'max' => '50',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>#dm_nav .menu-wrap__inner .menu-item-has-children > a:after {right: " + value + "px;}</style>");
',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Open Sub-Menu Rotation When Clicked", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_open_rotation',
'type' => 'number',
'default' => '0',
'min' => '-360',
'max' => '360',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>#dm_nav .menu-wrap__inner .menu-item-has-children.visible > a:after {transform: rotate(" + value + "deg);}</style>");
',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Close Sub-Menu Icon Appearance", 'divi_mobile_settings' ).'',
'type' => 'heading',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( 'Close Sub-Menu Icon', 'divi-mobile' ).'',
'id' => 'divi_mobile_sub_menu_icon_close',
'type' => 'text',
'default' => '23',
'desc' => ''.esc_html__( 'Enter in the code for the Divi icon of your choice which you will find', 'divi-mobile' ).' <a href="https://www.elegantthemes.com/blog/resources/elegant-icon-font" target="_blank">'.esc_html__( 'HERE.', 'divi-mobile' ).'</a> '.esc_html__( 'Copy the numbers and letters that appear after the "x". ', 'divi-mobile' ).esc_html__( 'For example for', 'divi-mobile' ).' "&amp;#x21;"'.esc_html__( 'copy and paste only the "21".', 'divi-mobile' ).'',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Close Sub-Menu Icon Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_icon_close_color',
'type' => 'color',
'default' => '#ffffff',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>#dm_nav .menu-wrap__inner .menu-item-has-children.visible > a:after, #dm_nav .menu-wrap__inner .close-submenu::before {color: " + value + " !important;}</style>");
',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Close Sub-Menu Font Size", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_close_font_size',
'type' => 'number',
'default' => '16',
'min' => '1',
'max' => '50',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>#dm_nav .menu-wrap__inner .menu-item-has-children.visible > a:after, #dm_nav .menu-wrap__inner .close-submenu::before {font-size: " + value + "px !important;}</style>");
',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Close Sub-Menu Icon Distance from Top", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_close_icon_top',
'type' => 'number',
'default' => '0',
'min' => '-50',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>#dm_nav .menu-wrap__inner .menu-item-has-children.visible > a:after, #dm_nav .menu-wrap__inner .close-submenu::before {top: " + value + "px !important;}</style>");
',
) );

$submenu->createOption( array(
'name' => ''.esc_html__( "Close Sub-Menu Icon Distance from Left", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_sub_menu_close_icon_left',
'type' => 'number',
'default' => '0',
'min' => '-50',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>#dm_nav .menu-wrap__inner .menu-item-has-children.visible > a:after, #dm_nav .menu-wrap__inner .close-submenu::before {margin-left: " + value + "px !important;}</style>");
',
) );



$menu_appearance->createOption( array(
'name' => ''.esc_html__( "Space at the top of the menu", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_space_top',
'type' => 'number',
'default' => '0',
'min' => '0',
'max' => '500',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>.menu-wrap__inner {padding-top: " + value + "px !important;}</style>");
',
) );

$menu_appearance->createOption( array(
'name' => ''.esc_html__( "Menu Background Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_bg_color',
'type' => 'color',
'default' => '#000000',
'alpha'  => 'true',
'livepreview' => '$(".menu-wrap").css("background-color", value);$(".menu-wrap__inner").css("background-color", value);',
) );

$menu_appearance->createOption( array(
  'name' => ''.esc_html__( "Menu Background Image", 'divi_mobile_settings' ).'',
  'id' => 'divi_mobile_menu_bg_image',
  'type' => 'upload',
  'desc' =>  ''.esc_html__( 'Upload your image here.', 'divi-mobile' ).'',
  // 'livepreview' => '$("#dm-header").css("height", value + "px");',
  ) );

  $menu_appearance->createOption( array(
    'name' => ''.esc_html__( "Menu Background Image Size", 'divi_mobile_settings' ).'',
    'id' => 'divi_mobile_menu_bg_image_size',
    'type' => 'select',
    'options' => array(
    'cover' => ''.esc_html__( "Cover", 'divi_mobile_settings' ).'',
    'contain' => ''.esc_html__( "Fit", 'divi_mobile_settings' ).'',
    'initial' => ''.esc_html__( "Actual Size", 'divi_mobile_settings' ).'',
    ),
    'default' => 'cover',
    'livepreview' => '$(".menu-wrap").css("background-size", value);$(".menu-wrap__inner").css("background-size", value);',
    ) );

    $menu_appearance->createOption( array(
      'name' => ''.esc_html__( "Menu Background Image Position", 'divi_mobile_settings' ).'',
      'id' => 'divi_mobile_menu_bg_image_pos',
      'type' => 'select',
      'options' => array(
      'top left' => ''.esc_html__( "Top Left", 'divi_mobile_settings' ).'',
      'top center' => ''.esc_html__( "Top Center", 'divi_mobile_settings' ).'',
      'top right' => ''.esc_html__( "Top Right", 'divi_mobile_settings' ).'',
      'center left' => ''.esc_html__( "Center Left", 'divi_mobile_settings' ).'',
      'center center' => ''.esc_html__( "Center", 'divi_mobile_settings' ).'',
      'center right' => ''.esc_html__( "Center Right", 'divi_mobile_settings' ).'',
      'bottom left' => ''.esc_html__( "Bottom Left", 'divi_mobile_settings' ).'',
      'bottom center' => ''.esc_html__( "Bottom Center", 'divi_mobile_settings' ).'',
      'bottom right' => ''.esc_html__( "Bottom Right", 'divi_mobile_settings' ).'',
      ),
      'default' => 'center center',
      'livepreview' => '$(".menu-wrap").css("background-position", value);$(".menu-wrap__inner").css("background-position", value);',
      ) );

      $menu_appearance->createOption( array(
        'name' => ''.esc_html__( "Menu Background Image Repeat", 'divi_mobile_settings' ).'',
        'id' => 'divi_mobile_menu_bg_image_repeat',
        'type' => 'select',
        'options' => array(
        'no-repeat' => ''.esc_html__( "No Repeat", 'divi_mobile_settings' ).'',
        'repeat' => ''.esc_html__( "Repeat", 'divi_mobile_settings' ).'',
        'repeat-x' => ''.esc_html__( "Repeat X (horizontal)", 'divi_mobile_settings' ).'',
        'repeat-y' => ''.esc_html__( "Repeat Y (vertical)", 'divi_mobile_settings' ).'',
        'space' => ''.esc_html__( "Space", 'divi_mobile_settings' ).'',
        'round' => ''.esc_html__( "Round", 'divi_mobile_settings' ).'',
        ),
        'default' => 'no-repeat',
        'livepreview' => '$(".menu-wrap").css("background-repeat", value);$(".menu-wrap__inner").css("background-repeat", value);',
        ) );

        $menu_appearance->createOption( array(
          'name' => ''.esc_html__( "Menu Background Image Blend", 'divi_mobile_settings' ).'',
          'id' => 'divi_mobile_menu_bg_image_blend',
          'type' => 'select',
          'options' => array(
          'normal' => ''.esc_html__( "Normal", 'divi_mobile_settings' ).'',
          'multiply' => ''.esc_html__( "Multiply", 'divi_mobile_settings' ).'',
          'screen' => ''.esc_html__( "Screen", 'divi_mobile_settings' ).'',
          'overlay' => ''.esc_html__( "Overlay", 'divi_mobile_settings' ).'',
          'darken' => ''.esc_html__( "Darken", 'divi_mobile_settings' ).'',
          'lighten' => ''.esc_html__( "Lighten", 'divi_mobile_settings' ).'',
          'color-dodge' => ''.esc_html__( "Color Dodge", 'divi_mobile_settings' ).'',
          'color-burn' => ''.esc_html__( "Color Burn", 'divi_mobile_settings' ).'',
          'hard-light' => ''.esc_html__( "Hard Light", 'divi_mobile_settings' ).'',
          'soft-light' => ''.esc_html__( "Soft Light", 'divi_mobile_settings' ).'',
          'difference' => ''.esc_html__( "Difference", 'divi_mobile_settings' ).'',
          'exclusion' => ''.esc_html__( "Exclusion", 'divi_mobile_settings' ).'',
          'hue' => ''.esc_html__( "Hue", 'divi_mobile_settings' ).'',
          'saturation' => ''.esc_html__( "Saturation", 'divi_mobile_settings' ).'',
          'color' => ''.esc_html__( "Color", 'divi_mobile_settings' ).'',
          'luminosity' => ''.esc_html__( "Luminosity", 'divi_mobile_settings' ).'',
          ),
          'default' => 'normal',
          'livepreview' => '$(".menu-wrap").css("background-blend-mode", value);$(".menu-wrap__inner").css("background-blend-mode", value);',
          ) );

$menu_appearance->createOption( array(
'name' => ''.esc_html__( "Menu Text Font", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_text_font',
'type' => 'font',
'show_color' => false,
'show_font_size' => false,
'show_websafe_fonts' => true,
'fonts'=>dm_get_user_custom_fonts_from_divi_theme(),
'livepreview' => '$(".menu-wrap nav a").css(value);',
'css' => '.menu-wrap nav a {
    value
}',
'desc' => ''
) );

$menu_appearance->createOption( array(
'name' => ''.esc_html__( "Menu Text Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_text_color',
'type' => 'color',
'default' => '#ffffff',
'alpha'  => 'true',
'livepreview' => '$(".menu-wrap nav a").css("color", value);',
) );

$menu_appearance->createOption( array(
'name' => ''.esc_html__( "Menu Text Colour Hover", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_text_color_hover',
'type' => 'color',
'default' => '#efefef',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>.menu-wrap nav a:hover {color: " + value + ";}</style>");
',
) );

$menu_appearance->createOption( array(
'name' => ''.esc_html__( "Active Menu Text Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_active_menu_text_color',
'type' => 'color',
'default' => 'rgba(255,255,255,0)',
'alpha'  => 'true',
'livepreview' => '$(".menu-wrap .current_page_item a").css("color", value);',
) );

$menu_appearance->createOption( array(
'name' => ''.esc_html__( "Active Menu Text Colour Hover", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_active_menu_text_color_hover',
'type' => 'color',
'default' => 'rgba(255,255,255,0)',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>.menu-wrap .current_page_item a:hover {color: " + value + ";}</style>");
',
) );

$menu_appearance->createOption( array(
'name' => ''.esc_html__( "Menu Text Font Size", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_text_font_size',
'type' => 'number',
'default' => '14',
'min' => '1',
'max' => '50',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".menu-wrap nav a").css("font-size", value + "px");',
) );

$menu_appearance->createOption( array(
'name' => ''.esc_html__( "Menu Text Alignment", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_text_font_alignment',
'type' => 'select',
'options' => array(
'left' => ''.esc_html__( "Left", 'divi_mobile_settings' ).'',
'center' => ''.esc_html__( "Center", 'divi_mobile_settings' ).'',
'right' => ''.esc_html__( "Right", 'divi_mobile_settings' ).'',
),
'default' => 'left',
'livepreview' => '$("#dm-menu.nav li").css("text-align", value);',
) );

$menu_appearance->createOption( array(
'name' => ''.esc_html__( "Menu Text Alignment Vertically", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_text_font_alignment_vertically',
'type' => 'select',
'options' => array(
'flex-start' => ''.esc_html__( "Top", 'divi_mobile_settings' ).'',
'center' => ''.esc_html__( "Center", 'divi_mobile_settings' ).'',
'flex-end' => ''.esc_html__( "Bottom", 'divi_mobile_settings' ).'',
),
'default' => 'flex-start',
'livepreview' => '$("..menu-wrap__inner").css("justify-content", value);',
) );


$menu_appearance->createOption( array(
'name' => ''.esc_html__( "Menu Text padding top/bottom", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_text_padding',
'type' => 'number',
'default' => '14',
'min' => '1',
'max' => '50',
'step' => '1',
'unit' => 'px',
'livepreview' => '$(".menu-wrap nav a").css("padding-top", value + "px");$(".menu-wrap nav a").css("padding-bottom", value + "px");',
) );

$menu_appearance->createOption( array(
'name' => ''.esc_html__( "Which side do you want the menu to appear from?", 'divi_mobile_settings' ).'',
'id' => 'set_mobile_menu_side_appear',
'type' => 'select',
'options' => array(
'right' => ''.esc_html__( "Right", 'divi_mobile_settings' ).'',
'left' => ''.esc_html__( "Left", 'divi_mobile_settings' ).'',
),
'default' => 'right',
) );

$menu_appearance->createOption( array(
'name' => ''.esc_html__( "Menu max-width (set the width of your menu)", 'divi_mobile_settings' ).'',
'id' => 'set_mobile_menu_side_max_width',
'type' => 'number',
'default' => '300',
'min' => '1',
'max' => '3000',
'step' => '1',
'unit' => 'px',
'livepreview' => '
if ( $("body").hasClass("dm-off-canvas dm-side-slide") || $("body").hasClass("dm-off-canvas dm-top-slide") ) {


if ( $("body").hasClass("dm-menuside-right") ) {
$("head").append("<style>.menu-wrap, #dm_nav .menu-wrap__inner .sub-menu {right: 0;transform: translate3d(" + value + "px,0,0) !important;}.menu-wrap{max-width: "  + value + "px;}</style>");
} else {
$("head").append("<style>.menu-wrap, #dm_nav .menu-wrap__inner .sub-menu {left: 0;transform: translate3d(-" + value + "px,0,0) !important;}.menu-wrap.menu-wrap{max-width: "  + value + "px;}</style>");
}


} else if ( $("body").hasClass("dm-off-canvas dm-elastic") ) {

  if ( $("body").hasClass("dm-menuside-right") ) {
  $("head").append("<style>.menu-wrap {right: 0;max-width: "  + value + "px;}#dm_nav .menu-wrap__inner .sub-menu{right: 0;}</style>");
  } else {
  $("head").append("<style>.menu-wrap {left: 0;max-width: "  + value + "px;}#dm_nav .menu-wrap__inner .sub-menu{left: 0;}</style>");
  }

}
else {
  // code...
}


',
) );


$circle_stretch->createOption( array(
'name' => ''.esc_html__( "Icon Settings", 'divi_mobile_settings' ).'',
'type' => 'heading',
) );

$circle_stretch->createOption( array(
'name' => ''.esc_html__( "Icon Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_icon_color',
'type' => 'color',
'default' => '#fff',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>body #dm_nav .bc-stretchy-nav.nav-is-visible ul .menu-item a::after {color: " + value + " !important;}</style>");
',
) );

$circle_stretch->createOption( array(
'name' => ''.esc_html__( "Icon Colour Hover", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_icon_color_hover',
'type' => 'color',
'default' => '#000',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>body #dm_nav .bc-stretchy-nav.nav-is-visible ul .menu-item a:hover::after {color: " + value + " !important;}</style>");
',
) );

$circle_stretch->createOption( array(
'name' => ''.esc_html__( "Icon Font Size", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_icon_font_size',
'type' => 'number',
'default' => '18',
'min' => '1',
'max' => '50',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>body #dm_nav .bc-stretchy-nav.nav-is-visible ul .menu-item a::after {font-size: " + value + "px !important;}</style>");
',
) );

$circle_stretch->createOption( array(
'name' => ''.esc_html__( "Icon Distance Top", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_icon_dis_top',
'type' => 'number',
'default' => '0',
'min' => '-50',
'max' => '50',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>body #dm_nav .bc-stretchy-nav.nav-is-visible ul .menu-item a::after{margin-top: " + value + "px !important;}</style>");
',
) );

$circle_stretch->createOption( array(
'name' => ''.esc_html__( "Icon Distance Right", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_icon_dis_right',
'type' => 'number',
'default' => '0',
'min' => '-50',
'max' => '50',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>body #dm_nav .bc-stretchy-nav.nav-is-visible ul .menu-item a::after {margin-right: " + value + "px !important;}</style>");
',
) );

$bottom_nav->createOption( array(
'name' => ''.esc_html__( "Bottom Background Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_bottom_nav_bg_color',
'type' => 'color',
'default' => '#fff',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>body .bottom-navigation {background-color: " + value + " !important;}</style>");
',
) );

$bottom_nav->createOption( array(
'name' => ''.esc_html__( "Icon Settings", 'divi_mobile_settings' ).'',
'type' => 'heading',
) );

$bottom_nav->createOption( array(
'name' => ''.esc_html__( "Icon Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_bottom_nav_icon_color',
'type' => 'color',
'default' => '#000',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>body .bottom-navigation-menu ul a::after {color: " + value + " !important;}</style>");
',
) );

$bottom_nav->createOption( array(
'name' => ''.esc_html__( "Active Icon Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_bottom_nav_active_icon_color',
'type' => 'color',
'default' => '#000',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>body .bottom-navigation-menu ul .current-menu-item a::after {color: " + value + " !important;}</style>");
',
) );

$bottom_nav->createOption( array(
'name' => ''.esc_html__( "Icon Colour Hover", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_bottom_nav_icon_color_hover',
'type' => 'color',
'default' => '#000',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>body .bottom-navigation-menu ul a:hover::after {color: " + value + " !important;}</style>");
',
) );

$bottom_nav->createOption( array(
'name' => ''.esc_html__( "Icon Font Size", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_bottom_nav_icon_font_size',
'type' => 'number',
'default' => '20',
'min' => '1',
'max' => '50',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>body .bottom-navigation-menu ul a::after {font-size: " + value + "px !important;}</style>");
',
) );

$bottom_nav->createOption( array(
'name' => ''.esc_html__( "Text Settings", 'divi_mobile_settings' ).'',
'type' => 'heading',
) );

$bottom_nav->createOption( array(
'name' => ''.esc_html__( "Text Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_bottom_nav_text_color',
'type' => 'color',
'default' => '#000',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>body .bottom-navigation-menu ul a {color: " + value + " !important;}</style>");
',
) );

$bottom_nav->createOption( array(
'name' => ''.esc_html__( "Active Text Colour", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_bottom_nav_active_text_color',
'type' => 'color',
'default' => '#000',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>body .bottom-navigation-menu ul .current-menu-item a {color: " + value + " !important;}</style>");
',
) );

$bottom_nav->createOption( array(
'name' => ''.esc_html__( "Text Colour Hover", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_bottom_nav_text_color_hover',
'type' => 'color',
'default' => '#000',
'alpha'  => 'true',
'livepreview' => '
$("head").append("<style>body .bottom-navigation-menu ul a:hover {color: " + value + " !important;}</style>");
',
) );

$bottom_nav->createOption( array(
'name' => ''.esc_html__( "Text Font Size", 'divi_mobile_settings' ).'',
'id' => 'divi_mobile_menu_bottom_nav_text_font_size',
'type' => 'number',
'default' => '10',
'min' => '1',
'max' => '50',
'step' => '1',
'unit' => 'px',
'livepreview' => '
$("head").append("<style>body .bottom-navigation-menu ul a {font-size: " + value + "px !important;}</style>");
',
) );

$fullscreenmenu->createOption( array(
  'name' => ''.esc_html__( "Extra Appearance Options", 'divi_mobile_settings' ).'',
  'id' => 'fullscreen_extra_options',
  'type' => 'select',
  'options' => array(
  'none' => ''.esc_html__( "None", 'divi_mobile_settings' ).'',
  'menu_name_behind' => ''.esc_html__( "Menu name behind item on hover", 'divi_mobile_settings' ).'',
  ),
  'default' => 'none',
  'livepreview' => '
  if (value == "menu_name_behind"){
  $("head").append("<style>body .menu-name-behind {display: block !important;}</style>");
  } else {}
  '
  ) );

  $fullscreenmenu->createOption( array(
    'name' => ''.esc_html__( "Extra Appearance Font Settings", 'divi_mobile_settings' ).'',
    'id' => 'fullscreen_extra_option_font',
    'type' => 'font',
    'show_color' => false,
    'show_font_size' => false,
    'show_websafe_fonts' => true,
    'fonts'=>dm_get_user_custom_fonts_from_divi_theme(),
    'livepreview' => '$(".menu-name-behind").css(value);',
    'css' => '.menu-name-behind {value}',
    'desc' => 'We do not have a live preview of the font styles. Save and reload to see it in action.'
    ) );

  $fullscreenmenu->createOption( array(
    'name' => ''.esc_html__( "Extra Appearance Font Size", 'divi_mobile_settings' ).'',
    'id' => 'fullscreen_extra_option_font_size',
    'type' => 'number',
    'default' => '150',
    'min' => '1',
    'max' => '500',
    'step' => '1',
    'unit' => 'px',
    'livepreview' => '
    $("head").append("<style>body .menu-name-behind {font-size: " + value + "px !important;}</style>");
    ',
    ) );

    $fullscreenmenu->createOption( array(
      'name' => ''.esc_html__( "Extra Appearance Font Color", 'divi_mobile_settings' ).'',
      'id' => 'fullscreen_extra_option_font_color',
      'type' => 'color',
      'default' => '#000',
      'alpha'  => 'true',
      'livepreview' => '
      $("head").append("<style>body .menu-name-behind {color: " + value + " !important;}</style>");
      ',
      ) );

}
add_action( 'tf_create_options', 'divi_mobile_menu_settings' );

add_action( 'wp_dashboard_setup', 'divi_m_check_validation' );

function divi_m_check_validation() {
    if (defined('DOING_AJAX') && DOING_AJAX) {
        return;
    }

    $a_result = '';

    $de_su = 'https://diviengine.com/';

    $de_su_json = $de_su . 'wp-json/de_plugins/products';

    $site_url = get_option( 'siteurl' );
    $site_url = str_replace( 'https://', '', $site_url );
    $site_url = str_replace( 'http://', '', $site_url );
    $site_url = rtrim( $site_url, '/' );

    $aj_gaket = get_option( 'et_automatic_updates_options' );
    if ( !empty( $aj_gaket ) && isset( $aj_gaket['api_key'] ) ) {
        $aj_gaket_val = trim($aj_gaket['api_key']);
    } else {
        $aj_gaket_val = '';
    }
    
    $code_l = get_option('divi_daf_license');
    $code_d = "Y";

    if ( isset( $code_l['key'] ) && $code_l['key'] !== '' ) {
        $code_d = $code_l['key'];
    }

    $product_id = '353';
    $et_status = 'N';

    if ( DE_M_P == 'm_a' && $aj_gaket_val != '' ) {
        $json = file_get_contents('https://www.elegantthemes.com/marketplace/index.php/wp-json/api/v1/check_subscription/product_id/'.$product_id.'/api_key/'.$aj_gaket_val);
        $data = json_decode($json);
        $code_m = $data->code;
        if ( $code_m != 'no_billing_records') {
            $et_status = 'Y';
        }
    }

    $secure_string = $site_url . '|' . 'de_m' . '|' . DE_M_P . '|' . $code_d . '|' . $et_status;
    $file = DE_DM_PATH . '/key.rem';
    $de_keys = get_option( 'de_keys', array() );

    if ( !file_exists( $file ) ) {
        if ( !empty( $de_keys['de_m'] ) ) {
            $keypair = $de_keys['de_m'];
            file_put_contents($file, $keypair);
        } else {
            $keypair = md5( $site_url );
            file_put_contents($file, $keypair);
            $de_keys['de_m'] = $keypair;
            update_option( 'de_keys', $de_keys );
        }
    } else {
        $keypair = file_get_contents( $file );
        $de_keys['de_m'] = $keypair;
        update_option( 'de_keys', $de_keys );
    }

    $body = array(
        'keypair'   => $keypair,
        'secure_str'    => base64_encode( $secure_string )
    );

    $args = array(
        'body'        => $body,
    );

    $response = wp_remote_post( $de_su_json, $args );
    $a_result = str_replace('"', '', wp_remote_retrieve_body( $response ));

    if ( $a_result == 'msg_ok' ) {
        return true;
    } else {
    
        return false;
    }
}

/**
 * Retrieves custom fonts that user uploaded to Divi theme
 * @return false|int[]|string[] An array with each font family
 */
if(!function_exists('dm_get_user_custom_fonts_from_divi_theme')){
	function dm_get_user_custom_fonts_from_divi_theme(){
		$custom_fonts_array = [];
		if ( function_exists( 'et_builder_get_custom_fonts' ) ){
			$user_fonts = array_keys(et_builder_get_custom_fonts());
			$custom_fonts_array =array_combine($user_fonts,$user_fonts);
		}
		return $custom_fonts_array;
	}
}
