<?php
if ( ! defined( 'ABSPATH' ) ) exit;


function dm_inject_layout_submenu_handler(){

    global $post;

    $layoutid = esc_html( $_POST['layoutid'] );

    $content = '<div class="divi-mobile-inner-ajax" id="dm-' .$layoutid. '">';
    $content .= do_shortcode('[et_pb_row global_module="' . $layoutid . '"][/et_pb_row]');
    $content .= '</div>';

    $content = preg_replace( '/et_pb_([a-z|_]+)_(\d+)_tb_body/', 'et_pb_dm-'.$layoutid.'_${1}_${2}_tb_body', $content );
    $content = preg_replace( '/et_pb_([a-z|_]+)_(\d+)( |")/', 'et_pb_dm-'.$layoutid.'_${1}_${2}${3}', $content );
 
    $args = array(
        'post_type' => 'et_pb_layout',
        'p'         => $layoutid,
        'posts_per_page' => 1
    );
    
    query_posts( $args );

    if( have_posts() ) :
        // run the loop
        while( have_posts() ):
            the_post();

    
    ob_start();

    // retrieve the styles for the modules
    $internal_style = ET_Builder_Element::get_style();
    // reset all the attributes after we retrieved styles
    ET_Builder_Element::clean_internal_modules_styles( false );
    $et_pb_rendering_column_content = false;

    // append styles

    // TODO: Need to add the class for the menu to the CSS so it ONLY applies the CSS to the one menu and not all

    if ( $internal_style ) {
?>
    <div class="df-inner-styles">
<?php
    $cleaned_styles = str_replace("body.et-db #page-container #et-boc .et-l .et_pb_section ","", $internal_style);
    $cleaned_styles = str_replace("body.et-db #page-container #et-boc .et-l ","", $cleaned_styles);
    $cleaned_styles = str_replace("body #page-container .et_pb_section ","", $cleaned_styles);
    $cleaned_styles = str_replace(".et-db #et-boc .et-l .et_pb_section ","", $cleaned_styles);
    $cleaned_styles = str_replace(".et-db #et-boc .et-l ","", $cleaned_styles);
    $temp_styles = $cleaned_styles;
    $temp_styles = preg_replace( '/et_pb_([a-z|_]+)_(\d+)_tb_body/', 'et_pb_dm-'.$layoutid.'_${1}_${2}_tb_body', $temp_styles );
    $temp_styles = preg_replace( '/et_pb_([a-z|_]+)_(\d+)( |"|\.|,|:)/', 'et_pb_dm-'.$layoutid .'_${1}_${2}${3}', $temp_styles );
    $cleaned_styles = preg_replace( '/\.et_pb_([a-z|_]+)_(\d+)_tb_body/', 'body.et-db #et-boc .et-l .et_pb_dm-'.$layoutid.'_${1}_${2}_tb_body', $cleaned_styles );
    $cleaned_styles = preg_replace( '/\.et_pb_([a-z|_]+)_(\d+)( |"|\.|,|:)/', 'body.et-db #et-boc .et-l .et_pb_dm-'.$layoutid.'_${1}_${2}${3}', $cleaned_styles );
    $cleaned_styles = $temp_styles . ' ' . $cleaned_styles;

        printf(
            '<style type="text/css" class="dmach_ajax_inner_styles">
              %1$s
            </style>',
            et_core_esc_previously( $cleaned_styles )
        );
?>
    </div>
<?php
    }


    $css_output = ob_get_contents();

    ob_end_clean();

    ob_start();
    
	$animation_data      = et_core_is_fb_enabled() ? array() : et_builder_handle_animation_data();
	$animation_data_json = json_encode( $animation_data );
    $animation_data_json = preg_replace( '/et_pb_([a-z|_]+)_(\d+)( |"|\.|,|:)/', 'et_pb_dm-'.$layoutid .'_${1}_${2}${3}', $animation_data_json );

    $link_options_data      = et_core_is_fb_enabled() ? array() : et_builder_handle_link_options_data();
	$link_options_data_json = json_encode( $link_options_data );    
    $link_options_data_json = preg_replace( '/et_pb_([a-z|_]+)_(\d+)( |"|\.|,|:)/', 'et_pb_dm-'.$layoutid .'_${1}_${2}${3}', $link_options_data_json );

	if ( empty( $animation_data ) && empty( $link_options_data ) ) {
		return;
	}

	?>
	<script type="text/javascript">
		<?php if ( $animation_data ) : ?>
		var et_animation_data = <?php echo et_core_esc_previously( $animation_data_json ); ?>;
			<?php
		endif;

		if ( $link_options_data ) :
			?>
		var et_link_options_data = <?php echo et_core_esc_previously( $link_options_data_json ); ?>;
		<?php endif; ?>
	</script>

    <?php 

    $js_output = ob_get_contents();

    ob_end_clean();

endwhile;
endif;

    $result['content'] = $content;
    $result['css_output'] = $css_output;
    $result['js_output'] = $js_output;

    wp_reset_postdata();

    wp_send_json($result);
    wp_die();
}

add_action("wp_ajax_get_dm_inject_submenu_layouts", "dm_inject_layout_submenu_handler");
add_action("wp_ajax_nopriv_get_dm_inject_submenu_layouts", "dm_inject_layout_submenu_handler");


function dm_inject_submenu_js() {
    $titan = TitanFramework::getInstance( 'divi-mobile-menu' );
    $inject_layouts_submenu = $titan->getOption( 'inject_layouts_submenu' );
    $inject_layouts_submenu_position = $titan->getOption( 'inject_layouts_submenu_position' );
    
    if ($inject_layouts_submenu == 'enabled') {
    ?>
    <script>
    jQuery(document).ready(function($){

        // on click et_clickable inside ajax loaded divi-mobile-inner-ajax
        // click on link that has been ajax loaded 
        
        $menuids = '';
        $('#dm-menu .menu-item-has-children[class*="dm-"]').each(function () {
            var layoutid = 0;

            var matches = $(this).attr('class').match(/(^|\s)dm-(\d+)(\s|$)/);
            if (matches) {
                layoutid = matches[2];
            }

            if ( layoutid != 0 ) {
                jQuery.ajax({
                    url: '<?php echo admin_url( 'admin-ajax.php' );?>',
                    data: {
                        action: 'get_dm_inject_submenu_layouts',
                        layoutid: layoutid
                        },
                        type: 'POST',
                        success: function( data ) {

                            if ($('#dm-' + layoutid).length) {
                            } else {
                                <?php if ($inject_layouts_submenu_position == 'below') { ?>
                                    $('.dm-' + layoutid).find('.sub-menu').append(data.content);
                                    $('.dm-' + layoutid).find('.sub-menu').append(data.css_output);
                                    $('.dm-' + layoutid).find('.sub-menu').append(data.js_output);
                                <?php } if ($inject_layouts_submenu_position == 'remove') { 
                                ?>
                                    $('body').addClass('inject_menu_remove');
                                    $('.dm-' + layoutid).find('.sub-menu').append(data.content);
                                    $('.dm-' + layoutid).find('.sub-menu').append(data.css_output);
                                    $('.dm-' + layoutid).find('.sub-menu').append(data.js_output);
                                <?php
                                }else {
                               ?>
                                    $('.dm-' + layoutid).find('.sub-menu').prepend(data.content);
                                    $('.dm-' + layoutid).find('.sub-menu').prepend(data.css_output);
                                    $('.dm-' + layoutid).find('.sub-menu').append(data.js_output);
                                <?php
                                } ?>

                            }

                            $('.divi-mobile-inner-ajax .et_clickable').on('touchend click', function(e) {
                                var $this = $(this);
                                if ( typeof et_link_options_data != 'undefined' ) {
                                    $.each(et_link_options_data, function( i, val ) {
                                        if ( $this.hasClass( val.class ) ) {
                                            if ( val.target == '_self' ) {
                                                document.location.href= val.url;
                                            } else {
                                                window.open( val.url );
                                            }
                                        }
                                    });
                                }
                                e.preventDefault();
                                e.stopPropagation();
                            });
                        }
                });
            }
        });
    });
    </script>
    <?php
    }
  }
  
  add_action('wp_footer', 'dm_inject_submenu_js');