<?php
if ( ! defined( 'ABSPATH' ) ) exit;

$titan = TitanFramework::getInstance( 'divi-mobile-menu' );
$divi_mobile_custom_header_logo = $titan->getOption( 'divi_mobile_custom_header_logo' );
$divi_mobile_custom_header_logo_alt_text = $titan->getOption( 'divi_mobile_custom_header_logo_alt_text' );
$divi_mobile_custom_header_logo_title_text = $titan->getOption( 'divi_mobile_custom_header_logo_title_text' );
$divi_mobile_custom_header_logo_scroll = $titan->getOption( 'divi_mobile_custom_header_logo_scroll' );
$inject_above_header = $titan->getOption( 'inject_above_header' );
$inject_above_header_scroll = $titan->getOption( 'inject_above_header_scroll' );
$inject_below_header = $titan->getOption( 'inject_below_header' );
$inject_below_header_scroll = $titan->getOption( 'inject_below_header_scroll' );

$divi_mobile_custom_header_logo_height_fixed = $titan->getOption( 'divi_mobile_custom_header_logo_height_fixed' );
$divi_mobile_custom_header_logo_width_fixed = $titan->getOption( 'divi_mobile_custom_header_logo_width_fixed' );

$divi_mobile_logo_link = $titan->getOption( 'divi_mobile_logo_link' );

if ($divi_mobile_logo_link == "") {

  if ( function_exists('icl_object_id') ) {
    $divi_mobile_logo_link_final = apply_filters( 'wpml_home_url', get_option( 'home' ) );
  } else if ( function_exists( 'pll_count_posts' ) ) { 
    $divi_mobile_logo_link_final = pll_home_url($slug);
  } else {
    $divi_mobile_logo_link_final = home_url( '/' );
  }

} else {
  $divi_mobile_logo_link_final = $divi_mobile_logo_link;
}

$divi_mobile_custom_header_account_icon_position = $titan->getOption( 'divi_mobile_custom_header_account_icon_position' );

if ($inject_above_header_scroll == "1") {
  $inject_above_header_scroll_css = "hideonscroll";
} else {
  $inject_above_header_scroll_css = "";
}


if ($inject_below_header_scroll == "1") {
  $inject_below_header_scroll_css = "hideonscroll";
} else {
  $inject_below_header_scroll_css = "";
}
 ?>
<header id="dm-header">
  <?php
  if (isset($inject_above_header)) {
    if ($inject_above_header !== "") {
      ?>
      <div class="dm-above-layout <?php echo esc_html($inject_above_header_scroll_css) ?>">
      <?php
      echo do_shortcode('[et_pb_section global_module="'.$inject_above_header.'"][/et_pb_section]');
      ?> 
      </div> 
      <?php
    }
  }
  ?>

<div class="dm-header-cont">

<div class="dm-branding">
  <?php

  $imageSrc = $divi_mobile_custom_header_logo; // For the default value
          if ( is_numeric( $divi_mobile_custom_header_logo ) ) {
              $imageAttachment = wp_get_attachment_image_src( $divi_mobile_custom_header_logo, 'full' );
              if (is_array($imageAttachment)) {
                $imageSrc = $imageAttachment[0];
                } else {
                  $imageSrc = $imageAttachment;
                }
          }

  $imageSrc_scroll = $divi_mobile_custom_header_logo_scroll; // For the default value
          if ( is_numeric( $divi_mobile_custom_header_logo_scroll ) ) {
              $imageAttachment_scroll = wp_get_attachment_image_src( $divi_mobile_custom_header_logo_scroll, 'full' );
              if (is_array($imageAttachment_scroll)) {
                $imageSrc_scroll = $imageAttachment_scroll[0];
                } else {
                  $imageSrc_scroll = $imageAttachment_scroll;
                }
          }          


if ($imageSrc != "") {
  $logo = $imageSrc;
} else {
    $user_logo = et_get_option( 'divi_logo' );
    $logo = $user_logo ?: "";

  }

$last3chars = substr($logo, -3);

if ($last3chars == "svg") {
  $last3chars_dis = "svg-logo";
} else {
  $last3chars_dis = "normal-logo";
}

if ($imageSrc_scroll != "") {
$hide_main_log = "hideonscroll";
} else {
$hide_main_log = "";
}

if ($divi_mobile_custom_header_logo_alt_text == "") {
  $alt_text = get_bloginfo( 'name' );
} else {
  $alt_text = $divi_mobile_custom_header_logo_alt_text;
}

if ($divi_mobile_custom_header_logo_title_text == "") {
  $title_text = "";
} else {
  $title_text = $divi_mobile_custom_header_logo_title_text;
}

// if divi_mobile_custom_header_logo_height_fixed is not 0
if ($divi_mobile_custom_header_logo_height_fixed != "0") {
  $divi_mobile_custom_header_logo_height_fixed_css = 'height='.$divi_mobile_custom_header_logo_height_fixed.'';
} else {
  $divi_mobile_custom_header_logo_height_fixed_css = "";
}

// if divi_mobile_custom_header_logo_width_fixed is not 0
if ($divi_mobile_custom_header_logo_width_fixed != "0") {
  $divi_mobile_custom_header_logo_width_fixed_css = 'width='.$divi_mobile_custom_header_logo_width_fixed.'';
} else {
  $divi_mobile_custom_header_logo_width_fixed_css = "";
}

   ?>
  <a href="<?php echo esc_url( $divi_mobile_logo_link_final ); ?>">
      <?php if($logo) { ?>
          <img class="main-logo <?php echo esc_html( $last3chars_dis ) ?> <?php echo esc_html( $hide_main_log ) ?>" src="<?php echo esc_attr( $logo ); ?>" alt="<?php echo esc_attr( $alt_text ); ?>" title="<?php echo esc_attr( $divi_mobile_custom_header_logo_title_text ); ?>" id="dm-logo" <?php echo esc_attr($divi_mobile_custom_header_logo_width_fixed_css); ?> <?php echo esc_attr($divi_mobile_custom_header_logo_height_fixed_css); ?> />
      <?php }else{ ?>
          <span class="main-logo  <?php echo esc_html( $last3chars_dis ) ?> <?php echo esc_html( $hide_main_log ) ?>" id="dm-logo" ><?php echo esc_attr( $divi_mobile_custom_header_logo_title_text ); ?></span>
      <?php } ?>
      <?php if ($imageSrc_scroll != "") { ?>
        <img class="logo-scroll <?php echo esc_html( $last3chars_dis ) ?>" src="<?php echo esc_attr( $imageSrc_scroll ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>" <?php echo esc_attr($divi_mobile_custom_header_logo_width_fixed_css); ?> <?php echo esc_attr($divi_mobile_custom_header_logo_height_fixed_css); ?>/>
      <?php } ?>
  </a>
</div>
<?php       if ($divi_mobile_custom_header_search_icon_position == "left" || $divi_mobile_custom_header_search_icon_position == "right") { ?>
<div class="dm-search">
  <div id="et_top_search_mob">
    <span id="et_search_icon"></span>
<div class="dm-search-box" style="opacity: 0;">
      <form role="search" method="get" class="et-search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
      <?php
        printf( '<input type="search" class="et-search-field" placeholder="%1$s" value="%2$s" name="s" title="%3$s" />',
          esc_attr__( 'Search &hellip;', 'Divi' ),
          get_search_query(),
          esc_attr__( 'Search for:', 'Divi' )
        );
      ?>
      </form>
      <span class="close"></span>
  </div>
  </div>
</div>
<?php } ?>
<?php
if ($divi_mobile_custom_header_cart_icon_position == "left" || $divi_mobile_custom_header_cart_icon_position == "right") {
 ?>
<div class="dm-cart">
<?php 				et_show_cart_total( array(
          'no_text' => true,
        ) ); ?>
</div>
<?php } ?>
<?php
if ($divi_mobile_custom_header_account_icon_position == "left" || $divi_mobile_custom_header_account_icon_position == "right") { ?>
	<?php if(function_exists('wc_get_page_id')){ ?>
        <div class="dm-account">
          <a href="<?php  echo get_permalink( wc_get_page_id( 'myaccount' ) );?>">
            <span class="dm-account-icon"></span>
          </a>
        </div>
    <?php } ?>
<?php } ?>
</div>
<?php
  if (isset($inject_below_header)) {
    if ($inject_below_header !== "") {
      ?>
      <div class="dm-below-layout <?php echo esc_html($inject_below_header_scroll_css) ?>">
      <?php
      echo do_shortcode('[et_pb_section global_module="'.$inject_below_header.'"][/et_pb_section]');
      ?> 
      </div> 
      <?php
    }
  }
  ?>
</header>
<?php
 ?>
