<?php
if ( ! defined( 'ABSPATH' ) ) exit;

function divi_mobile_sub_menu_overlap_js() {
    $titan = TitanFramework::getInstance( 'divi-mobile-menu' );
    $disable_parent_clickthrough = $titan->getOption( 'disable_parent_clickthrough' ) ?: "0";
    $divi_mobile_menu__breakpoint = $titan->getOption( 'divi_mobile_menu__breakpoint' );

?>
<script type="text/javascript">
jQuery(document).ready(function( $ ) {
    
    $("body").addClass("sidebyside-submenu");
    
    $(".menu-wrap__inner .menu-item-has-children:first").addClass("visible");

    function setup_collapsible_submenus() {
        var $menu = $('#dm_nav'),
        top_level_link = '.menu-wrap__inner .menu-item-has-children > a';
        
        $menu.find('a').each(function() {
            <?php 
            if ($disable_parent_clickthrough == "1") {
            ?>
            var click_through = $(this);
            if ( $(this).is(top_level_link) ) {
                $(this).attr('href', '#');
            }
            <?php 
            } else {
            ?>
            $(this).closest('.menu-item a').append('<span class="clickthrough"></span>');
            var click_through = $(".clickthrough");
            <?php 
            } 
            ?>

            if ( ! $(this).siblings('.sub-menu').length ) {
                $(this).off('touchstart click').on('touchstart click', function(event) {
                    $(this).parents('.mobile_nav').trigger('click');
                });
            } else {
               
            }
        });
    }

    $(window).on('load', function(){
        setTimeout(function() {
            setup_collapsible_submenus();
        }, 1200);
    });
    
    <?php if ($disable_parent_clickthrough == "1") {
    ?>
    var click_through = '.menu-wrap__inner .menu-item-has-children > a';
    <?php 
    } else {
    ?>
    var click_through = '.clickthrough';
    <?php 
    }
    ?>
    
    if ($(window).width() < <?php echo $divi_mobile_menu__breakpoint ?>) {
        
        var touchmoved;
        $('.menu-item-has-children').on('touchend click', click_through, function(e) {
            if(touchmoved != true){
                e.preventDefault();
                e.stopPropagation();
                $(this).closest('.menu-item').siblings().removeClass('visible');
                $(this).closest('.menu-item').toggleClass('visible');
                setTimeout(function() {
                    jQuery('.menu-item').removeClass('et-hover');
                    jQuery('.menu-item').removeClass('et-touch-hover');
                }, 800);
            }
        }).on('touchmove', click_through, function(e) {
            touchmoved = true;
        }).on('touchstart', click_through, function(e) {
            touchmoved = false;
        });  

    } else {
        $('body').on('touchstart click', click_through, function(e) {
            e.preventDefault();
            e.stopPropagation();
            $(this).closest('.menu-item').siblings().removeClass('visible');
            $(this).closest('.menu-item').toggleClass('visible');
            setTimeout(function() {
                jQuery('.menu-item').removeClass('et-hover');
                jQuery('.menu-item').removeClass('et-touch-hover');
            }, 800);
        });
    }
    
    <?php if ($disable_parent_clickthrough == "1") {
    ?>
    $("#dm_nav .menu-item").on("touchstart", 'a',function(e) {
        touchmoved = false;
        //var addressValue = $(this).attr("href");
        //window.location.href = addressValue;
    }).on("touchmove", 'a', function(e){
        touchmoved = true;
    }).on("touchend click", 'a', function(e){
        if ( touchmoved != true ){
            e.preventDefault();
            e.stopPropagation();
            if ( $(this).siblings('.sub-menu').length > 0 ) {
                $(this).closest('.menu-item').siblings().removeClass('visible');
                $(this).closest('.menu-item').toggleClass('visible');
                setTimeout(function() {
                    jQuery('.menu-item').removeClass('et-hover');
                    jQuery('.menu-item').removeClass('et-touch-hover');
                }, 800);
            }else{
                var addressValue = $(this).attr("href");
                var addresstarget = $(this).attr('target');
                if (addresstarget == "_blank") {
                    window.open(addressValue, '_blank');
                } else {
                    window.location.href = addressValue;
                }
            }
        }
    });
    <?php
    } else {
    ?>
    $("#dm_nav .menu-item").on("touchstart", 'a',function(e) {
        touchmoved = false;
        //var addressValue = $(this).attr("href");
        //window.location.href = addressValue;
    }).on("touchmove", 'a', function(e){
        touchmoved = true;
    }).on("touchend click", 'a', function(e){
        if ( touchmoved != true ){
            e.preventDefault();
            e.stopPropagation();
                var addressValue = $(this).attr("href");
                var addresstarget = $(this).attr('target');
                if (addresstarget == "_blank") {
                    window.open(addressValue, '_blank');
                } else {
                    window.location.href = addressValue;
                }
        }
    });
    <?php
    }
    ?>
});
</script>
<?php

}
add_action('wp_footer', 'divi_mobile_sub_menu_overlap_js');

 ?>
