<?php
if ( ! defined( 'ABSPATH' ) ) exit;


class NitroMinify_Admin {
	// Plugin unique prefix. Used for options, filenames etc.
	private $prefix = 'nitro';

	// Plugin options
	private $options;

	// Admin Notices.
	private $admin_notices;

	function __construct() {

		$this->prefix = apply_filters( 'nitro_prefix', $this->prefix );
		$this->options = nitro_get_options();

		$this->admin_notices = new NitroMinify_Admin_Notices( $this->prefix );

		add_action( 'admin_menu', array( $this, 'admin_menu' ) );
		add_action( 'admin_init', array( $this, 'admin_init' ) );
		add_action( 'admin_notices', array( $this, 'display_admin_notices' ), 1 );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

	}

	/**
	 * Add the adminmenu item
	 *
	 * @return null
	 */
	function admin_menu() {

		add_submenu_page( 'divi-engine','Nitro Minify', 'Nitro Minify', 'manage_options', 'nitro', array( $this, 'options_page' ), 11 );
		//add_options_page( 'Divi Nitro Minify', 'Divi Nitro Minify',  'manage_options', 'nitro', array( $this, 'options_page' ) );
	}

	/**
	 * Register plugin settings
	 *
	 * @return null
	 */
	function admin_init(){

		// Maybe clear cache
		if ( isset( $_GET['_wpnonce'] ) && wp_verify_nonce( $_GET['_wpnonce'], 'nitro_clear_cache' ) ) // phpcs:ignore
			$this->clear_cache();

		register_setting( 'nitro_options', 'nitro_options', array( $this, 'validate_options' ) );

		add_settings_section( 'plugin_main', 'Divi Nitro Minify', '__return_true', 'general_minify_options' );
		add_settings_section( 'plugin_main', 'Javascript Minification', '__return_true', 'script_minify_options' );
		add_settings_section( 'plugin_main', 'CSS Minification', '__return_true', 'style_minify_options' );
		add_settings_section( 'plugin_main', 'Inline Script Minification', '__return_true', 'inline_script_minify_options' );

		add_settings_field( 'nitro_information', 'Information', array( $this, 'information' ), 'general_minify_options', 'plugin_main' );
		add_settings_field( 'nitro_helper', 'Enable helper', array( $this, 'field_helper' ), 'general_minify_options', 'plugin_main' );
		add_settings_field( 'nitro_clear_cache', 'Delete all cached files', array( $this, 'field_clear_cache' ), 'general_minify_options', 'plugin_main' );
		add_settings_field( 'nitro_inline_scripts', 'Enable inline minification? (html, inline css & js)', array( $this, 'inline_scripts' ), 'inline_script_minify_options', 'plugin_main' );

		add_settings_field( 'nitro_styles_method', 'Enable Javascript minification?', array( $this, 'field_method_scripts' ), 'script_minify_options', 'plugin_main' );
		add_settings_field( 'nitro_scripts', 'Javascript minification queue(s)', array( $this, 'field_scripts' ), 'script_minify_options', 'plugin_main' );

		add_settings_field( 'nitro_styles_method', 'Enable CSS minification?', array( $this, 'field_method_styles' ), 'style_minify_options', 'plugin_main' );
		add_settings_field( 'nitro_styles', 'CSS minification queue(s)', array( $this, 'field_styles' ), 'style_minify_options', 'plugin_main' );

		add_action( 'add_meta_boxes', array( $this, 'add_nitro_box' ) );
		add_action( 'save_post',      array( $this, 'save_except_assets' ) );

	}

	/**
	 * Output the main options page content.
	 *
	 * @return null
	 */
	function options_page() { ?>

		<div class="wrap">


			<form action="options.php" method="post">

				<?php

				settings_fields('nitro_options');
				do_settings_sections('general_minify_options');
				do_settings_sections('script_minify_options');
				do_settings_sections('style_minify_options');
				do_settings_sections('inline_script_minify_options');

				?>

				<p class="submit">
					<input type="submit" name="submit" id="submit" class="button button-primary" value="Save Changes">
				</p>

			</form>

		</div>

		<?php

	}

	/**
	 * Output clear cache button
	 *
	 * @return null
	 */
	function field_clear_cache() { ?>

		<a href="<?php echo esc_html( wp_nonce_url( 'admin.php?page=nitro', 'nitro_clear_cache' ) ); ?>" class="button" style="margin-right: 10px;">Clear Cache</a>

		<?php if ( $cached_files_count = $this->get_cached_files_count() ) : ?>
			<?php echo intval( $cached_files_count ); ?> files cached.
		<?php endif; ?>

	<?php }

	/**
	 * Output information setting field.
	 *
	 * @return null
	 */
	function information() {	?>
<div>
<p>This technique requires you to do some work so that it works 100% for your setup, the reason why we don't automatically minify and combine the scripts is so that it gives you FULL control of what gets minified and combined. Please watch the video <a href="https://www.youtube.com/watch?v=WuY_KVNMFns" target="_blank">HERE</a> before you set things up.</p>
<p>--</p>
<p>The best setup is to allow Divi to minify and combine their scripts as they do this manually so it is the safest. You can then minify and combine any other scripts added by plugins with this file.</p>
</div>
		<?php }

	/**
	 * Output helper setting field.
	 *
	 * @return null
	 */
	function field_helper() {	?>
		<input type="checkbox" id="nitro_options_helper" name="nitro_options[helper]" <?php checked( true, ( ! ( ! isset( $this->options['helper'] ) || isset( $this->options['helper'] ) && $this->options['helper']  === false ) ) ); ?>/>
		<label for="nitro_options_helper">Enable helper on frontend - here you can see all the scripts that are enqueued, it is only visable to admin users.</label>

	<?php }


	/**
	 * Output settings section for scripts enable/disable toggle.
	 *
	 * @return null
	 */
	function field_method_scripts() {

		if ( empty( $this->options['scripts_method'] ) )
			$this->options['scripts_method'] = 'disabled';

		?>
		<input type="radio" id="nitro_options_scripts_method_manual" name="nitro_options[scripts_method]" value="manual" <?php checked( 'manual', $this->options['scripts_method'] ); ?>/> <label for="nitro_options_scripts_method_manual"style="color: #666;font-size: 16px">Enable script minification</label><br/>
		<input type="radio" id="nitro_options_scripts_method_disabled" name="nitro_options[scripts_method]" value="disabled" <?php checked( 'disabled', $this->options['scripts_method'] ); ?>/> <label for="nitro_options_scripts_method_disabled"style="color: #666;font-size: 16px">Disable script minification</label>

	<?php

}

	/**
	 * Output settings section for scripts queue textarea/s
	 *
	 * @return null
	 */
	function field_scripts() {

		$values = ( ! empty( $this->options['scripts_manual'] ) ) ? $this->options['scripts_manual'] : array();

		?>

		<div id="field_manual_scripts">

			<label for="nitro_field_manual_scripts_0">
			<p><span class="description">Enter in a list of file names you want minified and combined. Comma separated or on a new line</span></p>
				<p><span class="description">Adding a new queue will minify and combine separately.<br> This is useful if you have conflict with combining certain files.</span></p>
				<p><span class="description">Javascript can be placed in the header and footer of the site. You need to include the ones in the header in one box and the footer in another.<br> See the helper on the frontend to see where the files are loaded. If you are unsure, see the video which explains it all.</span></p>
<hr>
				<p><span class="description">It is best to enable "Minify And Combine Javascript Files" in the Divi theme options (as they manually do this before) - we will then merge this file with all the others you add to the queue. </span></p>
<hr>
			</label>

			<textarea id="nitro_field_manual_scripts_hidden" name="nitro_options[scripts_manual][]" class="large-text code input-template" style="display:none;"></textarea>

			<?php for ( $i = 0; $i < ( ( count( $values ) > 0 ) ? count( $values ) : 1 ); $i++ ) : ?>
				<?php if ( $i > 0 && empty( $values[$i]) ) continue; ?>
				<textarea id="nitro_field_manual_scripts_<?php echo esc_attr( $i ); ?>" name="nitro_options[scripts_manual][]" class="large-text code"><?php echo ( ! empty( $values[$i] ) ) ? esc_attr( implode( ', ', $values[$i] ) ) : null; ?></textarea>
			<?php endfor; ?>

		</div>

		<div id="field_disabled_scripts">
			<span style="color: #666;font-size: 16px">Script minification is disabled</span>
		</div>

		<?php

	}

	/**
	 * Output settings section for styles enable/disable toggle.
	 *
	 * @return null
	 */
	function field_method_styles() {

		if ( empty( $this->options['styles_method'] ) )
			$this->options['styles_method'] = 'disabled';

		?>

		<input type="radio" id="nitro_options_styles_method_manual" name="nitro_options[styles_method]" value="manual" <?php checked( 'manual', $this->options['styles_method'] ); ?>/> <label for="nitro_options_styles_method_manual" style="color: #666;font-size: 16px">Enable style minification</label><br/>
		<input type="radio" id="nitro_options_styles_method_disabled" name="nitro_options[styles_method]" value="disabled" <?php checked( 'disabled', $this->options['styles_method'] ); ?>/> <label for="nitro_options_styles_method_disabled" style="color: #666;font-size: 16px">Disable style minification</label>

	<?php }

	/**
	 * Output settings section for styles queue textarea/s
	 *
	 * @return null
	 */
	function field_styles() {

		$values = ( ! empty( $this->options['styles_manual'] ) ) ? $this->options['styles_manual'] : array();

		?>

		<div id="field_manual_styles">

<label for="nitro_field_manual_styles_0">
	<p><span class="description">Enter in a list of file names you want minified and combined. Comma separated or on a new line</span></p>
	<p><span class="description">Adding a new queue will minify and combine separately.<br> This is useful if you have conflict with combining certain files.</span></p>
	<hr>
					<p><span class="description">It is best to enable "Minify And Combine CSS Files" in the Divi theme options (as they manually do this before) - we will then merge this file with all the others you add to the queue. </span></p>
	<hr>

</label>

			<textarea id="nitro_field_manual_styles_template" name="nitro_options[styles_manual][]" class="large-text code input-template" style="display:none;"></textarea>

			<?php for ( $i = 0; $i < ( ( count( $values ) > 0 ) ? count( $values ) : 1 ); $i++ ) : ?>
				<?php if ( $i > 0 && empty( $values[$i]) ) continue; ?>
					<textarea id="nitro_field_manual_styles_<?php echo esc_attr( $i ); ?>" name="nitro_options[styles_manual][]" class="large-text code"><?php echo ( ! empty( $values[$i] ) ) ? esc_attr( implode( ', ', $values[$i] ) ) : null; ?></textarea>
			<?php endfor; ?>

		</div>

		<div id="field_disabled_styles">
			<span style="color: #666;font-size: 16px">Style minification is disabled</span>
		</div>

		<?php

	}

	/**
	 * Output settings section for inline scripts enable/disable toggle.
	 *
	 * @return null
	 */
	function inline_scripts() {

		if ( empty( $this->options['inline_scripts_method'] ) )
			$this->options['inline_scripts_method'] = 'disabled';

		?>
		<p><span class="description" style="color:#d8634f;">Note: please enabled this after you have minified & combined your css and js. If you enable whilst doing this, you may see a white screen, just reload and the cache will be refreshed. If you enable Inline only afterwards this wont happen.</span></p>
		<input type="radio" id="nitro_options_inline_scripts_method_manual" name="nitro_options[inline_scripts_method]" value="manual" <?php checked( 'manual', $this->options['inline_scripts_method'] ); ?>/> <label for="nitro_options_inline_scripts_method_manual" style="color: #666;font-size: 16px">Enable inline script minification</label><br/>
		<input type="radio" id="nitro_options_inline_scripts_method_disabled" name="nitro_options[inline_scripts_method]" value="disabled" <?php checked( 'disabled', $this->options['inline_scripts_method'] ); ?>/> <label for="nitro_options_inline_scripts_method_disabled" style="color: #666;font-size: 16px">Disable inline script minification</label>

	<?php }

	/**
	 * Settings validation.
	 *
	 * @return null
	 */
	function validate_options( $input ) {

		if ( ! empty( $input['scripts_manual'] ) ) {

			foreach ( $input['scripts_manual'] as $key => $queue )
				$input['scripts_manual'][$key] = $this->validate_handle_list( $queue );

			// Remove empty & reset array keys.
			$input['scripts_manual'] = array_merge( array_filter( $input['scripts_manual'] ) );

		}

		if ( ! empty( $input['styles_manual'] ) ) {

			foreach ( $input['styles_manual'] as $key => $queue )
				$input['styles_manual'][$key] = $this->validate_handle_list( $queue );

			// Remove empty & reset array keys.
			$input['styles_manual'] = array_merge( array_filter( $input['styles_manual'] ) );

		}

		$input['helper'] = ( empty( $input['helper'] ) ) ? false : true;

		// If method is manual, and no manual handles are set, disable minification.
		if ( isset( $input['styles_method'] ) && 'manual' == $input['styles_method'] && empty( $input['styles_manual'] ) )
			unset( $input['styles_method'] );
		if ( isset( $input['scripts_method'] ) && 'manual' == $input['scripts_method'] && empty( $input['scripts_manual'] ) )
			unset( $input['scripts_method'] );

		// Delete empty fields
		foreach( $input as $key => $field )
			if ( empty( $field ) )
				unset( $input[$key] );

		return $input;

	}

	/**
	 * Validate the list of handles from the scripts & style queue textareas.
	 *
	 * Deal with new lines, spaces, double commas & convert to array.
	 *
	 * Return an array ready for saving.
	 *
	 * @param  string $list string of comma separated handles
	 * @return array       array of handles
	 */
	function validate_handle_list( $list ) {

		$list = str_replace( array( "\n", "\r" ), ',', $list );

		$list = explode(',', $list );

		foreach ( $list as &$item )
			$item = trim( $item );

		return array_filter( $list );

	}

	/**
	 * Enqueue all scripts required by the admin page
	 *
	 * @return null
	 */
	function enqueue_scripts( $hook ) {

		if ( 'divi-engine_page_nitro' !== $hook )
			return;

		wp_enqueue_script( 'nitro-admin', trailingslashit( plugins_url( basename( __DIR__ ) ) ) . 'js/admin.js' );

	}

	/**
	 * Display Admin notices.
	 *
	 * Hook in on display admin notices, otherwise this is called when saving, before the redirect, causing the notice to be displayed and extra time.
	 *
	 * @return null
	 */
	function display_admin_notices() {

		$current_screen = get_current_screen();

		if ( isset( $this->options['helper'] ) && $this->options['helper'] === true )
			$this->admin_notices->add_notice( 'Nitro Minify helper is currently active on the frontend (admin users only)', true );


		if ( 'divi-engine_page_nitro' == $current_screen->id ) {
			$this->admin_notices->delete_notice( 'nitro_min_activation_notice' );
		}

	}

	/**
	 * Delete all cached files
	 *
	 * @param  boolean $redirect whether
	 * @return [type]            [description]
	 */
	function clear_cache( $redirect = true ) {

		// Delete the cache if requested.
		$minify = new NitroMinify_Scripts();
		$minify->delete_cache();

		// Redirect.
		if ( $redirect ) {
			wp_redirect( remove_query_arg( '_wpnonce' ) );
			exit;
		}

	}

	/**
	 * Get number of cached files.
	 *
	 * @return int number of cached files.
	 */
	function get_cached_files_count() {

		$minify = new NitroMinify_Scripts();
		return $minify->get_cached_files_count();

	}

	function add_nitro_box() {
		$screens = [ 'post', 'page' ];
		foreach ( $screens as $screen ) {
			add_meta_box(
				'nitro_meta_box' ,
				'Remove Scripts',
				array( $this, 'nitro_meta_box_html' ),
				$screen,
				'side'
			);
		}
	}

	function nitro_meta_box_html( $post ) {
		$nitro_js_except = get_post_meta( $post->ID, '_nitro_js_except', true );
        $nitro_css_except = get_post_meta( $post->ID, '_nitro_css_except', true );
?>
	<p>You can remove specific scripts from this page by adding the handler for the file below.</p>
	<p>Use our "Nitro Helper" to identify what scripts are loaded and the handler name.</p>
	<label for="nitro_js_except">JS files to remove from the page</label>
	<input type="text" name="nitro_js_except" id="nitro_js_except" value="<?php echo $nitro_js_except;?>">
	<br/>
	<label for="nitro_css_except">CSS files to remove from the page</label>
	<input type="text" name="nitro_css_except" id="nitro_css_except" value="<?php echo $nitro_css_except;?>">
<?php		
	}

	function save_except_assets( $post_id ) {

        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return $post_id;
        }

        if ( isset( $_POST['nitro_js_except'] ) ) {
        	$nitro_except_js = sanitize_text_field( $_POST['nitro_js_except'] );	
        	update_post_meta( $post_id, '_nitro_js_except', $nitro_except_js );
        }

        if ( isset( $_POST['nitro_css_except'] ) ) {
        	$nitro_except_css = sanitize_text_field( $_POST['nitro_css_except'] );	
        	update_post_meta( $post_id, '_nitro_css_except', $nitro_except_css );
        }
	}



}
$options = nitro_get_options();
if ( isset( $options['inline_scripts_method'] ) && "manual" === $options['inline_scripts_method'] ) {
	require_once dirname( __FILE__ ) .'/minify.php';
}