<?php
if ( ! defined( 'ABSPATH' ) ) exit;

include('titan-framework/titan-framework-embedder.php');

function divi_engine_options() {

    $titan = TitanFramework::getInstance('divi-nitro');

    $get_divi_engine_menu = get_option('divi-engine-menu', null);
    if ($get_divi_engine_menu == "" || $get_divi_engine_menu == "nitro-added") {
        update_option('divi-engine-menu', 'nitro-added');
        $titan = TitanFramework::getInstance('divi-nitro');
        $icon = plugins_url('images/dash-icon.svg', __FILE__);
        $admin_panel2 = $titan->createAdminPanel(array('name' => 'Divi Engine', 'capability' => 'manage_options', 'icon' => $icon . '', 'id' => 'divi-engine',));
        $welcometab = $admin_panel2->createTab(array('name' => 'Welcome',));
        $welcometab->createOption(array(
            'name' => esc_html__( 'Welcome to Divi Engine'),
            'type' => 'heading',
        ));

        $welcometab->createOption(array(
            'type' => 'note',
            'desc' => '<iframe class="nitro_videos" width="560" height="315" src="https://www.youtube.com/embed/jKio-EA4I0k" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>'
        ));

        $welcometab->createOption(array(
            'name' => esc_html__( 'Support'),
            'type' => 'heading',
        ));
        $welcometab->createOption(array(
            'type' => 'note',
            'desc' => esc_html__( 'We know that when building a website things may not always go according to plan. If you experience issues when using Divi Nitro do not worry we are here to help. First take a look at our documentation ').'<a href="https://help.diviengine.com/ " target="_blank">'. esc_html__( 'here') .'</a>'. esc_html__( ' and if you cannot find a solution, please contact us ').' <a href="https://diviengine.com/support/" target="_blank">'. esc_html__( 'here').'</a>'. esc_html__( ' and we will help you resolve any issues.'),
        ));
        $welcometab->createOption(array(
            'name' => 'Feedback',
            'type' => 'heading',
        ));
        $welcometab->createOption(array(
            'type' => 'note',
            'desc' => esc_html__( 'We would love to hear from you, good or bad! We would really appreciate it if you could leave a review on our product page so that it helps others!')
        ));

        $welcometab->createOption(array(
            'name' => esc_html__( 'Do you have idea?'),
            'type' => 'heading',
        ));
        $welcometab->createOption(array(
            'type' => 'note',
            'desc' => esc_html__( 'If you have an idea for how to improve Divi Nitro, please dont hesitate to contact us ') .'<a href="https://diviengine.com/contact/" target="_blank">'. esc_html__( 'here') .'</a>'. esc_html__( ' as we really want to make Divi Nitro better for everyone!')
        ));
    } else {
# code...
    }


//START

    $admin_panel = $titan->createAdminPanel(array('name' => 'Nitro Settings', 'id' => 'divi-nitro', 'parent' => 'divi-engine', 'position' => '9',));
    $imageoptionstab = $admin_panel->createTab(array('name' => 'Defer Images',));
    $backgroundimagetab = $admin_panel->createTab(array('name' => 'Defer Background Images',));
// $imageoptionstabother = $admin_panel->createTab( array('name' => 'Defer Other Plugin Modules',) );
// $minifyjsandcss = $admin_panel->createTab( array('name' => 'Minify Options',) );
    $htaccess = $admin_panel->createTab(array('name' => 'htaccess',));
    $asynccss = $admin_panel->createTab(array('name' => 'Asynchronous CSS',));
    $youtube = $admin_panel->createTab(array('name' => 'Defer Video Module',));
    $otheroptions = $admin_panel->createTab(array('name' => 'Other Speed Options',));
    //Setting Code Start
    $settingstab = $admin_panel->createTab(array('name' => 'Import Export Settings',));
    $licensestab = $admin_panel->createTab(array('name' => 'Nitro License',));
    //Setting Code End
    $get_settings_divi = get_option('divi-et_core_version');
//------------------------------------------------------------------------------------
    $licensestab->createOption(array(
        'name' => 'Nitro License',
        'type' => 'heading',
    ));

    // IMAGE OPTIONS TAB
        $asynccss->createOption(array(
            'name' => 'Asynchronous CSS',
            'type' => 'heading',
        ));

        $asynccss->createOption(array(
            'name' => 'Enable Asynchronous CSS',
            'id' => 'asyc_css_enable',
            'type' => 'enable',
            'default' => false,
            'desc' => 'Click the <i>Enabled</i> switch to load your CSS using acync. Software conflicts can break a website when CSS is loaded using async. Disable this switch if you see any problems.',
        ));
        $asynccss->createOption(array(
            'name' => 'Exclude files from being loaded Asynchronous',
            'type' => 'heading',
        ));

        $asynccss->createOption(array(
            'name' => 'Exclude WooCommerce CSS',
            'id' => 'asyc_css_exclude_woo',
            'type' => 'enable',
            'default' => false,
            'desc' => 'Click the <i>Enable</i> switch if you see issues with your WooCommerce CSS.',
        ));

        $asynccss->createOption(array(
            'name' => 'Exclude Custom CSS Queue',
            'id' => 'asyc_css_exclude_custom_queue',
            'type' => 'text',
            'desc' => 'If you want to exclude specific CSS scripts, find them using the Nitro Helper and add them here comma-seperated with no spaces. For example "divi-style" would be the main Divi CSS file name. If you want to exclude the CSS file that is generated using Divi Nitro Minify, add the name "divi-nitro-styles".',
        ));


            $asynccss->createOption(array(
                'type' => 'save',
            ));

    $youtube->createOption(array(
        'name' => 'Defer Video Module',
        'type' => 'heading',
    ));

    $youtube->createOption(array(
        'type' => 'note',
        'desc' => '<div class="topnotice" style="font-size: 18px; color: #1d0d6f">We have built a fantastic module that only loads your video when a customer clicks the play button. In addition, we have included the ability to customize this module. To use any of these functions, turn on the corresponding switch and then click the save button at the bottom of the tab. You can read more about this feature of Divi Nitro <a href="https://developers.google.com/youtube/player_parameters" target="_blank"> here for YouTube</a> or <a href="https://vimeo.zendesk.com/hc/en-us/articles/360001494447-Using-Player-Parameters" target="_blank"> here for vimeo</a>.</div>'
    ));

    $youtube->createOption(array(
        'name' =>'' . esc_html__("Autoplay", 'divi_nitro_settings') . '',
        'id' => 'youtube_autoplay',
        'type' => 'enable',
        'default' => true,
    ));

    $youtube->createOption(array(
        'name' =>'' . esc_html__("Mute on Autoplay", 'divi_nitro_settings') . '',
        'id' => 'youtube_autoplay_mute',
        'type' => 'enable',
        'default' => false,
        'desc' => '' . esc_html__("Please know that Google sometimes stops autoplay. To gaurantee autoplay, enable the mute setting.", 'divi_nitro_settings') . ''
    ));

    $youtube->createOption(array(
        'name' => '' . esc_html__("Color", 'divi_nitro_settings') . '',
        'id' => 'youtube_color',
        'type' => 'select',
        'options' => array(
            'white' => '' . esc_html__("White", 'divi_bodycommerce_settings') . '',
            'red' => '' . esc_html__("Red", 'divi_bodycommerce_settings') . '',
        ),
        'default' => 'red',
    ));

    $youtube->createOption(array(
        'name' => 'Controls',
        'id' => 'youtube_controls',
        'type' => 'enable',
        'default' => true,
    ));

    $youtube->createOption(array(
        'name' => 'Fullscreen',
        'id' => 'youtube_fs',
        'type' => 'enable',
        'default' => true,
    ));

    $youtube->createOption(array(
        'name' => 'Loop',
        'id' => 'youtube_loop',
        'type' => 'enable',
        'default' => false,
    ));

    $youtube->createOption(array(
        'name' => 'Modestbranding',
        'id' => 'youtube_modestbranding',
        'type' => 'enable',
        'default' => false,
    ));

    $youtube->createOption(array(
        'name' => 'Rel',
        'id' => 'youtube_rel',
        'type' => 'enable',
        'default' => true,
    ));

    $youtube->createOption(array(
        'type' => 'save',
    ));


// IMAGE OPTIONS TAB
    $imageoptionstab->createOption(array(
        'name' => 'Defer Images',
        'type' => 'heading',
    ));

    $imageoptionstab->createOption(array(
        'name' => 'Defer Images',
        'id' => 'defer_all',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch to defer all the images on your Divi website.',
    ));


    $imageoptionstab->createOption(array(
        'type' => 'save',
    ));

//-------------------------------------------------------------------------------------------------------------------------------------------------------
// DEFER BACKGROUND IMAGE

    $backgroundimagetab->createOption(array(
        'name' => 'Defer Background Images',
        'type' => 'heading',
    ));
    $backgroundimagetab->createOption(array(
        'type' => 'note',
        'desc' => '<div class="topnotice" style="font-size: 18px; color: #1d0d6f">Deferring a background image is not as straightforward as an image. To defer all background images that you have added into Divi’s section building block, enable the switch titled <i>Defer Section Images</i> and then click the <i>Save Changes</i> button. If you would like to defer a background image that you have added into Divi’s row or module building block then follow the steps below.
        After completing these steps you will need to go to the Divi builder and edit the row or module where the background image is found by adding your custom ID into the <i>Advanced</i> tab.<br><br>
         <ol>
         <li> Enter a unique ID name for your first image. Our suggestion is background_image_1.</li>
         <li> Copy and paste your image URL (found in wp-admin Media Gallery) of image one into the box provided.</li>
         <li> If you want the image to use parallax then enable this, but make sure that you enable parallax in the section.</li>
         <li> Click the <i>Save Changes</i> button.</li>
         <li>Repeat this process for up to ten images.</ol></div>'
    ));

    $backgroundimagetab->createOption(array(
        'name' => 'Defer Section Images',
        'id' => 'defer_all_background',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch to defer all the section background images on your Divi website. Use section image size slider to specify the size below which to defer.',
    ));

    $backgroundimagetab->createOption(array(
        'name' => '' . esc_html__("Section Image Size", 'divi_nitro_settings') . '',
        'id' => 'defer_all_background_from_top',
        'type' => 'number',
        'default' => '1000',
        'min' => '0',
        'max' => '5000',
        'step' => '1',
        'unit' => 'px',
    ));

    $backgroundimagetab->createOption(array(
        'name' => '' . esc_html__("Defer Background Image Timeout", 'divi_nitro_settings') . '',
        'id' => 'defer_all_background_timeout',
        'type' => 'number',
        'default' => '1000',
        'min' => '0',
        'max' => '5000',
        'step' => '100',
        'unit' => 's',
    ));

    $backgroundimagetab->createOption(array(
        'name' => 'Background Image One',
        'type' => 'heading',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'ID',
        'id' => 'background_image_one_idname',
        'type' => 'text',
        'desc' => 'Custom ID for background image one.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'URL',
        'id' => 'background_image_one_url',
        'type' => 'text',
        'desc' => 'URL for background image one.'
    ));

    $backgroundimagetab->createOption(array(
        'name' => 'Enable Parallax',
        'id' => 'background_image_one_enable_parallax',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch if you are using parallax on the background image in the Divi builder.',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'CSS or True Parallax',
        'id' => 'background_image_one_parallax_style',
        'type' => 'enable',
        'default' => false,
        'enabled' => 'TRUE',
        'disabled' => 'CSS ',
        'desc' => 'If parallax, do you want it to be css or true parallax?',
    ));

    $backgroundimagetab->createOption(array(
        'name' => 'Background Image Two',
        'type' => 'heading',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'ID',
        'id' => 'background_image_two_idname',
        'type' => 'text',
        'desc' => 'Custom ID name for background image two.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'URL',
        'id' => 'background_image_two_url',
        'type' => 'text',
        'desc' => 'URL for background image two.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'Enable Parallax',
        'id' => 'background_image_two_enable_parallax',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch if you are using parallax on the background image in the Divi builder.',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'CSS or True Parallax',
        'id' => 'background_image_two_parallax_style',
        'type' => 'enable',
        'default' => false,
        'enabled' => 'TRUE',
        'disabled' => 'CSS ',
        'desc' => 'If parallax, do you want it to be css or true parallax?',
    ));

    $backgroundimagetab->createOption(array(
        'name' => 'Background Image Three',
        'type' => 'heading',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'ID',
        'id' => 'background_image_three_idname',
        'type' => 'text',
        'desc' => 'Custom ID name for background image three.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'URL',
        'id' => 'background_image_three_url',
        'type' => 'text',
        'desc' => 'URL for background image three.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'Enable Parallax',
        'id' => 'background_image_three_enable_parallax',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch if you are using parallax on the background image in the Divi builder.',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'CSS or True Parallax',
        'id' => 'background_image_three_parallax_style',
        'type' => 'enable',
        'default' => false,
        'enabled' => 'TRUE',
        'disabled' => 'CSS ',
        'desc' => 'If parallax, do you want it to be css or true parallax?',
    ));

    $backgroundimagetab->createOption(array(
        'name' => 'Background Image Four',
        'type' => 'heading',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'ID',
        'id' => 'background_image_four_idname',
        'type' => 'text',
        'desc' => 'Custom ID name for background image four.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'URL',
        'id' => 'background_image_four_url',
        'type' => 'text',
        'desc' => 'URL for background image four.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'Enable Parallax',
        'id' => 'background_image_four_enable_parallax',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch if you are using parallax on the background image in the Divi builder.',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'CSS or True Parallax',
        'id' => 'background_image_four_parallax_style',
        'type' => 'enable',
        'default' => false,
        'enabled' => 'TRUE',
        'disabled' => 'CSS ',
        'desc' => 'If parallax, do you want it to be css or true parallax?',
    ));

    $backgroundimagetab->createOption(array(
        'name' => 'Background Image Five',
        'type' => 'heading',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'ID',
        'id' => 'background_image_five_idname',
        'type' => 'text',
        'desc' => 'Custom ID name for background image five.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'URL',
        'id' => 'background_image_five_url',
        'type' => 'text',
        'desc' => 'URL for background image five.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'Enable Parallax',
        'id' => 'background_image_five_enable_parallax',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch if you are using parallax on the background image in the Divi builder.',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'CSS or True Parallax',
        'id' => 'background_image_five_parallax_style',
        'type' => 'enable',
        'default' => false,
        'enabled' => 'TRUE',
        'disabled' => 'CSS ',
        'desc' => 'If parallax, do you want it to be css or true parallax?',
    ));

    $backgroundimagetab->createOption(array(
        'name' => 'Background Image Six',
        'type' => 'heading',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'ID',
        'id' => 'background_image_six_idname',
        'type' => 'text',
        'desc' => 'Custom ID name for background image six.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'URL',
        'id' => 'background_image_six_url',
        'type' => 'text',
        'desc' => 'URL for background image six.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'Enable Parallax',
        'id' => 'background_image_six_enable_parallax',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch if you are using parallax on the background image in the Divi builder.',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'CSS or True Parallax',
        'id' => 'background_image_six_parallax_style',
        'type' => 'enable',
        'default' => false,
        'enabled' => 'TRUE',
        'disabled' => 'CSS ',
        'desc' => 'If parallax, do you want it to be css or true parallax?',
    ));

    $backgroundimagetab->createOption(array(
        'name' => 'Background Image Seven',
        'type' => 'heading',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'ID',
        'id' => 'background_image_seven_idname',
        'type' => 'text',
        'desc' => 'Custom ID name for background image seven.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'URL',
        'id' => 'background_image_seven_url',
        'type' => 'text',
        'desc' => 'URL for background image seven.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'Enable Parallax',
        'id' => 'background_image_seven_enable_parallax',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch if you are using parallax on the background image in the Divi builder.',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'CSS or True Parallax',
        'id' => 'background_image_seven_parallax_style',
        'type' => 'enable',
        'default' => false,
        'enabled' => 'TRUE',
        'disabled' => 'CSS ',
        'desc' => 'If parallax, do you want it to be css or true parallax?',
    ));

    $backgroundimagetab->createOption(array(
        'name' => 'Background Image Eight',
        'type' => 'heading',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'ID',
        'id' => 'background_image_eight_idname',
        'type' => 'text',
        'desc' => 'Custom ID name for background image eight.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'URL',
        'id' => 'background_image_eight_url',
        'type' => 'text',
        'desc' => 'URL for background image eight.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'Enable Parallax',
        'id' => 'background_image_eight_enable_parallax',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch if you are using parallax on the background image in the Divi builder.',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'CSS or True Parallax',
        'id' => 'background_image_eight_parallax_style',
        'type' => 'enable',
        'default' => false,
        'enabled' => 'TRUE',
        'disabled' => 'CSS ',
        'desc' => 'If parallax, do you want it to be css or true parallax?',
    ));

    $backgroundimagetab->createOption(array(
        'name' => 'Background Image Nine',
        'type' => 'heading',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'ID',
        'id' => 'background_image_nine_idname',
        'type' => 'text',
        'desc' => 'Custom ID name for background image nine.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'URL',
        'id' => 'background_image_nine_url',
        'type' => 'text',
        'desc' => 'URL for background image nine.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'Enable Parallax',
        'id' => 'background_image_nine_enable_parallax',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch if you are using parallax on the background image in the Divi builder.',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'CSS or True Parallax',
        'id' => 'background_image_nine_parallax_style',
        'type' => 'enable',
        'default' => false,
        'enabled' => 'TRUE',
        'disabled' => 'CSS ',
        'desc' => 'If parallax, do you want it to be css or true parallax?',
    ));

    $backgroundimagetab->createOption(array(
        'name' => 'Background Image Ten',
        'type' => 'heading',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'ID',
        'id' => 'background_image_ten_idname',
        'type' => 'text',
        'desc' => 'Custom ID name for background image ten.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'URL',
        'id' => 'background_image_ten_url',
        'type' => 'text',
        'desc' => 'URL for background image ten.'
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'Enable Parallax',
        'id' => 'background_image_ten_enable_parallax',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch if you are using parallax on the background image in the Divi builder.',
    ));
    $backgroundimagetab->createOption(array(
        'name' => 'CSS or True Parallax',
        'id' => 'background_image_ten_parallax_style',
        'type' => 'enable',
        'default' => false,
        'enabled' => 'TRUE',
        'disabled' => 'CSS ',
        'desc' => 'If parallax, do you want it to be css or true parallax?',
    ));

    $backgroundimagetab->createOption(array(
        'type' => 'save',
    ));

//-------------------------------------------------------------------------------------------------------------------------------------------------------
// // OTHER PLUGINS
// $imageoptionstabother->createOption( array(
// 'name' => 'Deffering Image Options',
// 'type' => 'heading',
// ) );
// $imageoptionstabother->createOption( array(
// 'type' => 'note',
// 'desc' => 'Please note that defer image only works on html image and not background images (css). We will look at including this in the future. <br> See a list of available modules to install defer images on. Just click enable and save the page.<br> Dont worry as it does not overwrite any files so you can just disable if you run into any issues. '
// ) );
// // $imageoptionstabother->createOption( array(
// // 'name' => 'Woocommerce',
// // 'type' => 'heading',
// // ) );
// // $imageoptionstabother->createOption( array(
// // 'name' => 'Woocommerce Images',
// // 'id' => 'woocommerce_is_enabled',
// // 'type' => 'enable',
// // 'default' => false,
// // 'desc' => 'Enable defer image of Woocommerce images',
// // ) );
// $imageoptionstabother->createOption( array(
// 'name' => 'Divi/Extra Layout Injector',
// 'type' => 'heading',
// ) );
// $imageoptionstabother->createOption( array(
// 'name' => 'Injector Archive Module',
// 'id' => 'injector_archive_is_enabled',
// 'type' => 'enable',
// 'default' => false,
// 'desc' => 'Enable defer image of the Injector archive module "ET CPT Archive"',
// ) );
// $imageoptionstabother->createOption( array(
// 'name' => 'Injector Featured Image Module',
// 'id' => 'injector_featured_image_is_enabled',
// 'type' => 'enable',
// 'default' => false,
// 'desc' => 'Enable defer images of the Injector featured image module "ET CPT Featured Image"',
// ) );
// $imageoptionstabother->createOption( array(
// 'name' => 'Taxonomy Layout Injector',
// 'type' => 'heading',
// ) );
// $imageoptionstabother->createOption( array(
// 'name' => 'Taxonomy Archive Module',
// 'id' => 'taxonomy_archive_is_enabled',
// 'type' => 'enable',
// 'default' => false,
// 'desc' => 'Enable defer image of the Taxonomy archive module "ET Taxonomy Archive (Basic)"',
// ) );
// $imageoptionstabother->createOption( array(
// 'name' => 'Taxonomy Featured Image Module',
// 'id' => 'taxonomy_featured_image_is_enabled',
// 'type' => 'enable',
// 'default' => false,
// 'desc' => 'Enable defer images of the Taxonomy featured image module "ET Taxonomy/Post Featured Image"',
// ) );
// $imageoptionstabother->createOption( array(
// 'type' => 'save',
// ) );
//-------------------------------------------------------------------------------------------------------------------------------------------------------
// // MINIFY JS AND CSS TAB
// $minifyjsandcss->createOption( array(
// 'name' => 'Minify Options',
// 'type' => 'heading',
// ) );
// $minifyjsandcss->createOption( array(
// 'type' => 'note',
// 'desc' => 'IMPROVED JS AND CSS MINIFICATION<BR><a href="/wp-admin/options-general.php?page=nitro">SEE IT HERE</a><br> or go to Settings > Divi Nitro Minify'
// ) );
// $minifyjsandcss->createOption( array(
// 'type' => 'note',
// 'desc' => 'This technique requires you to do some work so that it works 100% for your setup, the reason why we have changed this is so that it gives you FULL control of what gets minified and combined.<br>Please watch the video below or on Youtube <a href="/admin.php?page=divi-engine" target="_blank" >HERE</a> before you set things up.'
// ) );
// $minifyjsandcss->createOption( array(
// 'type' => 'iframe',
// 'url' => 'https://www.youtube.com/embed/WuY_KVNMFns',
// ) );
//-------------------------------------------------------------------------------------------------------------------------------------------------------
// OTHER OPTIONS

    $otheroptions->createOption(array(
        'name' => 'Other Speed Options',
        'type' => 'heading',
    ));
    $otheroptions->createOption(array(
        'name' => 'Defer Media Library Images',
        'id' => 'defer_editor_enabled',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch to defer images that are added to your wp-admin Media Library. Please know that this software does not defer images already in the gallery. You will need to re-add these.',
    ));
    $otheroptions->createOption(array(
        'name' => 'Disable Divi Scripts',
        'id' => 'divi_scripts_disabled',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch to disable Divi scripts on pages where the builder is not used.',
    ));
    $otheroptions->createOption(array(
        'name' => 'Disable Google Fonts',
        'id' => 'google_fonts_disabled',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch to disable Google fonts. This will not affect fonts added through the Divi customizer. It will only disable fonts you are not using.',
    ));
    $otheroptions->createOption(array(
        'name' => 'Disable Open Sans Font',
        'id' => 'open_sans_fonts_disabled',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch to disable Open Sans Font that gets added with Monarch plugin and default Wordpress.',
    ));
    $otheroptions->createOption(array(
        'name' => 'Remove Query Strings',
        'id' => 'remove_query_strings_enable',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch to remove query strings from static resources.',
    ));

    $admin_url = get_admin_url();
    $html_link = '' . $admin_url . 'options-permalink.php';

    $htaccess->createOption(array(
        'name' => 'htaccess',
        'type' => 'heading',
    ));

    $htaccess->createOption(array(
        'type' => 'note',
        'desc' => '<div class="topnotice" style="font-size: 18px;color: #1d0d6f">Enable each switch below and then click the <i>Save Changes</i> button at the bottom of the tab. After saving these settings, please reset your permalinks by clicking the <i>Save Changes</i> button on your permalinks page.<br><br><a class="button btn" href="' . $html_link . '">Visit Permalink Settings</a><br><br>Please know that if any of your other plugins have made changes to your .htaccess file, then saving your permalinks may cause an issue on your Divi website. Please make sure you have access to ftp or cpanel when saving changes because if there is an issue you can simply rename the .htaccess file to something else and it will work again. You should not have issues but best be safe.</div>'
    ));

    $htaccess->createOption(array(
        'name' => 'Leverage Browser Caching',
        'id' => 'leverage_caching_enable',
        'type' => 'enable',
        'default' => false,
    ));

    $htaccess->createOption(array(
        'name' => 'Enable Gzip Compression',
        'id' => 'gzip_enable',
        'type' => 'enable',
        'default' => false,
    ));

    $htaccess->createOption(array(
        'name' => 'Enable keep-alive',
        'id' => 'keep_alive_enable',
        'type' => 'enable',
        'default' => false,
    ));

    // $htaccess->createOption(array(
    //     'name' => 'Disable Image Hotlinking',
    //     'id' => 'image_hotlink_disable',
    //     'type' => 'enable',
    //     'default' => false,
    //     'desc' => 'Disable Image Hotlinkinge. There are chances that spammers can use your image link on their websites. And because of this, every time when someone visits that webpage, images will be loaded from your server. This is known as Image Hotlinking.',
    // ));

    $htaccess->createOption(array(
        'name' => 'Enable Cache-Control Headers',
        'id' => 'cache_control_enable',
        'type' => 'enable',
        'default' => false,
    ));

    $htaccess->createOption(array(
        'type' => 'save',
    ));


    $otheroptions->createOption(array(
        'name' => 'Remove WordPress Emoji',
        'id' => 'wp_emoji_code_disabled',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch to remove WordPress emoji code.',
    ));
    $otheroptions->createOption(array(
        'name' => 'Enable WooCommerce Script Cleaner',
        'id' => 'disable_woocommerce_scripts_page',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch to remove WooCommerce scripts from unused pages.',
    ));
    $otheroptions->createOption(array(
        'name' => 'Remove Un-used Header Code',
        'id' => 'remove_unused_code_header',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch to remove un-used code from your header:<br>
1) Really simple discovery.<br>
2) Windows live writer.<br>
3) WordPress generator.<br>
4) Post relational links.<br>
5) Remove page and Post short links.',
    ));
    $otheroptions->createOption(array(
        'name' => 'Disable Heartbeat',
        'id' => 'disable_heartbeat',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch to disable the unnecessary WordPress Heartbeat API.',
    ));
    // $otheroptions->createOption(array(
    //     'name' => 'Enable Instant Page/Click',
    //     'id' => 'enable_instant_page',
    //     'type' => 'enable',
    //     'default' => false,
    //     'desc' => 'Instant.page uses just-in-time preloading — it preloads a page right before a user clicks on it. Before a user clicks on a link, they hover their mouse over that link. When a user has hovered for 65 ms there is one chance out of two that they will click on that link, so instant.page starts preloading at this moment, leaving on average over 300 ms for the page to preload.',
    // ));
    $otheroptions->createOption(array(
        'name' => 'Disable Comments JavaScript File',
        'id' => 'disable_comments_js',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch to disable comments on your website.  Enable this to remove the extra resource',
    ));
    $otheroptions->createOption(array(
        'name' => 'Disable JQuery Migrate',
        'id' => 'disable_jquery_migrate',
        'type' => 'enable',
        'default' => false,
        'desc' => 'Click the <i>Enabled</i> switch to remove JQuery migrate. This feature will first check if any scripts need migrate before removing.',
    ));
    $otheroptions->createOption(array(
        'name' => 'Disable Images On Mobile',
        'id' => 'disable_images_mobile',
        'type' => 'text',
        'placeholder' => "hide-mobile",
        'desc' => 'Click the <i>Enabled</i> switch to disable the load of images on mobile (if you only want to show them on desktop), simply give the image a class (or image module) and add the class name here. For example if you use class name "hide-mobile" then insert hide-mobile into this input field.',
    ));
    $otheroptions->createOption(array(
        'type' => 'save',
    ));
    //Setting Code Start
    $settingstab->createOption(array(
        'name' => 'Import Export Settings',
        'type' => 'heading',
    ));

    $settingstab->createOption(array(
        'name' => 'Upload Settings',
        'id' => 'setting_file_upload',
        'type' => 'file',
        'label' => 'Choose File',
        'placeholder' => 'Choose File'
    ));
    $settingstab->createOption(array(
        'id' => "import_setting_btn",
        'name' => 'Import Settings',
        'type' => 'ajax-button',
        'action' => 'divi_import_action',
        'label' => __('Save Settings', 'default'),
        'data_filter_callback' => 'import_settings_data_filter_callback',
        'success_callback' => 'import_settings',
        'class' => array('button-primary', 'button-secondary')
    ));
    $settingstab->createOption(array(
        'name' => 'Export Settings',
        'type' => 'ajax-button',
        'action' => 'divi_export_action',
        'label' => __('Download', 'default'),
        'success_callback' => 'export_settings',
        'class' => array('button-primary', 'button-secondary')
    ));


    $settingstab->createOption(array(
        'type' => 'save',
    ));

        if (isset($_GET['page']) && ($_GET['page'] == 'woo-ms-options' || $_GET['page'] == 'divi-nitro')) { // phpcs:ignore
    $de_dn_option = new DE_DN_options_interface();

    $licensestab->createOption(array(
        'type' => 'custom',
        'custom' => $de_dn_option->admin_menu(),
    ));

        add_action('init', array($de_dn_option, 'options_update'), 1);
    }
}

add_action('tf_create_options', 'divi_engine_options');

//Setting Code Start
add_action('wp_ajax_divi_export_action', 'divi_export_action');

function divi_export_action() {
    // Do something
    $mydata = get_option('divi-nitro_options');
    $mydata = unserialize($mydata);
    $export_data = [];
    foreach ($mydata as $key => $value) {
        $export_data[] = array($key, $value);
    }

    wp_send_json_success(__($export_data, 'default'));
}

add_action('wp_ajax_divi_import_action', 'divi_import_action');

function divi_import_action() {
  $setting_csv = file_get_contents(wp_get_attachment_url($_REQUEST['file_id'])); // phpcs:ignore
  $lines = explode("\n", $setting_csv); // split data by new lines
  $linevalues = [];
  foreach ($lines as $i => $line) {

      $values = explode(',', $line);
      $key = $values[0];
      $value = $values[1];
      if (count($values) > 2) {
          unset($values[0]);
          $value = implode($values, ",");
          $value = trim( $value,'"');
      }
      $linevalues[$key] = trim($value);
  }

  $linevalues = serialize($linevalues);

    update_option('divi-nitro_options',$linevalues);
    wp_send_json_success(__('Settings Saved!', 'default'));
}

//Setting Code End
?>
