<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class DE_DN_INIT {

	function __construct( $options = null ) {

		add_action( 'wp', array( $this, 'init' ), 99 ); // run this as late as possible

	}

	/**
	 * Initialize the setup
	 */
	public function init() {

		/* We do not touch the feeds */
		if ( is_feed() ) {
			return;
		}

			$this->_setup_filtering();
	}


	/**
	 * Set up filtering for certain content
	 */
	protected function _setup_filtering() {

		if ( ! is_admin() ) {

				add_filter( 'dedn/filter', array( __CLASS__, 'filter_images' ) );
				// add_filter( 'dedn/filter', array( __CLASS__, 'filter_iframes' ) );
				add_filter( 'the_content', array( __CLASS__, 'filter' ), 200 );
				add_filter( 'bodycommerce_include_woo_templates', array( __CLASS__, 'filter' ), 200 );
				add_filter( 'widget_text', array( __CLASS__, 'filter' ), 200 );
				add_filter( 'post_thumbnail_html', array( __CLASS__, 'filter' ), 200 );
 				add_filter( 'get_avatar', array( __CLASS__, 'filter' ), 200 );
 				add_filter( 'dedn_defer_images_html', array( __CLASS__, 'filter' ) );
		}

	}

	/**
	 * Filter HTML content. Replace supported content with placeholders.
	 */
	public static function filter( $content ) {

		// Last chance to bail out before running the filter
		$run_filter = apply_filters( 'dedn_defer_images_run_filter', true );
		if ( ! $run_filter ) {
			return $content;
		}

		/**
		 * Filter the content
		 *
		 * @param string $content The HTML string to filter
		 */
		$content = apply_filters( 'dedn/filter', $content );

		return $content;
	}


	/**
	 * Replace images with placeholders in the content
	 *
	 * @param string $content The HTML to do the filtering on
	 * @return string The HTML with the images replaced
	 */
	public static function filter_images( $content ) {


		$data_src_url = 'data:image/png;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=';
		$match_content = self::_get_content_haystack( $content );
		$matches = array();
		preg_match_all( '/<img[\s\r\n]+.*?>/is', $match_content, $matches );
		$search = array();
		$replace = array();
		foreach ( $matches[0] as $imgHTML ) {
			// don't do the replacement if the image is a data-src
			if ( ! preg_match( "/src=['\"]data:image/is", $imgHTML ) ) {


				// replace the src and add the data-src attribute
				$replaceHTML = preg_replace( '/<img(.*?)src=/is', '<img$1src="' . esc_attr( $data_src_url ) . '" data-src=', $imgHTML );

				// also replace the srcset (responsive images)
				$replaceHTML = str_replace( 'srcset', 'data-defer-srcset', $replaceHTML );
				// replace sizes to avoid w3c errors for missing srcset
				$replaceHTML = str_replace( 'sizes', 'data-defer-sizes', $replaceHTML );

				// add the defer class to the img element
				if ( preg_match( '/class=["\']/i', $replaceHTML ) ) {
					$replaceHTML = preg_replace( '/class=(["\'])(.*?)["\']/is', 'class=$1divi-nitro-defer $2$1', $replaceHTML );
				} else {
					$replaceHTML = preg_replace( '/<img/is', '<img class="divi-nitro-defer"', $replaceHTML );
				}

				$replaceHTML .= '<noscript>' . $imgHTML . '</noscript>';

				array_push( $search, $imgHTML );
				array_push( $replace, $replaceHTML );
			}
		}

		$content = str_replace( $search, $replace, $content );

		return $content;

	}

	// /**
	//  * Replace iframes with placeholders in the content
	//  *
	//  * @param string $content The HTML to do the filtering on
	//  * @return string The HTML with the iframes replaced
	//  */
	// public static function filter_iframes( $content ) {
	//
	//
	// 	$data_src_url = 'data:image/png;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=';
	//
	// 	$match_content = self::_get_content_haystack( $content );
	//
	// 	$matches = array();
	// 	preg_match_all( '|<iframe\s+.*?</iframe>|si', $match_content, $matches );
	//
	// 	$search = array();
	// 	$replace = array();
	//
	// 	foreach ( $matches[0] as $iframeHTML ) {
	//
	// 		// Don't mess with the Gravity Forms ajax iframe
	// 		if ( strpos( $iframeHTML, 'gform_ajax_frame' ) ) {
	// 			continue;
	// 		}
	//
	// 		$replaceHTML = '<img src="' . esc_attr( $data_src_url ) . '"  class="divi-nitro-defer" data-src="' . esc_attr( $iframeHTML ) . '" alt="">';
	//
	// 		$replaceHTML .= '<noscript>' . $iframeHTML . '</noscript>';
	//
	// 		array_push( $search, $iframeHTML );
	// 		array_push( $replace, $replaceHTML );
	// 	}
	//
	// 	$content = str_replace( $search, $replace, $content );
	//
	// 	return $content;
	//
	// }

	protected static function _get_content_haystack( $content ) {
		$content = self::remove_noscript( $content );
		return $content;
	}


	public static function remove_noscript( $content ) {
		return preg_replace( '/<noscript.*?(\/noscript>)/i', '', $content );
	}


}
