import React, { useContext, Component } from 'react'
import ReactDOM from 'react-dom'

class et_pb_de_nitro_defer_video extends Component {

    static slug = 'et_pb_de_nitro_defer_video'

    constructor(props) {
        super(props)
        this.state = {
            imageLoaded: false,
            fileSrc: '',
        }

        const api = window.ET_Builder.API,
            utils = api.Utils

        this.updateSource = ( youtubeid ) => {
            Promise.all([
                fetch(`https://vimeo.com/api/v2/video/${youtubeid}.json`)
            ])
            .then(([response1]) => Promise.all([response1.json()]))
            .then(([result1]) =>
                this.setState({
                    fileSrc: result1[0].thumbnail_large,
                    imageLoaded: true
                })
            )
        }
    }

    componentDidMount() {
        if ( ( typeof this.props.src === 'undefined' || this.props.src === '' ) && this.props.vido_type === 'vimeo' && this.props.youtubeid !== '' && this.state.imageLoaded === false) {
            this.updateSource( this.props.youtubeid )
        }
    }

    componentDidUpdate(prevProps) {
        if ( ( typeof this.props.src === 'undefined' || this.props.src === '' ) && ( prevProps.vido_type !== this.props.vido_type || prevProps.youtubeid !== this.props.vido_type ) && this.props.vido_type === 'vimeo' ) {
            this.updateSource( this.props.youtubeid )
        }
    }

    static css(props) {
        var css = []

        const api = window.ET_Builder.API,
            accentColor = window.ETBuilderBackend.etBuilderAccentColor,
            utils = api.Utils

        let icon_color = utils.hasValue(props.icon_color) ? props.icon_color : accentColor
        // font_icon = utils.hasValue(props.font_icon) ? props.font_icon : ''

        if ( props.custom_button === 'on' && "" !== props.button_icon && "on" === props.button_use_icon ) {
            if ( "left" === props.button_icon_placement ) {
                css.push([{
                    selector: 'body #page-container %%order_class%% .et_pb_button:before',
                    declaration: `content: "${utils.processFontIcon(props.button_icon)}"!important;
                                  font-family: ${utils.processIconFontData(props.button_icon).iconFontFamily} !important;
                                  font-weight: ${utils.processIconFontData(props.button_icon).iconFontWeight} !important;`
                }])
            } else if ( "right" === props.button_icon_placement ) {
                css.push([{
                    selector: 'body #page-container %%order_class%% .et_pb_button:after',
                    declaration: `content: "${utils.processFontIcon(props.button_icon)}"!important;
                                  font-family: ${utils.processIconFontData(props.button_icon).iconFontFamily} !important;
                                  font-weight: ${utils.processIconFontData(props.button_icon).iconFontWeight} !important;`
                }])
            }
        }

        if ( "" !== props.button_bg_color ) {
            css.push([{
                selector: 'body #page-container %%order_class%% .et_pb_button',
                declaration: `background-color: "${props.button_bg_color}"!important;`
            }])
        }

        return css
    }

    render() {

        var src = this.props.src;
        var youtubeid = this.props.youtubeid;
        var video_type = this.props.vido_type;

        if ( ( typeof src === 'undefined' || src === '' ) && youtubeid !== '') {
            if ( video_type === 'youtube' ) {
                src = "https://img.youtube.com/vi/" + youtubeid + "/0.jpg"; 
            } else {
                if ( this.state.imageLoaded === true ) {
                    src = this.state.fileSrc;
                } else {
                    src= "";
                }
            }                
        }

        return React.createElement("div", {
            dangerouslySetInnerHTML: {
                __html: '<div id="'+youtubeid+'" class="de_dn_youtube_video" data-id="'+youtubeid+'" data-thumb="'+src+'"><div data-id="'+youtubeid+'"><img src="'+src+'"><div class="play"></div></div></div>'
            }
        })
    }
}

export default et_pb_de_nitro_defer_video