<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class de_nitro_defer_video_code extends ET_Builder_Module {

public $vb_support = 'on';

protected $module_credits = array(
  'module_uri' => DE_DN_PRODUCT_URL,
  'author'     => DE_DN_AUTHOR,
  'author_uri' => DE_DN_PRO_URL,
);

                function init() {
                    $this->name       = esc_html__( 'Defer YouTube/Vimeo Video', 'divi-bodyshop-woocommerce' );
                    $this->slug = 'et_pb_de_nitro_defer_video';

          $this->settings_modal_toggles = array(
      			'general' => array(
      				'toggles' => array(
      					'main_content' => esc_html__( 'Module Options', 'divi-bodyshop-woocommerce' ),
      				),
      			),
            'advanced' => array(
              'toggles' => array(
                'play_icon' => esc_html__( 'Play Icon', 'et_builder' ),
                'overlay'   => et_builder_i18n( 'Overlay' ),
              ),
            ),

      		);


                      $this->main_css_element = '%%order_class%%';
                      $this->advanced_fields = array(
        			'fonts' => array(
                'text'   => array(
                                'label'    => esc_html__( 'Text', 'et_builder' ),
                                'css'      => array(
                                        'main' => "{$this->main_css_element} p",
                                ),
                                'font_size' => array('default' => '14px'),
                                'line_height'    => array('default' => '1.5em'),
                ),
        			),
        			'background' => array(
        				'settings' => array(
        					'color' => 'alpha',
        				),
        			),
        			'border' => array(),
        			'custom_margin_padding' => array(
        				'css' => array(
        					'important' => 'all',
        				),
        			),
        		);



            // $this->help_videos = array(
            //   array(
            //     'id'   => esc_html__( 'n2karNiwJ3A', 'divi-bodyshop-woocommerce' ), // YouTube video ID
            //     'name' => esc_html__( 'BodyCommcerce Product Page Template Guide', 'divi-bodyshop-woocommerce' ),
            //   ),
            // );
          }

                  function get_fields() {
                      $fields = array(
                      'vido_type' => array(
                        'label'            => esc_html__( 'Video Source', 'et_builder' ),
                        'description'      => esc_html__( 'Select which video service you are using.', 'et_builder' ),
                        'type'             => 'select',
                        'options'          => array(
                          'youtube'     => esc_html__( 'YouTube', 'et_builder' ),
                          'vimeo' => esc_html__( 'Vimeo', 'et_builder' ),
                        ),
                        'default'          => 'youtube',
                        'option_category'    => 'basic_option',
                        'toggle_slug'      => 'main_content',
                      ),
                  			'src' => array(
                  				'label'              => esc_html__( 'Preview Image', 'et_builder' ),
                  				'type'               => 'upload',
                  				'option_category'    => 'basic_option',
                  				'upload_button_text' => esc_attr__( 'Upload an image', 'et_builder' ),
                  				'choose_text'        => esc_attr__( 'Choose an Image', 'et_builder' ),
                  				'update_text'        => esc_attr__( 'Set As Image', 'et_builder' ),
                  				'affects'            => array(
                  					'alt',
                  	    				),
                  				'description'        => esc_html__( 'Upload a preview image of your youtube clip here', 'et_builder' ),
                  				'toggle_slug'        => 'main_content',
                  			),
                    			'youtubeid' => array(
                    				'label'              => esc_html__( 'YouTube Video ID', 'et_builder' ),
                    				'type'               => 'text',
                    				'option_category'    => 'basic_option',
                    				'description'        => esc_html__( 'Enter in the ID of your video here', 'et_builder' ),
                    				'toggle_slug'        => 'main_content',
                    			),
                  			'alt' => array(
                  				'label'           => esc_html__( 'Image Alternative Text', 'et_builder' ),
                  				'type'            => 'text',
                  				'option_category' => 'basic_option',
                  				'show_if' => true,
                  				'depends_to'      => array(
                  					'src',
                  				),
                  				'description'     => esc_html__( 'This defines the HTML ALT text. A short description of your image can be placed here.', 'et_builder' ),
                  				'toggle_slug'     => 'main_content',
                  			),
                        'defer_video_icon' => array(
                          'label'               => esc_html__('Play Icon', 'divi-machine'),
                          'type'                => 'select_icon',
                          'option_category'     => 'basic_option',
                          'class'               => array('et-pb-font-icon'),
                          'default'           => 'I||divi||400',
                          'tab_slug'       => 'advanced',
                          'toggle_slug'    => 'play_icon',
                          'description'         => esc_html__('Choose the icon for the play icon.', 'divi-machine'),
                        ),
                        'play_icon_color'         => array(
                          'label'          => esc_html__( 'Play Icon Color', 'et_builder' ),
                          'description'    => esc_html__( 'Here you can define a custom color for the play icon.', 'et_builder' ),
                          'type'           => 'color-alpha',
                          'custom_color'   => true,
                          'tab_slug'       => 'advanced',
                          'toggle_slug'    => 'play_icon',
                          'default'        => '#ffffff',
                          'hover'          => 'tabs',
                          'mobile_options' => true,
                          'sticky'         => true,
                        ),
                      );

                      return $fields;
                  }

                  function render($attrs, $content, $render_slug) {

                  //////////////////////////////////////////////////////////////////////

                		$alt                            = $this->props['alt'];
                		$youtubeid                      = $this->props['youtubeid'];
                		$vido_type                      = $this->props['vido_type'];
                    $src                            = $this->props['src'];

                    $play_icon_color                = $this->props['play_icon_color'];
                    $defer_video_icon                = $this->props['defer_video_icon'];


                    $defer_video_icon_rendered = DE_Nitro::et_icon_css_content(esc_attr($defer_video_icon));

                    $defer_video_icon_arr = explode('||', $defer_video_icon);
                    $defer_video_icon_family = ( !empty( $defer_video_icon_arr[1] ) && $defer_video_icon_arr[1] == 'fa' )?'FontAwesome':'ETmodules';
                    $defer_video_icon_weight = ( !empty( $defer_video_icon_arr[2] ))?$defer_video_icon_arr[2]:'400';
                    ET_Builder_Element::set_style($render_slug, array(
                      'selector'    => '%%order_class%% .et_pb_video_play::before',
                      'declaration' => sprintf(
                        'content: "%1$s";
                        color: %2$s;
                        font-family:"%3$s"!important;
                        font-weight:%4$s;',
                        $defer_video_icon_rendered,
                        $play_icon_color,
                        $defer_video_icon_family,
                        $defer_video_icon_weight
                      ),
                    ));

                    

                    if ($vido_type == "youtube") {
                        $vido_type_dis = "de_dn_youtube_listener";

                        if ( $src == "" ) {
                          $src = "https://img.youtube.com/vi/" . $youtubeid . "/0.jpg";
                        }                        
                    } else if ($vido_type == "vimeo") {
                        $vido_type_dis = "de_dn_vimeo_listener";
                        if ( $src == "" ) {
                          $video_info = file_get_contents('https://vimeo.com/api/v2/video/' . $youtubeid . '.json');
                          if ( $video_info !== FALSE ) {
                            $obj = json_decode($video_info);
                            $src = $obj[0]->thumbnail_large;
                          }                          
                        }                      
                    } else {
                        $vido_type_dis = "de_dn_youtube_listener";
                    }

                                  if( is_admin() ){
                                    return;
                                  }
                                  ob_start();

                                  $output = sprintf(
                                    '<div id="%2$s" class="de_dn_youtube_video %3$s" data-id="%2$s" data-thumb="%1$s" data-thumbalt="%4$s" style="background-image:url(%1$s);background-repeat: no-repeat;background-size: cover;background-position: center;"></div>',
                                    $src,
                                    $youtubeid,
                                    $vido_type_dis,
                                    $alt                                  
                                  );

                                  echo $output; // phpcs:ignore

                                  $data = ob_get_clean();

                                   //////////////////////////////////////////////////////////////////////

                                return $data;
                  }
              }

            new de_nitro_defer_video_code;

?>
