<?php
if ( ! defined( 'ABSPATH' ) ) exit;

add_action( 'init', 'nitro_tool' );
function nitro_tool () {
	if ( ! is_user_logged_in() || ! current_user_can( 'manage_options' ) )
		return;
	$options = nitro_get_options();
	if ( isset( $options['helper'] ) && true === $options['helper'] ) {
		add_action( 'wp_head', 'nitro_helper_style' );
		add_action( 'wp_footer', 'nitro_helper', 9999 );
		add_action( 'wp_footer', 'nitro_helper_script', 9999 );
	}

	add_filter( 'et_builder_page_settings_modal_toggles', 'nitro_page_settings_toggles' );
	add_filter( 'et_builder_page_settings_definitions', 'nitro_page_settings_fields' );
	add_filter( 'et_builder_page_settings_values', 'nitro_page_settings_values', 10, 2 );
}

function nitro_page_settings_toggles( $toggles ) {

	if ( empty( $toggles['divi_nitro'] ) ) {
		$toggles['divi_nitro'] = esc_html__( 'Divi Nitro', 'smpl-sample-extension' );
	}

	return $toggles;
}

function nitro_page_settings_fields( $fields ) {
	if ( empty( $fields['divi_nitro_except_js'] ) ) {
		$fields['divi_nitro_except_js'] = array(
			'type'        => 'text',
			'id'          => 'divi_nitro_except_js',
			'show_in_bb'  => false,
			'label'       => 'Except JS handlers',
			'default'     => '',
			'tab_slug'    => 'content',
			'toggle_slug' => 'divi_nitro'
		);
	}

	if ( empty( $fields['divi_nitro_except_css'] ) ) {
		$fields['divi_nitro_except_css'] = array(
			'type'        => 'text',
			'id'          => 'divi_nitro_except_css',
			'show_in_bb'  => false,
			'label'       => 'Except CSS handlers',
			'default'     => '',
			'tab_slug'    => 'content',
			'toggle_slug' => 'divi_nitro'
		);
	}

	return $fields;
}

function nitro_page_settings_values( $values, $post_id ) {
	if ( ! isset( $values['divi_nitro_except_js'] ) ) {
		$values['divi_nitro_except_js'] = get_post_meta( $post_id, '_divi_nitro_except_js', true );
	}

	if ( ! isset( $values['divi_nitro_except_css'] ) ) {
		$values['divi_nitro_except_css'] = get_post_meta( $post_id, '_divi_nitro_except_css', true );
	}

	return $values;
}


function nitro_helper() {
	global $wp_scripts, $wp_styles, $minified_deps;
	$styles_enqueued = array();
	$scripts_enqueued = array();
	if ( ! empty( $wp_scripts ) ) {
		$scripts = wp_clone( $wp_scripts );
		$scripts->done = array();
		$scripts->to_do = array();
		$queue = array_unique( array_merge( array_keys( $minified_deps['WP_Scripts'] ), $scripts->queue ) );
		$scripts->all_deps( $queue );
		$scripts_enqueued = $scripts->to_do;
	}
	if ( ! empty( $wp_styles ) ) {
		$styles = wp_clone( $wp_styles );
		$styles->done = array();
		$styles->to_do = array();
		$queue = array_unique( array_merge( array_keys( $minified_deps['WP_Styles'] ), $styles->queue ) );
		$styles->all_deps( $queue );
		$styles_enqueued = $styles->to_do;
	}
	?>
	<div id="nitro-helper">
		<div id="nitro-helper-containter">
			<h2>JavaScripts</h2>
			<ul>
				<?php nitro_helper_list( $scripts_enqueued ); ?>
			</ul>
			<h2>CSS</h2>
			<ul>
				<?php nitro_helper_list( $styles_enqueued, false ); ?>
			</ul>
			<h2>Information</h2>
			<ul>
				<li class="nitro-group-0">Aqua: in header</li>
				<li class="nitro-group-1">Green: in footer</li>
			</ul>
			<p>Files displayed in the order in which they are loaded.</p>
			<p>If the script is in red and has a line through, this means that it has been minified and combined if you have requested it to.</p>
			<p>Only visible to admin users.<p>
		</div>
	</div>
	<?php
}
/**
 * Output a <li>s of a list of assets for use in the helper
 *
 * @param  array  $asset_list list of handles to display
 * @param  boolean $scripts   whether minifying scripts. If false, minifyling styles.
 * @return null outputs <li> for each handle.
 */
function nitro_helper_list( $asset_list, $scripts = true ) {
	global $minified_deps, $wp_scripts, $wp_styles;
	$options = nitro_get_options();
	if ( $scripts )
		$class = &$wp_scripts;
	else
		$class = &$wp_styles;
	foreach ( $asset_list as $handle ) {
		if ( 0 === strpos( $handle, 'nitro' ) )
			continue;
		$classes = array();
		$classes['group'] = 'nitro-group-' . ( isset( $class->registered[$handle]->extra['group'] ) ? $class->registered[$handle]->extra['group'] : 0 );
		if ( array_key_exists( $handle, $minified_deps[get_class($class)] ) )
			$classes['minified'] = 'nitro-minified';
		$checked = false;
		foreach( $options[( 'WP_Scripts' == get_class($class) ) ? 'scripts_manual' : 'styles_manual'] as $queue )
			if( ! $checked )
				$checked = in_array( $handle, $queue );
		$disabled = ( ! is_user_logged_in() || ! current_user_can( 'manage_options' ) ) ? true : false;
		printf(
			'<li id="%s" class="%s" title="%s"><span class="nitro-icon">%s</span>%s</li>',
			esc_html( $handle ),
			implode( ' ', array_map( 'sanitize_html_class', $classes ) ),
			esc_attr( implode( ', ', $class->registered[$handle]->deps ) ),
			( $checked ) ? '&#10004;' : '&bull;',
			esc_html( $handle )
		);
	}
}
/**
 *
 * @return null
 */
function nitro_helper_style() {
	?>
	<style>
	#admin-bar, #jquery-core, #jquery-migrate, #jquery, #jquery-blockui, #jquery-ui-core, #wpfc-toolbar, #dashicons {display: none !important;}
		#nitro-helper { position: fixed; top: 10px; bottom: 0px; right: 0px; overflow: hidden; width: 100%; border-radius: 10px; background: rgba(0,0,0,0.8); border: none; color: #FFF; padding: 10px; z-index: 9999; }
		.admin-bar #nitro-helper { top: 38px; }
		#nitro-helper form { height: 100%; }
		#nitro-helper-containter { height: 100%; overflow: auto;text-align: center;position: absolute;top: 50%;left: 50%;transform: translate(-50%, -39%); }
		#nitro-helper * { background: none !important; text-shadow: none !important; padding: 0 !important; }
		#nitro-helper h2 {     font-family: sans-serif !important;font-size: 18px !important;line-height: 1.5;letter-spacing: normal;color: #FFF;border-bottom: 1px solid #fff;margin-bottom: 20px;padding-bottom: 10px !important; }
		#nitro-helper ul,
		#nitro-helper p { margin-bottom: 15px; }
		#nitro-helper ul,
		#nitro-helper p,
		#nitro-helper li { padding: 0; margin-left: 0; margin-right: 0; font-size: 10px; font-family: verdana, sans-serif; line-height: 1.5; }
		#nitro-helper li.nitro-group-0 { color: aqua;}
		#nitro-helper li.nitro-group-1 { color: lawngreen;}
		#nitro-helper li input { margin-right: 7px; }
		#nitro-helper li span.nitro-icon { display: inline-block; width: 10px; display: none;  }
		#nitro-helper li:before { content: '\2022'; display: inline-block; width: 10px; }
		#nitro-helper li.nitro-minified { text-decoration: line-through;    color: indianred; }
		#nitro-helper a,
		#nitro-helper a:link,
		#nitro-helper a:visited { color: inherit; text-decoration: none; }
		#nitro-helper a:hover { color: inherit; text-decoration: underline; }
		#nitro-helper-submit,
		#nitro-helper-submit:hover
		#nitro-helper-submit:active { border: 1px solid black !important; border-radius: 5px; box-shadow: inset 0 1px 0 rgba(255,255,255,0.6), inset 0 -1px 3px rgba(0,0,0,0.2); padding-bottom: 3px !important; padding-left: 6px !important; padding-right: 6px !important;
			padding-top: 2px !important; vertical-align: middle; }
		#nitro-helper-submit { background-image: -moz-linear-gradient(top,#CCC,#999) !important; background-image: -ms-linear-gradient(top,#CCC,#999) !important; background-image: -webkit-gradient(linear,0 0,0 100%,from(#CCC),to(#999)) !important; background-image: -webkit-linear-gradient(top,#CCC,#999) !important; background-image: -o-linear-gradient(top,#CCC,#999) !important; background-image: -webkit-linear-gradient(top,#CCC,#999) !important; background-image: linear-gradient(top,#CCC,#999) !important;  }
		#nitro-helper-submit:hover { background-image: -moz-linear-gradient(top,#FFF,#AAA) !important; background-image: -ms-linear-gradient(top,#FFF,#AAA) !important; background-image: -webkit-gradient(linear,0 0,0 100%,from(#FFF),to(#AAA)) !important; background-image: -webkit-linear-gradient(top,#FFF,#AAA) !important; background-image: -o-linear-gradient(top,#FFF,#AAA) !important; background-image: -webkit-linear-gradient(top,#FFF,#AAA) !important; background-image: linear-gradient(top,#FFF,#AAA) !important;  }
		#nitro-helper-submit:active {  background-image: -moz-linear-gradient(top,#999,#AAA) !important; background-image: -ms-linear-gradient(top,#999,#AAA) !important; background-image: -webkit-gradient(linear,0 0,0 100%,from(#999),to(#AAA)) !important; background-image: -webkit-linear-gradient(top,#999,#AAA) !important; background-image: -o-linear-gradient(top,#999,#AAA) !important; background-image: -webkit-linear-gradient(top,#999,#AAA) !important; background-image: linear-gradient(top,#999,#AAA) !important; box-shadow: inset 0 -1px 1px rgba(255,255,255,0.3), inset 0 1px 3px rgba(0,0,0,0.2); }
	</style>
	<?php
}

/**
 * @return null
 */
function nitro_helper_script() {
	
	?>
	<script>
		var NitroMinify = {
			display : document.getElementById('nitro-helper'),
			button  : document.createElement('a'),
			insertButton : function() {
				var button = this.button,
				    adminBarContainer = document.getElementById( 'wp-admin-bar-top-secondary' ),
				    li = document.createElement( 'li' );
				button.setAttribute( 'href', '#');
				button.setAttribute('class', 'ab-item' );
				button.appendChild( document.createTextNode( 'NitroMinify' ) );
				li.appendChild( button );
				adminBarContainer.appendChild( li );
			},
			toggleDisplay : function(e,el) {
				if ( this.display.style.display === 'block' )
					this.display.style.display = 'none';
				else
					this.display.style.display = 'block';
			},
			init : function() {
				var self = this;
				self.display.style.display = 'none';
				self.insertButton();
				self.button.addEventListener( 'click', function(e) {
					self.toggleDisplay.call( self, e, this )
				} );
			}
		}
		NitroMinify.init();
	</script>
	<?php
}
