<?php

/**
 * App class for Stock Sync with Google Sheet for WooCommerce Ultimate
 *
 * @package StockSyncWithGoogleSheetForWooCommerceUltimate
 * @since 1.0.0
 */

// Namespace.
namespace StockSyncWithGoogleSheetForWooCommerceUltimate;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit( 1 );

if ( ! class_exists( '\StockSyncWithGoogleSheetForWooCommerceUltimate\App' ) ) {

	/**
	 * App class for Stock Sync with Google Sheet for WooCommerce Ultimate
	 *
	 * @package StockSyncWithGoogleSheetForWooCommerceUltimate
	 * @since 1.0.0
	 */
	class App {


		/**
		 * Main plugin file
		 *
		 * @var string
		 */
		public $free_version = 'stock-sync-with-google-sheet-for-woocommerce/stock-sync-with-google-sheet-for-woocommerce.php';

		/**
		 * Is license active
		 *
		 * @var bool
		 */
		public $license_active = null;

		/**
		 * Checks if the plugin is installed
		 *
		 * @return bool
		 */
		public function is_plugin_installed() {
			// Check if WooCommerce is installed in plugin folder.
			if ( file_exists( WP_PLUGIN_DIR . '/' . $this->free_version ) ) {
				return true;
			}
			return true;
		}

		/**
		 * Checks if the plugin is activated
		 *
		 * @return bool
		 */
		public function is_plugin_activated() {
			if ( is_plugin_active( $this->free_version ) ) {
				return true;
			}

			return false;
		}

		/**
		 * Get Appsero Client
		 *
		 * @return \Appsero\Client|void
		 */
		public function get_appsero_client() {
		
			if ( ! class_exists( '\StockSyncWithGoogleSheetForWooCommerceUltimate\Appsero\Client' ) ) {
				require_once SSGSW_ULTIMATE_INCLUDES . '/appsero/Client.php';
			}
			require_once SSGSW_ULTIMATE_INCLUDES . '/appsero/Updater.php';
			// appsero_is_local FALSE.
			add_filter( 'appsero_is_local', '__return_false' );

			return new \StockSyncWithGoogleSheetForWooCommerceUltimate\Appsero\Client(
				'7040dc2d-ee25-4267-acbc-0f58de3f5e49',
				'Stock Sync with Google Sheet for WooCommerce Ultimate',
				SSGSW_ULTIMATE
			);
		}

		/**
		 * Is License Activated
		 *
		 * @return bool
		 */
		public function is_license_active() {
			global $ssgsw_license;

			if ( is_null( $this->license_active ) ) {
				return false;
			}

			return $ssgsw_license->is_valid();
		}
	}
}