<?php

/**
 * Step 1 template for setup.
 *
 * @package StockSyncWithGoogleSheetForWooCommerce
 * @since   1.0.0
 */

// Exit if accessed directly.
defined('ABSPATH') || exit(); ?>
<div class="ssgs-tab__pane" :class="{'active' : isStep(1), 'bounceInRight' : state.doingNext, 'bounceInLeft' : state.doingPrev}">
	<div :class="{'active' : isFirstScreen, 'bounceInRight' : state.doingNext, 'bounceInLeft' : state.doingPrev}" class="ssgs-credential">
		<div class="entry-title text-center">
			<h3 class="title"><?php esc_html_e('Add Credentials', 'stock-sync-with-google-sheet-for-woocommerce'); ?>
				<span class="ssgs-tooltip bottom"><i class="ssgs-help"></i>
					<span><?php esc_html_e('Adding credential here will allow you to sync your store products within seconds from Google Sheets.', 'stock-sync-with-google-sheet-for-woocommerce'); ?></span>
				</span>
			</h3>
			<p class="description credential">
				<?php
				printf(
					'%1$s <strong>%2$s</strong> %3$s <a target="_blank" href="https://console.cloud.google.com/apis/credentials"><span class="ssgs-link">%4$s</span></a> %5$s <strong><i>credentials.json</i></strong> %6$s',
					esc_html__('Create a', 'stock-sync-with-google-sheet-for-woocommerce'),
					esc_html__('Service Account', 'stock-sync-with-google-sheet-for-woocommerce'),
					esc_html__('from your', 'stock-sync-with-google-sheet-for-woocommerce'),
					esc_html__('Google Cloud Platform', 'stock-sync-with-google-sheet-for-woocommerce'),
					esc_html__('and download the', 'stock-sync-with-google-sheet-for-woocommerce'),
					esc_html__('file', 'stock-sync-with-google-sheet-for-woocommerce')
				);
				?>
			</p>
		</div>

		<div class="ssgs-row align-items-center">
			<div class="ssgs-column">
				<div class="upload-credentials">
					<!-- <label for="credentialjson" class="title">
					<?php
					printf('%s credential.json %s', esc_html__('Upload the', 'stock-sync-with-google-sheet-for-woocommerce'), esc_html__('file here', 'stock-sync-with-google-sheet-for-woocommerce'));
					?>
																	</label> -->
					<input type="file" id="credentialjson" accept="application/json">
				</div>
			</div>

			<div class="ssgs-column">
				<div class="ssgs-video-wrapper">
					<h4 class="title">
						<?php
						printf(
							'%s <span class="ssgs-badge gray">1:46</span>',
							esc_html__('How to add Credentials?', 'stock-sync-with-google-sheet-for-woocommerce')
						);
						?>
					</h4>

					<div class="sgss-video play-icon" data-play="https://youtu.be/6yZAQQMBq6M">
						<img src="<?php echo esc_url(SSGSW_PUBLIC . '/images/thumbnails/credentials.png'); ?>" alt="">
					</div>
				</div>
			</div>
		</div>

		<!-- uploaded file name  -->


	</div><!-- /First Step - Credentials -->

	<div :class="{'active' : !isFirstScreen, 'bounceInRight' : state.doingNext, 'bounceInLeft' : state.doingPrev}" class="enable-google-api">
		<div class="ssgs-row align-items-center">
			<div class="ssgs-column">
				<div class="entry-title enable-api-content">
					<h3 class="title">
						<?php
						printf(
							'%s <span class="ssgs-tooltip bottom"><i class="ssgs-help"></i><span><img src="%s" alt="" /></span></span>',
							esc_html__('Enable Google Sheet API', 'stock-sync-with-google-sheet-for-woocommerce'),
							esc_url(SSGSW_PUBLIC . '/images/tooltip/step1_api-enable-api.gif')
						);
						?>
					</h3>
					<p class="description"><span class="serial-number">1</span><a target="_blank" class="ssgs-link" href="https://console.cloud.google.com/apis/library/sheets.googleapis.com">
							<?php esc_html_e('Click here', 'stock-sync-with-google-sheet-for-woocommerce'); ?></a> <?php esc_html_e('to enable Google Sheet API', 'stock-sync-with-google-sheet-for-woocommerce'); ?>
						<?php esc_html_e('Visit the link and enable Google Sheets API', 'stock-sync-with-google-sheet-for-woocommerce'); ?>
						<?php
						printf(
							'%s <span class="label-with-bg">%s</span> %s',
							esc_html__('by clicking the', 'stock-sync-with-google-sheet-for-woocommerce'),
							esc_html__('ENABLE', 'stock-sync-with-google-sheet-for-woocommerce'),
							esc_html__('button as shown in the image', 'stock-sync-with-google-sheet-for-woocommerce')
						);
						?>
					</p>
				</div>
			</div>
			<div class="ssgs-column">
				<svg width="415" viewBox="0 0 415 253" fill="none" xmlns="http://www.w3.org/2000/svg">
					<rect x="0.498786" y="0.498786" width="414.002" height="251.002" rx="4.48908" fill="url(#paint0_linear_779_578)" stroke="#E4E4E4" stroke-width="0.997573" />
					<g opacity="0.3" filter="url(#filter0_d_779_578)">
						<rect x="222" y="180" width="100" height="38" rx="4" fill="white" />
					</g>
					<path opacity="0.9" d="M117.893 36.037V41.2295C117.718 41.4893 117.439 41.7815 117.055 42.1063C116.672 42.4245 116.143 42.7038 115.467 42.9441C114.799 43.1779 113.935 43.2948 112.876 43.2948C112.012 43.2948 111.217 43.1454 110.489 42.8466C109.768 42.5414 109.142 42.0998 108.609 41.5217C108.083 40.9372 107.674 40.2293 107.382 39.398C107.096 38.5602 106.953 37.612 106.953 36.5534V35.4525C106.953 34.3939 107.076 33.4489 107.323 32.6176C107.577 31.7863 107.947 31.0816 108.434 30.5036C108.921 29.9191 109.518 29.4775 110.226 29.1787C110.934 28.8735 111.746 28.7209 112.662 28.7209C113.746 28.7209 114.652 28.9092 115.38 29.2859C116.114 29.6561 116.685 30.1692 117.094 30.8251C117.51 31.4811 117.776 32.2279 117.893 33.0658H116.013C115.929 32.5527 115.76 32.0851 115.506 31.6629C115.26 31.2408 114.906 30.903 114.445 30.6498C113.983 30.39 113.389 30.2601 112.662 30.2601C112.006 30.2601 111.438 30.3802 110.957 30.6205C110.476 30.8608 110.08 31.205 109.768 31.6532C109.457 32.1013 109.223 32.6436 109.067 33.2801C108.918 33.9165 108.843 34.6342 108.843 35.433V36.5534C108.843 37.3717 108.937 38.1023 109.125 38.7453C109.32 39.3883 109.596 39.9371 109.954 40.3917C110.311 40.8398 110.736 41.1808 111.23 41.4146C111.73 41.6484 112.282 41.7653 112.886 41.7653C113.555 41.7653 114.097 41.7101 114.513 41.5997C114.928 41.4828 115.253 41.3464 115.487 41.1905C115.721 41.0281 115.899 40.8755 116.023 40.7326V37.5568H112.74V36.037H117.893ZM120.261 37.9465V37.7224C120.261 36.9625 120.371 36.2579 120.592 35.6084C120.813 34.9524 121.131 34.3842 121.546 33.9036C121.962 33.4165 122.465 33.0398 123.056 32.7735C123.647 32.5007 124.31 32.3643 125.044 32.3643C125.784 32.3643 126.45 32.5007 127.041 32.7735C127.638 33.0398 128.145 33.4165 128.561 33.9036C128.983 34.3842 129.304 34.9524 129.525 35.6084C129.746 36.2579 129.856 36.9625 129.856 37.7224V37.9465C129.856 38.7063 129.746 39.411 129.525 40.0605C129.304 40.7099 128.983 41.2782 128.561 41.7653C128.145 42.2459 127.642 42.6226 127.051 42.8953C126.466 43.1616 125.804 43.2948 125.063 43.2948C124.323 43.2948 123.657 43.1616 123.066 42.8953C122.475 42.6226 121.969 42.2459 121.546 41.7653C121.131 41.2782 120.813 40.7099 120.592 40.0605C120.371 39.411 120.261 38.7063 120.261 37.9465ZM122.063 37.7224V37.9465C122.063 38.4725 122.124 38.9694 122.248 39.437C122.371 39.8981 122.556 40.3072 122.803 40.6645C123.056 41.0217 123.371 41.3042 123.748 41.512C124.125 41.7133 124.563 41.814 125.063 41.814C125.557 41.814 125.989 41.7133 126.359 41.512C126.736 41.3042 127.047 41.0217 127.294 40.6645C127.541 40.3072 127.726 39.8981 127.849 39.437C127.979 38.9694 128.044 38.4725 128.044 37.9465V37.7224C128.044 37.2028 127.979 36.7125 127.849 36.2514C127.726 35.7837 127.538 35.3713 127.284 35.0141C127.038 34.6504 126.726 34.3647 126.349 34.1568C125.979 33.949 125.544 33.8451 125.044 33.8451C124.55 33.8451 124.115 33.949 123.738 34.1568C123.368 34.3647 123.056 34.6504 122.803 35.0141C122.556 35.3713 122.371 35.7837 122.248 36.2514C122.124 36.7125 122.063 37.2028 122.063 37.7224ZM131.639 37.9465V37.7224C131.639 36.9625 131.749 36.2579 131.97 35.6084C132.191 34.9524 132.509 34.3842 132.925 33.9036C133.341 33.4165 133.844 33.0398 134.435 32.7735C135.026 32.5007 135.688 32.3643 136.422 32.3643C137.163 32.3643 137.828 32.5007 138.419 32.7735C139.017 33.0398 139.524 33.4165 139.939 33.9036C140.361 34.3842 140.683 34.9524 140.904 35.6084C141.124 36.2579 141.235 36.9625 141.235 37.7224V37.9465C141.235 38.7063 141.124 39.411 140.904 40.0605C140.683 40.7099 140.361 41.2782 139.939 41.7653C139.524 42.2459 139.02 42.6226 138.429 42.8953C137.845 43.1616 137.182 43.2948 136.442 43.2948C135.701 43.2948 135.036 43.1616 134.445 42.8953C133.854 42.6226 133.347 42.2459 132.925 41.7653C132.509 41.2782 132.191 40.7099 131.97 40.0605C131.749 39.411 131.639 38.7063 131.639 37.9465ZM133.441 37.7224V37.9465C133.441 38.4725 133.503 38.9694 133.626 39.437C133.75 39.8981 133.935 40.3072 134.182 40.6645C134.435 41.0217 134.75 41.3042 135.127 41.512C135.503 41.7133 135.942 41.814 136.442 41.814C136.935 41.814 137.367 41.7133 137.738 41.512C138.114 41.3042 138.426 41.0217 138.673 40.6645C138.92 40.3072 139.105 39.8981 139.228 39.437C139.358 38.9694 139.423 38.4725 139.423 37.9465V37.7224C139.423 37.2028 139.358 36.7125 139.228 36.2514C139.105 35.7837 138.916 35.3713 138.663 35.0141C138.416 34.6504 138.104 34.3647 137.728 34.1568C137.358 33.949 136.922 33.8451 136.422 33.8451C135.929 33.8451 135.494 33.949 135.117 34.1568C134.747 34.3647 134.435 34.6504 134.182 35.0141C133.935 35.3713 133.75 35.7837 133.626 36.2514C133.503 36.7125 133.441 37.2028 133.441 37.7224ZM150.324 32.5592H151.961V42.8759C151.961 43.8046 151.772 44.5969 151.396 45.2529C151.019 45.9088 150.493 46.4057 149.817 46.7434C149.149 47.0876 148.376 47.2597 147.499 47.2597C147.135 47.2597 146.707 47.2013 146.213 47.0844C145.726 46.974 145.245 46.7824 144.771 46.5096C144.304 46.2433 143.911 45.8829 143.592 45.4282L144.537 44.3566C144.979 44.8892 145.44 45.2594 145.921 45.4672C146.408 45.675 146.888 45.779 147.363 45.779C147.934 45.779 148.428 45.6718 148.843 45.4575C149.259 45.2432 149.58 44.9249 149.808 44.5028C150.042 44.0871 150.158 43.574 150.158 42.9635V34.8778L150.324 32.5592ZM143.066 37.9465V37.7419C143.066 36.9365 143.161 36.2059 143.349 35.5499C143.544 34.8875 143.82 34.3192 144.177 33.8451C144.541 33.371 144.979 33.0073 145.492 32.754C146.005 32.4942 146.583 32.3643 147.226 32.3643C147.889 32.3643 148.467 32.4812 148.96 32.715C149.46 32.9424 149.882 33.2768 150.227 33.7185C150.577 34.1536 150.853 34.6797 151.055 35.2967C151.256 35.9136 151.396 36.6118 151.474 37.3912V38.2874C151.402 39.0603 151.263 39.7552 151.055 40.3722C150.853 40.9892 150.577 41.5152 150.227 41.9504C149.882 42.3855 149.46 42.72 148.96 42.9538C148.46 43.1811 147.876 43.2948 147.207 43.2948C146.577 43.2948 146.005 43.1616 145.492 42.8953C144.985 42.6291 144.55 42.2556 144.187 41.775C143.823 41.2944 143.544 40.7294 143.349 40.0799C143.161 39.424 143.066 38.7128 143.066 37.9465ZM144.869 37.7419V37.9465C144.869 38.4725 144.921 38.9661 145.024 39.4272C145.135 39.8883 145.3 40.2943 145.521 40.645C145.749 40.9957 146.038 41.2717 146.388 41.473C146.739 41.6679 147.158 41.7653 147.645 41.7653C148.243 41.7653 148.736 41.6386 149.126 41.3854C149.515 41.1321 149.824 40.7976 150.051 40.3819C150.285 39.9663 150.467 39.5149 150.597 39.0278V36.68C150.525 36.3228 150.415 35.9786 150.266 35.6474C150.123 35.3096 149.934 35.0109 149.701 34.7511C149.473 34.4848 149.191 34.2738 148.853 34.1179C148.515 33.962 148.119 33.8841 147.665 33.8841C147.171 33.8841 146.746 33.988 146.388 34.1958C146.038 34.3971 145.749 34.6764 145.521 35.0336C145.3 35.3843 145.135 35.7935 145.024 36.2611C144.921 36.7222 144.869 37.2158 144.869 37.7419ZM156.656 28.1363V43.0999H154.844V28.1363H156.656ZM163.924 43.2948C163.19 43.2948 162.524 43.1714 161.927 42.9246C161.336 42.6713 160.826 42.3173 160.397 41.8627C159.975 41.4081 159.65 40.869 159.423 40.2455C159.196 39.6221 159.082 38.9401 159.082 38.1997V37.7906C159.082 36.9333 159.209 36.1702 159.462 35.5012C159.715 34.8258 160.059 34.2543 160.495 33.7867C160.93 33.319 161.423 32.9651 161.975 32.7248C162.527 32.4845 163.099 32.3643 163.69 32.3643C164.443 32.3643 165.093 32.4942 165.638 32.754C166.19 33.0138 166.642 33.3775 166.992 33.8451C167.343 34.3062 167.603 34.8518 167.772 35.4817C167.941 36.1052 168.025 36.7872 168.025 37.5276V38.3361H160.154V36.8651H166.223V36.7287C166.197 36.2611 166.099 35.8065 165.931 35.3648C165.768 34.9232 165.508 34.5595 165.151 34.2738C164.794 33.988 164.307 33.8451 163.69 33.8451C163.281 33.8451 162.904 33.9328 162.56 34.1081C162.216 34.277 161.92 34.5303 161.673 34.868C161.427 35.2057 161.235 35.6181 161.099 36.1052C160.962 36.5923 160.894 37.1541 160.894 37.7906V38.1997C160.894 38.6998 160.962 39.1707 161.099 39.6123C161.242 40.0475 161.446 40.4306 161.712 40.7619C161.985 41.0931 162.313 41.3529 162.696 41.5412C163.086 41.7296 163.528 41.8237 164.021 41.8237C164.658 41.8237 165.197 41.6938 165.638 41.4341C166.08 41.1743 166.466 40.8268 166.798 40.3917L167.889 41.2587C167.661 41.6029 167.372 41.9309 167.022 42.2426C166.671 42.5544 166.239 42.8077 165.726 43.0025C165.219 43.1973 164.619 43.2948 163.924 43.2948ZM182.911 39.5149C182.911 39.1837 182.859 38.8914 182.755 38.6381C182.657 38.3783 182.482 38.1445 182.229 37.9367C181.982 37.7289 181.638 37.5308 181.196 37.3425C180.761 37.1541 180.209 36.9625 179.54 36.7677C178.839 36.5599 178.205 36.3293 177.64 36.076C177.075 35.8162 176.592 35.5207 176.189 35.1895C175.786 34.8583 175.478 34.4783 175.263 34.0497C175.049 33.621 174.942 33.1307 174.942 32.5787C174.942 32.0266 175.056 31.5168 175.283 31.0492C175.51 30.5816 175.835 30.1757 176.257 29.8314C176.686 29.4807 177.196 29.208 177.787 29.0131C178.378 28.8183 179.037 28.7209 179.764 28.7209C180.829 28.7209 181.732 28.9254 182.472 29.3346C183.219 29.7373 183.788 30.2666 184.177 30.9225C184.567 31.572 184.762 32.2669 184.762 33.0073H182.891C182.891 32.4747 182.778 32.0039 182.55 31.5947C182.323 31.1791 181.979 30.8543 181.518 30.6205C181.057 30.3802 180.472 30.2601 179.764 30.2601C179.095 30.2601 178.543 30.3607 178.108 30.5621C177.673 30.7634 177.348 31.0362 177.134 31.3804C176.926 31.7246 176.822 32.1175 176.822 32.5592C176.822 32.8579 176.884 33.1307 177.007 33.3775C177.137 33.6178 177.335 33.8419 177.601 34.0497C177.874 34.2575 178.218 34.4491 178.634 34.6245C179.056 34.7998 179.56 34.9687 180.144 35.131C180.949 35.3584 181.644 35.6116 182.229 35.8909C182.813 36.1702 183.294 36.4852 183.671 36.8359C184.054 37.1801 184.336 37.573 184.518 38.0146C184.707 38.4498 184.801 38.9434 184.801 39.4954C184.801 40.0734 184.684 40.5963 184.45 41.0639C184.216 41.5315 183.882 41.9309 183.447 42.2621C183.011 42.5934 182.489 42.8499 181.878 43.0317C181.274 43.2071 180.599 43.2948 179.852 43.2948C179.196 43.2948 178.55 43.2038 177.913 43.022C177.283 42.8401 176.708 42.5674 176.189 42.2037C175.676 41.84 175.263 41.3918 174.952 40.8593C174.646 40.3202 174.494 39.6968 174.494 38.9888H176.364C176.364 39.4759 176.458 39.8948 176.647 40.2455C176.835 40.5898 177.092 40.8755 177.416 41.1028C177.748 41.3301 178.121 41.499 178.537 41.6094C178.959 41.7133 179.397 41.7653 179.852 41.7653C180.508 41.7653 181.063 41.6744 181.518 41.4925C181.972 41.3107 182.317 41.0509 182.55 40.7132C182.791 40.3754 182.911 39.976 182.911 39.5149ZM188.727 28.1363V43.0999H186.924V28.1363H188.727ZM188.298 37.4301L187.548 37.4009C187.554 36.68 187.662 36.0143 187.869 35.4038C188.077 34.7868 188.37 34.251 188.746 33.7964C189.123 33.3418 189.571 32.9911 190.091 32.7443C190.617 32.491 191.198 32.3643 191.834 32.3643C192.354 32.3643 192.822 32.4358 193.237 32.5787C193.653 32.715 194.007 32.9359 194.299 33.2411C194.598 33.5464 194.825 33.9425 194.981 34.4296C195.137 34.9102 195.215 35.498 195.215 36.1929V43.0999H193.403V36.1734C193.403 35.6214 193.322 35.1797 193.159 34.8485C192.997 34.5108 192.76 34.2673 192.448 34.1179C192.136 33.962 191.753 33.8841 191.299 33.8841C190.85 33.8841 190.441 33.9782 190.071 34.1666C189.707 34.3549 189.392 34.6147 189.126 34.9459C188.866 35.2772 188.662 35.6571 188.512 36.0857C188.37 36.5079 188.298 36.956 188.298 37.4301ZM202.287 43.2948C201.554 43.2948 200.888 43.1714 200.29 42.9246C199.699 42.6713 199.19 42.3173 198.761 41.8627C198.339 41.4081 198.014 40.869 197.787 40.2455C197.559 39.6221 197.446 38.9401 197.446 38.1997V37.7906C197.446 36.9333 197.572 36.1702 197.826 35.5012C198.079 34.8258 198.423 34.2543 198.858 33.7867C199.293 33.319 199.787 32.9651 200.339 32.7248C200.891 32.4845 201.463 32.3643 202.054 32.3643C202.807 32.3643 203.456 32.4942 204.002 32.754C204.554 33.0138 205.005 33.3775 205.356 33.8451C205.707 34.3062 205.967 34.8518 206.136 35.4817C206.304 36.1052 206.389 36.7872 206.389 37.5276V38.3361H198.517V36.8651H204.587V36.7287C204.561 36.2611 204.463 35.8065 204.294 35.3648C204.132 34.9232 203.872 34.5595 203.515 34.2738C203.158 33.988 202.671 33.8451 202.054 33.8451C201.644 33.8451 201.268 33.9328 200.924 34.1081C200.579 34.277 200.284 34.5303 200.037 34.868C199.79 35.2057 199.599 35.6181 199.462 36.1052C199.326 36.5923 199.258 37.1541 199.258 37.7906V38.1997C199.258 38.6998 199.326 39.1707 199.462 39.6123C199.605 40.0475 199.81 40.4306 200.076 40.7619C200.349 41.0931 200.677 41.3529 201.06 41.5412C201.45 41.7296 201.891 41.8237 202.385 41.8237C203.021 41.8237 203.56 41.6938 204.002 41.4341C204.444 41.1743 204.83 40.8268 205.161 40.3917L206.252 41.2587C206.025 41.6029 205.736 41.9309 205.385 42.2426C205.035 42.5544 204.603 42.8077 204.09 43.0025C203.583 43.1973 202.982 43.2948 202.287 43.2948ZM212.867 43.2948C212.133 43.2948 211.468 43.1714 210.87 42.9246C210.279 42.6713 209.769 42.3173 209.341 41.8627C208.918 41.4081 208.594 40.869 208.366 40.2455C208.139 39.6221 208.025 38.9401 208.025 38.1997V37.7906C208.025 36.9333 208.152 36.1702 208.405 35.5012C208.659 34.8258 209.003 34.2543 209.438 33.7867C209.873 33.319 210.367 32.9651 210.919 32.7248C211.471 32.4845 212.042 32.3643 212.633 32.3643C213.387 32.3643 214.036 32.4942 214.582 32.754C215.134 33.0138 215.585 33.3775 215.936 33.8451C216.287 34.3062 216.546 34.8518 216.715 35.4817C216.884 36.1052 216.969 36.7872 216.969 37.5276V38.3361H209.097V36.8651H215.166V36.7287C215.14 36.2611 215.043 35.8065 214.874 35.3648C214.712 34.9232 214.452 34.5595 214.095 34.2738C213.737 33.988 213.25 33.8451 212.633 33.8451C212.224 33.8451 211.848 33.9328 211.503 34.1081C211.159 34.277 210.864 34.5303 210.617 34.868C210.37 35.2057 210.178 35.6181 210.042 36.1052C209.906 36.5923 209.837 37.1541 209.837 37.7906V38.1997C209.837 38.6998 209.906 39.1707 210.042 39.6123C210.185 40.0475 210.389 40.4306 210.656 40.7619C210.929 41.0931 211.257 41.3529 211.64 41.5412C212.029 41.7296 212.471 41.8237 212.965 41.8237C213.601 41.8237 214.14 41.6938 214.582 41.4341C215.023 41.1743 215.41 40.8268 215.741 40.3917L216.832 41.2587C216.605 41.6029 216.316 41.9309 215.965 42.2426C215.614 42.5544 215.183 42.8077 214.669 43.0025C214.163 43.1973 213.562 43.2948 212.867 43.2948ZM223.486 32.5592V33.9425H217.787V32.5592H223.486ZM219.716 29.997H221.518V40.4891C221.518 40.8463 221.573 41.1158 221.684 41.2977C221.794 41.4795 221.937 41.5997 222.112 41.6581C222.288 41.7166 222.476 41.7458 222.677 41.7458C222.827 41.7458 222.983 41.7328 223.145 41.7068C223.314 41.6744 223.44 41.6484 223.525 41.6289L223.535 43.0999C223.392 43.1454 223.203 43.1876 222.97 43.2266C222.742 43.272 222.466 43.2948 222.141 43.2948C221.7 43.2948 221.294 43.2071 220.924 43.0317C220.554 42.8564 220.258 42.5641 220.037 42.155C219.823 41.7393 219.716 41.1808 219.716 40.4794V29.997ZM231.737 40.304C231.737 40.0442 231.679 39.8039 231.562 39.5831C231.452 39.3558 231.221 39.1512 230.87 38.9694C230.526 38.781 230.006 38.6186 229.312 38.4823C228.727 38.3589 228.198 38.2127 227.724 38.0439C227.256 37.875 226.857 37.6704 226.525 37.4301C226.201 37.1898 225.951 36.9073 225.775 36.5826C225.6 36.2579 225.512 35.8779 225.512 35.4428C225.512 35.0271 225.603 34.6342 225.785 34.264C225.973 33.8938 226.236 33.5658 226.574 33.2801C226.918 32.9943 227.331 32.7702 227.811 32.6079C228.292 32.4455 228.828 32.3643 229.419 32.3643C230.263 32.3643 230.984 32.5137 231.581 32.8125C232.179 33.1112 232.637 33.5106 232.955 34.0107C233.273 34.5043 233.432 35.0531 233.432 35.6571H231.63C231.63 35.3648 231.542 35.0823 231.367 34.8096C231.198 34.5303 230.948 34.2997 230.617 34.1179C230.292 33.936 229.893 33.8451 229.419 33.8451C228.919 33.8451 228.513 33.923 228.201 34.0789C227.896 34.2283 227.672 34.4199 227.529 34.6537C227.392 34.8875 227.324 35.1343 227.324 35.3941C227.324 35.5889 227.357 35.7643 227.422 35.9201C227.493 36.0695 227.616 36.2091 227.792 36.339C227.967 36.4624 228.214 36.5793 228.532 36.6897C228.85 36.8002 229.256 36.9106 229.75 37.021C230.614 37.2158 231.325 37.4496 231.883 37.7224C232.442 37.9952 232.858 38.3296 233.13 38.7258C233.403 39.122 233.54 39.6026 233.54 40.1676C233.54 40.6287 233.442 41.0509 233.247 41.4341C233.059 41.8172 232.783 42.1485 232.419 42.4277C232.062 42.7005 231.633 42.9148 231.133 43.0707C230.64 43.2201 230.084 43.2948 229.467 43.2948C228.539 43.2948 227.753 43.1292 227.11 42.7979C226.467 42.4667 225.98 42.0381 225.649 41.512C225.317 40.9859 225.152 40.4306 225.152 39.8461H226.964C226.99 40.3397 227.133 40.7326 227.392 41.0249C227.652 41.3107 227.97 41.5152 228.347 41.6386C228.724 41.7555 229.097 41.814 229.467 41.814C229.961 41.814 230.373 41.7491 230.705 41.6192C231.042 41.4893 231.299 41.3107 231.474 41.0834C231.65 40.856 231.737 40.5963 231.737 40.304ZM246.379 30.1724L241.684 43.0999H239.765L245.171 28.9157H246.409L246.379 30.1724ZM250.315 43.0999L245.61 30.1724L245.581 28.9157H246.818L252.244 43.0999H250.315ZM250.072 37.849V39.3883H242.103V37.849H250.072ZM259.375 37.5373H255.586V36.0078H259.375C260.109 36.0078 260.703 35.8909 261.158 35.6571C261.613 35.4233 261.944 35.0986 262.152 34.6829C262.366 34.2673 262.473 33.7931 262.473 33.2606C262.473 32.7735 262.366 32.3156 262.152 31.887C261.944 31.4583 261.613 31.1141 261.158 30.8543C260.703 30.5881 260.109 30.4549 259.375 30.4549H256.024V43.0999H254.144V28.9157H259.375C260.447 28.9157 261.353 29.1008 262.093 29.471C262.833 29.8412 263.395 30.3543 263.778 31.0102C264.162 31.6597 264.353 32.4033 264.353 33.2411C264.353 34.1504 264.162 34.9265 263.778 35.5694C263.395 36.2124 262.833 36.7027 262.093 37.0405C261.353 37.3717 260.447 37.5373 259.375 37.5373ZM268.747 28.9157V43.0999H266.867V28.9157H268.747Z" fill="#242424" />
					<path opacity="0.9" d="M113.648 65.6401V69.0152C113.534 69.1841 113.353 69.374 113.104 69.5851C112.855 69.792 112.51 69.9735 112.071 70.1297C111.637 70.2817 111.075 70.3576 110.387 70.3576C109.826 70.3576 109.308 70.2606 108.836 70.0664C108.367 69.868 107.96 69.5809 107.614 69.2052C107.272 68.8252 107.006 68.3651 106.816 67.8247C106.63 67.2802 106.537 66.6638 106.537 65.9757V65.2602C106.537 64.5721 106.617 63.9579 106.778 63.4175C106.942 62.8772 107.183 62.4191 107.5 62.0434C107.816 61.6635 108.205 61.3764 108.665 61.1822C109.125 60.9838 109.653 60.8846 110.248 60.8846C110.953 60.8846 111.542 61.007 112.014 61.2519C112.491 61.4925 112.863 61.826 113.129 62.2524C113.399 62.6787 113.572 63.1642 113.648 63.7088H112.426C112.371 63.3753 112.261 63.0713 112.097 62.7969C111.936 62.5225 111.706 62.303 111.407 62.1384C111.107 61.9695 110.721 61.8851 110.248 61.8851C109.821 61.8851 109.452 61.9632 109.14 62.1194C108.827 62.2756 108.57 62.4993 108.367 62.7906C108.164 63.0819 108.012 63.4344 107.911 63.8481C107.814 64.2618 107.766 64.7283 107.766 65.2475V65.9757C107.766 66.5076 107.827 66.9826 107.949 67.4005C108.076 67.8184 108.255 68.1751 108.487 68.4706C108.72 68.7619 108.996 68.9835 109.317 69.1355C109.642 69.2875 110.001 69.3635 110.393 69.3635C110.828 69.3635 111.181 69.3276 111.451 69.2558C111.721 69.1798 111.932 69.0912 112.084 68.9899C112.236 68.8843 112.352 68.7851 112.432 68.6923V66.628H110.298V65.6401H113.648ZM115.187 66.8812V66.7356C115.187 66.2417 115.259 65.7837 115.402 65.3615C115.546 64.9351 115.753 64.5658 116.023 64.2534C116.293 63.9367 116.62 63.6919 117.004 63.5188C117.388 63.3415 117.819 63.2529 118.296 63.2529C118.777 63.2529 119.21 63.3415 119.594 63.5188C119.983 63.6919 120.312 63.9367 120.582 64.2534C120.856 64.5658 121.065 64.9351 121.209 65.3615C121.352 65.7837 121.424 66.2417 121.424 66.7356V66.8812C121.424 67.3752 121.352 67.8332 121.209 68.2553C121.065 68.6775 120.856 69.0469 120.582 69.3635C120.312 69.6759 119.985 69.9207 119.6 70.098C119.221 70.2711 118.79 70.3576 118.309 70.3576C117.827 70.3576 117.395 70.2711 117.011 70.098C116.626 69.9207 116.297 69.6759 116.023 69.3635C115.753 69.0469 115.546 68.6775 115.402 68.2553C115.259 67.8332 115.187 67.3752 115.187 66.8812ZM116.358 66.7356V66.8812C116.358 67.2232 116.398 67.5461 116.479 67.8501C116.559 68.1498 116.679 68.4158 116.84 68.6479C117.004 68.8801 117.209 69.0638 117.454 69.1988C117.699 69.3297 117.984 69.3951 118.309 69.3951C118.63 69.3951 118.91 69.3297 119.151 69.1988C119.396 69.0638 119.598 68.8801 119.759 68.6479C119.919 68.4158 120.04 68.1498 120.12 67.8501C120.204 67.5461 120.246 67.2232 120.246 66.8812V66.7356C120.246 66.3979 120.204 66.0792 120.12 65.7794C120.04 65.4755 119.917 65.2074 119.752 64.9752C119.592 64.7388 119.389 64.5531 119.145 64.418C118.904 64.2829 118.621 64.2154 118.296 64.2154C117.975 64.2154 117.692 64.2829 117.448 64.418C117.207 64.5531 117.004 64.7388 116.84 64.9752C116.679 65.2074 116.559 65.4755 116.479 65.7794C116.398 66.0792 116.358 66.3979 116.358 66.7356ZM122.583 66.8812V66.7356C122.583 66.2417 122.655 65.7837 122.798 65.3615C122.942 64.9351 123.149 64.5658 123.419 64.2534C123.689 63.9367 124.016 63.6919 124.4 63.5188C124.784 63.3415 125.215 63.2529 125.692 63.2529C126.173 63.2529 126.606 63.3415 126.99 63.5188C127.379 63.6919 127.708 63.9367 127.978 64.2534C128.252 64.5658 128.461 64.9351 128.605 65.3615C128.748 65.7837 128.82 66.2417 128.82 66.7356V66.8812C128.82 67.3752 128.748 67.8332 128.605 68.2553C128.461 68.6775 128.252 69.0469 127.978 69.3635C127.708 69.6759 127.381 69.9207 126.997 70.098C126.617 70.2711 126.186 70.3576 125.705 70.3576C125.224 70.3576 124.791 70.2711 124.407 70.098C124.023 69.9207 123.693 69.6759 123.419 69.3635C123.149 69.0469 122.942 68.6775 122.798 68.2553C122.655 67.8332 122.583 67.3752 122.583 66.8812ZM123.754 66.7356V66.8812C123.754 67.2232 123.795 67.5461 123.875 67.8501C123.955 68.1498 124.075 68.4158 124.236 68.6479C124.4 68.8801 124.605 69.0638 124.85 69.1988C125.095 69.3297 125.38 69.3951 125.705 69.3951C126.026 69.3951 126.306 69.3297 126.547 69.1988C126.792 69.0638 126.994 68.8801 127.155 68.6479C127.315 68.4158 127.436 68.1498 127.516 67.8501C127.6 67.5461 127.642 67.2232 127.642 66.8812V66.7356C127.642 66.3979 127.6 66.0792 127.516 65.7794C127.436 65.4755 127.313 65.2074 127.149 64.9752C126.988 64.7388 126.785 64.5531 126.541 64.418C126.3 64.2829 126.017 64.2154 125.692 64.2154C125.371 64.2154 125.088 64.2829 124.844 64.418C124.603 64.5531 124.4 64.7388 124.236 64.9752C124.075 65.2074 123.955 65.4755 123.875 65.7794C123.795 66.0792 123.754 66.3979 123.754 66.7356ZM134.728 63.3795H135.792V70.0854C135.792 70.689 135.67 71.2041 135.425 71.6304C135.18 72.0568 134.838 72.3797 134.399 72.5993C133.964 72.823 133.462 72.9349 132.892 72.9349C132.655 72.9349 132.377 72.8969 132.056 72.8209C131.739 72.7491 131.427 72.6246 131.119 72.4473C130.815 72.2742 130.56 72.0399 130.353 71.7444L130.967 71.0479C131.254 71.394 131.554 71.6347 131.866 71.7697C132.183 71.9048 132.495 71.9724 132.803 71.9724C133.175 71.9724 133.496 71.9027 133.766 71.7634C134.036 71.6241 134.245 71.4172 134.393 71.1428C134.545 70.8727 134.621 70.5392 134.621 70.1424V64.8866L134.728 63.3795ZM130.011 66.8812V66.7483C130.011 66.2248 130.072 65.7499 130.194 65.3235C130.321 64.8929 130.5 64.5235 130.733 64.2154C130.969 63.9072 131.254 63.6708 131.587 63.5062C131.921 63.3373 132.297 63.2529 132.715 63.2529C133.145 63.2529 133.521 63.3289 133.842 63.4808C134.167 63.6286 134.441 63.846 134.665 64.133C134.893 64.4159 135.072 64.7578 135.203 65.1589C135.334 65.5599 135.425 66.0137 135.475 66.5203V67.1029C135.429 67.6052 135.338 68.0569 135.203 68.458C135.072 68.859 134.893 69.201 134.665 69.4838C134.441 69.7666 134.167 69.984 133.842 70.136C133.517 70.2838 133.137 70.3576 132.702 70.3576C132.292 70.3576 131.921 70.2711 131.587 70.098C131.258 69.9249 130.975 69.6822 130.739 69.3698C130.503 69.0574 130.321 68.6902 130.194 68.268C130.072 67.8416 130.011 67.3794 130.011 66.8812ZM131.182 66.7483V66.8812C131.182 67.2232 131.216 67.544 131.283 67.8437C131.355 68.1435 131.463 68.4073 131.606 68.6353C131.754 68.8632 131.942 69.0427 132.17 69.1735C132.398 69.3002 132.67 69.3635 132.987 69.3635C133.375 69.3635 133.696 69.2812 133.949 69.1165C134.203 68.9519 134.403 68.7345 134.551 68.4643C134.703 68.1941 134.821 67.9007 134.906 67.5841V66.0581C134.859 65.8259 134.787 65.6021 134.69 65.3868C134.597 65.1673 134.475 64.9731 134.323 64.8043C134.175 64.6312 133.992 64.494 133.772 64.3927C133.553 64.2914 133.295 64.2407 133 64.2407C132.679 64.2407 132.402 64.3082 132.17 64.4433C131.942 64.5742 131.754 64.7557 131.606 64.9879C131.463 65.2159 131.355 65.4818 131.283 65.7858C131.216 66.0855 131.182 66.4063 131.182 66.7483ZM138.844 60.5047V70.231H137.666V60.5047H138.844ZM143.568 70.3576C143.091 70.3576 142.658 70.2774 142.27 70.117C141.886 69.9524 141.554 69.7223 141.276 69.4268C141.001 69.1313 140.79 68.7809 140.643 68.3757C140.495 67.9704 140.421 67.5271 140.421 67.0459V66.7799C140.421 66.2227 140.503 65.7267 140.668 65.2918C140.833 64.8528 141.056 64.4813 141.339 64.1774C141.622 63.8734 141.943 63.6434 142.302 63.4872C142.66 63.331 143.032 63.2529 143.416 63.2529C143.906 63.2529 144.328 63.3373 144.683 63.5062C145.041 63.675 145.335 63.9114 145.563 64.2154C145.791 64.5151 145.96 64.8697 146.069 65.2792C146.179 65.6844 146.234 66.1277 146.234 66.609V67.1345H141.117V66.1784H145.062V66.0897C145.046 65.7858 144.982 65.4903 144.872 65.2032C144.767 64.9161 144.598 64.6797 144.366 64.494C144.134 64.3082 143.817 64.2154 143.416 64.2154C143.15 64.2154 142.905 64.2724 142.682 64.3863C142.458 64.4961 142.266 64.6607 142.105 64.8803C141.945 65.0998 141.82 65.3678 141.732 65.6844C141.643 66.0011 141.599 66.3662 141.599 66.7799V67.0459C141.599 67.3709 141.643 67.677 141.732 67.9641C141.825 68.2469 141.958 68.496 142.131 68.7113C142.308 68.9266 142.521 69.0954 142.77 69.2178C143.023 69.3403 143.311 69.4015 143.631 69.4015C144.045 69.4015 144.395 69.317 144.683 69.1482C144.97 68.9793 145.221 68.7535 145.436 68.4706L146.145 69.0342C145.998 69.2579 145.81 69.4711 145.582 69.6738C145.354 69.8764 145.073 70.041 144.74 70.1677C144.41 70.2943 144.02 70.3576 143.568 70.3576ZM156.853 69.2368V70.231H151.971V69.2368H156.853ZM152.218 61.0112V70.231H150.996V61.0112H152.218ZM156.207 64.9752V65.9694H151.971V64.9752H156.207ZM156.79 61.0112V62.0117H151.971V61.0112H156.79ZM159.361 64.8423V70.231H158.189V63.3795H159.297L159.361 64.8423ZM159.082 66.5456L158.594 66.5266C158.599 66.0581 158.668 65.6253 158.803 65.2285C158.939 64.8275 159.128 64.4792 159.373 64.1837C159.618 63.8882 159.909 63.6602 160.247 63.4998C160.589 63.3352 160.967 63.2529 161.381 63.2529C161.718 63.2529 162.022 63.2993 162.293 63.3922C162.563 63.4808 162.793 63.6244 162.983 63.8228C163.177 64.0212 163.325 64.2787 163.426 64.5953C163.527 64.9077 163.578 65.2897 163.578 65.7414V70.231H162.4V65.7288C162.4 65.3699 162.347 65.0829 162.242 64.8676C162.136 64.6481 161.982 64.4898 161.78 64.3927C161.577 64.2914 161.328 64.2407 161.032 64.2407C160.741 64.2407 160.475 64.3019 160.235 64.4243C159.998 64.5468 159.793 64.7156 159.62 64.9309C159.451 65.1462 159.318 65.3932 159.221 65.6718C159.128 65.9462 159.082 66.2375 159.082 66.5456ZM168.226 63.3795V64.2787H164.521V63.3795H168.226ZM165.775 61.7141H166.947V68.534C166.947 68.7661 166.983 68.9413 167.054 69.0595C167.126 69.1777 167.219 69.2558 167.333 69.2938C167.447 69.3318 167.569 69.3508 167.7 69.3508C167.797 69.3508 167.899 69.3424 168.004 69.3255C168.114 69.3044 168.196 69.2875 168.251 69.2748L168.257 70.231C168.165 70.2606 168.042 70.288 167.89 70.3133C167.742 70.3429 167.563 70.3576 167.352 70.3576C167.065 70.3576 166.801 70.3007 166.56 70.1867C166.32 70.0727 166.128 69.8827 165.984 69.6168C165.845 69.3466 165.775 68.9835 165.775 68.5276V61.7141ZM172.443 70.3576C171.966 70.3576 171.533 70.2774 171.145 70.117C170.761 69.9524 170.429 69.7223 170.151 69.4268C169.876 69.1313 169.665 68.7809 169.518 68.3757C169.37 67.9704 169.296 67.5271 169.296 67.0459V66.7799C169.296 66.2227 169.378 65.7267 169.543 65.2918C169.708 64.8528 169.931 64.4813 170.214 64.1774C170.497 63.8734 170.818 63.6434 171.177 63.4872C171.535 63.331 171.907 63.2529 172.291 63.2529C172.781 63.2529 173.203 63.3373 173.558 63.5062C173.916 63.675 174.21 63.9114 174.438 64.2154C174.666 64.5151 174.835 64.8697 174.944 65.2792C175.054 65.6844 175.109 66.1277 175.109 66.609V67.1345H169.993V66.1784H173.938V66.0897C173.921 65.7858 173.857 65.4903 173.748 65.2032C173.642 64.9161 173.473 64.6797 173.241 64.494C173.009 64.3082 172.692 64.2154 172.291 64.2154C172.025 64.2154 171.78 64.2724 171.557 64.3863C171.333 64.4961 171.141 64.6607 170.98 64.8803C170.82 65.0998 170.695 65.3678 170.607 65.6844C170.518 66.0011 170.474 66.3662 170.474 66.7799V67.0459C170.474 67.3709 170.518 67.677 170.607 67.9641C170.7 68.2469 170.833 68.496 171.006 68.7113C171.183 68.9266 171.396 69.0954 171.645 69.2178C171.899 69.3403 172.186 69.4015 172.506 69.4015C172.92 69.4015 173.271 69.317 173.558 69.1482C173.845 68.9793 174.096 68.7535 174.311 68.4706L175.02 69.0342C174.873 69.2579 174.685 69.4711 174.457 69.6738C174.229 69.8764 173.948 70.041 173.615 70.1677C173.285 70.2943 172.895 70.3576 172.443 70.3576ZM177.648 64.456V70.231H176.477V63.3795H177.617L177.648 64.456ZM179.789 63.3415L179.782 64.4307C179.685 64.4096 179.592 64.3969 179.504 64.3927C179.419 64.3842 179.322 64.38 179.212 64.38C178.942 64.38 178.704 64.4222 178.497 64.5066C178.29 64.5911 178.115 64.7093 177.971 64.8613C177.828 65.0132 177.714 65.1948 177.629 65.4058C177.549 65.6127 177.496 65.8406 177.471 66.0897L177.142 66.2797C177.142 65.866 177.182 65.4776 177.262 65.1145C177.346 64.7515 177.475 64.4307 177.648 64.152C177.821 63.8692 178.041 63.6497 178.307 63.4935C178.577 63.3331 178.898 63.2529 179.269 63.2529C179.354 63.2529 179.451 63.2634 179.561 63.2845C179.67 63.3014 179.746 63.3204 179.789 63.3415ZM182.043 64.6966V72.8652H180.865V63.3795H181.941L182.043 64.6966ZM186.659 66.7483V66.8812C186.659 67.3794 186.6 67.8416 186.482 68.268C186.364 68.6902 186.19 69.0574 185.962 69.3698C185.739 69.6822 185.462 69.9249 185.133 70.098C184.804 70.2711 184.426 70.3576 183.999 70.3576C183.565 70.3576 183.18 70.2859 182.847 70.1424C182.513 69.9988 182.231 69.7899 181.998 69.5155C181.766 69.2411 181.581 68.9118 181.441 68.5276C181.306 68.1435 181.213 67.7108 181.163 67.2295V66.5203C181.213 66.0137 181.308 65.5599 181.448 65.1589C181.587 64.7578 181.771 64.4159 181.998 64.133C182.231 63.846 182.511 63.6286 182.841 63.4808C183.17 63.3289 183.55 63.2529 183.98 63.2529C184.411 63.2529 184.793 63.3373 185.127 63.5062C185.46 63.6708 185.741 63.9072 185.969 64.2154C186.197 64.5235 186.368 64.8929 186.482 65.3235C186.6 65.7499 186.659 66.2248 186.659 66.7483ZM185.481 66.8812V66.7483C185.481 66.4063 185.445 66.0855 185.374 65.7858C185.302 65.4818 185.19 65.2159 185.038 64.9879C184.89 64.7557 184.7 64.5742 184.468 64.4433C184.236 64.3082 183.959 64.2407 183.639 64.2407C183.343 64.2407 183.086 64.2914 182.866 64.3927C182.651 64.494 182.467 64.6312 182.315 64.8043C182.163 64.9731 182.039 65.1673 181.941 65.3868C181.849 65.6021 181.779 65.8259 181.733 66.0581V67.6981C181.817 67.9936 181.935 68.2722 182.087 68.534C182.239 68.7915 182.442 69.0004 182.695 69.1609C182.948 69.317 183.267 69.3951 183.651 69.3951C183.968 69.3951 184.24 69.3297 184.468 69.1988C184.7 69.0638 184.89 68.8801 185.038 68.6479C185.19 68.4158 185.302 68.1498 185.374 67.8501C185.445 67.5461 185.481 67.2232 185.481 66.8812ZM189.325 64.456V70.231H188.153V63.3795H189.293L189.325 64.456ZM191.465 63.3415L191.459 64.4307C191.362 64.4096 191.269 64.3969 191.18 64.3927C191.096 64.3842 190.999 64.38 190.889 64.38C190.619 64.38 190.38 64.4222 190.173 64.5066C189.967 64.5911 189.791 64.7093 189.648 64.8613C189.504 65.0132 189.39 65.1948 189.306 65.4058C189.226 65.6127 189.173 65.8406 189.148 66.0897L188.818 66.2797C188.818 65.866 188.858 65.4776 188.939 65.1145C189.023 64.7515 189.152 64.4307 189.325 64.152C189.498 63.8692 189.717 63.6497 189.983 63.4935C190.254 63.3331 190.574 63.2529 190.946 63.2529C191.03 63.2529 191.127 63.2634 191.237 63.2845C191.347 63.3014 191.423 63.3204 191.465 63.3415ZM193.821 63.3795V70.231H192.643V63.3795H193.821ZM192.554 61.5622C192.554 61.3722 192.611 61.2118 192.725 61.0809C192.844 60.95 193.017 60.8846 193.245 60.8846C193.468 60.8846 193.639 60.95 193.757 61.0809C193.88 61.2118 193.941 61.3722 193.941 61.5622C193.941 61.7437 193.88 61.8999 193.757 62.0307C193.639 62.1574 193.468 62.2207 193.245 62.2207C193.017 62.2207 192.844 62.1574 192.725 62.0307C192.611 61.8999 192.554 61.7437 192.554 61.5622ZM199.691 68.4136C199.691 68.2448 199.653 68.0886 199.577 67.9451C199.505 67.7973 199.355 67.6643 199.127 67.5461C198.903 67.4237 198.566 67.3182 198.114 67.2295C197.734 67.1493 197.39 67.0543 197.082 66.9446C196.778 66.8348 196.518 66.7018 196.303 66.5456C196.092 66.3894 195.929 66.2058 195.815 65.9947C195.701 65.7837 195.644 65.5367 195.644 65.2539C195.644 64.9837 195.704 64.7283 195.822 64.4877C195.944 64.247 196.115 64.0338 196.335 63.8481C196.558 63.6623 196.826 63.5167 197.139 63.4112C197.451 63.3056 197.8 63.2529 198.184 63.2529C198.732 63.2529 199.201 63.35 199.589 63.5441C199.978 63.7383 200.275 63.998 200.482 64.323C200.689 64.6438 200.793 65.0006 200.793 65.3932H199.621C199.621 65.2032 199.564 65.0196 199.45 64.8423C199.34 64.6607 199.178 64.5109 198.963 64.3927C198.751 64.2745 198.492 64.2154 198.184 64.2154C197.859 64.2154 197.595 64.266 197.392 64.3673C197.194 64.4644 197.048 64.589 196.955 64.7409C196.867 64.8929 196.822 65.0533 196.822 65.2222C196.822 65.3488 196.843 65.4628 196.886 65.5641C196.932 65.6612 197.012 65.752 197.126 65.8364C197.24 65.9166 197.401 65.9926 197.607 66.0644C197.814 66.1361 198.078 66.2079 198.399 66.2797C198.96 66.4063 199.423 66.5583 199.786 66.7356C200.149 66.9129 200.419 67.1303 200.596 67.3878C200.774 67.6453 200.862 67.9577 200.862 68.325C200.862 68.6247 200.799 68.8991 200.672 69.1482C200.55 69.3973 200.37 69.6126 200.134 69.7941C199.902 69.9714 199.623 70.1107 199.298 70.212C198.977 70.3091 198.616 70.3576 198.215 70.3576C197.612 70.3576 197.101 70.25 196.683 70.0347C196.265 69.8194 195.948 69.5408 195.733 69.1988C195.518 68.8569 195.41 68.496 195.41 68.116H196.588C196.605 68.4369 196.698 68.6923 196.867 68.8822C197.035 69.068 197.242 69.201 197.487 69.2812C197.732 69.3572 197.975 69.3951 198.215 69.3951C198.536 69.3951 198.804 69.3529 199.02 69.2685C199.239 69.1841 199.406 69.068 199.52 68.9202C199.634 68.7725 199.691 68.6036 199.691 68.4136ZM205.244 70.3576C204.767 70.3576 204.334 70.2774 203.946 70.117C203.562 69.9524 203.231 69.7223 202.952 69.4268C202.677 69.1313 202.466 68.7809 202.319 68.3757C202.171 67.9704 202.097 67.5271 202.097 67.0459V66.7799C202.097 66.2227 202.179 65.7267 202.344 65.2918C202.509 64.8528 202.732 64.4813 203.015 64.1774C203.298 63.8734 203.619 63.6434 203.978 63.4872C204.337 63.331 204.708 63.2529 205.092 63.2529C205.582 63.2529 206.004 63.3373 206.359 63.5062C206.717 63.675 207.011 63.9114 207.239 64.2154C207.467 64.5151 207.636 64.8697 207.745 65.2792C207.855 65.6844 207.91 66.1277 207.91 66.609V67.1345H202.794V66.1784H206.739V66.0897C206.722 65.7858 206.658 65.4903 206.549 65.2032C206.443 64.9161 206.274 64.6797 206.042 64.494C205.81 64.3082 205.493 64.2154 205.092 64.2154C204.826 64.2154 204.581 64.2724 204.358 64.3863C204.134 64.4961 203.942 64.6607 203.781 64.8803C203.621 65.0998 203.496 65.3678 203.408 65.6844C203.319 66.0011 203.275 66.3662 203.275 66.7799V67.0459C203.275 67.3709 203.319 67.677 203.408 67.9641C203.501 68.2469 203.634 68.496 203.807 68.7113C203.984 68.9266 204.197 69.0954 204.446 69.2178C204.7 69.3403 204.987 69.4015 205.307 69.4015C205.721 69.4015 206.072 69.317 206.359 69.1482C206.646 68.9793 206.897 68.7535 207.112 68.4706L207.821 69.0342C207.674 69.2579 207.486 69.4711 207.258 69.6738C207.03 69.8764 206.749 70.041 206.416 70.1677C206.086 70.2943 205.696 70.3576 205.244 70.3576ZM216.085 61.8281L213.033 70.231H211.785L215.3 61.0112H216.104L216.085 61.8281ZM218.643 70.231L215.585 61.8281L215.566 61.0112H216.37L219.897 70.231H218.643ZM218.485 66.8179V67.8184H213.305V66.8179H218.485ZM224.532 66.6153H222.069V65.6211H224.532C225.009 65.6211 225.395 65.5451 225.691 65.3932C225.986 65.2412 226.202 65.0301 226.337 64.7599C226.476 64.4898 226.546 64.1816 226.546 63.8354C226.546 63.5188 226.476 63.2212 226.337 62.9426C226.202 62.664 225.986 62.4402 225.691 62.2714C225.395 62.0983 225.009 62.0117 224.532 62.0117H222.354V70.231H221.132V61.0112H224.532C225.229 61.0112 225.818 61.1316 226.299 61.3722C226.78 61.6128 227.145 61.9463 227.394 62.3727C227.643 62.7948 227.768 63.2782 227.768 63.8228C227.768 64.4138 227.643 64.9182 227.394 65.3362C227.145 65.7541 226.78 66.0728 226.299 66.2923C225.818 66.5076 225.229 66.6153 224.532 66.6153ZM230.624 61.0112V70.231H229.402V61.0112H230.624Z" fill="#828282" />
					<path opacity="0.9" d="M110.586 99.4454V109.374H109.29V99.4454H110.586ZM113.777 99.4454V100.523H106.105V99.4454H113.777ZM116.321 98.8999V109.374H115.059V98.8999H116.321ZM116.021 105.406L115.496 105.385C115.5 104.88 115.575 104.414 115.721 103.987C115.866 103.555 116.071 103.18 116.335 102.862C116.598 102.544 116.912 102.298 117.276 102.125C117.644 101.948 118.051 101.859 118.496 101.859C118.86 101.859 119.187 101.91 119.478 102.01C119.769 102.105 120.017 102.26 120.222 102.473C120.431 102.687 120.59 102.964 120.699 103.305C120.808 103.642 120.863 104.053 120.863 104.539V109.374H119.594V104.526C119.594 104.139 119.537 103.83 119.424 103.598C119.31 103.362 119.144 103.192 118.926 103.087C118.708 102.978 118.439 102.923 118.121 102.923C117.807 102.923 117.521 102.989 117.262 103.121C117.007 103.253 116.787 103.435 116.6 103.667C116.419 103.898 116.275 104.164 116.171 104.464C116.071 104.76 116.021 105.074 116.021 105.406ZM125.813 109.511C125.3 109.511 124.834 109.424 124.415 109.252C124.002 109.074 123.645 108.827 123.345 108.508C123.049 108.19 122.822 107.813 122.663 107.376C122.504 106.94 122.424 106.463 122.424 105.944V105.658C122.424 105.058 122.513 104.524 122.69 104.055C122.867 103.583 123.108 103.182 123.413 102.855C123.718 102.528 124.063 102.28 124.45 102.112C124.836 101.944 125.236 101.859 125.65 101.859C126.177 101.859 126.632 101.95 127.014 102.132C127.4 102.314 127.716 102.569 127.961 102.896C128.207 103.219 128.389 103.601 128.507 104.042C128.625 104.478 128.684 104.955 128.684 105.474V106.04H123.174V105.01H127.423V104.915C127.405 104.587 127.336 104.269 127.218 103.96C127.105 103.651 126.923 103.396 126.673 103.196C126.423 102.996 126.082 102.896 125.65 102.896C125.363 102.896 125.1 102.957 124.859 103.08C124.618 103.198 124.411 103.376 124.238 103.612C124.065 103.848 123.931 104.137 123.836 104.478C123.74 104.819 123.693 105.212 123.693 105.658V105.944C123.693 106.294 123.74 106.624 123.836 106.933C123.936 107.238 124.079 107.506 124.265 107.738C124.456 107.97 124.686 108.151 124.954 108.283C125.227 108.415 125.536 108.481 125.882 108.481C126.327 108.481 126.704 108.39 127.014 108.208C127.323 108.026 127.593 107.783 127.825 107.479L128.589 108.086C128.43 108.327 128.227 108.556 127.982 108.774C127.736 108.993 127.434 109.17 127.075 109.306C126.72 109.443 126.3 109.511 125.813 109.511ZM139.104 106.865C139.104 106.633 139.068 106.428 138.995 106.251C138.927 106.069 138.804 105.906 138.627 105.76C138.454 105.615 138.213 105.476 137.904 105.344C137.6 105.212 137.213 105.078 136.745 104.942C136.254 104.796 135.811 104.635 135.415 104.458C135.02 104.276 134.681 104.069 134.399 103.837C134.117 103.605 133.901 103.339 133.751 103.039C133.601 102.739 133.526 102.396 133.526 102.01C133.526 101.623 133.606 101.266 133.765 100.939C133.924 100.612 134.151 100.327 134.447 100.086C134.747 99.841 135.104 99.65 135.517 99.5136C135.931 99.3773 136.392 99.3091 136.902 99.3091C137.647 99.3091 138.279 99.4523 138.797 99.7387C139.32 100.021 139.718 100.391 139.991 100.85C140.264 101.305 140.4 101.791 140.4 102.31H139.091C139.091 101.937 139.011 101.607 138.852 101.321C138.693 101.03 138.452 100.802 138.129 100.639C137.806 100.471 137.397 100.387 136.902 100.387C136.433 100.387 136.047 100.457 135.742 100.598C135.438 100.739 135.21 100.93 135.06 101.171C134.915 101.412 134.842 101.687 134.842 101.996C134.842 102.205 134.885 102.396 134.972 102.569C135.063 102.737 135.201 102.894 135.388 103.039C135.579 103.185 135.82 103.319 136.111 103.442C136.406 103.564 136.758 103.683 137.168 103.796C137.731 103.955 138.218 104.133 138.627 104.328C139.036 104.524 139.373 104.744 139.636 104.99C139.904 105.231 140.102 105.506 140.229 105.815C140.361 106.119 140.427 106.465 140.427 106.851C140.427 107.256 140.345 107.622 140.182 107.949C140.018 108.276 139.784 108.556 139.479 108.788C139.175 109.02 138.809 109.199 138.381 109.327C137.959 109.449 137.486 109.511 136.963 109.511C136.504 109.511 136.052 109.447 135.606 109.32C135.165 109.193 134.763 109.002 134.399 108.747C134.04 108.492 133.751 108.179 133.533 107.806C133.319 107.429 133.212 106.992 133.212 106.497H134.522C134.522 106.838 134.588 107.131 134.719 107.376C134.851 107.617 135.031 107.817 135.258 107.976C135.49 108.136 135.751 108.254 136.042 108.331C136.338 108.404 136.645 108.44 136.963 108.44C137.422 108.44 137.811 108.377 138.129 108.249C138.447 108.122 138.688 107.94 138.852 107.704C139.02 107.467 139.104 107.188 139.104 106.865ZM143.175 98.8999V109.374H141.914V98.8999H143.175ZM142.875 105.406L142.35 105.385C142.355 104.88 142.43 104.414 142.575 103.987C142.721 103.555 142.925 103.18 143.189 102.862C143.453 102.544 143.766 102.298 144.13 102.125C144.498 101.948 144.905 101.859 145.351 101.859C145.715 101.859 146.042 101.91 146.333 102.01C146.624 102.105 146.872 102.26 147.076 102.473C147.285 102.687 147.444 102.964 147.553 103.305C147.663 103.642 147.717 104.053 147.717 104.539V109.374H146.449V104.526C146.449 104.139 146.392 103.83 146.278 103.598C146.165 103.362 145.999 103.192 145.78 103.087C145.562 102.978 145.294 102.923 144.976 102.923C144.662 102.923 144.376 102.989 144.117 103.121C143.862 103.253 143.641 103.435 143.455 103.667C143.273 103.898 143.13 104.164 143.025 104.464C142.925 104.76 142.875 105.074 142.875 105.406ZM152.668 109.511C152.154 109.511 151.688 109.424 151.27 109.252C150.856 109.074 150.499 108.827 150.199 108.508C149.904 108.19 149.677 107.813 149.517 107.376C149.358 106.94 149.279 106.463 149.279 105.944V105.658C149.279 105.058 149.367 104.524 149.545 104.055C149.722 103.583 149.963 103.182 150.268 102.855C150.572 102.528 150.918 102.28 151.304 102.112C151.691 101.944 152.091 101.859 152.504 101.859C153.032 101.859 153.486 101.95 153.868 102.132C154.255 102.314 154.571 102.569 154.816 102.896C155.062 103.219 155.243 103.601 155.362 104.042C155.48 104.478 155.539 104.955 155.539 105.474V106.04H150.029V105.01H154.277V104.915C154.259 104.587 154.191 104.269 154.073 103.96C153.959 103.651 153.777 103.396 153.527 103.196C153.277 102.996 152.936 102.896 152.504 102.896C152.218 102.896 151.954 102.957 151.713 103.08C151.472 103.198 151.265 103.376 151.093 103.612C150.92 103.848 150.786 104.137 150.69 104.478C150.595 104.819 150.547 105.212 150.547 105.658V105.944C150.547 106.294 150.595 106.624 150.69 106.933C150.79 107.238 150.934 107.506 151.12 107.738C151.311 107.97 151.541 108.151 151.809 108.283C152.082 108.415 152.391 108.481 152.736 108.481C153.182 108.481 153.559 108.39 153.868 108.208C154.177 108.026 154.448 107.783 154.68 107.479L155.443 108.086C155.284 108.327 155.082 108.556 154.837 108.774C154.591 108.993 154.289 109.17 153.93 109.306C153.575 109.443 153.154 109.511 152.668 109.511ZM160.074 109.511C159.56 109.511 159.094 109.424 158.676 109.252C158.262 109.074 157.905 108.827 157.605 108.508C157.31 108.19 157.082 107.813 156.923 107.376C156.764 106.94 156.685 106.463 156.685 105.944V105.658C156.685 105.058 156.773 104.524 156.951 104.055C157.128 103.583 157.369 103.182 157.673 102.855C157.978 102.528 158.323 102.28 158.71 102.112C159.096 101.944 159.496 101.859 159.91 101.859C160.437 101.859 160.892 101.95 161.274 102.132C161.66 102.314 161.976 102.569 162.222 102.896C162.467 103.219 162.649 103.601 162.767 104.042C162.886 104.478 162.945 104.955 162.945 105.474V106.04H157.435V105.01H161.683V104.915C161.665 104.587 161.597 104.269 161.479 103.96C161.365 103.651 161.183 103.396 160.933 103.196C160.683 102.996 160.342 102.896 159.91 102.896C159.624 102.896 159.36 102.957 159.119 103.08C158.878 103.198 158.671 103.376 158.499 103.612C158.326 103.848 158.192 104.137 158.096 104.478C158.001 104.819 157.953 105.212 157.953 105.658V105.944C157.953 106.294 158.001 106.624 158.096 106.933C158.196 107.238 158.339 107.506 158.526 107.738C158.717 107.97 158.946 108.151 159.215 108.283C159.487 108.415 159.796 108.481 160.142 108.481C160.588 108.481 160.965 108.39 161.274 108.208C161.583 108.026 161.854 107.783 162.085 107.479L162.849 108.086C162.69 108.327 162.488 108.556 162.242 108.774C161.997 108.993 161.695 109.17 161.335 109.306C160.981 109.443 160.56 109.511 160.074 109.511ZM167.507 101.996V102.964H163.518V101.996H167.507ZM164.868 100.202H166.129V107.547C166.129 107.797 166.168 107.986 166.245 108.113C166.323 108.24 166.423 108.324 166.545 108.365C166.668 108.406 166.8 108.427 166.941 108.427C167.045 108.427 167.155 108.417 167.268 108.399C167.386 108.377 167.475 108.358 167.534 108.345L167.541 109.374C167.441 109.406 167.309 109.436 167.145 109.463C166.986 109.495 166.793 109.511 166.566 109.511C166.257 109.511 165.973 109.449 165.713 109.327C165.454 109.204 165.247 108.999 165.093 108.713C164.943 108.422 164.868 108.031 164.868 107.54V100.202ZM173.283 107.417C173.283 107.235 173.242 107.067 173.16 106.913C173.083 106.754 172.921 106.61 172.676 106.483C172.435 106.351 172.071 106.238 171.585 106.142C171.176 106.056 170.805 105.953 170.473 105.835C170.146 105.717 169.866 105.574 169.635 105.406C169.407 105.237 169.232 105.04 169.109 104.812C168.987 104.585 168.925 104.319 168.925 104.014C168.925 103.723 168.989 103.448 169.116 103.189C169.248 102.93 169.432 102.701 169.669 102.501C169.91 102.3 170.198 102.144 170.535 102.03C170.871 101.916 171.246 101.859 171.66 101.859C172.251 101.859 172.755 101.964 173.174 102.173C173.592 102.382 173.913 102.662 174.135 103.012C174.358 103.357 174.469 103.742 174.469 104.164H173.208C173.208 103.96 173.146 103.762 173.024 103.571C172.906 103.376 172.73 103.214 172.499 103.087C172.271 102.96 171.992 102.896 171.66 102.896C171.31 102.896 171.026 102.951 170.807 103.06C170.594 103.164 170.437 103.298 170.337 103.462C170.241 103.626 170.194 103.798 170.194 103.98C170.194 104.117 170.216 104.239 170.262 104.349C170.312 104.453 170.398 104.551 170.521 104.642C170.644 104.728 170.817 104.81 171.039 104.887C171.262 104.965 171.546 105.042 171.892 105.119C172.496 105.256 172.994 105.419 173.385 105.61C173.776 105.801 174.067 106.035 174.258 106.313C174.449 106.59 174.544 106.926 174.544 107.322C174.544 107.645 174.476 107.94 174.34 108.208C174.208 108.477 174.015 108.708 173.76 108.904C173.51 109.095 173.21 109.245 172.86 109.354C172.515 109.459 172.126 109.511 171.694 109.511C171.044 109.511 170.494 109.395 170.044 109.163C169.594 108.931 169.253 108.631 169.021 108.263C168.789 107.895 168.673 107.506 168.673 107.097H169.941C169.96 107.442 170.06 107.717 170.241 107.922C170.423 108.122 170.646 108.265 170.91 108.352C171.173 108.433 171.435 108.474 171.694 108.474C172.039 108.474 172.328 108.429 172.56 108.338C172.796 108.247 172.976 108.122 173.099 107.963C173.221 107.804 173.283 107.622 173.283 107.417ZM183.532 100.325L180.245 109.374H178.902L182.687 99.4454H183.553L183.532 100.325ZM186.287 109.374L182.994 100.325L182.973 99.4454H183.839L187.638 109.374H186.287ZM186.117 105.699V106.776H180.539V105.699H186.117ZM192.629 105.481H189.977V104.41H192.629C193.143 104.41 193.559 104.328 193.877 104.164C194.196 104.001 194.427 103.773 194.573 103.482C194.723 103.192 194.798 102.86 194.798 102.487C194.798 102.146 194.723 101.825 194.573 101.525C194.427 101.225 194.196 100.984 193.877 100.802C193.559 100.616 193.143 100.523 192.629 100.523H190.283V109.374H188.967V99.4454H192.629C193.379 99.4454 194.014 99.575 194.532 99.8341C195.05 100.093 195.443 100.452 195.712 100.912C195.98 101.366 196.114 101.887 196.114 102.473C196.114 103.11 195.98 103.653 195.712 104.103C195.443 104.553 195.05 104.896 194.532 105.133C194.014 105.365 193.379 105.481 192.629 105.481ZM199.19 99.4454V109.374H197.873V99.4454H199.19ZM209.637 101.996H210.782V109.218C210.782 109.868 210.651 110.422 210.387 110.881C210.123 111.341 209.755 111.688 209.282 111.925C208.814 112.166 208.273 112.286 207.659 112.286C207.405 112.286 207.105 112.245 206.759 112.164C206.418 112.086 206.082 111.952 205.75 111.761C205.422 111.575 205.147 111.322 204.925 111.004L205.586 110.254C205.895 110.627 206.218 110.886 206.554 111.032C206.895 111.177 207.232 111.25 207.564 111.25C207.964 111.25 208.309 111.175 208.6 111.025C208.891 110.875 209.116 110.652 209.275 110.356C209.439 110.065 209.521 109.706 209.521 109.279V103.619L209.637 101.996ZM204.556 105.767V105.624C204.556 105.06 204.622 104.549 204.754 104.089C204.891 103.626 205.084 103.228 205.334 102.896C205.588 102.564 205.895 102.31 206.254 102.132C206.614 101.95 207.018 101.859 207.468 101.859C207.932 101.859 208.337 101.941 208.682 102.105C209.032 102.264 209.328 102.498 209.569 102.807C209.814 103.112 210.007 103.48 210.148 103.912C210.289 104.344 210.387 104.833 210.441 105.378V106.006C210.391 106.547 210.294 107.033 210.148 107.465C210.007 107.897 209.814 108.265 209.569 108.57C209.328 108.874 209.032 109.108 208.682 109.272C208.332 109.431 207.923 109.511 207.455 109.511C207.014 109.511 206.614 109.418 206.254 109.231C205.9 109.045 205.595 108.783 205.341 108.447C205.086 108.111 204.891 107.715 204.754 107.26C204.622 106.801 204.556 106.303 204.556 105.767ZM205.818 105.624V105.767C205.818 106.135 205.854 106.481 205.927 106.804C206.004 107.126 206.12 107.41 206.275 107.656C206.434 107.901 206.636 108.095 206.882 108.236C207.127 108.372 207.42 108.44 207.761 108.44C208.18 108.44 208.525 108.352 208.798 108.174C209.071 107.997 209.287 107.763 209.446 107.472C209.61 107.181 209.737 106.865 209.828 106.524V104.88C209.778 104.63 209.7 104.389 209.596 104.158C209.496 103.921 209.364 103.712 209.2 103.53C209.041 103.344 208.843 103.196 208.607 103.087C208.371 102.978 208.093 102.923 207.775 102.923C207.43 102.923 207.132 102.996 206.882 103.142C206.636 103.282 206.434 103.478 206.275 103.728C206.12 103.973 206.004 104.26 205.927 104.587C205.854 104.91 205.818 105.256 205.818 105.624ZM214.069 101.996V109.374H212.801V101.996H214.069ZM212.705 100.039C212.705 99.8341 212.767 99.6614 212.89 99.5205C213.017 99.3795 213.203 99.3091 213.449 99.3091C213.69 99.3091 213.874 99.3795 214.001 99.5205C214.133 99.6614 214.199 99.8341 214.199 100.039C214.199 100.234 214.133 100.402 214.001 100.543C213.874 100.68 213.69 100.748 213.449 100.748C213.203 100.748 213.017 100.68 212.89 100.543C212.767 100.402 212.705 100.234 212.705 100.039ZM218.338 108.236L220.357 101.996H221.646L218.993 109.374H218.147L218.338 108.236ZM216.654 101.996L218.734 108.27L218.877 109.374H218.031L215.358 101.996H216.654ZM225.826 109.511C225.312 109.511 224.846 109.424 224.428 109.252C224.014 109.074 223.657 108.827 223.357 108.508C223.062 108.19 222.834 107.813 222.675 107.376C222.516 106.94 222.437 106.463 222.437 105.944V105.658C222.437 105.058 222.525 104.524 222.703 104.055C222.88 103.583 223.121 103.182 223.426 102.855C223.73 102.528 224.076 102.28 224.462 102.112C224.848 101.944 225.249 101.859 225.662 101.859C226.19 101.859 226.644 101.95 227.026 102.132C227.413 102.314 227.729 102.569 227.974 102.896C228.22 103.219 228.401 103.601 228.52 104.042C228.638 104.478 228.697 104.955 228.697 105.474V106.04H223.187V105.01H227.435V104.915C227.417 104.587 227.349 104.269 227.231 103.96C227.117 103.651 226.935 103.396 226.685 103.196C226.435 102.996 226.094 102.896 225.662 102.896C225.376 102.896 225.112 102.957 224.871 103.08C224.63 103.198 224.423 103.376 224.251 103.612C224.078 103.848 223.944 104.137 223.848 104.478C223.753 104.819 223.705 105.212 223.705 105.658V105.944C223.705 106.294 223.753 106.624 223.848 106.933C223.948 107.238 224.092 107.506 224.278 107.738C224.469 107.97 224.698 108.151 224.967 108.283C225.239 108.415 225.549 108.481 225.894 108.481C226.34 108.481 226.717 108.39 227.026 108.208C227.335 108.026 227.606 107.783 227.838 107.479L228.601 108.086C228.442 108.327 228.24 108.556 227.994 108.774C227.749 108.993 227.447 109.17 227.087 109.306C226.733 109.443 226.312 109.511 225.826 109.511ZM234.466 107.417C234.466 107.235 234.425 107.067 234.343 106.913C234.266 106.754 234.105 106.61 233.859 106.483C233.618 106.351 233.254 106.238 232.768 106.142C232.359 106.056 231.988 105.953 231.656 105.835C231.329 105.717 231.05 105.574 230.818 105.406C230.59 105.237 230.415 105.04 230.293 104.812C230.17 104.585 230.108 104.319 230.108 104.014C230.108 103.723 230.172 103.448 230.299 103.189C230.431 102.93 230.615 102.701 230.852 102.501C231.093 102.3 231.381 102.144 231.718 102.03C232.054 101.916 232.429 101.859 232.843 101.859C233.434 101.859 233.939 101.964 234.357 102.173C234.775 102.382 235.096 102.662 235.318 103.012C235.541 103.357 235.653 103.742 235.653 104.164H234.391C234.391 103.96 234.33 103.762 234.207 103.571C234.089 103.376 233.914 103.214 233.682 103.087C233.454 102.96 233.175 102.896 232.843 102.896C232.493 102.896 232.209 102.951 231.991 103.06C231.777 103.164 231.62 103.298 231.52 103.462C231.425 103.626 231.377 103.798 231.377 103.98C231.377 104.117 231.4 104.239 231.445 104.349C231.495 104.453 231.581 104.551 231.704 104.642C231.827 104.728 232 104.81 232.222 104.887C232.445 104.965 232.729 105.042 233.075 105.119C233.68 105.256 234.177 105.419 234.568 105.61C234.959 105.801 235.25 106.035 235.441 106.313C235.632 106.59 235.728 106.926 235.728 107.322C235.728 107.645 235.659 107.94 235.523 108.208C235.391 108.477 235.198 108.708 234.943 108.904C234.693 109.095 234.393 109.245 234.043 109.354C233.698 109.459 233.309 109.511 232.877 109.511C232.227 109.511 231.677 109.395 231.227 109.163C230.777 108.931 230.436 108.631 230.204 108.263C229.972 107.895 229.856 107.506 229.856 107.097H231.125C231.143 107.442 231.243 107.717 231.425 107.922C231.606 108.122 231.829 108.265 232.093 108.352C232.357 108.433 232.618 108.474 232.877 108.474C233.223 108.474 233.511 108.429 233.743 108.338C233.98 108.247 234.159 108.122 234.282 107.963C234.405 107.804 234.466 107.622 234.466 107.417ZM242.922 108.611L244.975 101.996H246.325L243.365 110.513C243.297 110.695 243.206 110.891 243.092 111.1C242.983 111.313 242.842 111.516 242.67 111.707C242.497 111.898 242.288 112.052 242.042 112.17C241.801 112.293 241.513 112.354 241.176 112.354C241.076 112.354 240.949 112.341 240.794 112.314C240.64 112.286 240.531 112.264 240.467 112.245L240.46 111.222C240.497 111.227 240.553 111.232 240.631 111.236C240.713 111.245 240.769 111.25 240.801 111.25C241.088 111.25 241.331 111.211 241.531 111.134C241.731 111.061 241.899 110.936 242.035 110.759C242.176 110.586 242.297 110.347 242.397 110.043L242.922 108.611ZM241.415 101.996L243.331 107.724L243.658 109.054L242.752 109.518L240.037 101.996H241.415ZM247.02 105.767V105.61C247.02 105.078 247.098 104.585 247.252 104.13C247.407 103.671 247.63 103.273 247.921 102.937C248.212 102.596 248.564 102.332 248.978 102.146C249.391 101.955 249.855 101.859 250.369 101.859C250.887 101.859 251.353 101.955 251.767 102.146C252.185 102.332 252.54 102.596 252.831 102.937C253.126 103.273 253.351 103.671 253.506 104.13C253.66 104.585 253.737 105.078 253.737 105.61V105.767C253.737 106.299 253.66 106.792 253.506 107.247C253.351 107.701 253.126 108.099 252.831 108.44C252.54 108.777 252.187 109.04 251.774 109.231C251.364 109.418 250.901 109.511 250.382 109.511C249.864 109.511 249.398 109.418 248.984 109.231C248.571 109.04 248.216 108.777 247.921 108.44C247.63 108.099 247.407 107.701 247.252 107.247C247.098 106.792 247.02 106.299 247.02 105.767ZM248.282 105.61V105.767C248.282 106.135 248.325 106.483 248.412 106.81C248.498 107.133 248.628 107.42 248.8 107.67C248.978 107.92 249.198 108.117 249.462 108.263C249.725 108.404 250.032 108.474 250.382 108.474C250.728 108.474 251.03 108.404 251.289 108.263C251.553 108.117 251.771 107.92 251.944 107.67C252.117 107.42 252.246 107.133 252.333 106.81C252.424 106.483 252.469 106.135 252.469 105.767V105.61C252.469 105.246 252.424 104.903 252.333 104.58C252.246 104.253 252.114 103.964 251.937 103.714C251.764 103.46 251.546 103.26 251.283 103.114C251.023 102.969 250.719 102.896 250.369 102.896C250.023 102.896 249.719 102.969 249.455 103.114C249.196 103.26 248.978 103.46 248.8 103.714C248.628 103.964 248.498 104.253 248.412 104.58C248.325 104.903 248.282 105.246 248.282 105.61ZM259.834 107.67V101.996H261.102V109.374H259.895L259.834 107.67ZM260.073 106.115L260.598 106.101C260.598 106.592 260.545 107.047 260.441 107.465C260.341 107.879 260.177 108.238 259.95 108.542C259.723 108.847 259.425 109.086 259.057 109.258C258.688 109.427 258.241 109.511 257.713 109.511C257.354 109.511 257.024 109.459 256.724 109.354C256.429 109.249 256.174 109.088 255.961 108.87C255.747 108.652 255.581 108.367 255.463 108.017C255.349 107.667 255.292 107.247 255.292 106.756V101.996H256.554V106.769C256.554 107.101 256.59 107.376 256.663 107.595C256.74 107.808 256.843 107.979 256.97 108.106C257.102 108.229 257.247 108.315 257.406 108.365C257.57 108.415 257.738 108.44 257.911 108.44C258.447 108.44 258.872 108.338 259.186 108.133C259.5 107.924 259.725 107.645 259.861 107.295C260.002 106.94 260.073 106.547 260.073 106.115ZM268.372 109.374H267.11V101.218C267.11 100.687 267.206 100.239 267.397 99.8751C267.592 99.5068 267.872 99.2295 268.235 99.0431C268.599 98.8522 269.031 98.7567 269.531 98.7567C269.677 98.7567 269.822 98.7658 269.968 98.784C270.118 98.8022 270.263 98.8294 270.404 98.8658L270.336 99.8955C270.24 99.8728 270.131 99.8569 270.008 99.8478C269.89 99.8387 269.772 99.8341 269.654 99.8341C269.386 99.8341 269.154 99.8887 268.958 99.9978C268.767 100.102 268.622 100.257 268.522 100.462C268.422 100.666 268.372 100.918 268.372 101.218V109.374ZM269.94 101.996V102.964H265.944V101.996H269.94ZM275.859 107.67V101.996H277.128V109.374H275.921L275.859 107.67ZM276.098 106.115L276.623 106.101C276.623 106.592 276.571 107.047 276.466 107.465C276.366 107.879 276.203 108.238 275.975 108.542C275.748 108.847 275.45 109.086 275.082 109.258C274.714 109.427 274.266 109.511 273.739 109.511C273.379 109.511 273.05 109.459 272.75 109.354C272.454 109.249 272.2 109.088 271.986 108.87C271.772 108.652 271.606 108.367 271.488 108.017C271.375 107.667 271.318 107.247 271.318 106.756V101.996H272.579V106.769C272.579 107.101 272.616 107.376 272.688 107.595C272.766 107.808 272.868 107.979 272.995 108.106C273.127 108.229 273.273 108.315 273.432 108.365C273.595 108.415 273.764 108.44 273.936 108.44C274.473 108.44 274.898 108.338 275.212 108.133C275.525 107.924 275.75 107.645 275.887 107.295C276.028 106.94 276.098 106.547 276.098 106.115ZM280.422 98.8999V109.374H279.153V98.8999H280.422ZM283.818 98.8999V109.374H282.549V98.8999H283.818ZM292.26 108.474C292.56 108.474 292.837 108.413 293.092 108.29C293.347 108.167 293.556 107.999 293.719 107.786C293.883 107.567 293.976 107.32 293.999 107.042H295.199C295.176 107.479 295.029 107.886 294.756 108.263C294.488 108.636 294.135 108.938 293.699 109.17C293.262 109.397 292.783 109.511 292.26 109.511C291.705 109.511 291.221 109.413 290.807 109.218C290.398 109.022 290.057 108.754 289.785 108.413C289.516 108.072 289.314 107.681 289.178 107.24C289.046 106.794 288.98 106.324 288.98 105.828V105.542C288.98 105.046 289.046 104.578 289.178 104.137C289.314 103.692 289.516 103.298 289.785 102.957C290.057 102.616 290.398 102.348 290.807 102.153C291.221 101.957 291.705 101.859 292.26 101.859C292.837 101.859 293.342 101.978 293.774 102.214C294.206 102.446 294.544 102.764 294.79 103.169C295.04 103.569 295.176 104.024 295.199 104.533H293.999C293.976 104.228 293.89 103.953 293.74 103.708C293.594 103.462 293.394 103.267 293.14 103.121C292.89 102.971 292.596 102.896 292.26 102.896C291.874 102.896 291.548 102.973 291.285 103.128C291.026 103.278 290.819 103.482 290.664 103.742C290.514 103.996 290.405 104.28 290.337 104.594C290.273 104.903 290.241 105.219 290.241 105.542V105.828C290.241 106.151 290.273 106.469 290.337 106.783C290.401 107.097 290.507 107.381 290.657 107.635C290.812 107.89 291.019 108.095 291.278 108.249C291.542 108.399 291.869 108.474 292.26 108.474ZM296.283 105.767V105.61C296.283 105.078 296.361 104.585 296.515 104.13C296.67 103.671 296.893 103.273 297.184 102.937C297.474 102.596 297.827 102.332 298.241 102.146C298.654 101.955 299.118 101.859 299.632 101.859C300.15 101.859 300.616 101.955 301.03 102.146C301.448 102.332 301.802 102.596 302.093 102.937C302.389 103.273 302.614 103.671 302.769 104.13C302.923 104.585 303 105.078 303 105.61V105.767C303 106.299 302.923 106.792 302.769 107.247C302.614 107.701 302.389 108.099 302.093 108.44C301.802 108.777 301.45 109.04 301.036 109.231C300.627 109.418 300.164 109.511 299.645 109.511C299.127 109.511 298.661 109.418 298.247 109.231C297.834 109.04 297.479 108.777 297.184 108.44C296.893 108.099 296.67 107.701 296.515 107.247C296.361 106.792 296.283 106.299 296.283 105.767ZM297.545 105.61V105.767C297.545 106.135 297.588 106.483 297.675 106.81C297.761 107.133 297.89 107.42 298.063 107.67C298.241 107.92 298.461 108.117 298.725 108.263C298.988 108.404 299.295 108.474 299.645 108.474C299.991 108.474 300.293 108.404 300.552 108.263C300.816 108.117 301.034 107.92 301.207 107.67C301.38 107.42 301.509 107.133 301.596 106.81C301.687 106.483 301.732 106.135 301.732 105.767V105.61C301.732 105.246 301.687 104.903 301.596 104.58C301.509 104.253 301.377 103.964 301.2 103.714C301.027 103.46 300.809 103.26 300.545 103.114C300.286 102.969 299.982 102.896 299.632 102.896C299.286 102.896 298.982 102.969 298.718 103.114C298.459 103.26 298.241 103.46 298.063 103.714C297.89 103.964 297.761 104.253 297.675 104.58C297.588 104.903 297.545 105.246 297.545 105.61ZM305.844 103.571V109.374H304.583V101.996H305.776L305.844 103.571ZM305.544 105.406L305.019 105.385C305.023 104.88 305.099 104.414 305.244 103.987C305.389 103.555 305.594 103.18 305.858 102.862C306.121 102.544 306.435 102.298 306.799 102.125C307.167 101.948 307.574 101.859 308.019 101.859C308.383 101.859 308.71 101.91 309.001 102.01C309.292 102.105 309.54 102.26 309.745 102.473C309.954 102.687 310.113 102.964 310.222 103.305C310.331 103.642 310.386 104.053 310.386 104.539V109.374H309.117V104.526C309.117 104.139 309.061 103.83 308.947 103.598C308.833 103.362 308.667 103.192 308.449 103.087C308.231 102.978 307.963 102.923 307.644 102.923C307.331 102.923 307.044 102.989 306.785 103.121C306.531 103.253 306.31 103.435 306.124 103.667C305.942 103.898 305.799 104.164 305.694 104.464C305.594 104.76 305.544 105.074 305.544 105.406ZM315.391 101.996V102.964H311.402V101.996H315.391ZM312.752 100.202H314.014V107.547C314.014 107.797 314.052 107.986 314.13 108.113C314.207 108.24 314.307 108.324 314.43 108.365C314.552 108.406 314.684 108.427 314.825 108.427C314.93 108.427 315.039 108.417 315.152 108.399C315.271 108.377 315.359 108.358 315.418 108.345L315.425 109.374C315.325 109.406 315.193 109.436 315.03 109.463C314.871 109.495 314.677 109.511 314.45 109.511C314.141 109.511 313.857 109.449 313.598 109.327C313.339 109.204 313.132 108.999 312.977 108.713C312.827 108.422 312.752 108.031 312.752 107.54V100.202ZM318.133 103.155V109.374H316.871V101.996H318.098L318.133 103.155ZM320.437 101.955L320.431 103.128C320.326 103.105 320.226 103.092 320.131 103.087C320.04 103.078 319.935 103.073 319.817 103.073C319.526 103.073 319.269 103.119 319.046 103.21C318.824 103.301 318.635 103.428 318.48 103.592C318.326 103.755 318.203 103.951 318.112 104.178C318.026 104.401 317.969 104.646 317.942 104.915L317.587 105.119C317.587 104.674 317.63 104.255 317.717 103.864C317.808 103.473 317.946 103.128 318.133 102.828C318.319 102.523 318.555 102.287 318.842 102.119C319.133 101.946 319.478 101.859 319.878 101.859C319.969 101.859 320.074 101.871 320.192 101.894C320.31 101.912 320.392 101.932 320.437 101.955ZM321.133 105.767V105.61C321.133 105.078 321.21 104.585 321.365 104.13C321.52 103.671 321.742 103.273 322.033 102.937C322.324 102.596 322.677 102.332 323.09 102.146C323.504 101.955 323.968 101.859 324.481 101.859C325 101.859 325.466 101.955 325.879 102.146C326.298 102.332 326.652 102.596 326.943 102.937C327.239 103.273 327.464 103.671 327.618 104.13C327.773 104.585 327.85 105.078 327.85 105.61V105.767C327.85 106.299 327.773 106.792 327.618 107.247C327.464 107.701 327.239 108.099 326.943 108.44C326.652 108.777 326.3 109.04 325.886 109.231C325.477 109.418 325.013 109.511 324.495 109.511C323.977 109.511 323.511 109.418 323.097 109.231C322.683 109.04 322.329 108.777 322.033 108.44C321.742 108.099 321.52 107.701 321.365 107.247C321.21 106.792 321.133 106.299 321.133 105.767ZM322.395 105.61V105.767C322.395 106.135 322.438 106.483 322.524 106.81C322.611 107.133 322.74 107.42 322.913 107.67C323.09 107.92 323.311 108.117 323.574 108.263C323.838 108.404 324.145 108.474 324.495 108.474C324.841 108.474 325.143 108.404 325.402 108.263C325.666 108.117 325.884 107.92 326.057 107.67C326.229 107.42 326.359 107.133 326.445 106.81C326.536 106.483 326.582 106.135 326.582 105.767V105.61C326.582 105.246 326.536 104.903 326.445 104.58C326.359 104.253 326.227 103.964 326.05 103.714C325.877 103.46 325.659 103.26 325.395 103.114C325.136 102.969 324.831 102.896 324.481 102.896C324.136 102.896 323.831 102.969 323.568 103.114C323.308 103.26 323.09 103.46 322.913 103.714C322.74 103.964 322.611 104.253 322.524 104.58C322.438 104.903 322.395 105.246 322.395 105.61ZM330.803 98.8999V109.374H329.535V98.8999H330.803ZM335.958 105.767V105.61C335.958 105.078 336.036 104.585 336.19 104.13C336.345 103.671 336.568 103.273 336.858 102.937C337.149 102.596 337.502 102.332 337.915 102.146C338.329 101.955 338.793 101.859 339.307 101.859C339.825 101.859 340.291 101.955 340.705 102.146C341.123 102.332 341.477 102.596 341.768 102.937C342.064 103.273 342.289 103.671 342.444 104.13C342.598 104.585 342.675 105.078 342.675 105.61V105.767C342.675 106.299 342.598 106.792 342.444 107.247C342.289 107.701 342.064 108.099 341.768 108.44C341.477 108.777 341.125 109.04 340.711 109.231C340.302 109.418 339.839 109.511 339.32 109.511C338.802 109.511 338.336 109.418 337.922 109.231C337.509 109.04 337.154 108.777 336.858 108.44C336.568 108.099 336.345 107.701 336.19 107.247C336.036 106.792 335.958 106.299 335.958 105.767ZM337.22 105.61V105.767C337.22 106.135 337.263 106.483 337.349 106.81C337.436 107.133 337.565 107.42 337.738 107.67C337.915 107.92 338.136 108.117 338.4 108.263C338.663 108.404 338.97 108.474 339.32 108.474C339.666 108.474 339.968 108.404 340.227 108.263C340.491 108.117 340.709 107.92 340.882 107.67C341.055 107.42 341.184 107.133 341.271 106.81C341.362 106.483 341.407 106.135 341.407 105.767V105.61C341.407 105.246 341.362 104.903 341.271 104.58C341.184 104.253 341.052 103.964 340.875 103.714C340.702 103.46 340.484 103.26 340.22 103.114C339.961 102.969 339.657 102.896 339.307 102.896C338.961 102.896 338.657 102.969 338.393 103.114C338.134 103.26 337.915 103.46 337.738 103.714C337.565 103.964 337.436 104.253 337.349 104.58C337.263 104.903 337.22 105.246 337.22 105.61ZM346.392 108.236L348.41 101.996H349.699L347.047 109.374H346.201L346.392 108.236ZM344.708 101.996L346.787 108.27L346.931 109.374H346.085L343.412 101.996H344.708ZM353.88 109.511C353.366 109.511 352.9 109.424 352.482 109.252C352.068 109.074 351.711 108.827 351.411 108.508C351.115 108.19 350.888 107.813 350.729 107.376C350.57 106.94 350.49 106.463 350.49 105.944V105.658C350.49 105.058 350.579 104.524 350.756 104.055C350.934 103.583 351.175 103.182 351.479 102.855C351.784 102.528 352.129 102.28 352.516 102.112C352.902 101.944 353.302 101.859 353.716 101.859C354.243 101.859 354.698 101.95 355.08 102.132C355.466 102.314 355.782 102.569 356.028 102.896C356.273 103.219 356.455 103.601 356.573 104.042C356.691 104.478 356.75 104.955 356.75 105.474V106.04H351.24V105.01H355.489V104.915C355.471 104.587 355.403 104.269 355.284 103.96C355.171 103.651 354.989 103.396 354.739 103.196C354.489 102.996 354.148 102.896 353.716 102.896C353.429 102.896 353.166 102.957 352.925 103.08C352.684 103.198 352.477 103.376 352.304 103.612C352.132 103.848 351.997 104.137 351.902 104.478C351.806 104.819 351.759 105.212 351.759 105.658V105.944C351.759 106.294 351.806 106.624 351.902 106.933C352.002 107.238 352.145 107.506 352.332 107.738C352.523 107.97 352.752 108.151 353.02 108.283C353.293 108.415 353.602 108.481 353.948 108.481C354.393 108.481 354.771 108.39 355.08 108.208C355.389 108.026 355.659 107.783 355.891 107.479L356.655 108.086C356.496 108.327 356.294 108.556 356.048 108.774C355.803 108.993 355.5 109.17 355.141 109.306C354.787 109.443 354.366 109.511 353.88 109.511ZM359.485 103.155V109.374H358.223V101.996H359.451L359.485 103.155ZM361.79 101.955L361.783 103.128C361.679 103.105 361.579 103.092 361.483 103.087C361.392 103.078 361.288 103.073 361.169 103.073C360.878 103.073 360.622 103.119 360.399 103.21C360.176 103.301 359.987 103.428 359.833 103.592C359.678 103.755 359.556 103.951 359.465 104.178C359.378 104.401 359.321 104.646 359.294 104.915L358.94 105.119C358.94 104.674 358.983 104.255 359.069 103.864C359.16 103.473 359.299 103.128 359.485 102.828C359.671 102.523 359.908 102.287 360.194 102.119C360.485 101.946 360.831 101.859 361.231 101.859C361.322 101.859 361.426 101.871 361.545 101.894C361.663 101.912 361.745 101.932 361.79 101.955ZM369.509 101.996V102.964H365.52V101.996H369.509ZM366.87 100.202H368.132V107.547C368.132 107.797 368.171 107.986 368.248 108.113C368.325 108.24 368.425 108.324 368.548 108.365C368.671 108.406 368.803 108.427 368.943 108.427C369.048 108.427 369.157 108.417 369.271 108.399C369.389 108.377 369.478 108.358 369.537 108.345L369.544 109.374C369.444 109.406 369.312 109.436 369.148 109.463C368.989 109.495 368.796 109.511 368.568 109.511C368.259 109.511 367.975 109.449 367.716 109.327C367.457 109.204 367.25 108.999 367.095 108.713C366.945 108.422 366.87 108.031 366.87 107.54V100.202ZM372.251 98.8999V109.374H370.989V98.8999H372.251ZM371.951 105.406L371.426 105.385C371.43 104.88 371.505 104.414 371.651 103.987C371.796 103.555 372.001 103.18 372.265 102.862C372.528 102.544 372.842 102.298 373.206 102.125C373.574 101.948 373.981 101.859 374.426 101.859C374.79 101.859 375.117 101.91 375.408 102.01C375.699 102.105 375.947 102.26 376.152 102.473C376.361 102.687 376.52 102.964 376.629 103.305C376.738 103.642 376.793 104.053 376.793 104.539V109.374H375.524V104.526C375.524 104.139 375.467 103.83 375.354 103.598C375.24 103.362 375.074 103.192 374.856 103.087C374.638 102.978 374.369 102.923 374.051 102.923C373.737 102.923 373.451 102.989 373.192 103.121C372.937 103.253 372.717 103.435 372.53 103.667C372.349 103.898 372.205 104.164 372.101 104.464C372.001 104.76 371.951 105.074 371.951 105.406ZM381.743 109.511C381.23 109.511 380.764 109.424 380.345 109.252C379.932 109.074 379.575 108.827 379.275 108.508C378.979 108.19 378.752 107.813 378.593 107.376C378.434 106.94 378.354 106.463 378.354 105.944V105.658C378.354 105.058 378.443 104.524 378.62 104.055C378.797 103.583 379.038 103.182 379.343 102.855C379.648 102.528 379.993 102.28 380.38 102.112C380.766 101.944 381.166 101.859 381.58 101.859C382.107 101.859 382.562 101.95 382.944 102.132C383.33 102.314 383.646 102.569 383.892 102.896C384.137 103.219 384.319 103.601 384.437 104.042C384.555 104.478 384.614 104.955 384.614 105.474V106.04H379.104V105.01H383.353V104.915C383.335 104.587 383.266 104.269 383.148 103.96C383.035 103.651 382.853 103.396 382.603 103.196C382.353 102.996 382.012 102.896 381.58 102.896C381.293 102.896 381.03 102.957 380.789 103.08C380.548 103.198 380.341 103.376 380.168 103.612C379.995 103.848 379.861 104.137 379.766 104.478C379.67 104.819 379.623 105.212 379.623 105.658V105.944C379.623 106.294 379.67 106.624 379.766 106.933C379.866 107.238 380.009 107.506 380.195 107.738C380.386 107.97 380.616 108.151 380.884 108.283C381.157 108.415 381.466 108.481 381.812 108.481C382.257 108.481 382.634 108.39 382.944 108.208C383.253 108.026 383.523 107.783 383.755 107.479L384.519 108.086C384.36 108.327 384.157 108.556 383.912 108.774C383.666 108.993 383.364 109.17 383.005 109.306C382.65 109.443 382.23 109.511 381.743 109.511ZM109.679 129.474C109.979 129.474 110.256 129.413 110.511 129.29C110.765 129.167 110.975 128.999 111.138 128.786C111.302 128.567 111.395 128.32 111.418 128.042H112.618C112.595 128.479 112.447 128.886 112.175 129.263C111.906 129.636 111.554 129.938 111.118 130.17C110.681 130.397 110.202 130.511 109.679 130.511C109.124 130.511 108.64 130.413 108.226 130.218C107.817 130.022 107.476 129.754 107.203 129.413C106.935 129.072 106.733 128.681 106.596 128.24C106.465 127.794 106.399 127.324 106.399 126.828V126.542C106.399 126.046 106.465 125.578 106.596 125.137C106.733 124.692 106.935 124.298 107.203 123.957C107.476 123.616 107.817 123.348 108.226 123.153C108.64 122.957 109.124 122.859 109.679 122.859C110.256 122.859 110.761 122.978 111.193 123.214C111.625 123.446 111.963 123.764 112.209 124.169C112.459 124.569 112.595 125.024 112.618 125.533H111.418C111.395 125.228 111.309 124.953 111.159 124.708C111.013 124.462 110.813 124.267 110.559 124.121C110.308 123.971 110.015 123.896 109.679 123.896C109.292 123.896 108.967 123.973 108.704 124.128C108.445 124.278 108.238 124.482 108.083 124.742C107.933 124.996 107.824 125.28 107.756 125.594C107.692 125.903 107.66 126.219 107.66 126.542V126.828C107.66 127.151 107.692 127.469 107.756 127.783C107.819 128.097 107.926 128.381 108.076 128.635C108.231 128.89 108.438 129.095 108.697 129.249C108.961 129.399 109.288 129.474 109.679 129.474ZM113.702 126.767V126.61C113.702 126.078 113.78 125.585 113.934 125.13C114.089 124.671 114.311 124.273 114.602 123.937C114.893 123.596 115.246 123.332 115.659 123.146C116.073 122.955 116.537 122.859 117.051 122.859C117.569 122.859 118.035 122.955 118.449 123.146C118.867 123.332 119.221 123.596 119.512 123.937C119.808 124.273 120.033 124.671 120.187 125.13C120.342 125.585 120.419 126.078 120.419 126.61V126.767C120.419 127.299 120.342 127.792 120.187 128.247C120.033 128.701 119.808 129.099 119.512 129.44C119.221 129.777 118.869 130.04 118.455 130.231C118.046 130.418 117.582 130.511 117.064 130.511C116.546 130.511 116.08 130.418 115.666 130.231C115.253 130.04 114.898 129.777 114.602 129.44C114.311 129.099 114.089 128.701 113.934 128.247C113.78 127.792 113.702 127.299 113.702 126.767ZM114.964 126.61V126.767C114.964 127.135 115.007 127.483 115.093 127.81C115.18 128.133 115.309 128.42 115.482 128.67C115.659 128.92 115.88 129.117 116.144 129.263C116.407 129.404 116.714 129.474 117.064 129.474C117.41 129.474 117.712 129.404 117.971 129.263C118.235 129.117 118.453 128.92 118.626 128.67C118.799 128.42 118.928 128.133 119.015 127.81C119.105 127.483 119.151 127.135 119.151 126.767V126.61C119.151 126.246 119.105 125.903 119.015 125.58C118.928 125.253 118.796 124.964 118.619 124.714C118.446 124.46 118.228 124.26 117.964 124.114C117.705 123.969 117.401 123.896 117.051 123.896C116.705 123.896 116.4 123.969 116.137 124.114C115.878 124.26 115.659 124.46 115.482 124.714C115.309 124.964 115.18 125.253 115.093 125.58C115.007 125.903 114.964 126.246 114.964 126.61ZM123.263 124.571V130.374H122.001V122.996H123.195L123.263 124.571ZM122.963 126.406L122.438 126.385C122.442 125.88 122.517 125.414 122.663 124.987C122.808 124.555 123.013 124.18 123.277 123.862C123.54 123.544 123.854 123.298 124.218 123.125C124.586 122.948 124.993 122.859 125.438 122.859C125.802 122.859 126.129 122.91 126.42 123.01C126.711 123.105 126.959 123.26 127.164 123.473C127.373 123.687 127.532 123.964 127.641 124.305C127.75 124.642 127.805 125.053 127.805 125.539V130.374H126.536V125.526C126.536 125.139 126.479 124.83 126.366 124.598C126.252 124.362 126.086 124.192 125.868 124.087C125.65 123.978 125.382 123.923 125.063 123.923C124.75 123.923 124.463 123.989 124.204 124.121C123.949 124.253 123.729 124.435 123.543 124.667C123.361 124.898 123.218 125.164 123.113 125.464C123.013 125.76 122.963 126.074 122.963 126.406ZM132.81 122.996V123.964H128.821V122.996H132.81ZM130.171 121.202H131.433V128.547C131.433 128.797 131.471 128.986 131.548 129.113C131.626 129.24 131.726 129.324 131.849 129.365C131.971 129.406 132.103 129.427 132.244 129.427C132.349 129.427 132.458 129.417 132.571 129.399C132.69 129.377 132.778 129.358 132.837 129.345L132.844 130.374C132.744 130.406 132.612 130.436 132.449 130.463C132.29 130.495 132.096 130.511 131.869 130.511C131.56 130.511 131.276 130.449 131.017 130.327C130.757 130.204 130.551 129.999 130.396 129.713C130.246 129.422 130.171 129.031 130.171 128.54V121.202ZM137.352 130.511C136.838 130.511 136.372 130.424 135.954 130.252C135.54 130.074 135.183 129.827 134.883 129.508C134.588 129.19 134.36 128.813 134.201 128.376C134.042 127.94 133.963 127.463 133.963 126.944V126.658C133.963 126.058 134.051 125.524 134.228 125.055C134.406 124.583 134.647 124.182 134.951 123.855C135.256 123.528 135.601 123.28 135.988 123.112C136.374 122.944 136.774 122.859 137.188 122.859C137.715 122.859 138.17 122.95 138.552 123.132C138.938 123.314 139.254 123.569 139.5 123.896C139.745 124.219 139.927 124.601 140.045 125.042C140.164 125.478 140.223 125.955 140.223 126.474V127.04H134.713V126.01H138.961V125.915C138.943 125.587 138.875 125.269 138.757 124.96C138.643 124.651 138.461 124.396 138.211 124.196C137.961 123.996 137.62 123.896 137.188 123.896C136.902 123.896 136.638 123.957 136.397 124.08C136.156 124.198 135.949 124.376 135.776 124.612C135.604 124.848 135.47 125.137 135.374 125.478C135.279 125.819 135.231 126.212 135.231 126.658V126.944C135.231 127.294 135.279 127.624 135.374 127.933C135.474 128.238 135.617 128.506 135.804 128.738C135.995 128.97 136.224 129.151 136.492 129.283C136.765 129.415 137.074 129.481 137.42 129.481C137.865 129.481 138.243 129.39 138.552 129.208C138.861 129.026 139.132 128.783 139.363 128.479L140.127 129.086C139.968 129.327 139.766 129.556 139.52 129.774C139.275 129.993 138.972 130.17 138.613 130.306C138.259 130.443 137.838 130.511 137.352 130.511ZM142.957 124.571V130.374H141.696V122.996H142.889L142.957 124.571ZM142.657 126.406L142.132 126.385C142.137 125.88 142.212 125.414 142.357 124.987C142.503 124.555 142.707 124.18 142.971 123.862C143.235 123.544 143.548 123.298 143.912 123.125C144.28 122.948 144.687 122.859 145.133 122.859C145.496 122.859 145.824 122.91 146.115 123.01C146.406 123.105 146.653 123.26 146.858 123.473C147.067 123.687 147.226 123.964 147.335 124.305C147.444 124.642 147.499 125.053 147.499 125.539V130.374H146.231V125.526C146.231 125.139 146.174 124.83 146.06 124.598C145.946 124.362 145.78 124.192 145.562 124.087C145.344 123.978 145.076 123.923 144.758 123.923C144.444 123.923 144.157 123.989 143.898 124.121C143.644 124.253 143.423 124.435 143.237 124.667C143.055 124.898 142.912 125.164 142.807 125.464C142.707 125.76 142.657 126.074 142.657 126.406ZM152.504 122.996V123.964H148.515V122.996H152.504ZM149.865 121.202H151.127V128.547C151.127 128.797 151.165 128.986 151.243 129.113C151.32 129.24 151.42 129.324 151.543 129.365C151.666 129.406 151.797 129.427 151.938 129.427C152.043 129.427 152.152 129.417 152.266 129.399C152.384 129.377 152.472 129.358 152.532 129.345L152.538 130.374C152.438 130.406 152.307 130.436 152.143 130.463C151.984 130.495 151.791 130.511 151.563 130.511C151.254 130.511 150.97 130.449 150.711 130.327C150.452 130.204 150.245 129.999 150.09 129.713C149.94 129.422 149.865 129.031 149.865 128.54V121.202ZM157.114 126.767V126.61C157.114 126.078 157.191 125.585 157.346 125.13C157.501 124.671 157.723 124.273 158.014 123.937C158.305 123.596 158.658 123.332 159.071 123.146C159.485 122.955 159.949 122.859 160.462 122.859C160.981 122.859 161.447 122.955 161.86 123.146C162.279 123.332 162.633 123.596 162.924 123.937C163.22 124.273 163.445 124.671 163.599 125.13C163.754 125.585 163.831 126.078 163.831 126.61V126.767C163.831 127.299 163.754 127.792 163.599 128.247C163.445 128.701 163.22 129.099 162.924 129.44C162.633 129.777 162.281 130.04 161.867 130.231C161.458 130.418 160.994 130.511 160.476 130.511C159.958 130.511 159.492 130.418 159.078 130.231C158.664 130.04 158.31 129.777 158.014 129.44C157.723 129.099 157.501 128.701 157.346 128.247C157.191 127.792 157.114 127.299 157.114 126.767ZM158.376 126.61V126.767C158.376 127.135 158.419 127.483 158.505 127.81C158.592 128.133 158.721 128.42 158.894 128.67C159.071 128.92 159.292 129.117 159.556 129.263C159.819 129.404 160.126 129.474 160.476 129.474C160.822 129.474 161.124 129.404 161.383 129.263C161.647 129.117 161.865 128.92 162.038 128.67C162.211 128.42 162.34 128.133 162.426 127.81C162.517 127.483 162.563 127.135 162.563 126.767V126.61C162.563 126.246 162.517 125.903 162.426 125.58C162.34 125.253 162.208 124.964 162.031 124.714C161.858 124.46 161.64 124.26 161.376 124.114C161.117 123.969 160.813 123.896 160.462 123.896C160.117 123.896 159.812 123.969 159.549 124.114C159.29 124.26 159.071 124.46 158.894 124.714C158.721 124.964 158.592 125.253 158.505 125.58C158.419 125.903 158.376 126.246 158.376 126.61ZM167.295 130.374H166.034V122.218C166.034 121.687 166.129 121.239 166.32 120.875C166.516 120.507 166.795 120.23 167.159 120.043C167.523 119.852 167.955 119.757 168.455 119.757C168.6 119.757 168.746 119.766 168.891 119.784C169.041 119.802 169.187 119.829 169.328 119.866L169.259 120.896C169.164 120.873 169.055 120.857 168.932 120.848C168.814 120.839 168.696 120.834 168.578 120.834C168.309 120.834 168.077 120.889 167.882 120.998C167.691 121.102 167.546 121.257 167.445 121.462C167.345 121.666 167.295 121.918 167.295 122.218V130.374ZM168.864 122.996V123.964H164.868V122.996H168.864ZM175.806 129.611L177.859 122.996H179.209L176.249 131.513C176.181 131.695 176.09 131.891 175.977 132.1C175.867 132.313 175.726 132.516 175.554 132.707C175.381 132.898 175.172 133.052 174.926 133.17C174.685 133.293 174.397 133.354 174.06 133.354C173.96 133.354 173.833 133.341 173.678 133.314C173.524 133.286 173.415 133.264 173.351 133.245L173.344 132.222C173.381 132.227 173.437 132.232 173.515 132.236C173.597 132.245 173.653 132.25 173.685 132.25C173.972 132.25 174.215 132.211 174.415 132.134C174.615 132.061 174.783 131.936 174.92 131.759C175.06 131.586 175.181 131.347 175.281 131.043L175.806 129.611ZM174.299 122.996L176.215 128.724L176.543 130.054L175.636 130.518L172.921 122.996H174.299ZM179.904 126.767V126.61C179.904 126.078 179.982 125.585 180.136 125.13C180.291 124.671 180.514 124.273 180.805 123.937C181.096 123.596 181.448 123.332 181.862 123.146C182.275 122.955 182.739 122.859 183.253 122.859C183.771 122.859 184.237 122.955 184.651 123.146C185.069 123.332 185.424 123.596 185.715 123.937C186.01 124.273 186.235 124.671 186.39 125.13C186.544 125.585 186.621 126.078 186.621 126.61V126.767C186.621 127.299 186.544 127.792 186.39 128.247C186.235 128.701 186.01 129.099 185.715 129.44C185.424 129.777 185.071 130.04 184.658 130.231C184.248 130.418 183.785 130.511 183.266 130.511C182.748 130.511 182.282 130.418 181.868 130.231C181.455 130.04 181.1 129.777 180.805 129.44C180.514 129.099 180.291 128.701 180.136 128.247C179.982 127.792 179.904 127.299 179.904 126.767ZM181.166 126.61V126.767C181.166 127.135 181.209 127.483 181.296 127.81C181.382 128.133 181.512 128.42 181.684 128.67C181.862 128.92 182.082 129.117 182.346 129.263C182.609 129.404 182.916 129.474 183.266 129.474C183.612 129.474 183.914 129.404 184.173 129.263C184.437 129.117 184.655 128.92 184.828 128.67C185.001 128.42 185.13 128.133 185.217 127.81C185.308 127.483 185.353 127.135 185.353 126.767V126.61C185.353 126.246 185.308 125.903 185.217 125.58C185.13 125.253 184.998 124.964 184.821 124.714C184.648 124.46 184.43 124.26 184.167 124.114C183.907 123.969 183.603 123.896 183.253 123.896C182.907 123.896 182.603 123.969 182.339 124.114C182.08 124.26 181.862 124.46 181.684 124.714C181.512 124.964 181.382 125.253 181.296 125.58C181.209 125.903 181.166 126.246 181.166 126.61ZM192.718 128.67V122.996H193.986V130.374H192.779L192.718 128.67ZM192.957 127.115L193.482 127.101C193.482 127.592 193.429 128.047 193.325 128.465C193.225 128.879 193.061 129.238 192.834 129.542C192.607 129.847 192.309 130.086 191.941 130.258C191.572 130.427 191.125 130.511 190.597 130.511C190.238 130.511 189.908 130.459 189.608 130.354C189.313 130.249 189.058 130.088 188.845 129.87C188.631 129.652 188.465 129.367 188.347 129.017C188.233 128.667 188.176 128.247 188.176 127.756V122.996H189.438V127.769C189.438 128.101 189.474 128.376 189.547 128.595C189.624 128.808 189.727 128.979 189.854 129.106C189.986 129.229 190.131 129.315 190.29 129.365C190.454 129.415 190.622 129.44 190.795 129.44C191.331 129.44 191.756 129.338 192.07 129.133C192.384 128.924 192.609 128.645 192.745 128.295C192.886 127.94 192.957 127.547 192.957 127.115ZM197.171 124.155V130.374H195.909V122.996H197.137L197.171 124.155ZM199.476 122.955L199.469 124.128C199.365 124.105 199.265 124.092 199.169 124.087C199.078 124.078 198.974 124.073 198.855 124.073C198.564 124.073 198.308 124.119 198.085 124.21C197.862 124.301 197.673 124.428 197.519 124.592C197.364 124.755 197.241 124.951 197.151 125.178C197.064 125.401 197.007 125.646 196.98 125.915L196.625 126.119C196.625 125.674 196.669 125.255 196.755 124.864C196.846 124.473 196.985 124.128 197.171 123.828C197.357 123.523 197.594 123.287 197.88 123.119C198.171 122.946 198.517 122.859 198.917 122.859C199.008 122.859 199.112 122.871 199.23 122.894C199.349 122.912 199.43 122.932 199.476 122.955ZM208.402 128.417C208.402 128.235 208.362 128.067 208.28 127.913C208.202 127.754 208.041 127.61 207.796 127.483C207.555 127.351 207.191 127.238 206.704 127.142C206.295 127.056 205.925 126.953 205.593 126.835C205.266 126.717 204.986 126.574 204.754 126.406C204.527 126.237 204.352 126.04 204.229 125.812C204.106 125.585 204.045 125.319 204.045 125.014C204.045 124.723 204.109 124.448 204.236 124.189C204.368 123.93 204.552 123.701 204.788 123.501C205.029 123.3 205.318 123.144 205.654 123.03C205.991 122.916 206.366 122.859 206.779 122.859C207.37 122.859 207.875 122.964 208.293 123.173C208.712 123.382 209.032 123.662 209.255 124.012C209.478 124.357 209.589 124.742 209.589 125.164H208.327C208.327 124.96 208.266 124.762 208.143 124.571C208.025 124.376 207.85 124.214 207.618 124.087C207.391 123.96 207.111 123.896 206.779 123.896C206.429 123.896 206.145 123.951 205.927 124.06C205.713 124.164 205.557 124.298 205.457 124.462C205.361 124.626 205.313 124.798 205.313 124.98C205.313 125.117 205.336 125.239 205.382 125.349C205.432 125.453 205.518 125.551 205.641 125.642C205.763 125.728 205.936 125.81 206.159 125.887C206.382 125.965 206.666 126.042 207.011 126.119C207.616 126.256 208.114 126.419 208.505 126.61C208.896 126.801 209.187 127.035 209.378 127.313C209.569 127.59 209.664 127.926 209.664 128.322C209.664 128.645 209.596 128.94 209.459 129.208C209.328 129.477 209.134 129.708 208.88 129.904C208.63 130.095 208.33 130.245 207.98 130.354C207.634 130.459 207.245 130.511 206.814 130.511C206.163 130.511 205.613 130.395 205.163 130.163C204.713 129.931 204.372 129.631 204.14 129.263C203.909 128.895 203.793 128.506 203.793 128.097H205.061C205.079 128.442 205.179 128.717 205.361 128.922C205.543 129.122 205.766 129.265 206.029 129.352C206.293 129.433 206.554 129.474 206.814 129.474C207.159 129.474 207.448 129.429 207.68 129.338C207.916 129.247 208.096 129.122 208.218 128.963C208.341 128.804 208.402 128.622 208.402 128.417ZM212.583 124.414V133.211H211.314V122.996H212.474L212.583 124.414ZM217.554 126.624V126.767C217.554 127.303 217.49 127.801 217.363 128.26C217.236 128.715 217.049 129.111 216.804 129.447C216.563 129.783 216.265 130.045 215.911 130.231C215.556 130.418 215.149 130.511 214.69 130.511C214.222 130.511 213.808 130.434 213.449 130.279C213.09 130.124 212.785 129.899 212.535 129.604C212.285 129.308 212.085 128.954 211.935 128.54C211.789 128.126 211.689 127.66 211.635 127.142V126.378C211.689 125.833 211.792 125.344 211.942 124.912C212.092 124.48 212.29 124.112 212.535 123.807C212.785 123.498 213.087 123.264 213.442 123.105C213.797 122.941 214.206 122.859 214.669 122.859C215.133 122.859 215.545 122.95 215.904 123.132C216.263 123.31 216.565 123.564 216.811 123.896C217.056 124.228 217.24 124.626 217.363 125.089C217.49 125.549 217.554 126.06 217.554 126.624ZM216.286 126.767V126.624C216.286 126.256 216.247 125.91 216.17 125.587C216.092 125.26 215.972 124.973 215.808 124.728C215.649 124.478 215.445 124.282 215.195 124.142C214.945 123.996 214.647 123.923 214.301 123.923C213.983 123.923 213.706 123.978 213.469 124.087C213.237 124.196 213.04 124.344 212.876 124.53C212.712 124.712 212.578 124.921 212.474 125.158C212.374 125.389 212.299 125.63 212.249 125.88V127.647C212.34 127.965 212.467 128.265 212.63 128.547C212.794 128.824 213.012 129.049 213.285 129.222C213.558 129.39 213.901 129.474 214.315 129.474C214.656 129.474 214.949 129.404 215.195 129.263C215.445 129.117 215.649 128.92 215.808 128.67C215.972 128.42 216.092 128.133 216.17 127.81C216.247 127.483 216.286 127.135 216.286 126.767ZM220.425 124.155V130.374H219.163V122.996H220.391L220.425 124.155ZM222.73 122.955L222.723 124.128C222.619 124.105 222.519 124.092 222.423 124.087C222.332 124.078 222.228 124.073 222.109 124.073C221.818 124.073 221.562 124.119 221.339 124.21C221.116 124.301 220.927 124.428 220.773 124.592C220.618 124.755 220.495 124.951 220.405 125.178C220.318 125.401 220.261 125.646 220.234 125.915L219.879 126.119C219.879 125.674 219.923 125.255 220.009 124.864C220.1 124.473 220.239 124.128 220.425 123.828C220.611 123.523 220.848 123.287 221.134 123.119C221.425 122.946 221.771 122.859 222.171 122.859C222.262 122.859 222.366 122.871 222.484 122.894C222.603 122.912 222.684 122.932 222.73 122.955ZM226.822 130.511C226.308 130.511 225.842 130.424 225.424 130.252C225.01 130.074 224.653 129.827 224.353 129.508C224.057 129.19 223.83 128.813 223.671 128.376C223.512 127.94 223.432 127.463 223.432 126.944V126.658C223.432 126.058 223.521 125.524 223.698 125.055C223.876 124.583 224.117 124.182 224.421 123.855C224.726 123.528 225.071 123.28 225.458 123.112C225.844 122.944 226.244 122.859 226.658 122.859C227.185 122.859 227.64 122.95 228.022 123.132C228.408 123.314 228.724 123.569 228.97 123.896C229.215 124.219 229.397 124.601 229.515 125.042C229.633 125.478 229.692 125.955 229.692 126.474V127.04H224.182V126.01H228.431V125.915C228.413 125.587 228.345 125.269 228.226 124.96C228.113 124.651 227.931 124.396 227.681 124.196C227.431 123.996 227.09 123.896 226.658 123.896C226.371 123.896 226.108 123.957 225.867 124.08C225.626 124.198 225.419 124.376 225.246 124.612C225.074 124.848 224.939 125.137 224.844 125.478C224.748 125.819 224.701 126.212 224.701 126.658V126.944C224.701 127.294 224.748 127.624 224.844 127.933C224.944 128.238 225.087 128.506 225.274 128.738C225.464 128.97 225.694 129.151 225.962 129.283C226.235 129.415 226.544 129.481 226.89 129.481C227.335 129.481 227.713 129.39 228.022 129.208C228.331 129.026 228.601 128.783 228.833 128.479L229.597 129.086C229.438 129.327 229.236 129.556 228.99 129.774C228.745 129.993 228.442 130.17 228.083 130.306C227.729 130.443 227.308 130.511 226.822 130.511ZM235.516 129.113V125.314C235.516 125.024 235.457 124.771 235.339 124.558C235.225 124.339 235.052 124.171 234.821 124.053C234.589 123.935 234.302 123.876 233.961 123.876C233.643 123.876 233.364 123.93 233.123 124.039C232.886 124.148 232.7 124.292 232.563 124.469C232.432 124.646 232.366 124.837 232.366 125.042H231.104C231.104 124.778 231.172 124.517 231.309 124.257C231.445 123.998 231.641 123.764 231.895 123.555C232.154 123.341 232.463 123.173 232.823 123.05C233.186 122.923 233.591 122.859 234.036 122.859C234.573 122.859 235.046 122.95 235.455 123.132C235.869 123.314 236.191 123.589 236.423 123.957C236.66 124.321 236.778 124.778 236.778 125.328V128.765C236.778 129.011 236.798 129.272 236.839 129.549C236.885 129.827 236.951 130.065 237.037 130.265V130.374H235.721C235.657 130.229 235.607 130.036 235.571 129.795C235.534 129.549 235.516 129.322 235.516 129.113ZM235.734 125.901L235.748 126.787H234.473C234.114 126.787 233.793 126.817 233.511 126.876C233.229 126.931 232.993 127.015 232.802 127.128C232.611 127.242 232.466 127.385 232.366 127.558C232.266 127.726 232.216 127.924 232.216 128.151C232.216 128.383 232.268 128.595 232.372 128.786C232.477 128.976 232.634 129.129 232.843 129.242C233.057 129.352 233.318 129.406 233.627 129.406C234.014 129.406 234.355 129.324 234.65 129.161C234.946 128.997 235.18 128.797 235.353 128.56C235.53 128.324 235.625 128.094 235.639 127.872L236.178 128.479C236.146 128.67 236.059 128.881 235.919 129.113C235.778 129.345 235.589 129.567 235.353 129.781C235.121 129.99 234.843 130.165 234.521 130.306C234.202 130.443 233.843 130.511 233.443 130.511C232.943 130.511 232.504 130.413 232.127 130.218C231.754 130.022 231.463 129.761 231.254 129.433C231.05 129.101 230.947 128.731 230.947 128.322C230.947 127.926 231.025 127.578 231.179 127.278C231.334 126.974 231.556 126.722 231.847 126.521C232.138 126.317 232.488 126.162 232.898 126.058C233.307 125.953 233.764 125.901 234.268 125.901H235.734ZM243.413 128.942V119.9H244.681V130.374H243.522L243.413 128.942ZM238.449 126.767V126.624C238.449 126.06 238.517 125.549 238.653 125.089C238.794 124.626 238.992 124.228 239.246 123.896C239.506 123.564 239.812 123.31 240.167 123.132C240.526 122.95 240.926 122.859 241.367 122.859C241.831 122.859 242.236 122.941 242.581 123.105C242.931 123.264 243.227 123.498 243.468 123.807C243.713 124.112 243.906 124.48 244.047 124.912C244.188 125.344 244.286 125.833 244.34 126.378V127.006C244.29 127.547 244.193 128.033 244.047 128.465C243.906 128.897 243.713 129.265 243.468 129.57C243.227 129.874 242.931 130.108 242.581 130.272C242.231 130.431 241.822 130.511 241.354 130.511C240.922 130.511 240.526 130.418 240.167 130.231C239.812 130.045 239.506 129.783 239.246 129.447C238.992 129.111 238.794 128.715 238.653 128.26C238.517 127.801 238.449 127.303 238.449 126.767ZM239.717 126.624V126.767C239.717 127.135 239.753 127.481 239.826 127.804C239.903 128.126 240.022 128.41 240.181 128.656C240.34 128.901 240.542 129.095 240.788 129.236C241.033 129.372 241.326 129.44 241.667 129.44C242.085 129.44 242.429 129.352 242.697 129.174C242.97 128.997 243.188 128.763 243.352 128.472C243.515 128.181 243.643 127.865 243.734 127.524V125.88C243.679 125.63 243.599 125.389 243.495 125.158C243.395 124.921 243.263 124.712 243.099 124.53C242.94 124.344 242.742 124.196 242.506 124.087C242.274 123.978 241.999 123.923 241.681 123.923C241.335 123.923 241.038 123.996 240.788 124.142C240.542 124.282 240.34 124.478 240.181 124.728C240.022 124.973 239.903 125.26 239.826 125.587C239.753 125.91 239.717 126.256 239.717 126.624ZM250.942 128.417C250.942 128.235 250.901 128.067 250.819 127.913C250.742 127.754 250.58 127.61 250.335 127.483C250.094 127.351 249.73 127.238 249.244 127.142C248.834 127.056 248.464 126.953 248.132 126.835C247.805 126.717 247.525 126.574 247.293 126.406C247.066 126.237 246.891 126.04 246.768 125.812C246.645 125.585 246.584 125.319 246.584 125.014C246.584 124.723 246.648 124.448 246.775 124.189C246.907 123.93 247.091 123.701 247.327 123.501C247.568 123.3 247.857 123.144 248.193 123.03C248.53 122.916 248.905 122.859 249.319 122.859C249.91 122.859 250.414 122.964 250.832 123.173C251.251 123.382 251.571 123.662 251.794 124.012C252.017 124.357 252.128 124.742 252.128 125.164H250.867C250.867 124.96 250.805 124.762 250.682 124.571C250.564 124.376 250.389 124.214 250.157 124.087C249.93 123.96 249.65 123.896 249.319 123.896C248.968 123.896 248.684 123.951 248.466 124.06C248.252 124.164 248.096 124.298 247.996 124.462C247.9 124.626 247.852 124.798 247.852 124.98C247.852 125.117 247.875 125.239 247.921 125.349C247.971 125.453 248.057 125.551 248.18 125.642C248.302 125.728 248.475 125.81 248.698 125.887C248.921 125.965 249.205 126.042 249.55 126.119C250.155 126.256 250.653 126.419 251.044 126.61C251.435 126.801 251.726 127.035 251.917 127.313C252.108 127.59 252.203 127.926 252.203 128.322C252.203 128.645 252.135 128.94 251.999 129.208C251.867 129.477 251.673 129.708 251.419 129.904C251.169 130.095 250.869 130.245 250.519 130.354C250.173 130.459 249.785 130.511 249.353 130.511C248.703 130.511 248.152 130.395 247.702 130.163C247.252 129.931 246.911 129.631 246.679 129.263C246.448 128.895 246.332 128.506 246.332 128.097H247.6C247.618 128.442 247.718 128.717 247.9 128.922C248.082 129.122 248.305 129.265 248.568 129.352C248.832 129.433 249.094 129.474 249.353 129.474C249.698 129.474 249.987 129.429 250.219 129.338C250.455 129.247 250.635 129.122 250.757 128.963C250.88 128.804 250.942 128.622 250.942 128.417ZM255.122 119.9V130.374H253.86V119.9H255.122ZM254.822 126.406L254.297 126.385C254.301 125.88 254.376 125.414 254.522 124.987C254.667 124.555 254.872 124.18 255.135 123.862C255.399 123.544 255.713 123.298 256.077 123.125C256.445 122.948 256.852 122.859 257.297 122.859C257.661 122.859 257.988 122.91 258.279 123.01C258.57 123.105 258.818 123.26 259.022 123.473C259.232 123.687 259.391 123.964 259.5 124.305C259.609 124.642 259.664 125.053 259.664 125.539V130.374H258.395V125.526C258.395 125.139 258.338 124.83 258.225 124.598C258.111 124.362 257.945 124.192 257.727 124.087C257.509 123.978 257.24 123.923 256.922 123.923C256.608 123.923 256.322 123.989 256.063 124.121C255.808 124.253 255.588 124.435 255.401 124.667C255.22 124.898 255.076 125.164 254.972 125.464C254.872 125.76 254.822 126.074 254.822 126.406ZM264.614 130.511C264.101 130.511 263.635 130.424 263.216 130.252C262.803 130.074 262.446 129.827 262.146 129.508C261.85 129.19 261.623 128.813 261.464 128.376C261.305 127.94 261.225 127.463 261.225 126.944V126.658C261.225 126.058 261.314 125.524 261.491 125.055C261.668 124.583 261.909 124.182 262.214 123.855C262.519 123.528 262.864 123.28 263.25 123.112C263.637 122.944 264.037 122.859 264.451 122.859C264.978 122.859 265.433 122.95 265.815 123.132C266.201 123.314 266.517 123.569 266.762 123.896C267.008 124.219 267.19 124.601 267.308 125.042C267.426 125.478 267.485 125.955 267.485 126.474V127.04H261.975V126.01H266.224V125.915C266.206 125.587 266.137 125.269 266.019 124.96C265.905 124.651 265.724 124.396 265.474 124.196C265.224 123.996 264.883 123.896 264.451 123.896C264.164 123.896 263.901 123.957 263.66 124.08C263.419 124.198 263.212 124.376 263.039 124.612C262.866 124.848 262.732 125.137 262.637 125.478C262.541 125.819 262.494 126.212 262.494 126.658V126.944C262.494 127.294 262.541 127.624 262.637 127.933C262.737 128.238 262.88 128.506 263.066 128.738C263.257 128.97 263.487 129.151 263.755 129.283C264.028 129.415 264.337 129.481 264.683 129.481C265.128 129.481 265.505 129.39 265.815 129.208C266.124 129.026 266.394 128.783 266.626 128.479L267.39 129.086C267.231 129.327 267.028 129.556 266.783 129.774C266.537 129.993 266.235 130.17 265.876 130.306C265.521 130.443 265.101 130.511 264.614 130.511ZM272.02 130.511C271.506 130.511 271.04 130.424 270.622 130.252C270.208 130.074 269.852 129.827 269.552 129.508C269.256 129.19 269.029 128.813 268.87 128.376C268.71 127.94 268.631 127.463 268.631 126.944V126.658C268.631 126.058 268.72 125.524 268.897 125.055C269.074 124.583 269.315 124.182 269.62 123.855C269.924 123.528 270.27 123.28 270.656 123.112C271.043 122.944 271.443 122.859 271.856 122.859C272.384 122.859 272.838 122.95 273.22 123.132C273.607 123.314 273.923 123.569 274.168 123.896C274.414 124.219 274.596 124.601 274.714 125.042C274.832 125.478 274.891 125.955 274.891 126.474V127.04H269.381V126.01H273.63V125.915C273.611 125.587 273.543 125.269 273.425 124.96C273.311 124.651 273.129 124.396 272.879 124.196C272.629 123.996 272.288 123.896 271.856 123.896C271.57 123.896 271.306 123.957 271.065 124.08C270.824 124.198 270.618 124.376 270.445 124.612C270.272 124.848 270.138 125.137 270.043 125.478C269.947 125.819 269.899 126.212 269.899 126.658V126.944C269.899 127.294 269.947 127.624 270.043 127.933C270.143 128.238 270.286 128.506 270.472 128.738C270.663 128.97 270.893 129.151 271.161 129.283C271.434 129.415 271.743 129.481 272.088 129.481C272.534 129.481 272.911 129.39 273.22 129.208C273.529 129.026 273.8 128.783 274.032 128.479L274.796 129.086C274.637 129.327 274.434 129.556 274.189 129.774C273.943 129.993 273.641 130.17 273.282 130.306C272.927 130.443 272.507 130.511 272.02 130.511ZM279.453 122.996V123.964H275.464V122.996H279.453ZM276.814 121.202H278.076V128.547C278.076 128.797 278.114 128.986 278.192 129.113C278.269 129.24 278.369 129.324 278.492 129.365C278.614 129.406 278.746 129.427 278.887 129.427C278.992 129.427 279.101 129.417 279.215 129.399C279.333 129.377 279.421 129.358 279.481 129.345L279.487 130.374C279.387 130.406 279.255 130.436 279.092 130.463C278.933 130.495 278.739 130.511 278.512 130.511C278.203 130.511 277.919 130.449 277.66 130.327C277.401 130.204 277.194 129.999 277.039 129.713C276.889 129.422 276.814 129.031 276.814 128.54V121.202ZM289.048 128.942V119.9H290.316V130.374H289.157L289.048 128.942ZM284.084 126.767V126.624C284.084 126.06 284.152 125.549 284.288 125.089C284.429 124.626 284.627 124.228 284.881 123.896C285.141 123.564 285.447 123.31 285.802 123.132C286.161 122.95 286.561 122.859 287.002 122.859C287.466 122.859 287.871 122.941 288.216 123.105C288.566 123.264 288.862 123.498 289.103 123.807C289.348 124.112 289.541 124.48 289.682 124.912C289.823 125.344 289.921 125.833 289.975 126.378V127.006C289.925 127.547 289.828 128.033 289.682 128.465C289.541 128.897 289.348 129.265 289.103 129.57C288.862 129.874 288.566 130.108 288.216 130.272C287.866 130.431 287.457 130.511 286.989 130.511C286.557 130.511 286.161 130.418 285.802 130.231C285.447 130.045 285.141 129.783 284.881 129.447C284.627 129.111 284.429 128.715 284.288 128.26C284.152 127.801 284.084 127.303 284.084 126.767ZM285.352 126.624V126.767C285.352 127.135 285.388 127.481 285.461 127.804C285.538 128.126 285.657 128.41 285.816 128.656C285.975 128.901 286.177 129.095 286.423 129.236C286.668 129.372 286.961 129.44 287.302 129.44C287.721 129.44 288.064 129.352 288.332 129.174C288.605 128.997 288.823 128.763 288.987 128.472C289.15 128.181 289.278 127.865 289.369 127.524V125.88C289.314 125.63 289.234 125.389 289.13 125.158C289.03 124.921 288.898 124.712 288.734 124.53C288.575 124.344 288.377 124.196 288.141 124.087C287.909 123.978 287.634 123.923 287.316 123.923C286.97 123.923 286.673 123.996 286.423 124.142C286.177 124.282 285.975 124.478 285.816 124.728C285.657 124.973 285.538 125.26 285.461 125.587C285.388 125.91 285.352 126.256 285.352 126.624ZM296.631 129.113V125.314C296.631 125.024 296.572 124.771 296.454 124.558C296.34 124.339 296.167 124.171 295.936 124.053C295.704 123.935 295.417 123.876 295.076 123.876C294.758 123.876 294.479 123.93 294.238 124.039C294.001 124.148 293.815 124.292 293.678 124.469C293.547 124.646 293.481 124.837 293.481 125.042H292.219C292.219 124.778 292.287 124.517 292.424 124.257C292.56 123.998 292.756 123.764 293.01 123.555C293.269 123.341 293.578 123.173 293.938 123.05C294.301 122.923 294.706 122.859 295.151 122.859C295.688 122.859 296.161 122.95 296.57 123.132C296.983 123.314 297.306 123.589 297.538 123.957C297.775 124.321 297.893 124.778 297.893 125.328V128.765C297.893 129.011 297.913 129.272 297.954 129.549C298 129.827 298.065 130.065 298.152 130.265V130.374H296.836C296.772 130.229 296.722 130.036 296.686 129.795C296.649 129.549 296.631 129.322 296.631 129.113ZM296.849 125.901L296.863 126.787H295.588C295.229 126.787 294.908 126.817 294.626 126.876C294.344 126.931 294.108 127.015 293.917 127.128C293.726 127.242 293.581 127.385 293.481 127.558C293.381 127.726 293.331 127.924 293.331 128.151C293.331 128.383 293.383 128.595 293.487 128.786C293.592 128.976 293.749 129.129 293.958 129.242C294.172 129.352 294.433 129.406 294.742 129.406C295.129 129.406 295.47 129.324 295.765 129.161C296.061 128.997 296.295 128.797 296.467 128.56C296.645 128.324 296.74 128.094 296.754 127.872L297.293 128.479C297.261 128.67 297.174 128.881 297.034 129.113C296.893 129.345 296.704 129.567 296.467 129.781C296.236 129.99 295.958 130.165 295.636 130.306C295.317 130.443 294.958 130.511 294.558 130.511C294.058 130.511 293.619 130.413 293.242 130.218C292.869 130.022 292.578 129.761 292.369 129.433C292.164 129.101 292.062 128.731 292.062 128.322C292.062 127.926 292.139 127.578 292.294 127.278C292.449 126.974 292.671 126.722 292.962 126.521C293.253 126.317 293.603 126.162 294.013 126.058C294.422 125.953 294.879 125.901 295.383 125.901H296.849ZM302.966 122.996V123.964H298.977V122.996H302.966ZM300.327 121.202H301.589V128.547C301.589 128.797 301.627 128.986 301.705 129.113C301.782 129.24 301.882 129.324 302.005 129.365C302.128 129.406 302.259 129.427 302.4 129.427C302.505 129.427 302.614 129.417 302.728 129.399C302.846 129.377 302.935 129.358 302.994 129.345L303 130.374C302.9 130.406 302.769 130.436 302.605 130.463C302.446 130.495 302.253 130.511 302.025 130.511C301.716 130.511 301.432 130.449 301.173 130.327C300.914 130.204 300.707 129.999 300.552 129.713C300.402 129.422 300.327 129.031 300.327 128.54V121.202ZM308.797 129.113V125.314C308.797 125.024 308.738 124.771 308.62 124.558C308.506 124.339 308.333 124.171 308.101 124.053C307.869 123.935 307.583 123.876 307.242 123.876C306.924 123.876 306.644 123.93 306.403 124.039C306.167 124.148 305.98 124.292 305.844 124.469C305.712 124.646 305.646 124.837 305.646 125.042H304.385C304.385 124.778 304.453 124.517 304.589 124.257C304.726 123.998 304.921 123.764 305.176 123.555C305.435 123.341 305.744 123.173 306.103 123.05C306.467 122.923 306.872 122.859 307.317 122.859C307.854 122.859 308.326 122.95 308.735 123.132C309.149 123.314 309.472 123.589 309.704 123.957C309.94 124.321 310.058 124.778 310.058 125.328V128.765C310.058 129.011 310.079 129.272 310.12 129.549C310.165 129.827 310.231 130.065 310.318 130.265V130.374H309.001C308.938 130.229 308.888 130.036 308.851 129.795C308.815 129.549 308.797 129.322 308.797 129.113ZM309.015 125.901L309.029 126.787H307.754C307.394 126.787 307.074 126.817 306.792 126.876C306.51 126.931 306.274 127.015 306.083 127.128C305.892 127.242 305.746 127.385 305.646 127.558C305.546 127.726 305.496 127.924 305.496 128.151C305.496 128.383 305.549 128.595 305.653 128.786C305.758 128.976 305.915 129.129 306.124 129.242C306.337 129.352 306.599 129.406 306.908 129.406C307.294 129.406 307.635 129.324 307.931 129.161C308.226 128.997 308.46 128.797 308.633 128.56C308.811 128.324 308.906 128.094 308.92 127.872L309.458 128.479C309.427 128.67 309.34 128.881 309.199 129.113C309.058 129.345 308.87 129.567 308.633 129.781C308.401 129.99 308.124 130.165 307.801 130.306C307.483 130.443 307.124 130.511 306.724 130.511C306.224 130.511 305.785 130.413 305.408 130.218C305.035 130.022 304.744 129.761 304.535 129.433C304.33 129.101 304.228 128.731 304.228 128.322C304.228 127.926 304.305 127.578 304.46 127.278C304.614 126.974 304.837 126.722 305.128 126.521C305.419 126.317 305.769 126.162 306.178 126.058C306.587 125.953 307.044 125.901 307.549 125.901H309.015Z" fill="#4F4F4F" />
					<path opacity="0.3" d="M234.93 194.071V204H233.634V194.071H234.93ZM238.121 194.071V195.148H230.45V194.071H238.121ZM239.594 194.071H242.881C243.627 194.071 244.257 194.185 244.77 194.412C245.289 194.639 245.682 194.976 245.95 195.421C246.223 195.862 246.359 196.406 246.359 197.051C246.359 197.506 246.266 197.922 246.08 198.299C245.898 198.672 245.634 198.99 245.289 199.254C244.948 199.513 244.538 199.706 244.061 199.833L243.693 199.977H240.604L240.59 198.906H242.922C243.395 198.906 243.788 198.824 244.102 198.66C244.416 198.492 244.652 198.267 244.811 197.985C244.97 197.703 245.05 197.392 245.05 197.051C245.05 196.669 244.975 196.335 244.825 196.049C244.675 195.762 244.438 195.542 244.116 195.387C243.797 195.228 243.386 195.148 242.881 195.148H240.911V204H239.594V194.071ZM245.398 204L242.984 199.499L244.354 199.492L246.803 203.918V204H245.398ZM248.33 194.071L250.908 199.056L253.492 194.071H254.986L251.562 200.29V204H250.246V200.29L246.823 194.071H248.33ZM263.121 194.071V204H261.826V194.071H263.121ZM266.313 194.071V195.148H258.641V194.071H266.313ZM274.271 198.34V199.411H268.897V198.34H274.271ZM269.102 194.071V204H267.786V194.071H269.102ZM275.416 194.071V204H274.107V194.071H275.416ZM279.167 194.071V204H277.851V194.071H279.167ZM286.853 201.49C286.853 201.259 286.816 201.054 286.743 200.877C286.675 200.695 286.552 200.531 286.375 200.386C286.202 200.24 285.961 200.102 285.652 199.97C285.348 199.838 284.961 199.704 284.493 199.567C284.002 199.422 283.559 199.261 283.163 199.083C282.768 198.901 282.429 198.695 282.147 198.463C281.865 198.231 281.649 197.965 281.499 197.665C281.349 197.365 281.274 197.022 281.274 196.635C281.274 196.249 281.354 195.892 281.513 195.564C281.672 195.237 281.899 194.953 282.195 194.712C282.495 194.467 282.852 194.276 283.266 194.139C283.679 194.003 284.141 193.935 284.65 193.935C285.395 193.935 286.027 194.078 286.546 194.364C287.068 194.646 287.466 195.017 287.739 195.476C288.012 195.93 288.148 196.417 288.148 196.935H286.839C286.839 196.562 286.759 196.233 286.6 195.946C286.441 195.655 286.2 195.428 285.877 195.264C285.555 195.096 285.145 195.012 284.65 195.012C284.182 195.012 283.795 195.083 283.491 195.224C283.186 195.364 282.959 195.555 282.809 195.796C282.663 196.037 282.59 196.312 282.59 196.621C282.59 196.831 282.634 197.022 282.72 197.194C282.811 197.363 282.95 197.519 283.136 197.665C283.327 197.81 283.568 197.944 283.859 198.067C284.154 198.19 284.507 198.308 284.916 198.422C285.48 198.581 285.966 198.758 286.375 198.954C286.784 199.149 287.121 199.37 287.384 199.615C287.653 199.856 287.85 200.131 287.978 200.44C288.11 200.745 288.175 201.09 288.175 201.477C288.175 201.881 288.094 202.247 287.93 202.575C287.766 202.902 287.532 203.182 287.228 203.414C286.923 203.645 286.557 203.825 286.13 203.952C285.707 204.075 285.234 204.136 284.711 204.136C284.252 204.136 283.8 204.073 283.354 203.945C282.913 203.818 282.511 203.627 282.147 203.373C281.788 203.118 281.499 202.804 281.281 202.432C281.067 202.054 280.961 201.618 280.961 201.122H282.27C282.27 201.463 282.336 201.756 282.468 202.002C282.6 202.243 282.779 202.443 283.006 202.602C283.238 202.761 283.5 202.879 283.791 202.957C284.086 203.029 284.393 203.066 284.711 203.066C285.17 203.066 285.559 203.002 285.877 202.875C286.196 202.748 286.437 202.566 286.6 202.329C286.768 202.093 286.853 201.813 286.853 201.49ZM296.993 194.951L293.706 204H292.363L296.147 194.071H297.013L296.993 194.951ZM299.748 204L296.454 194.951L296.434 194.071H297.3L301.098 204H299.748ZM299.577 200.324V201.402H293.999V200.324H299.577ZM306.09 200.106H303.437V199.036H306.09C306.604 199.036 307.02 198.954 307.338 198.79C307.656 198.626 307.888 198.399 308.033 198.108C308.183 197.817 308.258 197.485 308.258 197.112C308.258 196.771 308.183 196.451 308.033 196.151C307.888 195.851 307.656 195.61 307.338 195.428C307.02 195.242 306.604 195.148 306.09 195.148H303.744V204H302.428V194.071H306.09C306.84 194.071 307.474 194.201 307.992 194.46C308.511 194.719 308.904 195.078 309.172 195.537C309.44 195.992 309.575 196.512 309.575 197.099C309.575 197.735 309.44 198.279 309.172 198.729C308.904 199.179 308.511 199.522 307.992 199.758C307.474 199.99 306.84 200.106 306.09 200.106ZM312.65 194.071V204H311.334V194.071H312.65Z" fill="#2362EA" />
					<path d="M80.74 79.1267H47.1854C45.0469 79.1267 43.3137 77.3991 43.3137 75.2676V28.9595C43.3137 26.828 45.0469 25.1005 47.1854 25.1005H71.7061L84.6117 37.9638V75.2676C84.6117 77.3991 82.8785 79.1267 80.74 79.1267Z" fill="#21A464" />
					<path d="M84.6118 37.9633H71.7062V25.0999L84.6118 37.9633Z" fill="#C8E6C9" />
					<path d="M71.7062 37.965L84.6118 50.8284V37.965H71.7062Z" fill="#1B925A" />
					<path d="M72.9953 50.8246H54.9274H52.3463V53.3972V55.9699V58.5426V61.1153V63.6879V66.2606V68.8333H75.5764V66.2606V63.6879V61.1153V58.5426V55.9699V53.3972V50.8246H72.9953ZM54.9274 53.3972H60.0896V55.9699H54.9274V53.3972ZM54.9274 58.5426H60.0896V61.1153H54.9274V58.5426ZM54.9274 63.6879H60.0896V66.2606H54.9274V63.6879ZM72.9953 66.2606H62.6708V63.6879H72.9953V66.2606ZM72.9953 61.1153H62.6708V58.5426H72.9953V61.1153ZM72.9953 55.9699H62.6708V53.3972H72.9953V55.9699Z" fill="#E8F5E9" />
					<rect x="88.1691" y="180.309" width="109.699" height="37.5892" rx="5.09209" fill="white" stroke="#9F9F9F" stroke-width="1.13157" stroke-dasharray="3.39 3.39" />
					<g filter="url(#filter1_d_779_578)">
						<rect x="66.9694" y="159.244" width="107.874" height="45.152" rx="6.48992" fill="#2362EA" shape-rendering="crispEdges" />
						<path d="M96.7129 186.009V187.926H89.8452V186.009H96.7129ZM90.5905 175.007V187.926H88.1505V175.007H90.5905ZM95.8167 180.339V182.212H89.8452V180.339H95.8167ZM96.6862 175.007V176.932H89.8452V175.007H96.6862ZM108.789 175.007V187.926H106.34L100.848 178.964V187.926H98.4076V175.007H100.848L106.358 183.977V175.007H108.789ZM116.57 176.968L112.888 187.926H110.306L115.133 175.007H116.783L116.57 176.968ZM119.649 187.926L115.949 176.968L115.728 175.007H117.387L122.24 187.926H119.649ZM119.481 183.126V185.051H112.551V183.126H119.481ZM128.522 182.167H125.222L125.204 180.446H128.034C128.519 180.446 128.925 180.378 129.25 180.242C129.575 180.106 129.821 179.908 129.986 179.647C130.158 179.387 130.244 179.071 130.244 178.698C130.244 178.284 130.164 177.947 130.004 177.686C129.85 177.426 129.608 177.237 129.277 177.119C128.945 176.994 128.525 176.932 128.017 176.932H126.011V187.926H123.571V175.007H128.017C128.75 175.007 129.404 175.078 129.977 175.22C130.557 175.356 131.048 175.569 131.45 175.859C131.853 176.149 132.157 176.512 132.364 176.95C132.577 177.388 132.684 177.908 132.684 178.512C132.684 179.044 132.56 179.535 132.311 179.985C132.069 180.428 131.693 180.789 131.184 181.067C130.681 181.345 130.043 181.505 129.268 181.546L128.522 182.167ZM128.416 187.926H124.503L125.523 186.009H128.416C128.901 186.009 129.3 185.929 129.614 185.77C129.933 185.61 130.17 185.391 130.324 185.113C130.483 184.829 130.563 184.504 130.563 184.137C130.563 183.735 130.492 183.386 130.35 183.09C130.214 182.794 129.995 182.567 129.694 182.407C129.398 182.247 129.007 182.167 128.522 182.167H125.985L126.002 180.446H129.232L129.791 181.111C130.536 181.117 131.143 181.265 131.61 181.555C132.083 181.845 132.432 182.218 132.657 182.673C132.882 183.129 132.994 183.62 132.994 184.146C132.994 184.974 132.814 185.669 132.453 186.231C132.098 186.793 131.578 187.216 130.891 187.5C130.211 187.784 129.386 187.926 128.416 187.926ZM143.305 186.009V187.926H136.81V186.009H143.305ZM137.546 175.007V187.926H135.106V175.007H137.546ZM153.5 186.009V187.926H146.632V186.009H153.5ZM147.377 175.007V187.926H144.937V175.007H147.377ZM152.603 180.339V182.212H146.632V180.339H152.603ZM153.473 175.007V176.932H146.632V175.007H153.473Z" fill="#F8F9FA" />
					</g>
					<ellipse cx="164.157" cy="148.994" rx="3.42776" ry="3.41654" fill="#2362EA" />
					<path d="M103.034 153.55C103.034 155.122 101.754 156.401 100.172 156.401C98.5897 156.401 97.3101 155.122 97.3101 153.55C97.3101 151.977 98.5897 150.699 100.172 150.699C101.754 150.699 103.034 151.977 103.034 153.55Z" stroke="#2362EA" stroke-width="1.13157" />
					<ellipse cx="133.307" cy="218.464" rx="3.42776" ry="3.41654" fill="#2362EA" />
					<ellipse cx="71.6067" cy="211.631" rx="2.28518" ry="2.2777" fill="#2362EA" />
					<ellipse cx="59.0382" cy="164.938" rx="2.28518" ry="2.2777" fill="#2362EA" />
					<path d="M189.87 189.992C189.87 190.936 189.102 191.704 188.151 191.704C187.2 191.704 186.432 190.936 186.432 189.992C186.432 189.049 187.2 188.28 188.151 188.28C189.102 188.28 189.87 189.049 189.87 189.992Z" stroke="#2362EA" stroke-width="1.13157" />
					<line x1="0.848681" y1="-0.848681" x2="5.93251" y2="-0.848681" transform="matrix(-0.830894 -0.55643 0.55895 -0.829201 164.31 191.603)" stroke="white" stroke-width="1.69736" stroke-linecap="round" />
					<line x1="167.427" y1="190.569" x2="167.427" y2="186.286" stroke="white" stroke-width="1.69736" stroke-linecap="round" />
					<line x1="0.848681" y1="-0.848681" x2="5.1512" y2="-0.848681" transform="matrix(-0.998018 0.0629309 -0.0633433 -0.997992 163.288 195.84)" stroke="white" stroke-width="1.69736" stroke-linecap="round" />
					<g filter="url(#filter2_d_779_578)">
						<path d="M165.013 194.536L171.252 212.421C171.319 212.612 171.44 212.779 171.602 212.902C171.764 213.024 171.958 213.096 172.161 213.107C172.364 213.119 172.565 213.071 172.74 212.968C172.915 212.866 173.055 212.714 173.143 212.532L176.371 205.871C176.844 204.895 177.686 204.147 178.712 203.791L184.965 201.624C185.166 201.554 185.34 201.424 185.463 201.251C185.586 201.078 185.652 200.871 185.652 200.659C185.652 200.447 185.586 200.24 185.462 200.067C185.339 199.894 185.165 199.763 184.964 199.693L166.316 193.234C166.134 193.171 165.938 193.16 165.75 193.203C165.563 193.246 165.391 193.341 165.255 193.477C165.119 193.613 165.024 193.784 164.982 193.972C164.939 194.159 164.95 194.354 165.013 194.536Z" fill="white" />
						<path d="M165.441 194.388L165.441 194.387C165.406 194.286 165.399 194.177 165.423 194.073C165.447 193.968 165.5 193.873 165.576 193.797C165.652 193.721 165.747 193.668 165.852 193.644C165.957 193.62 166.066 193.626 166.168 193.661L166.168 193.661L184.816 200.12C184.816 200.12 184.816 200.12 184.816 200.12C184.928 200.16 185.025 200.232 185.094 200.328C185.162 200.425 185.199 200.54 185.199 200.658C185.199 200.777 185.163 200.892 185.094 200.988C185.025 201.085 184.928 201.158 184.816 201.197L178.563 203.364L178.563 203.364C177.424 203.759 176.489 204.589 175.964 205.673C175.964 205.673 175.964 205.673 175.964 205.673L172.735 212.334L172.735 212.335C172.686 212.436 172.608 212.521 172.51 212.578C172.412 212.636 172.3 212.663 172.187 212.656C172.074 212.649 171.965 212.609 171.875 212.541C171.785 212.473 171.717 212.38 171.68 212.273L171.68 212.272L165.441 194.388ZM165.013 194.536L171.252 212.421L166.316 193.234C166.134 193.171 165.938 193.16 165.75 193.203C165.563 193.246 165.391 193.341 165.255 193.477C165.119 193.613 165.024 193.784 164.982 193.972C164.939 194.159 164.95 194.354 165.013 194.536Z" stroke="#1A3879" stroke-width="0.90526" />
					</g>
					<defs>
						<filter id="filter0_d_779_578" x="217" y="175.998" width="110" height="48" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
							<feFlood flood-opacity="0" result="BackgroundImageFix" />
							<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha" />
							<feOffset dy="0.997573" />
							<feGaussianBlur stdDeviation="2.5" />
							<feComposite in2="hardAlpha" operator="out" />
							<feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.2 0" />
							<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_779_578" />
							<feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_779_578" result="shape" />
						</filter>
						<filter id="filter1_d_779_578" x="46.601" y="141.139" width="196.137" height="133.415" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
							<feFlood flood-opacity="0" result="BackgroundImageFix" />
							<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha" />
							<feOffset dx="23.7631" dy="26.0262" />
							<feGaussianBlur stdDeviation="22.0657" />
							<feComposite in2="hardAlpha" operator="out" />
							<feColorMatrix type="matrix" values="0 0 0 0 0.137255 0 0 0 0 0.384314 0 0 0 0 0.917647 0 0 0 0.2 0" />
							<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_779_578" />
							<feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_779_578" result="shape" />
						</filter>
						<filter id="filter2_d_779_578" x="155.903" y="185.256" width="38.8014" height="38.0374" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
							<feFlood flood-opacity="0" result="BackgroundImageFix" />
							<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha" />
							<feOffset dy="1.13157" />
							<feGaussianBlur stdDeviation="4.5263" />
							<feComposite in2="hardAlpha" operator="out" />
							<feColorMatrix type="matrix" values="0 0 0 0 0.227778 0 0 0 0 0.366722 0 0 0 0 0.666667 0 0 0 0.15 0" />
							<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_779_578" />
							<feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_779_578" result="shape" />
						</filter>
						<linearGradient id="paint0_linear_779_578" x1="208.078" y1="-102.546" x2="218.122" y2="276.569" gradientUnits="userSpaceOnUse">
							<stop stop-color="#F0F0F0" stop-opacity="0.51" />
							<stop offset="1" stop-color="#F8F8F8" stop-opacity="0.46" />
						</linearGradient>
					</defs>
				</svg>
			</div>
		</div>

		<div class="form-group">
			<label for="enable_google_api"><input type="checkbox" id="enable_google_api" name="enable_google_api" x-model="state.enabled_google_sheet_api"><?php esc_html_e('I’ve enabled Google Sheet API', 'stock-sync-with-google-sheet-for-woocommerce'); ?></label>
		</div>

	</div><!-- /Second Step - Enable Google Sheet API -->

</div><!-- /Set Credential -->
