<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

global $woocommerce_my_account_options; 

$allowed_html = array(
	'a' => array(
		'href' => array(),
	),
);

$current_user = wp_get_current_user();
$textVars = array();
if (( $current_user instanceof WP_User ) ) {
 	$textVars['customerDisplayName'] = $current_user->display_name;
 	$textVars['customerFirstName'] = $current_user->user_firstname;
 	$textVars['customerLastName'] = $current_user->user_lastname;
 	$textVars['customerEmail'] = $current_user->user_email;
 	$textVars['customerUserName'] = $current_user->user_login;
 	$textVars['customerId'] = $current_user->ID;
}

$textVars = apply_filters('woocommerce_my_account_custom_dashboard_text_vars', $textVars, $current_user);


do_action( 'woocommerce_before_my_account' );

if(isset($woocommerce_my_account_options['customDashboardHTML']) && !empty($woocommerce_my_account_options['customDashboardHTML'])) {

	$customDashboardHTML = $woocommerce_my_account_options['customDashboardHTML'];

	if (preg_match_all("/{{(.*?)}}/", $customDashboardHTML, $m)) {
		foreach ($m[1] as $i => $var) {
			if(!isset($textVars[$var])) {
				$textVars[$var] = '';
			}
			$customDashboardHTML = str_replace($m[0][$i], $textVars[$var], $customDashboardHTML);
		}
    }

	echo do_shortcode( wpautop( $customDashboardHTML ) );
}

?>


<?php
	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	// do_action( 'woocommerce_account_dashboard' );

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_after_my_account' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */